<?php include 'header.php'; ?>

<div class="content-wrapper">

  <section class="content-header">
    <h1>
      Transaksi
      <small>Data Transaksi</small>
    </h1>
    <ol class="breadcrumb">
      <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
      <li class="active">Dashboard</li>
    </ol>
  </section>

  <section class="content">
    <div class="row">
      <section class="col-lg-12">
        <div class="box box-info">
          <div class="box-header">
            <div class="btn-group pull-right">            

            <?php 
                if(isset($_GET['alert'])){
                  if($_GET['alert']=='gagal'){
                    ?>
                    <div class="alert alert-warning alert-dismissible">
                      <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                      <h4><i class="icon fa fa-warning"></i> Peringatan !</h4>
                      Ekstensi Tidak Diperbolehkan
                    </div>								
                    <?php
                  }elseif($_GET['alert']=="berhasil"){
                    ?>
                    <div class="alert alert-success alert-dismissible">
                      <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                      <h4><i class="icon fa fa-check"></i> Success</h4>
                      Berhasil Disimpan
                    </div> 								
                    <?php
                  }elseif($_GET['alert']=="berhasilupdate"){
                    ?>
                    <div class="alert alert-success alert-dismissible">
                      <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                      <h4><i class="icon fa fa-check"></i> Success</h4>
                      Berhasil Update
                    </div> 								
                    <?php
                  }
                }
                ?>
          </div>
          <div class="box-body">

            
            <form action="transaksi_act.php" method="post" enctype="multipart/form-data">
              
                  <div class="modal-content">
                    <div class="modal-header">
                      <h4 class="modal-title" id="exampleModalLabel">Tambah Transaksi</h4>
                      <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                    </div>
                    <div class="modal-body">
                    <div class="col-md-12">
                      <div class="form-group">
                        <label>Tanggal</label>
                        <input type="text" name="tanggal" required="required" class="form-control datepicker2">
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Jenis</label>
                        <select name="jenis" class="form-control" required="required">
                          <option value="">- Pilih -</option>
                          <option value="Pemasukan">Pemasukan</option>
                          <option value="Pengeluaran">Pengeluaran</option>
                        </select>
                      </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Kategori Akun</label>
                          <select class="form-control" name="kategori" id="kategori">
                            <option value=""> Pilih Kategori</option>
                          </select>
                        </div>
                      </div>
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Akun</label>                            
                          <button type="button" class="btn btn-info btn-sm" onclick="form_modal_add()">
                            <i class="fa fa-plus"></i> &nbsp Tambah Akun
                          </button> 
                          <select class="form-control" name="rekening" id="rekening">
                            <option value=""></option> 
                          </select> 
                           
                        </div>
                      </div>
                      
                      <div class="col-md-2">
                        <div class="form-group">
                          <label>Sumber (Pengeluaran)</label>
                          <select name="jenisakun" class="form-control" required="required">
                            <option value="">- Pilih -</option>
                            <option value="SY-001">Syahriyah</option>
                            <option value="DU-001">DU-Dapur</option>
                            <option value="DU-002">DU-Ospia</option>
                            <option value="DU-003">DU-UKP</option>
                            <option value="DU-004">DU-Seragam</option>
                            <option value="DU-005">DU-Buku</option>
                            <option value="DU-006">DU-Ujian</option>
                            <option value="DU-007">DU-Wakaf-Perlengkapan</option>
                          </select>
                        </div>
                      </div>

                      <div class="col-md-2">
                      <div class="form-group">
                        <label>Tahun (Daftar Ulang)</label>
                        <select name="tajaran" class="form-control" required="required">
                          <option value="">- Pilih -</option>
                          <?php 
                          $tajar = mysqli_query($koneksi,"SELECT * FROM th_ajaran");
                          while($ta = mysqli_fetch_array($tajar)){
                            ?>
                            <option value="<?php echo $ta['tahun']; ?>"><?php echo $ta['tahun']; ?></option>
                            <?php 
                          }
                          ?>
                        </select>
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Nominal</label>
                        <input type="text" id="rupiah1" name="nominal" required="required" class="form-control" placeholder="Masukkan Nominal ..">
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Keterangan</label>
                        <textarea name="keterangan" class="form-control" rows="3"></textarea>
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Upload File</label>
                        <input type="file" name="trnfoto" class="form-control">
                        <small>File yang di perbolehkan *PDF | *JPG | *jpeg </small>
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Rekening Bank</label>
                        <select name="bank" class="form-control" required="required">
                          <option value="">- Pilih -</option>
                          <?php 
                          $bank = mysqli_query($koneksi,"SELECT * FROM bank");
                          while($b = mysqli_fetch_array($bank)){
                            ?>
                            <option value="<?php echo $b['bank_id']; ?>"><?php echo $b['bank_nama']; ?></option>
                            <?php 
                          }
                          ?>
                        </select>
                      </div>
                      </div>
                      <div class="col-md-12">
                      <div class="form-group">
                        <label>Tahun Ajaran</label>
                        <select name="tajaran" class="form-control" required="required">
                          <option value="">- Pilih -</option>
                          <?php 
                          $tajar = mysqli_query($koneksi,"SELECT * FROM th_ajaran");
                          while($ta = mysqli_fetch_array($tajar)){
                            ?>
                            <option value="<?php echo $ta['tahun']; ?>"><?php echo $ta['tahun']; ?></option>
                            <?php 
                          }
                          ?>
                        </select>
                      </div>
                      </div>

                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-dismiss="modal">Tutup</button>
                      <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                  </div>
                </div>
              </div>
            </form>


            
            </div>
          </div>
          <div class="modal" id="modal_tambah_rekening" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title">Tambah Rekening</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <p>Kategori</p>
                  <input type="text" id="kategori_modal" class="form-control mb-2" readonly>
                  <p>Nama Rekening</p>
                  <input type="text" id="rekening_modal" class="form-control mb-2" placeholder="Masukkan nama rekening">
                  <p>Sub Rekening</p>
                  <select id="sub_rekening_modal" class="form-control">
                    <option>DEBET</option>
                    <option>KREDIT</option>
                  </select>
                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-primary" id="btn-save">Save changes</button>
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                </div>
              </div>
            </div>
          </div>

        </div>
      </section>
    </div>
  </section>

</div>
<?php include 'footer.php'; ?>
<script>
  function form_modal_add(){
    var kategori = $("#kategori").val();
    if(!kategori){//JIKA KATEGORI BELUM DIPILIH
      swal.fire("Warning","Anda belum memilih kategori","warning");
    }else{
      $("#modal_tambah_rekening").modal("show");
      $("#kategori_modal").val($("#kategori").find(":selected").text());
    }
  }

  function get_rekening(){
      var kategori = $("#kategori").val();
      $.ajax({
        type: 'POST',
          url: "get_rekening.php",
          data: {kategori: kategori},
          cache: false,
          success: function(msg){
            $("#rekening").html(msg);
          }
      });
    }

  function tambah_rekening() {
    var kategori = $("#kategori").val();
    var rekening = $("#rekening_modal").val();
    var sub_rekening = $("#sub_rekening_modal").val();
    $.ajax({
      type:"post",
      url:"add_rekening.php",
      data:{
        kategori:kategori,
        rekening:rekening,
        sub_rekening:sub_rekening,
      },
      dataType:"JSON",
      beforeSend:function(){
        $("#btn-save").html("Sedang Menyimpan...");
        $("#btn-save").attr("disabled",true);
      },
      success:function(r){
        d = JSON.parse(JSON.stringify(r));
        swal.fire({
          title:d.title,
          html:d.pesan,
          icon:d.icon,
        });

        if(d.icon == "success"){
          $("#modal_tambah_rekening").modal("hide");
          $("#rekening_modal").val("");
          $("#sub_rekening_modal").val("DEBET");
          get_rekening();
        }
        $("#btn-save").html("Simpan");
        $("#btn-save").attr("disabled",false);
      },
      error:function(a,b,c){
        swal.fire("Error",a.responseText,"error");
        $("#btn-save").html("Simpan");
        $("#btn-save").attr("disabled",false);
      }
    })
    }

  $("#btn-save").click(function() {
    tambah_rekening();
  })
</script>