-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.1.38-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for keuangan2
DROP DATABASE IF EXISTS `keuangan2`;
CREATE DATABASE IF NOT EXISTS `keuangan2` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `keuangan2`;

-- Dumping structure for table keuangan2.bank
DROP TABLE IF EXISTS `bank`;
CREATE TABLE IF NOT EXISTS `bank` (
  `bank_id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_nama` varchar(255) NOT NULL,
  `bank_nomor` varchar(255) NOT NULL,
  `bank_pemilik` varchar(255) NOT NULL,
  `bank_saldo` bigint(20) NOT NULL,
  PRIMARY KEY (`bank_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table keuangan2.bank: ~1 rows (approximately)
INSERT INTO `bank` (`bank_id`, `bank_nama`, `bank_nomor`, `bank_pemilik`, `bank_saldo`) VALUES
	(1, 'BNI', 'PPIA', '00899000', 18899689);

-- Dumping structure for table keuangan2.hutang
DROP TABLE IF EXISTS `hutang`;
CREATE TABLE IF NOT EXISTS `hutang` (
  `hutang_id` int(11) NOT NULL AUTO_INCREMENT,
  `hutang_tanggal` date NOT NULL,
  `hutang_nominal` int(11) NOT NULL,
  `hutang_keterangan` text NOT NULL,
  PRIMARY KEY (`hutang_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- Dumping data for table keuangan2.hutang: ~1 rows (approximately)
INSERT INTO `hutang` (`hutang_id`, `hutang_tanggal`, `hutang_nominal`, `hutang_keterangan`) VALUES
	(1, '2022-12-05', 100, 'Nugroho');

-- Dumping structure for table keuangan2.kabupaten
DROP TABLE IF EXISTS `kabupaten`;
CREATE TABLE IF NOT EXISTS `kabupaten` (
  `id_kab` char(4) NOT NULL,
  `id_prov` char(2) NOT NULL,
  `nama` tinytext NOT NULL,
  `id_jenis` int(11) NOT NULL,
  PRIMARY KEY (`id_kab`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table keuangan2.kabupaten: ~514 rows (approximately)
INSERT INTO `kabupaten` (`id_kab`, `id_prov`, `nama`, `id_jenis`) VALUES
	('1101', '11', 'KAB. ACEH SELATAN', 1),
	('1102', '11', 'KAB. ACEH TENGGARA', 1),
	('1103', '11', 'KAB. ACEH TIMUR', 1),
	('1104', '11', 'KAB. ACEH TENGAH', 1),
	('1105', '11', 'KAB. ACEH BARAT', 1),
	('1106', '11', 'KAB. ACEH BESAR', 1),
	('1107', '11', 'KAB. PIDIE', 1),
	('1108', '11', 'KAB. ACEH UTARA', 1),
	('1109', '11', 'KAB. SIMEULUE', 1),
	('1110', '11', 'KAB. ACEH SINGKIL', 1),
	('1111', '11', 'KAB. BIREUEN', 1),
	('1112', '11', 'KAB. ACEH BARAT DAYA', 1),
	('1113', '11', 'KAB. GAYO LUES', 1),
	('1114', '11', 'KAB. ACEH JAYA', 1),
	('1115', '11', 'KAB. NAGAN RAYA', 1),
	('1116', '11', 'KAB. ACEH TAMIANG', 1),
	('1117', '11', 'KAB. BENER MERIAH', 1),
	('1118', '11', 'KAB. PIDIE JAYA', 1),
	('1171', '11', 'KOTA BANDA ACEH', 2),
	('1172', '11', 'KOTA SABANG', 2),
	('1173', '11', 'KOTA LHOKSEUMAWE', 2),
	('1174', '11', 'KOTA LANGSA', 2),
	('1175', '11', 'KOTA SUBULUSSALAM', 2),
	('1201', '12', 'KAB. TAPANULI TENGAH', 1),
	('1202', '12', 'KAB. TAPANULI UTARA', 1),
	('1203', '12', 'KAB. TAPANULI SELATAN', 1),
	('1204', '12', 'KAB. NIAS', 1),
	('1205', '12', 'KAB. LANGKAT', 1),
	('1206', '12', 'KAB. KARO', 1),
	('1207', '12', 'KAB. DELI SERDANG', 1),
	('1208', '12', 'KAB. SIMALUNGUN', 1),
	('1209', '12', 'KAB. ASAHAN', 1),
	('1210', '12', 'KAB. LABUHANBATU', 1),
	('1211', '12', 'KAB. DAIRI', 1),
	('1212', '12', 'KAB. TOBA SAMOSIR', 1),
	('1213', '12', 'KAB. MANDAILING NATAL', 1),
	('1214', '12', 'KAB. NIAS SELATAN', 1),
	('1215', '12', 'KAB. PAKPAK BHARAT', 1),
	('1216', '12', 'KAB. HUMBANG HASUNDUTAN', 1),
	('1217', '12', 'KAB. SAMOSIR', 1),
	('1218', '12', 'KAB. SERDANG BEDAGAI', 1),
	('1219', '12', 'KAB. BATU BARA', 1),
	('1220', '12', 'KAB. PADANG LAWAS UTARA', 1),
	('1221', '12', 'KAB. PADANG LAWAS', 1),
	('1222', '12', 'KAB. LABUHANBATU SELATAN', 1),
	('1223', '12', 'KAB. LABUHANBATU UTARA', 1),
	('1224', '12', 'KAB. NIAS UTARA', 1),
	('1225', '12', 'KAB. NIAS BARAT', 1),
	('1271', '12', 'KOTA MEDAN', 2),
	('1272', '12', 'KOTA PEMATANG SIANTAR', 2),
	('1273', '12', 'KOTA SIBOLGA', 2),
	('1274', '12', 'KOTA TANJUNG BALAI', 2),
	('1275', '12', 'KOTA BINJAI', 2),
	('1276', '12', 'KOTA TEBING TINGGI', 2),
	('1277', '12', 'KOTA PADANGSIDIMPUAN', 2),
	('1278', '12', 'KOTA GUNUNGSITOLI', 2),
	('1301', '13', 'KAB. PESISIR SELATAN', 1),
	('1302', '13', 'KAB. SOLOK', 1),
	('1303', '13', 'KAB. SIJUNJUNG', 1),
	('1304', '13', 'KAB. TANAH DATAR', 1),
	('1305', '13', 'KAB. PADANG PARIAMAN', 1),
	('1306', '13', 'KAB. AGAM', 1),
	('1307', '13', 'KAB. LIMA PULUH KOTA', 1),
	('1308', '13', 'KAB. PASAMAN', 1),
	('1309', '13', 'KAB. KEPULAUAN MENTAWAI', 1),
	('1310', '13', 'KAB. DHARMASRAYA', 1),
	('1311', '13', 'KAB. SOLOK SELATAN', 1),
	('1312', '13', 'KAB. PASAMAN BARAT', 1),
	('1371', '13', 'KOTA PADANG', 2),
	('1372', '13', 'KOTA SOLOK', 2),
	('1373', '13', 'KOTA SAWAHLUNTO', 2),
	('1374', '13', 'KOTA PADANG PANJANG', 2),
	('1375', '13', 'KOTA BUKITTINGGI', 2),
	('1376', '13', 'KOTA PAYAKUMBUH', 2),
	('1377', '13', 'KOTA PARIAMAN', 2),
	('1401', '14', 'KAB. KAMPAR', 1),
	('1402', '14', 'KAB. INDRAGIRI HULU', 1),
	('1403', '14', 'KAB. BENGKALIS', 1),
	('1404', '14', 'KAB. INDRAGIRI HILIR', 1),
	('1405', '14', 'KAB. PELALAWAN', 1),
	('1406', '14', 'KAB. ROKAN HULU', 1),
	('1407', '14', 'KAB. ROKAN HILIR', 1),
	('1408', '14', 'KAB. SIAK', 1),
	('1409', '14', 'KAB. KUANTAN SINGINGI', 1),
	('1410', '14', 'KAB. KEPULAUAN MERANTI', 1),
	('1471', '14', 'KOTA PEKANBARU', 2),
	('1472', '14', 'KOTA DUMAI', 2),
	('1501', '15', 'KAB. KERINCI', 1),
	('1502', '15', 'KAB. MERANGIN', 1),
	('1503', '15', 'KAB. SAROLANGUN', 1),
	('1504', '15', 'KAB. BATANGHARI', 1),
	('1505', '15', 'KAB. MUARO JAMBI', 1),
	('1506', '15', 'KAB. TANJUNG JABUNG BARAT', 1),
	('1507', '15', 'KAB. TANJUNG JABUNG TIMUR', 1),
	('1508', '15', 'KAB. BUNGO', 1),
	('1509', '15', 'KAB. TEBO', 1),
	('1571', '15', 'KOTA JAMBI', 2),
	('1572', '15', 'KOTA SUNGAI PENUH', 2),
	('1601', '16', 'KAB. OGAN KOMERING ULU', 1),
	('1602', '16', 'KAB. OGAN KOMERING ILIR', 1),
	('1603', '16', 'KAB. MUARA ENIM', 1),
	('1604', '16', 'KAB. LAHAT', 1),
	('1605', '16', 'KAB. MUSI RAWAS', 1),
	('1606', '16', 'KAB. MUSI BANYUASIN', 1),
	('1607', '16', 'KAB. BANYUASIN', 1),
	('1608', '16', 'KAB. OGAN KOMERING ULU TIMUR', 1),
	('1609', '16', 'KAB. OGAN KOMERING ULU SELATAN', 1),
	('1610', '16', 'KAB. OGAN ILIR', 1),
	('1611', '16', 'KAB. EMPAT LAWANG', 1),
	('1612', '16', 'KAB. PENUKAL ABAB LEMATANG ILIR', 1),
	('1613', '16', 'KAB. MUSI RAWAS UTARA', 1),
	('1671', '16', 'KOTA PALEMBANG', 2),
	('1672', '16', 'KOTA PAGAR ALAM', 2),
	('1673', '16', 'KOTA LUBUK LINGGAU', 2),
	('1674', '16', 'KOTA PRABUMULIH', 2),
	('1701', '17', 'KAB. BENGKULU SELATAN', 1),
	('1702', '17', 'KAB. REJANG LEBONG', 1),
	('1703', '17', 'KAB. BENGKULU UTARA', 1),
	('1704', '17', 'KAB. KAUR', 1),
	('1705', '17', 'KAB. SELUMA', 1),
	('1706', '17', 'KAB. MUKO MUKO', 1),
	('1707', '17', 'KAB. LEBONG', 1),
	('1708', '17', 'KAB. KEPAHIANG', 1),
	('1709', '17', 'KAB. BENGKULU TENGAH', 1),
	('1771', '17', 'KOTA BENGKULU', 2),
	('1801', '18', 'KAB. LAMPUNG SELATAN', 1),
	('1802', '18', 'KAB. LAMPUNG TENGAH', 1),
	('1803', '18', 'KAB. LAMPUNG UTARA', 1),
	('1804', '18', 'KAB. LAMPUNG BARAT', 1),
	('1805', '18', 'KAB. TULANG BAWANG', 1),
	('1806', '18', 'KAB. TANGGAMUS', 1),
	('1807', '18', 'KAB. LAMPUNG TIMUR', 1),
	('1808', '18', 'KAB. WAY KANAN', 1),
	('1809', '18', 'KAB. PESAWARAN', 1),
	('1810', '18', 'KAB. PRINGSEWU', 1),
	('1811', '18', 'KAB. MESUJI', 1),
	('1812', '18', 'KAB. TULANG BAWANG BARAT', 1),
	('1813', '18', 'KAB. PESISIR BARAT', 1),
	('1871', '18', 'KOTA BANDAR LAMPUNG', 2),
	('1872', '18', 'KOTA METRO', 2),
	('1901', '19', 'KAB. BANGKA', 1),
	('1902', '19', 'KAB. BELITUNG', 1),
	('1903', '19', 'KAB. BANGKA SELATAN', 1),
	('1904', '19', 'KAB. BANGKA TENGAH', 1),
	('1905', '19', 'KAB. BANGKA BARAT', 1),
	('1906', '19', 'KAB. BELITUNG TIMUR', 1),
	('1971', '19', 'KOTA PANGKAL PINANG', 2),
	('2101', '21', 'KAB. BINTAN', 1),
	('2102', '21', 'KAB. KARIMUN', 1),
	('2103', '21', 'KAB. NATUNA', 1),
	('2104', '21', 'KAB. LINGGA', 1),
	('2105', '21', 'KAB. KEPULAUAN ANAMBAS', 1),
	('2171', '21', 'KOTA BATAM', 2),
	('2172', '21', 'KOTA TANJUNG PINANG', 2),
	('3101', '31', 'KAB. ADM. KEP. SERIBU', 1),
	('3171', '31', 'KOTA ADM. JAKARTA PUSAT', 2),
	('3172', '31', 'KOTA ADM. JAKARTA UTARA', 2),
	('3173', '31', 'KOTA ADM. JAKARTA BARAT', 2),
	('3174', '31', 'KOTA ADM. JAKARTA SELATAN', 2),
	('3175', '31', 'KOTA ADM. JAKARTA TIMUR', 2),
	('3201', '32', 'KAB. BOGOR', 1),
	('3202', '32', 'KAB. SUKABUMI', 1),
	('3203', '32', 'KAB. CIANJUR', 1),
	('3204', '32', 'KAB. BANDUNG', 1),
	('3205', '32', 'KAB. GARUT', 1),
	('3206', '32', 'KAB. TASIKMALAYA', 1),
	('3207', '32', 'KAB. CIAMIS', 1),
	('3208', '32', 'KAB. KUNINGAN', 1),
	('3209', '32', 'KAB. CIREBON', 1),
	('3210', '32', 'KAB. MAJALENGKA', 1),
	('3211', '32', 'KAB. SUMEDANG', 1),
	('3212', '32', 'KAB. INDRAMAYU', 1),
	('3213', '32', 'KAB. SUBANG', 1),
	('3214', '32', 'KAB. PURWAKARTA', 1),
	('3215', '32', 'KAB. KARAWANG', 1),
	('3216', '32', 'KAB. BEKASI', 1),
	('3217', '32', 'KAB. BANDUNG BARAT', 1),
	('3218', '32', 'KAB. PANGANDARAN', 1),
	('3271', '32', 'KOTA BOGOR', 2),
	('3272', '32', 'KOTA SUKABUMI', 2),
	('3273', '32', 'KOTA BANDUNG', 2),
	('3274', '32', 'KOTA CIREBON', 2),
	('3275', '32', 'KOTA BEKASI', 2),
	('3276', '32', 'KOTA DEPOK', 2),
	('3277', '32', 'KOTA CIMAHI', 2),
	('3278', '32', 'KOTA TASIKMALAYA', 2),
	('3279', '32', 'KOTA BANJAR', 2),
	('3301', '33', 'KAB. CILACAP', 1),
	('3302', '33', 'KAB. BANYUMAS', 1),
	('3303', '33', 'KAB. PURBALINGGA', 1),
	('3304', '33', 'KAB. BANJARNEGARA', 1),
	('3305', '33', 'KAB. KEBUMEN', 1),
	('3306', '33', 'KAB. PURWOREJO', 1),
	('3307', '33', 'KAB. WONOSOBO', 1),
	('3308', '33', 'KAB. MAGELANG', 1),
	('3309', '33', 'KAB. BOYOLALI', 1),
	('3310', '33', 'KAB. KLATEN', 1),
	('3311', '33', 'KAB. SUKOHARJO', 1),
	('3312', '33', 'KAB. WONOGIRI', 1),
	('3313', '33', 'KAB. KARANGANYAR', 1),
	('3314', '33', 'KAB. SRAGEN', 1),
	('3315', '33', 'KAB. GROBOGAN', 1),
	('3316', '33', 'KAB. BLORA', 1),
	('3317', '33', 'KAB. REMBANG', 1),
	('3318', '33', 'KAB. PATI', 1),
	('3319', '33', 'KAB. KUDUS', 1),
	('3320', '33', 'KAB. JEPARA', 1),
	('3321', '33', 'KAB. DEMAK', 1),
	('3322', '33', 'KAB. SEMARANG', 1),
	('3323', '33', 'KAB. TEMANGGUNG', 1),
	('3324', '33', 'KAB. KENDAL', 1),
	('3325', '33', 'KAB. BATANG', 1),
	('3326', '33', 'KAB. PEKALONGAN', 1),
	('3327', '33', 'KAB. PEMALANG', 1),
	('3328', '33', 'KAB. TEGAL', 1),
	('3329', '33', 'KAB. BREBES', 1),
	('3371', '33', 'KOTA MAGELANG', 2),
	('3372', '33', 'KOTA SURAKARTA', 2),
	('3373', '33', 'KOTA SALATIGA', 2),
	('3374', '33', 'KOTA SEMARANG', 2),
	('3375', '33', 'KOTA PEKALONGAN', 2),
	('3376', '33', 'KOTA TEGAL', 2),
	('3401', '34', 'KAB. KULON PROGO', 1),
	('3402', '34', 'KAB. BANTUL', 1),
	('3403', '34', 'KAB. GUNUNG KIDUL', 1),
	('3404', '34', 'KAB. SLEMAN', 1),
	('3471', '34', 'KOTA YOGYAKARTA', 2),
	('3501', '35', 'KAB. PACITAN', 1),
	('3502', '35', 'KAB. PONOROGO', 1),
	('3503', '35', 'KAB. TRENGGALEK', 1),
	('3504', '35', 'KAB. TULUNGAGUNG', 1),
	('3505', '35', 'KAB. BLITAR', 1),
	('3506', '35', 'KAB. KEDIRI', 1),
	('3507', '35', 'KAB. MALANG', 1),
	('3508', '35', 'KAB. LUMAJANG', 1),
	('3509', '35', 'KAB. JEMBER', 1),
	('3510', '35', 'KAB. BANYUWANGI', 1),
	('3511', '35', 'KAB. BONDOWOSO', 1),
	('3512', '35', 'KAB. SITUBONDO', 1),
	('3513', '35', 'KAB. PROBOLINGGO', 1),
	('3514', '35', 'KAB. PASURUAN', 1),
	('3515', '35', 'KAB. SIDOARJO', 1),
	('3516', '35', 'KAB. MOJOKERTO', 1),
	('3517', '35', 'KAB. JOMBANG', 1),
	('3518', '35', 'KAB. NGANJUK', 1),
	('3519', '35', 'KAB. MADIUN', 1),
	('3520', '35', 'KAB. MAGETAN', 1),
	('3521', '35', 'KAB. NGAWI', 1),
	('3522', '35', 'KAB. BOJONEGORO', 1),
	('3523', '35', 'KAB. TUBAN', 1),
	('3524', '35', 'KAB. LAMONGAN', 1),
	('3525', '35', 'KAB. GRESIK', 1),
	('3526', '35', 'KAB. BANGKALAN', 1),
	('3527', '35', 'KAB. SAMPANG', 1),
	('3528', '35', 'KAB. PAMEKASAN', 1),
	('3529', '35', 'KAB. SUMENEP', 1),
	('3571', '35', 'KOTA KEDIRI', 2),
	('3572', '35', 'KOTA BLITAR', 2),
	('3573', '35', 'KOTA MALANG', 2),
	('3574', '35', 'KOTA PROBOLINGGO', 2),
	('3575', '35', 'KOTA PASURUAN', 2),
	('3576', '35', 'KOTA MOJOKERTO', 2),
	('3577', '35', 'KOTA MADIUN', 2),
	('3578', '35', 'KOTA SURABAYA', 2),
	('3579', '35', 'KOTA BATU', 2),
	('3601', '36', 'KAB. PANDEGLANG', 1),
	('3602', '36', 'KAB. LEBAK', 1),
	('3603', '36', 'KAB. TANGERANG', 1),
	('3604', '36', 'KAB. SERANG', 1),
	('3671', '36', 'KOTA TANGERANG', 2),
	('3672', '36', 'KOTA CILEGON', 2),
	('3673', '36', 'KOTA SERANG', 2),
	('3674', '36', 'KOTA TANGERANG SELATAN', 2),
	('5101', '51', 'KAB. JEMBRANA', 1),
	('5102', '51', 'KAB. TABANAN', 1),
	('5103', '51', 'KAB. BADUNG', 1),
	('5104', '51', 'KAB. GIANYAR', 1),
	('5105', '51', 'KAB. KLUNGKUNG', 1),
	('5106', '51', 'KAB. BANGLI', 1),
	('5107', '51', 'KAB. KARANGASEM', 1),
	('5108', '51', 'KAB. BULELENG', 1),
	('5171', '51', 'KOTA DENPASAR', 2),
	('5201', '52', 'KAB. LOMBOK BARAT', 1),
	('5202', '52', 'KAB. LOMBOK TENGAH', 1),
	('5203', '52', 'KAB. LOMBOK TIMUR', 1),
	('5204', '52', 'KAB. SUMBAWA', 1),
	('5205', '52', 'KAB. DOMPU', 1),
	('5206', '52', 'KAB. BIMA', 1),
	('5207', '52', 'KAB. SUMBAWA BARAT', 1),
	('5208', '52', 'KAB. LOMBOK UTARA', 1),
	('5271', '52', 'KOTA MATARAM', 2),
	('5272', '52', 'KOTA BIMA', 2),
	('5301', '53', 'KAB. KUPANG', 1),
	('5302', '53', 'KAB TIMOR TENGAH SELATAN', 1),
	('5303', '53', 'KAB. TIMOR TENGAH UTARA', 1),
	('5304', '53', 'KAB. BELU', 1),
	('5305', '53', 'KAB. ALOR', 1),
	('5306', '53', 'KAB. FLORES TIMUR', 1),
	('5307', '53', 'KAB. SIKKA', 1),
	('5308', '53', 'KAB. ENDE', 1),
	('5309', '53', 'KAB. NGADA', 1),
	('5310', '53', 'KAB. MANGGARAI', 1),
	('5311', '53', 'KAB. SUMBA TIMUR', 1),
	('5312', '53', 'KAB. SUMBA BARAT', 1),
	('5313', '53', 'KAB. LEMBATA', 1),
	('5314', '53', 'KAB. ROTE NDAO', 1),
	('5315', '53', 'KAB. MANGGARAI BARAT', 1),
	('5316', '53', 'KAB. NAGEKEO', 1),
	('5317', '53', 'KAB. SUMBA TENGAH', 1),
	('5318', '53', 'KAB. SUMBA BARAT DAYA', 1),
	('5319', '53', 'KAB. MANGGARAI TIMUR', 1),
	('5320', '53', 'KAB. SABU RAIJUA', 1),
	('5321', '53', 'KAB. MALAKA', 1),
	('5371', '53', 'KOTA KUPANG', 2),
	('6101', '61', 'KAB. SAMBAS', 1),
	('6102', '61', 'KAB. MEMPAWAH', 1),
	('6103', '61', 'KAB. SANGGAU', 1),
	('6104', '61', 'KAB. KETAPANG', 1),
	('6105', '61', 'KAB. SINTANG', 1),
	('6106', '61', 'KAB. KAPUAS HULU', 1),
	('6107', '61', 'KAB. BENGKAYANG', 1),
	('6108', '61', 'KAB. LANDAK', 1),
	('6109', '61', 'KAB. SEKADAU', 1),
	('6110', '61', 'KAB. MELAWI', 1),
	('6111', '61', 'KAB. KAYONG UTARA', 1),
	('6112', '61', 'KAB. KUBU RAYA', 1),
	('6171', '61', 'KOTA PONTIANAK', 2),
	('6172', '61', 'KOTA SINGKAWANG', 2),
	('6201', '62', 'KAB. KOTAWARINGIN BARAT', 1),
	('6202', '62', 'KAB. KOTAWARINGIN TIMUR', 1),
	('6203', '62', 'KAB. KAPUAS', 1),
	('6204', '62', 'KAB. BARITO SELATAN', 1),
	('6205', '62', 'KAB. BARITO UTARA', 1),
	('6206', '62', 'KAB. KATINGAN', 1),
	('6207', '62', 'KAB. SERUYAN', 1),
	('6208', '62', 'KAB. SUKAMARA', 1),
	('6209', '62', 'KAB. LAMANDAU', 1),
	('6210', '62', 'KAB. GUNUNG MAS', 1),
	('6211', '62', 'KAB. PULANG PISAU', 1),
	('6212', '62', 'KAB. MURUNG RAYA', 1),
	('6213', '62', 'KAB. BARITO TIMUR', 1),
	('6271', '62', 'KOTA PALANGKARAYA', 2),
	('6301', '63', 'KAB. TANAH LAUT', 1),
	('6302', '63', 'KAB. KOTABARU', 1),
	('6303', '63', 'KAB. BANJAR', 1),
	('6304', '63', 'KAB. BARITO KUALA', 1),
	('6305', '63', 'KAB. TAPIN', 1),
	('6306', '63', 'KAB. HULU SUNGAI SELATAN', 1),
	('6307', '63', 'KAB. HULU SUNGAI TENGAH', 1),
	('6308', '63', 'KAB. HULU SUNGAI UTARA', 1),
	('6309', '63', 'KAB. TABALONG', 1),
	('6310', '63', 'KAB. TANAH BUMBU', 1),
	('6311', '63', 'KAB. BALANGAN', 1),
	('6371', '63', 'KOTA BANJARMASIN', 2),
	('6372', '63', 'KOTA BANJARBARU', 2),
	('6401', '64', 'KAB. PASER', 1),
	('6402', '64', 'KAB. KUTAI KARTANEGARA', 1),
	('6403', '64', 'KAB. BERAU', 1),
	('6407', '64', 'KAB. KUTAI BARAT', 1),
	('6408', '64', 'KAB. KUTAI TIMUR', 1),
	('6409', '64', 'KAB. PENAJAM PASER UTARA', 1),
	('6411', '64', 'KAB. MAHAKAM ULU', 1),
	('6471', '64', 'KOTA BALIKPAPAN', 2),
	('6472', '64', 'KOTA SAMARINDA', 2),
	('6474', '64', 'KOTA BONTANG', 2),
	('6501', '65', 'KAB. BULUNGAN', 1),
	('6502', '65', 'KAB. MALINAU', 1),
	('6503', '65', 'KAB. NUNUKAN', 1),
	('6504', '65', 'KAB. TANA TIDUNG', 1),
	('6571', '65', 'KOTA TARAKAN', 2),
	('7101', '71', 'KAB. BOLAANG MONGONDOW', 1),
	('7102', '71', 'KAB. MINAHASA', 1),
	('7103', '71', 'KAB. KEPULAUAN SANGIHE', 1),
	('7104', '71', 'KAB. KEPULAUAN TALAUD', 1),
	('7105', '71', 'KAB. MINAHASA SELATAN', 1),
	('7106', '71', 'KAB. MINAHASA UTARA', 1),
	('7107', '71', 'KAB. MINAHASA TENGGARA', 1),
	('7108', '71', 'KAB. BOLAANG MONGONDOW UTARA', 1),
	('7109', '71', 'KAB. KEP. SIAU TAGULANDANG BIARO', 1),
	('7110', '71', 'KAB. BOLAANG MONGONDOW TIMUR', 1),
	('7111', '71', 'KAB. BOLAANG MONGONDOW SELATAN', 1),
	('7171', '71', 'KOTA MANADO', 2),
	('7172', '71', 'KOTA BITUNG', 2),
	('7173', '71', 'KOTA TOMOHON', 2),
	('7174', '71', 'KOTA KOTAMOBAGU', 2),
	('7201', '72', 'KAB. BANGGAI', 1),
	('7202', '72', 'KAB. POSO', 1),
	('7203', '72', 'KAB. DONGGALA', 1),
	('7204', '72', 'KAB. TOLI TOLI', 1),
	('7205', '72', 'KAB. BUOL', 1),
	('7206', '72', 'KAB. MOROWALI', 1),
	('7207', '72', 'KAB. BANGGAI KEPULAUAN', 1),
	('7208', '72', 'KAB. PARIGI MOUTONG', 1),
	('7209', '72', 'KAB. TOJO UNA UNA', 1),
	('7210', '72', 'KAB. SIGI', 1),
	('7211', '72', 'KAB. BANGGAI LAUT', 1),
	('7212', '72', 'KAB. MOROWALI UTARA', 1),
	('7271', '72', 'KOTA PALU', 2),
	('7301', '73', 'KAB. KEPULAUAN SELAYAR', 1),
	('7302', '73', 'KAB. BULUKUMBA', 1),
	('7303', '73', 'KAB. BANTAENG', 1),
	('7304', '73', 'KAB. JENEPONTO', 1),
	('7305', '73', 'KAB. TAKALAR', 1),
	('7306', '73', 'KAB. GOWA', 1),
	('7307', '73', 'KAB. SINJAI', 1),
	('7308', '73', 'KAB. BONE', 1),
	('7309', '73', 'KAB. MAROS', 1),
	('7310', '73', 'KAB. PANGKAJENE KEPULAUAN', 1),
	('7311', '73', 'KAB. BARRU', 1),
	('7312', '73', 'KAB. SOPPENG', 1),
	('7313', '73', 'KAB. WAJO', 1),
	('7314', '73', 'KAB. SIDENRENG RAPPANG', 1),
	('7315', '73', 'KAB. PINRANG', 1),
	('7316', '73', 'KAB. ENREKANG', 1),
	('7317', '73', 'KAB. LUWU', 1),
	('7318', '73', 'KAB. TANA TORAJA', 1),
	('7322', '73', 'KAB. LUWU UTARA', 1),
	('7324', '73', 'KAB. LUWU TIMUR', 1),
	('7326', '73', 'KAB. TORAJA UTARA', 1),
	('7371', '73', 'KOTA MAKASSAR', 2),
	('7372', '73', 'KOTA PARE PARE', 2),
	('7373', '73', 'KOTA PALOPO', 2),
	('7401', '74', 'KAB. KOLAKA', 1),
	('7402', '74', 'KAB. KONAWE', 1),
	('7403', '74', 'KAB. MUNA', 1),
	('7404', '74', 'KAB. BUTON', 1),
	('7405', '74', 'KAB. KONAWE SELATAN', 1),
	('7406', '74', 'KAB. BOMBANA', 1),
	('7407', '74', 'KAB. WAKATOBI', 1),
	('7408', '74', 'KAB. KOLAKA UTARA', 1),
	('7409', '74', 'KAB. KONAWE UTARA', 1),
	('7410', '74', 'KAB. BUTON UTARA', 1),
	('7411', '74', 'KAB. KOLAKA TIMUR', 1),
	('7412', '74', 'KAB. KONAWE KEPULAUAN', 1),
	('7413', '74', 'KAB. MUNA BARAT', 1),
	('7414', '74', 'KAB. BUTON TENGAH', 1),
	('7415', '74', 'KAB. BUTON SELATAN', 1),
	('7471', '74', 'KOTA KENDARI', 2),
	('7472', '74', 'KOTA BAU BAU', 2),
	('7501', '75', 'KAB. GORONTALO', 1),
	('7502', '75', 'KAB. BOALEMO', 1),
	('7503', '75', 'KAB. BONE BOLANGO', 1),
	('7504', '75', 'KAB. PAHUWATO', 1),
	('7505', '75', 'KAB. GORONTALO UTARA', 1),
	('7571', '75', 'KOTA GORONTALO', 2),
	('7601', '76', 'KAB. MAMUJU UTARA', 1),
	('7602', '76', 'KAB. MAMUJU', 1),
	('7603', '76', 'KAB. MAMASA', 1),
	('7604', '76', 'KAB. POLEWALI MANDAR', 1),
	('7605', '76', 'KAB. MAJENE', 1),
	('7606', '76', 'KAB. MAMUJU TENGAH', 1),
	('8101', '81', 'KAB. MALUKU TENGAH', 1),
	('8102', '81', 'KAB. MALUKU TENGGARA', 1),
	('8103', '81', 'KAB MALUKU TENGGARA BARAT', 1),
	('8104', '81', 'KAB. BURU', 1),
	('8105', '81', 'KAB. SERAM BAGIAN TIMUR', 1),
	('8106', '81', 'KAB. SERAM BAGIAN BARAT', 1),
	('8107', '81', 'KAB. KEPULAUAN ARU', 1),
	('8108', '81', 'KAB. MALUKU BARAT DAYA', 1),
	('8109', '81', 'KAB. BURU SELATAN', 1),
	('8171', '81', 'KOTA AMBON', 2),
	('8172', '81', 'KOTA TUAL', 2),
	('8201', '82', 'KAB. HALMAHERA BARAT', 1),
	('8202', '82', 'KAB. HALMAHERA TENGAH', 1),
	('8203', '82', 'KAB. HALMAHERA UTARA', 1),
	('8204', '82', 'KAB. HALMAHERA SELATAN', 1),
	('8205', '82', 'KAB. KEPULAUAN SULA', 1),
	('8206', '82', 'KAB. HALMAHERA TIMUR', 1),
	('8207', '82', 'KAB. PULAU MOROTAI', 1),
	('8208', '82', 'KAB. PULAU TALIABU', 1),
	('8271', '82', 'KOTA TERNATE', 2),
	('8272', '82', 'KOTA TIDORE KEPULAUAN', 2),
	('9101', '91', 'KAB. MERAUKE', 1),
	('9102', '91', 'KAB. JAYAWIJAYA', 1),
	('9103', '91', 'KAB. JAYAPURA', 1),
	('9104', '91', 'KAB. NABIRE', 1),
	('9105', '91', 'KAB. KEPULAUAN YAPEN', 1),
	('9106', '91', 'KAB. BIAK NUMFOR', 1),
	('9107', '91', 'KAB. PUNCAK JAYA', 1),
	('9108', '91', 'KAB. PANIAI', 1),
	('9109', '91', 'KAB. MIMIKA', 1),
	('9110', '91', 'KAB. SARMI', 1),
	('9111', '91', 'KAB. KEEROM', 1),
	('9112', '91', 'KAB PEGUNUNGAN BINTANG', 1),
	('9113', '91', 'KAB. YAHUKIMO', 1),
	('9114', '91', 'KAB. TOLIKARA', 1),
	('9115', '91', 'KAB. WAROPEN', 1),
	('9116', '91', 'KAB. BOVEN DIGOEL', 1),
	('9117', '91', 'KAB. MAPPI', 1),
	('9118', '91', 'KAB. ASMAT', 1),
	('9119', '91', 'KAB. SUPIORI', 1),
	('9120', '91', 'KAB. MAMBERAMO RAYA', 1),
	('9121', '91', 'KAB. MAMBERAMO TENGAH', 1),
	('9122', '91', 'KAB. YALIMO', 1),
	('9123', '91', 'KAB. LANNY JAYA', 1),
	('9124', '91', 'KAB. NDUGA', 1),
	('9125', '91', 'KAB. PUNCAK', 1),
	('9126', '91', 'KAB. DOGIYAI', 1),
	('9127', '91', 'KAB. INTAN JAYA', 1),
	('9128', '91', 'KAB. DEIYAI', 1),
	('9171', '91', 'KOTA JAYAPURA', 2),
	('9201', '92', 'KAB. SORONG', 1),
	('9202', '92', 'KAB. MANOKWARI', 1),
	('9203', '92', 'KAB. FAK FAK', 1),
	('9204', '92', 'KAB. SORONG SELATAN', 1),
	('9205', '92', 'KAB. RAJA AMPAT', 1),
	('9206', '92', 'KAB. TELUK BINTUNI', 1),
	('9207', '92', 'KAB. TELUK WONDAMA', 1),
	('9208', '92', 'KAB. KAIMANA', 1),
	('9209', '92', 'KAB. TAMBRAUW', 1),
	('9210', '92', 'KAB. MAYBRAT', 1),
	('9211', '92', 'KAB. MANOKWARI SELATAN', 1),
	('9212', '92', 'KAB. PEGUNUNGAN ARFAK', 1),
	('9271', '92', 'KOTA SORONG', 2);

-- Dumping structure for table keuangan2.kategori
DROP TABLE IF EXISTS `kategori`;
CREATE TABLE IF NOT EXISTS `kategori` (
  `kategori_id` int(11) NOT NULL AUTO_INCREMENT,
  `kode_akun` varchar(50) NOT NULL DEFAULT '0',
  `kategori` varchar(255) NOT NULL,
  `sub_kategori` varchar(255) NOT NULL,
  `sub_sub_kategori` varchar(255) NOT NULL,
  PRIMARY KEY (`kategori_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

-- Dumping data for table keuangan2.kategori: ~18 rows (approximately)
INSERT INTO `kategori` (`kategori_id`, `kode_akun`, `kategori`, `sub_kategori`, `sub_sub_kategori`) VALUES
	(1, 'KEU-001', 'Pendapatan Utama\r\n', 'DEBET', ''),
	(2, 'KEU-002', 'Pendapatan Lain - Lain\r\n', 'DEBET', ''),
	(3, 'KEU-003', 'Belanja Konsumsi dan Dapur\r\n', 'KREDIT', ''),
	(4, 'KEU-004', 'Belanja Operasional Kebersihan\r\n', 'KREDIT', ''),
	(5, 'KEU-005', 'Belanja Kebutuhan Administrasi\r\n', 'KREDIT', ''),
	(6, 'KEU-006', 'Belanja Peralatan Media\r\n', 'KREDIT', ''),
	(7, 'KEU-007', 'Belanja Standar Penilaian\r\n', 'KREDIT', ''),
	(8, 'KEU-008', 'Belanja Kebutuhan Pratikum\r\n', 'KREDIT', ''),
	(9, 'KEU-009', 'Belanja Perpustakaan\r\n', 'KREDIT', ''),
	(10, 'KEU-010', 'Belanja Setoran Perpajakan\r\n', 'KREDIT', ''),
	(11, 'KEU-011', 'Belanja Operasional Transportasi\r\n', 'KREDIT', ''),
	(12, 'KEU-012', 'Belanja Sarana dan Prasarana\r\n', 'KREDIT', ''),
	(13, 'KEU-013', 'Belanja Pemeliharaan Sarana Prasarana\r\n', 'KREDIT', ''),
	(14, 'KEU-014', 'Belanja Langganan Daya\r\n', 'KREDIT', ''),
	(15, 'KEU-015', 'Aset Tetap Berwujud\r\n', 'KREDIT', ''),
	(16, 'KEU-016', 'Belanja Pegawai\r\n', 'KREDIT', ''),
	(17, 'KEU-017', 'Belanja Kebutuhan UKP\r\n', 'KREDIT', ''),
	(18, 'KEU-018', 'Belanja Kegiatan OSPIA', 'KREDIT', '');

-- Dumping structure for table keuangan2.kecamatan
DROP TABLE IF EXISTS `kecamatan`;
CREATE TABLE IF NOT EXISTS `kecamatan` (
  `id_kec` char(6) NOT NULL,
  `id_kab` char(4) NOT NULL,
  `nama` tinytext NOT NULL,
  PRIMARY KEY (`id_kec`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table keuangan2.kecamatan: ~7,094 rows (approximately)
INSERT INTO `kecamatan` (`id_kec`, `id_kab`, `nama`) VALUES
	('110101', '1101', 'Bakongan'),
	('110102', '1101', 'Kluet Utara'),
	('110103', '1101', 'Kluet Selatan'),
	('110104', '1101', 'Labuhan Haji'),
	('110105', '1101', 'Meukek'),
	('110106', '1101', 'Samadua'),
	('110107', '1101', 'Sawang'),
	('110108', '1101', 'Tapaktuan'),
	('110109', '1101', 'Trumon'),
	('110110', '1101', 'Pasi Raja'),
	('110111', '1101', 'Labuhan Haji Timur'),
	('110112', '1101', 'Labuhan Haji Barat'),
	('110113', '1101', 'Kluet Tengah'),
	('110114', '1101', 'Kluet Timur'),
	('110115', '1101', 'Bakongan Timur'),
	('110116', '1101', 'Trumon Timur'),
	('110117', '1101', 'Kota Bahagia'),
	('110118', '1101', 'Trumon Tengah'),
	('110201', '1102', 'Lawe Alas'),
	('110202', '1102', 'Lawe Sigala-Gala'),
	('110203', '1102', 'Bambel'),
	('110204', '1102', 'Babussalam'),
	('110205', '1102', 'Badar'),
	('110206', '1102', 'Babul Makmur'),
	('110207', '1102', 'Darul Hasanah'),
	('110208', '1102', 'Lawe Bulan'),
	('110209', '1102', 'Bukit Tusam'),
	('110210', '1102', 'Semadam'),
	('110211', '1102', 'Babul Rahmah'),
	('110212', '1102', 'Ketambe'),
	('110213', '1102', 'Deleng Pokhkisen'),
	('110214', '1102', 'Lawe Sumur'),
	('110215', '1102', 'Tanoh Alas'),
	('110216', '1102', 'Leuser'),
	('110301', '1103', 'Darul Aman'),
	('110302', '1103', 'Julok'),
	('110303', '1103', 'Idi Rayeuk'),
	('110304', '1103', 'Birem Bayeun'),
	('110305', '1103', 'Serbajadi'),
	('110306', '1103', 'Nurussalam'),
	('110307', '1103', 'Peureulak'),
	('110308', '1103', 'Rantau Selamat'),
	('110309', '1103', 'Simpang Ulim'),
	('110310', '1103', 'Rantau Peureulak'),
	('110311', '1103', 'Pante Bidari'),
	('110312', '1103', 'Madat'),
	('110313', '1103', 'Indra Makmu'),
	('110314', '1103', 'Idi Tunong'),
	('110315', '1103', 'Banda Alam'),
	('110316', '1103', 'Peudawa'),
	('110317', '1103', 'Peureulak Timur'),
	('110318', '1103', 'Peureulak Barat'),
	('110319', '1103', 'Sungai Raya'),
	('110320', '1103', 'Simpang Jernih'),
	('110321', '1103', 'Darul Ihsan'),
	('110322', '1103', 'Darul Falah'),
	('110323', '1103', 'Idi Timur'),
	('110324', '1103', 'Peunaron'),
	('110401', '1104', 'Linge'),
	('110402', '1104', 'Silih Nara'),
	('110403', '1104', 'Bebesen'),
	('110407', '1104', 'Pegasing'),
	('110408', '1104', 'Bintang'),
	('110410', '1104', 'Ketol'),
	('110411', '1104', 'Kebayakan'),
	('110412', '1104', 'Kute Panang'),
	('110413', '1104', 'Celala'),
	('110417', '1104', 'Laut Tawar'),
	('110418', '1104', 'Atu Lintang'),
	('110419', '1104', 'Jagong Jeget'),
	('110420', '1104', 'Bies'),
	('110421', '1104', 'Rusip Antara'),
	('110501', '1105', 'Johan Pahwalan'),
	('110502', '1105', 'Kaway XVI'),
	('110503', '1105', 'Sungai Mas'),
	('110504', '1105', 'Woyla'),
	('110505', '1105', 'Samatiga'),
	('110506', '1105', 'Bubon'),
	('110507', '1105', 'Arongan Lambalek'),
	('110508', '1105', 'Pante Ceureumen'),
	('110509', '1105', 'Meureubo'),
	('110510', '1105', 'Woyla Barat'),
	('110511', '1105', 'Woyla Timur'),
	('110512', '1105', 'Panton Reu'),
	('110601', '1106', 'Lhoong'),
	('110602', '1106', 'Lhoknga'),
	('110603', '1106', 'Indrapuri'),
	('110604', '1106', 'Seulimeum'),
	('110605', '1106', 'Montasik'),
	('110606', '1106', 'Sukamakmur'),
	('110607', '1106', 'Darul Imarah'),
	('110608', '1106', 'Peukan Bada'),
	('110609', '1106', 'Mesjid Raya'),
	('110610', '1106', 'Ingin Jaya'),
	('110611', '1106', 'Kuta Baro'),
	('110612', '1106', 'Darussalam'),
	('110613', '1106', 'Pulo Aceh'),
	('110614', '1106', 'Lembah Seulawah'),
	('110615', '1106', 'Kota Jantho'),
	('110616', '1106', 'Kota Cot Glie'),
	('110617', '1106', 'Kuta Malaka'),
	('110618', '1106', 'Simpang Tiga'),
	('110619', '1106', 'Darul Kamal'),
	('110620', '1106', 'Baitussalam'),
	('110621', '1106', 'Krueng Barona Jaya'),
	('110622', '1106', 'Leupung'),
	('110623', '1106', 'Blang Bintang'),
	('110703', '1107', 'Batee'),
	('110704', '1107', 'Delima'),
	('110705', '1107', 'Geumpang'),
	('110706', '1107', 'Geulumpang Tiga'),
	('110707', '1107', 'Indra Jaya'),
	('110708', '1107', 'Kembang Tanjong'),
	('110709', '1107', 'Kota Sigli'),
	('110711', '1107', 'Mila'),
	('110712', '1107', 'Muara Tiga'),
	('110713', '1107', 'Mutiara'),
	('110714', '1107', 'Padang Tiji'),
	('110715', '1107', 'Peukan Baro'),
	('110716', '1107', 'Pidie'),
	('110717', '1107', 'Sakti'),
	('110718', '1107', 'Simpang Tiga'),
	('110719', '1107', 'Tangse'),
	('110721', '1107', 'Tiro/Truseb'),
	('110722', '1107', 'Keumala'),
	('110724', '1107', 'Mutiara Timur'),
	('110725', '1107', 'Grong-grong'),
	('110727', '1107', 'Mane'),
	('110729', '1107', 'Glumpang Baro'),
	('110731', '1107', 'Titeue'),
	('110801', '1108', 'Baktiya'),
	('110802', '1108', 'Dewantara'),
	('110803', '1108', 'Kuta Makmur'),
	('110804', '1108', 'Lhoksukon'),
	('110805', '1108', 'Matangkuli'),
	('110806', '1108', 'Muara Batu'),
	('110807', '1108', 'Meurah Mulia'),
	('110808', '1108', 'Samudera'),
	('110809', '1108', 'Seunuddon'),
	('110810', '1108', 'Syamtalira Aron'),
	('110811', '1108', 'Syamtalira Bayu'),
	('110812', '1108', 'Tanah Luas'),
	('110813', '1108', 'Tanah Pasir'),
	('110814', '1108', 'T. Jambo Aye'),
	('110815', '1108', 'Sawang'),
	('110816', '1108', 'Nisam'),
	('110817', '1108', 'Cot Girek'),
	('110818', '1108', 'Langkahan'),
	('110819', '1108', 'Baktiya Barat'),
	('110820', '1108', 'Paya Bakong'),
	('110821', '1108', 'Nibong'),
	('110822', '1108', 'Simpang Kramat'),
	('110823', '1108', 'Lapang'),
	('110824', '1108', 'Pirak Timur'),
	('110825', '1108', 'Geuredong Pase'),
	('110826', '1108', 'Banda Baro'),
	('110827', '1108', 'Nisam Antara'),
	('110901', '1109', 'Simeulue Tengah'),
	('110902', '1109', 'Salang'),
	('110903', '1109', 'Teupah Barat'),
	('110904', '1109', 'Simeulue Timur'),
	('110905', '1109', 'Teluk Dalam'),
	('110906', '1109', 'Simeulue Barat'),
	('110907', '1109', 'Teupah Selatan'),
	('110908', '1109', 'Alapan'),
	('110909', '1109', 'Teupah Tengah'),
	('110910', '1109', 'Simeulue Cut'),
	('111001', '1110', 'Pulau Banyak'),
	('111002', '1110', 'Simpang Kanan'),
	('111004', '1110', 'Singkil'),
	('111006', '1110', 'Gunung Meriah'),
	('111009', '1110', 'Kota Baharu'),
	('111010', '1110', 'Singkil Utara'),
	('111011', '1110', 'Danau Paris'),
	('111012', '1110', 'Suro Makmur'),
	('111013', '1110', 'Singkohor'),
	('111014', '1110', 'Kuala Baru'),
	('111016', '1110', 'Pulau Banyak Barat'),
	('111101', '1111', 'Samalanga'),
	('111102', '1111', 'Jeunieb'),
	('111103', '1111', 'Peudada'),
	('111104', '1111', 'Jeumpa'),
	('111105', '1111', 'Peusangan'),
	('111106', '1111', 'Makmur'),
	('111107', '1111', 'Gandapura'),
	('111108', '1111', 'Pandrah'),
	('111109', '1111', 'Juli'),
	('111110', '1111', 'Jangka'),
	('111111', '1111', 'Simpang Mamplam'),
	('111112', '1111', 'Peulimbang'),
	('111113', '1111', 'Kota Juang'),
	('111114', '1111', 'Kuala'),
	('111115', '1111', 'Peusangan Siblah Krueng'),
	('111116', '1111', 'Peusangan Selatan'),
	('111117', '1111', 'Kuta Blang'),
	('111201', '1112', 'Blang Pidie'),
	('111202', '1112', 'Tangan-Tangan'),
	('111203', '1112', 'Manggeng'),
	('111204', '1112', 'Susoh'),
	('111205', '1112', 'Kuala Batee'),
	('111206', '1112', 'Babah Rot'),
	('111207', '1112', 'Setia'),
	('111208', '1112', 'Jeumpa'),
	('111209', '1112', 'Lembah Sabil'),
	('111301', '1113', 'Blangkejeren'),
	('111302', '1113', 'Kutapanjang'),
	('111303', '1113', 'Rikit Gaib'),
	('111304', '1113', 'Terangun'),
	('111305', '1113', 'Pining'),
	('111306', '1113', 'Blangpegayon'),
	('111307', '1113', 'Puteri Betung'),
	('111308', '1113', 'Dabun Gelang'),
	('111309', '1113', 'Blangjerango'),
	('111310', '1113', 'Teripe Jaya'),
	('111311', '1113', 'Pantan Cuaca'),
	('111401', '1114', 'Teunom'),
	('111402', '1114', 'Krueng Sabee'),
	('111403', '1114', 'Setia Bhakti'),
	('111404', '1114', 'Sampoiniet'),
	('111405', '1114', 'Jaya'),
	('111406', '1114', 'Panga'),
	('111407', '1114', 'Indra Jaya'),
	('111408', '1114', 'Darul Hikmah'),
	('111409', '1114', 'Pasie Raya'),
	('111501', '1115', 'Kuala'),
	('111502', '1115', 'Seunagan'),
	('111503', '1115', 'Seunagan Timur'),
	('111504', '1115', 'Beutong'),
	('111505', '1115', 'Darul Makmur'),
	('111506', '1115', 'Suka Makmue'),
	('111507', '1115', 'Kuala Pesisir'),
	('111508', '1115', 'Tadu Raya'),
	('111509', '1115', 'Tripa Makmur'),
	('111510', '1115', 'Beutong Ateuh Banggalang'),
	('111601', '1116', 'Manyak Payed'),
	('111602', '1116', 'Bendahara'),
	('111603', '1116', 'Karang Baru'),
	('111604', '1116', 'Seruway'),
	('111605', '1116', 'Kota Kualasinpang'),
	('111606', '1116', 'Kejuruan Muda'),
	('111607', '1116', 'Tamiang Hulu'),
	('111608', '1116', 'Rantau'),
	('111609', '1116', 'Banda Mulia'),
	('111610', '1116', 'Bandar Pusaka'),
	('111611', '1116', 'Tenggulun'),
	('111612', '1116', 'Sekerak'),
	('111701', '1117', 'Pintu Rime Gayo'),
	('111702', '1117', 'Permata'),
	('111703', '1117', 'Syiah Utama'),
	('111704', '1117', 'Bandar'),
	('111705', '1117', 'Bukit'),
	('111706', '1117', 'Wih Pesam'),
	('111707', '1117', 'Timang gajah'),
	('111708', '1117', 'Bener Kelipah'),
	('111709', '1117', 'Mesidah'),
	('111710', '1117', 'Gajah Putih'),
	('111801', '1118', 'Meureudu'),
	('111802', '1118', 'Ulim'),
	('111803', '1118', 'Jangka Buaya'),
	('111804', '1118', 'Bandar Dua'),
	('111805', '1118', 'Meurah Dua'),
	('111806', '1118', 'Bandar Baru'),
	('111807', '1118', 'Panteraja'),
	('111808', '1118', 'Trienggadeng'),
	('117101', '1171', 'Baiturrahman'),
	('117102', '1171', 'Kuta Alam'),
	('117103', '1171', 'Meuraxa'),
	('117104', '1171', 'Syiah Kuala'),
	('117105', '1171', 'Lueng Bata'),
	('117106', '1171', 'Kuta Raja'),
	('117107', '1171', 'Banda Raya'),
	('117108', '1171', 'Jaya Baru'),
	('117109', '1171', 'Ulee Kareng'),
	('117201', '1172', 'Sukakarya'),
	('117202', '1172', 'Sukajaya'),
	('117301', '1173', 'Muara Dua'),
	('117302', '1173', 'Banda Sakti'),
	('117303', '1173', 'Blang Mangat'),
	('117304', '1173', 'Muara Satu'),
	('117401', '1174', 'Langsa Timur'),
	('117402', '1174', 'Langsa Barat'),
	('117403', '1174', 'Langsa Kota'),
	('117404', '1174', 'Langsa Lama'),
	('117405', '1174', 'Langsa Baro'),
	('117501', '1175', 'Simpang Kiri'),
	('117502', '1175', 'Penanggalan'),
	('117503', '1175', 'Rundeng'),
	('117504', '1175', 'Sultan Daulat'),
	('117505', '1175', 'Longkib'),
	('120101', '1201', 'Barus'),
	('120102', '1201', 'Sorkam'),
	('120103', '1201', 'Pandan'),
	('120104', '1201', 'Pinangsori'),
	('120105', '1201', 'Manduamas'),
	('120106', '1201', 'Kolang'),
	('120107', '1201', 'Tapian Nauli'),
	('120108', '1201', 'Sibabangun'),
	('120109', '1201', 'Sosor Gadong'),
	('120110', '1201', 'Sorkam Barat'),
	('120111', '1201', 'Sirandorung'),
	('120112', '1201', 'Andam Dewi'),
	('120113', '1201', 'Sitahuis'),
	('120114', '1201', 'Tukka'),
	('120115', '1201', 'Badiri'),
	('120116', '1201', 'Pasaribu Tobing'),
	('120117', '1201', 'Barus Utara'),
	('120118', '1201', 'Suka Bangun'),
	('120119', '1201', 'Lumut'),
	('120120', '1201', 'Sarudik'),
	('120201', '1202', 'Tarutung'),
	('120202', '1202', 'Siatas Barita'),
	('120203', '1202', 'Adian Koting'),
	('120204', '1202', 'Sipoholon'),
	('120205', '1202', 'Pahae Julu'),
	('120206', '1202', 'Pahae Jae'),
	('120207', '1202', 'Simangumban'),
	('120208', '1202', 'Purba Tua'),
	('120209', '1202', 'Siborong-Borong'),
	('120210', '1202', 'Pagaran'),
	('120211', '1202', 'Parmonangan'),
	('120212', '1202', 'Sipahutar'),
	('120213', '1202', 'Pangaribuan'),
	('120214', '1202', 'Garoga'),
	('120215', '1202', 'Muara'),
	('120301', '1203', 'Angkola Barat'),
	('120302', '1203', 'Batang Toru'),
	('120303', '1203', 'Angkola Timur'),
	('120304', '1203', 'Sipirok'),
	('120305', '1203', 'Saipar Dolok Hole'),
	('120306', '1203', 'Angkola Selatan'),
	('120307', '1203', 'Batang Angkola'),
	('120314', '1203', 'Arse'),
	('120320', '1203', 'Marancar'),
	('120321', '1203', 'Sayur Matinggi'),
	('120322', '1203', 'Aek Bilah'),
	('120329', '1203', 'Muara Batang Toru'),
	('120330', '1203', 'Tano Tombangan Angkola'),
	('120331', '1203', 'Angkola Sangkunur'),
	('120405', '1204', 'Hiliduho'),
	('120406', '1204', 'Gido'),
	('120410', '1204', 'Idanogawo'),
	('120411', '1204', 'Bawolato'),
	('120420', '1204', 'Hiliserangkai'),
	('120421', '1204', 'Botomuzoi'),
	('120427', '1204', 'Ulugawo'),
	('120428', '1204', 'Ma\'u'),
	('120429', '1204', 'Somolo-molo'),
	('120435', '1204', 'Sogae\'adu'),
	('120501', '1205', 'Bahorok'),
	('120502', '1205', 'Salapian'),
	('120503', '1205', 'Kuala'),
	('120504', '1205', 'Sei Bingei'),
	('120505', '1205', 'Binjai'),
	('120506', '1205', 'Selesai'),
	('120507', '1205', 'Stabat'),
	('120508', '1205', 'Wampu'),
	('120509', '1205', 'Secanggang'),
	('120510', '1205', 'Hinai'),
	('120511', '1205', 'Tanjung Pura'),
	('120512', '1205', 'Padang Tualang'),
	('120513', '1205', 'Gebang'),
	('120514', '1205', 'Babalan'),
	('120515', '1205', 'Pangkalan Susu'),
	('120516', '1205', 'Besitang'),
	('120517', '1205', 'Sei Lepan'),
	('120518', '1205', 'Brandan Barat'),
	('120519', '1205', 'Batang Serangan'),
	('120520', '1205', 'Sawit Seberang'),
	('120521', '1205', 'Sirapit'),
	('120522', '1205', 'Kutambaru'),
	('120523', '1205', 'Pematang Jaya'),
	('120601', '1206', 'Kabanjahe'),
	('120602', '1206', 'Berastagi'),
	('120603', '1206', 'Barusjahe'),
	('120604', '1206', 'Tigapanah'),
	('120605', '1206', 'Merek'),
	('120606', '1206', 'Munte'),
	('120607', '1206', 'Juhar'),
	('120608', '1206', 'Tigabinanga'),
	('120609', '1206', 'Laubaleng'),
	('120610', '1206', 'Mardingding'),
	('120611', '1206', 'Payung'),
	('120612', '1206', 'Simpang Empat'),
	('120613', '1206', 'Kutabuluh'),
	('120614', '1206', 'Dolat Rayat'),
	('120615', '1206', 'Merdeka'),
	('120616', '1206', 'Naman Teran'),
	('120617', '1206', 'Tiganderket'),
	('120701', '1207', 'Gunung Meriah'),
	('120702', '1207', 'Tanjung Morawa'),
	('120703', '1207', 'Sibolangit'),
	('120704', '1207', 'Kutalimbaru'),
	('120705', '1207', 'Pancur Batu'),
	('120706', '1207', 'Namorambe'),
	('120707', '1207', 'Sibiru-biru'),
	('120708', '1207', 'STM Hilir'),
	('120709', '1207', 'Bangun Purba'),
	('120719', '1207', 'Galang'),
	('120720', '1207', 'STM Hulu'),
	('120721', '1207', 'Patumbak'),
	('120722', '1207', 'Deli Tua'),
	('120723', '1207', 'Sunggal'),
	('120724', '1207', 'Hamparan Perak'),
	('120725', '1207', 'Labuhan Deli'),
	('120726', '1207', 'Percut Sei Tuan'),
	('120727', '1207', 'Batang Kuis'),
	('120728', '1207', 'Lubuk Pakam'),
	('120731', '1207', 'Pagar Merbau'),
	('120732', '1207', 'Pantai Labu'),
	('120733', '1207', 'Beringin'),
	('120801', '1208', 'Siantar'),
	('120802', '1208', 'Gunung Malela'),
	('120803', '1208', 'Gunung Maligas'),
	('120804', '1208', 'Panei'),
	('120805', '1208', 'Panombeian Pane'),
	('120806', '1208', 'Jorlang Hataran'),
	('120807', '1208', 'Raya Kahean'),
	('120808', '1208', 'Bosar Maligas'),
	('120809', '1208', 'Sidamanik'),
	('120810', '1208', 'Pematang Sidamanik'),
	('120811', '1208', 'Tanah Jawa'),
	('120812', '1208', 'Hatonduhan'),
	('120813', '1208', 'Dolok Panribuan'),
	('120814', '1208', 'Purba'),
	('120815', '1208', 'Haranggaol Horison'),
	('120816', '1208', 'Girsang Sipangan Bolon'),
	('120817', '1208', 'Dolok Batu Nanggar'),
	('120818', '1208', 'Huta Bayu Raja'),
	('120819', '1208', 'Jawa Maraja Bah Jambi'),
	('120820', '1208', 'Dolok Pardamean'),
	('120821', '1208', 'Pematang Bandar'),
	('120822', '1208', 'Bandar Huluan'),
	('120823', '1208', 'Bandar'),
	('120824', '1208', 'Bandar Masilam'),
	('120825', '1208', 'Silimakuta'),
	('120826', '1208', 'Dolok Silau'),
	('120827', '1208', 'Silou Kahean'),
	('120828', '1208', 'Tapian Dolok'),
	('120829', '1208', 'Raya'),
	('120830', '1208', 'Ujung Padang'),
	('120831', '1208', 'Pamatang Silima Huta'),
	('120908', '1209', 'Meranti'),
	('120909', '1209', 'Air Joman'),
	('120910', '1209', 'Tanjung Balai'),
	('120911', '1209', 'Sei Kepayang'),
	('120912', '1209', 'Simpang Empat'),
	('120913', '1209', 'Air Batu'),
	('120914', '1209', 'Pulau Rakyat'),
	('120915', '1209', 'Bandar Pulau'),
	('120916', '1209', 'Buntu Pane'),
	('120917', '1209', 'Bandar Pasir Mandoge'),
	('120918', '1209', 'Aek Kuasan'),
	('120919', '1209', 'Kota Kisaran Barat'),
	('120920', '1209', 'Kota Kisaran Timur'),
	('120921', '1209', 'Aek Songsongan'),
	('120922', '1209', 'Rahunig'),
	('120923', '1209', 'Sei Dadap'),
	('120924', '1209', 'Sei Kepayang Barat'),
	('120925', '1209', 'Sei Kepayang Timur'),
	('120926', '1209', 'Tinggi Raja'),
	('120927', '1209', 'Setia Janji'),
	('120928', '1209', 'Silau Laut'),
	('120929', '1209', 'Rawang Panca Arga'),
	('120930', '1209', 'Pulo Bandring'),
	('120931', '1209', 'Teluk Dalam'),
	('120932', '1209', 'Aek Ledong'),
	('121001', '1210', 'Rantau Utara'),
	('121002', '1210', 'Rantau Selatan'),
	('121007', '1210', 'Bilah Barat'),
	('121008', '1210', 'Bilah Hilir'),
	('121009', '1210', 'Bilah Hulu'),
	('121014', '1210', 'Pangkatan'),
	('121018', '1210', 'Panai Tengah'),
	('121019', '1210', 'Panai Hilir'),
	('121020', '1210', 'Panai Hulu'),
	('121101', '1211', 'Sidikalang'),
	('121102', '1211', 'Sumbul'),
	('121103', '1211', 'Tigalingga'),
	('121104', '1211', 'Siempat Nempu'),
	('121105', '1211', 'Silima Pungga Punga'),
	('121106', '1211', 'Tanah Pinem'),
	('121107', '1211', 'Siempat Nempu Hulu'),
	('121108', '1211', 'Siempat Nempu Hilir'),
	('121109', '1211', 'Pegagan Hilir'),
	('121110', '1211', 'Parbuluan'),
	('121111', '1211', 'Lae Parira'),
	('121112', '1211', 'Gunung Sitember'),
	('121113', '1211', 'Brampu'),
	('121114', '1211', 'Silahisabungan'),
	('121115', '1211', 'Sitinjo'),
	('121201', '1212', 'Balige'),
	('121202', '1212', 'Laguboti'),
	('121203', '1212', 'Silaen'),
	('121204', '1212', 'Habinsaran'),
	('121205', '1212', 'Pintu Pohan Meranti'),
	('121206', '1212', 'Borbor'),
	('121207', '1212', 'Porsea'),
	('121208', '1212', 'Ajibata'),
	('121209', '1212', 'Lumban Julu'),
	('121210', '1212', 'Uluan'),
	('121219', '1212', 'Sigumpar'),
	('121220', '1212', 'Siantar Narumonda'),
	('121221', '1212', 'Nassau'),
	('121222', '1212', 'Tampahan'),
	('121223', '1212', 'Bonatua Lunasi'),
	('121224', '1212', 'Parmaksian'),
	('121301', '1213', 'Panyabungan'),
	('121302', '1213', 'Panyabungan Utara'),
	('121303', '1213', 'Panyabungan Timur'),
	('121304', '1213', 'Panyabungan Selatan'),
	('121305', '1213', 'Panyabungan Barat'),
	('121306', '1213', 'Siabu'),
	('121307', '1213', 'Bukit Malintang'),
	('121308', '1213', 'Kotanopan'),
	('121309', '1213', 'Lembah Sorik Marapi'),
	('121310', '1213', 'Tambangan'),
	('121311', '1213', 'Ulu Pungkut'),
	('121312', '1213', 'Muara Sipongi'),
	('121313', '1213', 'Batang Natal'),
	('121314', '1213', 'Lingga Bayu'),
	('121315', '1213', 'Batahan'),
	('121316', '1213', 'Natal'),
	('121317', '1213', 'Muara Batang Gadis'),
	('121318', '1213', 'Ranto Baek'),
	('121319', '1213', 'Huta Bargot'),
	('121320', '1213', 'Puncak Sorik Marapi'),
	('121321', '1213', 'Pakantan'),
	('121322', '1213', 'Sinunukan'),
	('121323', '1213', 'Naga Juang'),
	('121401', '1214', 'Lolomatua'),
	('121402', '1214', 'Gomo'),
	('121403', '1214', 'Lahusa'),
	('121404', '1214', 'Hibala'),
	('121405', '1214', 'Pulau-Pulau Batu'),
	('121406', '1214', 'Teluk Dalam'),
	('121407', '1214', 'Amandraya'),
	('121408', '1214', 'Lalowa\'u'),
	('121409', '1214', 'Susua'),
	('121410', '1214', 'Maniamolo'),
	('121411', '1214', 'Hilimegai'),
	('121412', '1214', 'Toma'),
	('121413', '1214', 'Mazino'),
	('121414', '1214', 'Umbunasi'),
	('121415', '1214', 'Aramo'),
	('121416', '1214', 'Pulau-Pulau Batu Timur'),
	('121417', '1214', 'Mazo'),
	('121418', '1214', 'Fanayama'),
	('121419', '1214', 'Ulunoyo'),
	('121420', '1214', 'Huruna'),
	('121421', '1214', 'O\'o\'u'),
	('121422', '1214', 'Onohazumba'),
	('121423', '1214', 'Hilisalawa\'ahe'),
	('121424', '1214', 'Ulususua'),
	('121425', '1214', 'Sidua\'ori'),
	('121426', '1214', 'Somambawa'),
	('121427', '1214', 'Boronadu'),
	('121428', '1214', 'Simuk'),
	('121429', '1214', 'Pulau-Pulau Batu Barat'),
	('121430', '1214', 'Pulau-Pulau Batu Utara'),
	('121431', '1214', 'Tanah Masa'),
	('121501', '1215', 'Sitelu Tali Urang Jehe'),
	('121502', '1215', 'Kerajaan'),
	('121503', '1215', 'Salak'),
	('121504', '1215', 'Sitelu Tali Urang Julu'),
	('121505', '1215', 'Pergetteng Getteng Sengkut'),
	('121506', '1215', 'Pagindar'),
	('121507', '1215', 'Tinada'),
	('121508', '1215', 'Siempat Rube'),
	('121601', '1216', 'Parlilitan'),
	('121602', '1216', 'Pollung'),
	('121603', '1216', 'Baktiraja'),
	('121604', '1216', 'Paranginan'),
	('121605', '1216', 'Lintong Nihuta'),
	('121606', '1216', 'Dolok Sanggul'),
	('121607', '1216', 'Sijamapolang'),
	('121608', '1216', 'Onan Ganjang'),
	('121609', '1216', 'Pakkat'),
	('121610', '1216', 'Tarabintang'),
	('121701', '1217', 'Simanindo'),
	('121702', '1217', 'Onan Runggu'),
	('121703', '1217', 'Nainggolan'),
	('121704', '1217', 'Palipi'),
	('121705', '1217', 'Harian'),
	('121706', '1217', 'Sianjar Mula Mula'),
	('121707', '1217', 'Ronggur Nihuta'),
	('121708', '1217', 'Pangururan'),
	('121709', '1217', 'Sitio-tio'),
	('121801', '1218', 'Pantai Cermin'),
	('121802', '1218', 'Perbaungan'),
	('121803', '1218', 'Teluk Mengkudu'),
	('121804', '1218', 'Sei. Rampah'),
	('121805', '1218', 'Tanjung Beringin'),
	('121806', '1218', 'Bandar Khalifah'),
	('121807', '1218', 'Dolok Merawan'),
	('121808', '1218', 'Sipispis'),
	('121809', '1218', 'Dolok Masihul'),
	('121810', '1218', 'Kotarih'),
	('121811', '1218', 'Silinda'),
	('121812', '1218', 'Serba Jadi'),
	('121813', '1218', 'Tebing Tinggi'),
	('121814', '1218', 'Pegajahan'),
	('121815', '1218', 'Sei Bamban'),
	('121816', '1218', 'Tebing Syahbandar'),
	('121817', '1218', 'Bintang Bayu'),
	('121901', '1219', 'Medang Deras'),
	('121902', '1219', 'Sei Suka'),
	('121903', '1219', 'Air Putih'),
	('121904', '1219', 'Lima Puluh'),
	('121905', '1219', 'Talawi'),
	('121906', '1219', 'Tanjung Tiram'),
	('121907', '1219', 'Sei Balai'),
	('122001', '1220', 'Dolok Sigompulon'),
	('122002', '1220', 'Dolok'),
	('122003', '1220', 'Halongonan'),
	('122004', '1220', 'Padang Bolak'),
	('122005', '1220', 'Padang Bolak Julu'),
	('122006', '1220', 'Portibi'),
	('122007', '1220', 'Batang Onang'),
	('122008', '1220', 'Simangambat'),
	('122009', '1220', 'Hulu Sihapas'),
	('122101', '1221', 'Sosopan'),
	('122102', '1221', 'Barumun Tengah'),
	('122103', '1221', 'Huristak'),
	('122104', '1221', 'Lubuk Barumun'),
	('122105', '1221', 'Huta Raja Tinggi'),
	('122106', '1221', 'Ulu Barumun'),
	('122107', '1221', 'Barumun'),
	('122108', '1221', 'Sosa'),
	('122109', '1221', 'Batang Lubu Sutam'),
	('122110', '1221', 'Barumun Selatan'),
	('122111', '1221', 'Aek Nabara Barumun'),
	('122112', '1221', 'Sihapas Barumun'),
	('122201', '1222', 'Kotapinang'),
	('122202', '1222', 'Kampung Rakyat'),
	('122203', '1222', 'Torgamba'),
	('122204', '1222', 'Sungai Kanan'),
	('122205', '1222', 'Silangkitang'),
	('122301', '1223', 'Kualuh Hulu'),
	('122302', '1223', 'Kualuh Leidong'),
	('122303', '1223', 'Kualuh Hilir'),
	('122304', '1223', 'Aek Kuo'),
	('122305', '1223', 'Marbau'),
	('122306', '1223', 'Na IX - X'),
	('122307', '1223', 'Aek Natas'),
	('122308', '1223', 'Kualuh Selatan'),
	('122401', '1224', 'Lotu'),
	('122402', '1224', 'Sawo'),
	('122403', '1224', 'Tuhemberua'),
	('122404', '1224', 'Sitolu Ori'),
	('122405', '1224', 'Namohalu Esiwa'),
	('122406', '1224', 'Alasa Talumuzoi'),
	('122407', '1224', 'Alasa'),
	('122408', '1224', 'Tugala Oyo'),
	('122409', '1224', 'Afulu'),
	('122410', '1224', 'Lahewa'),
	('122411', '1224', 'Lahewa Timur'),
	('122501', '1225', 'Lahomi'),
	('122502', '1225', 'Sirombu'),
	('122503', '1225', 'Mandrehe Barat'),
	('122504', '1225', 'Moro\'o'),
	('122505', '1225', 'Mandrehe'),
	('122506', '1225', 'Mandrehe Utara'),
	('122507', '1225', 'Lolofitu Moi'),
	('122508', '1225', 'Ulu Moro\'o'),
	('127101', '1271', 'Medan Kota'),
	('127102', '1271', 'Medan Sunggal'),
	('127103', '1271', 'Medan Helvetia'),
	('127104', '1271', 'Medan Denai'),
	('127105', '1271', 'Medan Barat'),
	('127106', '1271', 'Medan Deli'),
	('127107', '1271', 'Medan Tuntungan'),
	('127108', '1271', 'Medan Belawan'),
	('127109', '1271', 'Medan Amplas'),
	('127110', '1271', 'Medan Area'),
	('127111', '1271', 'Medan Johor'),
	('127112', '1271', 'Medan Marelan'),
	('127113', '1271', 'Medan Labuhan'),
	('127114', '1271', 'Medan Tembung'),
	('127115', '1271', 'Medan Maimun'),
	('127116', '1271', 'Medan Polonia'),
	('127117', '1271', 'Medan Baru'),
	('127118', '1271', 'Medan Perjuangan'),
	('127119', '1271', 'Medan Petisah'),
	('127120', '1271', 'Medan Timur'),
	('127121', '1271', 'Medan Selayang'),
	('127201', '1272', 'Siantar Timur'),
	('127202', '1272', 'Siantar Barat'),
	('127203', '1272', 'Siantar Utara'),
	('127204', '1272', 'Siantar Selatan'),
	('127205', '1272', 'Siantar Marihat'),
	('127206', '1272', 'Siantar Martoba'),
	('127207', '1272', 'Siantar Sitalasari'),
	('127208', '1272', 'Siantar Marimbun'),
	('127301', '1273', 'Sibolga Utara'),
	('127302', '1273', 'Sibolga Kota'),
	('127303', '1273', 'Sibolga Selatan'),
	('127304', '1273', 'Sibolga Sambas'),
	('127401', '1274', 'Tanjung Balai Selatan'),
	('127402', '1274', 'Tanjung Balai Utara'),
	('127403', '1274', 'Sei Tualang Raso'),
	('127404', '1274', 'Teluk Nibung'),
	('127405', '1274', 'Datuk Bandar'),
	('127406', '1274', 'Datuk Bandar Timur'),
	('127501', '1275', 'Binjai Utara'),
	('127502', '1275', 'Binjai Kota'),
	('127503', '1275', 'Binjai Barat'),
	('127504', '1275', 'Binjai Timur'),
	('127505', '1275', 'Binjai Selatan'),
	('127601', '1276', 'Padang Hulu'),
	('127602', '1276', 'Rambutan'),
	('127603', '1276', 'Padang Hilir'),
	('127604', '1276', 'Bajenis'),
	('127605', '1276', 'Tebing Tinggi Kota'),
	('127701', '1277', 'Padangsidimpuan Utara'),
	('127702', '1277', 'Padangsidimpuan Selatan'),
	('127703', '1277', 'Padangsidimpuan Batunadua'),
	('127704', '1277', 'Padangsidimpuan Hutaimbaru'),
	('127705', '1277', 'Padangsidimpuan Tenggara'),
	('127706', '1277', 'Padangsidimpuan Angkola Julu'),
	('127801', '1278', 'Gunungsitoli'),
	('127802', '1278', 'Gunungsitoli Selatan'),
	('127803', '1278', 'Gunungsitoli Utara'),
	('127804', '1278', 'Gunungsitoli Idanoi'),
	('127805', '1278', 'Gunungsitoli Alo\'oa'),
	('127806', '1278', 'Gunungsitoli Barat'),
	('130101', '1301', 'Pancung Soal'),
	('130102', '1301', 'Ranah Pesisir'),
	('130103', '1301', 'Lengayang'),
	('130104', '1301', 'Batang Kapas'),
	('130105', '1301', 'IV Jurai'),
	('130106', '1301', 'Bayang'),
	('130107', '1301', 'Koto XI Tarusan'),
	('130108', '1301', 'Sutera'),
	('130109', '1301', 'Linggo Sari Baganti'),
	('130110', '1301', 'Lunang'),
	('130111', '1301', 'Basa Ampek Balai Tapan'),
	('130112', '1301', 'IV Nagari Bayang Utara'),
	('130113', '1301', 'Airpura'),
	('130114', '1301', 'Ranah Ampek Hulu Tapan'),
	('130115', '1301', 'Silaut'),
	('130203', '1302', 'Pantai Cermin'),
	('130204', '1302', 'Lembah Gumanti'),
	('130205', '1302', 'Payung Sekaki'),
	('130206', '1302', 'Lembang Jaya'),
	('130207', '1302', 'Gunung Talang'),
	('130208', '1302', 'Bukit Sundi'),
	('130209', '1302', 'IX Koto Sungai Lasi'),
	('130210', '1302', 'Kubung'),
	('130211', '1302', 'X Koto Singkarak'),
	('130212', '1302', 'X Koto Diatas'),
	('130213', '1302', 'Junjung Sirih'),
	('130217', '1302', 'Hiliran Gumanti'),
	('130218', '1302', 'Tigo Lurah'),
	('130219', '1302', 'Danau Kembar'),
	('130303', '1303', 'Tanjung Gadang'),
	('130304', '1303', 'Sijunjung'),
	('130305', '1303', 'IV Nagari'),
	('130306', '1303', 'Kamang Baru'),
	('130307', '1303', 'Lubuak Tarok'),
	('130308', '1303', 'Koto VII'),
	('130309', '1303', 'Sumpur Kudus'),
	('130310', '1303', 'Kupitan'),
	('130401', '1304', 'X Koto'),
	('130402', '1304', 'Batipuh'),
	('130403', '1304', 'Rambatan'),
	('130404', '1304', 'Lima Kaum'),
	('130405', '1304', 'Tanjung Emas'),
	('130406', '1304', 'Lintau Buo'),
	('130407', '1304', 'Sungayang'),
	('130408', '1304', 'Sungai Tarab'),
	('130409', '1304', 'Pariangan'),
	('130410', '1304', 'Salimpauang'),
	('130411', '1304', 'Padang Ganting'),
	('130412', '1304', 'Tanjuang Baru'),
	('130413', '1304', 'Lintau Buo Utara'),
	('130414', '1304', 'Batipuah Selatan'),
	('130501', '1305', 'Lubuk Alung'),
	('130502', '1305', 'Batang Anai'),
	('130503', '1305', 'Nan Sabaris'),
	('130504', '1305', 'x Enam Lingkuang'),
	('130505', '1305', 'VII Koto Sungai Sarik'),
	('130506', '1305', 'V Koto Kampung Dalam'),
	('130507', '1305', 'Sungai Garingging'),
	('130508', '1305', 'Sungai Limau'),
	('130509', '1305', 'IV Koto Aur Malintang'),
	('130510', '1305', 'Ulakan Tapakih'),
	('130511', '1305', 'Sintuak Toboh Gadang'),
	('130512', '1305', 'Padang Sago'),
	('130513', '1305', 'Batang Gasan'),
	('130514', '1305', 'V Koto Timur'),
	('130515', '1305', 'x Kayu Tanam'),
	('130516', '1305', 'Patamuan'),
	('130517', '1305', 'Enam Lingkung'),
	('130601', '1306', 'Tanjung Mutiara'),
	('130602', '1306', 'Lubuk Basung'),
	('130603', '1306', 'Tanjung Raya'),
	('130604', '1306', 'Matur'),
	('130605', '1306', 'IV Koto'),
	('130606', '1306', 'Banuhampu'),
	('130607', '1306', 'Ampek Angkek'),
	('130608', '1306', 'Baso'),
	('130609', '1306', 'Tilatang Kamang'),
	('130610', '1306', 'Palupuh'),
	('130611', '1306', 'Pelembayan'),
	('130612', '1306', 'Sungai Pua'),
	('130613', '1306', 'Ampek Nagari'),
	('130614', '1306', 'Candung'),
	('130615', '1306', 'Kamang Magek'),
	('130616', '1306', 'Malalak'),
	('130701', '1307', 'Suliki'),
	('130702', '1307', 'Guguak'),
	('130703', '1307', 'Payakumbuh'),
	('130704', '1307', 'Luak'),
	('130705', '1307', 'Harau'),
	('130706', '1307', 'Pangkalan Koto Baru'),
	('130707', '1307', 'Kapur IX'),
	('130708', '1307', 'Gunuang Omeh'),
	('130709', '1307', 'Lareh Sago Halaban'),
	('130710', '1307', 'Situjuah Limo Nagari'),
	('130711', '1307', 'Mungka'),
	('130712', '1307', 'Bukik Barisan'),
	('130713', '1307', 'Akabiluru'),
	('130804', '1308', 'Bonjol'),
	('130805', '1308', 'Lubuk Sikaping'),
	('130807', '1308', 'Panti'),
	('130808', '1308', 'Mapat Tunggul'),
	('130812', '1308', 'Duo Koto'),
	('130813', '1308', 'Tigo Nagari'),
	('130814', '1308', 'Rao'),
	('130815', '1308', 'Mapat Tunggul Selatan'),
	('130816', '1308', 'Simpang Alahan Mati'),
	('130817', '1308', 'Padang Gelugur'),
	('130818', '1308', 'Rao Utara'),
	('130819', '1308', 'Rao Selatan'),
	('130901', '1309', 'Pagai Utara'),
	('130902', '1309', 'Sipora Selatan'),
	('130903', '1309', 'Siberut Selatan'),
	('130904', '1309', 'Siberut Utara'),
	('130905', '1309', 'Siberut Barat'),
	('130906', '1309', 'Siberut Barat Daya'),
	('130907', '1309', 'Siberut Tengah'),
	('130908', '1309', 'Sipora Utara'),
	('130909', '1309', 'Sikakap'),
	('130910', '1309', 'Pagai Selatan'),
	('131001', '1310', 'Koto Baru'),
	('131002', '1310', 'Pulau Punjung'),
	('131003', '1310', 'Sungai Rumbai'),
	('131004', '1310', 'Sitiung'),
	('131005', '1310', 'Sembilan Koto'),
	('131006', '1310', 'Timpeh'),
	('131007', '1310', 'Koto Salak'),
	('131008', '1310', 'Tiumang'),
	('131009', '1310', 'Padang Laweh'),
	('131010', '1310', 'Asam Jujuhan'),
	('131011', '1310', 'Koto Besar'),
	('131101', '1311', 'Sangir'),
	('131102', '1311', 'Sungai Pagu'),
	('131103', '1311', 'Koto Parik Gadang Diateh'),
	('131104', '1311', 'Sangir Jujuan'),
	('131105', '1311', 'Sangir Batang Hari'),
	('131106', '1311', 'Pauh Duo'),
	('131107', '1311', 'Sangir Balai Janggo'),
	('131201', '1312', 'Sungaiberemas'),
	('131202', '1312', 'Lembah Melintang'),
	('131203', '1312', 'Pasaman'),
	('131204', '1312', 'Talamau'),
	('131205', '1312', 'Kinali'),
	('131206', '1312', 'Gunungtuleh'),
	('131207', '1312', 'Ranah Batahan'),
	('131208', '1312', 'Koto Balingka'),
	('131209', '1312', 'Sungaiaur'),
	('131210', '1312', 'Luhak Nan Duo'),
	('131211', '1312', 'Sasak Ranah Pesisir'),
	('137101', '1371', 'Padang Selatan'),
	('137102', '1371', 'Padang Timur'),
	('137103', '1371', 'Padang Barat'),
	('137104', '1371', 'Padang Utara'),
	('137105', '1371', 'Bungus Teluk Kabung'),
	('137106', '1371', 'Lubuk Begalung'),
	('137107', '1371', 'Lubuk Kilangan'),
	('137108', '1371', 'Pauh'),
	('137109', '1371', 'Kuranji'),
	('137110', '1371', 'Nanggalo'),
	('137111', '1371', 'Koto Tangah'),
	('137201', '1372', 'Lubuk Sikarah'),
	('137202', '1372', 'Tanjung Harapan'),
	('137301', '1373', 'Lembah Segar'),
	('137302', '1373', 'Barangin'),
	('137303', '1373', 'Silungkang'),
	('137304', '1373', 'Talawi'),
	('137401', '1374', 'Padang Panjang Timur'),
	('137402', '1374', 'Padang Panjang Barat'),
	('137501', '1375', 'Guguak Panjang'),
	('137502', '1375', 'Mandiangin K. Selayan'),
	('137503', '1375', 'Aur Birugo Tigo Baleh'),
	('137601', '1376', 'Payakumbuh Barat'),
	('137602', '1376', 'Payakumbuh Utara'),
	('137603', '1376', 'Payakumbuh Timur'),
	('137604', '1376', 'Lamposi Tigo Nagori'),
	('137605', '1376', 'Payakumbuh Selatan'),
	('137701', '1377', 'Pariaman Tengah'),
	('137702', '1377', 'Pariaman Utara'),
	('137703', '1377', 'Pariaman Selatan'),
	('137704', '1377', 'Pariaman Timur'),
	('140101', '1401', 'Bangkinang Kota'),
	('140102', '1401', 'Kampar'),
	('140103', '1401', 'Tambang'),
	('140104', '1401', 'XIII Koto Kampar'),
	('140105', '1401', 'Kuok'),
	('140106', '1401', 'Siak Hulu'),
	('140107', '1401', 'Kampar Kiri'),
	('140108', '1401', 'Kampar Kiri Hilir'),
	('140109', '1401', 'Kampar Kiri Hulu'),
	('140110', '1401', 'Tapung'),
	('140111', '1401', 'Tapung Hilir'),
	('140112', '1401', 'Tapung Hulu'),
	('140113', '1401', 'Salo'),
	('140114', '1401', 'Rumbio Jaya'),
	('140115', '1401', 'Bangkinang'),
	('140116', '1401', 'Perhentian Raja'),
	('140117', '1401', 'Kampar Timur'),
	('140118', '1401', 'Kampar Utara'),
	('140119', '1401', 'Kampar Kiri Tengah'),
	('140120', '1401', 'Gunung Sahilan'),
	('140121', '1401', 'Koto Kampar Hulu'),
	('140201', '1402', 'Rengat'),
	('140202', '1402', 'Rengat Barat'),
	('140203', '1402', 'Kelayang'),
	('140204', '1402', 'Pasir Penyu'),
	('140205', '1402', 'Peranap'),
	('140206', '1402', 'Siberida'),
	('140207', '1402', 'Batang Cenaku'),
	('140208', '1402', 'Batang Gangsal'),
	('140209', '1402', 'Lirik'),
	('140210', '1402', 'Kuala Cenaku'),
	('140211', '1402', 'Sungai Lala'),
	('140212', '1402', 'Lubuk Batu Jaya'),
	('140213', '1402', 'Rakit Kulim'),
	('140214', '1402', 'Batang Peranap'),
	('140301', '1403', 'Bengkalis'),
	('140302', '1403', 'Bantan'),
	('140303', '1403', 'Bukit Batu'),
	('140309', '1403', 'Mandau'),
	('140310', '1403', 'Rupat'),
	('140311', '1403', 'Rupat Utara'),
	('140312', '1403', 'Siak Kecil'),
	('140313', '1403', 'Pinggir'),
	('140401', '1404', 'Reteh'),
	('140402', '1404', 'Enok'),
	('140403', '1404', 'Kuala Indragiri'),
	('140404', '1404', 'Tembilahan'),
	('140405', '1404', 'Tempuling'),
	('140406', '1404', 'Gaung Anak Serka'),
	('140407', '1404', 'Mandah'),
	('140408', '1404', 'Kateman'),
	('140409', '1404', 'Keritang'),
	('140410', '1404', 'Tanah Merah'),
	('140411', '1404', 'Batang Tuaka'),
	('140412', '1404', 'Gaung'),
	('140413', '1404', 'Tembilahan Hulu'),
	('140414', '1404', 'Kemuning'),
	('140415', '1404', 'Pelangiran'),
	('140416', '1404', 'Teluk Belengkong'),
	('140417', '1404', 'Pulau Burung'),
	('140418', '1404', 'Concong'),
	('140419', '1404', 'Kempas'),
	('140420', '1404', 'Sungai Batang'),
	('140501', '1405', 'Ukui'),
	('140502', '1405', 'Pangkalan Kerinci'),
	('140503', '1405', 'Pangkalan Kuras'),
	('140504', '1405', 'Pangkalan Lesung'),
	('140505', '1405', 'Langgam'),
	('140506', '1405', 'Pelalawan'),
	('140507', '1405', 'Kerumutan'),
	('140508', '1405', 'Bunut'),
	('140509', '1405', 'Teluk Meranti'),
	('140510', '1405', 'Kuala Kampar'),
	('140511', '1405', 'Bandar Sei Kijang'),
	('140512', '1405', 'Bandar Petalangan'),
	('140601', '1406', 'Ujung Batu'),
	('140602', '1406', 'Rokan IV Koto'),
	('140603', '1406', 'Rambah'),
	('140604', '1406', 'Tambusai'),
	('140605', '1406', 'Kepenuhan'),
	('140606', '1406', 'Kunto Darussalam'),
	('140607', '1406', 'Rambah Samo'),
	('140608', '1406', 'Rambah Hilir'),
	('140609', '1406', 'Tambusai Utara'),
	('140610', '1406', 'Bangun Purba'),
	('140611', '1406', 'Tandun'),
	('140612', '1406', 'Kabun'),
	('140613', '1406', 'Bonai Darussalam'),
	('140614', '1406', 'Pagaran Tapah Darussalam'),
	('140615', '1406', 'Kepenuhan Hulu'),
	('140616', '1406', 'Pendalian IV Koto'),
	('140701', '1407', 'Kubu'),
	('140702', '1407', 'Bangko'),
	('140703', '1407', 'Tanah Putih'),
	('140704', '1407', 'Rimba Melintang'),
	('140705', '1407', 'Bagan Sinembah'),
	('140706', '1407', 'Pasir Limau Kapas'),
	('140707', '1407', 'Sinaboi'),
	('140708', '1407', 'Pujud'),
	('140709', '1407', 'Tanah Putih Tanjung Melawan'),
	('140710', '1407', 'Bangko Pusako'),
	('140711', '1407', 'Simpang Kanan'),
	('140712', '1407', 'Batu Hampar'),
	('140713', '1407', 'Rantau Kopar'),
	('140714', '1407', 'Pekaitan'),
	('140715', '1407', 'Kubu Babussalam'),
	('140801', '1408', 'Siak'),
	('140802', '1408', 'Sungai Apit'),
	('140803', '1408', 'Minas'),
	('140804', '1408', 'Tualang'),
	('140805', '1408', 'Sungai Mandau'),
	('140806', '1408', 'Dayun'),
	('140807', '1408', 'Kerinci Kanan'),
	('140808', '1408', 'Bunga Raya'),
	('140809', '1408', 'Koto Gasib'),
	('140810', '1408', 'Kandis'),
	('140811', '1408', 'Lubuk Dalam'),
	('140812', '1408', 'Sabak Auh'),
	('140813', '1408', 'Mempura'),
	('140814', '1408', 'Pusako'),
	('140901', '1409', 'Kuantan Mudik'),
	('140902', '1409', 'Kuantan Tengah'),
	('140903', '1409', 'Singingi'),
	('140904', '1409', 'Kuantan Hilir'),
	('140905', '1409', 'Cerenti'),
	('140906', '1409', 'Benai'),
	('140907', '1409', 'Gunungtoar'),
	('140908', '1409', 'Singingi Hilir'),
	('140909', '1409', 'Pangean'),
	('140910', '1409', 'Logas Tanah Darat'),
	('140911', '1409', 'Inuman'),
	('140912', '1409', 'Hulu Kuantan'),
	('140913', '1409', 'Kuantan Hilir Seberang'),
	('140914', '1409', 'Sentajo Raya'),
	('140915', '1409', 'Pucuk Rantau'),
	('141001', '1410', 'Tebing Tinggi'),
	('141002', '1410', 'Rangsang Barat'),
	('141003', '1410', 'Rangsang'),
	('141004', '1410', 'Tebing Tinggi Barat'),
	('141005', '1410', 'Merbau'),
	('141006', '1410', 'Pulaumerbau'),
	('141007', '1410', 'Tebing Tinggi Timur'),
	('141008', '1410', 'Tasik Putri Puyu'),
	('141009', '1410', 'Rangsang Pesisir'),
	('147101', '1471', 'Sukajadi'),
	('147102', '1471', 'Pekanbaru Kota'),
	('147103', '1471', 'Sail'),
	('147104', '1471', 'Lima Puluh'),
	('147105', '1471', 'Senapelan'),
	('147106', '1471', 'Rumbai'),
	('147107', '1471', 'Bukit Raya'),
	('147108', '1471', 'Tampan'),
	('147109', '1471', 'Marpoyan Damai'),
	('147110', '1471', 'Tenayan Raya'),
	('147111', '1471', 'Payung Sekaki'),
	('147112', '1471', 'Rumbai Pesisir'),
	('147201', '1472', 'Dumai Barat'),
	('147202', '1472', 'Dumai Timur'),
	('147203', '1472', 'Bukit Kapur'),
	('147204', '1472', 'Sungai Sembilan'),
	('147205', '1472', 'Medang Kampai'),
	('147206', '1472', 'Dumai Kota'),
	('147207', '1472', 'Dumai Selatan'),
	('150101', '1501', 'Gunung Raya'),
	('150102', '1501', 'Danau Kerinci'),
	('150104', '1501', 'Sitinjau Laut'),
	('150105', '1501', 'Air Hangat'),
	('150106', '1501', 'Gunung Kerinci'),
	('150107', '1501', 'Batang Merangin'),
	('150108', '1501', 'Keliling Danau'),
	('150109', '1501', 'Kayu Aro'),
	('150111', '1501', 'Air Hangat Timur'),
	('150115', '1501', 'Gunung Tujuh'),
	('150116', '1501', 'Siulak'),
	('150117', '1501', 'Depati Tujuh'),
	('150118', '1501', 'Siulak Mukai'),
	('150119', '1501', 'Kayu Aro Barat'),
	('150120', '1501', 'Bukitkerman'),
	('150121', '1501', 'Air Hangat Barat'),
	('150201', '1502', 'Jangkat'),
	('150202', '1502', 'Bangko'),
	('150203', '1502', 'Muara Siau'),
	('150204', '1502', 'Sungai Manau'),
	('150205', '1502', 'Tabir'),
	('150206', '1502', 'Pamenang'),
	('150207', '1502', 'Tabir Ulu'),
	('150208', '1502', 'Tabir Selatan'),
	('150209', '1502', 'Lembah Masurai'),
	('150210', '1502', 'Bangko Barat'),
	('150211', '1502', 'Nalo Tatan'),
	('150212', '1502', 'Batang Masumai'),
	('150213', '1502', 'Pamenang Barat'),
	('150214', '1502', 'Tabir Ilir'),
	('150215', '1502', 'Tabir Timur'),
	('150216', '1502', 'Renah Pembarap'),
	('150217', '1502', 'Pangkalan Jambu'),
	('150218', '1502', 'Sungai Tenang'),
	('150219', '1502', 'Renah Pamenang'),
	('150220', '1502', 'Pamenang Selatan'),
	('150221', '1502', 'Margo Tabir'),
	('150222', '1502', 'Tabir Lintas'),
	('150223', '1502', 'Tabir Barat'),
	('150224', '1502', 'Tiang Pumpung'),
	('150301', '1503', 'Batang Asai'),
	('150302', '1503', 'Limun'),
	('150303', '1503', 'Sarolangun'),
	('150304', '1503', 'Pauh'),
	('150305', '1503', 'Pelawan'),
	('150306', '1503', 'Mandiangin'),
	('150307', '1503', 'Air Hitam'),
	('150308', '1503', 'Bathin VIII'),
	('150309', '1503', 'Singkut'),
	('150310', '1503', 'Cermin Nan Gedang'),
	('150401', '1504', 'Mersam'),
	('150402', '1504', 'Muara Tembesi'),
	('150403', '1504', 'Muara Bulian'),
	('150404', '1504', 'Batin XXIV'),
	('150405', '1504', 'Pemayung'),
	('150406', '1504', 'Maro Sebo Ulu'),
	('150407', '1504', 'Bajubang'),
	('150408', '1504', 'Maro Sebo Ilir'),
	('150501', '1505', 'Jambi Luar Kota'),
	('150502', '1505', 'Sekernan'),
	('150503', '1505', 'Kumpeh'),
	('150504', '1505', 'Maro Sebo'),
	('150505', '1505', 'Mestong'),
	('150506', '1505', 'Kumpeh Ulu'),
	('150507', '1505', 'Sungai Bahar'),
	('150508', '1505', 'Sungai Gelam'),
	('150509', '1505', 'Bahar Utara'),
	('150510', '1505', 'Bahar Selatan'),
	('150511', '1505', 'Taman Rajo'),
	('150601', '1506', 'Tungkal Ulu'),
	('150602', '1506', 'Tungkal Ilir'),
	('150603', '1506', 'Pengabuan'),
	('150604', '1506', 'Betara'),
	('150605', '1506', 'Merlung'),
	('150606', '1506', 'Tebing Tinggi'),
	('150607', '1506', 'Batang Asam'),
	('150608', '1506', 'Renah Mendaluh'),
	('150609', '1506', 'Muara Papalik'),
	('150610', '1506', 'Seberang Kota'),
	('150611', '1506', 'Bram Itam'),
	('150612', '1506', 'Kuala Betara'),
	('150613', '1506', 'Senyerang'),
	('150701', '1507', 'Muara Sabak Timur'),
	('150702', '1507', 'Nipah Panjang'),
	('150703', '1507', 'Mendahara'),
	('150704', '1507', 'Rantau Rasau'),
	('150705', '1507', 'S a d u'),
	('150706', '1507', 'Dendang'),
	('150707', '1507', 'Muara Sabak Barat'),
	('150708', '1507', 'Kuala Jambi'),
	('150709', '1507', 'Mendahara Ulu'),
	('150710', '1507', 'Geragai'),
	('150711', '1507', 'Berbak'),
	('150801', '1508', 'Tanah Tumbuh'),
	('150802', '1508', 'Rantau Pandan'),
	('150803', '1508', 'Pasar Muaro Bungo'),
	('150804', '1508', 'Jujuhan'),
	('150805', '1508', 'Tanah Sepenggal'),
	('150806', '1508', 'Pelepat'),
	('150807', '1508', 'Limbur Lubuk Mengkuang'),
	('150808', '1508', 'Muko-muko Bathin VII'),
	('150809', '1508', 'Pelepat Ilir'),
	('150810', '1508', 'Batin II Babeko'),
	('150811', '1508', 'Bathin III'),
	('150812', '1508', 'Bungo Dani'),
	('150813', '1508', 'Rimbo Tengah'),
	('150814', '1508', 'Bathin III Ulu'),
	('150815', '1508', 'Bathin II Pelayang'),
	('150816', '1508', 'Jujuhan Ilir'),
	('150817', '1508', 'Tanah Sepenggal Lintas'),
	('150901', '1509', 'Tebo Tengah'),
	('150902', '1509', 'Tebo Ilir'),
	('150903', '1509', 'Tebo Ulu'),
	('150904', '1509', 'Rimbo Bujang'),
	('150905', '1509', 'Sumay'),
	('150906', '1509', 'VII Koto'),
	('150907', '1509', 'Rimbo Ulu'),
	('150908', '1509', 'Rimbo Ilir'),
	('150909', '1509', 'Tengah Ilir'),
	('150910', '1509', 'Serai Serumpun'),
	('150911', '1509', 'VII Koto Ilir'),
	('150912', '1509', 'Muara Tabir'),
	('157101', '1571', 'Telanaipura'),
	('157102', '1571', 'Jambi Selatan'),
	('157103', '1571', 'Jambi Timur'),
	('157104', '1571', 'Pasar Jambi'),
	('157105', '1571', 'Pelayangan'),
	('157106', '1571', 'Danau Teluk'),
	('157107', '1571', 'Kota Baru'),
	('157108', '1571', 'Jelutung'),
	('157201', '1572', 'Sungai Penuh'),
	('157202', '1572', 'Pesisir Bukit'),
	('157203', '1572', 'Hamparan Rawang'),
	('157204', '1572', 'Tanah Kampung'),
	('157205', '1572', 'Kumun Debai'),
	('157206', '1572', 'Pondok Tinggi'),
	('157207', '1572', 'Koto Baru'),
	('157208', '1572', 'Sungai Bungkal'),
	('160107', '1601', 'Sosoh Buay Rayap'),
	('160108', '1601', 'Pengandonan'),
	('160109', '1601', 'Peninjauan'),
	('160113', '1601', 'Baturaja Barat'),
	('160114', '1601', 'Baturaja Timur'),
	('160120', '1601', 'Ulu Ogan'),
	('160121', '1601', 'Semidang Aji'),
	('160122', '1601', 'Lubuk Batang'),
	('160128', '1601', 'Lengkiti'),
	('160129', '1601', 'Sinar Peninjauan'),
	('160130', '1601', 'Lubuk Raja'),
	('160131', '1601', 'Muara Jaya'),
	('160202', '1602', 'Tanjung Lubuk'),
	('160203', '1602', 'Pedamaran'),
	('160204', '1602', 'Mesuji'),
	('160205', '1602', 'Kayu Agung'),
	('160208', '1602', 'Sirah Pulau Padang'),
	('160211', '1602', 'Tulung Selapan'),
	('160212', '1602', 'Pampangan'),
	('160213', '1602', 'Lempuing'),
	('160214', '1602', 'Air Sugihan'),
	('160215', '1602', 'Sungai Menang'),
	('160217', '1602', 'Jejawi'),
	('160218', '1602', 'Cengal'),
	('160219', '1602', 'Pangkalan Lampam'),
	('160220', '1602', 'Mesuji Makmur'),
	('160221', '1602', 'Mesuji Raya'),
	('160222', '1602', 'Lempuing Jaya'),
	('160223', '1602', 'Teluk Gelam'),
	('160224', '1602', 'Pedamaran Timur'),
	('160301', '1603', 'Tanjung Agung'),
	('160302', '1603', 'Muara Enim'),
	('160303', '1603', 'Rambang Dangku'),
	('160304', '1603', 'Gunung Megang'),
	('160306', '1603', 'Gelumbang'),
	('160307', '1603', 'Lawang Kidul'),
	('160308', '1603', 'Semende Darat Laut'),
	('160309', '1603', 'Semende Darat Tengah'),
	('160310', '1603', 'Semende Darat Ulu'),
	('160311', '1603', 'Ujan Mas'),
	('160314', '1603', 'Lubai'),
	('160315', '1603', 'Rambang'),
	('160316', '1603', 'Sungai Rotan'),
	('160317', '1603', 'Lembak'),
	('160319', '1603', 'Benakat'),
	('160321', '1603', 'Kelekar'),
	('160322', '1603', 'Muara Belida'),
	('160323', '1603', 'Belimbing'),
	('160324', '1603', 'Belida Darat'),
	('160325', '1603', 'Lubai Ulu'),
	('160401', '1604', 'Tanjungsakti Pumu'),
	('160406', '1604', 'Jarai'),
	('160407', '1604', 'Kota Agung'),
	('160408', '1604', 'Pulaupinang'),
	('160409', '1604', 'Merapi Barat'),
	('160410', '1604', 'Lahat'),
	('160412', '1604', 'Pajar Bulan'),
	('160415', '1604', 'Mulak Ulu'),
	('160416', '1604', 'Kikim Selatan'),
	('160417', '1604', 'Kikim Timur'),
	('160418', '1604', 'Kikim Tengah'),
	('160419', '1604', 'Kikim Barat'),
	('160420', '1604', 'Pseksu'),
	('160421', '1604', 'Gumay Talang'),
	('160422', '1604', 'Pagar Gunung'),
	('160423', '1604', 'Merapi Timur'),
	('160424', '1604', 'Tanjung Sakti Pumi'),
	('160425', '1604', 'Gumay Ulu'),
	('160426', '1604', 'Merapi Selatan'),
	('160427', '1604', 'Tanjungtebat'),
	('160428', '1604', 'Muarapayang'),
	('160429', '1604', 'Sukamerindu'),
	('160501', '1605', 'Tugumulyo'),
	('160502', '1605', 'Muara Lakitan'),
	('160503', '1605', 'Muara Kelingi'),
	('160508', '1605', 'Jayaloka'),
	('160509', '1605', 'Muara Beliti'),
	('160510', '1605', 'STL Ulu Terawas'),
	('160511', '1605', 'Selangit'),
	('160512', '1605', 'Megang Sakti'),
	('160513', '1605', 'Purwodadi'),
	('160514', '1605', 'BTS. Ulu'),
	('160518', '1605', 'Tiang Pumpung Kepungut'),
	('160519', '1605', 'Sumber Harta'),
	('160520', '1605', 'Tuah Negeri'),
	('160521', '1605', 'Suka Karya'),
	('160601', '1606', 'Sekayu'),
	('160602', '1606', 'Lais'),
	('160603', '1606', 'Sungai Keruh'),
	('160604', '1606', 'Batang Hari Leko'),
	('160605', '1606', 'Sanga Desa'),
	('160606', '1606', 'Babat Toman'),
	('160607', '1606', 'Sungai Lilin'),
	('160608', '1606', 'Keluang'),
	('160609', '1606', 'Bayung Lencir'),
	('160610', '1606', 'Plakat Tinggi'),
	('160611', '1606', 'Lalan'),
	('160612', '1606', 'Tungkal Jaya'),
	('160613', '1606', 'Lawang Wetan'),
	('160614', '1606', 'Babat Supat'),
	('160701', '1607', 'Banyuasin I'),
	('160702', '1607', 'Banyuasin II'),
	('160703', '1607', 'Banyuasin III'),
	('160704', '1607', 'Pulau Rimau'),
	('160705', '1607', 'Betung'),
	('160706', '1607', 'Rambutan'),
	('160707', '1607', 'Muara Padang'),
	('160708', '1607', 'Muara Telang'),
	('160709', '1607', 'Makarti Jaya'),
	('160710', '1607', 'Talang Kelapa'),
	('160711', '1607', 'Rantau Bayur'),
	('160712', '1607', 'Tanjung Lago'),
	('160713', '1607', 'Muara Sugihan'),
	('160714', '1607', 'Air Salek'),
	('160715', '1607', 'Tungkal Ilir'),
	('160716', '1607', 'Suak Tapeh'),
	('160717', '1607', 'Sembawa'),
	('160718', '1607', 'Sumber Marga Telang'),
	('160719', '1607', 'Air Kumbang'),
	('160801', '1608', 'Martapura'),
	('160802', '1608', 'Buay Madang'),
	('160803', '1608', 'Belitang'),
	('160804', '1608', 'Cempaka'),
	('160805', '1608', 'Buay Pemuka Peliung'),
	('160806', '1608', 'Madang Suku II'),
	('160807', '1608', 'Madang Suku I'),
	('160808', '1608', 'Semendawai Suku III'),
	('160809', '1608', 'Belitang II'),
	('160810', '1608', 'Belitang III'),
	('160811', '1608', 'Bunga Mayang'),
	('160812', '1608', 'Buay Madang Timur'),
	('160813', '1608', 'Madang Suku III'),
	('160814', '1608', 'Semendawai Barat'),
	('160815', '1608', 'Semendawai Timur'),
	('160816', '1608', 'Jayapura'),
	('160817', '1608', 'Belitang Jaya'),
	('160818', '1608', 'Belitang Madang Raya'),
	('160819', '1608', 'Belitang Mulya'),
	('160820', '1608', 'Buay Pemuka Bangsa Raja'),
	('160901', '1609', 'Muara Dua'),
	('160902', '1609', 'Pulau Beringin'),
	('160903', '1609', 'Banding Agung'),
	('160904', '1609', 'Muara Dua Kisam'),
	('160905', '1609', 'Simpang'),
	('160906', '1609', 'Buay Sandang Aji'),
	('160907', '1609', 'Buay Runjung'),
	('160908', '1609', 'Mekakau Ilir'),
	('160909', '1609', 'Buay Pemaca'),
	('160910', '1609', 'Kisam Tinggi'),
	('160911', '1609', 'Kisam Ilir'),
	('160912', '1609', 'Buay Pematang Ribu Ranau Tengah'),
	('160913', '1609', 'Warkuk Ranau Selatan'),
	('160914', '1609', 'Runjung Agung'),
	('160915', '1609', 'Sungai Are'),
	('160916', '1609', 'Sindang Danau'),
	('160917', '1609', 'Buana Pemaca'),
	('160918', '1609', 'Tiga Dihaji'),
	('160919', '1609', 'Buay Rawan'),
	('161001', '1610', 'Muara Kuang'),
	('161002', '1610', 'Tanjung Batu'),
	('161003', '1610', 'Tanjung Raja'),
	('161004', '1610', 'Indralaya'),
	('161005', '1610', 'Pemulutan'),
	('161006', '1610', 'Rantau Alai'),
	('161007', '1610', 'Indralaya Utara'),
	('161008', '1610', 'Indralaya Selatan'),
	('161009', '1610', 'Pemulutan Selatan'),
	('161010', '1610', 'Pemulutan Barat'),
	('161011', '1610', 'Rantau Panjang'),
	('161012', '1610', 'Sungai Pinang'),
	('161013', '1610', 'Kandis'),
	('161014', '1610', 'Rambang Kuang'),
	('161015', '1610', 'Lubuk Keliat'),
	('161016', '1610', 'Payaraman'),
	('161101', '1611', 'Muara Pinang'),
	('161102', '1611', 'Pendopo'),
	('161103', '1611', 'Ulu Musi'),
	('161104', '1611', 'Tebing Tinggi'),
	('161105', '1611', 'Lintang Kanan'),
	('161106', '1611', 'Talang Padang'),
	('161107', '1611', 'Pasemah Air Keruh'),
	('161108', '1611', 'Sikap Dalam'),
	('161109', '1611', 'Saling'),
	('161110', '1611', 'Pendopo Barat'),
	('161201', '1612', 'Talang Ubi'),
	('161202', '1612', 'Penukal Utara'),
	('161203', '1612', 'Penukal'),
	('161204', '1612', 'Abab'),
	('161205', '1612', 'Tanah Abang'),
	('161301', '1613', 'Rupit'),
	('161302', '1613', 'Rawas Ulu'),
	('161303', '1613', 'Nibung'),
	('161304', '1613', 'Rawas Ilir'),
	('161305', '1613', 'Karang Dapo'),
	('161306', '1613', 'Karang Jaya'),
	('161307', '1613', 'Ulu Rawas'),
	('167101', '1671', 'Ilir Barat II'),
	('167102', '1671', 'Seberang Ulu I'),
	('167103', '1671', 'Seberang Ulu II'),
	('167104', '1671', 'Ilir Barat I'),
	('167105', '1671', 'Ilir Timur I'),
	('167106', '1671', 'Ilir Timur II'),
	('167107', '1671', 'Sukarami'),
	('167108', '1671', 'Sako'),
	('167109', '1671', 'Kemuning'),
	('167110', '1671', 'Kalidoni'),
	('167111', '1671', 'Bukit Kecil'),
	('167112', '1671', 'Gandus'),
	('167113', '1671', 'Kertapati'),
	('167114', '1671', 'Plaju'),
	('167115', '1671', 'Alang-alang Lebar'),
	('167116', '1671', 'Sematang Borang'),
	('167201', '1672', 'Pagar Alam Utara'),
	('167202', '1672', 'Pagar Alam Selatan'),
	('167203', '1672', 'Dempo Utara'),
	('167204', '1672', 'Dempo Selatan'),
	('167205', '1672', 'Dempo Tengah'),
	('167301', '1673', 'Lubuk Linggau Timur I'),
	('167302', '1673', 'Lubuk Linggau Barat I'),
	('167303', '1673', 'Lubuk Linggau Selatan I'),
	('167304', '1673', 'Lubuk Linggau Utara I'),
	('167305', '1673', 'Lubuk Linggau Timur II'),
	('167306', '1673', 'Lubuk Linggau Barat II'),
	('167307', '1673', 'Lubuk Linggau Selatan II'),
	('167308', '1673', 'Lubuk Linggau Utara II'),
	('167401', '1674', 'Prabumulih Barat'),
	('167402', '1674', 'Prabumulih Timur'),
	('167403', '1674', 'Cambai'),
	('167404', '1674', 'Rambang Kpk Tengah'),
	('167405', '1674', 'Prabumulih Utara'),
	('167406', '1674', 'Prabumulih Selatan'),
	('170101', '1701', 'Kedurang'),
	('170102', '1701', 'Seginim'),
	('170103', '1701', 'Pino'),
	('170104', '1701', 'Manna'),
	('170105', '1701', 'Kota Manna'),
	('170106', '1701', 'Pino Raya'),
	('170107', '1701', 'Kedurang Ilir'),
	('170108', '1701', 'Air Nipis'),
	('170109', '1701', 'Ulu Manna'),
	('170110', '1701', 'Bunga Mas'),
	('170111', '1701', 'Pasar Manna'),
	('170206', '1702', 'Kota Padang'),
	('170207', '1702', 'Padang Ulak Tanding'),
	('170208', '1702', 'Sindang Kelingi'),
	('170209', '1702', 'Curup'),
	('170210', '1702', 'Bermani Ulu'),
	('170211', '1702', 'Selupu Rejang'),
	('170216', '1702', 'Curup Utara'),
	('170217', '1702', 'Curup Timur'),
	('170218', '1702', 'Curup Selatan'),
	('170219', '1702', 'Curup Tengah'),
	('170220', '1702', 'Binduriang'),
	('170221', '1702', 'Sindang Beliti Ulu'),
	('170222', '1702', 'Sindang Dataran'),
	('170223', '1702', 'Sindang Beliti Ilir'),
	('170224', '1702', 'Bermani Ulu Raya'),
	('170301', '1703', 'Enggano'),
	('170306', '1703', 'Kerkap'),
	('170307', '1703', 'Kota Arga Makmur'),
	('170308', '1703', 'Giri Mulya'),
	('170309', '1703', 'Padang Jaya'),
	('170310', '1703', 'Lais'),
	('170311', '1703', 'Batik Nau'),
	('170312', '1703', 'Ketahun'),
	('170313', '1703', 'Napal Putih'),
	('170314', '1703', 'Putri Hijau'),
	('170315', '1703', 'Air Besi'),
	('170316', '1703', 'Air Napal'),
	('170319', '1703', 'Hulu Palik'),
	('170320', '1703', 'Air Padang'),
	('170321', '1703', 'Arma Jaya'),
	('170322', '1703', 'Tanjung Agung Palik'),
	('170323', '1703', 'Ulok Kupai'),
	('170401', '1704', 'Kinal'),
	('170402', '1704', 'Tanjung Kemuning'),
	('170403', '1704', 'Kaur Utara'),
	('170404', '1704', 'Kaur Tengah'),
	('170405', '1704', 'Kaur Selatan'),
	('170406', '1704', 'Maje'),
	('170407', '1704', 'Nasal'),
	('170408', '1704', 'Semidang Gumay'),
	('170409', '1704', 'Kelam Tengah'),
	('170410', '1704', 'Luas'),
	('170411', '1704', 'Muara Sahung'),
	('170412', '1704', 'Tetap'),
	('170413', '1704', 'Lungkang Kule'),
	('170414', '1704', 'Padang Guci Hilir'),
	('170415', '1704', 'Padang Guci Hulu'),
	('170501', '1705', 'Sukaraja'),
	('170502', '1705', 'Seluma'),
	('170503', '1705', 'Talo'),
	('170504', '1705', 'Semidang Alas'),
	('170505', '1705', 'Semidang Alas Maras'),
	('170506', '1705', 'Air Periukan'),
	('170507', '1705', 'Lubuk Sandi'),
	('170508', '1705', 'Seluma Barat'),
	('170509', '1705', 'Seluma Timur'),
	('170510', '1705', 'Seluma Utara'),
	('170511', '1705', 'Seluma Selatan'),
	('170512', '1705', 'Talo Kecil'),
	('170513', '1705', 'Ulu Talo'),
	('170514', '1705', 'Ilir Talo'),
	('170601', '1706', 'Lubuk Pinang'),
	('170602', '1706', 'Kota Mukomuko'),
	('170603', '1706', 'Teras Terunjam'),
	('170604', '1706', 'Pondok Suguh'),
	('170605', '1706', 'Ipuh'),
	('170606', '1706', 'Malin Deman'),
	('170607', '1706', 'Air Rami'),
	('170608', '1706', 'Teramang Jaya'),
	('170609', '1706', 'Selagan Raya'),
	('170610', '1706', 'Penarik'),
	('170611', '1706', 'XIV Koto'),
	('170612', '1706', 'V Koto'),
	('170613', '1706', 'Air Majunto'),
	('170614', '1706', 'Air Dikit'),
	('170615', '1706', 'Sungai Rumbai'),
	('170701', '1707', 'Lebong Utara'),
	('170702', '1707', 'Lebong Atas'),
	('170703', '1707', 'Lebong Tengah'),
	('170704', '1707', 'Lebong Selatan'),
	('170705', '1707', 'Rimbo Pengadang'),
	('170706', '1707', 'Topos'),
	('170707', '1707', 'Bingin Kuning'),
	('170708', '1707', 'Lebong Sakti'),
	('170709', '1707', 'Pelabai'),
	('170710', '1707', 'Amen'),
	('170711', '1707', 'Uram Jaya'),
	('170712', '1707', 'Pinang Belapis'),
	('170801', '1708', 'Bermani Ilir'),
	('170802', '1708', 'Ujan Mas'),
	('170803', '1708', 'Tebat Karai'),
	('170804', '1708', 'Kepahiang'),
	('170805', '1708', 'Merigi'),
	('170806', '1708', 'Kebawetan'),
	('170807', '1708', 'Seberang Musi'),
	('170808', '1708', 'Muara Kemumu'),
	('170901', '1709', 'Karang Tinggi'),
	('170902', '1709', 'Talang Empat'),
	('170903', '1709', 'Pondok Kelapa'),
	('170904', '1709', 'Pematang Tiga'),
	('170905', '1709', 'Pagar Jati'),
	('170906', '1709', 'Taba Penanjung'),
	('170907', '1709', 'Merigi Kelindang'),
	('170908', '1709', 'Merigi Sakti'),
	('170909', '1709', 'Pondok Kubang'),
	('170910', '1709', 'Bang Haji'),
	('177101', '1771', 'Selebar'),
	('177102', '1771', 'Gading Cempaka'),
	('177103', '1771', 'Teluk Segara'),
	('177104', '1771', 'Muara Bangka Hulu'),
	('177105', '1771', 'Kampung Melayu'),
	('177106', '1771', 'Ratu Agung'),
	('177107', '1771', 'Ratu Samban'),
	('177108', '1771', 'Sungai Serut'),
	('177109', '1771', 'Singaran Pati'),
	('180104', '1801', 'Natar'),
	('180105', '1801', 'Tanjung Bintang'),
	('180106', '1801', 'Kalianda'),
	('180107', '1801', 'Sidomulyo'),
	('180108', '1801', 'Katibung'),
	('180109', '1801', 'Penengahan'),
	('180110', '1801', 'Palas'),
	('180113', '1801', 'Jati Agung'),
	('180114', '1801', 'Ketapang'),
	('180115', '1801', 'Sragi'),
	('180116', '1801', 'Raja Basa'),
	('180117', '1801', 'Candipuro'),
	('180118', '1801', 'Merbau Mataram'),
	('180121', '1801', 'Bakauheni'),
	('180122', '1801', 'Tanjung Sari'),
	('180123', '1801', 'Way Sulan'),
	('180124', '1801', 'Way Panji'),
	('180201', '1802', 'Kalirejo'),
	('180202', '1802', 'Bangun Rejo'),
	('180203', '1802', 'Padang Ratu'),
	('180204', '1802', 'Gunung Sugih'),
	('180205', '1802', 'Trimurjo'),
	('180206', '1802', 'Punggur'),
	('180207', '1802', 'Terbanggi Besar'),
	('180208', '1802', 'Seputih Raman'),
	('180209', '1802', 'Rumbia'),
	('180210', '1802', 'Seputih Banyak'),
	('180211', '1802', 'Seputih Mataram'),
	('180212', '1802', 'Seputih Surabaya'),
	('180213', '1802', 'Terusan Nunyai'),
	('180214', '1802', 'Bumi Ratu Nuban'),
	('180215', '1802', 'Bekri'),
	('180216', '1802', 'Seputih Agung'),
	('180217', '1802', 'Way Pangubuan'),
	('180218', '1802', 'Bandar Mataram'),
	('180219', '1802', 'Pubian'),
	('180220', '1802', 'Selagai Lingga'),
	('180221', '1802', 'Anak Tuha'),
	('180222', '1802', 'Sendang Agung'),
	('180223', '1802', 'Kota Gajah'),
	('180224', '1802', 'Bumi Nabung'),
	('180225', '1802', 'Way Seputih'),
	('180226', '1802', 'Bandar Surabaya'),
	('180227', '1802', 'Anak Ratu Aji'),
	('180228', '1802', 'Putra Rumbia'),
	('180301', '1803', 'Bukit Kemuning'),
	('180302', '1803', 'Kotabumi'),
	('180303', '1803', 'Sungkai Selatan'),
	('180304', '1803', 'Tanjung Raja'),
	('180305', '1803', 'Abung Timur'),
	('180306', '1803', 'Abung Barat'),
	('180307', '1803', 'Abung Selatan'),
	('180308', '1803', 'Sungkai Utara'),
	('180309', '1803', 'Kotabumi Utara'),
	('180310', '1803', 'Kotabumi Selatan'),
	('180311', '1803', 'Abung Tengah'),
	('180312', '1803', 'Abung Tinggi'),
	('180313', '1803', 'Abung Semuli'),
	('180314', '1803', 'Abung Surakarta'),
	('180315', '1803', 'Muara Sungkai'),
	('180316', '1803', 'Bunga Mayang'),
	('180317', '1803', 'Hulu Sungkai'),
	('180318', '1803', 'Sungkai Tengah'),
	('180319', '1803', 'Abung Pekurun'),
	('180320', '1803', 'Sungkai Jaya'),
	('180321', '1803', 'Sungkai Barat'),
	('180322', '1803', 'Abung Kunang'),
	('180323', '1803', 'Blambangan Pagar'),
	('180404', '1804', 'Balik Bukit'),
	('180405', '1804', 'Sumber Jaya'),
	('180406', '1804', 'Belalau'),
	('180407', '1804', 'Way Tenong'),
	('180408', '1804', 'Sekincau'),
	('180409', '1804', 'Suoh'),
	('180410', '1804', 'Batu Brak'),
	('180411', '1804', 'Sukau'),
	('180415', '1804', 'Gedung Surian'),
	('180418', '1804', 'Kebun Tebu'),
	('180419', '1804', 'Air Hitam'),
	('180420', '1804', 'Pagar Dewa'),
	('180421', '1804', 'Batu Ketulis'),
	('180422', '1804', 'Lumbok Seminung'),
	('180423', '1804', 'Bandar Negeri Suoh'),
	('180502', '1805', 'Menggala'),
	('180506', '1805', 'Gedung Aji'),
	('180508', '1805', 'Banjar Agung'),
	('180511', '1805', 'Gedung Meneng'),
	('180512', '1805', 'Rawa Jitu Selatan'),
	('180513', '1805', 'Penawar Tama'),
	('180518', '1805', 'Rawa Jitu Timur'),
	('180520', '1805', 'Banjar Margo'),
	('180522', '1805', 'Rawa Pitu'),
	('180523', '1805', 'Penawar Aji'),
	('180525', '1805', 'Dente Teladas'),
	('180526', '1805', 'Meraksa Aji'),
	('180527', '1805', 'Gedung Aji Baru'),
	('180529', '1805', 'Banjar Baru'),
	('180530', '1805', 'Menggala Timur'),
	('180601', '1806', 'Kota Agung'),
	('180602', '1806', 'Talang Padang'),
	('180603', '1806', 'Wonosobo'),
	('180604', '1806', 'Pulau Panggung'),
	('180609', '1806', 'Cukuh Balak'),
	('180611', '1806', 'Pugung'),
	('180612', '1806', 'Semaka'),
	('180613', '1806', 'Sumber Rejo'),
	('180615', '1806', 'Ulu Belu'),
	('180616', '1806', 'Pematang Sawa'),
	('180617', '1806', 'Klumbayan'),
	('180618', '1806', 'Kota Agung Barat'),
	('180619', '1806', 'Kota Agung Timur'),
	('180620', '1806', 'Gisting'),
	('180621', '1806', 'Gunung Alip'),
	('180624', '1806', 'Limau'),
	('180625', '1806', 'Bandar Negeri Semuong'),
	('180626', '1806', 'Air Naningan'),
	('180627', '1806', 'Bulok'),
	('180628', '1806', 'Klumbayan Barat'),
	('180701', '1807', 'Sukadana'),
	('180702', '1807', 'Labuhan Maringgai'),
	('180703', '1807', 'Jabung'),
	('180704', '1807', 'Pekalongan'),
	('180705', '1807', 'Sekampung'),
	('180706', '1807', 'Batanghari'),
	('180707', '1807', 'Way Jepara'),
	('180708', '1807', 'Purbolinggo'),
	('180709', '1807', 'Raman Utara'),
	('180710', '1807', 'Metro Kibang'),
	('180711', '1807', 'Marga Tiga'),
	('180712', '1807', 'Sekampung Udik'),
	('180713', '1807', 'Batanghari Nuban'),
	('180714', '1807', 'Bumi Agung'),
	('180715', '1807', 'Bandar Sribhawono'),
	('180716', '1807', 'Mataram Baru'),
	('180717', '1807', 'Melinting'),
	('180718', '1807', 'Gunung Pelindung'),
	('180719', '1807', 'Pasir Sakti'),
	('180720', '1807', 'Waway Karya'),
	('180721', '1807', 'Labuhan Ratu'),
	('180722', '1807', 'Braja Selebah'),
	('180723', '1807', 'Way Bungur'),
	('180724', '1807', 'Marga Sekampung'),
	('180801', '1808', 'Blambangan Umpu'),
	('180802', '1808', 'Kasui'),
	('180803', '1808', 'Banjit'),
	('180804', '1808', 'Baradatu'),
	('180805', '1808', 'Bahuga'),
	('180806', '1808', 'Pakuan Ratu'),
	('180807', '1808', 'Negeri Agung'),
	('180808', '1808', 'Way Tuba'),
	('180809', '1808', 'Rebang Tangkas'),
	('180810', '1808', 'Gunung Labuhan'),
	('180811', '1808', 'Negara Batin'),
	('180812', '1808', 'Negeri Besar'),
	('180813', '1808', 'Buay Bahuga'),
	('180814', '1808', 'Bumi Agung'),
	('180901', '1809', 'Gedong Tataan'),
	('180902', '1809', 'Negeri Katon'),
	('180903', '1809', 'Tegineneng'),
	('180904', '1809', 'Way Lima'),
	('180905', '1809', 'Padang Cermin'),
	('180906', '1809', 'Punduh Pidada'),
	('180907', '1809', 'Kedondong'),
	('180908', '1809', 'Marga Punduh'),
	('180909', '1809', 'Way Khilau'),
	('181001', '1810', 'Pringsewu'),
	('181002', '1810', 'Gading Rejo'),
	('181003', '1810', 'Ambarawa'),
	('181004', '1810', 'Pardasuka'),
	('181005', '1810', 'Pagelaran'),
	('181006', '1810', 'Banyumas'),
	('181007', '1810', 'Adiluwih'),
	('181008', '1810', 'Sukoharjo'),
	('181009', '1810', 'Pagelaran Utara'),
	('181101', '1811', 'Mesuji'),
	('181102', '1811', 'Mesuji Timur'),
	('181103', '1811', 'Rawa Jitu Utara'),
	('181104', '1811', 'Way Serdang'),
	('181105', '1811', 'Simpang Pematang'),
	('181106', '1811', 'Panca Jaya'),
	('181107', '1811', 'Tanjung Raya'),
	('181201', '1812', 'Tulang Bawang Tengah'),
	('181202', '1812', 'Tumijajar'),
	('181203', '1812', 'Tulang Bawang Udik'),
	('181204', '1812', 'Gunung Terang'),
	('181205', '1812', 'Gunung Agung'),
	('181206', '1812', 'Way Kenanga'),
	('181207', '1812', 'Lambu Kibang'),
	('181208', '1812', 'Pagar Dewa'),
	('181301', '1813', 'Pesisir Tengah'),
	('181302', '1813', 'Pesisir Selatan'),
	('181303', '1813', 'Lemong'),
	('181304', '1813', 'Pesisir Utara'),
	('181305', '1813', 'Karya Penggawa'),
	('181306', '1813', 'Pulaupisang'),
	('181307', '1813', 'Way Krui'),
	('181308', '1813', 'Krui Selatan'),
	('181309', '1813', 'Ngambur'),
	('181310', '1813', 'Bengkunat'),
	('181311', '1813', 'Bengkunat Belimbing'),
	('187101', '1871', 'Kedaton'),
	('187102', '1871', 'Sukarame'),
	('187103', '1871', 'Tanjungkarang Barat'),
	('187104', '1871', 'Panjang'),
	('187105', '1871', 'Tanjungkarang Timur'),
	('187106', '1871', 'Tanjungkarang Pusat'),
	('187107', '1871', 'Telukbetung Selatan'),
	('187108', '1871', 'Telukbetung Barat'),
	('187109', '1871', 'Telukbetung Utara'),
	('187110', '1871', 'Rajabasa'),
	('187111', '1871', 'Tanjung Senang'),
	('187112', '1871', 'Sukabumi'),
	('187113', '1871', 'Kemiling'),
	('187114', '1871', 'Labuhan Ratu'),
	('187115', '1871', 'Way Halim'),
	('187116', '1871', 'Langkapura'),
	('187117', '1871', 'Enggal'),
	('187118', '1871', 'Kedamaian'),
	('187119', '1871', 'Telukbetung Timur'),
	('187120', '1871', 'Bumi Waras'),
	('187201', '1872', 'Metro Pusat'),
	('187202', '1872', 'Metro Utara'),
	('187203', '1872', 'Metro Barat'),
	('187204', '1872', 'Metro Timur'),
	('187205', '1872', 'Metro Selatan'),
	('190101', '1901', 'Sungailiat'),
	('190102', '1901', 'Belinyu'),
	('190103', '1901', 'Merawang'),
	('190104', '1901', 'Mendo Barat'),
	('190105', '1901', 'Pemali'),
	('190106', '1901', 'Bakam'),
	('190107', '1901', 'Riau Silip'),
	('190108', '1901', 'Puding Besar'),
	('190201', '1902', 'Tanjung Pandan'),
	('190202', '1902', 'Membalong'),
	('190203', '1902', 'Selat Nasik'),
	('190204', '1902', 'Sijuk'),
	('190205', '1902', 'Badau'),
	('190301', '1903', 'Toboali'),
	('190302', '1903', 'Lepar Pongok'),
	('190303', '1903', 'Air Gegas'),
	('190304', '1903', 'Simpang Rimba'),
	('190305', '1903', 'Payung'),
	('190306', '1903', 'Tukak Sadai'),
	('190307', '1903', 'Pulaubesar'),
	('190308', '1903', 'Kepulauan Pongok'),
	('190401', '1904', 'Koba'),
	('190402', '1904', 'Pangkalan Baru'),
	('190403', '1904', 'Sungai Selan'),
	('190404', '1904', 'Simpang Katis'),
	('190405', '1904', 'Namang'),
	('190406', '1904', 'Lubuk Besar'),
	('190501', '1905', 'Mentok'),
	('190502', '1905', 'Simpang Teritip'),
	('190503', '1905', 'Jebus'),
	('190504', '1905', 'Kelapa'),
	('190505', '1905', 'Tempilang'),
	('190506', '1905', 'Parittiga'),
	('190601', '1906', 'Manggar'),
	('190602', '1906', 'Gantung'),
	('190603', '1906', 'Dendang'),
	('190604', '1906', 'Kelapa Kampit'),
	('190605', '1906', 'Damar'),
	('190606', '1906', 'Simpang Renggiang'),
	('190607', '1906', 'Simpang Pesak'),
	('197101', '1971', 'Bukitintan'),
	('197102', '1971', 'Taman Sari'),
	('197103', '1971', 'Pangkal Balam'),
	('197104', '1971', 'Rangkui'),
	('197105', '1971', 'Gerunggang'),
	('197106', '1971', 'Gabek'),
	('197107', '1971', 'Girimaya'),
	('210104', '2101', 'Gunung Kijang'),
	('210106', '2101', 'Bintan Timur'),
	('210107', '2101', 'Bintan Utara'),
	('210108', '2101', 'Teluk Bintan'),
	('210109', '2101', 'Tambelan'),
	('210110', '2101', 'Telok Sebong'),
	('210112', '2101', 'Toapaya'),
	('210113', '2101', 'Mantang'),
	('210114', '2101', 'Bintan Pesisir'),
	('210115', '2101', 'Seri Kuala Lobam'),
	('210201', '2102', 'Moro'),
	('210202', '2102', 'Kundur'),
	('210203', '2102', 'Karimun'),
	('210204', '2102', 'Meral'),
	('210205', '2102', 'Tebing'),
	('210206', '2102', 'Buru'),
	('210207', '2102', 'Kundur Utara'),
	('210208', '2102', 'Kundur Barat'),
	('210209', '2102', 'Durai'),
	('210210', '2102', 'Meral Barat'),
	('210211', '2102', 'Ungar'),
	('210212', '2102', 'Belat'),
	('210304', '2103', 'Midai'),
	('210305', '2103', 'Bunguran Barat'),
	('210306', '2103', 'Serasan'),
	('210307', '2103', 'Bunguran Timur'),
	('210308', '2103', 'Bunguran Utara'),
	('210309', '2103', 'Subi'),
	('210310', '2103', 'Pulau Laut'),
	('210311', '2103', 'Pulau Tiga'),
	('210315', '2103', 'Bunguran Timur Laut'),
	('210316', '2103', 'Bunguran Tengah'),
	('210318', '2103', 'Bunguran Selatan'),
	('210319', '2103', 'Serasan Timur'),
	('210401', '2104', 'Singkep'),
	('210402', '2104', 'Lingga'),
	('210403', '2104', 'Senayang'),
	('210404', '2104', 'Singkep Barat'),
	('210405', '2104', 'Lingga Utara'),
	('210406', '2104', 'Singkep Pesisir'),
	('210407', '2104', 'Lingga Timur'),
	('210408', '2104', 'Selayar'),
	('210409', '2104', 'Singkep Selatan'),
	('210501', '2105', 'Siantan'),
	('210502', '2105', 'Palmatak'),
	('210503', '2105', 'Siantan Timur'),
	('210504', '2105', 'Siantan Selatan'),
	('210505', '2105', 'Jemaja Timur'),
	('210506', '2105', 'Jemaja'),
	('210507', '2105', 'Siantan Tengah'),
	('217101', '2171', 'Belakang Padang'),
	('217102', '2171', 'Batu Ampar'),
	('217103', '2171', 'Sekupang'),
	('217104', '2171', 'Nongsa'),
	('217105', '2171', 'Bulang'),
	('217106', '2171', 'Lubuk Baja'),
	('217107', '2171', 'Sei Beduk'),
	('217108', '2171', 'Galang'),
	('217109', '2171', 'Bengkong'),
	('217110', '2171', 'Batam Kota'),
	('217111', '2171', 'Sagulung'),
	('217112', '2171', 'Batu Aji'),
	('217201', '2172', 'Tanjung Pinang Barat'),
	('217202', '2172', 'Tanjung Pinang Timur'),
	('217203', '2172', 'Tanjung Pinang Kota'),
	('217204', '2172', 'Bukit Bestari'),
	('310101', '3101', 'Kepulauan Seribu Utara'),
	('310102', '3101', 'Kepulauan Seribu Selatan.'),
	('317101', '3171', 'Gambir'),
	('317102', '3171', 'Sawah Besar'),
	('317103', '3171', 'Kemayoran'),
	('317104', '3171', 'Senen'),
	('317105', '3171', 'Cempaka Putih'),
	('317106', '3171', 'Menteng'),
	('317107', '3171', 'Tanah Abang'),
	('317108', '3171', 'Johar Baru'),
	('317201', '3172', 'Penjaringan'),
	('317202', '3172', 'Tanjung Priok'),
	('317203', '3172', 'Koja'),
	('317204', '3172', 'Cilincing'),
	('317205', '3172', 'Pademangan'),
	('317206', '3172', 'Kelapa Gading'),
	('317301', '3173', 'Cengkareng'),
	('317302', '3173', 'Grogol Petamburan'),
	('317303', '3173', 'Taman Sari'),
	('317304', '3173', 'Tambora'),
	('317305', '3173', 'Kebon Jeruk'),
	('317306', '3173', 'Kalideres'),
	('317307', '3173', 'Pal Merah'),
	('317308', '3173', 'Kembangan'),
	('317401', '3174', 'Tebet'),
	('317402', '3174', 'Setiabudi'),
	('317403', '3174', 'Mampang Prapatan'),
	('317404', '3174', 'Pasar Minggu'),
	('317405', '3174', 'Kebayoran Lama'),
	('317406', '3174', 'Cilandak'),
	('317407', '3174', 'Kebayoran Baru'),
	('317408', '3174', 'Pancoran'),
	('317409', '3174', 'Jagakarsa'),
	('317410', '3174', 'Pesanggrahan'),
	('317501', '3175', 'Matraman'),
	('317502', '3175', 'Pulogadung'),
	('317503', '3175', 'Jatinegara'),
	('317504', '3175', 'Kramatjati'),
	('317505', '3175', 'Pasar Rebo'),
	('317506', '3175', 'Cakung'),
	('317507', '3175', 'Duren Sawit'),
	('317508', '3175', 'Makasar'),
	('317509', '3175', 'Ciracas'),
	('317510', '3175', 'Cipayung'),
	('320101', '3201', 'Cibinong'),
	('320102', '3201', 'Gunung Putri'),
	('320103', '3201', 'Citeureup'),
	('320104', '3201', 'Sukaraja'),
	('320105', '3201', 'Babakan Madang'),
	('320106', '3201', 'Jonggol'),
	('320107', '3201', 'Cileungsi'),
	('320108', '3201', 'Cariu'),
	('320109', '3201', 'Sukamakmur'),
	('320110', '3201', 'Parung'),
	('320111', '3201', 'Gunung Sindur'),
	('320112', '3201', 'Kemang'),
	('320113', '3201', 'Bojong Gede'),
	('320114', '3201', 'Leuwiliang'),
	('320115', '3201', 'Ciampea'),
	('320116', '3201', 'Cibungbulang'),
	('320117', '3201', 'Pamijahan'),
	('320118', '3201', 'Rumpin'),
	('320119', '3201', 'Jasinga'),
	('320120', '3201', 'Parung Panjang'),
	('320121', '3201', 'Nanggung'),
	('320122', '3201', 'Cigudeg'),
	('320123', '3201', 'Tenjo'),
	('320124', '3201', 'Ciawi'),
	('320125', '3201', 'Cisarua'),
	('320126', '3201', 'Megamendung'),
	('320127', '3201', 'Caringin'),
	('320128', '3201', 'Cijeruk'),
	('320129', '3201', 'Ciomas'),
	('320130', '3201', 'Dramaga'),
	('320131', '3201', 'Tamansari'),
	('320132', '3201', 'Klapanunggal'),
	('320133', '3201', 'Ciseeng'),
	('320134', '3201', 'Ranca Bungur'),
	('320135', '3201', 'Sukajaya'),
	('320136', '3201', 'Tanjungsari'),
	('320137', '3201', 'Tajurhalang'),
	('320138', '3201', 'Cigombong'),
	('320139', '3201', 'Leuwisadeng'),
	('320140', '3201', 'Tenjolaya'),
	('320201', '3202', 'Pelabuhanratu'),
	('320202', '3202', 'Simpenan'),
	('320203', '3202', 'Cikakak'),
	('320204', '3202', 'Bantargadung'),
	('320205', '3202', 'Cisolok'),
	('320206', '3202', 'Cikidang'),
	('320207', '3202', 'Lengkong'),
	('320208', '3202', 'Jampang Tengah'),
	('320209', '3202', 'Warungkiara'),
	('320210', '3202', 'Cikembar'),
	('320211', '3202', 'Cibadak'),
	('320212', '3202', 'Nagrak'),
	('320213', '3202', 'Parungkuda'),
	('320214', '3202', 'Bojonggenteng'),
	('320215', '3202', 'Parakansalak'),
	('320216', '3202', 'Cicurug'),
	('320217', '3202', 'Cidahu'),
	('320218', '3202', 'Kalapanunggal'),
	('320219', '3202', 'Kabandungan'),
	('320220', '3202', 'Waluran'),
	('320221', '3202', 'Jampang Kulon'),
	('320222', '3202', 'Ciemas'),
	('320223', '3202', 'Kalibunder'),
	('320224', '3202', 'Surade'),
	('320225', '3202', 'Cibitung'),
	('320226', '3202', 'Ciracap'),
	('320227', '3202', 'Gunungguruh'),
	('320228', '3202', 'Cicantayan'),
	('320229', '3202', 'Cisaat'),
	('320230', '3202', 'Kadudampit'),
	('320231', '3202', 'Caringin'),
	('320232', '3202', 'Sukabumi'),
	('320233', '3202', 'Sukaraja'),
	('320234', '3202', 'Kebonpedes'),
	('320235', '3202', 'Cireunghas'),
	('320236', '3202', 'Sukalarang'),
	('320237', '3202', 'Pabuaran'),
	('320238', '3202', 'Purabaya'),
	('320239', '3202', 'Nyalindung'),
	('320240', '3202', 'Gegerbitung'),
	('320241', '3202', 'Sagaranten'),
	('320242', '3202', 'Curugkembar'),
	('320243', '3202', 'Cidolog'),
	('320244', '3202', 'Cidadap'),
	('320245', '3202', 'Tegalbuleud'),
	('320246', '3202', 'Cimanggu'),
	('320247', '3202', 'Ciambar'),
	('320301', '3203', 'Cianjur'),
	('320302', '3203', 'Warungkondang'),
	('320303', '3203', 'Cibeber'),
	('320304', '3203', 'Cilaku'),
	('320305', '3203', 'Ciranjang'),
	('320306', '3203', 'Bojongpicung'),
	('320307', '3203', 'Karangtengah'),
	('320308', '3203', 'Mande'),
	('320309', '3203', 'Sukaluyu'),
	('320310', '3203', 'Pacet'),
	('320311', '3203', 'Cugenang'),
	('320312', '3203', 'Cikalongkulon'),
	('320313', '3203', 'Sukaresmi'),
	('320314', '3203', 'Sukanagara'),
	('320315', '3203', 'Campaka'),
	('320316', '3203', 'Takokak'),
	('320317', '3203', 'Kadupandak'),
	('320318', '3203', 'Pagelaran'),
	('320319', '3203', 'Tanggeung'),
	('320320', '3203', 'Cibinong'),
	('320321', '3203', 'Sindangbarang'),
	('320322', '3203', 'Agrabinta'),
	('320323', '3203', 'Cidaun'),
	('320324', '3203', 'Naringgul'),
	('320325', '3203', 'Campakamulya'),
	('320326', '3203', 'Cikadu'),
	('320327', '3203', 'Gekbrong'),
	('320328', '3203', 'Cipanas'),
	('320329', '3203', 'Cijati'),
	('320330', '3203', 'Leles'),
	('320331', '3203', 'Haurwangi'),
	('320332', '3203', 'Pasirkuda'),
	('320405', '3204', 'Cileunyi'),
	('320406', '3204', 'Cimenyan'),
	('320407', '3204', 'Cilengkrang'),
	('320408', '3204', 'Bojongsoang'),
	('320409', '3204', 'Margahayu'),
	('320410', '3204', 'Margaasih'),
	('320411', '3204', 'Katapang'),
	('320412', '3204', 'Dayeuhkolot'),
	('320413', '3204', 'Banjaran'),
	('320414', '3204', 'Pameungpeuk'),
	('320415', '3204', 'Pangalengan'),
	('320416', '3204', 'Arjasari'),
	('320417', '3204', 'Cimaung'),
	('320425', '3204', 'Cicalengka'),
	('320426', '3204', 'Nagreg'),
	('320427', '3204', 'Cikancung'),
	('320428', '3204', 'Rancaekek'),
	('320429', '3204', 'Ciparay'),
	('320430', '3204', 'Pacet'),
	('320431', '3204', 'Kertasari'),
	('320432', '3204', 'Baleendah'),
	('320433', '3204', 'Majalaya'),
	('320434', '3204', 'Solokanjeruk'),
	('320435', '3204', 'Paseh'),
	('320436', '3204', 'Ibun'),
	('320437', '3204', 'Soreang'),
	('320438', '3204', 'Pasirjambu'),
	('320439', '3204', 'Ciwidey'),
	('320440', '3204', 'Rancabali'),
	('320444', '3204', 'Cangkuang'),
	('320446', '3204', 'Kutawaringin'),
	('320501', '3205', 'Garut Kota'),
	('320502', '3205', 'Karangpawitan'),
	('320503', '3205', 'Wanaraja'),
	('320504', '3205', 'Tarogong Kaler'),
	('320505', '3205', 'Tarogong Kidul'),
	('320506', '3205', 'Banyuresmi'),
	('320507', '3205', 'Samarang'),
	('320508', '3205', 'Pasirwangi'),
	('320509', '3205', 'Leles'),
	('320510', '3205', 'Kadungora'),
	('320511', '3205', 'Leuwigoong'),
	('320512', '3205', 'Cibatu'),
	('320513', '3205', 'Kersamanah'),
	('320514', '3205', 'Malangbong'),
	('320515', '3205', 'Sukawening'),
	('320516', '3205', 'Karangtengah'),
	('320517', '3205', 'Bayongbong'),
	('320518', '3205', 'Cigedug'),
	('320519', '3205', 'Cilawu'),
	('320520', '3205', 'Cisurupan'),
	('320521', '3205', 'Sukaresmi'),
	('320522', '3205', 'Cikajang'),
	('320523', '3205', 'Banjarwangi'),
	('320524', '3205', 'Singajaya'),
	('320525', '3205', 'Cihurip'),
	('320526', '3205', 'Peundeuy'),
	('320527', '3205', 'Pameungpeuk'),
	('320528', '3205', 'Cisompet'),
	('320529', '3205', 'Cibalong'),
	('320530', '3205', 'Cikelet'),
	('320531', '3205', 'Bungbulang'),
	('320532', '3205', 'Mekarmukti'),
	('320533', '3205', 'Pakenjeng'),
	('320534', '3205', 'Pamulihan'),
	('320535', '3205', 'Cisewu'),
	('320536', '3205', 'Caringin'),
	('320537', '3205', 'Talegong'),
	('320538', '3205', 'Bl. Limbangan'),
	('320539', '3205', 'Selaawi'),
	('320540', '3205', 'Cibiuk'),
	('320541', '3205', 'Pangatikan'),
	('320542', '3205', 'Sucinaraja'),
	('320601', '3206', 'Cipatujah'),
	('320602', '3206', 'Karangnunggal'),
	('320603', '3206', 'Cikalong'),
	('320604', '3206', 'Pancatengah'),
	('320605', '3206', 'Cikatomas'),
	('320606', '3206', 'Cibalong'),
	('320607', '3206', 'Parungponteng'),
	('320608', '3206', 'Bantarkalong'),
	('320609', '3206', 'Bojongasih'),
	('320610', '3206', 'Culamega'),
	('320611', '3206', 'Bojonggambir'),
	('320612', '3206', 'Sodonghilir'),
	('320613', '3206', 'Taraju'),
	('320614', '3206', 'Salawu'),
	('320615', '3206', 'Puspahiang'),
	('320616', '3206', 'Tanjungjaya'),
	('320617', '3206', 'Sukaraja'),
	('320618', '3206', 'Salopa'),
	('320619', '3206', 'Jatiwaras'),
	('320620', '3206', 'Cineam'),
	('320621', '3206', 'Karang Jaya'),
	('320622', '3206', 'Manonjaya'),
	('320623', '3206', 'Gunung Tanjung'),
	('320624', '3206', 'Singaparna'),
	('320625', '3206', 'Mangunreja'),
	('320626', '3206', 'Sukarame'),
	('320627', '3206', 'Cigalontang'),
	('320628', '3206', 'Leuwisari'),
	('320629', '3206', 'Padakembang'),
	('320630', '3206', 'Sariwangi'),
	('320631', '3206', 'Sukaratu'),
	('320632', '3206', 'Cisayong'),
	('320633', '3206', 'Sukahening'),
	('320634', '3206', 'Rajapolah'),
	('320635', '3206', 'Jamanis'),
	('320636', '3206', 'Ciawi'),
	('320637', '3206', 'Kadipaten'),
	('320638', '3206', 'Pagerageung'),
	('320639', '3206', 'Sukaresik'),
	('320701', '3207', 'Ciamis'),
	('320702', '3207', 'Cikoneng'),
	('320703', '3207', 'Cijeungjing'),
	('320704', '3207', 'Sadananya'),
	('320705', '3207', 'Cidolog'),
	('320706', '3207', 'Cihaurbeuti'),
	('320707', '3207', 'Panumbangan'),
	('320708', '3207', 'Panjalu'),
	('320709', '3207', 'Kawali'),
	('320710', '3207', 'Panawangan'),
	('320711', '3207', 'Cipaku'),
	('320712', '3207', 'Jatinagara'),
	('320713', '3207', 'Rajadesa'),
	('320714', '3207', 'Sukadana'),
	('320715', '3207', 'Rancah'),
	('320716', '3207', 'Tambaksari'),
	('320717', '3207', 'Lakbok'),
	('320718', '3207', 'Banjarsari'),
	('320719', '3207', 'Pamarican'),
	('320729', '3207', 'Cimaragas'),
	('320730', '3207', 'Cisaga'),
	('320731', '3207', 'Sindangkasih'),
	('320732', '3207', 'Baregbeg'),
	('320733', '3207', 'Sukamantri'),
	('320734', '3207', 'Lumbung'),
	('320735', '3207', 'Purwadadi'),
	('320801', '3208', 'Kadugede'),
	('320802', '3208', 'Ciniru'),
	('320803', '3208', 'Subang'),
	('320804', '3208', 'Ciwaru'),
	('320805', '3208', 'Cibingbin'),
	('320806', '3208', 'Luragung'),
	('320807', '3208', 'Lebakwangi'),
	('320808', '3208', 'Garawangi'),
	('320809', '3208', 'Kuningan'),
	('320810', '3208', 'Ciawigebang'),
	('320811', '3208', 'Cidahu'),
	('320812', '3208', 'Jalaksana'),
	('320813', '3208', 'Cilimus'),
	('320814', '3208', 'Mandirancan'),
	('320815', '3208', 'Selajambe'),
	('320816', '3208', 'Kramatmulya'),
	('320817', '3208', 'Darma'),
	('320818', '3208', 'Cigugur'),
	('320819', '3208', 'Pasawahan'),
	('320820', '3208', 'Nusaherang'),
	('320821', '3208', 'Cipicung'),
	('320822', '3208', 'Pancalang'),
	('320823', '3208', 'Japara'),
	('320824', '3208', 'Cimahi'),
	('320825', '3208', 'Cilebak'),
	('320826', '3208', 'Hantara'),
	('320827', '3208', 'Kalimanggis'),
	('320828', '3208', 'Cibeureum'),
	('320829', '3208', 'Karang Kancana'),
	('320830', '3208', 'Maleber'),
	('320831', '3208', 'Sindang Agung'),
	('320832', '3208', 'Cigandamekar'),
	('320901', '3209', 'Waled'),
	('320902', '3209', 'Ciledug'),
	('320903', '3209', 'Losari'),
	('320904', '3209', 'Pabedilan'),
	('320905', '3209', 'Babakan'),
	('320906', '3209', 'Karangsembung'),
	('320907', '3209', 'Lemahabang'),
	('320908', '3209', 'Susukan Lebak'),
	('320909', '3209', 'Sedong'),
	('320910', '3209', 'Astanajapura'),
	('320911', '3209', 'Pangenan'),
	('320912', '3209', 'Mundu'),
	('320913', '3209', 'Beber'),
	('320914', '3209', 'Talun'),
	('320915', '3209', 'Sumber'),
	('320916', '3209', 'Dukupuntang'),
	('320917', '3209', 'Palimanan'),
	('320918', '3209', 'Plumbon'),
	('320919', '3209', 'Weru'),
	('320920', '3209', 'Kedawung'),
	('320921', '3209', 'Gunung Jati'),
	('320922', '3209', 'Kapetakan'),
	('320923', '3209', 'Klangenan'),
	('320924', '3209', 'Arjawinangun'),
	('320925', '3209', 'Panguragan'),
	('320926', '3209', 'Ciwaringin'),
	('320927', '3209', 'Susukan'),
	('320928', '3209', 'Gegesik'),
	('320929', '3209', 'Kaliwedi'),
	('320930', '3209', 'Gebang'),
	('320931', '3209', 'Depok'),
	('320932', '3209', 'Pasaleman'),
	('320933', '3209', 'Pabuaran'),
	('320934', '3209', 'Karangwareng'),
	('320935', '3209', 'Tengah Tani'),
	('320936', '3209', 'Plered'),
	('320937', '3209', 'Gempol'),
	('320938', '3209', 'Greged'),
	('320939', '3209', 'Suranenggala'),
	('320940', '3209', 'Jamblang'),
	('321001', '3210', 'Lemahsugih'),
	('321002', '3210', 'Bantarujeg'),
	('321003', '3210', 'Cikijing'),
	('321004', '3210', 'Talaga'),
	('321005', '3210', 'Argapura'),
	('321006', '3210', 'Maja'),
	('321007', '3210', 'Majalengka'),
	('321008', '3210', 'Sukahaji'),
	('321009', '3210', 'Rajagaluh'),
	('321010', '3210', 'Leuwimunding'),
	('321011', '3210', 'Jatiwangi'),
	('321012', '3210', 'Dawuan'),
	('321013', '3210', 'Kadipaten'),
	('321014', '3210', 'Kertajati'),
	('321015', '3210', 'Jatitujuh'),
	('321016', '3210', 'Ligung'),
	('321017', '3210', 'Sumberjaya'),
	('321018', '3210', 'Panyingkiran'),
	('321019', '3210', 'Palasah'),
	('321020', '3210', 'Cigasong'),
	('321021', '3210', 'Sindangwangi'),
	('321022', '3210', 'Banjaran'),
	('321023', '3210', 'Cingambul'),
	('321024', '3210', 'Kasokandel'),
	('321025', '3210', 'Sindang'),
	('321026', '3210', 'Malausma'),
	('321101', '3211', 'Wado'),
	('321102', '3211', 'Jatinunggal'),
	('321103', '3211', 'Darmaraja'),
	('321104', '3211', 'Cibugel'),
	('321105', '3211', 'Cisitu'),
	('321106', '3211', 'Situraja'),
	('321107', '3211', 'Conggeang'),
	('321108', '3211', 'Paseh'),
	('321109', '3211', 'Surian'),
	('321110', '3211', 'Buahdua'),
	('321111', '3211', 'Tanjungsari'),
	('321112', '3211', 'Sukasari'),
	('321113', '3211', 'Pamulihan'),
	('321114', '3211', 'Cimanggung'),
	('321115', '3211', 'Jatinangor'),
	('321116', '3211', 'Rancakalong'),
	('321117', '3211', 'Sumedang Selatan'),
	('321118', '3211', 'Sumedang Utara'),
	('321119', '3211', 'Ganeas'),
	('321120', '3211', 'Tanjungkerta'),
	('321121', '3211', 'Tanjungmedar'),
	('321122', '3211', 'Cimalaka'),
	('321123', '3211', 'Cisarua'),
	('321124', '3211', 'Tomo'),
	('321125', '3211', 'Ujungjaya'),
	('321126', '3211', 'Jatigede'),
	('321201', '3212', 'Haurgeulis'),
	('321202', '3212', 'Kroya'),
	('321203', '3212', 'Gabuswetan'),
	('321204', '3212', 'Cikedung'),
	('321205', '3212', 'Lelea'),
	('321206', '3212', 'Bangodua'),
	('321207', '3212', 'Widasari'),
	('321208', '3212', 'Kertasemaya'),
	('321209', '3212', 'Krangkeng'),
	('321210', '3212', 'Karangampel'),
	('321211', '3212', 'Juntinyuat'),
	('321212', '3212', 'Sliyeg'),
	('321213', '3212', 'Jatibarang'),
	('321214', '3212', 'Balongan'),
	('321215', '3212', 'Indramayu'),
	('321216', '3212', 'Sindang'),
	('321217', '3212', 'Cantigi'),
	('321218', '3212', 'Lohbener'),
	('321219', '3212', 'Arahan'),
	('321220', '3212', 'Losarang'),
	('321221', '3212', 'Kandanghaur'),
	('321222', '3212', 'Bongas'),
	('321223', '3212', 'Anjatan'),
	('321224', '3212', 'Sukra'),
	('321225', '3212', 'Gantar'),
	('321226', '3212', 'Trisi'),
	('321227', '3212', 'Sukagumiwang'),
	('321228', '3212', 'Kedokan Bunder'),
	('321229', '3212', 'Pasekan'),
	('321230', '3212', 'Tukdana'),
	('321231', '3212', 'Patrol'),
	('321301', '3213', 'Sagalaherang'),
	('321302', '3213', 'Cisalak'),
	('321303', '3213', 'Subang'),
	('321304', '3213', 'Kalijati'),
	('321305', '3213', 'Pabuaran'),
	('321306', '3213', 'Purwadadi'),
	('321307', '3213', 'Pagaden'),
	('321308', '3213', 'Binong'),
	('321309', '3213', 'Ciasem'),
	('321310', '3213', 'Pusakanagara'),
	('321311', '3213', 'Pamanukan'),
	('321312', '3213', 'Jalancagak'),
	('321313', '3213', 'Blanakan'),
	('321314', '3213', 'Tanjungsiang'),
	('321315', '3213', 'Compreng'),
	('321316', '3213', 'Patokbeusi'),
	('321317', '3213', 'Cibogo'),
	('321318', '3213', 'Cipunagara'),
	('321319', '3213', 'Cijambe'),
	('321320', '3213', 'Cipeunduey'),
	('321321', '3213', 'Legonkulon'),
	('321322', '3213', 'Cikaum'),
	('321323', '3213', 'Serangpanjang'),
	('321324', '3213', 'Sukasari'),
	('321325', '3213', 'Tambakdahan'),
	('321326', '3213', 'Kasomalang'),
	('321327', '3213', 'Dawuan'),
	('321328', '3213', 'Pagaden Barat'),
	('321329', '3213', 'Ciater'),
	('321330', '3213', 'Pusakajaya'),
	('321401', '3214', 'Purwakarta'),
	('321402', '3214', 'Campaka'),
	('321403', '3214', 'Jatiluhur'),
	('321404', '3214', 'Plered'),
	('321405', '3214', 'Sukatani'),
	('321406', '3214', 'Darangdan'),
	('321407', '3214', 'Maniis'),
	('321408', '3214', 'Tegalwaru'),
	('321409', '3214', 'Wanayasa'),
	('321410', '3214', 'Pasawahan'),
	('321411', '3214', 'Bojong'),
	('321412', '3214', 'Babakancikao'),
	('321413', '3214', 'Bungursari'),
	('321414', '3214', 'Cibatu'),
	('321415', '3214', 'Sukasari'),
	('321416', '3214', 'Pondoksalam'),
	('321417', '3214', 'Kiarapedes'),
	('321501', '3215', 'Karawang Barat'),
	('321502', '3215', 'Pangkalan'),
	('321503', '3215', 'Telukjambe Timur'),
	('321504', '3215', 'Ciampel'),
	('321505', '3215', 'Klari'),
	('321506', '3215', 'Rengasdengklok'),
	('321507', '3215', 'Kutawaluya'),
	('321508', '3215', 'Batujaya'),
	('321509', '3215', 'Tirtajaya'),
	('321510', '3215', 'Pedes'),
	('321511', '3215', 'Cibuaya'),
	('321512', '3215', 'Pakisjaya'),
	('321513', '3215', 'Cikampek'),
	('321514', '3215', 'Jatisari'),
	('321515', '3215', 'Cilamaya Wetan'),
	('321516', '3215', 'Tirtamulya'),
	('321517', '3215', 'Telagasari'),
	('321518', '3215', 'Rawamerta'),
	('321519', '3215', 'Lemahabang'),
	('321520', '3215', 'Tempuran'),
	('321521', '3215', 'Majalaya'),
	('321522', '3215', 'Jayakerta'),
	('321523', '3215', 'Cilamaya Kulon'),
	('321524', '3215', 'Banyusari'),
	('321525', '3215', 'Kota Baru'),
	('321526', '3215', 'Karawang Timur'),
	('321527', '3215', 'Telukjambe Barat'),
	('321528', '3215', 'Tegalwaru'),
	('321529', '3215', 'Purwasari'),
	('321530', '3215', 'Cilebar'),
	('321601', '3216', 'Tarumajaya'),
	('321602', '3216', 'Babelan'),
	('321603', '3216', 'Sukawangi'),
	('321604', '3216', 'Tambelang'),
	('321605', '3216', 'Tambun Utara'),
	('321606', '3216', 'Tambun Selatan'),
	('321607', '3216', 'Cibitung'),
	('321608', '3216', 'Cikarang Barat'),
	('321609', '3216', 'Cikarang Utara'),
	('321610', '3216', 'Karang Bahagia'),
	('321611', '3216', 'Cikarang Timur'),
	('321612', '3216', 'Kedung Waringin'),
	('321613', '3216', 'Pebayuran'),
	('321614', '3216', 'Sukakarya'),
	('321615', '3216', 'Sukatani'),
	('321616', '3216', 'Cabangbungin'),
	('321617', '3216', 'Muaragembong'),
	('321618', '3216', 'Setu'),
	('321619', '3216', 'Cikarang Selatan'),
	('321620', '3216', 'Cikarang Pusat'),
	('321621', '3216', 'Serang Baru'),
	('321622', '3216', 'Cibarusah'),
	('321623', '3216', 'Bojongmangu'),
	('321701', '3217', 'Lembang'),
	('321702', '3217', 'Parongpong'),
	('321703', '3217', 'Cisarua'),
	('321704', '3217', 'Cikalongwetan'),
	('321705', '3217', 'Cipeundeuy'),
	('321706', '3217', 'Ngamprah'),
	('321707', '3217', 'Cipatat'),
	('321708', '3217', 'Padalarang'),
	('321709', '3217', 'Batujajar'),
	('321710', '3217', 'Cihampelas'),
	('321711', '3217', 'Cililin'),
	('321712', '3217', 'Cipongkor'),
	('321713', '3217', 'Rongga'),
	('321714', '3217', 'Sindangkerta'),
	('321715', '3217', 'Gununghalu'),
	('321716', '3217', 'Saguling'),
	('321801', '3218', 'Parigi'),
	('321802', '3218', 'Cijulang'),
	('321803', '3218', 'Cimerak'),
	('321804', '3218', 'Cigugur'),
	('321805', '3218', 'Langkaplancar'),
	('321806', '3218', 'Mangunjaya'),
	('321807', '3218', 'Padaherang'),
	('321808', '3218', 'Kalipucang'),
	('321809', '3218', 'Pangandaran'),
	('321810', '3218', 'Sidamulih'),
	('327101', '3271', 'Bogor Selatan'),
	('327102', '3271', 'Bogor Timur'),
	('327103', '3271', 'Bogor Tengah'),
	('327104', '3271', 'Bogor Barat'),
	('327105', '3271', 'Bogor Utara'),
	('327106', '3271', 'Tanah Sareal'),
	('327201', '3272', 'Gunung Puyuh'),
	('327202', '3272', 'Cikole'),
	('327203', '3272', 'Citamiang'),
	('327204', '3272', 'Warudoyong'),
	('327205', '3272', 'Baros'),
	('327206', '3272', 'Lembursitu'),
	('327207', '3272', 'Cibeureum'),
	('327301', '3273', 'Sukasari'),
	('327302', '3273', 'Coblong'),
	('327303', '3273', 'Babakan Ciparay'),
	('327304', '3273', 'Bojongloa Kaler'),
	('327305', '3273', 'Andir'),
	('327306', '3273', 'Cicendo'),
	('327307', '3273', 'Sukajadi'),
	('327308', '3273', 'Cidadap'),
	('327309', '3273', 'Bandung Wetan'),
	('327310', '3273', 'Astana Anyar'),
	('327311', '3273', 'Regol'),
	('327312', '3273', 'Batununggal'),
	('327313', '3273', 'Lengkong'),
	('327314', '3273', 'Cibeunying Kidul'),
	('327315', '3273', 'Bandung Kulon'),
	('327316', '3273', 'Kiaracondong'),
	('327317', '3273', 'Bojongloa Kidul'),
	('327318', '3273', 'Cibeunying Kaler'),
	('327319', '3273', 'Sumur Bandung'),
	('327320', '3273', 'Antapani'),
	('327321', '3273', 'Bandung Kidul'),
	('327322', '3273', 'Buahbatu'),
	('327323', '3273', 'Rancasari'),
	('327324', '3273', 'Arcamanik'),
	('327325', '3273', 'Cibiru'),
	('327326', '3273', 'Ujung Berung'),
	('327327', '3273', 'Gedebage'),
	('327328', '3273', 'Panyileukan'),
	('327329', '3273', 'Cinambo'),
	('327330', '3273', 'Mandalajati'),
	('327401', '3274', 'Kejaksan'),
	('327402', '3274', 'Lemah Wungkuk'),
	('327403', '3274', 'Harjamukti'),
	('327404', '3274', 'Pekalipan'),
	('327405', '3274', 'Kesambi'),
	('327501', '3275', 'Bekasi Timur'),
	('327502', '3275', 'Bekasi Barat'),
	('327503', '3275', 'Bekasi Utara'),
	('327504', '3275', 'Bekasi Selatan'),
	('327505', '3275', 'Rawa Lumbu'),
	('327506', '3275', 'Medan Satria'),
	('327507', '3275', 'Bantar Gebang'),
	('327508', '3275', 'Pondok Gede'),
	('327509', '3275', 'Jatiasih'),
	('327510', '3275', 'Jati Sempurna'),
	('327511', '3275', 'Mustika Jaya'),
	('327512', '3275', 'Pondok Melati'),
	('327601', '3276', 'Pancoran Mas'),
	('327602', '3276', 'Cimanggis'),
	('327603', '3276', 'Sawangan'),
	('327604', '3276', 'Limo'),
	('327605', '3276', 'Sukmajaya'),
	('327606', '3276', 'Beji'),
	('327607', '3276', 'Cipayung'),
	('327608', '3276', 'Cilodong'),
	('327609', '3276', 'Cinere'),
	('327610', '3276', 'Tapos'),
	('327611', '3276', 'Bojongsari'),
	('327701', '3277', 'Cimahi Selatan'),
	('327702', '3277', 'Cimahi Tengah'),
	('327703', '3277', 'Cimahi Utara'),
	('327801', '3278', 'Cihideung'),
	('327802', '3278', 'Cipedes'),
	('327803', '3278', 'Tawang'),
	('327804', '3278', 'Indihiang'),
	('327805', '3278', 'Kawalu'),
	('327806', '3278', 'Cibeureum'),
	('327807', '3278', 'Tamansari'),
	('327808', '3278', 'Mangkubumi'),
	('327809', '3278', 'Bungursari'),
	('327810', '3278', 'Purbaratu'),
	('327901', '3279', 'Banjar'),
	('327902', '3279', 'Pataruman'),
	('327903', '3279', 'Purwaharja'),
	('327904', '3279', 'Langensari'),
	('330101', '3301', 'Kedungreja'),
	('330102', '3301', 'Kesugihan'),
	('330103', '3301', 'Adipala'),
	('330104', '3301', 'Binangun'),
	('330105', '3301', 'Nusawungu'),
	('330106', '3301', 'Kroya'),
	('330107', '3301', 'Maos'),
	('330108', '3301', 'Jeruklegi'),
	('330109', '3301', 'Kawunganten'),
	('330110', '3301', 'Gandrungmangu'),
	('330111', '3301', 'Sidareja'),
	('330112', '3301', 'Karangpucung'),
	('330113', '3301', 'Cimanggu'),
	('330114', '3301', 'Majenang'),
	('330115', '3301', 'Wanareja'),
	('330116', '3301', 'Dayeuhluhur'),
	('330117', '3301', 'Sampang'),
	('330118', '3301', 'Cipari'),
	('330119', '3301', 'Patimuan'),
	('330120', '3301', 'Bantarsari'),
	('330121', '3301', 'Cilacap Selatan'),
	('330122', '3301', 'Cilacap Tengah'),
	('330123', '3301', 'Cilacap Utara'),
	('330124', '3301', 'Kampung Laut'),
	('330201', '3302', 'Lumbir'),
	('330202', '3302', 'Wangon'),
	('330203', '3302', 'Jatilawang'),
	('330204', '3302', 'Rawalo'),
	('330205', '3302', 'Kebasen'),
	('330206', '3302', 'Kemranjen'),
	('330207', '3302', 'Sumpiuh'),
	('330208', '3302', 'Tambak'),
	('330209', '3302', 'Somagede'),
	('330210', '3302', 'Kalibagor'),
	('330211', '3302', 'Banyumas'),
	('330212', '3302', 'Patikraja'),
	('330213', '3302', 'Purwojati'),
	('330214', '3302', 'Ajibarang'),
	('330215', '3302', 'Gumelar'),
	('330216', '3302', 'Pekuncen'),
	('330217', '3302', 'Cilongok'),
	('330218', '3302', 'Karanglewas'),
	('330219', '3302', 'Sokaraja'),
	('330220', '3302', 'Kembaran'),
	('330221', '3302', 'Sumbang'),
	('330222', '3302', 'Baturraden'),
	('330223', '3302', 'Kedungbanteng'),
	('330224', '3302', 'Purwokerto Selatan'),
	('330225', '3302', 'Purwokerto Barat'),
	('330226', '3302', 'Purwokerto Timur'),
	('330227', '3302', 'Purwokerto Utara'),
	('330301', '3303', 'Kemangkon'),
	('330302', '3303', 'Bukateja'),
	('330303', '3303', 'Kejobong'),
	('330304', '3303', 'Kaligondang'),
	('330305', '3303', 'Purbalingga'),
	('330306', '3303', 'Kalimanah'),
	('330307', '3303', 'Kutasari'),
	('330308', '3303', 'Mrebet'),
	('330309', '3303', 'Bobotsari'),
	('330310', '3303', 'Karangreja'),
	('330311', '3303', 'Karanganyar'),
	('330312', '3303', 'Karangmoncol'),
	('330313', '3303', 'Rembang'),
	('330314', '3303', 'Bojongsari'),
	('330315', '3303', 'Padamara'),
	('330316', '3303', 'Pengadegan'),
	('330317', '3303', 'Karangjambu'),
	('330318', '3303', 'Kertanegara'),
	('330401', '3304', 'Susukan'),
	('330402', '3304', 'Purworeja Klampok'),
	('330403', '3304', 'Mandiraja'),
	('330404', '3304', 'Purwanegara'),
	('330405', '3304', 'Bawang'),
	('330406', '3304', 'Banjarnegara'),
	('330407', '3304', 'Sigaluh'),
	('330408', '3304', 'Madukara'),
	('330409', '3304', 'Banjarmangu'),
	('330410', '3304', 'Wanadadi'),
	('330411', '3304', 'Rakit'),
	('330412', '3304', 'Punggelan'),
	('330413', '3304', 'Karangkobar'),
	('330414', '3304', 'Pagentan'),
	('330415', '3304', 'Pejawaran'),
	('330416', '3304', 'Batur'),
	('330417', '3304', 'Wanayasa'),
	('330418', '3304', 'Kalibening'),
	('330419', '3304', 'Pandanarum'),
	('330420', '3304', 'Pagedongan'),
	('330501', '3305', 'Ayah'),
	('330502', '3305', 'Buayan'),
	('330503', '3305', 'Puring'),
	('330504', '3305', 'Petanahan'),
	('330505', '3305', 'Klirong'),
	('330506', '3305', 'Buluspesantren'),
	('330507', '3305', 'Ambal'),
	('330508', '3305', 'Mirit'),
	('330509', '3305', 'Prembun'),
	('330510', '3305', 'Kutowinangun'),
	('330511', '3305', 'Alian'),
	('330512', '3305', 'Kebumen'),
	('330513', '3305', 'Pejagoan'),
	('330514', '3305', 'Sruweng'),
	('330515', '3305', 'Adimulyo'),
	('330516', '3305', 'Kuwarasan'),
	('330517', '3305', 'Rowokele'),
	('330518', '3305', 'Sempor'),
	('330519', '3305', 'Gombong'),
	('330520', '3305', 'Karanganyar'),
	('330521', '3305', 'Karanggayam'),
	('330522', '3305', 'Sadang'),
	('330523', '3305', 'Bonorowo'),
	('330524', '3305', 'Padureso'),
	('330525', '3305', 'Poncowarno'),
	('330526', '3305', 'Karangsambung'),
	('330601', '3306', 'Grabag'),
	('330602', '3306', 'Ngombol'),
	('330603', '3306', 'Purwodadi'),
	('330604', '3306', 'Bagelen'),
	('330605', '3306', 'Kaligesing'),
	('330606', '3306', 'Purworejo'),
	('330607', '3306', 'Banyuurip'),
	('330608', '3306', 'Bayan'),
	('330609', '3306', 'Kutoarjo'),
	('330610', '3306', 'Butuh'),
	('330611', '3306', 'Pituruh'),
	('330612', '3306', 'Kemiri'),
	('330613', '3306', 'Bruno'),
	('330614', '3306', 'Gebang'),
	('330615', '3306', 'Loano'),
	('330616', '3306', 'Bener'),
	('330701', '3307', 'Wadaslintang'),
	('330702', '3307', 'Kepil'),
	('330703', '3307', 'Sapuran'),
	('330704', '3307', 'Kaliwiro'),
	('330705', '3307', 'Leksono'),
	('330706', '3307', 'Selomerto'),
	('330707', '3307', 'Kalikajar'),
	('330708', '3307', 'Kertek'),
	('330709', '3307', 'Wonosobo'),
	('330710', '3307', 'Watumalang'),
	('330711', '3307', 'Mojotengah'),
	('330712', '3307', 'Garung'),
	('330713', '3307', 'Kejajar'),
	('330714', '3307', 'Sukoharjo'),
	('330715', '3307', 'Kalibawang'),
	('330801', '3308', 'Salaman'),
	('330802', '3308', 'Borobudur'),
	('330803', '3308', 'Ngluwar'),
	('330804', '3308', 'Salam'),
	('330805', '3308', 'Srumbung'),
	('330806', '3308', 'Dukun'),
	('330807', '3308', 'Sawangan'),
	('330808', '3308', 'Muntilan'),
	('330809', '3308', 'Mungkid'),
	('330810', '3308', 'Mertoyudan'),
	('330811', '3308', 'Tempuran'),
	('330812', '3308', 'Kajoran'),
	('330813', '3308', 'Kaliangkrik'),
	('330814', '3308', 'Bandongan'),
	('330815', '3308', 'Candimulyo'),
	('330816', '3308', 'Pakis'),
	('330817', '3308', 'Ngablak'),
	('330818', '3308', 'Grabag'),
	('330819', '3308', 'Tegalrejo'),
	('330820', '3308', 'Secang'),
	('330821', '3308', 'Windusari'),
	('330901', '3309', 'Selo'),
	('330902', '3309', 'Ampel'),
	('330903', '3309', 'Cepogo'),
	('330904', '3309', 'Musuk'),
	('330905', '3309', 'Boyolali'),
	('330906', '3309', 'Mojosongo'),
	('330907', '3309', 'Teras'),
	('330908', '3309', 'Sawit'),
	('330909', '3309', 'Banyudono'),
	('330910', '3309', 'Sambi'),
	('330911', '3309', 'Ngemplak'),
	('330912', '3309', 'Nogosari'),
	('330913', '3309', 'Simo'),
	('330914', '3309', 'Karanggede'),
	('330915', '3309', 'Klego'),
	('330916', '3309', 'Andong'),
	('330917', '3309', 'Kemusu'),
	('330918', '3309', 'Wonosegoro'),
	('330919', '3309', 'Juwangi'),
	('331001', '3310', 'Prambanan'),
	('331002', '3310', 'Gantiwarno'),
	('331003', '3310', 'Wedi'),
	('331004', '3310', 'Bayat'),
	('331005', '3310', 'Cawas'),
	('331006', '3310', 'Trucuk'),
	('331007', '3310', 'Kebonarum'),
	('331008', '3310', 'Jogonalan'),
	('331009', '3310', 'Manisrenggo'),
	('331010', '3310', 'Karangnongko'),
	('331011', '3310', 'Ceper'),
	('331012', '3310', 'Pedan'),
	('331013', '3310', 'Karangdowo'),
	('331014', '3310', 'Juwiring'),
	('331015', '3310', 'Wonosari'),
	('331016', '3310', 'Delanggu'),
	('331017', '3310', 'Polanharjo'),
	('331018', '3310', 'Karanganom'),
	('331019', '3310', 'Tulung'),
	('331020', '3310', 'Jatinom'),
	('331021', '3310', 'Kemalang'),
	('331022', '3310', 'Ngawen'),
	('331023', '3310', 'Kalikotes'),
	('331024', '3310', 'Klaten Utara'),
	('331025', '3310', 'Klaten Tengah'),
	('331026', '3310', 'Klaten Selatan'),
	('331101', '3311', 'Weru'),
	('331102', '3311', 'Bulu'),
	('331103', '3311', 'Tawangsari'),
	('331104', '3311', 'Sukoharjo'),
	('331105', '3311', 'Nguter'),
	('331106', '3311', 'Bendosari'),
	('331107', '3311', 'Polokarto'),
	('331108', '3311', 'Mojolaban'),
	('331109', '3311', 'Grogol'),
	('331110', '3311', 'Baki'),
	('331111', '3311', 'Gatak'),
	('331112', '3311', 'Kartasura'),
	('331201', '3312', 'Pracimantoro'),
	('331202', '3312', 'Giritontro'),
	('331203', '3312', 'Giriwoyo'),
	('331204', '3312', 'Batuwarno'),
	('331205', '3312', 'Tirtomoyo'),
	('331206', '3312', 'Nguntoronadi'),
	('331207', '3312', 'Baturetno'),
	('331208', '3312', 'Eromoko'),
	('331209', '3312', 'Wuryantoro'),
	('331210', '3312', 'Manyaran'),
	('331211', '3312', 'Selogiri'),
	('331212', '3312', 'Wonogiri'),
	('331213', '3312', 'Ngadirojo'),
	('331214', '3312', 'Sidoharjo'),
	('331215', '3312', 'Jatiroto'),
	('331216', '3312', 'Kismantoro'),
	('331217', '3312', 'Purwantoro'),
	('331218', '3312', 'Bulukerto'),
	('331219', '3312', 'Slogohimo'),
	('331220', '3312', 'Jatisrono'),
	('331221', '3312', 'Jatipurno'),
	('331222', '3312', 'Girimarto'),
	('331223', '3312', 'Karangtengah'),
	('331224', '3312', 'Paranggupito'),
	('331225', '3312', 'Puhpelem'),
	('331301', '3313', 'Jatipuro'),
	('331302', '3313', 'Jatiyoso'),
	('331303', '3313', 'Jumapolo'),
	('331304', '3313', 'Jumantono'),
	('331305', '3313', 'Matesih'),
	('331306', '3313', 'Tawangmangu'),
	('331307', '3313', 'Ngargoyoso'),
	('331308', '3313', 'Karangpandan'),
	('331309', '3313', 'Karanganyar'),
	('331310', '3313', 'Tasikmadu'),
	('331311', '3313', 'Jaten'),
	('331312', '3313', 'Colomadu'),
	('331313', '3313', 'Gondangrejo'),
	('331314', '3313', 'Kebakkramat'),
	('331315', '3313', 'Mojogedang'),
	('331316', '3313', 'Kerjo'),
	('331317', '3313', 'Jenawi'),
	('331401', '3314', 'Kalijambe'),
	('331402', '3314', 'Plupuh'),
	('331403', '3314', 'Masaran'),
	('331404', '3314', 'Kedawung'),
	('331405', '3314', 'Sambirejo'),
	('331406', '3314', 'Gondang'),
	('331407', '3314', 'Sambungmacan'),
	('331408', '3314', 'Ngrampal'),
	('331409', '3314', 'Karangmalang'),
	('331410', '3314', 'Sragen'),
	('331411', '3314', 'Sidoharjo'),
	('331412', '3314', 'Tanon'),
	('331413', '3314', 'Gemolong'),
	('331414', '3314', 'Miri'),
	('331415', '3314', 'Sumberlawang'),
	('331416', '3314', 'Mondokan'),
	('331417', '3314', 'Sukodono'),
	('331418', '3314', 'Gesi'),
	('331419', '3314', 'Tangen'),
	('331420', '3314', 'Jenar'),
	('331501', '3315', 'Kedungjati'),
	('331502', '3315', 'Karangrayung'),
	('331503', '3315', 'Penawangan'),
	('331504', '3315', 'Toroh'),
	('331505', '3315', 'Geyer'),
	('331506', '3315', 'Pulokulon'),
	('331507', '3315', 'Kradenan'),
	('331508', '3315', 'Gabus'),
	('331509', '3315', 'Ngaringan'),
	('331510', '3315', 'Wirosari'),
	('331511', '3315', 'Tawangharjo'),
	('331512', '3315', 'Grobogan'),
	('331513', '3315', 'Purwodadi'),
	('331514', '3315', 'Brati'),
	('331515', '3315', 'Klambu'),
	('331516', '3315', 'Godong'),
	('331517', '3315', 'Gubug'),
	('331518', '3315', 'Tegowanu'),
	('331519', '3315', 'Tanggungharjo'),
	('331601', '3316', 'Jati'),
	('331602', '3316', 'Randublatung'),
	('331603', '3316', 'Kradenan'),
	('331604', '3316', 'Kedungtuban'),
	('331605', '3316', 'Cepu'),
	('331606', '3316', 'Sambong'),
	('331607', '3316', 'Jiken'),
	('331608', '3316', 'Jepon'),
	('331609', '3316', 'Blora'),
	('331610', '3316', 'Tunjungan'),
	('331611', '3316', 'Banjarejo'),
	('331612', '3316', 'Ngawen'),
	('331613', '3316', 'Kunduran'),
	('331614', '3316', 'Todanan'),
	('331615', '3316', 'Bogorejo'),
	('331616', '3316', 'Japah'),
	('331701', '3317', 'Sumber'),
	('331702', '3317', 'Bulu'),
	('331703', '3317', 'Gunem'),
	('331704', '3317', 'Sale'),
	('331705', '3317', 'Sarang'),
	('331706', '3317', 'Sedan'),
	('331707', '3317', 'Pamotan'),
	('331708', '3317', 'Sulang'),
	('331709', '3317', 'Kaliori'),
	('331710', '3317', 'Rembang'),
	('331711', '3317', 'Pancur'),
	('331712', '3317', 'Kragan'),
	('331713', '3317', 'Sluke'),
	('331714', '3317', 'Lasem'),
	('331801', '3318', 'Sukolilo'),
	('331802', '3318', 'Kayen'),
	('331803', '3318', 'Tambakromo'),
	('331804', '3318', 'Winong'),
	('331805', '3318', 'Pucakwangi'),
	('331806', '3318', 'Jaken'),
	('331807', '3318', 'Batangan'),
	('331808', '3318', 'Juwana'),
	('331809', '3318', 'Jakenan'),
	('331810', '3318', 'Pati'),
	('331811', '3318', 'Gabus'),
	('331812', '3318', 'Margorejo'),
	('331813', '3318', 'Gembong'),
	('331814', '3318', 'Tlogowungu'),
	('331815', '3318', 'Wedarijaksa'),
	('331816', '3318', 'Margoyoso'),
	('331817', '3318', 'Gunungwungkal'),
	('331818', '3318', 'Cluwak'),
	('331819', '3318', 'Tayu'),
	('331820', '3318', 'Dukuhseti'),
	('331821', '3318', 'Trangkil'),
	('331901', '3319', 'Kaliwungu'),
	('331902', '3319', 'Kota Kudus'),
	('331903', '3319', 'Jati'),
	('331904', '3319', 'Undaan'),
	('331905', '3319', 'Mejobo'),
	('331906', '3319', 'Jekulo'),
	('331907', '3319', 'Bae'),
	('331908', '3319', 'Gebog'),
	('331909', '3319', 'Dawe'),
	('332001', '3320', 'Kedung'),
	('332002', '3320', 'Pecangaan'),
	('332003', '3320', 'Welahan'),
	('332004', '3320', 'Mayong'),
	('332005', '3320', 'Batealit'),
	('332006', '3320', 'Jepara'),
	('332007', '3320', 'Mlonggo'),
	('332008', '3320', 'Bangsri'),
	('332009', '3320', 'Keling'),
	('332010', '3320', 'Karimun Jawa'),
	('332011', '3320', 'Tahunan'),
	('332012', '3320', 'Nalumsari'),
	('332013', '3320', 'Kalinyamatan'),
	('332014', '3320', 'Kembang'),
	('332015', '3320', 'Pakis Aji'),
	('332016', '3320', 'Donorojo'),
	('332101', '3321', 'Mranggen'),
	('332102', '3321', 'Karangawen'),
	('332103', '3321', 'Guntur'),
	('332104', '3321', 'Sayung'),
	('332105', '3321', 'Karangtengah'),
	('332106', '3321', 'Wonosalam'),
	('332107', '3321', 'Dempet'),
	('332108', '3321', 'Gajah'),
	('332109', '3321', 'Karanganyar'),
	('332110', '3321', 'Mijen'),
	('332111', '3321', 'Demak'),
	('332112', '3321', 'Bonang'),
	('332113', '3321', 'Wedung'),
	('332114', '3321', 'Kebonagung'),
	('332201', '3322', 'Getasan'),
	('332202', '3322', 'Tengaran'),
	('332203', '3322', 'Susukan'),
	('332204', '3322', 'Suruh'),
	('332205', '3322', 'Pabelan'),
	('332206', '3322', 'Tuntang'),
	('332207', '3322', 'Banyubiru'),
	('332208', '3322', 'Jambu'),
	('332209', '3322', 'Sumowono'),
	('332210', '3322', 'Ambarawa'),
	('332211', '3322', 'Bawen'),
	('332212', '3322', 'Bringin'),
	('332213', '3322', 'Bergas'),
	('332215', '3322', 'Pringapus'),
	('332216', '3322', 'Bancak'),
	('332217', '3322', 'Kaliwungu'),
	('332218', '3322', 'Ungaran Barat'),
	('332219', '3322', 'Ungaran Timur'),
	('332220', '3322', 'Bandungan'),
	('332301', '3323', 'Bulu'),
	('332302', '3323', 'Tembarak'),
	('332303', '3323', 'Temanggung'),
	('332304', '3323', 'Pringsurat'),
	('332305', '3323', 'Kaloran'),
	('332306', '3323', 'Kandangan'),
	('332307', '3323', 'Kedu'),
	('332308', '3323', 'Parakan'),
	('332309', '3323', 'Ngadirejo'),
	('332310', '3323', 'Jumo'),
	('332311', '3323', 'Tretep'),
	('332312', '3323', 'Candiroto'),
	('332313', '3323', 'Kranggan'),
	('332314', '3323', 'Tlogomulyo'),
	('332315', '3323', 'Selopampang'),
	('332316', '3323', 'Bansari'),
	('332317', '3323', 'Kledung'),
	('332318', '3323', 'Bejen'),
	('332319', '3323', 'Wonoboyo'),
	('332320', '3323', 'Gemawang'),
	('332401', '3324', 'Plantungan'),
	('332402', '3324', 'Pageruyung'),
	('332403', '3324', 'Sukorejo'),
	('332404', '3324', 'Patean'),
	('332405', '3324', 'Singorojo'),
	('332406', '3324', 'Limbangan'),
	('332407', '3324', 'Boja'),
	('332408', '3324', 'Kaliwungu'),
	('332409', '3324', 'Brangsong'),
	('332410', '3324', 'Pegandon'),
	('332411', '3324', 'Gemuh'),
	('332412', '3324', 'Weleri'),
	('332413', '3324', 'Cepiring'),
	('332414', '3324', 'Patebon'),
	('332415', '3324', 'Kendal'),
	('332416', '3324', 'Rowosari'),
	('332417', '3324', 'Kangkung'),
	('332418', '3324', 'Ringinarum'),
	('332419', '3324', 'Ngampel'),
	('332420', '3324', 'Kaliwungu Selatan'),
	('332501', '3325', 'Wonotunggal'),
	('332502', '3325', 'Bandar'),
	('332503', '3325', 'Blado'),
	('332504', '3325', 'Reban'),
	('332505', '3325', 'Bawang'),
	('332506', '3325', 'Tersono'),
	('332507', '3325', 'Gringsing'),
	('332508', '3325', 'Limpung'),
	('332509', '3325', 'Subah'),
	('332510', '3325', 'Tulis'),
	('332511', '3325', 'Batang'),
	('332512', '3325', 'Warungasem'),
	('332513', '3325', 'Kandeman'),
	('332514', '3325', 'Pecalungan'),
	('332515', '3325', 'Banyuputih'),
	('332601', '3326', 'Kandangserang'),
	('332602', '3326', 'Paninggaran'),
	('332603', '3326', 'Lebakbarang'),
	('332604', '3326', 'Petungkriyono'),
	('332605', '3326', 'Talun'),
	('332606', '3326', 'Doro'),
	('332607', '3326', 'Karanganyar'),
	('332608', '3326', 'Kajen'),
	('332609', '3326', 'Kesesi'),
	('332610', '3326', 'Sragi'),
	('332611', '3326', 'Bojong'),
	('332612', '3326', 'Wonopringgo'),
	('332613', '3326', 'Kedungwuni'),
	('332614', '3326', 'Buaran'),
	('332615', '3326', 'Tirto'),
	('332616', '3326', 'Wiradesa'),
	('332617', '3326', 'Siwalan'),
	('332618', '3326', 'Karangdadap'),
	('332619', '3326', 'Wonokerto'),
	('332701', '3327', 'Moga'),
	('332702', '3327', 'Pulosari'),
	('332703', '3327', 'Belik'),
	('332704', '3327', 'Watukumpul'),
	('332705', '3327', 'Bodeh'),
	('332706', '3327', 'Bantarbolang'),
	('332707', '3327', 'Randudongkal'),
	('332708', '3327', 'Pemalang'),
	('332709', '3327', 'Taman'),
	('332710', '3327', 'Petarukan'),
	('332711', '3327', 'Ampelgading'),
	('332712', '3327', 'Comal'),
	('332713', '3327', 'Ulujami'),
	('332714', '3327', 'Warungpring'),
	('332801', '3328', 'Margasari'),
	('332802', '3328', 'Bumijawa'),
	('332803', '3328', 'Bojong'),
	('332804', '3328', 'Balapulang'),
	('332805', '3328', 'Pagerbarang'),
	('332806', '3328', 'Lebaksiu'),
	('332807', '3328', 'Jatinegara'),
	('332808', '3328', 'Kedungbanteng'),
	('332809', '3328', 'Pangkah'),
	('332810', '3328', 'Slawi'),
	('332811', '3328', 'Adiwerna'),
	('332812', '3328', 'Talang'),
	('332813', '3328', 'Dukuhturi'),
	('332814', '3328', 'Tarub'),
	('332815', '3328', 'Kramat'),
	('332816', '3328', 'Suradadi'),
	('332817', '3328', 'Warureja'),
	('332818', '3328', 'Dukuhwaru'),
	('332901', '3329', 'Salem'),
	('332902', '3329', 'Bantarkawung'),
	('332903', '3329', 'Bumiayu'),
	('332904', '3329', 'Paguyangan'),
	('332905', '3329', 'Sirampog'),
	('332906', '3329', 'Tonjong'),
	('332907', '3329', 'Jatibarang'),
	('332908', '3329', 'Wanasari'),
	('332909', '3329', 'Brebes'),
	('332910', '3329', 'Songgom'),
	('332911', '3329', 'Kersana'),
	('332912', '3329', 'Losari'),
	('332913', '3329', 'Tanjung'),
	('332914', '3329', 'Bulakamba'),
	('332915', '3329', 'Larangan'),
	('332916', '3329', 'Ketanggungan'),
	('332917', '3329', 'Banjarharjo'),
	('337101', '3371', 'Magelang Selatan'),
	('337102', '3371', 'Magelang Utara'),
	('337103', '3371', 'Magelang Tengah'),
	('337201', '3372', 'Laweyan'),
	('337202', '3372', 'Serengan'),
	('337203', '3372', 'Pasar Kliwon'),
	('337204', '3372', 'Jebres'),
	('337205', '3372', 'Banjarsari'),
	('337301', '3373', 'Sidorejo'),
	('337302', '3373', 'Tingkir'),
	('337303', '3373', 'Argomulyo'),
	('337304', '3373', 'Sidomukti'),
	('337401', '3374', 'Semarang Tengah'),
	('337402', '3374', 'Semarang Utara'),
	('337403', '3374', 'Semarang Timur'),
	('337404', '3374', 'Gayamsari'),
	('337405', '3374', 'Genuk'),
	('337406', '3374', 'Pedurungan'),
	('337407', '3374', 'Semarang Selatan'),
	('337408', '3374', 'Candisari'),
	('337409', '3374', 'Gajahmungkur'),
	('337410', '3374', 'Tembalang'),
	('337411', '3374', 'Banyumanik'),
	('337412', '3374', 'Gunungpati'),
	('337413', '3374', 'Semarang Barat'),
	('337414', '3374', 'Mijen'),
	('337415', '3374', 'Ngaliyan'),
	('337416', '3374', 'Tugu'),
	('337501', '3375', 'Pekalongan Barat'),
	('337502', '3375', 'Pekalongan Timur'),
	('337503', '3375', 'Pekalongan Utara'),
	('337504', '3375', 'Pekalongan Selatan'),
	('337601', '3376', 'Tegal Barat'),
	('337602', '3376', 'Tegal Timur'),
	('337603', '3376', 'Tegal Selatan'),
	('337604', '3376', 'Margadana'),
	('340101', '3401', 'Temon'),
	('340102', '3401', 'Wates'),
	('340103', '3401', 'Panjatan'),
	('340104', '3401', 'Galur'),
	('340105', '3401', 'Lendah'),
	('340106', '3401', 'Sentolo'),
	('340107', '3401', 'Pengasih'),
	('340108', '3401', 'Kokap'),
	('340109', '3401', 'Girimulyo'),
	('340110', '3401', 'Nanggulan'),
	('340111', '3401', 'Samigaluh'),
	('340112', '3401', 'Kalibawang'),
	('340201', '3402', 'Srandakan'),
	('340202', '3402', 'Sanden'),
	('340203', '3402', 'Kretek'),
	('340204', '3402', 'Pundong'),
	('340205', '3402', 'Bambang Lipuro'),
	('340206', '3402', 'Pandak'),
	('340207', '3402', 'Pajangan'),
	('340208', '3402', 'Bantul'),
	('340209', '3402', 'Jetis'),
	('340210', '3402', 'Imogiri'),
	('340211', '3402', 'Dlingo'),
	('340212', '3402', 'Banguntapan'),
	('340213', '3402', 'Pleret'),
	('340214', '3402', 'Piyungan'),
	('340215', '3402', 'Sewon'),
	('340216', '3402', 'Kasihan'),
	('340217', '3402', 'Sedayu'),
	('340301', '3403', 'Wonosari'),
	('340302', '3403', 'Nglipar'),
	('340303', '3403', 'Playen'),
	('340304', '3403', 'Patuk'),
	('340305', '3403', 'Paliyan'),
	('340306', '3403', 'Panggang'),
	('340307', '3403', 'Tepus'),
	('340308', '3403', 'Semanu'),
	('340309', '3403', 'Karangmojo'),
	('340310', '3403', 'Ponjong'),
	('340311', '3403', 'Rongkop'),
	('340312', '3403', 'Semin'),
	('340313', '3403', 'Ngawen'),
	('340314', '3403', 'Gedangsari'),
	('340315', '3403', 'Saptosari'),
	('340316', '3403', 'Girisubo'),
	('340317', '3403', 'Tanjungsari'),
	('340318', '3403', 'Purwosari'),
	('340401', '3404', 'Gamping'),
	('340402', '3404', 'Godean'),
	('340403', '3404', 'Moyudan'),
	('340404', '3404', 'Minggir'),
	('340405', '3404', 'Seyegan'),
	('340406', '3404', 'Mlati'),
	('340407', '3404', 'Depok'),
	('340408', '3404', 'Berbah'),
	('340409', '3404', 'Prambanan'),
	('340410', '3404', 'Kalasan'),
	('340411', '3404', 'Ngemplak'),
	('340412', '3404', 'Ngaglik'),
	('340413', '3404', 'Sleman'),
	('340414', '3404', 'Tempel'),
	('340415', '3404', 'Turi'),
	('340416', '3404', 'Pakem'),
	('340417', '3404', 'Cangkringan'),
	('347101', '3471', 'Tegalrejo'),
	('347102', '3471', 'Jetis'),
	('347103', '3471', 'Gondokusuman'),
	('347104', '3471', 'Danurejan'),
	('347105', '3471', 'Gedongtengen'),
	('347106', '3471', 'Ngampilan'),
	('347107', '3471', 'Wirobrajan'),
	('347108', '3471', 'Mantrijeron'),
	('347109', '3471', 'Kraton'),
	('347110', '3471', 'Gondomanan'),
	('347111', '3471', 'Pakualaman'),
	('347112', '3471', 'Mergangsan'),
	('347113', '3471', 'Umbulharjo'),
	('347114', '3471', 'Kotagede'),
	('350101', '3501', 'Donorojo'),
	('350102', '3501', 'Pringkuku'),
	('350103', '3501', 'Punung'),
	('350104', '3501', 'Pacitan'),
	('350105', '3501', 'Kebonagung'),
	('350106', '3501', 'Arjosari'),
	('350107', '3501', 'Nawangan'),
	('350108', '3501', 'Bandar'),
	('350109', '3501', 'Tegalombo'),
	('350110', '3501', 'Tulakan'),
	('350111', '3501', 'Ngadirojo'),
	('350112', '3501', 'Sudimoro'),
	('350201', '3502', 'Slahung'),
	('350202', '3502', 'Ngrayun'),
	('350203', '3502', 'Bungkal'),
	('350204', '3502', 'Sambit'),
	('350205', '3502', 'Sawoo'),
	('350206', '3502', 'Sooko'),
	('350207', '3502', 'Pulung'),
	('350208', '3502', 'Mlarak'),
	('350209', '3502', 'Jetis'),
	('350210', '3502', 'Siman'),
	('350211', '3502', 'Balong'),
	('350212', '3502', 'Kauman'),
	('350213', '3502', 'Badegan'),
	('350214', '3502', 'Sampung'),
	('350215', '3502', 'Sukorejo'),
	('350216', '3502', 'Babadan'),
	('350217', '3502', 'Ponorogo'),
	('350218', '3502', 'Jenangan'),
	('350219', '3502', 'Ngebel'),
	('350220', '3502', 'Jambon'),
	('350221', '3502', 'Pudak'),
	('350301', '3503', 'Panggul'),
	('350302', '3503', 'Munjungan'),
	('350303', '3503', 'Pule'),
	('350304', '3503', 'Dongko'),
	('350305', '3503', 'Tugu'),
	('350306', '3503', 'Karangan'),
	('350307', '3503', 'Kampak'),
	('350308', '3503', 'Watulimo'),
	('350309', '3503', 'Bendungan'),
	('350310', '3503', 'Gandusari'),
	('350311', '3503', 'Trenggalek'),
	('350312', '3503', 'Pogalan'),
	('350313', '3503', 'Durenan'),
	('350314', '3503', 'Suruh'),
	('350401', '3504', 'Tulungagung'),
	('350402', '3504', 'Boyolangu'),
	('350403', '3504', 'Kedungwaru'),
	('350404', '3504', 'Ngantru'),
	('350405', '3504', 'Kauman'),
	('350406', '3504', 'Pagerwojo'),
	('350407', '3504', 'Sendang'),
	('350408', '3504', 'Karangrejo'),
	('350409', '3504', 'Gondang'),
	('350410', '3504', 'Sumbergempol'),
	('350411', '3504', 'Ngunut'),
	('350412', '3504', 'Pucanglaban'),
	('350413', '3504', 'Rejotangan'),
	('350414', '3504', 'Kalidawir'),
	('350415', '3504', 'Besuki'),
	('350416', '3504', 'Campurdarat'),
	('350417', '3504', 'Bandung'),
	('350418', '3504', 'Pakel'),
	('350419', '3504', 'Tanggunggunung'),
	('350501', '3505', 'Wonodadi'),
	('350502', '3505', 'Udanawu'),
	('350503', '3505', 'Srengat'),
	('350504', '3505', 'Kademangan'),
	('350505', '3505', 'Bakung'),
	('350506', '3505', 'Ponggok'),
	('350507', '3505', 'Sanankulon'),
	('350508', '3505', 'Wonotirto'),
	('350509', '3505', 'Nglegok'),
	('350510', '3505', 'Kanigoro'),
	('350511', '3505', 'Garum'),
	('350512', '3505', 'Sutojayan'),
	('350513', '3505', 'Panggungrejo'),
	('350514', '3505', 'Talun'),
	('350515', '3505', 'Gandusari'),
	('350516', '3505', 'Binangun'),
	('350517', '3505', 'Wlingi'),
	('350518', '3505', 'Doko'),
	('350519', '3505', 'Kesamben'),
	('350520', '3505', 'Wates'),
	('350521', '3505', 'Selorejo'),
	('350522', '3505', 'Selopuro'),
	('350601', '3506', 'Semen'),
	('350602', '3506', 'Mojo'),
	('350603', '3506', 'Kras'),
	('350604', '3506', 'Ngadiluwih'),
	('350605', '3506', 'Kandat'),
	('350606', '3506', 'Wates'),
	('350607', '3506', 'Ngancar'),
	('350608', '3506', 'Puncu'),
	('350609', '3506', 'Plosoklaten'),
	('350610', '3506', 'Gurah'),
	('350611', '3506', 'Pagu'),
	('350612', '3506', 'Gampengrejo'),
	('350613', '3506', 'Grogol'),
	('350614', '3506', 'Papar'),
	('350615', '3506', 'Purwoasri'),
	('350616', '3506', 'Plemahan'),
	('350617', '3506', 'Pare'),
	('350618', '3506', 'Kepung'),
	('350619', '3506', 'Kandangan'),
	('350620', '3506', 'Tarokan'),
	('350621', '3506', 'Kunjang'),
	('350622', '3506', 'Banyakan'),
	('350623', '3506', 'Ringinrejo'),
	('350624', '3506', 'Kayen Kidul'),
	('350625', '3506', 'Ngasem'),
	('350626', '3506', 'Badas'),
	('350701', '3507', 'Donomulyo'),
	('350702', '3507', 'Pagak'),
	('350703', '3507', 'Bantur'),
	('350704', '3507', 'Sumbermanjing Wetan'),
	('350705', '3507', 'Dampit'),
	('350706', '3507', 'Ampelgading'),
	('350707', '3507', 'Poncokusumo'),
	('350708', '3507', 'Wajak'),
	('350709', '3507', 'Turen'),
	('350710', '3507', 'Gondanglegi'),
	('350711', '3507', 'Kalipare'),
	('350712', '3507', 'Sumberpucung'),
	('350713', '3507', 'Kepanjen'),
	('350714', '3507', 'Bululawang'),
	('350715', '3507', 'Tajinan'),
	('350716', '3507', 'Tumpang'),
	('350717', '3507', 'Jabung'),
	('350718', '3507', 'Pakis'),
	('350719', '3507', 'Pakisaji'),
	('350720', '3507', 'Ngajung'),
	('350721', '3507', 'Wagir'),
	('350722', '3507', 'Dau'),
	('350723', '3507', 'Karang Ploso'),
	('350724', '3507', 'Singosari'),
	('350725', '3507', 'Lawang'),
	('350726', '3507', 'Pujon'),
	('350727', '3507', 'Ngantang'),
	('350728', '3507', 'Kasembon'),
	('350729', '3507', 'Gedangan'),
	('350730', '3507', 'Tirtoyudo'),
	('350731', '3507', 'Kromengan'),
	('350732', '3507', 'Wonosari'),
	('350733', '3507', 'Pagelaran'),
	('350801', '3508', 'Tempursari'),
	('350802', '3508', 'Pronojiwo'),
	('350803', '3508', 'Candipuro'),
	('350804', '3508', 'Pasirian'),
	('350805', '3508', 'Tempeh'),
	('350806', '3508', 'Kunir'),
	('350807', '3508', 'Yosowilangun'),
	('350808', '3508', 'Rowokangkung'),
	('350809', '3508', 'Tekung'),
	('350810', '3508', 'Lumajang'),
	('350811', '3508', 'Pasrujambe'),
	('350812', '3508', 'Senduro'),
	('350813', '3508', 'Gucialit'),
	('350814', '3508', 'Padang'),
	('350815', '3508', 'Sukodono'),
	('350816', '3508', 'Kedungjajang'),
	('350817', '3508', 'Jatiroto'),
	('350818', '3508', 'Randuagung'),
	('350819', '3508', 'Klakah'),
	('350820', '3508', 'Ranuyoso'),
	('350821', '3508', 'Sumbersuko'),
	('350901', '3509', 'Jombang'),
	('350902', '3509', 'Kencong'),
	('350903', '3509', 'Sumberbaru'),
	('350904', '3509', 'Gumukmas'),
	('350905', '3509', 'Umbulsari'),
	('350906', '3509', 'Tanggul'),
	('350907', '3509', 'Semboro'),
	('350908', '3509', 'Puger'),
	('350909', '3509', 'Bangsalsari'),
	('350910', '3509', 'Balung'),
	('350911', '3509', 'Wuluhan'),
	('350912', '3509', 'Ambulu'),
	('350913', '3509', 'Rambipuji'),
	('350914', '3509', 'Panti'),
	('350915', '3509', 'Sukorambi'),
	('350916', '3509', 'Jenggawah'),
	('350917', '3509', 'Ajung'),
	('350918', '3509', 'Tempurejo'),
	('350919', '3509', 'Kaliwates'),
	('350920', '3509', 'Patrang'),
	('350921', '3509', 'Sumbersari'),
	('350922', '3509', 'Arjasa'),
	('350923', '3509', 'Mumbulsari'),
	('350924', '3509', 'Pakusari'),
	('350925', '3509', 'Jelbuk'),
	('350926', '3509', 'Mayang'),
	('350927', '3509', 'Kalisat'),
	('350928', '3509', 'Ledokombo'),
	('350929', '3509', 'Sukowono'),
	('350930', '3509', 'Silo'),
	('350931', '3509', 'Sumberjambe'),
	('351001', '3510', 'Pesanggaran'),
	('351002', '3510', 'Bangorejo'),
	('351003', '3510', 'Purwoharjo'),
	('351004', '3510', 'Tegaldlimo'),
	('351005', '3510', 'Muncar'),
	('351006', '3510', 'Cluring'),
	('351007', '3510', 'Gambiran'),
	('351008', '3510', 'Srono'),
	('351009', '3510', 'Genteng'),
	('351010', '3510', 'Glenmore'),
	('351011', '3510', 'Kalibaru'),
	('351012', '3510', 'Singojuruh'),
	('351013', '3510', 'Rogojampi'),
	('351014', '3510', 'Kabat'),
	('351015', '3510', 'Glagah'),
	('351016', '3510', 'Banyuwangi'),
	('351017', '3510', 'Giri'),
	('351018', '3510', 'Wongsorejo'),
	('351019', '3510', 'Songgon'),
	('351020', '3510', 'Sempu'),
	('351021', '3510', 'Kalipuro'),
	('351022', '3510', 'Siliragung'),
	('351023', '3510', 'Tegalsari'),
	('351024', '3510', 'Licin'),
	('351101', '3511', 'Maesan'),
	('351102', '3511', 'Tamanan'),
	('351103', '3511', 'Tlogosari'),
	('351104', '3511', 'Sukosari'),
	('351105', '3511', 'Pujer'),
	('351106', '3511', 'Grujugan'),
	('351107', '3511', 'Curahdami'),
	('351108', '3511', 'Tenggarang'),
	('351109', '3511', 'Wonosari'),
	('351110', '3511', 'Tapen'),
	('351111', '3511', 'Bondowoso'),
	('351112', '3511', 'Wringin'),
	('351113', '3511', 'Tegalampel'),
	('351114', '3511', 'Klabang'),
	('351115', '3511', 'Cermee'),
	('351116', '3511', 'Prajekan'),
	('351117', '3511', 'Pakem'),
	('351118', '3511', 'Sumberwringin'),
	('351119', '3511', 'Sempol'),
	('351120', '3511', 'Binakal'),
	('351121', '3511', 'Taman Krocok'),
	('351122', '3511', 'Botolinggo'),
	('351123', '3511', 'Jambesari Darus Sholah'),
	('351201', '3512', 'Jatibanteng'),
	('351202', '3512', 'Besuki'),
	('351203', '3512', 'Suboh'),
	('351204', '3512', 'Mlandingan'),
	('351205', '3512', 'Kendit'),
	('351206', '3512', 'Panarukan'),
	('351207', '3512', 'Situbondo'),
	('351208', '3512', 'Panji'),
	('351209', '3512', 'Mangaran'),
	('351210', '3512', 'Kapongan'),
	('351211', '3512', 'Arjasa'),
	('351212', '3512', 'Jangkar'),
	('351213', '3512', 'Asembagus'),
	('351214', '3512', 'Banyuputih'),
	('351215', '3512', 'Sumbermalang'),
	('351216', '3512', 'Banyuglugur'),
	('351217', '3512', 'Bungatan'),
	('351301', '3513', 'Sukapura'),
	('351302', '3513', 'Sumber'),
	('351303', '3513', 'Kuripan'),
	('351304', '3513', 'Bantaran'),
	('351305', '3513', 'Leces'),
	('351306', '3513', 'Banyuanyar'),
	('351307', '3513', 'Tiris'),
	('351308', '3513', 'Krucil'),
	('351309', '3513', 'Gading'),
	('351310', '3513', 'Pakuniran'),
	('351311', '3513', 'Kotaanyar'),
	('351312', '3513', 'Paiton'),
	('351313', '3513', 'Besuk'),
	('351314', '3513', 'Kraksaan'),
	('351315', '3513', 'Krejengan'),
	('351316', '3513', 'Pejarakan'),
	('351317', '3513', 'Maron'),
	('351318', '3513', 'Gending'),
	('351319', '3513', 'Dringu'),
	('351320', '3513', 'Tegalsiwalan'),
	('351321', '3513', 'Sumberasih'),
	('351322', '3513', 'Wonomerto'),
	('351323', '3513', 'Tongas'),
	('351324', '3513', 'Lumbang'),
	('351401', '3514', 'Purwodadi'),
	('351402', '3514', 'Tutur'),
	('351403', '3514', 'Puspo'),
	('351404', '3514', 'Lumbang'),
	('351405', '3514', 'Pasrepan'),
	('351406', '3514', 'Kejayan'),
	('351407', '3514', 'Wonorejo'),
	('351408', '3514', 'Purwosari'),
	('351409', '3514', 'Sukorejo'),
	('351410', '3514', 'Prigen'),
	('351411', '3514', 'Pandaan'),
	('351412', '3514', 'Gempol'),
	('351413', '3514', 'Beji'),
	('351414', '3514', 'Bangil'),
	('351415', '3514', 'Rembang'),
	('351416', '3514', 'Kraton'),
	('351417', '3514', 'Pohjentrek'),
	('351418', '3514', 'Gondangwetan'),
	('351419', '3514', 'Winongan'),
	('351420', '3514', 'Grati'),
	('351421', '3514', 'Nguling'),
	('351422', '3514', 'Lekok'),
	('351423', '3514', 'Rejoso'),
	('351424', '3514', 'Tosari'),
	('351501', '3515', 'Tarik'),
	('351502', '3515', 'Prambon'),
	('351503', '3515', 'Krembung'),
	('351504', '3515', 'Porong'),
	('351505', '3515', 'Jabon'),
	('351506', '3515', 'Tanggulangin'),
	('351507', '3515', 'Candi'),
	('351508', '3515', 'Sidoarjo'),
	('351509', '3515', 'Tulangan'),
	('351510', '3515', 'Wonoayu'),
	('351511', '3515', 'Krian'),
	('351512', '3515', 'Balongbendo'),
	('351513', '3515', 'Taman'),
	('351514', '3515', 'Sukodono'),
	('351515', '3515', 'Buduran'),
	('351516', '3515', 'Gedangan'),
	('351517', '3515', 'Sedati'),
	('351518', '3515', 'Waru'),
	('351601', '3516', 'Jatirejo'),
	('351602', '3516', 'Gondang'),
	('351603', '3516', 'Pacet'),
	('351604', '3516', 'Trawas'),
	('351605', '3516', 'Ngoro'),
	('351606', '3516', 'Pungging'),
	('351607', '3516', 'Kutorejo'),
	('351608', '3516', 'Mojosari'),
	('351609', '3516', 'Dlanggu'),
	('351610', '3516', 'Bangsal'),
	('351611', '3516', 'Puri'),
	('351612', '3516', 'Trowulan'),
	('351613', '3516', 'Sooko'),
	('351614', '3516', 'Gedeg'),
	('351615', '3516', 'Kemlagi'),
	('351616', '3516', 'Jetis'),
	('351617', '3516', 'Dawarblandong'),
	('351618', '3516', 'Mojoanyar'),
	('351701', '3517', 'Perak'),
	('351702', '3517', 'Gudo'),
	('351703', '3517', 'Ngoro'),
	('351704', '3517', 'Bareng'),
	('351705', '3517', 'Wonosalam'),
	('351706', '3517', 'Mojoagung'),
	('351707', '3517', 'Mojowarno'),
	('351708', '3517', 'Diwek'),
	('351709', '3517', 'Jombang'),
	('351710', '3517', 'Peterongan'),
	('351711', '3517', 'Sumobito'),
	('351712', '3517', 'Kesamben'),
	('351713', '3517', 'Tembelang'),
	('351714', '3517', 'Ploso'),
	('351715', '3517', 'Plandaan'),
	('351716', '3517', 'Kabuh'),
	('351717', '3517', 'Kudu'),
	('351718', '3517', 'Bandarkedungmulyo'),
	('351719', '3517', 'Jogoroto'),
	('351720', '3517', 'Megaluh'),
	('351721', '3517', 'Ngusikan'),
	('351801', '3518', 'Sawahan'),
	('351802', '3518', 'Ngetos'),
	('351803', '3518', 'Berbek'),
	('351804', '3518', 'Loceret'),
	('351805', '3518', 'Pace'),
	('351806', '3518', 'Prambon'),
	('351807', '3518', 'Ngronggot'),
	('351808', '3518', 'Kertosono'),
	('351809', '3518', 'Patianrowo'),
	('351810', '3518', 'Baron'),
	('351811', '3518', 'Tanjunganom'),
	('351812', '3518', 'Sukomoro'),
	('351813', '3518', 'Nganjuk'),
	('351814', '3518', 'Bagor'),
	('351815', '3518', 'Wilangan'),
	('351816', '3518', 'Rejoso'),
	('351817', '3518', 'Gondang'),
	('351818', '3518', 'Ngluyu'),
	('351819', '3518', 'Lengkong'),
	('351820', '3518', 'Jatikalen'),
	('351901', '3519', 'Kebon Sari'),
	('351902', '3519', 'Dolopo'),
	('351903', '3519', 'Geger'),
	('351904', '3519', 'Dagangan'),
	('351905', '3519', 'Kare'),
	('351906', '3519', 'Gemarang'),
	('351907', '3519', 'Wungu'),
	('351908', '3519', 'Madiun'),
	('351909', '3519', 'Jiwan'),
	('351910', '3519', 'Balerejo'),
	('351911', '3519', 'Mejayan'),
	('351912', '3519', 'Saradan'),
	('351913', '3519', 'Pilangkenceng'),
	('351914', '3519', 'Sawahan'),
	('351915', '3519', 'Wonoasri'),
	('352001', '3520', 'Poncol'),
	('352002', '3520', 'Parang'),
	('352003', '3520', 'Lembeyan'),
	('352004', '3520', 'Takeran'),
	('352005', '3520', 'Kawedanan'),
	('352006', '3520', 'Magetan'),
	('352007', '3520', 'Plaosan'),
	('352008', '3520', 'Panekan'),
	('352009', '3520', 'Sukomoro'),
	('352010', '3520', 'Bendo'),
	('352011', '3520', 'Maospati'),
	('352012', '3520', 'Barat'),
	('352013', '3520', 'Karangrejo'),
	('352014', '3520', 'Karas'),
	('352015', '3520', 'Kartoharjo'),
	('352016', '3520', 'Ngariboyo'),
	('352017', '3520', 'Nguntoronadi'),
	('352018', '3520', 'Sidorejo'),
	('352101', '3521', 'Sine'),
	('352102', '3521', 'Ngrambe'),
	('352103', '3521', 'Jogorogo'),
	('352104', '3521', 'Kendal'),
	('352105', '3521', 'Geneng'),
	('352106', '3521', 'Kwadungan'),
	('352107', '3521', 'Karangjati'),
	('352108', '3521', 'Padas'),
	('352109', '3521', 'Ngawi'),
	('352110', '3521', 'Paron'),
	('352111', '3521', 'Kedunggalar'),
	('352112', '3521', 'Widodaren'),
	('352113', '3521', 'Mantingan'),
	('352114', '3521', 'Pangkur'),
	('352115', '3521', 'Bringin'),
	('352116', '3521', 'Pitu'),
	('352117', '3521', 'Karanganyar'),
	('352118', '3521', 'Gerih'),
	('352119', '3521', 'Kasreman'),
	('352201', '3522', 'Ngraho'),
	('352202', '3522', 'Tambakrejo'),
	('352203', '3522', 'Ngambon'),
	('352204', '3522', 'Ngasem'),
	('352205', '3522', 'Bubulan'),
	('352206', '3522', 'Dander'),
	('352207', '3522', 'Sugihwaras'),
	('352208', '3522', 'Kedungadem'),
	('352209', '3522', 'Kepoh Baru'),
	('352210', '3522', 'Baureno'),
	('352211', '3522', 'Kanor'),
	('352212', '3522', 'Sumberejo'),
	('352213', '3522', 'Balen'),
	('352214', '3522', 'Kapas'),
	('352215', '3522', 'Bojonegoro'),
	('352216', '3522', 'Kalitidu'),
	('352217', '3522', 'Malo'),
	('352218', '3522', 'Purwosari'),
	('352219', '3522', 'Padangan'),
	('352220', '3522', 'Kasiman'),
	('352221', '3522', 'Temayang'),
	('352222', '3522', 'Margomulyo'),
	('352223', '3522', 'Trucuk'),
	('352224', '3522', 'Sukosewu'),
	('352225', '3522', 'Kedewan'),
	('352226', '3522', 'Gondang'),
	('352227', '3522', 'Sekar'),
	('352228', '3522', 'Gayam'),
	('352301', '3523', 'Kenduruan'),
	('352302', '3523', 'Jatirogo'),
	('352303', '3523', 'Bangilan'),
	('352304', '3523', 'Bancar'),
	('352305', '3523', 'Senori'),
	('352306', '3523', 'Tambakboyo'),
	('352307', '3523', 'Singgahan'),
	('352308', '3523', 'Kerek'),
	('352309', '3523', 'Parengan'),
	('352310', '3523', 'Montong'),
	('352311', '3523', 'Soko'),
	('352312', '3523', 'Jenu'),
	('352313', '3523', 'Merakurak'),
	('352314', '3523', 'Rengel'),
	('352315', '3523', 'Semanding'),
	('352316', '3523', 'Tuban'),
	('352317', '3523', 'Plumpang'),
	('352318', '3523', 'Palang'),
	('352319', '3523', 'Widang'),
	('352320', '3523', 'Grabagan'),
	('352401', '3524', 'Sukorame'),
	('352402', '3524', 'Bluluk'),
	('352403', '3524', 'Modo'),
	('352404', '3524', 'Ngimbang'),
	('352405', '3524', 'Babat'),
	('352406', '3524', 'Kedungpring'),
	('352407', '3524', 'Brondong'),
	('352408', '3524', 'Laren'),
	('352409', '3524', 'Sekaran'),
	('352410', '3524', 'Maduran'),
	('352411', '3524', 'Sambeng'),
	('352412', '3524', 'Sugio'),
	('352413', '3524', 'Pucuk'),
	('352414', '3524', 'Paciran'),
	('352415', '3524', 'Solokuro'),
	('352416', '3524', 'Mantup'),
	('352417', '3524', 'Sukodadi'),
	('352418', '3524', 'Karanggeneng'),
	('352419', '3524', 'Kembangbahu'),
	('352420', '3524', 'Kalitengah'),
	('352421', '3524', 'Turi'),
	('352422', '3524', 'Lamongan'),
	('352423', '3524', 'Tikung'),
	('352424', '3524', 'Karangbinangun'),
	('352425', '3524', 'Deket'),
	('352426', '3524', 'Glagah'),
	('352427', '3524', 'Sarirejo'),
	('352501', '3525', 'Dukun'),
	('352502', '3525', 'Balongpanggang'),
	('352503', '3525', 'Panceng'),
	('352504', '3525', 'Benjeng'),
	('352505', '3525', 'Duduksampeyan'),
	('352506', '3525', 'Wringinanom'),
	('352507', '3525', 'Ujungpangkah'),
	('352508', '3525', 'Kedamean'),
	('352509', '3525', 'Sidayu'),
	('352510', '3525', 'Manyar'),
	('352511', '3525', 'Cerme'),
	('352512', '3525', 'Bungah'),
	('352513', '3525', 'Menganti'),
	('352514', '3525', 'Kebomas'),
	('352515', '3525', 'Driyorejo'),
	('352516', '3525', 'Gresik'),
	('352517', '3525', 'Sangkapura'),
	('352518', '3525', 'Tambak'),
	('352601', '3526', 'Bangkalan'),
	('352602', '3526', 'Socah'),
	('352603', '3526', 'Burneh'),
	('352604', '3526', 'Kamal'),
	('352605', '3526', 'Arosbaya'),
	('352606', '3526', 'Geger'),
	('352607', '3526', 'Klampis'),
	('352608', '3526', 'Sepulu'),
	('352609', '3526', 'Tanjung Bumi'),
	('352610', '3526', 'Kokop'),
	('352611', '3526', 'Kwanyar'),
	('352612', '3526', 'Labang'),
	('352613', '3526', 'Tanah Merah'),
	('352614', '3526', 'Tragah'),
	('352615', '3526', 'Blega'),
	('352616', '3526', 'Modung'),
	('352617', '3526', 'Konang'),
	('352618', '3526', 'Galis'),
	('352701', '3527', 'Sreseh'),
	('352702', '3527', 'Torjun'),
	('352703', '3527', 'Sampang'),
	('352704', '3527', 'Camplong'),
	('352705', '3527', 'Omben'),
	('352706', '3527', 'Kedungdung'),
	('352707', '3527', 'Jrengik'),
	('352708', '3527', 'Tambelangan'),
	('352709', '3527', 'Banyuates'),
	('352710', '3527', 'Robatal'),
	('352711', '3527', 'Sokobanah'),
	('352712', '3527', 'Ketapang'),
	('352713', '3527', 'Pangarengan'),
	('352714', '3527', 'Karangpenang'),
	('352801', '3528', 'Tlanakan'),
	('352802', '3528', 'Pademawu'),
	('352803', '3528', 'Galis'),
	('352804', '3528', 'Pamekasan'),
	('352805', '3528', 'Proppo'),
	('352806', '3528', 'Palenga"an'),
	('352807', '3528', 'Pegantenan'),
	('352808', '3528', 'Larangan'),
	('352809', '3528', 'Pakong'),
	('352810', '3528', 'Waru'),
	('352811', '3528', 'Batumarmar'),
	('352812', '3528', 'Kadur'),
	('352813', '3528', 'Pasean'),
	('352901', '3529', 'Kota Sumenep'),
	('352902', '3529', 'Kalianget'),
	('352903', '3529', 'Manding'),
	('352904', '3529', 'Talango'),
	('352905', '3529', 'Bluto'),
	('352906', '3529', 'Saronggi'),
	('352907', '3529', 'Lenteng'),
	('352908', '3529', 'Gili Ginting'),
	('352909', '3529', 'Guluk-Guluk'),
	('352910', '3529', 'Ganding'),
	('352911', '3529', 'Pragaan'),
	('352912', '3529', 'Ambunten'),
	('352913', '3529', 'Pasongsongan'),
	('352914', '3529', 'Dasuk'),
	('352915', '3529', 'Rubaru'),
	('352916', '3529', 'Batang Batang'),
	('352917', '3529', 'Batu Putih'),
	('352918', '3529', 'Dungkek'),
	('352919', '3529', 'Gapura'),
	('352920', '3529', 'Gayam'),
	('352921', '3529', 'Nonggunong'),
	('352922', '3529', 'Ra"as'),
	('352923', '3529', 'Masalembu'),
	('352924', '3529', 'Arjasa'),
	('352925', '3529', 'Sapeken'),
	('352926', '3529', 'Batuan'),
	('352927', '3529', 'Kangayan'),
	('357101', '3571', 'Mojoroto'),
	('357102', '3571', 'Kota'),
	('357103', '3571', 'Pesantren'),
	('357201', '3572', 'Kepanjenkidul'),
	('357202', '3572', 'Sukorejo'),
	('357203', '3572', 'Sananwetan'),
	('357301', '3573', 'Blimbing'),
	('357302', '3573', 'Klojen'),
	('357303', '3573', 'Kedungkandang'),
	('357304', '3573', 'Sukun'),
	('357305', '3573', 'Lowokwaru'),
	('357401', '3574', 'Kademangan'),
	('357402', '3574', 'Wonoasih'),
	('357403', '3574', 'Mayangan'),
	('357404', '3574', 'Kanigaran'),
	('357405', '3574', 'Kedopak'),
	('357501', '3575', 'Gadingrejo'),
	('357502', '3575', 'Purworejo'),
	('357503', '3575', 'Bugul Kidul'),
	('357504', '3575', 'Panggungrejo'),
	('357601', '3576', 'Prajurit Kulon'),
	('357602', '3576', 'Magersari'),
	('357701', '3577', 'Kartoharjo'),
	('357702', '3577', 'Manguharjo'),
	('357703', '3577', 'Taman'),
	('357801', '3578', 'Karangpilang'),
	('357802', '3578', 'Wonocolo'),
	('357803', '3578', 'Rungkut'),
	('357804', '3578', 'Wonokromo'),
	('357805', '3578', 'Tegalsari'),
	('357806', '3578', 'Sawahan'),
	('357807', '3578', 'Genteng'),
	('357808', '3578', 'Gubeng'),
	('357809', '3578', 'Sukolilo'),
	('357810', '3578', 'Tambaksari'),
	('357811', '3578', 'Simokerto'),
	('357812', '3578', 'Pabean Cantikan'),
	('357813', '3578', 'Bubutan'),
	('357814', '3578', 'Tandes'),
	('357815', '3578', 'Krembangan'),
	('357816', '3578', 'Semampir'),
	('357817', '3578', 'Kenjeran'),
	('357818', '3578', 'Lakarsantri'),
	('357819', '3578', 'Benowo'),
	('357820', '3578', 'Wiyung'),
	('357821', '3578', 'Dukuhpakis'),
	('357822', '3578', 'Gayungan'),
	('357823', '3578', 'Jambangan'),
	('357824', '3578', 'Tenggilis Mejoyo'),
	('357825', '3578', 'Gunung Anyar'),
	('357826', '3578', 'Mulyorejo'),
	('357827', '3578', 'Sukomanunggal'),
	('357828', '3578', 'Asem Rowo'),
	('357829', '3578', 'Bulak'),
	('357830', '3578', 'Pakal'),
	('357831', '3578', 'Sambikerep'),
	('357901', '3579', 'Batu'),
	('357902', '3579', 'Bumiaji'),
	('357903', '3579', 'Junrejo'),
	('360101', '3601', 'Sumur'),
	('360102', '3601', 'Cimanggu'),
	('360103', '3601', 'Cibaliung'),
	('360104', '3601', 'Cikeusik'),
	('360105', '3601', 'Cigeulis'),
	('360106', '3601', 'Panimbang'),
	('360107', '3601', 'Angsana'),
	('360108', '3601', 'Munjul'),
	('360109', '3601', 'Pagelaran'),
	('360110', '3601', 'Bojong'),
	('360111', '3601', 'Picung'),
	('360112', '3601', 'Labuan'),
	('360113', '3601', 'Menes'),
	('360114', '3601', 'Saketi'),
	('360115', '3601', 'Cipeucang'),
	('360116', '3601', 'Jiput'),
	('360117', '3601', 'Mandalawangi'),
	('360118', '3601', 'Cimanuk'),
	('360119', '3601', 'Kaduhejo'),
	('360120', '3601', 'Banjar'),
	('360121', '3601', 'Pandeglang'),
	('360122', '3601', 'Cadasari'),
	('360123', '3601', 'Cisata'),
	('360124', '3601', 'Patia'),
	('360125', '3601', 'Karang Tanjung'),
	('360126', '3601', 'Cikedal'),
	('360127', '3601', 'Cibitung'),
	('360128', '3601', 'Carita'),
	('360129', '3601', 'Sukaresmi'),
	('360130', '3601', 'Mekarjaya'),
	('360131', '3601', 'Sindangresmi'),
	('360132', '3601', 'Pulosari'),
	('360133', '3601', 'Koroncong'),
	('360134', '3601', 'Majasari'),
	('360135', '3601', 'Sobang'),
	('360201', '3602', 'Malingping'),
	('360202', '3602', 'Panggarangan'),
	('360203', '3602', 'Bayah'),
	('360204', '3602', 'Cipanas'),
	('360205', '3602', 'Muncang'),
	('360206', '3602', 'Leuwidamar'),
	('360207', '3602', 'Bojongmanik'),
	('360208', '3602', 'Gunungkencana'),
	('360209', '3602', 'Banjarsari'),
	('360210', '3602', 'Cileles'),
	('360211', '3602', 'Cimarga'),
	('360212', '3602', 'Sajira'),
	('360213', '3602', 'Maja'),
	('360214', '3602', 'Rangkasbitung'),
	('360215', '3602', 'Warunggunung'),
	('360216', '3602', 'Cijaku'),
	('360217', '3602', 'Cikulur'),
	('360218', '3602', 'Cibadak'),
	('360219', '3602', 'Cibeber'),
	('360220', '3602', 'Cilograng'),
	('360221', '3602', 'Wanasalam'),
	('360222', '3602', 'Sobang'),
	('360223', '3602', 'Curug bitung'),
	('360224', '3602', 'Kalanganyar'),
	('360225', '3602', 'Lebakgedong'),
	('360226', '3602', 'Cihara'),
	('360227', '3602', 'Cirinten'),
	('360228', '3602', 'Cigemlong'),
	('360301', '3603', 'Balaraja'),
	('360302', '3603', 'Jayanti'),
	('360303', '3603', 'Tigaraksa'),
	('360304', '3603', 'Jambe'),
	('360305', '3603', 'Cisoka'),
	('360306', '3603', 'Kresek'),
	('360307', '3603', 'Kronjo'),
	('360308', '3603', 'Mauk'),
	('360309', '3603', 'Kemiri'),
	('360310', '3603', 'Sukadiri'),
	('360311', '3603', 'Rajeg'),
	('360312', '3603', 'Pasar Kemis'),
	('360313', '3603', 'Teluknaga'),
	('360314', '3603', 'Kosambi'),
	('360315', '3603', 'Pakuhaji'),
	('360316', '3603', 'Sepatan'),
	('360317', '3603', 'Curug'),
	('360318', '3603', 'Cikupa'),
	('360319', '3603', 'Panongan'),
	('360320', '3603', 'Legok'),
	('360322', '3603', 'Pagedangan'),
	('360323', '3603', 'Cisauk'),
	('360327', '3603', 'Sukamulya'),
	('360328', '3603', 'Kelapa Dua'),
	('360329', '3603', 'Sindang Jaya'),
	('360330', '3603', 'Sepatan Timur'),
	('360331', '3603', 'Solear'),
	('360332', '3603', 'Gunung Kaler'),
	('360333', '3603', 'Mekar Baru'),
	('360405', '3604', 'Kramatwatu'),
	('360406', '3604', 'Waringinkurung'),
	('360407', '3604', 'Bojonegara'),
	('360408', '3604', 'Pulo Ampel'),
	('360409', '3604', 'Ciruas'),
	('360411', '3604', 'Kragilan'),
	('360412', '3604', 'Pontang'),
	('360413', '3604', 'Tirtayasa'),
	('360414', '3604', 'Tanara'),
	('360415', '3604', 'Cikande'),
	('360416', '3604', 'Kibin'),
	('360417', '3604', 'Carenang'),
	('360418', '3604', 'Binuang'),
	('360419', '3604', 'Petir'),
	('360420', '3604', 'Tunjung Teja'),
	('360422', '3604', 'Baros'),
	('360423', '3604', 'Cikeusal'),
	('360424', '3604', 'Pamarayan'),
	('360425', '3604', 'Kopo'),
	('360426', '3604', 'Jawilan'),
	('360427', '3604', 'Ciomas'),
	('360428', '3604', 'Pabuaran'),
	('360429', '3604', 'Padarincang'),
	('360430', '3604', 'Anyar'),
	('360431', '3604', 'Cinangka'),
	('360432', '3604', 'Mancak'),
	('360433', '3604', 'Gunung Sari'),
	('360434', '3604', 'Bandung'),
	('360435', '3604', 'Lebak Wangi'),
	('367101', '3671', 'Tangerang'),
	('367102', '3671', 'Jatiuwung'),
	('367103', '3671', 'Batuceper'),
	('367104', '3671', 'Benda'),
	('367105', '3671', 'Cipondoh'),
	('367106', '3671', 'Ciledug'),
	('367107', '3671', 'Karawaci'),
	('367108', '3671', 'Periuk'),
	('367109', '3671', 'Cibodas'),
	('367110', '3671', 'Neglasari'),
	('367111', '3671', 'Pinang'),
	('367112', '3671', 'Karang Tengah'),
	('367113', '3671', 'Larangan'),
	('367201', '3672', 'Cibeber'),
	('367202', '3672', 'Cilegon'),
	('367203', '3672', 'Pulomerak'),
	('367204', '3672', 'Ciwandan'),
	('367205', '3672', 'Jombang'),
	('367206', '3672', 'Gerogol'),
	('367207', '3672', 'Purwakarta'),
	('367208', '3672', 'Citangkil'),
	('367301', '3673', 'Serang'),
	('367302', '3673', 'Kasemen'),
	('367303', '3673', 'Walantaka'),
	('367304', '3673', 'Curug'),
	('367305', '3673', 'Cipocok Jaya'),
	('367306', '3673', 'Taktakan'),
	('367401', '3674', 'Serpong'),
	('367402', '3674', 'Serpong Utara'),
	('367403', '3674', 'Pondok Aren'),
	('367404', '3674', 'Ciputat'),
	('367405', '3674', 'Ciputat Timur'),
	('367406', '3674', 'Pamulang'),
	('367407', '3674', 'Setu'),
	('510101', '5101', 'Negara'),
	('510102', '5101', 'Mendoyo'),
	('510103', '5101', 'Pekutatan'),
	('510104', '5101', 'Melaya'),
	('510105', '5101', 'Jembrana'),
	('510201', '5102', 'Selemadeg'),
	('510202', '5102', 'Salamadeg Timur'),
	('510203', '5102', 'Salemadeg Barat'),
	('510204', '5102', 'Kerambitan'),
	('510205', '5102', 'Tabanan'),
	('510206', '5102', 'Kediri'),
	('510207', '5102', 'Marga'),
	('510208', '5102', 'Penebel'),
	('510209', '5102', 'Baturiti'),
	('510210', '5102', 'Pupuan'),
	('510301', '5103', 'Kuta'),
	('510302', '5103', 'Mengwi'),
	('510303', '5103', 'Abiansemal'),
	('510304', '5103', 'Petang'),
	('510305', '5103', 'Kuta Selatan'),
	('510306', '5103', 'Kuta Utara'),
	('510401', '5104', 'Sukawati'),
	('510402', '5104', 'Blahbatuh'),
	('510403', '5104', 'Gianyar'),
	('510404', '5104', 'Tampaksiring'),
	('510405', '5104', 'Ubud'),
	('510406', '5104', 'Tegalallang'),
	('510407', '5104', 'Payangan'),
	('510501', '5105', 'Nusa Penida'),
	('510502', '5105', 'Banjarangkan'),
	('510503', '5105', 'Klungkung'),
	('510504', '5105', 'Dawan'),
	('510601', '5106', 'Susut'),
	('510602', '5106', 'Bangli'),
	('510603', '5106', 'Tembuku'),
	('510604', '5106', 'Kintamani'),
	('510701', '5107', 'Rendang'),
	('510702', '5107', 'Sidemen'),
	('510703', '5107', 'Manggis'),
	('510704', '5107', 'Karangasem'),
	('510705', '5107', 'Abang'),
	('510706', '5107', 'Bebandem'),
	('510707', '5107', 'Selat'),
	('510708', '5107', 'Kubu'),
	('510801', '5108', 'Gerokgak'),
	('510802', '5108', 'Seririt'),
	('510803', '5108', 'Busung biu'),
	('510804', '5108', 'Banjar'),
	('510805', '5108', 'Sukasada'),
	('510806', '5108', 'Buleleng'),
	('510807', '5108', 'Sawan'),
	('510808', '5108', 'Kubutambahan'),
	('510809', '5108', 'Tejakula'),
	('517101', '5171', 'Denpasar Selatan'),
	('517102', '5171', 'Denpasar Timur'),
	('517103', '5171', 'Denpasar Barat'),
	('517104', '5171', 'Denpasar Utara'),
	('520101', '5201', 'Gerung'),
	('520102', '5201', 'Kediri'),
	('520103', '5201', 'Narmada'),
	('520107', '5201', 'Sekotong'),
	('520108', '5201', 'Labuapi'),
	('520109', '5201', 'Gunungsari'),
	('520112', '5201', 'Lingsar'),
	('520113', '5201', 'Lembar'),
	('520114', '5201', 'Batu Layar'),
	('520115', '5201', 'Kuripan'),
	('520201', '5202', 'Praya'),
	('520202', '5202', 'Jonggat'),
	('520203', '5202', 'Batukliang'),
	('520204', '5202', 'Pujut'),
	('520205', '5202', 'Praya Barat'),
	('520206', '5202', 'Praya Timur'),
	('520207', '5202', 'Janapria'),
	('520208', '5202', 'Pringgarata'),
	('520209', '5202', 'Kopang'),
	('520210', '5202', 'Praya Tengah'),
	('520211', '5202', 'Praya Barat Daya'),
	('520212', '5202', 'Batukliang Utara'),
	('520301', '5203', 'Keruak'),
	('520302', '5203', 'Sakra'),
	('520303', '5203', 'Terara'),
	('520304', '5203', 'Sikur'),
	('520305', '5203', 'Masbagik'),
	('520306', '5203', 'Sukamulia'),
	('520307', '5203', 'Selong'),
	('520308', '5203', 'Pringgabaya'),
	('520309', '5203', 'Aikmel'),
	('520310', '5203', 'Sambelia'),
	('520311', '5203', 'Montong Gading'),
	('520312', '5203', 'Pringgasela'),
	('520313', '5203', 'Suralaga'),
	('520314', '5203', 'Wanasaba'),
	('520315', '5203', 'Sembalun'),
	('520316', '5203', 'Suwela'),
	('520317', '5203', 'Labuhan Haji'),
	('520318', '5203', 'Sakra Timur'),
	('520319', '5203', 'Sakra Barat'),
	('520320', '5203', 'Jerowaru'),
	('520402', '5204', 'Lunyuk'),
	('520405', '5204', 'Alas'),
	('520406', '5204', 'Utan'),
	('520407', '5204', 'Batu Lanteh'),
	('520408', '5204', 'Sumbawa'),
	('520409', '5204', 'Moyo Hilir'),
	('520410', '5204', 'Moyo Hulu'),
	('520411', '5204', 'Ropang'),
	('520412', '5204', 'Lape'),
	('520413', '5204', 'Plampang'),
	('520414', '5204', 'Empang'),
	('520417', '5204', 'Alas Barat'),
	('520418', '5204', 'Labuhan Badas'),
	('520419', '5204', 'Labangka'),
	('520420', '5204', 'Buer'),
	('520421', '5204', 'Rhee'),
	('520422', '5204', 'Unter Iwes'),
	('520423', '5204', 'Moyo Utara'),
	('520424', '5204', 'Maronge'),
	('520425', '5204', 'Tarano'),
	('520426', '5204', 'Lopok'),
	('520427', '5204', 'Lenangguar'),
	('520428', '5204', 'Orong Telu'),
	('520429', '5204', 'Lantung'),
	('520501', '5205', 'Dompu'),
	('520502', '5205', 'Kempo'),
	('520503', '5205', 'Hu\'u'),
	('520504', '5205', 'Kilo'),
	('520505', '5205', 'Woja'),
	('520506', '5205', 'Pekat'),
	('520507', '5205', 'Manggalewa'),
	('520508', '5205', 'Pajo'),
	('520601', '5206', 'Monta'),
	('520602', '5206', 'Bolo'),
	('520603', '5206', 'Woha'),
	('520604', '5206', 'Belo'),
	('520605', '5206', 'Wawo'),
	('520606', '5206', 'Sape'),
	('520607', '5206', 'Wera'),
	('520608', '5206', 'Donggo'),
	('520609', '5206', 'Sanggar'),
	('520610', '5206', 'Ambalawi'),
	('520611', '5206', 'Langgudu'),
	('520612', '5206', 'Lambu'),
	('520613', '5206', 'Madapangga'),
	('520614', '5206', 'Tambora'),
	('520615', '5206', 'Soromandi'),
	('520616', '5206', 'Parado'),
	('520617', '5206', 'Lambitu'),
	('520618', '5206', 'Palibelo'),
	('520701', '5207', 'Jereweh'),
	('520702', '5207', 'Taliwang'),
	('520703', '5207', 'Seteluk'),
	('520704', '5207', 'Sekongkang'),
	('520705', '5207', 'Brang Rea'),
	('520706', '5207', 'Poto Tano'),
	('520707', '5207', 'Brang Ene'),
	('520708', '5207', 'Maluk'),
	('520801', '5208', 'Tanjung'),
	('520802', '5208', 'Gangga'),
	('520803', '5208', 'Kayangan'),
	('520804', '5208', 'Bayan'),
	('520805', '5208', 'Pemenang'),
	('527101', '5271', 'Ampenan'),
	('527102', '5271', 'Mataram'),
	('527103', '5271', 'Cakranegara'),
	('527104', '5271', 'Sekarbela'),
	('527105', '5271', 'Selaprang'),
	('527106', '5271', 'Sandubaya'),
	('527201', '5272', 'RasanaE Barat'),
	('527202', '5272', 'RasanaE Timur'),
	('527203', '5272', 'Asakota'),
	('527204', '5272', 'Raba'),
	('527205', '5272', 'Mpunda'),
	('530104', '5301', 'Semau'),
	('530105', '5301', 'Kupang Barat'),
	('530106', '5301', 'Kupang Timur'),
	('530107', '5301', 'Sulamu'),
	('530108', '5301', 'Kupang Tengah'),
	('530109', '5301', 'Amarasi'),
	('530110', '5301', 'Fatuleu'),
	('530111', '5301', 'Takari'),
	('530112', '5301', 'Amfoang Selatan'),
	('530113', '5301', 'Amfoang Utara'),
	('530116', '5301', 'Nekamese'),
	('530117', '5301', 'Amarasi Barat'),
	('530118', '5301', 'Amarasi Selatan'),
	('530119', '5301', 'Amarasi Timur'),
	('530120', '5301', 'Amabi Oefeto Timur'),
	('530121', '5301', 'Amfoang Barat Daya'),
	('530122', '5301', 'Amfoang Barat Laut'),
	('530123', '5301', 'Semau Selatan'),
	('530124', '5301', 'Taebenu'),
	('530125', '5301', 'Amabi Oefeto'),
	('530126', '5301', 'Amfoang Timur'),
	('530127', '5301', 'Fatuleu Barat'),
	('530128', '5301', 'Fatuleu Tengah'),
	('530130', '5301', 'Amfoang Tengah'),
	('530201', '5302', 'Kota Soe'),
	('530202', '5302', 'Mollo Selatan'),
	('530203', '5302', 'Mollo Utara'),
	('530204', '5302', 'Amanuban Timur'),
	('530205', '5302', 'Amanuban Tengah'),
	('530206', '5302', 'Amanuban Selatan'),
	('530207', '5302', 'Amanuban Barat'),
	('530208', '5302', 'Amanatun Selatan'),
	('530209', '5302', 'Amanatun Utara'),
	('530210', '5302', 'KI\'E'),
	('530211', '5302', 'Kuanfatu'),
	('530212', '5302', 'Fatumnasi'),
	('530213', '5302', 'Polen'),
	('530214', '5302', 'Batu Putih'),
	('530215', '5302', 'Boking'),
	('530216', '5302', 'Toianas'),
	('530217', '5302', 'Nunkolo'),
	('530218', '5302', 'Oenino'),
	('530219', '5302', 'Kolbano'),
	('530220', '5302', 'Kot olin'),
	('530221', '5302', 'Kualin'),
	('530222', '5302', 'Mollo Barat'),
	('530223', '5302', 'Kok Baun'),
	('530224', '5302', 'Noebana'),
	('530225', '5302', 'Santian'),
	('530226', '5302', 'Noebeba'),
	('530227', '5302', 'Kuatnana'),
	('530228', '5302', 'Fautmolo'),
	('530229', '5302', 'Fatukopa'),
	('530230', '5302', 'Mollo Tengah'),
	('530231', '5302', 'Tobu'),
	('530232', '5302', 'Nunbena'),
	('530301', '5303', 'Miomafo Timur'),
	('530302', '5303', 'Miomafo Barat'),
	('530303', '5303', 'Biboki Selatan'),
	('530304', '5303', 'Noemuti'),
	('530305', '5303', 'Kota Kefamenanu'),
	('530306', '5303', 'Biboki Utara'),
	('530307', '5303', 'Biboki Anleu'),
	('530308', '5303', 'Insana'),
	('530309', '5303', 'Insana Utara'),
	('530310', '5303', 'Noemuti Timur'),
	('530311', '5303', 'Miomaffo Tengah'),
	('530312', '5303', 'Musi'),
	('530313', '5303', 'Mutis'),
	('530314', '5303', 'Bikomi Selatan'),
	('530315', '5303', 'Bikomi Tengah'),
	('530316', '5303', 'Bikomi Nilulat'),
	('530317', '5303', 'Bikomi Utara'),
	('530318', '5303', 'Naibenu'),
	('530319', '5303', 'Insana Fafinesu'),
	('530320', '5303', 'Insana Barat'),
	('530321', '5303', 'Insana Tengah'),
	('530322', '5303', 'Biboki Tan Pah'),
	('530323', '5303', 'Biboki Moenleu'),
	('530324', '5303', 'Biboki Feotleu'),
	('530401', '5304', 'Lamaknen'),
	('530402', '5304', 'TasifetoTimur'),
	('530403', '5304', 'Raihat'),
	('530404', '5304', 'Tasifeto Barat'),
	('530405', '5304', 'Kakuluk Mesak'),
	('530412', '5304', 'Kota Atambua'),
	('530413', '5304', 'Raimanuk'),
	('530417', '5304', 'Lasiolat'),
	('530418', '5304', 'Lamaknen Selatan'),
	('530421', '5304', 'Atambua Barat'),
	('530422', '5304', 'Atambua Selatan'),
	('530423', '5304', 'Nanaet Duabesi'),
	('530501', '5305', 'Teluk Mutiara'),
	('530502', '5305', 'Alor Barat Laut'),
	('530503', '5305', 'Alor Barat Daya'),
	('530504', '5305', 'Alor Selatan'),
	('530505', '5305', 'Alor Timur'),
	('530506', '5305', 'Pantar'),
	('530507', '5305', 'Alor Tengah Utara'),
	('530508', '5305', 'Alor Timur Laut'),
	('530509', '5305', 'Pantar Barat'),
	('530510', '5305', 'Kabola'),
	('530511', '5305', 'Pulau Pura'),
	('530512', '5305', 'Mataru'),
	('530513', '5305', 'Pureman'),
	('530514', '5305', 'Pantar Timur'),
	('530515', '5305', 'Lembur'),
	('530516', '5305', 'Pantar Tengah'),
	('530517', '5305', 'Pantar Baru Laut'),
	('530601', '5306', 'Wulanggitang'),
	('530602', '5306', 'Titehena'),
	('530603', '5306', 'Larantuka'),
	('530604', '5306', 'Ile Mandiri'),
	('530605', '5306', 'Tanjung Bunga'),
	('530606', '5306', 'Solor Barat'),
	('530607', '5306', 'Solor Timur'),
	('530608', '5306', 'Adonara Barat'),
	('530609', '5306', 'Wotan Ulumando'),
	('530610', '5306', 'Adonara Timur'),
	('530611', '5306', 'Kelubagolit'),
	('530612', '5306', 'Witihama'),
	('530613', '5306', 'Ile Boleng'),
	('530614', '5306', 'Demon Pagong'),
	('530615', '5306', 'Lewolema'),
	('530616', '5306', 'Ile Bura'),
	('530617', '5306', 'Adonara'),
	('530618', '5306', 'Adonara Tengah'),
	('530619', '5306', 'Solor Selatan'),
	('530701', '5307', 'Paga'),
	('530702', '5307', 'Mego'),
	('530703', '5307', 'Lela'),
	('530704', '5307', 'Nita'),
	('530705', '5307', 'Alok'),
	('530706', '5307', 'Palue'),
	('530707', '5307', 'Nelle'),
	('530708', '5307', 'Talibura'),
	('530709', '5307', 'Waigete'),
	('530710', '5307', 'Kewapante'),
	('530711', '5307', 'Bola'),
	('530712', '5307', 'Magepanda'),
	('530713', '5307', 'Waiblama'),
	('530714', '5307', 'Alok Barat'),
	('530715', '5307', 'Alok Timur'),
	('530716', '5307', 'Koting'),
	('530717', '5307', 'Tana Wawo'),
	('530718', '5307', 'Hewokloang'),
	('530719', '5307', 'Kangae'),
	('530720', '5307', 'Doreng'),
	('530721', '5307', 'Mapitara'),
	('530801', '5308', 'Nangapanda'),
	('530802', '5308', 'Pulau Ende'),
	('530803', '5308', 'Ende'),
	('530804', '5308', 'Ende Selatan'),
	('530805', '5308', 'Ndona'),
	('530806', '5308', 'Detusoko'),
	('530807', '5308', 'Wewaria'),
	('530808', '5308', 'Wolowaru'),
	('530809', '5308', 'Wolojita'),
	('530810', '5308', 'Maurole'),
	('530811', '5308', 'Maukaro'),
	('530812', '5308', 'Lio Timur'),
	('530813', '5308', 'Kota Baru'),
	('530814', '5308', 'Kelimutu'),
	('530815', '5308', 'Detukeli'),
	('530816', '5308', 'Ndona Timur'),
	('530817', '5308', 'Ndori'),
	('530818', '5308', 'Ende Utara'),
	('530819', '5308', 'Ende Tengah'),
	('530820', '5308', 'Ende Timur'),
	('530821', '5308', 'Lepembusu Kelisoke'),
	('530901', '5309', 'Aimere'),
	('530902', '5309', 'Golewa'),
	('530906', '5309', 'Bajawa'),
	('530907', '5309', 'Soa'),
	('530909', '5309', 'Riung'),
	('530912', '5309', 'Jerebuu'),
	('530914', '5309', 'Riung Barat'),
	('530915', '5309', 'Bajawa Utara'),
	('530916', '5309', 'Wolomeze'),
	('530918', '5309', 'Golewa Selatan'),
	('530919', '5309', 'Golewa Barat'),
	('530920', '5309', 'Inerie'),
	('531001', '5310', 'Wae Rii'),
	('531003', '5310', 'Ruteng'),
	('531005', '5310', 'Satar Mese'),
	('531006', '5310', 'Cibal'),
	('531011', '5310', 'Reok'),
	('531012', '5310', 'Langke Rembong'),
	('531013', '5310', 'Satar Mese Barat'),
	('531014', '5310', 'Rahong Utara'),
	('531015', '5310', 'Lelak'),
	('531016', '5310', 'Reok Barat'),
	('531017', '5310', 'Cibal barat'),
	('531101', '5311', 'Kota Waingapu'),
	('531102', '5311', 'Haharu'),
	('531103', '5311', 'Lewa'),
	('531104', '5311', 'Nggaha Ori Angu'),
	('531105', '5311', 'Tabundung'),
	('531106', '5311', 'Pinu Pahar'),
	('531107', '5311', 'Pandawai'),
	('531108', '5311', 'Umalulu'),
	('531109', '5311', 'Rindi'),
	('531110', '5311', 'Pahunga Lodu'),
	('531111', '5311', 'Wulla Waijelu'),
	('531112', '5311', 'Paberiwai'),
	('531113', '5311', 'Karera'),
	('531114', '5311', 'Kahaungu Eti'),
	('531115', '5311', 'Matawai La Pawu'),
	('531116', '5311', 'Kambera'),
	('531117', '5311', 'Kambata Mapambuhang'),
	('531118', '5311', 'Lewa Tidahu'),
	('531119', '5311', 'Katala Hamu Lingu'),
	('531120', '5311', 'Kanatang'),
	('531121', '5311', 'Ngadu Ngala'),
	('531122', '5311', 'Mahu'),
	('531204', '5312', 'Tana Righu'),
	('531210', '5312', 'Loli'),
	('531211', '5312', 'Wanokaka'),
	('531212', '5312', 'Lamboya'),
	('531215', '5312', 'Kota Waikabubak'),
	('531218', '5312', 'Laboya Barat'),
	('531301', '5313', 'Naga Wutung'),
	('531302', '5313', 'Atadei'),
	('531303', '5313', 'Ile Ape'),
	('531304', '5313', 'Lebatukan'),
	('531305', '5313', 'Nubatukan'),
	('531306', '5313', 'Omesuri'),
	('531307', '5313', 'Buyasuri'),
	('531308', '5313', 'Wulandoni'),
	('531309', '5313', 'Ile Ape Timur'),
	('531401', '5314', 'Rote Barat Daya'),
	('531402', '5314', 'Rote Barat Laut'),
	('531403', '5314', 'Lobalain'),
	('531404', '5314', 'Rote Tengah'),
	('531405', '5314', 'Pantai Baru'),
	('531406', '5314', 'Rote Timur'),
	('531407', '5314', 'Rote Barat'),
	('531408', '5314', 'Rote Selatan'),
	('531409', '5314', 'Ndao Nuse'),
	('531410', '5314', 'Landu Leko'),
	('531501', '5315', 'Macang Pacar'),
	('531502', '5315', 'Kuwus'),
	('531503', '5315', 'Lembor'),
	('531504', '5315', 'Sano Nggoang'),
	('531505', '5315', 'Komodo'),
	('531506', '5315', 'Boleng'),
	('531507', '5315', 'Welak'),
	('531508', '5315', 'Ndoso'),
	('531509', '5315', 'Lembor Selatan'),
	('531510', '5315', 'Mbeliling'),
	('531601', '5316', 'Aesesa'),
	('531602', '5316', 'Nangaroro'),
	('531603', '5316', 'Boawae'),
	('531604', '5316', 'Mauponggo'),
	('531605', '5316', 'Wolowae'),
	('531606', '5316', 'Keo Tengah'),
	('531607', '5316', 'Aesesa Selatan'),
	('531701', '5317', 'Katiku Tana'),
	('531702', '5317', 'Umbu Ratu Nggay Barat'),
	('531703', '5317', 'Mamboro'),
	('531704', '5317', 'Umbu Ratu Nggay'),
	('531705', '5317', 'Katiku Tana Selatan'),
	('531801', '5318', 'Loura'),
	('531802', '5318', 'Wewewa Utara'),
	('531803', '5318', 'Wewewa Timur'),
	('531804', '5318', 'Wewewa Barat'),
	('531805', '5318', 'Wewewa Selatan'),
	('531806', '5318', 'Kodi Bangedo'),
	('531807', '5318', 'Kodi'),
	('531808', '5318', 'Kodi Utara'),
	('531809', '5318', 'Kota Tambolaka'),
	('531810', '5318', 'Wewewa Tengah'),
	('531811', '5318', 'Kodi Balaghar'),
	('531901', '5319', 'Borong'),
	('531902', '5319', 'Poco Ranaka'),
	('531903', '5319', 'Lamba Leda'),
	('531904', '5319', 'Sambi Rampas'),
	('531905', '5319', 'Elar'),
	('531906', '5319', 'Kota Komba'),
	('531907', '5319', 'Rana Mese'),
	('531908', '5319', 'Poco Ranaka Timur'),
	('531909', '5319', 'Elar Selatan'),
	('532001', '5320', 'Sabu Barat'),
	('532002', '5320', 'Sabu Tengah'),
	('532003', '5320', 'Sabu Timur'),
	('532004', '5320', 'Sabu Liae'),
	('532005', '5320', 'Hawu Mehara'),
	('532006', '5320', 'Raijua'),
	('532101', '5321', 'Malaka Tengah'),
	('532102', '5321', 'Malaka Barat'),
	('532103', '5321', 'Wewiku'),
	('532104', '5321', 'Weliman'),
	('532105', '5321', 'Rinhat'),
	('532106', '5321', 'Io Kufeu'),
	('532107', '5321', 'Sasitamean'),
	('532108', '5321', 'Laenmanen'),
	('532109', '5321', 'Malaka Timur'),
	('532110', '5321', 'Kobalima Timur'),
	('532111', '5321', 'Kobalima'),
	('532112', '5321', 'Botin Leobele'),
	('537101', '5371', 'Alak'),
	('537102', '5371', 'Maulafa'),
	('537103', '5371', 'Kelapa Lima'),
	('537104', '5371', 'Oebobo'),
	('537105', '5371', 'Kota Raja'),
	('537106', '5371', 'Kota Lama'),
	('610101', '6101', 'Sambas'),
	('610102', '6101', 'Teluk Keramat'),
	('610103', '6101', 'Jawai'),
	('610104', '6101', 'Tebas'),
	('610105', '6101', 'Pemangkat'),
	('610106', '6101', 'Sejangkung'),
	('610107', '6101', 'Selakau'),
	('610108', '6101', 'Paloh'),
	('610109', '6101', 'Sajingan Besar'),
	('610110', '6101', 'Subah'),
	('610111', '6101', 'Galing'),
	('610112', '6101', 'Tekarang'),
	('610113', '6101', 'Semparuk'),
	('610114', '6101', 'Sajad'),
	('610115', '6101', 'Sebawi'),
	('610116', '6101', 'Jawai Selatan'),
	('610117', '6101', 'Tangaran'),
	('610118', '6101', 'Salatiga'),
	('610119', '6101', 'Selakau Timur'),
	('610201', '6102', 'Mempawah Hilir'),
	('610206', '6102', 'Toho'),
	('610207', '6102', 'Sungai Pinyuh'),
	('610208', '6102', 'Siantan'),
	('610212', '6102', 'Sungai Kunyit'),
	('610215', '6102', 'Segedong'),
	('610216', '6102', 'Anjongan'),
	('610217', '6102', 'Sadaniang'),
	('610218', '6102', 'Mempawah Timur'),
	('610301', '6103', 'Kapuas'),
	('610302', '6103', 'Mukok'),
	('610303', '6103', 'Noyan'),
	('610304', '6103', 'Jangkang'),
	('610305', '6103', 'Bonti'),
	('610306', '6103', 'Beduai'),
	('610307', '6103', 'Sekayam'),
	('610308', '6103', 'Kembayan'),
	('610309', '6103', 'Parindu'),
	('610310', '6103', 'Tayan Hulu'),
	('610311', '6103', 'Tayan Hilir'),
	('610312', '6103', 'Balai'),
	('610313', '6103', 'Toba'),
	('610320', '6103', 'Meliau'),
	('610321', '6103', 'Entikong'),
	('610401', '6104', 'Matan Hilir Utara'),
	('610402', '6104', 'Marau'),
	('610403', '6104', 'Manis Mata'),
	('610404', '6104', 'Kendawangan'),
	('610405', '6104', 'Sandai'),
	('610407', '6104', 'Sungai Laur'),
	('610408', '6104', 'Simpang Hulu'),
	('610411', '6104', 'Nanga Tayap'),
	('610412', '6104', 'Matan Hilir Selatan'),
	('610413', '6104', 'Tumbang Titi'),
	('610414', '6104', 'Jelai Hulu'),
	('610416', '6104', 'Delta Pawan'),
	('610417', '6104', 'Muara Pawan'),
	('610418', '6104', 'Benua Kayong'),
	('610419', '6104', 'Hulu Sungai'),
	('610420', '6104', 'Simpang Dua'),
	('610421', '6104', 'Air Upas'),
	('610422', '6104', 'Singkup'),
	('610424', '6104', 'Pemahan'),
	('610425', '6104', 'Sungai Melayu Rayak'),
	('610501', '6105', 'Sintang'),
	('610502', '6105', 'Tempunak'),
	('610503', '6105', 'Sepauk'),
	('610504', '6105', 'Ketungau Hilir'),
	('610505', '6105', 'Ketungau Tengah'),
	('610506', '6105', 'Ketungau Hulu'),
	('610507', '6105', 'Dedai'),
	('610508', '6105', 'Kayan Hilir'),
	('610509', '6105', 'Kayan Hulu'),
	('610514', '6105', 'Serawai'),
	('610515', '6105', 'Ambalau'),
	('610519', '6105', 'Kelam Permai'),
	('610520', '6105', 'Sungai Tebelian'),
	('610521', '6105', 'Binjai Hulu'),
	('610601', '6106', 'Putussibau Utara'),
	('610602', '6106', 'Bika'),
	('610603', '6106', 'Embaloh Hilir'),
	('610604', '6106', 'Embaloh Hulu'),
	('610605', '6106', 'Bunut Hilir'),
	('610606', '6106', 'Bunut Hulu'),
	('610607', '6106', 'Jongkong'),
	('610608', '6106', 'Hulu Gurung'),
	('610609', '6106', 'Selimbau'),
	('610610', '6106', 'Semitau'),
	('610611', '6106', 'Seberuang'),
	('610612', '6106', 'Batang Lupar'),
	('610613', '6106', 'Empanang'),
	('610614', '6106', 'Badau'),
	('610615', '6106', 'Silat Hilir'),
	('610616', '6106', 'Silat Hulu'),
	('610617', '6106', 'Putussibau Selatan'),
	('610618', '6106', 'Kalis'),
	('610619', '6106', 'Boyan Tanjung'),
	('610620', '6106', 'Mentebah'),
	('610621', '6106', 'Pengkadan'),
	('610622', '6106', 'Suhaid'),
	('610623', '6106', 'Puring Kencana'),
	('610701', '6107', 'Sungai Raya'),
	('610702', '6107', 'Samalantan'),
	('610703', '6107', 'Ledo'),
	('610704', '6107', 'Bengkayang'),
	('610705', '6107', 'Seluas'),
	('610706', '6107', 'Sanggau Ledo'),
	('610707', '6107', 'Jagoi Babang'),
	('610708', '6107', 'Monterado'),
	('610709', '6107', 'Teriak'),
	('610710', '6107', 'Suti Semarang'),
	('610711', '6107', 'Capkala'),
	('610712', '6107', 'Siding'),
	('610713', '6107', 'Lumar'),
	('610714', '6107', 'Sungai Betung'),
	('610715', '6107', 'Sungai Raya Kepulauan'),
	('610716', '6107', 'Lembah Bawang'),
	('610717', '6107', 'Tujuh Belas'),
	('610801', '6108', 'Ngabang'),
	('610802', '6108', 'Mempawah Hulu'),
	('610803', '6108', 'Menjalin'),
	('610804', '6108', 'Mandor'),
	('610805', '6108', 'Air Besar'),
	('610806', '6108', 'Menyuke'),
	('610807', '6108', 'Sengah Temila'),
	('610808', '6108', 'Meranti'),
	('610809', '6108', 'Kuala Behe'),
	('610810', '6108', 'Sebangki'),
	('610811', '6108', 'Jelimpo'),
	('610812', '6108', 'Banyuke Hulu'),
	('610813', '6108', 'Sompak'),
	('610901', '6109', 'Sekadau Hilir'),
	('610902', '6109', 'Sekadau Hulu'),
	('610903', '6109', 'Nanga Taman'),
	('610904', '6109', 'Nanga Mahap'),
	('610905', '6109', 'Belitang Hilir'),
	('610906', '6109', 'Belitang Hulu'),
	('610907', '6109', 'Belitang'),
	('611001', '6110', 'Belimbing'),
	('611002', '6110', 'Nanga Pinoh'),
	('611003', '6110', 'Ella Hilir'),
	('611004', '6110', 'Menukung'),
	('611005', '6110', 'Sayan'),
	('611006', '6110', 'Tanah Pinoh'),
	('611007', '6110', 'Sokan'),
	('611008', '6110', 'Pinoh Utara'),
	('611009', '6110', 'Pinoh Selatan'),
	('611010', '6110', 'Belimbing Hulu'),
	('611011', '6110', 'Tanah Pinoh Barat'),
	('611101', '6111', 'Sukadana'),
	('611102', '6111', 'Simpang Hilir'),
	('611103', '6111', 'Teluk Batang'),
	('611104', '6111', 'Pulau Maya'),
	('611105', '6111', 'Seponti'),
	('611106', '6111', 'Kepulauan Karimata'),
	('611201', '6112', 'Sungai Raya'),
	('611202', '6112', 'Kuala Mandor B'),
	('611203', '6112', 'Sungai Ambawang'),
	('611204', '6112', 'Terentang'),
	('611205', '6112', 'Batu Ampar'),
	('611206', '6112', 'Kubu'),
	('611207', '6112', 'Rasau Jaya'),
	('611208', '6112', 'Teluk Pakedai'),
	('611209', '6112', 'Sungai Kakap'),
	('617101', '6171', 'Pontianak Selatan'),
	('617102', '6171', 'Pontianak Timur'),
	('617103', '6171', 'Pontianak Barat'),
	('617104', '6171', 'Pontianak Utara'),
	('617105', '6171', 'Pontianak Kota'),
	('617106', '6171', 'Pontianak Tenggara'),
	('617201', '6172', 'Singkawang Tengah'),
	('617202', '6172', 'Singkawang Barat'),
	('617203', '6172', 'Singkawang Timur'),
	('617204', '6172', 'Singkawang Utara'),
	('617205', '6172', 'Singkawang Selatan'),
	('620101', '6201', 'Kumai'),
	('620102', '6201', 'Arut Selatan'),
	('620103', '6201', 'Kotawaringin Lama'),
	('620104', '6201', 'Arut Utara'),
	('620105', '6201', 'Pangkalan Lada'),
	('620106', '6201', 'Pangkalan Banteng'),
	('620201', '6202', 'Kota Besi'),
	('620202', '6202', 'Cempaga'),
	('620203', '6202', 'Mentaya Hulu'),
	('620204', '6202', 'Parenggean'),
	('620205', '6202', 'Baamang'),
	('620206', '6202', 'Mentawa Baru Ketapang'),
	('620207', '6202', 'Mentaya Hilir Utara'),
	('620208', '6202', 'Mentaya Hilir Selatan'),
	('620209', '6202', 'Pulau Hanaut'),
	('620210', '6202', 'Antang Kalang'),
	('620211', '6202', 'Teluk Sampit'),
	('620212', '6202', 'Seranau'),
	('620213', '6202', 'Cempaga Hulu'),
	('620214', '6202', 'Telawang'),
	('620215', '6202', 'Bukit Santuai'),
	('620216', '6202', 'Tualan Hulu'),
	('620217', '6202', 'Telaga Antang'),
	('620301', '6203', 'Selat'),
	('620302', '6203', 'Kapuas Hilir'),
	('620303', '6203', 'Kapuas Timur'),
	('620304', '6203', 'Kapuas Kuala'),
	('620305', '6203', 'Kapuas Barat'),
	('620306', '6203', 'Pulau Petak'),
	('620307', '6203', 'Kapuas Murung'),
	('620308', '6203', 'Basarang'),
	('620309', '6203', 'Mantangai'),
	('620310', '6203', 'Timpah'),
	('620311', '6203', 'Kapuas Tengah'),
	('620312', '6203', 'Kapuas Hulu'),
	('620313', '6203', 'Tamban Catur'),
	('620314', '6203', 'Pasak Talawang'),
	('620315', '6203', 'Mandau Talawang'),
	('620316', '6203', 'Dadahup'),
	('620317', '6203', 'Bataguh'),
	('620401', '6204', 'Jenamas'),
	('620402', '6204', 'Dusun Hilir'),
	('620403', '6204', 'Karau Kuala'),
	('620404', '6204', 'Dusun Utara'),
	('620405', '6204', 'Gn. Bintang Awai'),
	('620406', '6204', 'Dusun Selatan'),
	('620501', '6205', 'Montallat'),
	('620502', '6205', 'Gunung Timang'),
	('620503', '6205', 'Gunung Purei'),
	('620504', '6205', 'Teweh Timur'),
	('620505', '6205', 'Teweh Tengah'),
	('620506', '6205', 'Lahei'),
	('620507', '6205', 'Teweh Baru'),
	('620508', '6205', 'Teweh Selatan'),
	('620509', '6205', 'Lahei Barat'),
	('620601', '6206', 'Kampiang'),
	('620602', '6206', 'Katingan Hilir'),
	('620603', '6206', 'Tewang Sangalang Garing'),
	('620604', '6206', 'Pulau Malan'),
	('620605', '6206', 'Katingan Tengah'),
	('620606', '6206', 'Sanaman Mantikei'),
	('620607', '6206', 'Marikit'),
	('620608', '6206', 'Katingan Hulu'),
	('620609', '6206', 'Mendawai'),
	('620610', '6206', 'Katingan Kuala'),
	('620611', '6206', 'Tasik Payawan'),
	('620612', '6206', 'Petak Malai'),
	('620613', '6206', 'Bukit Raya'),
	('620701', '6207', 'Seruyan Hilir'),
	('620702', '6207', 'Seruyan Tengah'),
	('620703', '6207', 'Danau Sembuluh'),
	('620704', '6207', 'Hanau'),
	('620705', '6207', 'Seruyan Hulu'),
	('620706', '6207', 'Seruyan Hilir Timur'),
	('620707', '6207', 'Seruyan Raya'),
	('620708', '6207', 'Danau Seluluk'),
	('620709', '6207', 'Batu Ampar'),
	('620710', '6207', 'Suling Tambun'),
	('620801', '6208', 'Sukamara'),
	('620802', '6208', 'Jelai'),
	('620803', '6208', 'Balai Riam'),
	('620804', '6208', 'Pantai Lunci'),
	('620805', '6208', 'Permata Kecubung'),
	('620901', '6209', 'Lamandau'),
	('620902', '6209', 'Delang'),
	('620903', '6209', 'Bulik'),
	('620904', '6209', 'Bulik Timur'),
	('620905', '6209', 'Menthobi Raya'),
	('620906', '6209', 'Sematu Jaya'),
	('620907', '6209', 'Belantikan Raya'),
	('620908', '6209', 'Batang Kawa'),
	('621001', '6210', 'Sepang Simin'),
	('621002', '6210', 'Kurun'),
	('621003', '6210', 'Tewah'),
	('621004', '6210', 'Kahayan Hulu Utara'),
	('621005', '6210', 'Rungan'),
	('621006', '6210', 'Manuhing'),
	('621007', '6210', 'Mihing Raya'),
	('621008', '6210', 'Damang Batu'),
	('621009', '6210', 'Miri Manasa'),
	('621010', '6210', 'Rungan Hulu'),
	('621011', '6210', 'Mahuning Raya'),
	('621012', '6210', 'Rungan Barat'),
	('621101', '6211', 'Pandih Batu'),
	('621102', '6211', 'Kahayan Kuala'),
	('621103', '6211', 'Kahayan Tengah'),
	('621104', '6211', 'Banama Tingang'),
	('621105', '6211', 'Kahayan Hilir'),
	('621106', '6211', 'Maliku'),
	('621107', '6211', 'Jabiren'),
	('621108', '6211', 'Sebangau Kuala'),
	('621201', '6212', 'Murung'),
	('621202', '6212', 'Tanah Siang'),
	('621203', '6212', 'Laung Tuhup'),
	('621204', '6212', 'Permata Intan'),
	('621205', '6212', 'Sumber Barito'),
	('621206', '6212', 'Barito Tuhup Raya'),
	('621207', '6212', 'Tanah Siang Selatan'),
	('621208', '6212', 'Sungai Babuat'),
	('621209', '6212', 'Seribu Riam'),
	('621210', '6212', 'Uut Murung'),
	('621301', '6213', 'Dusun Timur'),
	('621302', '6213', 'Banua Lima'),
	('621303', '6213', 'Patangkep Tutui'),
	('621304', '6213', 'Awang'),
	('621305', '6213', 'Dusun Tengah'),
	('621306', '6213', 'Pematang Karau'),
	('621307', '6213', 'Paju Epat'),
	('621308', '6213', 'Raren Batuah'),
	('621309', '6213', 'Paku'),
	('621310', '6213', 'Karusen Janang'),
	('627101', '6271', 'Pahandut'),
	('627102', '6271', 'Bukit Batu'),
	('627103', '6271', 'Jekan Raya'),
	('627104', '6271', 'Sabangau'),
	('627105', '6271', 'Rakumpit'),
	('630101', '6301', 'Takisung'),
	('630102', '6301', 'Jorong'),
	('630103', '6301', 'Pelaihari'),
	('630104', '6301', 'Kurau'),
	('630105', '6301', 'Bati Bati'),
	('630106', '6301', 'Panyipatan'),
	('630107', '6301', 'Kintap'),
	('630108', '6301', 'Tambang Ulang'),
	('630109', '6301', 'Batu Ampar'),
	('630110', '6301', 'Bajuin'),
	('630111', '6301', 'Bumi Makmur'),
	('630201', '6302', 'Pulausembilan'),
	('630202', '6302', 'Pulaulaut Barat'),
	('630203', '6302', 'Pulaulaut Selatan'),
	('630204', '6302', 'Pulaulaut Timur'),
	('630205', '6302', 'Pulausebuku'),
	('630206', '6302', 'Pulaulaut Utara'),
	('630207', '6302', 'Kelumpang Selatan'),
	('630208', '6302', 'Kelumpang Hulu'),
	('630209', '6302', 'Kelumpang Tengah'),
	('630210', '6302', 'Kelumpang Utara'),
	('630211', '6302', 'Pamukan Selatan'),
	('630212', '6302', 'Sampanahan'),
	('630213', '6302', 'Pamukan Utara'),
	('630214', '6302', 'Hampang'),
	('630215', '6302', 'Sungaidurian'),
	('630216', '6302', 'Pulaulaut Tengah'),
	('630217', '6302', 'Kelumpang Hilir'),
	('630218', '6302', 'Kelumpang Barat'),
	('630219', '6302', 'Pamukan Barat'),
	('630220', '6302', 'Pulaulaut Kepulauan'),
	('630221', '6302', 'Pulaulaut Tanjung Selayar'),
	('630301', '6303', 'Aluh Aluh'),
	('630302', '6303', 'Kertak Hanyar'),
	('630303', '6303', 'Gambut'),
	('630304', '6303', 'Sungai Tabuk'),
	('630305', '6303', 'Martapura'),
	('630306', '6303', 'Karang Intan'),
	('630307', '6303', 'Astambul'),
	('630308', '6303', 'Simpang Empat'),
	('630309', '6303', 'Pengarom'),
	('630310', '6303', 'Sungai Pinang'),
	('630311', '6303', 'Aranio'),
	('630312', '6303', 'Mataraman'),
	('630313', '6303', 'Beruntung Baru'),
	('630314', '6303', 'Martapura Barat'),
	('630315', '6303', 'Martapura Timur'),
	('630316', '6303', 'Sambung Makmur'),
	('630317', '6303', 'Paramasan'),
	('630318', '6303', 'Telaga Bauntung'),
	('630319', '6303', 'Tatah Makmur'),
	('630401', '6304', 'Tabunganen'),
	('630402', '6304', 'Tamban'),
	('630403', '6304', 'Anjir Pasar'),
	('630404', '6304', 'Anjir Muara'),
	('630405', '6304', 'Alalak'),
	('630406', '6304', 'Mandastana'),
	('630407', '6304', 'Rantau Badauh'),
	('630408', '6304', 'Belawang'),
	('630409', '6304', 'Cerbon'),
	('630410', '6304', 'Bakumpai'),
	('630411', '6304', 'Kuripan'),
	('630412', '6304', 'Tabukan'),
	('630413', '6304', 'Mekarsari'),
	('630414', '6304', 'Barambai'),
	('630415', '6304', 'Marabahan'),
	('630416', '6304', 'Wanaraya'),
	('630417', '6304', 'Jejangkit'),
	('630501', '6305', 'Binuang'),
	('630502', '6305', 'Tapin Selatan'),
	('630503', '6305', 'Tapin Tengah'),
	('630504', '6305', 'Tapin Utara'),
	('630505', '6305', 'Candi Laras Selatan'),
	('630506', '6305', 'Candi Laras Utara'),
	('630507', '6305', 'Bakarangan'),
	('630508', '6305', 'Piani'),
	('630509', '6305', 'Bungur'),
	('630510', '6305', 'Lokpaikat'),
	('630511', '6305', 'Salam Babaris'),
	('630512', '6305', 'Hatungun'),
	('630601', '6306', 'Sungai Raya'),
	('630602', '6306', 'Padang Batung'),
	('630603', '6306', 'Telaga Langsat'),
	('630604', '6306', 'Angkinang'),
	('630605', '6306', 'Kandangan'),
	('630606', '6306', 'Simpur'),
	('630607', '6306', 'Daha Selatan'),
	('630608', '6306', 'Daha Utara'),
	('630609', '6306', 'Kalumpang'),
	('630610', '6306', 'Loksado'),
	('630611', '6306', 'Daha Barat'),
	('630701', '6307', 'Haruyan'),
	('630702', '6307', 'Batu Benawa'),
	('630703', '6307', 'Labuan Amas Selatan'),
	('630704', '6307', 'Labuan Amas Utara'),
	('630705', '6307', 'Pandawan'),
	('630706', '6307', 'Barabai'),
	('630707', '6307', 'Batang Alai Selatan'),
	('630708', '6307', 'Batang Alai Utara'),
	('630709', '6307', 'Hantakan'),
	('630710', '6307', 'Batang Alai Timur'),
	('630711', '6307', 'Limpasu'),
	('630801', '6308', 'Danau Panggang'),
	('630802', '6308', 'Babirik'),
	('630803', '6308', 'Sungai Pandan'),
	('630804', '6308', 'Amuntai Selatan'),
	('630805', '6308', 'Amuntai Tengah'),
	('630806', '6308', 'Amuntai Utara'),
	('630807', '6308', 'Banjang'),
	('630808', '6308', 'Haur Gading'),
	('630809', '6308', 'Paminggir'),
	('630810', '6308', 'Sungai Tabukan'),
	('630901', '6309', 'Banua Lawas'),
	('630902', '6309', 'Kelua'),
	('630903', '6309', 'Tanta'),
	('630904', '6309', 'Tanjung'),
	('630905', '6309', 'Haruai'),
	('630906', '6309', 'Murung Pudak'),
	('630907', '6309', 'Muara Uya'),
	('630908', '6309', 'Muara Harus'),
	('630909', '6309', 'Pugaan'),
	('630910', '6309', 'Upau'),
	('630911', '6309', 'Jaro'),
	('630912', '6309', 'Bintang Ara'),
	('631001', '6310', 'Batu Licin'),
	('631002', '6310', 'Kusan Hilir'),
	('631003', '6310', 'Sungai Loban'),
	('631004', '6310', 'Satui'),
	('631005', '6310', 'Kusan Hulu'),
	('631006', '6310', 'Simpang Empat'),
	('631007', '6310', 'Karang Bintang'),
	('631008', '6310', 'Mantewe'),
	('631009', '6310', 'Angsana'),
	('631010', '6310', 'Kuranji'),
	('631101', '6311', 'Juai'),
	('631102', '6311', 'Halong'),
	('631103', '6311', 'Awayan'),
	('631104', '6311', 'Batu Mandi'),
	('631105', '6311', 'Lampihong'),
	('631106', '6311', 'Paringin'),
	('631107', '6311', 'Paringin Selatan'),
	('631108', '6311', 'Tebing Tinggi'),
	('637101', '6371', 'Banjarmasin Selatan'),
	('637102', '6371', 'Banjarmasin Timur'),
	('637103', '6371', 'Banjarmasin Barat'),
	('637104', '6371', 'Banjarmasin Utara'),
	('637105', '6371', 'Banjarmasin Tengah'),
	('637202', '6372', 'Landasan Ulin'),
	('637203', '6372', 'Cempaka'),
	('637204', '6372', 'Banjarbaru Utara'),
	('637205', '6372', 'Banjarbaru Selatan'),
	('637206', '6372', 'Liang Anggang'),
	('640101', '6401', 'Batu Sopang'),
	('640102', '6401', 'Tanjung Harapan'),
	('640103', '6401', 'Pasir Balengkong'),
	('640104', '6401', 'Tanah Grogot'),
	('640105', '6401', 'Kuaro'),
	('640106', '6401', 'Long Ikis'),
	('640107', '6401', 'Muara Komam'),
	('640108', '6401', 'Long Kali'),
	('640109', '6401', 'Batu Engau'),
	('640110', '6401', 'Muara Samu'),
	('640201', '6402', 'Muara Muntai'),
	('640202', '6402', 'Loa Kulu'),
	('640203', '6402', 'Loa Janan'),
	('640204', '6402', 'Anggana'),
	('640205', '6402', 'Muara Badak'),
	('640206', '6402', 'Tenggarong'),
	('640207', '6402', 'Sebulu'),
	('640208', '6402', 'Kota Bangun'),
	('640209', '6402', 'Kenohan'),
	('640210', '6402', 'Kembang Janggut'),
	('640211', '6402', 'Muara Kaman'),
	('640212', '6402', 'Tabang'),
	('640213', '6402', 'Samboja'),
	('640214', '6402', 'Muara Jawa'),
	('640215', '6402', 'Sanga Sanga'),
	('640216', '6402', 'Tenggarong Seberang'),
	('640217', '6402', 'Marang Kayu'),
	('640218', '6402', 'Muara Wis'),
	('640301', '6403', 'Kelay'),
	('640302', '6403', 'Talisayan'),
	('640303', '6403', 'Sambaliung'),
	('640304', '6403', 'Segah'),
	('640305', '6403', 'Tanjung Redeb'),
	('640306', '6403', 'Gunung Tabur'),
	('640307', '6403', 'Pulau Derawan'),
	('640308', '6403', 'Biduk-Biduk'),
	('640309', '6403', 'Teluk Bayur'),
	('640310', '6403', 'Tabalar'),
	('640311', '6403', 'Maratua'),
	('640312', '6403', 'Batu Putih'),
	('640313', '6403', 'Biatan'),
	('640705', '6407', 'Long Iram'),
	('640706', '6407', 'Melak'),
	('640707', '6407', 'Barong Tongkok'),
	('640708', '6407', 'Damai'),
	('640709', '6407', 'Muara Lawa'),
	('640710', '6407', 'Muara Pahu'),
	('640711', '6407', 'Jempang'),
	('640712', '6407', 'Bongan'),
	('640713', '6407', 'Penyinggahan'),
	('640714', '6407', 'Bentian Besar'),
	('640715', '6407', 'Linggang Bigung'),
	('640716', '6407', 'Nyuatan'),
	('640717', '6407', 'Siluq Ngurai'),
	('640718', '6407', 'Mook Manaar Bulatn'),
	('640719', '6407', 'Tering'),
	('640720', '6407', 'Sekolaq Darat'),
	('640801', '6408', 'Muara Ancalong'),
	('640802', '6408', 'Muara Wahau'),
	('640803', '6408', 'Muara Bengkal'),
	('640804', '6408', 'Sangatta Utara'),
	('640805', '6408', 'Sangkulirang'),
	('640806', '6408', 'Busang'),
	('640807', '6408', 'Telen'),
	('640808', '6408', 'Kombeng'),
	('640809', '6408', 'Bengalon'),
	('640810', '6408', 'Kaliorang'),
	('640811', '6408', 'Sandaran'),
	('640812', '6408', 'Sangatta Selatan'),
	('640813', '6408', 'Teluk Pandan'),
	('640814', '6408', 'Rantau Pulung'),
	('640815', '6408', 'Kaubun'),
	('640816', '6408', 'Karangan'),
	('640817', '6408', 'Batu Ampar'),
	('640818', '6408', 'Long Mesangat'),
	('640901', '6409', 'Penajam'),
	('640902', '6409', 'Waru'),
	('640903', '6409', 'Babulu'),
	('640904', '6409', 'Sepaku'),
	('641101', '6411', 'Long Bagun'),
	('641102', '6411', 'Long Hubung'),
	('641103', '6411', 'Laham'),
	('641104', '6411', 'Long Apari'),
	('641105', '6411', 'Long Pahangai'),
	('647101', '6471', 'Balikpapan Timur'),
	('647102', '6471', 'Balikpapan Barat'),
	('647103', '6471', 'Balikpapan Utara'),
	('647104', '6471', 'Balikpapan Tengah'),
	('647105', '6471', 'Balikpapan Selatan'),
	('647106', '6471', 'Balikpapan Kota'),
	('647201', '6472', 'Palaran'),
	('647202', '6472', 'Samarinda Seberang'),
	('647203', '6472', 'Samarinda Ulu'),
	('647204', '6472', 'Samarinda Ilir'),
	('647205', '6472', 'Samarinda Utara'),
	('647206', '6472', 'Sungai Kunjang'),
	('647207', '6472', 'Sambutan'),
	('647208', '6472', 'Sungai Pinang'),
	('647209', '6472', 'Samarinda Kota'),
	('647210', '6472', 'Loa Janan Ilir'),
	('647401', '6474', 'Bontang Utara'),
	('647402', '6474', 'Bontang Selatan'),
	('647403', '6474', 'Bontang Barat'),
	('650101', '6501', 'Tanjung Palas'),
	('650102', '6501', 'Tanjung Palas Barat'),
	('650103', '6501', 'Tanjung Palas Utara'),
	('650104', '6501', 'Tanjung Palas Timur'),
	('650105', '6501', 'Tanjung Selor'),
	('650106', '6501', 'Tanjung Palas Tengah'),
	('650107', '6501', 'Peso'),
	('650108', '6501', 'Peso Hilir'),
	('650109', '6501', 'Sekatak'),
	('650110', '6501', 'Bunyu'),
	('650201', '6502', 'Mentarang'),
	('650202', '6502', 'Malinau Kota'),
	('650203', '6502', 'Pujungan'),
	('650204', '6502', 'Kayan Hilir'),
	('650205', '6502', 'Kayan Hulu'),
	('650206', '6502', 'Malinau Selatan'),
	('650207', '6502', 'Malinau Utara'),
	('650208', '6502', 'Malinau Barat'),
	('650209', '6502', 'Sungai Boh'),
	('650210', '6502', 'Kayan Selatan'),
	('650211', '6502', 'Bahau Hulu'),
	('650212', '6502', 'Mentarang Hulu'),
	('650213', '6502', 'Malinau Selatan Hilir'),
	('650214', '6502', 'Malinau Selatan Hulu'),
	('650215', '6502', 'Sungai Tubu'),
	('650301', '6503', 'Sebatik'),
	('650302', '6503', 'Nunukan'),
	('650303', '6503', 'Sembakung'),
	('650304', '6503', 'Lumbis'),
	('650305', '6503', 'Krayan'),
	('650306', '6503', 'Sebuku'),
	('650307', '6503', 'Krayan Selatan'),
	('650308', '6503', 'Sebatik Barat'),
	('650309', '6503', 'Nunukan Selatan'),
	('650310', '6503', 'Sebatik Timur'),
	('650311', '6503', 'Sebatik Utara'),
	('650312', '6503', 'Sebatik Tengah'),
	('650313', '6503', 'Sei Menggaris'),
	('650314', '6503', 'Tulin Onsoi'),
	('650315', '6503', 'Lumbis Ogong'),
	('650316', '6503', 'Sembakung Atulai'),
	('650401', '6504', 'Sesayap'),
	('650402', '6504', 'Sesayap Hilir'),
	('650403', '6504', 'Tana Lia'),
	('650404', '6504', 'Betayau'),
	('650405', '6504', 'Muruk Rian'),
	('657101', '6571', 'Tarakan Barat'),
	('657102', '6571', 'Tarakan Tengah'),
	('657103', '6571', 'Tarakan Timur'),
	('657104', '6571', 'Tarakan Utara'),
	('710105', '7101', 'Sang Tombolang'),
	('710109', '7101', 'Dumoga Barat'),
	('710110', '7101', 'Dumoga Timur'),
	('710111', '7101', 'Dumoga Utara'),
	('710112', '7101', 'Lolak'),
	('710113', '7101', 'Bolaang'),
	('710114', '7101', 'Lolayan'),
	('710119', '7101', 'Passi Barat'),
	('710120', '7101', 'Poigar'),
	('710122', '7101', 'Passi Timur'),
	('710131', '7101', 'Bolaang Timur'),
	('710132', '7101', 'Bilalang'),
	('710133', '7101', 'Dumoga'),
	('710134', '7101', 'Dumoga Tenggara'),
	('710135', '7101', 'Dumoga Tengah'),
	('710201', '7102', 'Tondano Barat'),
	('710202', '7102', 'Tondano Timur'),
	('710203', '7102', 'Eris'),
	('710204', '7102', 'Kombi'),
	('710205', '7102', 'Lembean Timur'),
	('710206', '7102', 'Kakas'),
	('710207', '7102', 'Tompaso'),
	('710208', '7102', 'Remboken'),
	('710209', '7102', 'Langowan Timur'),
	('710210', '7102', 'Langowan Barat'),
	('710211', '7102', 'Sonder'),
	('710212', '7102', 'Kawangkoan'),
	('710213', '7102', 'Pineleng'),
	('710214', '7102', 'Tombulu'),
	('710215', '7102', 'Tombariri'),
	('710216', '7102', 'Tondano Utara'),
	('710217', '7102', 'Langowan Selatan'),
	('710218', '7102', 'Tondano Selatan'),
	('710219', '7102', 'Langowan Utara'),
	('710220', '7102', 'Kakas Barat'),
	('710221', '7102', 'Kawangkoan Utara'),
	('710222', '7102', 'Kawangkoan Barat'),
	('710223', '7102', 'Mandolang'),
	('710224', '7102', 'Tombariri Timur'),
	('710225', '7102', 'Tompaso Barat'),
	('710308', '7103', 'Tabukan Utara'),
	('710309', '7103', 'Nusa Tabukan'),
	('710310', '7103', 'Manganitu Selatan'),
	('710311', '7103', 'Tatoareng'),
	('710312', '7103', 'Tamako'),
	('710313', '7103', 'Manganitu'),
	('710314', '7103', 'Tabukan Tengah'),
	('710315', '7103', 'Tabukan Selatan'),
	('710316', '7103', 'Kendahe'),
	('710317', '7103', 'Tahuna'),
	('710319', '7103', 'Tabukan Selatan Tengah'),
	('710320', '7103', 'Tabukan Selatan Tenggara'),
	('710323', '7103', 'Tahuna Barat'),
	('710324', '7103', 'Tahuna Timur'),
	('710325', '7103', 'Kepulauan Marore'),
	('710401', '7104', 'Lirung'),
	('710402', '7104', 'Beo'),
	('710403', '7104', 'Rainis'),
	('710404', '7104', 'Essang'),
	('710405', '7104', 'Nanusa'),
	('710406', '7104', 'Kabaruan'),
	('710407', '7104', 'Melonguane'),
	('710408', '7104', 'Gemeh'),
	('710409', '7104', 'Damau'),
	('710410', '7104', 'Tampan\' Amma'),
	('710411', '7104', 'Salibabu'),
	('710412', '7104', 'Kalongan'),
	('710413', '7104', 'Miangas'),
	('710414', '7104', 'Beo Utara'),
	('710415', '7104', 'Pulutan'),
	('710416', '7104', 'Melonguane Timur'),
	('710417', '7104', 'Moronge'),
	('710418', '7104', 'Beo Selatan'),
	('710419', '7104', 'Essang Selatan'),
	('710501', '7105', 'Modoinding'),
	('710502', '7105', 'Tompaso Baru'),
	('710503', '7105', 'Ranoyapo'),
	('710507', '7105', 'Motoling'),
	('710508', '7105', 'Sinonsayang'),
	('710509', '7105', 'Tenga'),
	('710510', '7105', 'Amurang'),
	('710512', '7105', 'Tumpaan'),
	('710513', '7105', 'Tareran'),
	('710515', '7105', 'Kumelembuai'),
	('710516', '7105', 'Maesaan'),
	('710517', '7105', 'Amurang Barat'),
	('710518', '7105', 'Amurang Timur'),
	('710519', '7105', 'Tatapaan'),
	('710521', '7105', 'Motoling Barat'),
	('710522', '7105', 'Motoling Timur'),
	('710523', '7105', 'Suluun Tareran'),
	('710601', '7106', 'Kema'),
	('710602', '7106', 'Kauditan'),
	('710603', '7106', 'Airmadidi'),
	('710604', '7106', 'Wori'),
	('710605', '7106', 'Dimembe'),
	('710606', '7106', 'Likupang Barat'),
	('710607', '7106', 'Likupang Timur'),
	('710608', '7106', 'Kalawat'),
	('710609', '7106', 'Talawaan'),
	('710610', '7106', 'Likupang Selatan'),
	('710701', '7107', 'Ratahan'),
	('710702', '7107', 'Pusomaen'),
	('710703', '7107', 'Belang'),
	('710704', '7107', 'Ratatotok'),
	('710705', '7107', 'Tombatu'),
	('710706', '7107', 'Touluaan'),
	('710707', '7107', 'Touluaan Selatan'),
	('710708', '7107', 'Silian Raya'),
	('710709', '7107', 'Tombatu Timur'),
	('710710', '7107', 'Tombatu Utara'),
	('710711', '7107', 'Pasan'),
	('710712', '7107', 'Ratahan Timur'),
	('710801', '7108', 'Sangkub'),
	('710802', '7108', 'Bintauna'),
	('710803', '7108', 'Bolangitang Timur'),
	('710804', '7108', 'Bolangitang Barat'),
	('710805', '7108', 'Kaidipang'),
	('710806', '7108', 'Pinogaluman'),
	('710901', '7109', 'Siau Timur'),
	('710902', '7109', 'Siau Barat'),
	('710903', '7109', 'Tagulandang'),
	('710904', '7109', 'Siau Timur Selatan'),
	('710905', '7109', 'Siau Barat Selatan'),
	('710906', '7109', 'Tagulandang Utara'),
	('710907', '7109', 'Biaro'),
	('710908', '7109', 'Siau Barat Utara'),
	('710909', '7109', 'Siau Tengah'),
	('710910', '7109', 'Tagulandang Selatan'),
	('711001', '7110', 'Tutuyan'),
	('711002', '7110', 'Kotabunan'),
	('711003', '7110', 'Nuangan'),
	('711004', '7110', 'Modayag'),
	('711005', '7110', 'Modayag Barat'),
	('711101', '7111', 'Bolaang Uki'),
	('711102', '7111', 'Posigadan'),
	('711103', '7111', 'Pinolosian'),
	('711104', '7111', 'Pinolosian Tengah'),
	('711105', '7111', 'Pinolosian Timur'),
	('717101', '7171', 'Bunaken'),
	('717102', '7171', 'Tuminiting'),
	('717103', '7171', 'Singkil'),
	('717104', '7171', 'Wenang'),
	('717105', '7171', 'Tikala'),
	('717106', '7171', 'Sario'),
	('717107', '7171', 'Wanea'),
	('717108', '7171', 'Mapanget'),
	('717109', '7171', 'Malalayang'),
	('717110', '7171', 'Bunaken Kepulauan'),
	('717111', '7171', 'Paal Dua'),
	('717201', '7172', 'Lembeh Selatan'),
	('717202', '7172', 'Madidir'),
	('717203', '7172', 'Ranowulu'),
	('717204', '7172', 'Aertembaga'),
	('717205', '7172', 'Matuari'),
	('717206', '7172', 'Girian'),
	('717207', '7172', 'Maesa'),
	('717208', '7172', 'Lembeh Utara'),
	('717301', '7173', 'Tomohon Selatan'),
	('717302', '7173', 'Tomohon Tengah'),
	('717303', '7173', 'Tomohon Utara'),
	('717304', '7173', 'Tomohon Barat'),
	('717305', '7173', 'Tomohon Timur'),
	('717401', '7174', 'Kotamobagu Utara'),
	('717402', '7174', 'Kotamobagu Timur'),
	('717403', '7174', 'Kotamobagu Selatan'),
	('717404', '7174', 'Kotamobagu Barat'),
	('720101', '7201', 'Batui'),
	('720102', '7201', 'Bunta'),
	('720103', '7201', 'Kintom'),
	('720104', '7201', 'Luwuk'),
	('720105', '7201', 'Lamala'),
	('720106', '7201', 'Balantak'),
	('720107', '7201', 'Pagimana'),
	('720108', '7201', 'Bualemo'),
	('720109', '7201', 'Toili'),
	('720110', '7201', 'Masama'),
	('720111', '7201', 'Luwuk Timur'),
	('720112', '7201', 'Toili Barat'),
	('720113', '7201', 'Nuhon'),
	('720114', '7201', 'Moilong'),
	('720115', '7201', 'Batui Selatan'),
	('720116', '7201', 'Lobu'),
	('720117', '7201', 'Simpang Raya'),
	('720118', '7201', 'Balantak Selatan'),
	('720119', '7201', 'Balantak Utara'),
	('720120', '7201', 'Luwuk Selatan'),
	('720121', '7201', 'Luwuk Utara'),
	('720122', '7201', 'Mantoh'),
	('720123', '7201', 'Nambo'),
	('720201', '7202', 'Poso Kota'),
	('720202', '7202', 'Poso Pesisir'),
	('720203', '7202', 'Lage'),
	('720204', '7202', 'Pamona Puselemba'),
	('720205', '7202', 'Pamona Timur'),
	('720206', '7202', 'Pamona Selatan'),
	('720207', '7202', 'Lore Utara'),
	('720208', '7202', 'Lore Tengah'),
	('720209', '7202', 'Lore Selatan'),
	('720218', '7202', 'Poso Pesisir Utara'),
	('720219', '7202', 'Poso Pesisir Selatan'),
	('720220', '7202', 'Pamona Barat'),
	('720221', '7202', 'Poso Kota Selatan'),
	('720222', '7202', 'Poso Kota Utara'),
	('720223', '7202', 'Lore Barat'),
	('720224', '7202', 'Lore Timur'),
	('720225', '7202', 'Lore Piore'),
	('720226', '7202', 'Pamona Tenggara'),
	('720227', '7202', 'Pamona Utara'),
	('720304', '7203', 'Rio Pakava'),
	('720306', '7203', 'Dampelas'),
	('720308', '7203', 'Banawa'),
	('720309', '7203', 'Labuan'),
	('720310', '7203', 'Sindue'),
	('720311', '7203', 'Sirenja'),
	('720312', '7203', 'Balaesang'),
	('720314', '7203', 'Sojol'),
	('720318', '7203', 'Banawa Selatan'),
	('720319', '7203', 'Tanantovea'),
	('720321', '7203', 'Panembani'),
	('720324', '7203', 'Sindue Tombusabora'),
	('720325', '7203', 'Sindue Tobata'),
	('720327', '7203', 'Banawa Tengah'),
	('720330', '7203', 'Sojol Utara'),
	('720331', '7203', 'Balaesang Tanjung'),
	('720401', '7204', 'Dampal Selatan'),
	('720402', '7204', 'Dampal Utara'),
	('720403', '7204', 'Dondo'),
	('720404', '7204', 'Basidondo'),
	('720405', '7204', 'Ogodeide'),
	('720406', '7204', 'Lampasio'),
	('720407', '7204', 'Baolan'),
	('720408', '7204', 'Galang'),
	('720409', '7204', 'Toli-Toli Utara'),
	('720410', '7204', 'Dako Pemean'),
	('720501', '7205', 'Momunu'),
	('720502', '7205', 'Lakea'),
	('720503', '7205', 'Bokat'),
	('720504', '7205', 'Bunobogu'),
	('720505', '7205', 'Paleleh'),
	('720506', '7205', 'Biau'),
	('720507', '7205', 'Tiloan'),
	('720508', '7205', 'Bukal'),
	('720509', '7205', 'Gadung'),
	('720510', '7205', 'Karamat'),
	('720511', '7205', 'Paleleh Barat'),
	('720605', '7206', 'Bungku Tengah'),
	('720606', '7206', 'Bungku Selatan'),
	('720607', '7206', 'Menui Kepulauan'),
	('720608', '7206', 'Bungku Barat'),
	('720609', '7206', 'Bumi Raya'),
	('720610', '7206', 'Bahodopi'),
	('720612', '7206', 'Wita Ponda'),
	('720615', '7206', 'Bungku Pesisir'),
	('720618', '7206', 'Bungku Timur'),
	('720703', '7207', 'Totikum'),
	('720704', '7207', 'Tinangkung'),
	('720705', '7207', 'Liang'),
	('720706', '7207', 'Bulagi'),
	('720707', '7207', 'Buko'),
	('720709', '7207', 'Bulagi Selatan'),
	('720711', '7207', 'Tinangkung Selatan'),
	('720715', '7207', 'Totikum Selatan'),
	('720716', '7207', 'Peling Tengah'),
	('720717', '7207', 'Bulagi Utara'),
	('720718', '7207', 'Buko Selatan'),
	('720719', '7207', 'Tinangkung Utara'),
	('720801', '7208', 'Parigi'),
	('720802', '7208', 'Ampibabo'),
	('720803', '7208', 'Tinombo'),
	('720804', '7208', 'Moutong'),
	('720805', '7208', 'Tomini'),
	('720806', '7208', 'Sausu'),
	('720807', '7208', 'Bolano Lambunu'),
	('720808', '7208', 'Kasimbar'),
	('720809', '7208', 'Torue'),
	('720810', '7208', 'Tinombo Selatan'),
	('720811', '7208', 'Parigi Selatan'),
	('720812', '7208', 'Mepanga'),
	('720813', '7208', 'Toribulu'),
	('720814', '7208', 'Taopa'),
	('720815', '7208', 'Balinggi'),
	('720816', '7208', 'Parigi Barat'),
	('720817', '7208', 'Siniu'),
	('720818', '7208', 'Palasa'),
	('720819', '7208', 'Parigi Utara'),
	('720820', '7208', 'Parigi Tengah'),
	('720821', '7208', 'Bolano'),
	('720822', '7208', 'Ongka Malino'),
	('720823', '7208', 'Sidoan'),
	('720901', '7209', 'Una Una'),
	('720902', '7209', 'Togean'),
	('720903', '7209', 'Walea Kepulauan'),
	('720904', '7209', 'Ampana Tete'),
	('720905', '7209', 'Ampana Kota'),
	('720906', '7209', 'Ulubongka'),
	('720907', '7209', 'Tojo Barat'),
	('720908', '7209', 'Tojo'),
	('720909', '7209', 'Walea Besar'),
	('720910', '7209', 'Ratolindo'),
	('720911', '7209', 'Batudaka'),
	('720912', '7209', 'Talatako'),
	('721001', '7210', 'Sigi Biromaru'),
	('721002', '7210', 'Palolo'),
	('721003', '7210', 'Nokilalaki'),
	('721004', '7210', 'Lindu'),
	('721005', '7210', 'Kulawi'),
	('721006', '7210', 'Kulawi Selatan'),
	('721007', '7210', 'Pipikoro'),
	('721008', '7210', 'Gumbasa'),
	('721009', '7210', 'Dolo Selatan'),
	('721010', '7210', 'Tanambulava'),
	('721011', '7210', 'Dolo Barat'),
	('721012', '7210', 'Dolo'),
	('721013', '7210', 'Kinovaro'),
	('721014', '7210', 'Marawola'),
	('721015', '7210', 'Marawola Barat'),
	('721101', '7211', 'Banggai'),
	('721102', '7211', 'Banggai Utara'),
	('721103', '7211', 'Bokan Kepulauan'),
	('721104', '7211', 'Bangkurung'),
	('721105', '7211', 'Labobo'),
	('721106', '7211', 'Banggai Selatan'),
	('721107', '7211', 'Banggai Tengah'),
	('721201', '7212', 'Petasia'),
	('721202', '7212', 'Petasia Timur'),
	('721203', '7212', 'Lembo Raya'),
	('721204', '7212', 'Lembo'),
	('721205', '7212', 'Mori Atas'),
	('721206', '7212', 'Mori Utara'),
	('721207', '7212', 'Soyo Jaya'),
	('721208', '7212', 'Bungku Utara'),
	('721209', '7212', 'Mamosalato'),
	('727101', '7271', 'Palu Timur'),
	('727102', '7271', 'Palu Barat'),
	('727103', '7271', 'Palu Selatan'),
	('727104', '7271', 'Palu Utara'),
	('727105', '7271', 'Ulujadi'),
	('727106', '7271', 'Tatanga'),
	('727107', '7271', 'Tawaeli'),
	('727108', '7271', 'Mantikulore'),
	('730101', '7301', 'Benteng'),
	('730102', '7301', 'Bontoharu'),
	('730103', '7301', 'Bontomatene'),
	('730104', '7301', 'Bontomanai'),
	('730105', '7301', 'Bontosikuyu'),
	('730106', '7301', 'Pasimasunggu'),
	('730107', '7301', 'Pasimarannu'),
	('730108', '7301', 'Taka Bonerate'),
	('730109', '7301', 'Pasilambena'),
	('730110', '7301', 'Pasimasunggu Timur'),
	('730111', '7301', 'Buki'),
	('730201', '7302', 'Gantorang'),
	('730202', '7302', 'Ujung Bulu'),
	('730203', '7302', 'Bonto Bahari'),
	('730204', '7302', 'Bonto Tiro'),
	('730205', '7302', 'Herlang'),
	('730206', '7302', 'Kajang'),
	('730207', '7302', 'Bulukumpa'),
	('730208', '7302', 'Kindang'),
	('730209', '7302', 'Ujungloe'),
	('730210', '7302', 'Rilauale'),
	('730301', '7303', 'Bissappu'),
	('730302', '7303', 'Bantaeng'),
	('730303', '7303', 'Eremerasa'),
	('730304', '7303', 'Tompo Bulu'),
	('730305', '7303', 'Pajukukang'),
	('730306', '7303', 'Uluere'),
	('730307', '7303', 'Gantarang Keke'),
	('730308', '7303', 'Sinoa'),
	('730401', '7304', 'Bangkala'),
	('730402', '7304', 'Tamalatea'),
	('730403', '7304', 'Binamu'),
	('730404', '7304', 'Batang'),
	('730405', '7304', 'Kelara'),
	('730406', '7304', 'Bangkala Barat'),
	('730407', '7304', 'Bontoramba'),
	('730408', '7304', 'Turatea'),
	('730409', '7304', 'Arungkeke'),
	('730410', '7304', 'Rumbia'),
	('730411', '7304', 'Tarowang'),
	('730501', '7305', 'Mappakasunggu'),
	('730502', '7305', 'Mangarabombang'),
	('730503', '7305', 'Polombangkeng Selatan'),
	('730504', '7305', 'Polombangkeng Utara'),
	('730505', '7305', 'Galesong Selatan'),
	('730506', '7305', 'Galesong Utara'),
	('730507', '7305', 'Pattallassang'),
	('730508', '7305', 'Sanrobone'),
	('730509', '7305', 'Galesong'),
	('730601', '7306', 'Bontonompo'),
	('730602', '7306', 'Bajeng'),
	('730603', '7306', 'Tompobullu'),
	('730604', '7306', 'Tinggimoncong'),
	('730605', '7306', 'Parangloe'),
	('730606', '7306', 'Bontomarannu'),
	('730607', '7306', 'Palangga'),
	('730608', '7306', 'Somba Upu'),
	('730609', '7306', 'Bungaya'),
	('730610', '7306', 'Tombolopao'),
	('730611', '7306', 'Biringbulu'),
	('730612', '7306', 'Barombong'),
	('730613', '7306', 'Pattalasang'),
	('730614', '7306', 'Manuju'),
	('730615', '7306', 'Bontolempangang'),
	('730616', '7306', 'Bontonompo Selatan'),
	('730617', '7306', 'Parigi'),
	('730618', '7306', 'Bajeng Barat'),
	('730701', '7307', 'Sinjai Barat'),
	('730702', '7307', 'Sinjai Selatan'),
	('730703', '7307', 'Sinjai Timur'),
	('730704', '7307', 'Sinjai Tengah'),
	('730705', '7307', 'Sinjai Utara'),
	('730706', '7307', 'Bulupoddo'),
	('730707', '7307', 'Sinjai Borong'),
	('730708', '7307', 'Tellu Limpoe'),
	('730709', '7307', 'Pulau Sembilan'),
	('730801', '7308', 'Bontocani'),
	('730802', '7308', 'Kahu'),
	('730803', '7308', 'Kajuara'),
	('730804', '7308', 'Salomekko'),
	('730805', '7308', 'Tonra'),
	('730806', '7308', 'Libureng'),
	('730807', '7308', 'Mare'),
	('730808', '7308', 'Sibulue'),
	('730809', '7308', 'Barebbo'),
	('730810', '7308', 'Cina'),
	('730811', '7308', 'Ponre'),
	('730812', '7308', 'Lappariaja'),
	('730813', '7308', 'Lamuru'),
	('730814', '7308', 'Ulaweng'),
	('730815', '7308', 'Palakka'),
	('730816', '7308', 'Awangpone'),
	('730817', '7308', 'Tellu Siattinge'),
	('730818', '7308', 'Ajangale'),
	('730819', '7308', 'Dua Boccoe'),
	('730820', '7308', 'Cenrana'),
	('730821', '7308', 'Tanete Riattang'),
	('730822', '7308', 'Tanete Riattang Barat'),
	('730823', '7308', 'Tanete Riattang Timur'),
	('730824', '7308', 'Amali'),
	('730825', '7308', 'Tellulimpoe'),
	('730826', '7308', 'Bengo'),
	('730827', '7308', 'Patimpeng'),
	('730901', '7309', 'Mandai'),
	('730902', '7309', 'Camba'),
	('730903', '7309', 'Bantimurung'),
	('730904', '7309', 'Maros Baru'),
	('730905', '7309', 'Bontoa'),
	('730906', '7309', 'Malllawa'),
	('730907', '7309', 'Tanralili'),
	('730908', '7309', 'Marusu'),
	('730909', '7309', 'Simbang'),
	('730910', '7309', 'Cenrana'),
	('730911', '7309', 'Tompobulu'),
	('730912', '7309', 'Lau'),
	('730913', '7309', 'Moncong Loe'),
	('730914', '7309', 'Turikale'),
	('731001', '7310', 'Liukang Tangaya'),
	('731002', '7310', 'Liukang Kalmas'),
	('731003', '7310', 'Liukang Tupabbiring'),
	('731004', '7310', 'Pangkajene'),
	('731005', '7310', 'Balocci'),
	('731006', '7310', 'Bungoro'),
	('731007', '7310', 'Labakkang'),
	('731008', '7310', 'Marang'),
	('731009', '7310', 'Segeri'),
	('731010', '7310', 'Minasa Tene'),
	('731011', '7310', 'Mandalle'),
	('731012', '7310', 'Tondong Tallasa'),
	('731013', '7310', 'Liukang Tupabbiring Utara'),
	('731101', '7311', 'Tanete Riaja'),
	('731102', '7311', 'Tanete Rilau'),
	('731103', '7311', 'Barru'),
	('731104', '7311', 'Soppeng Riaja'),
	('731105', '7311', 'Mallusetasi'),
	('731106', '7311', 'Pujananting'),
	('731107', '7311', 'Balusu'),
	('731201', '7312', 'Marioriwawo'),
	('731202', '7312', 'Liliraja'),
	('731203', '7312', 'Lilirilau'),
	('731204', '7312', 'Lalabata'),
	('731205', '7312', 'Marioriawa'),
	('731206', '7312', 'Donri Donri'),
	('731207', '7312', 'Ganra'),
	('731208', '7312', 'Citta'),
	('731301', '7313', 'Sabangparu'),
	('731302', '7313', 'Pammana'),
	('731303', '7313', 'Takkalalla'),
	('731304', '7313', 'Sajoanging'),
	('731305', '7313', 'Majauleng'),
	('731306', '7313', 'Tempe'),
	('731307', '7313', 'Belawa'),
	('731308', '7313', 'Tanasitolo'),
	('731309', '7313', 'Maniangpajo'),
	('731310', '7313', 'Pitumpanua'),
	('731311', '7313', 'Bola'),
	('731312', '7313', 'Penrang'),
	('731313', '7313', 'Gilireng'),
	('731314', '7313', 'Keera'),
	('731401', '7314', 'Panca Lautan'),
	('731402', '7314', 'Tellu Limpoe'),
	('731403', '7314', 'Watang Pulu'),
	('731404', '7314', 'Baranti'),
	('731405', '7314', 'Panca Rijang'),
	('731406', '7314', 'Kulo'),
	('731407', '7314', 'Maritengngae'),
	('731408', '7314', 'WT. Sidenreng'),
	('731409', '7314', 'Dua Pitue'),
	('731410', '7314', 'Pitu Riawa'),
	('731411', '7314', 'Pitu Raise'),
	('731501', '7315', 'Matirro Sompe'),
	('731502', '7315', 'Suppa'),
	('731503', '7315', 'Mattiro Bulu'),
	('731504', '7315', 'Watang Sawito'),
	('731505', '7315', 'Patampanua'),
	('731506', '7315', 'Duampanua'),
	('731507', '7315', 'Lembang'),
	('731508', '7315', 'Cempa'),
	('731509', '7315', 'Tiroang'),
	('731510', '7315', 'Lansirang'),
	('731511', '7315', 'Paleteang'),
	('731512', '7315', 'Batu Lappa'),
	('731601', '7316', 'Maiwa'),
	('731602', '7316', 'Enrekang'),
	('731603', '7316', 'Baraka'),
	('731604', '7316', 'Anggeraja'),
	('731605', '7316', 'Alla'),
	('731606', '7316', 'Bungin'),
	('731607', '7316', 'Cendana'),
	('731608', '7316', 'Curio'),
	('731609', '7316', 'Malua'),
	('731610', '7316', 'Buntu Batu'),
	('731611', '7316', 'Masalle'),
	('731612', '7316', 'Baroko'),
	('731701', '7317', 'Basse Sangtempe'),
	('731702', '7317', 'Larompong'),
	('731703', '7317', 'Suli'),
	('731704', '7317', 'Bajo'),
	('731705', '7317', 'Bua Ponrang'),
	('731706', '7317', 'Walenrang'),
	('731707', '7317', 'Belopa'),
	('731708', '7317', 'Bua'),
	('731709', '7317', 'Lamasi'),
	('731710', '7317', 'Larompong Selatan'),
	('731711', '7317', 'Ponrang'),
	('731712', '7317', 'Latimojong'),
	('731713', '7317', 'Kamanre'),
	('731714', '7317', 'Belopa Utara'),
	('731715', '7317', 'Walenrang Barat'),
	('731716', '7317', 'Walenrang Utara'),
	('731717', '7317', 'Walenrang Timur'),
	('731718', '7317', 'Lamasi Timur'),
	('731719', '7317', 'Suli Barat'),
	('731720', '7317', 'Bajo Barat'),
	('731721', '7317', 'Ponrang Selatan'),
	('731722', '7317', 'Basse Sangtempe Utara'),
	('731801', '7318', 'Saluputi'),
	('731802', '7318', 'Bittuang'),
	('731803', '7318', 'Bonggakaradeng'),
	('731805', '7318', 'Makale'),
	('731809', '7318', 'Simbuang'),
	('731811', '7318', 'Rantetayo'),
	('731812', '7318', 'Mengkendek'),
	('731813', '7318', 'Sangalla'),
	('731819', '7318', 'Gandangbatu Sillanan'),
	('731820', '7318', 'Rembon'),
	('731827', '7318', 'Makale Utara'),
	('731828', '7318', 'Mappak'),
	('731829', '7318', 'Makale Selatan'),
	('731831', '7318', 'Masanda'),
	('731833', '7318', 'Sangalla Selatan'),
	('731834', '7318', 'Sangalla Utara'),
	('731835', '7318', 'Malimbong Balepe'),
	('731837', '7318', 'Rano'),
	('731838', '7318', 'Kurra'),
	('732201', '7322', 'Malangke'),
	('732202', '7322', 'Bone Bone'),
	('732203', '7322', 'Masamba'),
	('732204', '7322', 'Sabbang'),
	('732205', '7322', 'Limbong'),
	('732206', '7322', 'Sukamaju'),
	('732207', '7322', 'Seko'),
	('732208', '7322', 'Malangke Barat'),
	('732209', '7322', 'Rampi'),
	('732210', '7322', 'Mappedeceng'),
	('732211', '7322', 'Baebunta'),
	('732212', '7322', 'Tana Lili'),
	('732401', '7324', 'Mangkutana'),
	('732402', '7324', 'Nuha'),
	('732403', '7324', 'Towuti'),
	('732404', '7324', 'Malili'),
	('732405', '7324', 'Angkona'),
	('732406', '7324', 'Wotu'),
	('732407', '7324', 'Burau'),
	('732408', '7324', 'Tomoni'),
	('732409', '7324', 'Tomoni Timur'),
	('732410', '7324', 'Kalaena'),
	('732411', '7324', 'Wasuponda'),
	('732601', '7326', 'Rantepao'),
	('732602', '7326', 'Sesean'),
	('732603', '7326', 'Nanggala'),
	('732604', '7326', 'Rindingallo'),
	('732605', '7326', 'Buntao'),
	('732606', '7326', 'Sa\'dan'),
	('732607', '7326', 'Sanggalangi'),
	('732608', '7326', 'Sopai'),
	('732609', '7326', 'Tikala'),
	('732610', '7326', 'Balusu'),
	('732611', '7326', 'Tallunglipu'),
	('732612', '7326', 'Dende\' Piongan Napo'),
	('732613', '7326', 'Buntu Pepasan'),
	('732614', '7326', 'Baruppu'),
	('732615', '7326', 'Kesu'),
	('732616', '7326', 'Tondon'),
	('732617', '7326', 'Bangkelekila'),
	('732618', '7326', 'Rantebua'),
	('732619', '7326', 'Sesean Suloara'),
	('732620', '7326', 'Kapala Pitu'),
	('732621', '7326', 'Awan Rante Karua'),
	('737101', '7371', 'Mariso'),
	('737102', '7371', 'Mamajang'),
	('737103', '7371', 'Makasar'),
	('737104', '7371', 'Ujung Pandang'),
	('737105', '7371', 'Wajo'),
	('737106', '7371', 'Bontoala'),
	('737107', '7371', 'Tallo'),
	('737108', '7371', 'Ujung Tanah'),
	('737109', '7371', 'Panakukkang'),
	('737110', '7371', 'Tamalate'),
	('737111', '7371', 'Biringkanaya'),
	('737112', '7371', 'Manggala'),
	('737113', '7371', 'Rappocini'),
	('737114', '7371', 'Tamalanrea'),
	('737201', '7372', 'Bacukiki'),
	('737202', '7372', 'Ujung'),
	('737203', '7372', 'Soreang'),
	('737204', '7372', 'Bacukiki Barat'),
	('737301', '7373', 'Wara'),
	('737302', '7373', 'Wara Utara'),
	('737303', '7373', 'Wara Selatan'),
	('737304', '7373', 'Telluwanua'),
	('737305', '7373', 'Wara Timur'),
	('737306', '7373', 'Wara Barat'),
	('737307', '7373', 'Sendana'),
	('737308', '7373', 'Mungkajang'),
	('737309', '7373', 'Bara'),
	('740101', '7401', 'Wundulako'),
	('740104', '7401', 'Kolaka'),
	('740107', '7401', 'Pomalaa'),
	('740108', '7401', 'Watubangga'),
	('740110', '7401', 'Wolo'),
	('740112', '7401', 'Baula'),
	('740114', '7401', 'Latambaga'),
	('740118', '7401', 'Tanggetada'),
	('740120', '7401', 'Samaturu'),
	('740124', '7401', 'Toari'),
	('740125', '7401', 'Polinggona'),
	('740127', '7401', 'Iwoimendaa'),
	('740201', '7402', 'Lambuya'),
	('740202', '7402', 'Unaaha'),
	('740203', '7402', 'Wawotobi'),
	('740204', '7402', 'Pondidaha'),
	('740205', '7402', 'Sampara'),
	('740210', '7402', 'Abuki'),
	('740211', '7402', 'Soropia'),
	('740215', '7402', 'Tongauna'),
	('740216', '7402', 'Latoma'),
	('740217', '7402', 'Puriala'),
	('740218', '7402', 'Uepai'),
	('740219', '7402', 'Wonggeduku'),
	('740220', '7402', 'Besulutu'),
	('740221', '7402', 'Bondoala'),
	('740223', '7402', 'Routa'),
	('740224', '7402', 'Anggaberi'),
	('740225', '7402', 'Meluhu'),
	('740228', '7402', 'Amonggedo'),
	('740231', '7402', 'Asinua'),
	('740232', '7402', 'Konawe'),
	('740233', '7402', 'Kapoiala'),
	('740236', '7402', 'Lalonggasumeeto'),
	('740237', '7402', 'Onembute'),
	('740306', '7403', 'Napabalano'),
	('740307', '7403', 'Maligano'),
	('740313', '7403', 'Wakorumba Selatan'),
	('740314', '7403', 'Lasalepa'),
	('740315', '7403', 'Batalaiwaru'),
	('740316', '7403', 'Katobu'),
	('740317', '7403', 'Duruka'),
	('740318', '7403', 'Lohia'),
	('740319', '7403', 'Watopute'),
	('740320', '7403', 'Kontunaga'),
	('740323', '7403', 'Kabangka'),
	('740324', '7403', 'Kabawo'),
	('740325', '7403', 'Parigi'),
	('740326', '7403', 'Bone'),
	('740327', '7403', 'Tongkuno'),
	('740328', '7403', 'Pasir Putih'),
	('740330', '7403', 'Kontu Kowuna'),
	('740331', '7403', 'Marobo'),
	('740332', '7403', 'Tongkuno Selatan'),
	('740333', '7403', 'Pasi Kolaga'),
	('740334', '7403', 'Batukara'),
	('740337', '7403', 'Towea'),
	('740411', '7404', 'Pasarwajo'),
	('740422', '7404', 'Kapontori'),
	('740423', '7404', 'Lasalimu'),
	('740424', '7404', 'Lasalimu Selatan'),
	('740427', '7404', 'Siotapina'),
	('740428', '7404', 'Wolowa'),
	('740429', '7404', 'Wabula'),
	('740501', '7405', 'Tinanggea'),
	('740502', '7405', 'Angata'),
	('740503', '7405', 'Andoolo'),
	('740504', '7405', 'Palangga'),
	('740505', '7405', 'Landono'),
	('740506', '7405', 'Lainea'),
	('740507', '7405', 'Konda'),
	('740508', '7405', 'Ranomeeto'),
	('740509', '7405', 'Kolono'),
	('740510', '7405', 'Moramo'),
	('740511', '7405', 'Laonti'),
	('740512', '7405', 'Lalembuu'),
	('740513', '7405', 'Benua'),
	('740514', '7405', 'Palangga Selatan'),
	('740515', '7405', 'Mowila'),
	('740516', '7405', 'Moramo Utara'),
	('740517', '7405', 'Buke'),
	('740518', '7405', 'Wolasi'),
	('740519', '7405', 'Laeya'),
	('740520', '7405', 'Baito'),
	('740521', '7405', 'Basala'),
	('740522', '7405', 'Ranomeeto Barat'),
	('740601', '7406', 'Poleang'),
	('740602', '7406', 'Poleang Timur'),
	('740603', '7406', 'Rarowatu'),
	('740604', '7406', 'Rumbia'),
	('740605', '7406', 'Kabaena'),
	('740606', '7406', 'Kabaena Timur'),
	('740607', '7406', 'Poleang Barat'),
	('740608', '7406', 'Mata Oleo'),
	('740609', '7406', 'Rarowatu Utara'),
	('740610', '7406', 'Poleang Utara'),
	('740611', '7406', 'Poleang Selatan'),
	('740612', '7406', 'Poleang Tenggara'),
	('740613', '7406', 'Kabaena Selatan'),
	('740614', '7406', 'Kabaena Barat'),
	('740615', '7406', 'Kabaena Utara'),
	('740616', '7406', 'Kabaena Tengah'),
	('740617', '7406', 'Kep. Masaloka Raya'),
	('740618', '7406', 'Rumbia Tengah'),
	('740619', '7406', 'Poleang Tengah'),
	('740620', '7406', 'Tontonunu'),
	('740621', '7406', 'Lantari Jaya'),
	('740622', '7406', 'Mata Usu'),
	('740701', '7407', 'Wangi-Wangi'),
	('740702', '7407', 'Kaledupa'),
	('740703', '7407', 'Tomia'),
	('740704', '7407', 'Binongko'),
	('740705', '7407', 'Wangi Wangi Selatan'),
	('740706', '7407', 'Kaledupa Selatan'),
	('740707', '7407', 'Tomia Timur'),
	('740708', '7407', 'Togo Binongko'),
	('740801', '7408', 'Lasusua'),
	('740802', '7408', 'Pakue'),
	('740803', '7408', 'Batu Putih'),
	('740804', '7408', 'Rante Angin'),
	('740805', '7408', 'Kodeoha'),
	('740806', '7408', 'Ngapa'),
	('740807', '7408', 'Wawo'),
	('740808', '7408', 'Lambai'),
	('740809', '7408', 'Watunohu'),
	('740810', '7408', 'Pakue Tengah'),
	('740811', '7408', 'Pakue Utara'),
	('740812', '7408', 'Porehu'),
	('740813', '7408', 'Tolala'),
	('740814', '7408', 'Tiwu'),
	('740815', '7408', 'Katoi'),
	('740901', '7409', 'Asera'),
	('740902', '7409', 'Wiwirano'),
	('740903', '7409', 'Langgikima'),
	('740904', '7409', 'Molawe'),
	('740905', '7409', 'Lasolo'),
	('740906', '7409', 'Lembo'),
	('740907', '7409', 'Sawa'),
	('740908', '7409', 'Oheo'),
	('740909', '7409', 'Andowia'),
	('740910', '7409', 'Motui'),
	('741001', '7410', 'Kulisusu'),
	('741002', '7410', 'Kambowa'),
	('741003', '7410', 'Bonegunu'),
	('741004', '7410', 'Kulisusu Barat'),
	('741005', '7410', 'Kulisusu Utara'),
	('741006', '7410', 'Wakorumba Utara'),
	('741101', '7411', 'Tirawuta'),
	('741102', '7411', 'Loea'),
	('741103', '7411', 'Ladongi'),
	('741104', '7411', 'Poli Polia'),
	('741105', '7411', 'Lambandia'),
	('741106', '7411', 'Lalolae'),
	('741107', '7411', 'Mowewe'),
	('741108', '7411', 'Uluiwoi'),
	('741109', '7411', 'Tinondo'),
	('741110', '7411', 'Aere'),
	('741111', '7411', 'Ueesi'),
	('741112', '7411', 'Dangia'),
	('741201', '7412', 'Wawonii Barat'),
	('741202', '7412', 'Wawonii Utara'),
	('741203', '7412', 'Wawonii Timur Laut'),
	('741204', '7412', 'Wawonii Timur'),
	('741205', '7412', 'Wawonii Tenggara'),
	('741206', '7412', 'Wawonii Selatan'),
	('741207', '7412', 'Wawonii Tengah'),
	('741301', '7413', 'Sawerigadi'),
	('741302', '7413', 'Barangka'),
	('741303', '7413', 'Lawa'),
	('741304', '7413', 'Wadaga'),
	('741305', '7413', 'Tiworo Selatan'),
	('741306', '7413', 'Maginti'),
	('741307', '7413', 'Tiworo Tengah'),
	('741308', '7413', 'Tiworo Utara'),
	('741309', '7413', 'Tiworo Kepulauan'),
	('741310', '7413', 'Kusambi'),
	('741311', '7413', 'Napano Kusambi'),
	('741401', '7414', 'Lakudo'),
	('741402', '7414', 'Mawasangka Timur'),
	('741403', '7414', 'Mawasangka Tengah'),
	('741404', '7414', 'Mawasangka'),
	('741405', '7414', 'Talaga Raya'),
	('741406', '7414', 'Gu'),
	('741407', '7414', 'Sangia Wambulu'),
	('741501', '7415', 'Batauga'),
	('741502', '7415', 'Sampolawa'),
	('741503', '7415', 'Lapandewa'),
	('741504', '7415', 'Batu Atas'),
	('741505', '7415', 'Siompu Barat'),
	('741506', '7415', 'Siompu'),
	('741507', '7415', 'Kadatua'),
	('747101', '7471', 'Mandonga'),
	('747102', '7471', 'Kendari'),
	('747103', '7471', 'Baruga'),
	('747104', '7471', 'Poasia'),
	('747105', '7471', 'Kendari Barat'),
	('747106', '7471', 'Abeli'),
	('747107', '7471', 'Wua-Wua'),
	('747108', '7471', 'Kadia'),
	('747109', '7471', 'Puuwatu'),
	('747110', '7471', 'Kambu'),
	('747201', '7472', 'Betoambari'),
	('747202', '7472', 'Wolio'),
	('747203', '7472', 'Sora Walio'),
	('747204', '7472', 'Bungi'),
	('747205', '7472', 'Kokalukuna'),
	('747206', '7472', 'Murhum'),
	('747207', '7472', 'Lea-Lea'),
	('747208', '7472', 'Batupoaro'),
	('750101', '7501', 'Limboto'),
	('750102', '7501', 'Telaga'),
	('750103', '7501', 'Batudaa'),
	('750104', '7501', 'Tibawa'),
	('750105', '7501', 'Batudaa Pantai'),
	('750109', '7501', 'Boliyohuto'),
	('750110', '7501', 'Telaga Biru'),
	('750111', '7501', 'Bongomeme'),
	('750113', '7501', 'Tolangohula'),
	('750114', '7501', 'Mootilango'),
	('750116', '7501', 'Pulubala'),
	('750117', '7501', 'Limboto Barat'),
	('750118', '7501', 'Tilango'),
	('750119', '7501', 'Tabongo'),
	('750120', '7501', 'Biluhu'),
	('750121', '7501', 'Asparaga'),
	('750122', '7501', 'Talaga Jaya'),
	('750123', '7501', 'Bilato'),
	('750124', '7501', 'Dungaliyo'),
	('750201', '7502', 'Paguyaman'),
	('750202', '7502', 'Wonosari'),
	('750203', '7502', 'Dulupi'),
	('750204', '7502', 'Tilamuta'),
	('750205', '7502', 'Mananggu'),
	('750206', '7502', 'Botumoita'),
	('750207', '7502', 'Paguyaman Pantai'),
	('750301', '7503', 'Tapa'),
	('750302', '7503', 'Kabila'),
	('750303', '7503', 'Suwawa'),
	('750304', '7503', 'Bonepantai'),
	('750305', '7503', 'Bulango Utara'),
	('750306', '7503', 'Tilongkabila'),
	('750307', '7503', 'Botupingge'),
	('750308', '7503', 'Kabila Bone'),
	('750309', '7503', 'Bone'),
	('750310', '7503', 'Bone Raya'),
	('750311', '7503', 'Suwawa Timur'),
	('750312', '7503', 'Suwawa Selatan'),
	('750313', '7503', 'Suwawa Tengah'),
	('750314', '7503', 'Bulango Ulu'),
	('750315', '7503', 'Bulango Selatan'),
	('750316', '7503', 'Bulango Timur'),
	('750317', '7503', 'Bulawa'),
	('750318', '7503', 'Pinogu'),
	('750401', '7504', 'Popayato'),
	('750402', '7504', 'Lemito'),
	('750403', '7504', 'Randangan'),
	('750404', '7504', 'Marisa'),
	('750405', '7504', 'Paguat'),
	('750406', '7504', 'Patilanggio'),
	('750407', '7504', 'Taluditi'),
	('750408', '7504', 'Dengilo'),
	('750409', '7504', 'Buntulia'),
	('750410', '7504', 'Duhiadaa'),
	('750411', '7504', 'Wanggarasi'),
	('750412', '7504', 'Popayato Timur'),
	('750413', '7504', 'Popayato Barat'),
	('750501', '7505', 'Atinggola'),
	('750502', '7505', 'Kwandang'),
	('750503', '7505', 'Anggrek'),
	('750504', '7505', 'Sumalata'),
	('750505', '7505', 'Tolinggula'),
	('750506', '7505', 'Gentuma Raya'),
	('750507', '7505', 'Tomolito'),
	('750508', '7505', 'Ponelo Kepulauan'),
	('750509', '7505', 'Monano'),
	('750510', '7505', 'Biau'),
	('750511', '7505', 'Sumalata Timur'),
	('757101', '7571', 'Kota Barat'),
	('757102', '7571', 'Kota Selatan'),
	('757103', '7571', 'Kota Utara'),
	('757104', '7571', 'Dungingi'),
	('757105', '7571', 'Kota Timur'),
	('757106', '7571', 'Kota Tengah'),
	('757107', '7571', 'Sipatana'),
	('757108', '7571', 'Dumbo Raya'),
	('757109', '7571', 'Hulonthalangi'),
	('760101', '7601', 'Bambalamotu'),
	('760102', '7601', 'Pasangkayu'),
	('760103', '7601', 'Baras'),
	('760104', '7601', 'Sarudu'),
	('760105', '7601', 'Dapurang'),
	('760106', '7601', 'Duripoku'),
	('760107', '7601', 'Bulu Taba'),
	('760108', '7601', 'Tikke Raya'),
	('760109', '7601', 'Pedongga'),
	('760110', '7601', 'Bambaira'),
	('760111', '7601', 'Sarjo'),
	('760112', '7601', 'Lariang'),
	('760201', '7602', 'Mamuju'),
	('760202', '7602', 'Tapalang'),
	('760203', '7602', 'Kalukku'),
	('760204', '7602', 'Kalumpang'),
	('760207', '7602', 'Papalang'),
	('760208', '7602', 'Sampaga'),
	('760211', '7602', 'Tommo'),
	('760212', '7602', 'Simboro dan Kepulauan'),
	('760213', '7602', 'Tapalang Barat'),
	('760215', '7602', 'Bonehau'),
	('760216', '7602', 'Kep. Bala Balakang'),
	('760301', '7603', 'Mambi'),
	('760302', '7603', 'Aralle'),
	('760303', '7603', 'Mamasa'),
	('760304', '7603', 'Pana'),
	('760305', '7603', 'Tabulahan'),
	('760306', '7603', 'Sumarorong'),
	('760307', '7603', 'Messawa'),
	('760308', '7603', 'Sesenapadang'),
	('760309', '7603', 'Tanduk Kalua'),
	('760310', '7603', 'Tabang'),
	('760311', '7603', 'Bambang'),
	('760312', '7603', 'Balla'),
	('760313', '7603', 'Nosu'),
	('760314', '7603', 'Tawalian'),
	('760315', '7603', 'Rantebulahan Timur'),
	('760316', '7603', 'Buntumalangka'),
	('760317', '7603', 'Mehalaan'),
	('760401', '7604', 'Tinambung'),
	('760402', '7604', 'Campalagian'),
	('760403', '7604', 'Wonomulyo'),
	('760404', '7604', 'Polewali'),
	('760405', '7604', 'Tutar'),
	('760406', '7604', 'Binuang'),
	('760407', '7604', 'Tapango'),
	('760408', '7604', 'Mapilli'),
	('760409', '7604', 'Matangnga'),
	('760410', '7604', 'Luyo'),
	('760411', '7604', 'Limboro'),
	('760412', '7604', 'Balanipa'),
	('760413', '7604', 'Anreapi'),
	('760414', '7604', 'Matakali'),
	('760415', '7604', 'Allu'),
	('760416', '7604', 'Bulo'),
	('760501', '7605', 'Banggae'),
	('760502', '7605', 'Pamboang'),
	('760503', '7605', 'Sendana'),
	('760504', '7605', 'Malunda'),
	('760505', '7605', 'Ulumanda'),
	('760506', '7605', 'Tammerodo Sendana'),
	('760507', '7605', 'Tubo Sendana'),
	('760508', '7605', 'Banggae Timur'),
	('760601', '7606', 'Tobadak'),
	('760602', '7606', 'Pangale'),
	('760603', '7606', 'Budong-Budong'),
	('760604', '7606', 'Topoyo'),
	('760605', '7606', 'Karossa'),
	('810101', '8101', 'Amahai'),
	('810102', '8101', 'Teon Nila Serua'),
	('810106', '8101', 'Seram Utara'),
	('810109', '8101', 'Banda'),
	('810111', '8101', 'Tehoru'),
	('810112', '8101', 'Saparua'),
	('810113', '8101', 'Pulau Haruku'),
	('810114', '8101', 'Salahutu'),
	('810115', '8101', 'Leihitu'),
	('810116', '8101', 'Nusa Laut'),
	('810117', '8101', 'Kota Masohi'),
	('810120', '8101', 'Seram Utara Barat'),
	('810121', '8101', 'Teluk Elpaputih'),
	('810122', '8101', 'Leihitu Barat'),
	('810123', '8101', 'Telutih'),
	('810124', '8101', 'Seram Utara Timur Seti'),
	('810125', '8101', 'Seram Utara Timur Kobi'),
	('810126', '8101', 'Saparua Timur'),
	('810201', '8102', 'Kei Kecil'),
	('810203', '8102', 'Kei Besar'),
	('810204', '8102', 'Kei Besar Selatan'),
	('810205', '8102', 'Kei Besar Utara Timur'),
	('810213', '8102', 'Kei Kecil Timur'),
	('810214', '8102', 'Kei Kecil Barat'),
	('810215', '8102', 'Manyeuw'),
	('810216', '8102', 'Hoat Sorbay'),
	('810217', '8102', 'Kei Besar Utara Barat'),
	('810218', '8102', 'Kei Besar Selatan Barat'),
	('810219', '8102', 'Kei Kecil Timur Selatan'),
	('810301', '8103', 'Tanimbar Selatan'),
	('810302', '8103', 'Selaru'),
	('810303', '8103', 'Wer Tamrian'),
	('810304', '8103', 'Wer Maktian'),
	('810305', '8103', 'Tanimbar Utara'),
	('810306', '8103', 'Yaru'),
	('810307', '8103', 'Wuar Labobar'),
	('810308', '8103', 'Kormomolin'),
	('810309', '8103', 'Nirunmas'),
	('810318', '8103', 'Molu Maru'),
	('810401', '8104', 'Namlea'),
	('810402', '8104', 'Air Buaya'),
	('810403', '8104', 'Waeapo'),
	('810406', '8104', 'Waplau'),
	('810410', '8104', 'Batabual'),
	('810411', '8104', 'Lolong Guba'),
	('810412', '8104', 'Waelata'),
	('810413', '8104', 'Fena Leisela'),
	('810414', '8104', 'Teluk Kaiely'),
	('810415', '8104', 'Lilialy'),
	('810501', '8105', 'Bula'),
	('810502', '8105', 'Seram Timur'),
	('810503', '8105', 'Werinama'),
	('810504', '8105', 'Pulau Gorom'),
	('810505', '8105', 'Wakate'),
	('810506', '8105', 'Tutuk Tolu'),
	('810507', '8105', 'Siwalalat'),
	('810508', '8105', 'Kilmury'),
	('810509', '8105', 'Pulau Panjang'),
	('810510', '8105', 'Teor'),
	('810511', '8105', 'Gorom Timur'),
	('810512', '8105', 'Bula Barat'),
	('810513', '8105', 'Kian Darat'),
	('810514', '8105', 'Siritaun Wida Timur'),
	('810515', '8105', 'Teluk Waru'),
	('810601', '8106', 'Kairatu'),
	('810602', '8106', 'Seram Barat'),
	('810603', '8106', 'Taniwel'),
	('810604', '8106', 'Huamual Belakang'),
	('810605', '8106', 'Amalatu'),
	('810606', '8106', 'Inamosol'),
	('810607', '8106', 'Kairatu Barat'),
	('810608', '8106', 'Huamual'),
	('810609', '8106', 'Kepulauan Manipa'),
	('810610', '8106', 'Taniwel Timur'),
	('810611', '8106', 'Elpaputih'),
	('810701', '8107', 'Pulau-Pulau Aru'),
	('810702', '8107', 'Aru Selatan'),
	('810703', '8107', 'Aru Tengah'),
	('810704', '8107', 'Aru Utara'),
	('810705', '8107', 'Aru Utara Timur Batuley'),
	('810706', '8107', 'Sir-Sir'),
	('810707', '8107', 'Aru Tengah Timur'),
	('810708', '8107', 'Aru Tengah Selatan'),
	('810709', '8107', 'Aru Selatan Timur'),
	('810710', '8107', 'Aru Selatan Utara'),
	('810801', '8108', 'Moa Lakor'),
	('810802', '8108', 'Damer'),
	('810803', '8108', 'Mndona Hiera'),
	('810804', '8108', 'Pulau-Pulau Babar'),
	('810805', '8108', 'Pulau-pulau Babar Timur'),
	('810806', '8108', 'Wetar'),
	('810807', '8108', 'Pulau-pulau Terselatan'),
	('810808', '8108', 'Pulau Leti'),
	('810809', '8108', 'Pulau Masela'),
	('810810', '8108', 'Dawelor Dawera'),
	('810811', '8108', 'Pulau Wetang'),
	('810812', '8108', 'Pulau Lakor'),
	('810813', '8108', 'Wetar Utara'),
	('810814', '8108', 'Wetar Barat'),
	('810815', '8108', 'Wetar Timur'),
	('810816', '8108', 'Kepulauan Romang'),
	('810817', '8108', 'Kisar Utara'),
	('810901', '8109', 'Namrole'),
	('810902', '8109', 'Waesama'),
	('810903', '8109', 'Ambalau'),
	('810904', '8109', 'Kepala Madan'),
	('810905', '8109', 'Leksula'),
	('810906', '8109', 'Fena Fafan'),
	('817101', '8171', 'Nusaniwe'),
	('817102', '8171', 'Sirimau'),
	('817103', '8171', 'Baguala'),
	('817104', '8171', 'Teluk Ambon'),
	('817105', '8171', 'Leitimur Selatan'),
	('817201', '8172', 'Pulau Dullah Utara'),
	('817202', '8172', 'Pulau Dullah Selatan'),
	('817203', '8172', 'Tayando Tam'),
	('817204', '8172', 'Pulau-Pulau Kur'),
	('817205', '8172', 'Kur Selatan'),
	('820101', '8201', 'Jailolo'),
	('820102', '8201', 'Loloda'),
	('820103', '8201', 'Ibu'),
	('820104', '8201', 'Sahu'),
	('820105', '8201', 'Jailolo Selatan'),
	('820107', '8201', 'Ibu Utara'),
	('820108', '8201', 'Ibu Selatan'),
	('820109', '8201', 'Sahu Timur'),
	('820201', '8202', 'Weda'),
	('820202', '8202', 'Patani'),
	('820203', '8202', 'Pulau Gebe'),
	('820204', '8202', 'Weda Utara'),
	('820205', '8202', 'Weda Selatan'),
	('820206', '8202', 'Patani Utara'),
	('820207', '8202', 'Weda Tengah'),
	('820208', '8202', 'Patani Barat'),
	('820304', '8203', 'Galela'),
	('820305', '8203', 'Tobelo'),
	('820306', '8203', 'Tobelo Selatan'),
	('820307', '8203', 'Kao'),
	('820308', '8203', 'Malifut'),
	('820309', '8203', 'Loloda Utara'),
	('820310', '8203', 'Tobelo Utara'),
	('820311', '8203', 'Tobelo Tengah'),
	('820312', '8203', 'Tobelo Timur'),
	('820313', '8203', 'Tobelo Barat'),
	('820314', '8203', 'Galela Barat'),
	('820315', '8203', 'Galela Utara'),
	('820316', '8203', 'Galela Selatan'),
	('820319', '8203', 'Loloda Kepulauan'),
	('820320', '8203', 'Kao Utara'),
	('820321', '8203', 'Kao Barat'),
	('820322', '8203', 'Kao Teluk'),
	('820401', '8204', 'Pulau Makian'),
	('820402', '8204', 'Kayoa'),
	('820403', '8204', 'Gane Timur'),
	('820404', '8204', 'Gane Barat'),
	('820405', '8204', 'Obi Selatan'),
	('820406', '8204', 'Obi'),
	('820407', '8204', 'Bacan Timur'),
	('820408', '8204', 'Bacan'),
	('820409', '8204', 'Bacan Barat'),
	('820410', '8204', 'Makian Barat'),
	('820411', '8204', 'Kayoa Barat'),
	('820412', '8204', 'Kayoa Selatan'),
	('820413', '8204', 'Kayoa Utara'),
	('820414', '8204', 'Bacan Barat Utara'),
	('820415', '8204', 'Kasiruta Barat'),
	('820416', '8204', 'Kasiruta Timur'),
	('820417', '8204', 'Bacan Selatan'),
	('820418', '8204', 'Kepulauan Botanglomang'),
	('820419', '8204', 'Mandioli Selatan'),
	('820420', '8204', 'Mandioli Utara'),
	('820421', '8204', 'Bacan Timur Selatan'),
	('820422', '8204', 'Bacan Timur Tengah'),
	('820423', '8204', 'Gane Barat Selatan'),
	('820424', '8204', 'Gane Barat Utara'),
	('820425', '8204', 'Kepulauan Joronga'),
	('820426', '8204', 'Gane Timur Selatan'),
	('820427', '8204', 'Gane Timur Tengah'),
	('820428', '8204', 'Obi Barat'),
	('820429', '8204', 'Obi Timur'),
	('820430', '8204', 'Obi Utara'),
	('820501', '8205', 'Mangoli Timur'),
	('820502', '8205', 'Sanana'),
	('820503', '8205', 'Sulabesi Barat'),
	('820506', '8205', 'Mangoli Barat'),
	('820507', '8205', 'Sulabesi Tengah'),
	('820508', '8205', 'Sulabesi Timur'),
	('820509', '8205', 'Sulabesi Selatan'),
	('820510', '8205', 'Mangoli Utara Timur'),
	('820511', '8205', 'Mangoli Tengah'),
	('820512', '8205', 'Mangoli Selatan'),
	('820513', '8205', 'Mangoli Utara'),
	('820518', '8205', 'Sanana Utara'),
	('820601', '8206', 'Wasile'),
	('820602', '8206', 'Maba'),
	('820603', '8206', 'Maba Selatan'),
	('820604', '8206', 'Wasile Selatan'),
	('820605', '8206', 'Wasile Tengah'),
	('820606', '8206', 'Wasile Utara'),
	('820607', '8206', 'Wasile Timur'),
	('820608', '8206', 'Maba Tengah'),
	('820609', '8206', 'Maba Utara'),
	('820610', '8206', 'Kota Maba'),
	('820701', '8207', 'Morotai Selatan'),
	('820702', '8207', 'Morotai Selatan Barat'),
	('820703', '8207', 'Morotai Jaya'),
	('820704', '8207', 'Morotai Utara'),
	('820705', '8207', 'Morotai Timur'),
	('820801', '8208', 'Taliabu Barat'),
	('820802', '8208', 'Taliabu Barat Laut'),
	('820803', '8208', 'Lede'),
	('820804', '8208', 'Taliabu Utara'),
	('820805', '8208', 'Taliabu Timur'),
	('820806', '8208', 'Taliabu Timur Selatan'),
	('820807', '8208', 'Taliabu Selatan'),
	('820808', '8208', 'Tabona'),
	('827101', '8271', 'Pulau Ternate'),
	('827102', '8271', 'Kota Ternate Selatan'),
	('827103', '8271', 'Kota Ternate Utara'),
	('827104', '8271', 'Pulau Moti'),
	('827105', '8271', 'Pulau Batang Dua'),
	('827106', '8271', 'Kota Ternate Tengah'),
	('827107', '8271', 'Pulau Hiri'),
	('827201', '8272', 'Tidore'),
	('827202', '8272', 'Oba Utara'),
	('827203', '8272', 'Oba'),
	('827204', '8272', 'Tidore Selatan'),
	('827205', '8272', 'Tidore Utara'),
	('827206', '8272', 'Oba Tengah'),
	('827207', '8272', 'Oba Selatan'),
	('827208', '8272', 'Tidore Timur'),
	('910101', '9101', 'Merauke'),
	('910102', '9101', 'Muting'),
	('910103', '9101', 'Okaba'),
	('910104', '9101', 'Kimaam'),
	('910105', '9101', 'Semangga'),
	('910106', '9101', 'Tanah Miring'),
	('910107', '9101', 'Jagebob'),
	('910108', '9101', 'Sota'),
	('910109', '9101', 'Ulilin'),
	('910110', '9101', 'Elikobal'),
	('910111', '9101', 'Kurik'),
	('910112', '9101', 'Naukenjerai'),
	('910113', '9101', 'Animha'),
	('910114', '9101', 'Malind'),
	('910115', '9101', 'Tubang'),
	('910116', '9101', 'Ngguti'),
	('910117', '9101', 'Kaptel'),
	('910118', '9101', 'Tabonji'),
	('910119', '9101', 'Waan'),
	('910120', '9101', 'Ilwayab'),
	('910201', '9102', 'Wamena'),
	('910203', '9102', 'Kurulu'),
	('910204', '9102', 'Asologaima'),
	('910212', '9102', 'Hubikosi'),
	('910215', '9102', 'Bolakme'),
	('910225', '9102', 'Walelagama'),
	('910227', '9102', 'Musatfak'),
	('910228', '9102', 'Wolo'),
	('910229', '9102', 'Asolokobal'),
	('910234', '9102', 'Pelebaga'),
	('910235', '9102', 'Yalengga'),
	('910240', '9102', 'Trikora'),
	('910241', '9102', 'Napua'),
	('910242', '9102', 'Walaik'),
	('910243', '9102', 'Wouma'),
	('910244', '9102', 'Hubikiak'),
	('910245', '9102', 'Ibele'),
	('910246', '9102', 'Taelarek'),
	('910247', '9102', 'Itlay Hisage'),
	('910248', '9102', 'Siepkosi'),
	('910249', '9102', 'Usilimo'),
	('910250', '9102', 'Wita Waya'),
	('910251', '9102', 'Libarek'),
	('910252', '9102', 'Wadangku'),
	('910253', '9102', 'Pisugi'),
	('910254', '9102', 'Koragi'),
	('910255', '9102', 'Tagime'),
	('910256', '9102', 'Molagalome'),
	('910257', '9102', 'Tagineri'),
	('910258', '9102', 'Silo Karno Doga'),
	('910259', '9102', 'Piramid'),
	('910260', '9102', 'Muliama'),
	('910261', '9102', 'Bugi'),
	('910262', '9102', 'Bpiri'),
	('910263', '9102', 'Welesi'),
	('910264', '9102', 'Asotipo'),
	('910265', '9102', 'Maima'),
	('910266', '9102', 'Popugoba'),
	('910267', '9102', 'Wame'),
	('910268', '9102', 'Wesaput'),
	('910301', '9103', 'Sentani'),
	('910302', '9103', 'Sentani Timur'),
	('910303', '9103', 'Depapre'),
	('910304', '9103', 'Sentani Barat'),
	('910305', '9103', 'Kemtuk'),
	('910306', '9103', 'Kemtuk Gresi'),
	('910307', '9103', 'Nimboran'),
	('910308', '9103', 'Nimbokrang'),
	('910309', '9103', 'Unurum Guay'),
	('910310', '9103', 'Demta'),
	('910311', '9103', 'Kaureh'),
	('910312', '9103', 'Ebungfa'),
	('910313', '9103', 'Waibu'),
	('910314', '9103', 'Nambluong'),
	('910315', '9103', 'Yapsi'),
	('910316', '9103', 'Airu'),
	('910317', '9103', 'Raveni Rara'),
	('910318', '9103', 'Gresi Selatan'),
	('910319', '9103', 'Yokari'),
	('910401', '9104', 'Nabire'),
	('910402', '9104', 'Napan'),
	('910403', '9104', 'Yaur'),
	('910406', '9104', 'Uwapa'),
	('910407', '9104', 'Wanggar'),
	('910410', '9104', 'Siriwo'),
	('910411', '9104', 'Makimi'),
	('910412', '9104', 'Teluk Umar'),
	('910416', '9104', 'Teluk Kimi'),
	('910417', '9104', 'Yaro'),
	('910421', '9104', 'Wapoga'),
	('910422', '9104', 'Nabire Barat'),
	('910423', '9104', 'Moora'),
	('910424', '9104', 'Dipa'),
	('910425', '9104', 'Menou'),
	('910501', '9105', 'Yapen Selatan'),
	('910502', '9105', 'Yapen Barat'),
	('910503', '9105', 'Yapen Timur'),
	('910504', '9105', 'Angkaisera'),
	('910505', '9105', 'Poom'),
	('910506', '9105', 'Kosiwo'),
	('910507', '9105', 'Yapen Utara'),
	('910508', '9105', 'Raimbawi'),
	('910509', '9105', 'Teluk Ampimoi'),
	('910510', '9105', 'Kepulauan Ambai'),
	('910511', '9105', 'Wonawa'),
	('910512', '9105', 'Windesi'),
	('910513', '9105', 'Pulau Kurudu'),
	('910514', '9105', 'Pulau Yerui'),
	('910601', '9106', 'Biak Kota'),
	('910602', '9106', 'Biak Utara'),
	('910603', '9106', 'Biak Timur'),
	('910604', '9106', 'Numfor Barat'),
	('910605', '9106', 'Numfor Timur'),
	('910608', '9106', 'Biak Barat'),
	('910609', '9106', 'Warsa'),
	('910610', '9106', 'Padaido'),
	('910611', '9106', 'Yendidori'),
	('910612', '9106', 'Samofa'),
	('910613', '9106', 'Yawosi'),
	('910614', '9106', 'Andey'),
	('910615', '9106', 'Swandiwe'),
	('910616', '9106', 'Bruyadori'),
	('910617', '9106', 'Orkeri'),
	('910618', '9106', 'Poiru'),
	('910619', '9106', 'Aimando Padaido'),
	('910620', '9106', 'Oridek'),
	('910621', '9106', 'Bondifuar'),
	('910701', '9107', 'Mulia'),
	('910703', '9107', 'Ilu'),
	('910706', '9107', 'Fawi'),
	('910707', '9107', 'Mewoluk'),
	('910708', '9107', 'Yamo'),
	('910710', '9107', 'Nume'),
	('910711', '9107', 'Torere'),
	('910712', '9107', 'Tingginambut'),
	('910717', '9107', 'Pagaleme'),
	('910718', '9107', 'Gurage'),
	('910719', '9107', 'Irimuli'),
	('910720', '9107', 'Muara'),
	('910721', '9107', 'Ilamburawi'),
	('910722', '9107', 'Yambi'),
	('910723', '9107', 'Lumo'),
	('910724', '9107', 'Molanikime'),
	('910725', '9107', 'Dokome'),
	('910726', '9107', 'Kalome'),
	('910727', '9107', 'Wanwi'),
	('910728', '9107', 'Yamoneri'),
	('910729', '9107', 'Waegi'),
	('910730', '9107', 'Nioga'),
	('910731', '9107', 'Gubume'),
	('910732', '9107', 'Taganombak'),
	('910733', '9107', 'Dagai'),
	('910734', '9107', 'Kiyage'),
	('910801', '9108', 'Paniai Timur'),
	('910802', '9108', 'Paniai Barat'),
	('910804', '9108', 'Aradide'),
	('910807', '9108', 'Bogabaida'),
	('910809', '9108', 'Bibida'),
	('910812', '9108', 'Dumadama'),
	('910813', '9108', 'Siriwo'),
	('910819', '9108', 'Kebo'),
	('910820', '9108', 'Yatamo'),
	('910821', '9108', 'Ekadide'),
	('910901', '9109', 'Mimika Baru'),
	('910902', '9109', 'Agimuga'),
	('910903', '9109', 'Mimika Timur'),
	('910904', '9109', 'Mimika Barat'),
	('910905', '9109', 'Jita'),
	('910906', '9109', 'Jila'),
	('910907', '9109', 'Mimika Timur Jauh'),
	('910908', '9109', 'Mimika Tengah'),
	('910909', '9109', 'Kuala Kencana'),
	('910910', '9109', 'Tembagapura'),
	('910911', '9109', 'Mimika Barat Jauh'),
	('910912', '9109', 'Mimika Barat Tengah'),
	('910913', '9109', 'Kwamki Narama'),
	('910914', '9109', 'Hoya'),
	('910915', '9109', 'Iwaka'),
	('910916', '9109', 'Wania'),
	('910917', '9109', 'Amar'),
	('910918', '9109', 'Alama'),
	('911001', '9110', 'Sarmi'),
	('911002', '9110', 'Tor Atas'),
	('911003', '9110', 'Pantai Barat'),
	('911004', '9110', 'Pantai Timur'),
	('911005', '9110', 'Bonggo'),
	('911009', '9110', 'Apawer Hulu'),
	('911012', '9110', 'Sarmi Selatan'),
	('911013', '9110', 'Sarmi Timur'),
	('911014', '9110', 'Pantai Timur Bagian Barat'),
	('911015', '9110', 'Bonggo Timur'),
	('911101', '9111', 'Waris'),
	('911102', '9111', 'Arso'),
	('911103', '9111', 'Senggi'),
	('911104', '9111', 'Web'),
	('911105', '9111', 'Skanto'),
	('911106', '9111', 'Arso Timur'),
	('911107', '9111', 'Towe'),
	('911201', '9112', 'Oksibil'),
	('911202', '9112', 'Kiwirok'),
	('911203', '9112', 'Okbibab'),
	('911204', '9112', 'Iwur'),
	('911205', '9112', 'Batom'),
	('911206', '9112', 'Borme'),
	('911207', '9112', 'Kiwirok Timur'),
	('911208', '9112', 'Aboy'),
	('911209', '9112', 'Pepera'),
	('911210', '9112', 'Bime'),
	('911211', '9112', 'Alemsom'),
	('911212', '9112', 'Okbape'),
	('911213', '9112', 'Kalomdol'),
	('911214', '9112', 'Oksop'),
	('911215', '9112', 'Serambakon'),
	('911216', '9112', 'Ok Aom'),
	('911217', '9112', 'Kawor'),
	('911218', '9112', 'Awinbon'),
	('911219', '9112', 'Tarup'),
	('911220', '9112', 'Okhika'),
	('911221', '9112', 'Oksamol'),
	('911222', '9112', 'Oklip'),
	('911223', '9112', 'Okbemtau'),
	('911224', '9112', 'Oksebang'),
	('911225', '9112', 'Okbab'),
	('911226', '9112', 'Batani'),
	('911227', '9112', 'Weime'),
	('911228', '9112', 'Murkim'),
	('911229', '9112', 'Mofinop'),
	('911230', '9112', 'Jetfa'),
	('911231', '9112', 'Teiraplu'),
	('911232', '9112', 'Eipumek'),
	('911233', '9112', 'Pamek'),
	('911234', '9112', 'Nongme'),
	('911301', '9113', 'Kurima'),
	('911302', '9113', 'Anggruk'),
	('911303', '9113', 'Ninia'),
	('911306', '9113', 'Silimo'),
	('911307', '9113', 'Samenage'),
	('911308', '9113', 'Nalca'),
	('911309', '9113', 'Dekai'),
	('911310', '9113', 'Obio'),
	('911311', '9113', 'Suru Suru'),
	('911312', '9113', 'Wusama'),
	('911313', '9113', 'Amuma'),
	('911314', '9113', 'Musaik'),
	('911315', '9113', 'Pasema'),
	('911316', '9113', 'Hogio'),
	('911317', '9113', 'Mugi'),
	('911318', '9113', 'Soba'),
	('911319', '9113', 'Werima'),
	('911320', '9113', 'Tangma'),
	('911321', '9113', 'Ukha'),
	('911322', '9113', 'Panggema'),
	('911323', '9113', 'Kosarek'),
	('911324', '9113', 'Nipsan'),
	('911325', '9113', 'Ubahak'),
	('911326', '9113', 'Pronggoli'),
	('911327', '9113', 'Walma'),
	('911328', '9113', 'Yahuliambut'),
	('911329', '9113', 'Hereapini'),
	('911330', '9113', 'Ubalihi'),
	('911331', '9113', 'Talambo'),
	('911332', '9113', 'Puldama'),
	('911333', '9113', 'Endomen'),
	('911334', '9113', 'Kona'),
	('911335', '9113', 'Dirwemna'),
	('911336', '9113', 'Holuon'),
	('911337', '9113', 'Lolat'),
	('911338', '9113', 'Soloikma'),
	('911339', '9113', 'Sela'),
	('911340', '9113', 'Korupun'),
	('911341', '9113', 'Langda'),
	('911342', '9113', 'Bomela'),
	('911343', '9113', 'Suntamon'),
	('911344', '9113', 'Seredela'),
	('911345', '9113', 'Sobaham'),
	('911346', '9113', 'Kabianggama'),
	('911347', '9113', 'Kwelemdua'),
	('911348', '9113', 'Kwikma'),
	('911349', '9113', 'Hilipuk'),
	('911350', '9113', 'Duram'),
	('911351', '9113', 'Yogosem'),
	('911352', '9113', 'Kayo'),
	('911353', '9113', 'Sumo'),
	('911401', '9114', 'Karubaga'),
	('911402', '9114', 'Bokondini'),
	('911403', '9114', 'Kanggime'),
	('911404', '9114', 'Kembu'),
	('911405', '9114', 'Goyage'),
	('911406', '9114', 'Wunim'),
	('911407', '9114', 'Wina'),
	('911408', '9114', 'Umagi'),
	('911409', '9114', 'Panaga'),
	('911410', '9114', 'Woniki'),
	('911411', '9114', 'Kubu'),
	('911412', '9114', 'Konda/ Kondaga'),
	('911413', '9114', 'Nelawi'),
	('911414', '9114', 'Kuari'),
	('911415', '9114', 'Bokoneri'),
	('911416', '9114', 'Bewani'),
	('911418', '9114', 'Nabunage'),
	('911419', '9114', 'Gilubandu'),
	('911420', '9114', 'Nunggawi'),
	('911421', '9114', 'Gundagi'),
	('911422', '9114', 'Numba'),
	('911423', '9114', 'Timori'),
	('911424', '9114', 'Dundu'),
	('911425', '9114', 'Geya'),
	('911426', '9114', 'Egiam'),
	('911427', '9114', 'Poganeri'),
	('911428', '9114', 'Kamboneri'),
	('911429', '9114', 'Airgaram'),
	('911430', '9114', 'Wari/Taiyeve II'),
	('911431', '9114', 'Dow'),
	('911432', '9114', 'Tagineri'),
	('911433', '9114', 'Yuneri'),
	('911434', '9114', 'Wakuwo'),
	('911435', '9114', 'Gika'),
	('911436', '9114', 'Telenggeme'),
	('911437', '9114', 'Anawi'),
	('911438', '9114', 'Wenam'),
	('911439', '9114', 'Wugi'),
	('911440', '9114', 'Danime'),
	('911441', '9114', 'Tagime'),
	('911442', '9114', 'Kai'),
	('911443', '9114', 'Aweku'),
	('911444', '9114', 'Bogonuk'),
	('911445', '9114', 'Li Anogomma'),
	('911446', '9114', 'Biuk'),
	('911447', '9114', 'Yuko'),
	('911501', '9115', 'Waropen Bawah'),
	('911503', '9115', 'Masirei'),
	('911507', '9115', 'Risei Sayati'),
	('911508', '9115', 'Urei Faisei'),
	('911509', '9115', 'Inggerus'),
	('911510', '9115', 'Kirihi'),
	('911511', '9115', 'Oudate'),
	('911512', '9115', 'Wapoga'),
	('911513', '9115', 'Demba'),
	('911514', '9115', 'Wonti'),
	('911515', '9115', 'Soyoi Mambai'),
	('911601', '9116', 'Mandobo'),
	('911602', '9116', 'Mindiptana'),
	('911603', '9116', 'Waropko'),
	('911604', '9116', 'Kouh'),
	('911605', '9116', 'Jair'),
	('911606', '9116', 'Bomakia'),
	('911607', '9116', 'Kombut'),
	('911608', '9116', 'Iniyandit'),
	('911609', '9116', 'Arimop'),
	('911610', '9116', 'Fofi'),
	('911611', '9116', 'Ambatkwi'),
	('911612', '9116', 'Manggelum'),
	('911613', '9116', 'Firiwage'),
	('911614', '9116', 'Yaniruma'),
	('911615', '9116', 'Subur'),
	('911616', '9116', 'Kombay'),
	('911617', '9116', 'Ninati'),
	('911618', '9116', 'Sesnuk'),
	('911619', '9116', 'Ki'),
	('911620', '9116', 'Kawagit'),
	('911701', '9117', 'Obaa'),
	('911702', '9117', 'Mambioman Bapai'),
	('911703', '9117', 'Citak-Mitak'),
	('911704', '9117', 'Edera'),
	('911705', '9117', 'Haju'),
	('911706', '9117', 'Assue'),
	('911707', '9117', 'Kaibar'),
	('911708', '9117', 'Passue'),
	('911709', '9117', 'Minyamur'),
	('911710', '9117', 'Venaha'),
	('911711', '9117', 'Syahcame'),
	('911712', '9117', 'Yakomi'),
	('911713', '9117', 'Bamgi'),
	('911714', '9117', 'Passue Bawah'),
	('911715', '9117', 'Ti Zain'),
	('911801', '9118', 'Agats'),
	('911802', '9118', 'Atsj'),
	('911803', '9118', 'Sawa Erma'),
	('911804', '9118', 'Akat'),
	('911805', '9118', 'Fayit'),
	('911806', '9118', 'Pantai Kasuari'),
	('911807', '9118', 'Suator'),
	('911808', '9118', 'Suru-suru'),
	('911809', '9118', 'Kolf Braza'),
	('911810', '9118', 'Unir Sirau'),
	('911811', '9118', 'Joerat'),
	('911812', '9118', 'Pulau Tiga'),
	('911813', '9118', 'Jetsy'),
	('911814', '9118', 'Der Koumur'),
	('911815', '9118', 'Kopay'),
	('911816', '9118', 'Safan'),
	('911817', '9118', 'Sirets'),
	('911818', '9118', 'Ayip'),
	('911819', '9118', 'Betcbamu'),
	('911901', '9119', 'Supiori Selatan'),
	('911902', '9119', 'Supiori Utara'),
	('911903', '9119', 'Supiori Timur'),
	('911904', '9119', 'Kepulauan Aruri'),
	('911905', '9119', 'Supiori Barat'),
	('912001', '9120', 'Mamberamo Tengah'),
	('912002', '9120', 'Mamberamo Hulu'),
	('912003', '9120', 'Rufaer'),
	('912004', '9120', 'Mamberamo Tengah Timur'),
	('912005', '9120', 'Mamberamo Hilir'),
	('912006', '9120', 'Waropen Atas'),
	('912007', '9120', 'Benuki'),
	('912008', '9120', 'Sawai'),
	('912101', '9121', 'Kobagma'),
	('912102', '9121', 'Kelila'),
	('912103', '9121', 'Eragayam'),
	('912104', '9121', 'Megambilis'),
	('912105', '9121', 'Ilugwa'),
	('912201', '9122', 'Elelim'),
	('912202', '9122', 'Apalapsili'),
	('912203', '9122', 'Abenaho'),
	('912204', '9122', 'Benawa'),
	('912205', '9122', 'Welarek'),
	('912301', '9123', 'Tiom'),
	('912302', '9123', 'Pirime'),
	('912303', '9123', 'Makki'),
	('912304', '9123', 'Gamelia'),
	('912305', '9123', 'Dimba'),
	('912306', '9123', 'Melagineri'),
	('912307', '9123', 'Balingga'),
	('912308', '9123', 'Tiomneri'),
	('912309', '9123', 'Kuyawage'),
	('912310', '9123', 'Poga'),
	('912311', '9123', 'Niname'),
	('912312', '9123', 'Nogi'),
	('912313', '9123', 'Yiginua'),
	('912314', '9123', 'Tiom Ollo'),
	('912315', '9123', 'Yugungwi'),
	('912316', '9123', 'Mokoni'),
	('912317', '9123', 'Wereka'),
	('912318', '9123', 'Milimbo'),
	('912319', '9123', 'Wiringgambut'),
	('912320', '9123', 'Gollo'),
	('912321', '9123', 'Awina'),
	('912322', '9123', 'Ayumnati'),
	('912323', '9123', 'Wano Barat'),
	('912324', '9123', 'Goa Balim'),
	('912325', '9123', 'Bruwa'),
	('912326', '9123', 'Balingga Barat'),
	('912327', '9123', 'Gupura'),
	('912328', '9123', 'Kolawa'),
	('912329', '9123', 'Gelok Beam'),
	('912330', '9123', 'Kuly Lanny'),
	('912331', '9123', 'Lannyna'),
	('912332', '9123', 'Karu'),
	('912333', '9123', 'Yiluk'),
	('912334', '9123', 'Guna'),
	('912335', '9123', 'Kelulome'),
	('912336', '9123', 'Nikogwe'),
	('912337', '9123', 'Muara'),
	('912338', '9123', 'Buguk Gona'),
	('912339', '9123', 'Melagi'),
	('912401', '9124', 'Kenyam'),
	('912402', '9124', 'Mapenduma'),
	('912403', '9124', 'Yigi'),
	('912404', '9124', 'Wosak'),
	('912405', '9124', 'Geselma'),
	('912406', '9124', 'Mugi'),
	('912407', '9124', 'Mbuwa'),
	('912408', '9124', 'Gearek'),
	('912409', '9124', 'Koroptak'),
	('912410', '9124', 'Kegayem'),
	('912411', '9124', 'Paro'),
	('912412', '9124', 'Mebarok'),
	('912413', '9124', 'Yenggelo'),
	('912414', '9124', 'Kilmid'),
	('912415', '9124', 'Alama'),
	('912416', '9124', 'Yal'),
	('912417', '9124', 'Mam'),
	('912418', '9124', 'Dal'),
	('912419', '9124', 'Nirkuri'),
	('912420', '9124', 'Inikgal'),
	('912421', '9124', 'Iniye'),
	('912422', '9124', 'Mbulmu Yalma'),
	('912423', '9124', 'Mbua Tengah'),
	('912424', '9124', 'Embetpen'),
	('912425', '9124', 'Kora'),
	('912426', '9124', 'Wusi'),
	('912427', '9124', 'Pija'),
	('912428', '9124', 'Moba'),
	('912429', '9124', 'Wutpaga'),
	('912430', '9124', 'Nenggeagin'),
	('912431', '9124', 'Krepkuri'),
	('912432', '9124', 'Pasir Putih'),
	('912501', '9125', 'Ilaga'),
	('912502', '9125', 'Wangbe'),
	('912503', '9125', 'Beoga'),
	('912504', '9125', 'Doufo'),
	('912505', '9125', 'Pogoma'),
	('912506', '9125', 'Sinak'),
	('912507', '9125', 'Agandugume'),
	('912508', '9125', 'Gome'),
	('912601', '9126', 'Kamu'),
	('912602', '9126', 'Mapia'),
	('912603', '9126', 'Piyaiye'),
	('912604', '9126', 'Kamu Utara'),
	('912605', '9126', 'Sukikai Selatan'),
	('912606', '9126', 'Mapia Barat'),
	('912607', '9126', 'Kamu Selatan'),
	('912608', '9126', 'Kamu Timur'),
	('912609', '9126', 'Mapia Tengah'),
	('912610', '9126', 'Dogiyai'),
	('912701', '9127', 'Sugapa'),
	('912702', '9127', 'Homeyo'),
	('912703', '9127', 'Wandai'),
	('912704', '9127', 'Biandoga'),
	('912705', '9127', 'Agisiga'),
	('912706', '9127', 'Hitadipa'),
	('912707', '9127', 'Ugimba'),
	('912708', '9127', 'Tomosiga'),
	('912801', '9128', 'Tigi'),
	('912802', '9128', 'Tigi Timur'),
	('912803', '9128', 'Bowobado'),
	('912804', '9128', 'Tigi Barat'),
	('912805', '9128', 'Kapiraya'),
	('917101', '9171', 'Jayapura Utara'),
	('917102', '9171', 'Jayapura Selatan'),
	('917103', '9171', 'Abepura'),
	('917104', '9171', 'Muara Tami'),
	('917105', '9171', 'Heram'),
	('920101', '9201', 'Makbon'),
	('920104', '9201', 'Beraur'),
	('920105', '9201', 'Salawati'),
	('920106', '9201', 'Seget'),
	('920107', '9201', 'Aimas'),
	('920108', '9201', 'Klamono'),
	('920110', '9201', 'Sayosa'),
	('920112', '9201', 'Segun'),
	('920113', '9201', 'Mayamuk'),
	('920114', '9201', 'Salawati Selatan'),
	('920117', '9201', 'Klabot'),
	('920118', '9201', 'Klawak'),
	('920120', '9201', 'Maudus'),
	('920139', '9201', 'Mariat'),
	('920140', '9201', 'Klaili'),
	('920141', '9201', 'Klaso'),
	('920142', '9201', 'Moisegen'),
	('920203', '9202', 'Warmare'),
	('920204', '9202', 'Prafi'),
	('920205', '9202', 'Masni'),
	('920212', '9202', 'Manokwari Barat'),
	('920213', '9202', 'Manokwari Timur'),
	('920214', '9202', 'Manokwari Utara'),
	('920215', '9202', 'Manokwari Selatan'),
	('920217', '9202', 'Tanah Rubuh'),
	('920221', '9202', 'Sidey'),
	('920301', '9203', 'Fak-Fak'),
	('920302', '9203', 'Fak-Fak Barat'),
	('920303', '9203', 'Fak-Fak Timur'),
	('920304', '9203', 'Kokas'),
	('920305', '9203', 'Fak-Fak Tengah'),
	('920306', '9203', 'Karas'),
	('920307', '9203', 'Bomberay'),
	('920308', '9203', 'Kramongmongga'),
	('920309', '9203', 'Teluk Patipi'),
	('920310', '9203', 'Pariwari'),
	('920311', '9203', 'Wartutin'),
	('920312', '9203', 'Fakfak Timur Tengah'),
	('920313', '9203', 'Arguni'),
	('920314', '9203', 'Mbahamdandara'),
	('920315', '9203', 'Kayauni'),
	('920316', '9203', 'Furwagi'),
	('920317', '9203', 'Tomage'),
	('920401', '9204', 'Teminabuan'),
	('920404', '9204', 'Inanwatan'),
	('920406', '9204', 'Sawiat'),
	('920409', '9204', 'Kokoda'),
	('920410', '9204', 'Moswaren'),
	('920411', '9204', 'Seremuk'),
	('920412', '9204', 'Wayer'),
	('920414', '9204', 'Kais'),
	('920415', '9204', 'Konda'),
	('920420', '9204', 'Matemani'),
	('920421', '9204', 'Kokoda Utara'),
	('920422', '9204', 'Saifi'),
	('920424', '9204', 'Fokour'),
	('920501', '9205', 'Misool (Misool Utara)'),
	('920502', '9205', 'Waigeo Utara'),
	('920503', '9205', 'Waigeo Selatan'),
	('920504', '9205', 'Salawati Utara'),
	('920505', '9205', 'Kepulauan Ayau'),
	('920506', '9205', 'Misool Timur'),
	('920507', '9205', 'Waigeo Barat'),
	('920508', '9205', 'Waigeo Timur'),
	('920509', '9205', 'Teluk Mayalibit'),
	('920510', '9205', 'Kofiau'),
	('920511', '9205', 'Meos Mansar'),
	('920513', '9205', 'Misool Selatan'),
	('920514', '9205', 'Warwarbomi'),
	('920515', '9205', 'Waigeo Barat Kepulauan'),
	('920516', '9205', 'Misool Barat'),
	('920517', '9205', 'Kepulauan Sembilan'),
	('920518', '9205', 'Kota Waisai'),
	('920519', '9205', 'Tiplol Mayalibit'),
	('920520', '9205', 'Batanta Utara'),
	('920521', '9205', 'Salawati Barat'),
	('920522', '9205', 'Salawati Tengah'),
	('920523', '9205', 'Supnin'),
	('920524', '9205', 'Ayau'),
	('920525', '9205', 'Batanta Selatan'),
	('920601', '9206', 'Bintuni'),
	('920602', '9206', 'Merdey'),
	('920603', '9206', 'Babo'),
	('920604', '9206', 'Aranday'),
	('920605', '9206', 'Moskona Selatan'),
	('920606', '9206', 'Moskona Utara'),
	('920607', '9206', 'Wamesa'),
	('920608', '9206', 'Fafurwar'),
	('920609', '9206', 'Tembuni'),
	('920610', '9206', 'Kuri'),
	('920611', '9206', 'Manimeri'),
	('920612', '9206', 'Tuhiba'),
	('920613', '9206', 'Dataran Beimes'),
	('920614', '9206', 'Sumuri'),
	('920615', '9206', 'Kaitaro'),
	('920616', '9206', 'Aroba'),
	('920617', '9206', 'Masyeta'),
	('920618', '9206', 'Biscoop'),
	('920619', '9206', 'Tomu'),
	('920620', '9206', 'Kamundan'),
	('920621', '9206', 'Weriagar'),
	('920622', '9206', 'Moskona Barat'),
	('920623', '9206', 'Meyado'),
	('920624', '9206', 'Moskona Timur'),
	('920701', '9207', 'Wasior'),
	('920702', '9207', 'Windesi'),
	('920703', '9207', 'Teluk Duairi'),
	('920704', '9207', 'Wondiboy'),
	('920705', '9207', 'Wamesa'),
	('920706', '9207', 'Rumberpon'),
	('920707', '9207', 'Naikere'),
	('920708', '9207', 'Rasiei'),
	('920709', '9207', 'Kuri Wamesa'),
	('920710', '9207', 'Roon'),
	('920711', '9207', 'Roswar'),
	('920712', '9207', 'Nikiwar'),
	('920713', '9207', 'Soug Jaya'),
	('920801', '9208', 'Kaimana'),
	('920802', '9208', 'Buruway'),
	('920803', '9208', 'Teluk Arguni Atas'),
	('920804', '9208', 'Teluk Etna'),
	('920805', '9208', 'Kambrau'),
	('920806', '9208', 'Teluk Arguni Bawah'),
	('920807', '9208', 'Yamor'),
	('920901', '9209', 'Fef'),
	('920902', '9209', 'Miyah'),
	('920903', '9209', 'Yembun'),
	('920904', '9209', 'Kwoor'),
	('920905', '9209', 'Sausapor'),
	('920906', '9209', 'Abun'),
	('920907', '9209', 'Syujak'),
	('920908', '9209', 'Moraid'),
	('920909', '9209', 'Kebar'),
	('920910', '9209', 'Amberbaken'),
	('920911', '9209', 'Senopi'),
	('920912', '9209', 'Mubrani'),
	('920913', '9209', 'Bikar'),
	('920914', '9209', 'Bamusbama'),
	('920915', '9209', 'Ases'),
	('920916', '9209', 'Miyah Selatan'),
	('920917', '9209', 'Ireres'),
	('920918', '9209', 'Tobouw'),
	('920919', '9209', 'Wilhem Roumbouts'),
	('920920', '9209', 'Tinggouw'),
	('920921', '9209', 'Kwesefo'),
	('920922', '9209', 'Mawabuan'),
	('920923', '9209', 'Kebar Timur'),
	('920924', '9209', 'Kebar Selatan'),
	('920925', '9209', 'Manekar'),
	('920926', '9209', 'Mpur'),
	('920927', '9209', 'Amberbaken Barat'),
	('920928', '9209', 'Kasi'),
	('920929', '9209', 'Selemkai'),
	('921001', '9210', 'Aifat'),
	('921002', '9210', 'Aifat Utara'),
	('921003', '9210', 'Aifat Timur'),
	('921004', '9210', 'Aifat Selatan'),
	('921005', '9210', 'Aitinyo Barat'),
	('921006', '9210', 'Aitinyo'),
	('921007', '9210', 'Aitinyo Utara'),
	('921008', '9210', 'Ayamaru'),
	('921009', '9210', 'Ayamaru Utara'),
	('921010', '9210', 'Ayamaru Timur'),
	('921011', '9210', 'Mare'),
	('921012', '9210', 'Aifat Timur Tengah'),
	('921013', '9210', 'Aifat Timur Jauh'),
	('921014', '9210', 'Aifat Timur Selatan'),
	('921015', '9210', 'Ayamaru Selatan'),
	('921016', '9210', 'Ayamaru Jaya'),
	('921017', '9210', 'Ayamaru Selatan Jaya'),
	('921018', '9210', 'Ayamaru Timur Selatan'),
	('921019', '9210', 'Ayamaru Utara Timur'),
	('921020', '9210', 'Ayamaru Tengah'),
	('921021', '9210', 'Ayamaru Barat'),
	('921022', '9210', 'Aitinyo Tengah'),
	('921023', '9210', 'Aitinyo Raya'),
	('921024', '9210', 'Mare Selatan'),
	('921101', '9211', 'Ransiki'),
	('921102', '9211', 'Oransbari'),
	('921103', '9211', 'Neney'),
	('921104', '9211', 'Dataran Isim'),
	('921105', '9211', 'Momi Waren'),
	('921106', '9211', 'Tahota'),
	('921201', '9212', 'Anggi'),
	('921202', '9212', 'Anggi Gida'),
	('921203', '9212', 'Membey'),
	('921204', '9212', 'Sururey'),
	('921205', '9212', 'Didohu'),
	('921206', '9212', 'Taige'),
	('921207', '9212', 'Catubouw'),
	('921208', '9212', 'Testega'),
	('921209', '9212', 'Minyambaouw'),
	('921210', '9212', 'Hingk'),
	('927101', '9271', 'Sorong'),
	('927102', '9271', 'Sorong Timur'),
	('927103', '9271', 'Sorong Barat'),
	('927104', '9271', 'Sorong Kepulauan'),
	('927105', '9271', 'Sorong Utara'),
	('927106', '9271', 'Sorong Manoi'),
	('927107', '9271', 'Sorong Kota'),
	('927108', '9271', 'Klaurung'),
	('927109', '9271', 'Malaimsimsa'),
	('927110', '9271', 'Maladum Mes');

-- Dumping structure for table keuangan2.kelurahan
DROP TABLE IF EXISTS `kelurahan`;
CREATE TABLE IF NOT EXISTS `kelurahan` (
  `id_kel` char(10) NOT NULL,
  `id_kec` char(6) DEFAULT NULL,
  `nama` tinytext,
  `id_jenis` int(11) NOT NULL,
  PRIMARY KEY (`id_kel`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Dumping data for table keuangan2.kelurahan: ~17,815 rows (approximately)
INSERT INTO `kelurahan` (`id_kel`, `id_kec`, `nama`, `id_jenis`) VALUES
	('1101012001', '110101', 'Keude Bakongan', 4),
	('1101012002', '110101', 'Ujung Mangki', 4),
	('1101012003', '110101', 'Ujung Padang', 4),
	('1101012004', '110101', 'Kampong Drien', 4),
	('1101012015', '110101', 'Darul Ikhsan', 4),
	('1101012016', '110101', 'Padang Berahan', 4),
	('1101012017', '110101', 'Gampong Baro', 4),
	('1101022001', '110102', 'Fajar Harapan', 4),
	('1101022002', '110102', 'Krueng Batee', 4),
	('1101022003', '110102', 'Pasi Kuala Asahan', 4),
	('1101022004', '110102', 'Gunung Pulo', 4),
	('1101022005', '110102', 'Pulo IE I', 4),
	('1101022006', '110102', 'Jambo Manyang', 4),
	('1101022007', '110102', 'Simpang Empat', 4),
	('1101022008', '110102', 'Limau Purut', 4),
	('1101022009', '110102', 'Pulo Kambing', 4),
	('1101022010', '110102', 'Kampung Paya', 4),
	('1101022011', '110102', 'Krueng Batu', 4),
	('1101022012', '110102', 'Krueng Kluet', 4),
	('1101022013', '110102', 'Alur Mas', 4),
	('1101022014', '110102', 'Simpang Dua', 4),
	('1101022015', '110102', 'Simpang Tiga', 4),
	('1101022016', '110102', 'Simpang Lhee', 4),
	('1101022017', '110102', 'Suag Geuringgeng', 4),
	('1101022018', '110102', 'Pasi Kuala Baku', 4),
	('1101022019', '110102', 'Kedai Padang', 4),
	('1101022020', '110102', 'Kotafajar', 4),
	('1101022021', '110102', 'Gunung Pudung', 4),
	('1101032001', '110103', 'Suaq Bakong', 4),
	('1101032002', '110103', 'Rantau Benuang', 4),
	('1101032003', '110103', 'Barat Daya', 4),
	('1101032004', '110103', 'Sialang', 4),
	('1101032005', '110103', 'Kapeh', 4),
	('1101032006', '110103', 'Pulo IE', 4),
	('1101032007', '110103', 'Kedai Runding', 4),
	('1101032008', '110103', 'Kedai Kandang', 4),
	('1101032009', '110103', 'Luar', 4),
	('1101032010', '110103', 'Ujong', 4),
	('1101032011', '110103', 'Jua', 4),
	('1101032012', '110103', 'Pasi Meurapat', 4),
	('1101032013', '110103', 'Ujung Pasir', 4),
	('1101032014', '110103', 'Geulumbuk', 4),
	('1101032015', '110103', 'Pasie Lambang', 4),
	('1101032016', '110103', 'Ujung Padang', 4),
	('1101032017', '110103', 'Indra Damai', 4),
	('1101042001', '110104', 'Bakau Hulu', 4),
	('1101042002', '110104', 'Padang Baku', 4),
	('1101042003', '110104', 'Manggis Harapan', 4),
	('1101042004', '110104', 'Pasar Lama', 4),
	('1101042005', '110104', 'Apha', 4),
	('1101042006', '110104', 'Ujung Batu', 4),
	('1101042007', '110104', 'Pawoh', 4),
	('1101042008', '110104', 'Dalam', 4),
	('1101042009', '110104', 'Kota Palak', 4),
	('1101042010', '110104', 'Cacang', 4),
	('1101042011', '110104', 'Tengoh Pisang', 4),
	('1101042012', '110104', 'Pisang', 4),
	('1101042013', '110104', 'Hulu Pisang', 4),
	('1101042014', '110104', 'Tengah Baru', 4),
	('1101042015', '110104', 'Lembah Baru', 4),
	('1101042016', '110104', 'Padang Baru', 4),
	('1101052001', '110105', 'Kuta Buloh II', 4),
	('1101052002', '110105', 'Kuta Buloh I', 4),
	('1101052003', '110105', 'IE Dingin', 4),
	('1101052004', '110105', 'Drien Jalo', 4),
	('1101052005', '110105', 'Jambo Papeun', 4),
	('1101052006', '110105', 'Buket Mas', 4),
	('1101052007', '110105', 'Blang Kuala', 4),
	('1101052008', '110105', 'Rot Teungoh', 4),
	('1101052009', '110105', 'Alue Baro', 4),
	('1101052010', '110105', 'Ladang Tuha', 4),
	('1101052011', '110105', 'Lhok Mamplam', 4),
	('1101052012', '110105', 'Aron Tunggai', 4),
	('1101052013', '110105', 'Blang Teungoh', 4),
	('1101052014', '110105', 'Blang Bladeh', 4),
	('1101052015', '110105', 'IE Buboh', 4),
	('1101052016', '110105', 'Keudai Meukek', 4),
	('1101052017', '110105', 'Kota Baro', 4),
	('1101052018', '110105', 'Tanjung Harapan', 4),
	('1101052019', '110105', 'Labuhan Tarok', 4),
	('1101052020', '110105', 'Lhok Aman', 4),
	('1101052021', '110105', 'Alue Meutuwah', 4),
	('1101052022', '110105', 'Ladang Baro', 4),
	('1101052023', '110105', 'Labuhan Tarok II', 4),
	('1101062001', '110106', 'Dalam', 4),
	('1101062002', '110106', 'Subarang', 4),
	('1101062003', '110106', 'Kuta Baro', 4),
	('1101062004', '110106', 'Gunung Ketek', 4),
	('1101062005', '110106', 'Ladang Panton Luas', 4),
	('1101062006', '110106', 'Madat', 4),
	('1101062007', '110106', 'Alu Seumirah', 4),
	('1101062008', '110106', 'Tengah', 4),
	('1101062009', '110106', 'Gunung Cut', 4),
	('1101062010', '110106', 'Alur Pinang', 4),
	('1101062011', '110106', 'Kuta Blang', 4),
	('1101062012', '110106', 'Batee Tunggal', 4),
	('1101062013', '110106', 'Ujung Tanoh', 4),
	('1101062014', '110106', 'Ujung Kampung', 4),
	('1101062015', '110106', 'Jilatang', 4),
	('1101062016', '110106', 'Luar', 4),
	('1101062017', '110106', 'Lubuk Kayu', 4),
	('1101062018', '110106', 'Suaq Hulu', 4),
	('1101062019', '110106', 'Tampang', 4),
	('1101062020', '110106', 'Payo Nanggadang', 4),
	('1101062021', '110106', 'Gadang', 4),
	('1101062022', '110106', 'Baru', 4),
	('1101062023', '110106', 'Ladang Kasik Putih', 4),
	('1101062024', '110106', 'Air Sialang Hilir.', 4),
	('1101062025', '110106', 'Air Sialang Hulu', 4),
	('1101062026', '110106', 'Air Sialang Tengah', 4),
	('1101062027', '110106', 'Balai', 4),
	('1101062028', '110106', 'Arafah', 4),
	('1101072001', '110107', 'Sikulat', 4),
	('1101072002', '110107', 'Sawang I', 4),
	('1101072003', '110107', 'Meuligo', 4),
	('1101072004', '110107', 'Lhok Pawoh', 4),
	('1101072005', '110107', 'Sawang II', 4),
	('1101072006', '110107', 'Ujung Karang', 4),
	('1101072007', '110107', 'Trieng Meudeuro Baroh', 4),
	('1101072008', '110107', 'Trieng Meudeuro Tunong', 4),
	('1101072009', '110107', 'Panton Luas', 4),
	('1101072010', '110107', 'Simpang Tiga', 4),
	('1101072011', '110107', 'Kuta Baro', 4),
	('1101072012', '110107', 'Blang Geulinggang', 4),
	('1101072013', '110107', 'Mutiara', 4),
	('1101072014', '110107', 'Ujung Padang', 4),
	('1101072015', '110107', 'Sawang Ba\'u', 4),
	('1101082001', '110108', 'Lhok Keutapang', 4),
	('1101082002', '110108', 'Hilir', 4),
	('1101082003', '110108', 'Padang', 4),
	('1101082004', '110108', 'Hulu', 4),
	('1101082005', '110108', 'Jambo Apha', 4),
	('1101082006', '110108', 'Tepi Air', 4),
	('1101082007', '110108', 'Pasar Tapaktuan', 4),
	('1101082008', '110108', 'Lhok Bengkuang', 4),
	('1101082009', '110108', 'Panton Luas', 4),
	('1101082010', '110108', 'Gunung Kerambil', 4),
	('1101082011', '110108', 'Air Berundang', 4),
	('1101082012', '110108', 'Batu Itam', 4),
	('1101082013', '110108', 'Panju Plan', 4),
	('1101082014', '110108', 'Lhok Rukam', 4),
	('1101082015', '110108', 'Air Pinang', 4),
	('1101082016', '110108', 'Lhok Bengkuang Timur', 4),
	('1101092001', '110109', 'Kede Trumon', 4),
	('1101092002', '110109', 'Ujung Tanoh', 4),
	('1101092003', '110109', 'Sigleng', 4),
	('1101092004', '110109', 'Ie Meudama', 4),
	('1101092005', '110109', 'Tepin Tinggi', 4),
	('1101092006', '110109', 'Kuta Baro', 4),
	('1101092007', '110109', 'Panton Bilie', 4),
	('1101092012', '110109', 'Kuta Padang', 4),
	('1101092013', '110109', 'Raket', 4),
	('1101092015', '110109', 'Seuneubok Jaya', 4),
	('1101092016', '110109', 'Padang Harapan', 4),
	('1101102001', '110110', 'Ladang Teungoh', 4),
	('1101102002', '110110', 'Pucok Krueng', 4),
	('1101102003', '110110', 'Silolo', 4),
	('1101102004', '110110', 'Kampong Baru', 4),
	('1101102005', '110110', 'Panton Bili', 4),
	('1101102006', '110110', 'Paya Teuk', 4),
	('1101102007', '110110', 'Ladang Tuha', 4),
	('1101102008', '110110', 'Mata Ie', 4),
	('1101102009', '110110', 'Ujong Batee', 4),
	('1101102010', '110110', 'Lhok Sialang Cut', 4),
	('1101102011', '110110', 'Seunebok', 4),
	('1101102012', '110110', 'Ie Mirah', 4),
	('1101102013', '110110', 'Pasie Rasian', 4),
	('1101102014', '110110', 'Ujung Padang Rasian', 4),
	('1101102015', '110110', 'Krueng Kalee', 4),
	('1101102016', '110110', 'Lhok Sialang Rayeuk', 4),
	('1101102017', '110110', 'Pd. Macan Brs', 4),
	('1101102018', '110110', 'Teupin Gajah', 4),
	('1101102019', '110110', 'Ujung Padang Asahan', 4),
	('1101102020', '110110', 'Pulo Ie II', 4),
	('1101102021', '110110', 'Pante Raja', 4),
	('1101112001', '110111', 'Tengoh Peulumat', 4),
	('1101112002', '110111', 'Paya Peulumat', 4),
	('1101112003', '110111', 'Padang Peulumat', 4),
	('1101112004', '110111', 'Alur Peulumat', 4),
	('1101112005', '110111', 'Limau Saring', 4),
	('1101112006', '110111', 'Beutong', 4),
	('1101112007', '110111', 'Peuneulop', 4),
	('1101112008', '110111', 'Gunung Rotan', 4),
	('1101112009', '110111', 'Keumumu Hilir', 4),
	('1101112010', '110111', 'Keumumu Hulu', 4),
	('1101112011', '110111', 'Keumumu Seberang', 4),
	('1101112012', '110111', 'Sawang Indah', 4),
	('1101122001', '110112', 'Tutong', 4),
	('1101122002', '110112', 'Tengah Iboh', 4),
	('1101122003', '110112', 'Peulokan', 4),
	('1101122004', '110112', 'Kuta Iboh', 4),
	('1101122005', '110112', 'Ujung Padang', 4),
	('1101122006', '110112', 'Blang Baru', 4),
	('1101122007', '110112', 'Blang Poroh', 4),
	('1101122008', '110112', 'Pulo Ie', 4),
	('1101122009', '110112', 'Suaq Lokan', 4),
	('1101122010', '110112', 'Iku Lhung', 4),
	('1101122011', '110112', 'Kuta Trieng', 4),
	('1101122012', '110112', 'Pante Geulima', 4),
	('1101122013', '110112', 'Panton Pawoh', 4),
	('1101122014', '110112', 'Batee Meucanang', 4),
	('1101122015', '110112', 'Panton Rubek', 4),
	('1101132001', '110113', 'Koto Manggamat', 4),
	('1101132002', '110113', 'Alur Kejrun', 4),
	('1101132003', '110113', 'Jambo Papeun', 4),
	('1101132004', '110113', 'Malaka', 4),
	('1101132005', '110113', 'Koto Indarung', 4),
	('1101132006', '110113', 'Siurai-Urai', 4),
	('1101132007', '110113', 'Kampung Sawah', 4),
	('1101132008', '110113', 'Kampung Padang', 4),
	('1101132009', '110113', 'Pulo Air', 4),
	('1101132010', '110113', 'Lawe Melang', 4),
	('1101132011', '110113', 'Mersak', 4),
	('1101132012', '110113', 'Kampung Tinggi', 4),
	('1101132013', '110113', 'Ruak', 4),
	('1101142001', '110114', 'Paya Dapur', 4),
	('1101142002', '110114', 'Sapik', 4),
	('1101142003', '110114', 'Alai', 4),
	('1101142004', '110114', 'Durian Kawan', 4),
	('1101142005', '110114', 'Lawe Sawah', 4),
	('1101142006', '110114', 'Lawe Buluh Didi', 4),
	('1101142007', '110114', 'Pucuk Lembang', 4),
	('1101142008', '110114', 'Paya Laba', 4),
	('1101142009', '110114', 'Lawe Cimanok', 4),
	('1101152001', '110115', 'Seubadeh', 4),
	('1101152002', '110115', 'Ladang Rimba', 4),
	('1101152003', '110115', 'Ujong Pulo Rayeuk', 4),
	('1101152004', '110115', 'Sawah Tingkeum', 4),
	('1101152005', '110115', 'Simpang', 4),
	('1101152006', '110115', 'Ujong Pulo Cut', 4),
	('1101152007', '110115', 'Kampung Baru', 4),
	('1101152008', '110115', 'Seuleukat', 4),
	('1101162005', '110116', 'Pinto Rimba', 4),
	('1101162006', '110116', 'Krueng Luas', 4),
	('1101162007', '110116', 'Jambo Dalem', 4),
	('1101162008', '110116', 'Kapai Seusak', 4),
	('1101162009', '110116', 'Seuneubok Punto', 4),
	('1101162010', '110116', 'Seuneubok Psk.', 4),
	('1101162011', '110116', 'Alur Bujok', 4),
	('1101162012', '110116', 'Titi Polem', 4),
	('1101172001', '110117', 'Bukit Gadeng', 4),
	('1101172002', '110117', 'Rambong', 4),
	('1101172003', '110117', 'Seuneubok Keuranji', 4),
	('1101172004', '110117', 'Seuneubok Alur Buloh', 4),
	('1101172005', '110117', 'Ujong Tanoh', 4),
	('1101172006', '110117', 'Gunong Cut', 4),
	('1101172007', '110117', 'Gunong Rayeuk', 4),
	('1101172008', '110117', 'Beutong', 4),
	('1101172009', '110117', 'Jambo Keupok', 4),
	('1101172010', '110117', 'Alurduamas', 4),
	('1101182001', '110118', 'Ladang Rimba', 4),
	('1101182002', '110118', 'Gunong Kapo', 4),
	('1101182003', '110118', 'Kampong Teungoh', 4),
	('1101182004', '110118', 'Krueng Batee', 4),
	('1101182005', '110118', 'Pulo Paya', 4),
	('1101182006', '110118', 'Jambo Papeun', 4),
	('1101182007', '110118', 'Cot Bayu', 4),
	('1101182008', '110118', 'Naca', 4),
	('1101182009', '110118', 'Ie Jeureuneh', 4),
	('1101182010', '110118', 'Lhok Raya', 4),
	('1102012001', '110201', 'Ngkeren', 4),
	('1102012002', '110201', 'Rumah Kampung', 4),
	('1102012004', '110201', 'Pasir Bangun', 4),
	('1102012006', '110201', 'Kubu', 4),
	('1102012007', '110201', 'Lawe Kongker', 4),
	('1102012008', '110201', 'Kuta Cingkam II', 4),
	('1102012009', '110201', 'Muara Baru', 4),
	('1102012011', '110201', 'Kuta Batu I', 4),
	('1102012012', '110201', 'Kuta Cingkam I', 4),
	('1102012013', '110201', 'Kuta Batu II', 4),
	('1102012014', '110201', 'Lawe Sempilang', 4),
	('1102012015', '110201', 'Prapat Batu Nunggul', 4),
	('1102012016', '110201', 'Pulo Sepang', 4),
	('1102012017', '110201', 'Rih Mbelang', 4),
	('1102012018', '110201', 'Kute Batu Baru', 4),
	('1102012019', '110201', 'Darul Amin', 4),
	('1102012020', '110201', 'Lawe Lumbang Indah', 4),
	('1102012021', '110201', 'Batu Hamparan', 4),
	('1102012022', '110201', 'Paye Munje', 4),
	('1102012023', '110201', 'Pulo Ndadap', 4),
	('1102012024', '110201', 'Pasir Nunggul', 4),
	('1102012025', '110201', 'Cingkham Mekhanggun', 4),
	('1102012026', '110201', 'Pintu Khimbe', 4),
	('1102012027', '110201', 'Lawe Kongker Hilir', 4),
	('1102012028', '110201', 'Polu Gadung', 4),
	('1102012029', '110201', 'Pasikh Pekhemate', 4),
	('1102012030', '110201', 'Pasikh Nunang', 4),
	('1102012031', '110201', 'Deleng Kukusen', 4),
	('1102022001', '110202', 'Bukit Merdeka', 4),
	('1102022002', '110202', 'Darul Aman', 4),
	('1102022003', '110202', 'Lawe Kesumpat', 4),
	('1102022004', '110202', 'Lawe Tua Gabungan', 4),
	('1102022005', '110202', 'Lawe Sigala II', 4),
	('1102022006', '110202', 'Lawe Sigala Timur', 4),
	('1102022007', '110202', 'Lawe Sigala Barat', 4),
	('1102022008', '110202', 'Suka Damai', 4),
	('1102022009', '110202', 'Kute Tengah', 4),
	('1102022010', '110202', 'Tanah Baru', 4),
	('1102022011', '110202', 'Kedataran Gabungan', 4),
	('1102022012', '110202', 'Gabungan Parsaroan', 4),
	('1102022013', '110202', 'Lawe Loning Gabungan', 4),
	('1102022014', '110202', 'Lawe Loning Aman', 4),
	('1102022015', '110202', 'Suka Maju', 4),
	('1102022016', '110202', 'Lawe Tua Makmur', 4),
	('1102022017', '110202', 'Lawe Tua Pusat', 4),
	('1102022018', '110202', 'Kute Serke', 4),
	('1102022019', '110202', 'Lawe Rakat', 4),
	('1102022020', '110202', 'Suka Jaya', 4),
	('1102022021', '110202', 'Emiya Batu Dua Ratus', 4),
	('1102022022', '110202', 'Sebungke', 4),
	('1102022023', '110202', 'Bukit Sepakat', 4),
	('1102022024', '110202', 'Lawe Loning Sepakat', 4),
	('1102022025', '110202', 'Lawe Loning I', 4),
	('1102022026', '110202', 'Gaya Jaya', 4),
	('1102022027', '110202', 'Gajah Musara', 4),
	('1102022028', '110202', 'Mulie Damai', 4),
	('1102022029', '110202', 'Lawe Loning Hakhapen', 4),
	('1102022030', '110202', 'Karya Indah', 4),
	('1102022031', '110202', 'Kayu Mbelin', 4),
	('1102022032', '110202', 'Lawe Sigala Barat Jaya', 4),
	('1102022033', '110202', 'Lawe Pekhidinen', 4),
	('1102022034', '110202', 'Kertimbang', 4),
	('1102022035', '110202', 'Kute Dauh Nitenggau', 4),
	('1102032001', '110203', 'Bambel Gabungan', 4),
	('1102032002', '110203', 'Kisam', 4),
	('1102032005', '110203', 'Lawe Hijo', 4),
	('1102032006', '110203', 'Pinding', 4),
	('1102032009', '110203', 'Terutung Megara Asli', 4),
	('1102032011', '110203', 'Biak Muli', 4),
	('1102032012', '110203', 'Kute Lang-Lang', 4),
	('1102032013', '110203', 'Pedesi', 4),
	('1102032014', '110203', 'Terutung Peyung Hulu', 4),
	('1102032015', '110203', 'Terutung Peyung Hilir', 4),
	('1102032016', '110203', 'Tualang Sembilar', 4),
	('1102032017', '110203', 'Kuning I', 4),
	('1102032018', '110203', 'Kuning II', 4),
	('1102032019', '110203', 'Cinta Damai', 4),
	('1102032020', '110203', 'Likat', 4),
	('1102032021', '110203', 'Rikit', 4),
	('1102032023', '110203', 'Bambel', 4),
	('1102032025', '110203', 'Lawe Kihing', 4),
	('1102032026', '110203', 'Terutung Seperai', 4),
	('1102032027', '110203', 'Kute Sari', 4),
	('1102032028', '110203', 'Kute Antara', 4),
	('1102032029', '110203', 'Pulo Perengge', 4),
	('1102032031', '110203', 'Pulo Kendondong', 4),
	('1102032033', '110203', 'Pancakh Iman', 4),
	('1102032034', '110203', 'Biak Muli Bukhu', 4),
	('1102032035', '110203', 'Biak Muli Pantai Raja', 4),
	('1102032036', '110203', 'Biak Muli Sejahtera', 4),
	('1102032037', '110203', 'Lembah Haji', 4),
	('1102032038', '110203', 'Terutung Payung Gabungan', 4),
	('1102032039', '110203', 'Lawe Hijo Metuah', 4),
	('1102032040', '110203', 'Ampera', 4),
	('1102032041', '110203', 'Tembilakh Mbakhu', 4),
	('1102032042', '110203', 'Kute Lang-Lang Bakhu', 4),
	('1102042001', '110204', 'Kota Kutacane', 4),
	('1102042002', '110204', 'Perapat Hilir', 4),
	('1102042003', '110204', 'Perapat Hulu', 4),
	('1102042004', '110204', 'Muara Lawe Bulan', 4),
	('1102042005', '110204', 'Mbarung', 4),
	('1102042006', '110204', 'Batu Mbulan Asli', 4),
	('1102042007', '110204', 'Batu Mbulan I', 4),
	('1102042008', '110204', 'Batu Mbulan II', 4),
	('1102042009', '110204', 'Kampung Raja', 4),
	('1102042010', '110204', 'Pulonas', 4),
	('1102042011', '110204', 'Kampung Melayu Gabungan', 4),
	('1102042012', '110204', 'Terutung Pedi', 4),
	('1102042013', '110204', 'Kute Rih', 4),
	('1102042014', '110204', 'Gumpang Jaya', 4),
	('1102042015', '110204', 'Pulo Latong', 4),
	('1102042016', '110204', 'Kutacane Lama', 4),
	('1102042017', '110204', 'Batum Bln Baru', 4),
	('1102042018', '110204', 'Pulo Peding', 4),
	('1102042019', '110204', 'Mendabe', 4),
	('1102042020', '110204', 'Ujung Barat', 4),
	('1102042021', '110204', 'Perapat Titi Panjang', 4),
	('1102042022', '110204', 'Perapat Sepakat', 4),
	('1102042023', '110204', 'Alas Memancar', 4),
	('1102042024', '110204', 'Batu Mbulan Sepakat', 4),
	('1102042025', '110204', 'Pulo Sanggakh', 4),
	('1102042026', '110204', 'Melayu I', 4),
	('1102042027', '110204', 'Mburung Datuk Sekhudane', 4),
	('1102052005', '110205', 'Salang Alas', 4),
	('1102052009', '110205', 'Kute Pasir', 4),
	('1102052011', '110205', 'Purwodadi', 4),
	('1102052012', '110205', 'Kute Tinggi', 4),
	('1102052013', '110205', 'Kampung Baru', 4),
	('1102052014', '110205', 'Peranginan', 4),
	('1102052015', '110205', 'Natam', 4),
	('1102052025', '110205', 'Kumbang Jaya', 4),
	('1102052026', '110205', 'Kumbang Indah', 4),
	('1102052027', '110205', 'Natam Baru', 4),
	('1102052029', '110205', 'Delem Megakhae', 4),
	('1102052030', '110205', 'Lawe Bekung', 4),
	('1102052031', '110205', 'Lawe Bekung Tampahan', 4),
	('1102052032', '110205', 'Badar Indah', 4),
	('1102052033', '110205', 'Batu Mberong', 4),
	('1102052034', '110205', 'Tanah Merah', 4),
	('1102052035', '110205', 'Tanoh Megakhe', 4),
	('1102052036', '110205', 'Lawe Sekekhah', 4),
	('1102062001', '110206', 'Pardomuan II', 4),
	('1102062002', '110206', 'Lawe Desky I', 4),
	('1102062003', '110206', 'Lawe Desky Sabas', 4),
	('1102062004', '110206', 'Pardomuan I', 4),
	('1102062005', '110206', 'Cinta Damai', 4),
	('1102062006', '110206', 'Pardamean', 4),
	('1102062007', '110206', 'Lawe Desky Tengah', 4),
	('1102062008', '110206', 'Kute Bakti', 4),
	('1102062010', '110206', 'Muara Situlen', 4),
	('1102062011', '110206', 'Sejahtera', 4),
	('1102062012', '110206', 'Kute Makmur', 4),
	('1102062013', '110206', 'Perdamaian', 4),
	('1102062014', '110206', 'Lawe Mantik', 4),
	('1102062015', '110206', 'Cinta Makmur', 4),
	('1102062016', '110206', 'Muara Setia', 4),
	('1102062017', '110206', 'Tanoh Alas', 4),
	('1102062018', '110206', 'Sejahtera Baru', 4),
	('1102062024', '110206', 'Lawe Tawakh', 4),
	('1102062025', '110206', 'Sabilussalam', 4),
	('1102062026', '110206', 'Desky Jaya', 4),
	('1102062027', '110206', 'Pintu Alas', 4),
	('1102072001', '110207', 'Gulo', 4),
	('1102072002', '110207', 'Pulo Piku', 4),
	('1102072003', '110207', 'Terutung Kute', 4),
	('1102072004', '110207', 'Kuta Ujung', 4),
	('1102072005', '110207', 'Lawe Setul', 4),
	('1102072006', '110207', 'Kite Merangun', 4),
	('1102072007', '110207', 'Mamas', 4),
	('1102072008', '110207', 'Tanjung Lama', 4),
	('1102072009', '110207', 'Tanjung Muda', 4),
	('1102072010', '110207', 'Rambung Teldak', 4),
	('1102072011', '110207', 'Tanjung Aman', 4),
	('1102072012', '110207', 'Seri Muda', 4),
	('1102072013', '110207', 'Ujung Baru', 4),
	('1102072014', '110207', 'Kute Rambe', 4),
	('1102072015', '110207', 'Mamas Baru', 4),
	('1102072016', '110207', 'Rambung Jaya', 4),
	('1102072017', '110207', 'Makmur Jaya', 4),
	('1102072018', '110207', 'Darul Makmur', 4),
	('1102072019', '110207', 'Tanjung Mbakhu', 4),
	('1102072020', '110207', 'Pulo Gadung', 4),
	('1102072021', '110207', 'Kokthan Jaya', 4),
	('1102072022', '110207', 'Istikamah', 4),
	('1102072023', '110207', 'Lawe Mamas Indah', 4),
	('1102072024', '110207', 'Tanjung Leuser', 4),
	('1102072025', '110207', 'Simpang Empat Tanjung', 4),
	('1102072026', '110207', 'Lawe Pinis', 4),
	('1102072027', '110207', 'Buntul Kendawi', 4),
	('1102072028', '110207', 'Kuning Abadi', 4),
	('1102082001', '110208', 'Pasir Gala', 4),
	('1102082002', '110208', 'Pasir Penjengakan', 4),
	('1102082003', '110208', 'Kutem Baru', 4),
	('1102082004', '110208', 'Lawe Sagu Hulu', 4),
	('1102082005', '110208', 'Lawe Sagu Hilir', 4),
	('1102082006', '110208', 'Kute Bantil', 4),
	('1102082011', '110208', 'Lawe Kolok', 4),
	('1102082012', '110208', 'Lawe Rutung', 4),
	('1102082013', '110208', 'Kampung Nangka', 4),
	('1102082014', '110208', 'Tenembak Juhar', 4),
	('1102082015', '110208', 'Simpang Empat', 4),
	('1102082016', '110208', 'Kuta Buluh Botong', 4),
	('1102082017', '110208', 'Katembaru Bencawan', 4),
	('1102082018', '110208', 'Lawe Kinge', 4),
	('1102082019', '110208', 'Kd. Mbelang Mandiri', 4),
	('1102082020', '110208', 'Mbacang Racun', 4),
	('1102082021', '110208', 'Telaga Mekar', 4),
	('1102082023', '110208', 'Pulonas Baru', 4),
	('1102082025', '110208', 'Kuta Genting', 4),
	('1102082026', '110208', 'Lawe Sagu Baru', 4),
	('1102082027', '110208', 'Lawe Sagu', 4),
	('1102082028', '110208', 'Pekhapat Timur', 4),
	('1102082029', '110208', 'Bahagia', 4),
	('1102082030', '110208', 'Kuta Galuh Asli', 4),
	('1102092001', '110209', 'Kute Lengat Pangan', 4),
	('1102092002', '110209', 'Kute Lengat Selian', 4),
	('1102092003', '110209', 'Tualang Baru', 4),
	('1102092004', '110209', 'Alur Buluh', 4),
	('1102092005', '110209', 'Maha Singkil', 4),
	('1102092006', '110209', 'Tenembak Bintang', 4),
	('1102092007', '110209', 'Kute Lingga', 4),
	('1102092008', '110209', 'Rikit Bur', 4),
	('1102092010', '110209', 'Kerukunan', 4),
	('1102092011', '110209', 'Lawe Dua', 4),
	('1102092012', '110209', 'Rema', 4),
	('1102092013', '110209', 'Bambel Baru', 4),
	('1102092014', '110209', 'Pejuang', 4),
	('1102092015', '110209', 'Darussalam', 4),
	('1102092016', '110209', 'Amaliah', 4),
	('1102092017', '110209', 'Sebudi Jaya', 4),
	('1102092018', '110209', 'Gumpang', 4),
	('1102092019', '110209', 'Kute Gekhat', 4),
	('1102092020', '110209', 'Paye Khambung', 4),
	('1102092021', '110209', 'Mbak Sako', 4),
	('1102092022', '110209', 'Darul Imami', 4),
	('1102092023', '110209', 'Bukit Bur-II', 4),
	('1102092024', '110209', 'Kute Empat Lima', 4),
	('1102102001', '110210', 'Simpang Semadam', 4),
	('1102102002', '110210', 'Semadam Awal', 4),
	('1102102003', '110210', 'Semadam Asal', 4),
	('1102102004', '110210', 'Lawe Kinga Gabungan', 4),
	('1102102005', '110210', 'Lawe Kinga Tebing Tinggi', 4),
	('1102102006', '110210', 'Kebun Sere', 4),
	('1102102007', '110210', 'Laawe Berigin Horas', 4),
	('1102102008', '110210', 'Lawe. Berigin Gayo', 4),
	('1102102009', '110210', 'Suka Makmur', 4),
	('1102102010', '110210', 'Pasar Puntung', 4),
	('1102102011', '110210', 'Titi Pasir', 4),
	('1102102012', '110210', 'Lawe Petanduk', 4),
	('1102102013', '110210', 'Ngkeran Alur Buluh', 4),
	('1102102014', '110210', 'Kampung Baru', 4),
	('1102102015', '110210', 'Sepakat Segenap', 4),
	('1102102016', '110210', 'Selamat Indah', 4),
	('1102102017', '110210', 'Lawe Kinge', 4),
	('1102102018', '110210', 'Lawe Mejilai', 4),
	('1102102019', '110210', 'Lawe Petanduk-II', 4),
	('1102112004', '110211', 'Titi Mas', 4),
	('1102112005', '110211', 'Meranti', 4),
	('1102112006', '110211', 'Kute Lang-Lang', 4),
	('1102112007', '110211', 'Lawe Sumur', 4),
	('1102112008', '110211', 'Perdamaian', 4),
	('1102112009', '110211', 'Salim Pipit', 4),
	('1102112010', '110211', 'Penguhapan', 4),
	('1102112011', '110211', 'Lumban Tua', 4),
	('1102112012', '110211', 'Mutiara Damai', 4),
	('1102112013', '110211', 'Dolok Nauli', 4),
	('1102112014', '110211', 'Tuhi Jongkat', 4),
	('1102112015', '110211', 'Uning Sigugur', 4),
	('1102112016', '110211', 'Lumban Sitio', 4),
	('1102112017', '110211', 'Lawe Malum', 4),
	('1102112018', '110211', 'Alur Baning', 4),
	('1102112019', '110211', 'Lingge Alas', 4),
	('1102112020', '110211', 'Khambung Tumbung', 4),
	('1102112021', '110211', 'Tuah Mesade', 4),
	('1102112022', '110211', 'Sumukh Alas', 4),
	('1102112023', '110211', 'Alukh Bakhu', 4),
	('1102112024', '110211', 'Sepekhiding', 4),
	('1102112025', '110211', 'Tanoh Subukh', 4),
	('1102112026', '110211', 'Pinggan Mbelang', 4),
	('1102112027', '110211', 'Sigai Indah', 4),
	('1102112028', '110211', 'Ukekh Deleng', 4),
	('1102112029', '110211', 'Alas Mesikhat', 4),
	('1102112030', '110211', 'Titi Hakhapen', 4),
	('1102122001', '110212', 'Aunan Sepakat', 4),
	('1102122002', '110212', 'Lawe Penanggalan', 4),
	('1102122003', '110212', 'Lawe Mengkudu', 4),
	('1102122004', '110212', 'Jambur Lak-lak', 4),
	('1102122005', '110212', 'Simpang Tiga Jongar', 4),
	('1102122006', '110212', 'Jongar Asli', 4),
	('1102122007', '110212', 'Ketambe', 4),
	('1102122008', '110212', 'Rumah Bundar', 4),
	('1102122009', '110212', 'Penyeb. Cingkam', 4),
	('1102122010', '110212', 'Deleng Damar', 4),
	('1102122011', '110212', 'Bintang Bener', 4),
	('1102122012', '110212', 'Sukarimbun', 4),
	('1102122013', '110212', 'Lawe Aunen', 4),
	('1102122014', '110212', 'Bener Bepapah', 4),
	('1102122015', '110212', 'Penungkenen', 4),
	('1102122016', '110212', 'Datok Pining', 4),
	('1102122017', '110212', 'Kati Maju', 4),
	('1102122018', '110212', 'Leuser', 4),
	('1102122019', '110212', 'Jati Sara', 4),
	('1102122020', '110212', 'Buket Mbakhu', 4),
	('1102122021', '110212', 'Kayu Mentangur', 4),
	('1102122022', '110212', 'Lawe Sembekan', 4),
	('1102122023', '110212', 'Lawe Bekhingin', 4),
	('1102122024', '110212', 'Lawe Ger-Ger', 4),
	('1102122025', '110212', 'Simpur Jaya', 4),
	('1102132001', '110213', 'Salang Baru', 4),
	('1102132002', '110213', 'Ranta Dior', 4),
	('1102132003', '110213', 'Lembah Alas', 4),
	('1102132004', '110213', 'Tenembak Lang-Lang', 4),
	('1102132005', '110213', 'Salang Sigotom', 4),
	('1102132006', '110213', 'Tualang Lama', 4),
	('1102132007', '110213', 'Gusung Batu', 4),
	('1102132008', '110213', 'Kayu Pangor', 4),
	('1102132009', '110213', 'Sepakat', 4),
	('1102132010', '110213', 'Lawe Pangkat', 4),
	('1102132011', '110213', 'Bunga Melur', 4),
	('1102132012', '110213', 'Penampaan', 4),
	('1102132013', '110213', 'Terutung Mbelang', 4),
	('1102132014', '110213', 'Salang Muara', 4),
	('1102132015', '110213', 'Lawe Hakhum', 4),
	('1102132016', '110213', 'Tanoh Khukahen', 4),
	('1102132017', '110213', 'Tading Niulihi', 4),
	('1102132018', '110213', 'Peseluk Pesimbe', 4),
	('1102132019', '110213', 'Kane Lot', 4),
	('1102132020', '110213', 'Muhajirin', 4),
	('1102132021', '110213', 'Beriring Naru', 4),
	('1102132022', '110213', 'Kati Jeroh', 4),
	('1102142001', '110214', 'Terutung Megara Lawe Pasaran', 4),
	('1102142002', '110214', 'Kisam Gabungan', 4),
	('1102142003', '110214', 'Kisam Kute Pasir', 4),
	('1102142004', '110214', 'Lawe Sumur', 4),
	('1102142005', '110214', 'Lawe Sumur Baru', 4),
	('1102142006', '110214', 'Kuta Lesung', 4),
	('1102142007', '110214', 'Berandang', 4),
	('1102142008', '110214', 'Kute Bunin', 4),
	('1102142009', '110214', 'Buah Pala', 4),
	('1102142010', '110214', 'Penosan', 4),
	('1102142011', '110214', 'Tengku Mbelim', 4),
	('1102142012', '110214', 'Megakhe Bakhu', 4),
	('1102142013', '110214', 'Kisam Lestari', 4),
	('1102142014', '110214', 'Kisam Kue Khambe', 4),
	('1102142015', '110214', 'Lawe Polak', 4),
	('1102142016', '110214', 'Lawe Semukh Sepakat', 4),
	('1102142017', '110214', 'Setia Baru', 4),
	('1102142018', '110214', 'Teger Miko', 4),
	('1102152001', '110215', 'Salim Pinim', 4),
	('1102152002', '110215', 'Jambur Damar', 4),
	('1102152003', '110215', 'Alur Langsat', 4),
	('1102152004', '110215', 'Rambah Sayang', 4),
	('1102152006', '110215', 'Rumah Luar', 4),
	('1102152007', '110215', 'Tenembak Alas', 4),
	('1102152008', '110215', 'Lawe Tungkal', 4),
	('1102152009', '110215', 'Salim Pinim II', 4),
	('1102152010', '110215', 'Jambukh Pekhmate', 4),
	('1102152011', '110215', 'Khutung Mbelang', 4),
	('1102152012', '110215', 'Timang Khase', 4),
	('1102152013', '110215', 'Stambul Jaya', 4),
	('1102152014', '110215', 'Alukh Nangke', 4),
	('1102152015', '110215', 'Mejile', 4),
	('1102162001', '110216', 'Bintang Alga Musara', 4),
	('1102162002', '110216', 'Bukit Bintang Indah', 4),
	('1102162003', '110216', 'Tanjung Sari', 4),
	('1102162004', '110216', 'Bunbun Alas', 4),
	('1102162005', '110216', 'Naga Timbul', 4),
	('1102162006', '110216', 'Gunung Pak-Pak', 4),
	('1102162007', '110216', 'Bukit Mekhiah', 4),
	('1102162008', '110216', 'Permata Musara', 4),
	('1102162009', '110216', 'Laut Tawar', 4),
	('1102162010', '110216', 'Kane Mende', 4),
	('1102162011', '110216', 'Lawe Sekhakut', 4),
	('1102162012', '110216', 'Bunbun Indah War', 4),
	('1102162013', '110216', 'Suka Damai', 4),
	('1102162014', '110216', 'Tanah Khekhine', 4),
	('1102162015', '110216', 'Punce Nali', 4),
	('1102162016', '110216', 'Sade Ate', 4),
	('1102162017', '110216', 'Akhih Majile', 4),
	('1102162018', '110216', 'Ukhat Peseluk', 4),
	('1102162019', '110216', 'Tunas Mude', 4),
	('1102162020', '110216', 'Gaye Sendah', 4),
	('1102162021', '110216', 'Hakhapen', 4),
	('1102162022', '110216', 'Kompas', 4),
	('1102162023', '110216', 'Sepakat', 4),
	('1103012001', '110301', 'Alue Luddin Sa', 4),
	('1103012002', '110301', 'Alue Luddin Dua', 4),
	('1103012003', '110301', 'Alue Dalam', 4),
	('1103012004', '110301', 'Dama Pulo Sa', 4),
	('1103012005', '110301', 'Dama Pulo Dua', 4),
	('1103012006', '110301', 'Buket Kulam', 4),
	('1103012007', '110301', 'Seuneubok Teungoh', 4),
	('1103012008', '110301', 'Jungka Gajah', 4),
	('1103012009', '110301', 'Seuneubok Simpang', 4),
	('1103012010', '110301', 'Matang Pineung', 4),
	('1103012011', '110301', 'Lhok Geulumpang', 4),
	('1103012012', '110301', 'Blang Buket', 4),
	('1103012013', '110301', 'Meunasah Keutapang', 4),
	('1103012014', '110301', 'Buket Rumia', 4),
	('1103012015', '110301', 'Alue Gadeng', 4),
	('1103012016', '110301', 'Kapai Baro', 4),
	('1103012017', '110301', 'Seuneubok Tuha Sa', 4),
	('1103012018', '110301', 'Seuneubok Tuha Dua', 4),
	('1103012019', '110301', 'Seuneubok Buloh', 4),
	('1103012020', '110301', 'Gaseh Sayang', 4),
	('1103012021', '110301', 'Alue Lhok', 4),
	('1103012022', '110301', 'Trieng Gadeng', 4),
	('1103012023', '110301', 'Grong-Grong', 4),
	('1103012024', '110301', 'Matang Geutou', 4),
	('1103012025', '110301', 'Alue Merbo', 4),
	('1103012026', '110301', 'Buket Raya', 4),
	('1103012027', '110301', 'Gampong Keude', 4),
	('1103012028', '110301', 'Peukan Idi Cut', 4),
	('1103012029', '110301', 'Gampong Beunot', 4),
	('1103012030', '110301', 'Seuneubok Baroh', 4),
	('1103012031', '110301', 'Teupin Drum', 4),
	('1103012032', '110301', 'Kuala Idi Cut', 4),
	('1103012034', '110301', 'Seuneubok Aceh', 4),
	('1103012035', '110301', 'Gampong Baro', 4),
	('1103012036', '110301', 'Bagok Panah Sa', 4),
	('1103012037', '110301', 'Bagok Panah Dua', 4),
	('1103012038', '110301', 'Bagok Panah Lhee', 4),
	('1103012039', '110301', 'Bagok Panah Peut', 4),
	('1103012040', '110301', 'Buket Tualang', 4),
	('1103012041', '110301', 'Keumuneng Sa', 4),
	('1103012042', '110301', 'Keumuneng Dua', 4),
	('1103012043', '110301', 'Keumuneng Lhee', 4),
	('1103012044', '110301', 'Keumuneng Peut', 4),
	('1103012045', '110301', 'Keumuneng Limong', 4),
	('1103012046', '110301', 'Meunasah Blang', 4),
	('1103022001', '110302', 'Blang Keumahang', 4),
	('1103022002', '110302', 'Blang Jambee', 4),
	('1103022003', '110302', 'Keumuneng', 4),
	('1103022004', '110302', 'Ladang Baro', 4),
	('1103022005', '110302', 'Buket Panyang', 4),
	('1103022006', '110302', 'Seuneubok Rambong', 4),
	('1103022007', '110302', 'Seuneubok Baro', 4),
	('1103022008', '110302', 'Blang Mideun', 4),
	('1103022009', '110302', 'Paya Bakong', 4),
	('1103022010', '110302', 'Teupin Raya', 4),
	('1103022011', '110302', 'Lhok Rambong', 4),
	('1103022012', '110302', 'Julok Tunong', 4),
	('1103022013', '110302', 'Ulee Ateung', 4),
	('1103022014', '110302', 'Ulee Blang', 4),
	('1103022015', '110302', 'Labuhan', 4),
	('1103022016', '110302', 'Naleung', 4),
	('1103022017', '110302', 'Mane Rampak', 4),
	('1103022018', '110302', 'Matang', 4),
	('1103022019', '110302', 'Blang Uyok', 4),
	('1103022020', '110302', 'Blang Pauh Sa', 4),
	('1103022021', '110302', 'Blang Pauh Dua', 4),
	('1103022022', '110302', 'Ulee Tanoh', 4),
	('1103022023', '110302', 'Keude Kuta Binjei', 4),
	('1103022024', '110302', 'Buket Seuraja', 4),
	('1103022025', '110302', 'Kuala Geulumpang', 4),
	('1103022026', '110302', 'Gampong Baro', 4),
	('1103022027', '110302', 'Tumpok Teungoh', 4),
	('1103022028', '110302', 'Seumatang', 4),
	('1103022029', '110302', 'Ujong Tunong', 4),
	('1103022030', '110302', 'Bukit Dindeng', 4),
	('1103022031', '110302', 'Paya Pasi', 4),
	('1103022032', '110302', 'Alue Cek Doi', 4),
	('1103022033', '110302', 'Blang Gleum', 4),
	('1103022034', '110302', 'Tanjong Tok Blang', 4),
	('1103022035', '110302', 'Buket Makmu', 4),
	('1103022036', '110302', 'Lhok Seuntang', 4),
	('1103022037', '110302', 'Simpang Lhee', 4),
	('1103032001', '110303', 'Gampong Jawa', 4),
	('1103032002', '110303', 'Keude Blang', 4),
	('1103032003', '110303', 'Tanoh Anoe', 4),
	('1103032004', '110303', 'Kuala Peudawa Puntong', 4),
	('1103032005', '110303', 'Gampong Aceh', 4),
	('1103032006', '110303', 'Kuta Blang', 4),
	('1103032007', '110303', 'Gampong Tanjong', 4),
	('1103032008', '110303', 'Blang Geulumpang', 4),
	('1103032009', '110303', 'Meunasah Pu\'uk', 4),
	('1103032010', '110303', 'Bantayan Timu', 4),
	('1103032011', '110303', 'Keutapang Mameh', 4),
	('1103032012', '110303', 'Seuneubok Rambong', 4),
	('1103032013', '110303', 'Kuala Idi', 4),
	('1103032014', '110303', 'Keude Aceh', 4),
	('1103032023', '110303', 'Seuneubok Bacee', 4),
	('1103032029', '110303', 'Titi Baro', 4),
	('1103032047', '110303', 'Tanjong Kapai', 4),
	('1103032048', '110303', 'Alue Dua Muka O', 4),
	('1103032049', '110303', 'Alue Dua Muka S', 4),
	('1103032050', '110303', 'Ulee Blang', 4),
	('1103032051', '110303', 'Buket Jok', 4),
	('1103032052', '110303', 'Buket Meulinteung', 4),
	('1103032053', '110303', 'Gampong Jalan', 4),
	('1103032054', '110303', 'Teupin Batee', 4),
	('1103032055', '110303', 'Buket Langa', 4),
	('1103032056', '110303', 'Buket Pala', 4),
	('1103032057', '110303', 'Buket Juara', 4),
	('1103032058', '110303', 'Seuneubok Tutong', 4),
	('1103032059', '110303', 'Seuneubok Tuha', 4),
	('1103032060', '110303', 'Sampoimah', 4),
	('1103032061', '110303', 'Dama pulo', 4),
	('1103032062', '110303', 'Gureb Blang', 4),
	('1103032064', '110303', 'Gampong Baro', 4),
	('1103032065', '110303', 'SeunebokTeungoh P Puntong', 4),
	('1103032067', '110303', 'Kuta Lawah', 4),
	('1103042001', '110304', 'Jambo Labu', 4),
	('1103042002', '110304', 'Alue Canang', 4),
	('1103042003', '110304', 'Alue Drien', 4),
	('1103042004', '110304', 'Buket Tiga', 4),
	('1103042005', '110304', 'Benteng', 4),
	('1103042006', '110304', 'Afdeling II Bukit', 4),
	('1103042007', '110304', 'Keumuneng Hulu', 4),
	('1103042008', '110304', 'Peutow', 4),
	('1103042009', '110304', 'Alue Buloh', 4),
	('1103042010', '110304', 'Alue Teh', 4),
	('1103042011', '110304', 'Paya Rambong', 4),
	('1103042012', '110304', 'Alue Gadeng SA', 4),
	('1103042013', '110304', 'Paya Tampah', 4),
	('1103042014', '110304', 'Paya Bili Dua', 4),
	('1103042015', '110304', 'Paya Bili Sa', 4),
	('1103042016', '110304', 'Paya Peulawi', 4),
	('1103042017', '110304', 'Keude Birem', 4),
	('1103042018', '110304', 'Bayeun', 4),
	('1103042019', '110304', 'Aramiyah', 4),
	('1103042020', '110304', 'Blang Tualang', 4),
	('1103042021', '110304', 'Buket Seuleumak', 4),
	('1103042022', '110304', 'Birem Rayeuk', 4),
	('1103042023', '110304', 'Alue Gadeng GP', 4),
	('1103042024', '110304', 'Alue Gadeng II', 4),
	('1103042025', '110304', 'Alue Sentang', 4),
	('1103042026', '110304', 'Merbou Dua', 4),
	('1103042027', '110304', 'Alue Nyamuk', 4),
	('1103052001', '110305', 'Lokop', 4),
	('1103052002', '110305', 'Terujak', 4),
	('1103052003', '110305', 'Tualang', 4),
	('1103052004', '110305', 'Leles', 4),
	('1103052005', '110305', 'Ujung Karang', 4),
	('1103052006', '110305', 'Nalon', 4),
	('1103052007', '110305', 'Jering', 4),
	('1103052008', '110305', 'Loot', 4),
	('1103052009', '110305', 'Sekualan', 4),
	('1103052010', '110305', 'Sunti', 4),
	('1103052011', '110305', 'Umah Taring', 4),
	('1103052012', '110305', 'Bunin', 4),
	('1103052013', '110305', 'Sembuang', 4),
	('1103052014', '110305', 'Seuleumak', 4),
	('1103052015', '110305', 'Mesir', 4),
	('1103052016', '110305', 'Rampah', 4),
	('1103052022', '110305', 'Arul Durin', 4),
	('1103062001', '110306', 'Keude Bagok Sa', 4),
	('1103062002', '110306', 'Gampong Keude Bagok Dua', 4),
	('1103062003', '110306', 'Asan Tanjong', 4),
	('1103062004', '110306', 'Bantayan', 4),
	('1103062005', '110306', 'Matang Seuleumak', 4),
	('1103062006', '110306', 'Teupin Pukat', 4),
	('1103062007', '110306', 'Matang Neuheun', 4),
	('1103062008', '110306', 'Kuala Bagok', 4),
	('1103062009', '110306', 'Meunasah Teungoh', 4),
	('1103062010', '110306', 'Medang Ara', 4),
	('1103062011', '110306', 'Peulawi', 4),
	('1103062012', '110306', 'Baroh Bugeng', 4),
	('1103062013', '110306', 'Seumatang Aron', 4),
	('1103062014', '110306', 'Blang Panjou', 4),
	('1103062025', '110306', 'Pulo U', 4),
	('1103062026', '110306', 'Cot Asan', 4),
	('1103062027', '110306', 'Paya Enjee', 4),
	('1103062028', '110306', 'Seuleumak Muda', 4),
	('1103062029', '110306', 'Matang Panyang', 4),
	('1103062030', '110306', 'Meunasah Hagu', 4),
	('1103062031', '110306', 'Matang Kunyet', 4),
	('1103062032', '110306', 'Buket Panjou', 4),
	('1103062033', '110306', 'Buket Meurak', 4),
	('1103062034', '110306', 'Buket Panyang', 4),
	('1103062035', '110306', 'Seuneubok Dalam', 4),
	('1103062036', '110306', 'Gampong Mesjid', 4),
	('1103062037', '110306', 'Alue Siwah Serdang', 4),
	('1103062038', '110306', 'Gampong Lhee', 4),
	('1103062039', '110306', 'Beurandang', 4),
	('1103062040', '110306', 'Gampong Jalan', 4),
	('1103062041', '110306', 'Seuneubok Rambong', 4),
	('1103072001', '110307', 'Pasir Putih', 4),
	('1103072002', '110307', 'Tualang', 4),
	('1103072003', '110307', 'Keude Peureulak', 4),
	('1103072004', '110307', 'Leuge', 4),
	('1103072005', '110307', 'Uteun Dama', 4),
	('1103072006', '110307', 'Punti', 4),
	('1103072007', '110307', 'Alue Dua Paya Gajah', 4),
	('1103072008', '110307', 'Blang Bitra', 4),
	('1103072009', '110307', 'Kuala Bugak', 4),
	('1103072010', '110307', 'Paya Lipah', 4),
	('1103072011', '110307', 'Seumatang Muda Itam', 4),
	('1103072012', '110307', 'Lhok Dalam', 4),
	('1103072013', '110307', 'Beusa Meuranoe', 4),
	('1103072014', '110307', 'Bangka Rimung', 4),
	('1103072015', '110307', 'Tanoh Rata', 4),
	('1103072016', '110307', 'Bandrong', 4),
	('1103072017', '110307', 'Blang Balok', 4),
	('1103072018', '110307', 'Cot Muda Itam', 4),
	('1103072019', '110307', 'Keumuneng', 4),
	('1103072020', '110307', 'Kuala Leuge', 4),
	('1103072021', '110307', 'Balee Buya', 4),
	('1103072022', '110307', 'Alue Nibong', 4),
	('1103072023', '110307', 'Seuneubok Peusangan', 4),
	('1103072024', '110307', 'Seuneubok Aceh', 4),
	('1103072025', '110307', 'Seuneubok Pidie', 4),
	('1103072026', '110307', 'Dama Tutong', 4),
	('1103072027', '110307', 'Matang Gleum', 4),
	('1103072028', '110307', 'Lubok Pempeng', 4),
	('1103072029', '110307', 'Buket Pala', 4),
	('1103072030', '110307', 'Paya Kalui', 4),
	('1103072031', '110307', 'Cek Mbon', 4),
	('1103072032', '110307', 'Paya Meuligou', 4),
	('1103072033', '110307', 'Blang Simpo', 4),
	('1103072034', '110307', 'Blang Batee', 4),
	('1103072035', '110307', 'Matang Pelawi', 4),
	('1103072036', '110307', 'Cot Geulumpang', 4),
	('1103072037', '110307', 'Alue Rambong', 4),
	('1103072038', '110307', 'Cot Keh', 4),
	('1103082001', '110308', 'Bayeun', 4),
	('1103082002', '110308', 'Rantau Panjang', 4),
	('1103082003', '110308', 'Alue Raya', 4),
	('1103082004', '110308', 'Alue Kumba', 4),
	('1103082005', '110308', 'Seuneubok Dalam', 4),
	('1103082006', '110308', 'Alue Seuleumak', 4),
	('1103082007', '110308', 'Sarah Kayee', 4),
	('1103082008', '110308', 'Damar Siput', 4),
	('1103082009', '110308', 'Simpang Peut', 4),
	('1103082010', '110308', 'Simpang Aneuh', 4),
	('1103082011', '110308', 'Alue Punti', 4),
	('1103082012', '110308', 'Alue Kaul', 4),
	('1103082013', '110308', 'Sarah Taube', 4),
	('1103082014', '110308', 'Alue Tuwi', 4),
	('1103092001', '110309', 'Peulalu', 4),
	('1103092002', '110309', 'Nicah Awe', 4),
	('1103092003', '110309', 'Alue Buloh Sa', 4),
	('1103092004', '110309', 'Alue Buloh Dua', 4),
	('1103092005', '110309', 'Teupin Breuh', 4),
	('1103092006', '110309', 'Matang Rayeuk', 4),
	('1103092007', '110309', 'Matang Kumbang', 4),
	('1103092008', '110309', 'Blang Nie', 4),
	('1103092010', '110309', 'Bantayan', 4),
	('1103092011', '110309', 'Matang Weng', 4),
	('1103092012', '110309', 'Alue Mulieng', 4),
	('1103092013', '110309', 'Pucok Alue II', 4),
	('1103092014', '110309', 'Gampong Blang', 4),
	('1103092015', '110309', 'Keude Tuha', 4),
	('1103092016', '110309', 'Kuala Simpang Ulim', 4),
	('1103092017', '110309', 'Lampoh Rayeuk', 4),
	('1103092018', '110309', 'Teupin Mamplam', 4),
	('1103092019', '110309', 'Titi Bareuh', 4),
	('1103092020', '110309', 'Pucok Alue Sa', 4),
	('1103092021', '110309', 'Pucok Alue Barat', 4),
	('1103092022', '110309', 'Arakundo', 4),
	('1103092023', '110309', 'Gampong Baro', 4),
	('1103092024', '110309', 'Matang Seupeng', 4),
	('1103102001', '110310', 'Paya Unou', 4),
	('1103102002', '110310', 'Seuneubok Johan', 4),
	('1103102003', '110310', 'Seuneubok Baro', 4),
	('1103102004', '110310', 'Pulo Blang', 4),
	('1103102005', '110310', 'Blang Barom', 4),
	('1103102006', '110310', 'Seuneubok Dalam', 4),
	('1103102007', '110310', 'Seuleumak Muda', 4),
	('1103102008', '110310', 'Bhom Lama', 4),
	('1103102009', '110310', 'Pasi Puteh', 4),
	('1103102010', '110310', 'Alue Dua', 4),
	('1103102011', '110310', 'Buket Pala', 4),
	('1103102012', '110310', 'Mata Ie', 4),
	('1103102013', '110310', 'Alue Udep', 4),
	('1103102014', '110310', 'Seumali', 4),
	('1103102015', '110310', 'Punti Payong', 4),
	('1103102016', '110310', 'Paya Palas', 4),
	('1103102017', '110310', 'Tampak', 4),
	('1103102018', '110310', 'Kliet', 4),
	('1103102019', '110310', 'Alue Geunteng', 4),
	('1103102020', '110310', 'Pertamina', 4),
	('1103102021', '110310', 'Alue Batee', 4),
	('1103102022', '110310', 'Beurandang', 4),
	('1103102024', '110310', 'Seumanah Jaya', 4),
	('1103112001', '110311', 'Blang Seunong', 4),
	('1103112002', '110311', 'Suka Damai', 4),
	('1103112003', '110311', 'Pante Labu', 4),
	('1103112004', '110311', 'Pante Rambong', 4),
	('1103112005', '110311', 'Alue Ie Mirah', 4),
	('1103112006', '110311', 'Seuneubok Tuha', 4),
	('1103112007', '110311', 'Seuneubok Saboh', 4),
	('1103112008', '110311', 'Buket Kareung', 4),
	('1103112009', '110311', 'Buket Bata', 4),
	('1103112010', '110311', 'Meunasah Tunong', 4),
	('1103112011', '110311', 'Meunasah Teungoh', 4),
	('1103112012', '110311', 'Keude Baro', 4),
	('1103112013', '110311', 'Matang Perlak', 4),
	('1103112014', '110311', 'Grong-grong', 4),
	('1103112015', '110311', 'Matang Kruet', 4),
	('1103112016', '110311', 'Meunasah Leubok', 4),
	('1103112017', '110311', 'Pante Panah', 4),
	('1103112018', '110311', 'Paya Demam Sa', 4),
	('1103112019', '110311', 'Paya Demam Dua', 4),
	('1103112020', '110311', 'Paya Demam Lhee', 4),
	('1103112021', '110311', 'Matang Pudeng', 4),
	('1103112022', '110311', 'Putoh Sa', 4),
	('1103112023', '110311', 'Putoh Dua', 4),
	('1103112024', '110311', 'Sah Raja', 4),
	('1103112025', '110311', 'Sijudo', 4),
	('1103122001', '110312', 'Madat', 4),
	('1103122002', '110312', 'Matang Kupula Sa', 4),
	('1103122003', '110312', 'Matang Kupula Dua', 4),
	('1103122004', '110312', 'Matang Keupula Lhee', 4),
	('1103122005', '110312', 'Ulee Ateung', 4),
	('1103122006', '110312', 'Blang Ubit', 4),
	('1103122007', '110312', 'Matang Guru', 4),
	('1103122008', '110312', 'Pantee Bayam', 4),
	('1103122009', '110312', 'Meunasah Asan', 4),
	('1103122010', '110312', 'Meunasah Tingkeum', 4),
	('1103122011', '110312', 'Lueng Dua', 4),
	('1103122012', '110312', 'Lueng Peut', 4),
	('1103122013', '110312', 'Paya Demam Peut', 4),
	('1103122014', '110312', 'Abeuk Geulanteu', 4),
	('1103122015', '110312', 'Rambong Lop', 4),
	('1103122016', '110312', 'Tanjong Ara', 4),
	('1103122017', '110312', 'Matang Jrok', 4),
	('1103122018', '110312', 'Paya Naden', 4),
	('1103122019', '110312', 'Tanjong Minjey', 4),
	('1103122020', '110312', 'Pante Merbo', 4),
	('1103122021', '110312', 'Blang Awe', 4),
	('1103122022', '110312', 'Bintah', 4),
	('1103122023', '110312', 'Seuneubok Pidie', 4),
	('1103122024', '110312', 'Blang Andam', 4),
	('1103122025', '110312', 'Matang Nibong', 4),
	('1103122026', '110312', 'Lueng Sa', 4),
	('1103132001', '110313', 'Seuneubok Bayu', 4),
	('1103132002', '110313', 'Alue Ie Itam', 4),
	('1103132003', '110313', 'Blang Nisan', 4),
	('1103132004', '110313', 'Bandar Baro', 4),
	('1103132005', '110313', 'Alue Patong', 4),
	('1103132006', '110313', 'Alue Ie Mirah', 4),
	('1103132007', '110313', 'Suka Makmur', 4),
	('1103132008', '110313', 'Jambo Balee', 4),
	('1103132009', '110313', 'Jambo Lubok', 4),
	('1103132010', '110313', 'Seuneubok Cina', 4),
	('1103132011', '110313', 'Pelita Sagop Jaya', 4),
	('1103132012', '110313', 'Perkebunan Julok Rayeuk Selatan', 4),
	('1103132013', '110313', 'Perkebunan Julok Rayeuk Utara', 4),
	('1103142001', '110314', 'Seuneubok Buloh', 4),
	('1103142002', '110314', 'Seuneubok Baro', 4),
	('1103142003', '110314', 'Seuneubok Meureudu', 4),
	('1103142004', '110314', 'Seuneubok Teupin Panah', 4),
	('1103142005', '110314', 'Gampong Teupin Panah', 4),
	('1103142006', '110314', 'Gampong Keumuneng', 4),
	('1103142007', '110314', 'Keude Keumuneng', 4),
	('1103142008', '110314', 'Keumuneng Lhok', 4),
	('1103142009', '110314', 'Paya Awee', 4),
	('1103142010', '110314', 'Paya Gaboh', 4),
	('1103142011', '110314', 'Padang Kasah', 4),
	('1103142012', '110314', 'Buket Teukuh', 4),
	('1103142013', '110314', 'Buket Pu\'uk', 4),
	('1103142014', '110314', 'Blang Minjei', 4),
	('1103142015', '110314', 'Alue Kumbang A', 4),
	('1103142016', '110314', 'Alue Kumbang M', 4),
	('1103142017', '110314', 'Alue Lhok', 4),
	('1103142018', '110314', 'Seuneubok Buya', 4),
	('1103142019', '110314', 'Seuneubok Drien', 4),
	('1103142020', '110314', 'Bantayan Barat', 4),
	('1103142021', '110314', 'Blang Guci', 4),
	('1103142022', '110314', 'Buket Rumiya', 4),
	('1103142023', '110314', 'Seuneubok Punti', 4),
	('1103142024', '110314', 'Seuneubok Jalan', 4),
	('1103142025', '110314', 'Seuneubok Dalam', 4),
	('1103152001', '110315', 'Jalan Dua', 4),
	('1103152002', '110315', 'Jambo Reuhat', 4),
	('1103152003', '110315', 'Seuneubok Benteng', 4),
	('1103152004', '110315', 'Seuneubok Pango', 4),
	('1103152005', '110315', 'Seuneubok Simpang', 4),
	('1103152006', '110315', 'Seuneubok Kandang', 4),
	('1103152007', '110315', 'Ulee Jalan', 4),
	('1103152008', '110315', 'Uram Jalan', 4),
	('1103152009', '110315', 'Seuneubok Bayu', 4),
	('1103152010', '110315', 'Blang Rambong', 4),
	('1103152011', '110315', 'Buket Drien', 4),
	('1103152012', '110315', 'Panton Rayeuk A', 4),
	('1103152013', '110315', 'Panton Rayeuk B', 4),
	('1103152014', '110315', 'Panton Rayeuk M', 4),
	('1103152015', '110315', 'Panton Rayeuk T', 4),
	('1103152016', '110315', 'Paya Laman', 4),
	('1103162001', '110316', 'Gampong Keude', 4),
	('1103162002', '110316', 'Meunasah Krueng', 4),
	('1103162003', '110316', 'Kuta Baro', 4),
	('1103162004', '110316', 'Alue Batee', 4),
	('1103162005', '110316', 'Matang Rayeuk', 4),
	('1103162006', '110316', 'Paya Bili Dua', 4),
	('1103162007', '110316', 'Alue Ie Itam', 4),
	('1103162008', '110316', 'Asan Rampak', 4),
	('1103162009', '110316', 'Gampong Kuala', 4),
	('1103162010', '110316', 'Paya Dua', 4),
	('1103162011', '110316', 'Seuneubok Teungoh', 4),
	('1103162012', '110316', 'Buket Kuta', 4),
	('1103162013', '110316', 'Sama Dua', 4),
	('1103162014', '110316', 'Blang Kuta', 4),
	('1103162015', '110316', 'Blang Buket', 4),
	('1103162016', '110316', 'Seuneubok Peunteut', 4),
	('1103162017', '110316', 'Paya Bili Sa', 4),
	('1103172001', '110317', 'Babah Krueng', 4),
	('1103172002', '110317', 'Kruet Lintang', 4),
	('1103172003', '110317', 'Jeungki', 4),
	('1103172004', '110317', 'Buket Meriam', 4),
	('1103172005', '110317', 'Alue Gureb', 4),
	('1103172006', '110317', 'Seuneubok Teupin', 4),
	('1103172007', '110317', 'Seuneubok Teungoh', 4),
	('1103172008', '110317', 'Alue Bugeng', 4),
	('1103172009', '110317', 'Seuneubok Punti', 4),
	('1103172010', '110317', 'Seumatang Keude', 4),
	('1103172011', '110317', 'Seuneubok Jalan', 4),
	('1103172012', '110317', 'Seuneubok Paya', 4),
	('1103172013', '110317', 'Alue Tho', 4),
	('1103172014', '110317', 'Seuneubok Rawang', 4),
	('1103172015', '110317', 'Alue Bu Alue Nireh', 4),
	('1103172016', '110317', 'Seuneubok Dalam', 4),
	('1103172017', '110317', 'Seuneubok Lapang', 4),
	('1103172018', '110317', 'Geulanggang Meurak', 4),
	('1103172019', '110317', 'Alue Bu Alue Lhok', 4),
	('1103172020', '110317', 'Tualang Pateng', 4),
	('1103182001', '110318', 'Beusa Seberang', 4),
	('1103182002', '110318', 'Mon Geudong', 4),
	('1103182003', '110318', 'Paya Seungat', 4),
	('1103182004', '110318', 'Teumpeun', 4),
	('1103182005', '110318', 'Alue Bu Tuha', 4),
	('1103182006', '110318', 'Alue Bu Jalan', 4),
	('1103182007', '110318', 'Tanjong Tualang', 4),
	('1103182008', '110318', 'Beringen', 4),
	('1103182009', '110318', 'Kebon Tempeun', 4),
	('1103182010', '110318', 'Paya Gajah', 4),
	('1103182011', '110318', 'Kabu', 4),
	('1103182012', '110318', 'Paya Biek', 4),
	('1103182013', '110318', 'Beusa Baroh', 4),
	('1103182014', '110318', 'Alue Bu Jalan Baroh', 4),
	('1103182015', '110318', 'Alue Bu Tunong', 4),
	('1103192001', '110319', 'Alue Rangan', 4),
	('1103192002', '110319', 'Geulumpang Payong', 4),
	('1103192003', '110319', 'Labuhan Keudee', 4),
	('1103192004', '110319', 'Buket Seulamat', 4),
	('1103192005', '110319', 'Buket Drien', 4),
	('1103192006', '110319', 'Alue Itam', 4),
	('1103192007', '110319', 'Paya Keutapang', 4),
	('1103192008', '110319', 'Gajah Mentah', 4),
	('1103192009', '110319', 'Seuneubok Pase', 4),
	('1103192010', '110319', 'Seuneubok Aceh', 4),
	('1103192011', '110319', 'Krueng Lingka', 4),
	('1103192012', '110319', 'Sungai Simpang', 4),
	('1103192013', '110319', 'Kuala Parek', 4),
	('1103202001', '110320', 'Simpang Jernih', 4),
	('1103202002', '110320', 'Batu Sumbang', 4),
	('1103202003', '110320', 'Pante Kera', 4),
	('1103202004', '110320', 'Rantau Panjang', 4),
	('1103202005', '110320', 'Melidi', 4),
	('1103202006', '110320', 'Tampur Paloh', 4),
	('1103202007', '110320', 'Tampur Boor', 4),
	('1103202008', '110320', 'HTI Rantau Naro', 4),
	('1103212001', '110321', 'Meudang Ara', 4),
	('1103212002', '110321', 'Gunong Putoh', 4),
	('1103212003', '110321', 'Meunasah Aroen', 4),
	('1103212004', '110321', 'Keude Dua', 4),
	('1103212005', '110321', 'Seuneubok Lapang', 4),
	('1103212006', '110321', 'Alue Jangat', 4),
	('1103212007', '110321', 'Buket Peulawi', 4),
	('1103212008', '110321', 'Lhok Panjoe', 4),
	('1103212009', '110321', 'Seuneubok Aceh Baro', 4),
	('1103212010', '110321', 'Pulo Blang', 4),
	('1103212011', '110321', 'Lhok Dalam', 4),
	('1103212012', '110321', 'Lhok Leumak', 4),
	('1103212013', '110321', 'Seuneubok Kulam', 4),
	('1103212014', '110321', 'Panton Meurebo', 4),
	('1103212015', '110321', 'Seuneubok Teungoh', 4),
	('1103212016', '110321', 'Lhok Meureu', 4),
	('1103222001', '110322', 'Tunong Bugeng', 4),
	('1103222002', '110322', 'Cempeudak', 4),
	('1103222003', '110322', 'Buket Tufah', 4),
	('1103222004', '110322', 'Tunong Ulee Gajah', 4),
	('1103222005', '110322', 'Keudondong', 4),
	('1103222006', '110322', 'Seuneubok Panton', 4),
	('1103222007', '110322', 'Buket Teumpeun', 4),
	('1103222008', '110322', 'Keude Blang', 4),
	('1103222009', '110322', 'Paya Kruep', 4),
	('1103222010', '110322', 'Tunong Paya Kruep', 4),
	('1103222011', '110322', 'Alue Siwah', 4),
	('1103232001', '110323', 'Keutapang Dua', 4),
	('1103232002', '110323', 'Matang Reyeuk PP', 4),
	('1103232003', '110323', 'Meunasah Jeumpa', 4),
	('1103232004', '110323', 'Lhok Asahan', 4),
	('1103232005', '110323', 'Tualang Dalam', 4),
	('1103232006', '110323', 'Seuneubok Kuyun', 4),
	('1103232007', '110323', 'Ulee Glee', 4),
	('1103232008', '110323', 'Seuneubok Barat', 4),
	('1103232009', '110323', 'Seuneubok Teungoh', 4),
	('1103232010', '110323', 'Seuneubok Timur', 4),
	('1103232011', '110323', 'Matang Bungong', 4),
	('1103232012', '110323', 'Matang Rayeuk (SMK)', 4),
	('1103232013', '110323', 'Seuneubok Dalam', 4),
	('1103242001', '110324', 'Arul Pinang', 4),
	('1103242002', '110324', 'Peunaron Baru', 4),
	('1103242003', '110324', 'Peunaron Lama', 4),
	('1103242004', '110324', 'Bukit Tiga', 4),
	('1103242006', '110324', 'Sri Mulya', 4),
	('1104012003', '110401', 'Delung Sekinel', 4),
	('1104012005', '110401', 'Gelampang Gading', 4),
	('1104012006', '110401', 'Gewat', 4),
	('1104012008', '110401', 'Jamat', 4),
	('1104012009', '110401', 'Kemerleng', 4),
	('1104012010', '110401', 'Kute Baru', 4),
	('1104012011', '110401', 'Kute Keramil', 4),
	('1104012012', '110401', 'Kute Rayang', 4),
	('1104012013', '110401', 'Kute Riyem', 4),
	('1104012014', '110401', 'Kute Robel', 4),
	('1104012015', '110401', 'Linge', 4),
	('1104012016', '110401', 'Lumut', 4),
	('1104012018', '110401', 'Mungkur', 4),
	('1104012019', '110401', 'Owaq', 4),
	('1104012020', '110401', 'Pantan Nangka', 4),
	('1104012021', '110401', 'Penarun', 4),
	('1104012022', '110401', 'Simpang Tige Uning', 4),
	('1104012023', '110401', 'Umang', 4),
	('1104012024', '110401', 'Despot Linge', 4),
	('1104012025', '110401', 'Gemboyah', 4),
	('1104012031', '110401', 'Arul Item', 4),
	('1104012032', '110401', 'Ise-Ise', 4),
	('1104012033', '110401', 'Kute Reje', 4),
	('1104012034', '110401', 'Reje Payung', 4),
	('1104012035', '110401', 'Pantan Reduk', 4),
	('1104012036', '110401', 'Antara', 4),
	('1104022001', '110402', 'Arul Gele', 4),
	('1104022002', '110402', 'Arul Kumer', 4),
	('1104022003', '110402', 'Burni Bius', 4),
	('1104022004', '110402', 'Genting Gerbang', 4),
	('1104022005', '110402', 'Gunung Singit', 4),
	('1104022007', '110402', 'Pepayungan Angkup', 4),
	('1104022008', '110402', 'Remesen', 4),
	('1104022009', '110402', 'Rutih', 4),
	('1104022010', '110402', 'Mutiara', 4),
	('1104022012', '110402', 'Wih Porak', 4),
	('1104022013', '110402', 'Wihni Nibakong', 4),
	('1104022014', '110402', 'Wihni Durin', 4),
	('1104022016', '110402', 'Arul Putih', 4),
	('1104022017', '110402', 'Arul Relem', 4),
	('1104022018', '110402', 'Burni Bius Baru', 4),
	('1104022019', '110402', 'Jerata', 4),
	('1104022022', '110402', 'Paya Beke', 4),
	('1104022023', '110402', 'Paya Pelu', 4),
	('1104022026', '110402', 'Rebe Gedung', 4),
	('1104022027', '110402', 'Reremal', 4),
	('1104022029', '110402', 'Senehen', 4),
	('1104022030', '110402', 'Simpang Kemili', 4),
	('1104022031', '110402', 'Tenebuk Kampung Baru', 4),
	('1104022032', '110402', 'Terang Engon', 4),
	('1104022033', '110402', 'Wih Pesam', 4),
	('1104022034', '110402', 'Bius Utama', 4),
	('1104022035', '110402', 'Meker Indah', 4),
	('1104022036', '110402', 'Mulie Jadi', 4),
	('1104022037', '110402', 'Wihbersih', 4),
	('1104022038', '110402', 'Wih Sagi Indah', 4),
	('1104022039', '110402', 'Arul Kumer Barat', 4),
	('1104022040', '110402', 'Arul Kumer Timur', 4),
	('1104022041', '110402', 'Arul Kumer Selatan', 4),
	('1104032001', '110403', 'Blang Kolak I', 4),
	('1104032002', '110403', 'Bebesan', 4),
	('1104032003', '110403', 'Mongal', 4),
	('1104032004', '110403', 'Daling', 4),
	('1104032005', '110403', 'Tensaren', 4),
	('1104032006', '110403', 'Lelabu', 4),
	('1104032007', '110403', 'Blang Gele', 4),
	('1104032008', '110403', 'Kemili', 4),
	('1104032009', '110403', 'Tan Saril', 4),
	('1104032010', '110403', 'Blang Kolak II', 4),
	('1104032011', '110403', 'Umang', 4),
	('1104032012', '110403', 'Simpang IV', 4),
	('1104032013', '110403', 'Bahgie', 4),
	('1104032014', '110403', 'Keramat Mufakat', 4),
	('1104032015', '110403', 'Atu Gajah Reje Guru', 4),
	('1104032016', '110403', 'Atu Tulu', 4),
	('1104032017', '110403', 'Burbiah', 4),
	('1104032018', '110403', 'Empus Talu', 4),
	('1104032019', '110403', 'Gele Lah', 4),
	('1104032020', '110403', 'Kebet', 4),
	('1104032021', '110403', 'Lemah Burbana', 4),
	('1104032022', '110403', 'Mah Bengi', 4),
	('1104032023', '110403', 'Nunang Antara', 4),
	('1104032024', '110403', 'Pendere Saril', 4),
	('1104032025', '110403', 'Sadong Juru Mudi', 4),
	('1104032026', '110403', 'Ulu Nuwih', 4),
	('1104032027', '110403', 'Colo Blang Gele', 4),
	('1104032028', '110403', 'Kala Kemili', 4),
	('1104072001', '110407', 'Arul Badak', 4),
	('1104072004', '110407', 'Berawang Baro', 4),
	('1104072008', '110407', 'Gelelungi', 4),
	('1104072009', '110407', 'Ie Relop', 4),
	('1104072010', '110407', 'Kayu Kul', 4),
	('1104072011', '110407', 'Kedelah', 4),
	('1104072012', '110407', 'Kung', 4),
	('1104072013', '110407', 'Kute Lintang', 4),
	('1104072014', '110407', 'Lelumu', 4),
	('1104072016', '110407', 'Paya Jeget', 4),
	('1104072017', '110407', 'Pedekok', 4),
	('1104072018', '110407', 'Pegasing', 4),
	('1104072019', '110407', 'Pepalang', 4),
	('1104072021', '110407', 'Simpang Kelaping', 4),
	('1104072024', '110407', 'Tebuk', 4),
	('1104072025', '110407', 'Terang Ulen', 4),
	('1104072026', '110407', 'Ujung Gele', 4),
	('1104072029', '110407', 'Wih Ilang', 4),
	('1104072030', '110407', 'Wih Nareh', 4),
	('1104072031', '110407', 'Wih Lah', 4),
	('1104072032', '110407', 'Jejen', 4),
	('1104072033', '110407', 'Jurusen', 4),
	('1104072034', '110407', 'Kala Pegasing', 4),
	('1104072035', '110407', 'Linu Ayu', 4),
	('1104072036', '110407', 'Panangan Mata', 4),
	('1104072037', '110407', 'Pantan Musara', 4),
	('1104072038', '110407', 'Wihterjun', 4),
	('1104072039', '110407', 'Blang Bebangka', 4),
	('1104072040', '110407', 'Uning', 4),
	('1104072041', '110407', 'Uring', 4),
	('1104072042', '110407', 'Suka Damai', 4),
	('1104082001', '110408', 'Atu Payung', 4),
	('1104082002', '110408', 'Bale Nosar', 4),
	('1104082003', '110408', 'Bamil Nosar', 4),
	('1104082004', '110408', 'Bewang', 4),
	('1104082005', '110408', 'Dedamar', 4),
	('1104082006', '110408', 'Genuren', 4),
	('1104082007', '110408', 'Kala Bintang', 4),
	('1104082008', '110408', 'Kala Segi', 4),
	('1104082009', '110408', 'Kejurun Syiah Utama', 4),
	('1104082010', '110408', 'Kelitu Sintep', 4),
	('1104082011', '110408', 'Kuala I', 4),
	('1104082012', '110408', 'Kuala II', 4),
	('1104082013', '110408', 'Linung Bulen I', 4),
	('1104082014', '110408', 'Linung Bulen II', 4),
	('1104082015', '110408', 'Mengaya', 4),
	('1104082016', '110408', 'Mude Nosar', 4),
	('1104082017', '110408', 'Serule', 4),
	('1104082018', '110408', 'Wakil Jalil', 4),
	('1104082019', '110408', 'Wihlah Setie', 4),
	('1104082020', '110408', 'Gegarang', 4),
	('1104082021', '110408', 'Jamur Konyel', 4),
	('1104082022', '110408', 'Merodot', 4),
	('1104082023', '110408', 'Sintep', 4),
	('1104082024', '110408', 'Gele Pulo', 4),
	('1104102001', '110410', 'Bah', 4),
	('1104102002', '110410', 'Belang Mancung', 4),
	('1104102003', '110410', 'Bintang Pepara', 4),
	('1104102004', '110410', 'Burlah', 4),
	('1104102005', '110410', 'Buter', 4),
	('1104102006', '110410', 'Cang Duri', 4),
	('1104102007', '110410', 'Geulumpang Payung', 4),
	('1104102008', '110410', 'Jaluk', 4),
	('1104102009', '110410', 'Kala Ketol', 4),
	('1104102010', '110410', 'Karang Ampar', 4),
	('1104102011', '110410', 'Kekuyang', 4),
	('1104102012', '110410', 'Kute Gelime', 4),
	('1104102013', '110410', 'Pantan Penyo', 4),
	('1104102014', '110410', 'Pantan Reduk', 4),
	('1104102015', '110410', 'Pondok Balik', 4),
	('1104102016', '110410', 'Rejewali', 4),
	('1104102017', '110410', 'Serempah', 4),
	('1104102018', '110410', 'Bergang', 4),
	('1104102019', '110410', 'Blang Mancung Bawah', 4),
	('1104102020', '110410', 'Buge Ara', 4),
	('1104102021', '110410', 'Genting Bulen', 4),
	('1104102022', '110410', 'Jalan Tengah', 4),
	('1104102023', '110410', 'Jerata', 4),
	('1104102024', '110410', 'Simpang Juli', 4),
	('1104102025', '110410', 'Selon', 4),
	('1104112001', '110411', 'Bukit Sama', 4),
	('1104112002', '110411', 'Gunung Bukit', 4),
	('1104112003', '110411', 'Jongok Meluem', 4),
	('1104112004', '110411', 'Kelupak Mata', 4),
	('1104112005', '110411', 'Lot Kala', 4),
	('1104112006', '110411', 'Mendale', 4),
	('1104112007', '110411', 'Paya Reje Tami Dalem', 4),
	('1104112008', '110411', 'Paya Tumpi', 4),
	('1104112009', '110411', 'Pinangan', 4),
	('1104112010', '110411', 'Bukit', 4),
	('1104112011', '110411', 'Bukit Iwih Tami Delem', 4),
	('1104112012', '110411', 'Gunung Bahgie', 4),
	('1104112013', '110411', 'Gunung Balohen', 4),
	('1104112014', '110411', 'Jongkok Bathin', 4),
	('1104112015', '110411', 'Kala Lengkio', 4),
	('1104112016', '110411', 'Kute Lot', 4),
	('1104112017', '110411', 'Paya Tumpi Baru', 4),
	('1104112018', '110411', 'Paya Tumpi I', 4),
	('1104112019', '110411', 'Timangan Gading', 4),
	('1104112020', '110411', 'Telege Atu', 4),
	('1104122001', '110412', 'Atu Gogop', 4),
	('1104122002', '110412', 'Balik', 4),
	('1104122003', '110412', 'Buter Balik', 4),
	('1104122004', '110412', 'Dedingin', 4),
	('1104122005', '110412', 'Kute Panang', 4),
	('1104122006', '110412', 'Lukub Sabun', 4),
	('1104122007', '110412', 'Pantan Sile', 4),
	('1104122008', '110412', 'Rata Wali', 4),
	('1104122009', '110412', 'Segene Balik', 4),
	('1104122010', '110412', 'Tapak Moge', 4),
	('1104122011', '110412', 'Tawar Miko', 4),
	('1104122012', '110412', 'Tawardi', 4),
	('1104122013', '110412', 'Timang Rasa', 4),
	('1104122014', '110412', 'Wih Nongkal', 4),
	('1104122015', '110412', 'Bukit Rata', 4),
	('1104122016', '110412', 'Lukub Sabun Barat', 4),
	('1104122017', '110412', 'Lukub Sabun Tengah', 4),
	('1104122018', '110412', 'Lukub Sabun Timur', 4),
	('1104122019', '110412', 'Wih Nongkal Tua', 4),
	('1104122020', '110412', 'Tapak Moge Timur', 4),
	('1104122021', '110412', 'Empu Balik', 4),
	('1104122022', '110412', 'Blang Balik', 4),
	('1104122023', '110412', 'Kala Nongkal', 4),
	('1104122024', '110412', 'Pantan Jerik', 4),
	('1104132001', '110413', 'Arul Gading', 4),
	('1104132002', '110413', 'Belang Kekumur', 4),
	('1104132003', '110413', 'Berawang Gading', 4),
	('1104132004', '110413', 'Celala', 4),
	('1104132005', '110413', 'Cibro', 4),
	('1104132006', '110413', 'Kuyun', 4),
	('1104132007', '110413', 'Kuyun Toa', 4),
	('1104132008', '110413', 'Kuyun Uken', 4),
	('1104132009', '110413', 'Makmur', 4),
	('1104132010', '110413', 'Melala', 4),
	('1104132011', '110413', 'Paya Kolak', 4),
	('1104132012', '110413', 'Ramung Ara', 4),
	('1104132013', '110413', 'Sepakat', 4),
	('1104132014', '110413', 'Tanoh Depet', 4),
	('1104132015', '110413', 'Uning Berawang Ramung', 4),
	('1104132016', '110413', 'Blang Delem', 4),
	('1104132017', '110413', 'Depet Indah', 4),
	('1104172001', '110417', 'Takengon Timur', 4),
	('1104172002', '110417', 'Asir Asir', 4),
	('1104172003', '110417', 'Asir Asir Asia', 4),
	('1104172004', '110417', 'Bale Atu', 4),
	('1104172005', '110417', 'Bujang', 4),
	('1104172006', '110417', 'Gunung Suku', 4),
	('1104172007', '110417', 'Hakim Bale Bujang', 4),
	('1104172008', '110417', 'Kenawat', 4),
	('1104172009', '110417', 'Kuteni Reje', 4),
	('1104172010', '110417', 'Pedemun One One', 4),
	('1104172011', '110417', 'Rawe', 4),
	('1104172012', '110417', 'Takengon Barat', 4),
	('1104172013', '110417', 'Toweren Antara', 4),
	('1104172014', '110417', 'Toweran Toa', 4),
	('1104172015', '110417', 'Toweren Uken', 4),
	('1104172016', '110417', 'Teluk One-One', 4),
	('1104172017', '110417', 'Merah Mersa', 4),
	('1104172018', '110417', 'Waq Toweren', 4),
	('1104182001', '110418', 'Atu Lintang', 4),
	('1104182002', '110418', 'Merah Mege', 4),
	('1104182003', '110418', 'Merah Pupuk', 4),
	('1104182004', '110418', 'Merah Muyang', 4),
	('1104182005', '110418', 'Gayo Murni', 4),
	('1104182006', '110418', 'Kepala Akal', 4),
	('1104182007', '110418', 'Tanoh Abu', 4),
	('1104182008', '110418', 'Bintang Kekelip', 4),
	('1104182009', '110418', 'Merah Jernang', 4),
	('1104182010', '110418', 'Damar Mulyo', 4),
	('1104182011', '110418', 'Pantan Damar', 4),
	('1104192001', '110419', 'Merah Said', 4),
	('1104192002', '110419', 'Berawang Dewal', 4),
	('1104192003', '110419', 'Gegarang', 4),
	('1104192004', '110419', 'Telege Sari', 4),
	('1104192005', '110419', 'Jeget Ayu', 4),
	('1104192006', '110419', 'Paya Tugel', 4),
	('1104192007', '110419', 'Jagong Jeget', 4),
	('1104192008', '110419', 'Bukit Sari', 4),
	('1104192009', '110419', 'Bukit Kemuning', 4),
	('1104192010', '110419', 'Paya Dedep', 4),
	('1104202001', '110420', 'Bies Penantanan', 4),
	('1104202002', '110420', 'Bies Baru', 4),
	('1104202003', '110420', 'Bies Mulie', 4),
	('1104202004', '110420', 'Arul Latong', 4),
	('1104202005', '110420', 'Simpang Lukup Badak', 4),
	('1104202006', '110420', 'Atang Jungket', 4),
	('1104202007', '110420', 'Tebes Lues', 4),
	('1104202008', '110420', 'Pucuk Deku', 4),
	('1104202009', '110420', 'Lenga', 4),
	('1104202010', '110420', 'Uning Pegantungen', 4),
	('1104202011', '110420', 'Simpang Uning Niken', 4),
	('1104202012', '110420', 'Karang Bayur', 4),
	('1104212001', '110421', 'Pantan Tengah', 4),
	('1104212002', '110421', 'Rusip', 4),
	('1104212003', '110421', 'Pilar', 4),
	('1104212004', '110421', 'Arul Pertik', 4),
	('1104212005', '110421', 'Pilar Jaya', 4),
	('1104212006', '110421', 'Tirmi Ara', 4),
	('1104212007', '110421', 'Atu Singkih', 4),
	('1104212008', '110421', 'Pantan Bener', 4),
	('1104212009', '110421', 'Kerawang', 4),
	('1104212010', '110421', 'Mekar Maju', 4),
	('1104212011', '110421', 'Paya Tampu', 4),
	('1104212012', '110421', 'Tanjung', 4),
	('1104212013', '110421', 'Marandih Paya', 4),
	('1104212014', '110421', 'Kuala Rawa', 4),
	('1104212015', '110421', 'Pilar Wih Kiri', 4),
	('1104212016', '110421', 'Lut Jaya', 4),
	('1105012001', '110501', 'Suak Indrapuri', 4),
	('1105012002', '110501', 'Kampung Belakang', 4),
	('1105012003', '110501', 'Ujung Kalak', 4),
	('1105012004', '110501', 'Kuta Padang', 4),
	('1105012005', '110501', 'Ujong Baroh', 4),
	('1105012006', '110501', 'Rundeng', 4),
	('1105012007', '110501', 'Drien Rampak', 4),
	('1105012008', '110501', 'Kampung Pasir', 4),
	('1105012009', '110501', 'Pasar Aceh', 4),
	('1105012010', '110501', 'Padang Seurahet', 4),
	('1105012011', '110501', 'Panggong', 4),
	('1105012012', '110501', 'Seuneugok', 4),
	('1105012013', '110501', 'Gampong Darat', 4),
	('1105012014', '110501', 'Gampong Gampa', 4),
	('1105012015', '110501', 'Lapang', 4),
	('1105012016', '110501', 'Blang Beurandang', 4),
	('1105012017', '110501', 'Suak Ribee', 4),
	('1105012018', '110501', 'Suak Raya', 4),
	('1105012019', '110501', 'Suak Nie', 4),
	('1105012020', '110501', 'Leuhan', 4),
	('1105012021', '110501', 'Suak Sigadeng', 4),
	('1105022001', '110502', 'Keude Aron', 4),
	('1105022002', '110502', 'Kampung Masjid', 4),
	('1105022003', '110502', 'Padang Mancang', 4),
	('1105022004', '110502', 'Meunasah Buloh', 4),
	('1105022005', '110502', 'Alue Tampak', 4),
	('1105022006', '110502', 'Beureugang', 4),
	('1105022007', '110502', 'Marek', 4),
	('1105022008', '110502', 'Pasi Jambu', 4),
	('1105022009', '110502', 'Meunasah Ara', 4),
	('1105022010', '110502', 'Meunasah Rayeuk', 4),
	('1105022011', '110502', 'Simpang', 4),
	('1105022012', '110502', 'Peunia', 4),
	('1105022013', '110502', 'Tumpok Ladang', 4),
	('1105022014', '110502', 'Pasi Teungoh', 4),
	('1105022015', '110502', 'Putim', 4),
	('1105022016', '110502', 'Meunasah Rambot', 4),
	('1105022017', '110502', 'Pasi Jeumpa', 4),
	('1105022018', '110502', 'Palimbungan', 4),
	('1105022019', '110502', 'Muko', 4),
	('1105022020', '110502', 'Meuna. Gantung', 4),
	('1105022021', '110502', 'Blang Geunang', 4),
	('1105022022', '110502', 'Puuk', 4),
	('1105022023', '110502', 'Tanjong Bungong', 4),
	('1105022024', '110502', 'Alue On', 4),
	('1105022036', '110502', 'Tanjong Meulaboh', 4),
	('1105022037', '110502', 'Keude Tanjong', 4),
	('1105022038', '110502', 'Pungkie', 4),
	('1105022039', '110502', 'Pucok Pungkie', 4),
	('1105022040', '110502', 'Teladan', 4),
	('1105022041', '110502', 'Pasi Ara', 4),
	('1105022042', '110502', 'Meunuang Tanjong', 4),
	('1105022043', '110502', 'Alue Lhee', 4),
	('1105022044', '110502', 'Blang Dalam', 4),
	('1105022045', '110502', 'Teupin Panah', 4),
	('1105022046', '110502', 'Drien Caleue', 4),
	('1105022047', '110502', 'Alue Peudeung', 4),
	('1105022048', '110502', 'Pasi Meugat', 4),
	('1105022049', '110502', 'Babah Meulaboh', 4),
	('1105022050', '110502', 'Pasi Kumbang', 4),
	('1105022051', '110502', 'Padang Sikabu', 4),
	('1105022052', '110502', 'Sawang Teubei', 4),
	('1105022053', '110502', 'Alue Lhok', 4),
	('1105022062', '110502', 'Butu Jaya', 4),
	('1105022063', '110502', 'Keuramat', 4),
	('1105032001', '110503', 'Tungkop', 4),
	('1105032002', '110503', 'Sakuy', 4),
	('1105032003', '110503', 'Kajeung', 4),
	('1105032004', '110503', 'Geudong', 4),
	('1105032005', '110503', 'Sarah Perlak', 4),
	('1105032006', '110503', 'Tutut', 4),
	('1105032007', '110503', 'Drien Sibak', 4),
	('1105032008', '110503', 'Tuwi Saya', 4),
	('1105032009', '110503', 'Lancong', 4),
	('1105032010', '110503', 'Sipot', 4),
	('1105032011', '110503', 'Pungki', 4),
	('1105032012', '110503', 'Gunong Buloh', 4),
	('1105032013', '110503', 'Ramitie', 4),
	('1105032014', '110503', 'Lubok Beutong', 4),
	('1105032015', '110503', 'Gleng', 4),
	('1105032016', '110503', 'Tanoh Mirah', 4),
	('1105032017', '110503', 'Gaseu', 4),
	('1105032018', '110503', 'Lueng Baro', 4),
	('1105042001', '110504', 'Kuala Bhee', 4),
	('1105042002', '110504', 'Pasi Lunak', 4),
	('1105042003', '110504', 'Pasi Aceh', 4),
	('1105042004', '110504', 'Aron Tunong', 4),
	('1105042005', '110504', 'Aron Baroh', 4),
	('1105042006', '110504', 'Pasi Pandan', 4),
	('1105042007', '110504', 'Ranto Panyang', 4),
	('1105042008', '110504', 'Gempa Raya', 4),
	('1105042009', '110504', 'Padang Jawa', 4),
	('1105042010', '110504', 'Ie Itam Tunong', 4),
	('1105042011', '110504', 'Ie Itam Baroh', 4),
	('1105042012', '110504', 'Tingkeum Panyang', 4),
	('1105042013', '110504', 'Lueng Teungku Yah', 4),
	('1105042014', '110504', 'Lueng Tanoh Tho', 4),
	('1105042015', '110504', 'Gunong Rambong', 4),
	('1105042016', '110504', 'Drien Mangko', 4),
	('1105042017', '110504', 'Gunung Hampa', 4),
	('1105042018', '110504', 'Lung Jawa', 4),
	('1105042019', '110504', 'Blang Me', 4),
	('1105042020', '110504', 'Alue Blang', 4),
	('1105042021', '110504', 'Paya Dua', 4),
	('1105042022', '110504', 'Paya Luah', 4),
	('1105042023', '110504', 'Pasi Ara Kuala Batee', 4),
	('1105042024', '110504', 'Alue Sikaya', 4),
	('1105042025', '110504', 'Darul Huda', 4),
	('1105042026', '110504', 'Keuleumbah', 4),
	('1105042027', '110504', 'Jawa', 4),
	('1105042028', '110504', 'Pulo Ie', 4),
	('1105042029', '110504', 'Alue Panyang', 4),
	('1105042030', '110504', 'Cot Keumudai', 4),
	('1105042031', '110504', 'Seumantok', 4),
	('1105042032', '110504', 'Cot Situah', 4),
	('1105042033', '110504', 'Jawi', 4),
	('1105042034', '110504', 'Panton', 4),
	('1105042035', '110504', 'Pasi Birah', 4),
	('1105042036', '110504', 'Alue Sundak', 4),
	('1105042037', '110504', 'Teumarom', 4),
	('1105042038', '110504', 'Cot Murong', 4),
	('1105042039', '110504', 'Glee Siblah', 4),
	('1105042040', '110504', 'Suak Trieng', 4),
	('1105042041', '110504', 'Cot Lagan Bubon', 4),
	('1105042042', '110504', 'Bakat', 4),
	('1105042043', '110504', 'Lueng Buloh', 4),
	('1105052001', '110505', 'Alue Raya', 4),
	('1105052002', '110505', 'Cot Darat', 4),
	('1105052003', '110505', 'Cot Pluh', 4),
	('1105052004', '110505', 'Cot Seumeurung', 4),
	('1105052005', '110505', 'Cot Masjid', 4),
	('1105052006', '110505', 'Cot Lampise', 4),
	('1105052007', '110505', 'Cot Seulamat', 4),
	('1105052008', '110505', 'Cot Amun', 4),
	('1105052009', '110505', 'Deah', 4),
	('1105052010', '110505', 'Gampong Teungoh', 4),
	('1105052011', '110505', 'Gampong Ladang', 4),
	('1105052012', '110505', 'Gampong Cot', 4),
	('1105052013', '110505', 'Keureuseng', 4),
	('1105052014', '110505', 'Krueng Tinggai', 4),
	('1105052015', '110505', 'Kuala Bubon', 4),
	('1105052016', '110505', 'Leubok', 4),
	('1105052017', '110505', 'Lhok Bubon', 4),
	('1105052018', '110505', 'Leuken', 4),
	('1105052019', '110505', 'Mesjid baro', 4),
	('1105052020', '110505', 'Paya Lumpat', 4),
	('1105052021', '110505', 'Pinem', 4),
	('1105052022', '110505', 'Pange', 4),
	('1105052023', '110505', 'Pucok Lueng', 4),
	('1105052024', '110505', 'Rangkileh', 4),
	('1105052025', '110505', 'Reusak', 4),
	('1105052026', '110505', 'Suak Pandan', 4),
	('1105052027', '110505', 'Suak Seuke', 4),
	('1105052028', '110505', 'Suak Pante Breh', 4),
	('1105052029', '110505', 'Suak Geudeubang', 4),
	('1105052030', '110505', 'Suak Seumaseh', 4),
	('1105052031', '110505', 'Suak Timah', 4),
	('1105052032', '110505', 'Ujong Nga', 4),
	('1105062001', '110506', 'Alue Lhok', 4),
	('1105062002', '110506', 'Alue Bakong', 4),
	('1105062003', '110506', 'Berawang', 4),
	('1105062004', '110506', 'Blang Sibeutong', 4),
	('1105062005', '110506', 'Cot Keumuneng', 4),
	('1105062006', '110506', 'Cot Lada', 4),
	('1105062007', '110506', 'Gunong Panah', 4),
	('1105062008', '110506', 'Kuta Padang', 4),
	('1105062009', '110506', 'Kuala Pling', 4),
	('1105062010', '110506', 'Layung', 4),
	('1105062011', '110506', 'Liceh', 4),
	('1105062012', '110506', 'Peulanteu SP', 4),
	('1105062013', '110506', 'Rambong', 4),
	('1105062014', '110506', 'Seumuleng', 4),
	('1105062015', '110506', 'Suak Pangkat', 4),
	('1105062016', '110506', 'Seuneubok Trap', 4),
	('1105062017', '110506', 'Ulai Blang', 4),
	('1105072001', '110507', 'Arongan', 4),
	('1105072002', '110507', 'Alue Bagok', 4),
	('1105072003', '110507', 'Alue Sundak', 4),
	('1105072004', '110507', 'Alue Batee', 4),
	('1105072005', '110507', 'Cot Buloh', 4),
	('1105072006', '110507', 'Cot Kumbang', 4),
	('1105072007', '110507', 'Cot Juru Mudi', 4),
	('1105072008', '110507', 'Drien Rampak', 4),
	('1105072009', '110507', 'Kubu', 4),
	('1105072010', '110507', 'Keub', 4),
	('1105072011', '110507', 'Pante Mutia', 4),
	('1105072012', '110507', 'Peribu', 4),
	('1105072013', '110507', 'Panton Makmu', 4),
	('1105072014', '110507', 'Panton Bahagia', 4),
	('1105072015', '110507', 'Peulanteu LB.', 4),
	('1105072016', '110507', 'Rimba Langgeh', 4),
	('1105072017', '110507', 'Suak Keumudai', 4),
	('1105072018', '110507', 'Seune. Lhong', 4),
	('1105072019', '110507', 'Suak Ie Beuso', 4),
	('1105072020', '110507', 'Suak Bidok', 4),
	('1105072021', '110507', 'Simpang peut', 4),
	('1105072022', '110507', 'Seun. Teungoh', 4),
	('1105072023', '110507', 'Teupin Peraho', 4),
	('1105072024', '110507', 'Ujong Beusa', 4),
	('1105072025', '110507', 'Ujong Simpang', 4),
	('1105072026', '110507', 'Gunong Pulo', 4),
	('1105072027', '110507', 'Karang Hampa', 4),
	('1105082001', '110508', 'Seumara', 4),
	('1105082002', '110508', 'Babah Leung', 4),
	('1105082003', '110508', 'Babah Iseung', 4),
	('1105082004', '110508', 'Seumantok', 4),
	('1105082005', '110508', 'Alue Keumang', 4),
	('1105082006', '110508', 'Meunuang Kinco', 4),
	('1105082007', '110508', 'Langso', 4),
	('1105082008', '110508', 'Sikundo', 4),
	('1105082009', '110508', 'Lawet', 4),
	('1105082010', '110508', 'Canggei', 4),
	('1105082011', '110508', 'Manjeng', 4),
	('1105082012', '110508', 'Keutambang', 4),
	('1105082013', '110508', 'Pante Ceuremen', 4),
	('1105082014', '110508', 'Pulo Teungoh Manyang', 4),
	('1105082015', '110508', 'Jambak', 4),
	('1105082016', '110508', 'Tegal Sari', 4),
	('1105082017', '110508', 'Gunong Tarok', 4),
	('1105082018', '110508', 'Suak Awe', 4),
	('1105082019', '110508', 'Kreung Beukah', 4),
	('1105082020', '110508', 'Lhok Sari', 4),
	('1105082021', '110508', 'Babah Krueng Tep Lep', 4),
	('1105082022', '110508', 'Berdikari', 4),
	('1105082023', '110508', 'Lhok Guci', 4),
	('1105082024', '110508', 'Keude Suak Awe', 4),
	('1105082025', '110508', 'Sawang Rambot', 4),
	('1105092001', '110509', 'Ranto Panyang Barat', 4),
	('1105092002', '110509', 'Ranto Panyang Timur', 4),
	('1105092003', '110509', 'Mesjid Tuha', 4),
	('1105092004', '110509', 'Ujong Tanoh Darat', 4),
	('1105092005', '110509', 'Pasi Aceh. Tunong', 4),
	('1105092006', '110509', 'Pasi Aceh Baroh', 4),
	('1105092007', '110509', 'Buloh', 4),
	('1105092008', '110509', 'PuloTeungoh Ranto P.', 4),
	('1105092009', '110509', 'Paya Baro Ranto P', 4),
	('1105092010', '110509', 'Ranub Dong', 4),
	('1105092011', '110509', 'Pasi Pinang', 4),
	('1105092012', '110509', 'Pasi Mesjid', 4),
	('1105092013', '110509', 'Meureubo', 4),
	('1105092014', '110509', 'Langung', 4),
	('1105092015', '110509', 'Gunong Kleng', 4),
	('1105092016', '110509', 'Ujong Drien', 4),
	('1105092017', '110509', 'Peunaga Rayeuk', 4),
	('1105092018', '110509', 'Peunaga Pasi', 4),
	('1105092019', '110509', 'Peunaga Cut Ujong', 4),
	('1105092020', '110509', 'Reudeup', 4),
	('1105092021', '110509', 'Balee', 4),
	('1105092022', '110509', 'Paya Peunaga', 4),
	('1105092023', '110509', 'Ujong Tanjung', 4),
	('1105092024', '110509', 'Pucok Reudeup', 4),
	('1105092025', '110509', 'Sumber Batu', 4),
	('1105092026', '110509', 'Bakit Jaya', 4),
	('1105102001', '110510', 'Blang Luah LM', 4),
	('1105102002', '110510', 'Cot Rambong', 4),
	('1105102003', '110510', 'Lhok Malee', 4),
	('1105102004', '110510', 'Pasi Malee', 4),
	('1105102005', '110510', 'Napai', 4),
	('1105102006', '110510', 'Blang Cot Mameh', 4),
	('1105102007', '110510', 'Blang Cot Rubek', 4),
	('1105102008', '110510', 'Alue Leuhop', 4),
	('1105102009', '110510', 'Lubuk Pasi Ara', 4),
	('1105102010', '110510', 'Ulei Pasi Ara', 4),
	('1105102011', '110510', 'Cot Lagan LM', 4),
	('1105102012', '110510', 'Lueng Baro', 4),
	('1105102013', '110510', 'Kulam Kaju', 4),
	('1105102014', '110510', 'Alue Permen', 4),
	('1105102015', '110510', 'Peuleukueng', 4),
	('1105102016', '110510', 'Pasi Jeut', 4),
	('1105102017', '110510', 'Mon Pasong', 4),
	('1105102018', '110510', 'Pasi Mali', 4),
	('1105102019', '110510', 'Karak', 4),
	('1105102020', '110510', 'Ie Sayang', 4),
	('1105102021', '110510', 'Ule Pulo', 4),
	('1105102022', '110510', 'Pasi Panah', 4),
	('1105102023', '110510', 'Alue Keumuning', 4),
	('1105102024', '110510', 'Simpang Keumaron', 4),
	('1105112001', '110511', 'Seuradek', 4),
	('1105112002', '110511', 'Lubuk Panyang', 4),
	('1105112003', '110511', 'Paya Baro', 4),
	('1105112004', '110511', 'Kubu Capang', 4),
	('1105112005', '110511', 'Pasi Ara WT', 4),
	('1105112006', '110511', 'Gampong Baro WT', 4),
	('1105112007', '110511', 'Rambong', 4),
	('1105112008', '110511', 'Cot Punti', 4),
	('1105112009', '110511', 'Alue Empek', 4),
	('1105112010', '110511', 'Alue Bilie', 4),
	('1105112011', '110511', 'Pasi Janeng', 4),
	('1105112012', '110511', 'Tangkeh', 4),
	('1105112013', '110511', 'Alue Kuyun', 4),
	('1105112014', '110511', 'Bukit Meugajah', 4),
	('1105112015', '110511', 'Blang Dalam', 4),
	('1105112016', '110511', 'Teumiket Ranom', 4),
	('1105112017', '110511', 'Blang Makmu', 4),
	('1105112018', '110511', 'Gampong Baro KB', 4),
	('1105112019', '110511', 'Alue Meuganda', 4),
	('1105112020', '110511', 'Alue Seuralen', 4),
	('1105112021', '110511', 'Rambong Pinto', 4),
	('1105112022', '110511', 'Tuwi Empek', 4),
	('1105112023', '110511', 'Blang Luah KB', 4),
	('1105112024', '110511', 'Seuneubok Dalam', 4),
	('1105112025', '110511', 'Gayo Meugenderang', 4),
	('1105112026', '110511', 'Gunong Payang', 4),
	('1105122001', '110512', 'Mentulang', 4),
	('1105122002', '110512', 'Mugo Cut', 4),
	('1105122003', '110512', 'Mugo Rayeuk', 4),
	('1105122004', '110512', 'Baro Paya', 4),
	('1105122005', '110512', 'Sibintang', 4),
	('1105122006', '110512', 'Blang Teungoh', 4),
	('1105122007', '110512', 'Antong', 4),
	('1105122008', '110512', 'Ujong Raya', 4),
	('1105122009', '110512', 'Paya Baro Meuko', 4),
	('1105122010', '110512', 'Tuwi Buya', 4),
	('1105122011', '110512', 'Kuala Manyeue', 4),
	('1105122012', '110512', 'Manggie', 4),
	('1105122013', '110512', 'Kp. Baro', 4),
	('1105122014', '110512', 'Tamping', 4),
	('1105122015', '110512', 'Cot Manggie', 4),
	('1105122016', '110512', 'Blang Balee', 4),
	('1105122017', '110512', 'Babah Krueng Manggie', 4),
	('1105122018', '110512', 'Gunong Mata Ie', 4),
	('1105122019', '110512', 'Lek-Lek', 4),
	('1106012001', '110601', 'Meunasah Krueng Kala', 4),
	('1106012002', '110601', 'Jantang', 4),
	('1106012003', '110601', 'Baroh Krueng Kala', 4),
	('1106012004', '110601', 'Tunong Krueng Kala', 4),
	('1106012005', '110601', 'Sengko Meulat', 4),
	('1106012006', '110601', 'Birek', 4),
	('1106012007', '110601', 'Kareung', 4),
	('1106012008', '110601', 'Paroy', 4),
	('1106012009', '110601', 'Teungoh Blang Mee', 4),
	('1106012010', '110601', 'Lam Kuta Blang Mee', 4),
	('1106012011', '110601', 'Baroh Blang Mee', 4),
	('1106012012', '110601', 'Umong Seurebee', 4),
	('1106012013', '110601', 'Teungoh Geunteut', 4),
	('1106012014', '110601', 'Baroh Genteut', 4),
	('1106012015', '110601', 'Lam Juhang', 4),
	('1106012016', '110601', 'Utamong', 4),
	('1106012017', '110601', 'Gapuy', 4),
	('1106012018', '110601', 'Lam Sujen', 4),
	('1106012019', '110601', 'Mon Mata', 4),
	('1106012020', '110601', 'Lam Griheu', 4),
	('1106012021', '110601', 'Keutapang', 4),
	('1106012022', '110601', 'Saney', 4),
	('1106012023', '110601', 'Cundin', 4),
	('1106012024', '110601', 'Glee Bruek', 4),
	('1106012025', '110601', 'Pasie', 4),
	('1106012026', '110601', 'Pudeng', 4),
	('1106012027', '110601', 'Cot', 4),
	('1106012028', '110601', 'Meunasah Lhok', 4),
	('1106022001', '110602', 'Mon Ikeun', 4),
	('1106022002', '110602', 'Nusa', 4),
	('1106022003', '110602', 'Weu Raya', 4),
	('1106022004', '110602', 'Lam Kruet', 4),
	('1106022005', '110602', 'Lam Gaboh', 4),
	('1106022006', '110602', 'Lambaro Kueh', 4),
	('1106022007', '110602', 'Lam Ateuk', 4),
	('1106022008', '110602', 'Kueh', 4),
	('1106022009', '110602', 'Tanjong', 4),
	('1106022010', '110602', 'Ateuk Paya', 4),
	('1106022011', '110602', 'Seubun Keutapang', 4),
	('1106022012', '110602', 'Seubun Ayon', 4),
	('1106022013', '110602', 'Lambaro Seubun', 4),
	('1106022014', '110602', 'Naga Umbang', 4),
	('1106022015', '110602', 'Lampaya', 4),
	('1106022016', '110602', 'Meunasah Mesjid Lamlhom', 4),
	('1106022017', '110602', 'Meunasah Mon Cut', 4),
	('1106022018', '110602', 'Meunasah Manyang', 4),
	('1106022019', '110602', 'Meunasah Lam Girek', 4),
	('1106022020', '110602', 'Meunasah Baro Lam Puuk', 4),
	('1106022021', '110602', 'Meunasah Baro Lamlhom', 4),
	('1106022022', '110602', 'Meunasah Beutong', 4),
	('1106022023', '110602', 'Mnsh Mesjid Lam Puuk', 4),
	('1106022024', '110602', 'Meunasah Balee Lamlhom', 4),
	('1106022025', '110602', 'Meunasah Karieng', 4),
	('1106022026', '110602', 'Lam Cok', 4),
	('1106022027', '110602', 'Meunasah Cut', 4),
	('1106022028', '110602', 'Meunasah Blang', 4),
	('1106032001', '110603', 'Reukih Dayah', 4),
	('1106032002', '110603', 'Indrapuri', 4),
	('1106032003', '110603', 'Lam Leubok', 4),
	('1106032004', '110603', 'Ampee Ara', 4),
	('1106032005', '110603', 'Limo Blang', 4),
	('1106032006', '110603', 'Limo Mesjid', 4),
	('1106032007', '110603', 'Limo Lam Leuweung', 4),
	('1106032008', '110603', 'Lheu', 4),
	('1106032009', '110603', 'Meusale Lhok', 4),
	('1106032010', '110603', 'Cureh', 4),
	('1106032011', '110603', 'Cot Kareung', 4),
	('1106032012', '110603', 'Lam Lueng', 4),
	('1106032013', '110603', 'Mureu Ulee Titi', 4),
	('1106032014', '110603', 'Mureu Bung Ue', 4),
	('1106032015', '110603', 'Mureu Baro', 4),
	('1106032016', '110603', 'Mureu L. Glumpang', 4),
	('1106032017', '110603', 'Pasar Indrapuri', 4),
	('1106032018', '110603', 'Manggra', 4),
	('1106032019', '110603', 'Reukih Keupula', 4),
	('1106032020', '110603', 'Lam Ilie Mesjid', 4),
	('1106032021', '110603', 'Lam Ilie Teungoh', 4),
	('1106032022', '110603', 'Lam Ilie Ganto', 4),
	('1106032023', '110603', 'Meunara', 4),
	('1106032024', '110603', 'Aneuk Glee', 4),
	('1106032025', '110603', 'Krueng Lam Kareung', 4),
	('1106032026', '110603', 'Sinyeu', 4),
	('1106032027', '110603', 'Seureumo', 4),
	('1106032028', '110603', 'Ulee Kareung', 4),
	('1106032029', '110603', 'Lam Beutong', 4),
	('1106032030', '110603', 'Lampupok Baro', 4),
	('1106032031', '110603', 'Lampupok Raya', 4),
	('1106032032', '110603', 'Seulangai', 4),
	('1106032033', '110603', 'Ritieng', 4),
	('1106032034', '110603', 'Sihom Lhok', 4),
	('1106032035', '110603', 'Sihom Cot', 4),
	('1106032036', '110603', 'Seuot Baroh', 4),
	('1106032037', '110603', 'Seuot Tunong', 4),
	('1106032038', '110603', 'Lampanah Ranjo', 4),
	('1106032039', '110603', 'Lampanah Teungoh', 4),
	('1106032040', '110603', 'Lampanah Dayah', 4),
	('1106032041', '110603', 'Lampanah Baroh', 4),
	('1106032042', '110603', 'Lampanah Tunong', 4),
	('1106032043', '110603', 'Groet Blang', 4),
	('1106032044', '110603', 'Groet Mayang', 4),
	('1106032045', '110603', 'Groet Baro', 4),
	('1106032046', '110603', 'Jruek Bak Kreh', 4),
	('1106032047', '110603', 'Jruk Balee', 4),
	('1106032049', '110603', 'Mon Alue', 4),
	('1106032050', '110603', 'Lambunot', 4),
	('1106032051', '110603', 'Ulee Oe', 4),
	('1106032052', '110603', 'Lamseot', 4),
	('1106032053', '110603', 'Lingom', 4),
	('1106042001', '110604', 'Peukan Seulimum', 4),
	('1106042002', '110604', 'Keunaloi', 4),
	('1106042003', '110604', 'Lhieb', 4),
	('1106042004', '110604', 'Alue Gintong', 4),
	('1106042005', '110604', 'Kampong Seulimum', 4),
	('1106042006', '110604', 'Data Gaseu', 4),
	('1106042007', '110604', 'Rabo', 4),
	('1106042008', '110604', 'Kampong Raya', 4),
	('1106042009', '110604', 'Lam Jruen', 4),
	('1106042010', '110604', 'Buga', 4),
	('1106042011', '110604', 'Jawie', 4),
	('1106042012', '110604', 'Alue Rindang', 4),
	('1106042013', '110604', 'Iboh Tunong', 4),
	('1106042014', '110604', 'Iboh Tanjong', 4),
	('1106042015', '110604', 'Seuneubok', 4),
	('1106042016', '110604', 'Meunasah Baro', 4),
	('1106042017', '110604', 'Meunasah Tunong', 4),
	('1106042018', '110604', 'Batee Lhee', 4),
	('1106042019', '110604', 'Mangeu', 4),
	('1106042020', '110604', 'Bayu', 4),
	('1106042021', '110604', 'Ayon', 4),
	('1106042022', '110604', 'Lamteuba Droe', 4),
	('1106042023', '110604', 'Pulo', 4),
	('1106042024', '110604', 'Lampantee', 4),
	('1106042025', '110604', 'Lam Bada', 4),
	('1106042026', '110604', 'Blang Tingkeum', 4),
	('1106042027', '110604', 'Ateuk', 4),
	('1106042028', '110604', 'Lam Apeng', 4),
	('1106042029', '110604', 'Meurah', 4),
	('1106042030', '110604', 'Lampanah', 4),
	('1106042031', '110604', 'Ujong Mesjid Lampanah', 4),
	('1106042032', '110604', 'Ujong Keupula', 4),
	('1106042033', '110604', 'Leungah', 4),
	('1106042034', '110604', 'Beureunut', 4),
	('1106042035', '110604', 'Jeumpa', 4),
	('1106042036', '110604', 'Pinto Khop', 4),
	('1106042037', '110604', 'Bak Setui', 4),
	('1106042038', '110604', 'Bak Aghu', 4),
	('1106042039', '110604', 'Kayee Adang', 4),
	('1106042040', '110604', 'Lamkuk', 4),
	('1106042041', '110604', 'Ujong Mesjid Tanoh Abee', 4),
	('1106042042', '110604', 'Lam Carak', 4),
	('1106042043', '110604', 'Capeng Dayah', 4),
	('1106042044', '110604', 'Capeng Baroh', 4),
	('1106042045', '110604', 'Lampisang Dayah', 4),
	('1106042046', '110604', 'Lampisang Tunong', 4),
	('1106042047', '110604', 'Lampisang Teungoh', 4),
	('1106052001', '110605', 'Mata Ie', 4),
	('1106052002', '110605', 'Gampong Baroh', 4),
	('1106052003', '110605', 'Lampaseh Lhok', 4),
	('1106052004', '110605', 'Lampaseh Krueng', 4),
	('1106052005', '110605', 'Lam Nga', 4),
	('1106052006', '110605', 'Dayah Daboh', 4),
	('1106052007', '110605', 'Wue Lhok', 4),
	('1106052008', '110605', 'Alue', 4),
	('1106052009', '110605', 'Weu Krueng', 4),
	('1106052010', '110605', 'Seuban Cot', 4),
	('1106052011', '110605', 'Bak Dilib', 4),
	('1106052012', '110605', 'Ulee Lhat', 4),
	('1106052015', '110605', 'Lam Raya', 4),
	('1106052016', '110605', 'Lamme Garot', 4),
	('1106052017', '110605', 'Weu Bada', 4),
	('1106052018', '110605', 'Meunasah Tutong', 4),
	('1106052019', '110605', 'Empee Tunong', 4),
	('1106052020', '110605', 'Bak Cirih', 4),
	('1106052021', '110605', 'Warabo', 4),
	('1106052022', '110605', 'Teubang Phui Mesjid', 4),
	('1106052023', '110605', 'Teubang Phui Baro', 4),
	('1106052024', '110605', 'Bira Cot', 4),
	('1106052025', '110605', 'Bira Lhok', 4),
	('1106052026', '110605', 'Bung Tujuh', 4),
	('1106052027', '110605', 'Peurumping', 4),
	('1106052028', '110605', 'Atong', 4),
	('1106052029', '110605', 'Reudeup', 4),
	('1106052042', '110605', 'Seuban Lhok', 4),
	('1106052043', '110605', 'Seumeut', 4),
	('1106052044', '110605', 'Cot Seunong', 4),
	('1106052045', '110605', 'Mon Ara', 4),
	('1106052046', '110605', 'Cot Lhok', 4),
	('1106052047', '110605', 'Cot Lampoh Soh', 4),
	('1106052048', '110605', 'Bung Raya', 4),
	('1106052049', '110605', 'Piyeung Lhang', 4),
	('1106052050', '110605', 'Piyeung Manee', 4),
	('1106052051', '110605', 'Bung Daroh', 4),
	('1106052052', '110605', 'Piyeng Kuweu', 4),
	('1106052053', '110605', 'Peyeung Datu', 4),
	('1106062001', '110606', 'Reuhat Tuha', 4),
	('1106062002', '110606', 'Weu Siteh', 4),
	('1106062003', '110606', 'Dilib Lam Teungoh', 4),
	('1106062004', '110606', 'Baet Lampuot', 4),
	('1106062005', '110606', 'Dilib Bukit', 4),
	('1106062006', '110606', 'Seumeureung', 4),
	('1106062007', '110606', 'Sibreh Keumudee', 4),
	('1106062008', '110606', 'Baeit Mesago', 4),
	('1106062009', '110606', 'Baeit Mesjid', 4),
	('1106062010', '110606', 'Lam Baro Sibreh', 4),
	('1106062011', '110606', 'Lamgeu Baro', 4),
	('1106062012', '110606', 'Lamgeu Tuha', 4),
	('1106062013', '110606', 'Lampanah Ineu', 4),
	('1106062014', '110606', 'Tampak Jirat Raya', 4),
	('1106062015', '110606', 'Tampok Blang', 4),
	('1106062016', '110606', 'Lamteh Dayah', 4),
	('1106062017', '110606', 'Lam Lheu', 4),
	('1106062018', '110606', 'Lambarih Jurong Raya', 4),
	('1106062019', '110606', 'Bukhloh', 4),
	('1106062020', '110606', 'Niron', 4),
	('1106062021', '110606', 'Aneuk Galong Baro', 4),
	('1106062022', '110606', 'Aneuk Galong Titi', 4),
	('1106062023', '110606', 'Blang Cut', 4),
	('1106062024', '110606', 'Klieng Manyang', 4),
	('1106062025', '110606', 'Aneuk Batee', 4),
	('1106062026', '110606', 'Meunasah Tuha', 4),
	('1106062027', '110606', 'Lampisang', 4),
	('1106062028', '110606', 'Meunasah Bakthue', 4),
	('1106062029', '110606', 'Lambarih Mns. Bak Mee', 4),
	('1106062030', '110606', 'Luthu Dayah Krueng', 4),
	('1106062031', '110606', 'Luthu Lamweu', 4),
	('1106062032', '110606', 'Pantee Rawa', 4),
	('1106062033', '110606', 'Lambirah', 4),
	('1106062034', '110606', 'Kayee Adang', 4),
	('1106062035', '110606', 'Lamtanjong', 4),
	('1106072001', '110607', 'Lampeuneurut Ujong Blang', 4),
	('1106072002', '110607', 'Lampeuneurut Gampong', 4),
	('1106072003', '110607', 'Lam Reung', 4),
	('1106072004', '110607', 'Lam Cot', 4),
	('1106072005', '110607', 'Lam Blang Trieng', 4),
	('1106072006', '110607', 'Lam Blang Manyang', 4),
	('1106072007', '110607', 'Bayu', 4),
	('1106072008', '110607', 'Lagang', 4),
	('1106072009', '110607', 'Lam Siteh', 4),
	('1106072010', '110607', 'Lam Kawee', 4),
	('1106072011', '110607', 'Lheu Blang', 4),
	('1106072012', '110607', 'Paya Roh', 4),
	('1106072013', '110607', 'Lam Sidaya', 4),
	('1106072014', '110607', 'Kuta Karang', 4),
	('1106072015', '110607', 'Leu Geu', 4),
	('1106072016', '110607', 'Lam Peu Neu Uen', 4),
	('1106072017', '110607', 'Lam Theun', 4),
	('1106072018', '110607', 'Deunong', 4),
	('1106072019', '110607', 'Tingkuem', 4),
	('1106072020', '110607', 'Kandang', 4),
	('1106072021', '110607', 'Lam Bheu', 4),
	('1106072022', '110607', 'Daroy Kamee', 4),
	('1106072023', '110607', 'Geundring', 4),
	('1106072024', '110607', 'Garot', 4),
	('1106072025', '110607', 'Pasie Beutong', 4),
	('1106072026', '110607', 'Pasie Engking', 4),
	('1106072027', '110607', 'Jeumpet Ajun', 4),
	('1106072028', '110607', 'Gue Gajah', 4),
	('1106072029', '110607', 'Leu Ue/ Mata Ie', 4),
	('1106072030', '110607', 'Ulee Lueng', 4),
	('1106072031', '110607', 'Punie', 4),
	('1106072032', '110607', 'Ulee Tuy', 4),
	('1106082001', '110608', 'Lam Badeuk', 4),
	('1106082002', '110608', 'Lam Guron', 4),
	('1106082003', '110608', 'Lam Baro', 4),
	('1106082004', '110608', 'Lam Pageu', 4),
	('1106082005', '110608', 'Gampong Baro', 4),
	('1106082006', '110608', 'Lam Manyang', 4),
	('1106082007', '110608', 'Lam Teh', 4),
	('1106082008', '110608', 'Lam Lumpu', 4),
	('1106082009', '110608', 'Lam Teungoh', 4),
	('1106082010', '110608', 'Lam Tutui', 4),
	('1106082011', '110608', 'Meunasah Tuha', 4),
	('1106082012', '110608', 'Lam Awe', 4),
	('1106082013', '110608', 'Pulo Bunta', 4),
	('1106082014', '110608', 'Beuradeun', 4),
	('1106082015', '110608', 'Lampisang', 4),
	('1106082016', '110608', 'Keuneu Eu', 4),
	('1106082017', '110608', 'Lam Isek', 4),
	('1106082018', '110608', 'Lam Keumok', 4),
	('1106082019', '110608', 'Lam Rukam', 4),
	('1106082020', '110608', 'Gurah', 4),
	('1106082021', '110608', 'Rima Jenee', 4),
	('1106082022', '110608', 'Lam Geu Eu', 4),
	('1106082023', '110608', 'Lam Hasan', 4),
	('1106082024', '110608', 'Paya Tieng', 4),
	('1106082025', '110608', 'Ajuen', 4),
	('1106082026', '110608', 'Rima Keuneuron', 4),
	('1106092001', '110609', 'Meunasah Kulam', 4),
	('1106092002', '110609', 'Beurandeh', 4),
	('1106092003', '110609', 'Ie Seum', 4),
	('1106092004', '110609', 'Meunasah Keude', 4),
	('1106092005', '110609', 'Lam Reh', 4),
	('1106092006', '110609', 'Meunasah Mon', 4),
	('1106092007', '110609', 'Paya Kameng', 4),
	('1106092008', '110609', 'Ruyung', 4),
	('1106092009', '110609', 'Ladong', 4),
	('1106092010', '110609', 'Gampong Baro', 4),
	('1106092011', '110609', 'Durung', 4),
	('1106092012', '110609', 'Neuheun', 4),
	('1106092013', '110609', 'Lam Nga', 4),
	('1106102001', '110610', 'Lambaro', 4),
	('1106102002', '110610', 'Meunasah Manyang LG', 4),
	('1106102003', '110610', 'Bakoy', 4),
	('1106102004', '110610', 'Meunasah Baro', 4),
	('1106102005', '110610', 'Meunasah Dayah', 4),
	('1106102006', '110610', 'Meunasah Teutong', 4),
	('1106102007', '110610', 'Siron', 4),
	('1106102008', '110610', 'Pasie LG', 4),
	('1106102009', '110610', 'Dham Ceukok', 4),
	('1106102010', '110610', 'Dham Pulo', 4),
	('1106102011', '110610', 'Lhok Sukon', 4),
	('1106102012', '110610', 'Lubok Gapuy', 4),
	('1106102013', '110610', 'Pasie Lubok', 4),
	('1106102014', '110610', 'Bung Ceukok', 4),
	('1106102015', '110610', 'Teubang Phui', 4),
	('1106102016', '110610', 'Ateuk Anggok', 4),
	('1106102017', '110610', 'Ajee Rayeuk', 4),
	('1106102018', '110610', 'Ajee Cut', 4),
	('1106102019', '110610', 'Gani', 4),
	('1106102020', '110610', 'Ateuk Lueng Ie', 4),
	('1106102021', '110610', 'Cot Alue', 4),
	('1106102022', '110610', 'Cot Suruy', 4),
	('1106102023', '110610', 'Cot Bada', 4),
	('1106102024', '110610', 'Ajee Pagar Air', 4),
	('1106102025', '110610', 'Meunasah Krueng', 4),
	('1106102026', '110610', 'Jurong Peujeura', 4),
	('1106102027', '110610', 'Lubuk Batee', 4),
	('1106102028', '110610', 'Bineeh Blang', 4),
	('1106102029', '110610', 'Pantee', 4),
	('1106102030', '110610', 'Kalut', 4),
	('1106102031', '110610', 'Meunasah Manyang Pagar Air', 4),
	('1106102032', '110610', 'Meunasah Manyet', 4),
	('1106102033', '110610', 'Santan', 4),
	('1106102034', '110610', 'Tanjong', 4),
	('1106102035', '110610', 'Reuloh', 4),
	('1106102041', '110610', 'Paleuh Blang', 4),
	('1106102042', '110610', 'Cot Montiwan', 4),
	('1106102043', '110610', 'Lampreh Lam Jamprok', 4),
	('1106102044', '110610', 'Paleuh Pulo', 4),
	('1106102045', '110610', 'lam Cot', 4),
	('1106102046', '110610', 'Lam Sinyeu', 4),
	('1106102047', '110610', 'Lam Ue', 4),
	('1106102048', '110610', 'Cot Got', 4),
	('1106102049', '110610', 'Lamdaya', 4),
	('1106102050', '110610', 'Lambada', 4),
	('1106102051', '110610', 'Ujong XII', 4),
	('1106102052', '110610', 'Bada', 4),
	('1106102053', '110610', 'Lam Teungoh', 4),
	('1106102054', '110610', 'Kayee Lee', 4),
	('1106102056', '110610', 'Lampreh L. Teungoh', 4),
	('1106112001', '110611', 'Krueng Anaai', 4),
	('1106112002', '110611', 'Lam Puuk', 4),
	('1106112003', '110611', 'Cot Buet', 4),
	('1106112004', '110611', 'Bueng Bak Jok', 4),
	('1106112005', '110611', 'Lam Neuheun', 4),
	('1106112006', '110611', 'Seupeu', 4),
	('1106112007', '110611', 'Cot Mancang', 4),
	('1106112008', '110611', 'Lam Baet', 4),
	('1106112009', '110611', 'Cot Masam', 4),
	('1106112016', '110611', 'Gue', 4),
	('1106112018', '110611', 'Lam Sabang', 4),
	('1106112019', '110611', 'Lam Ulue Raya', 4),
	('1106112020', '110611', 'Lam Ulue Cut', 4),
	('1106112021', '110611', 'Leupung Masjid', 4),
	('1106112022', '110611', 'Cot Lam Mee', 4),
	('1106112023', '110611', 'Leupung Ulee Alue', 4),
	('1106112024', '110611', 'Lampoh Tarom', 4),
	('1106112025', '110611', 'L. Teubee Geupula', 4),
	('1106112026', '110611', 'L. Teubee Mon Ara', 4),
	('1106112027', '110611', 'Aron', 4),
	('1106112028', '110611', 'Bak Buloh', 4),
	('1106112029', '110611', 'Lam Seunong', 4),
	('1106112030', '110611', 'Lam Raya', 4),
	('1106112031', '110611', 'Lam Roh', 4),
	('1106112032', '110611', 'Lam Bunot Tanoh', 4),
	('1106112033', '110611', 'Tumpok Lampoh', 4),
	('1106112034', '110611', 'Puuk', 4),
	('1106112035', '110611', 'Lam Bunot Paya', 4),
	('1106112036', '110611', 'Lam Pok Kaude', 4),
	('1106112037', '110611', 'Lam Asan', 4),
	('1106112038', '110611', 'Lam Baro Dayah', 4),
	('1106112039', '110611', 'Lam Baro Bileu', 4),
	('1106112040', '110611', 'Cot Peutano', 4),
	('1106112041', '110611', 'Cot Cut', 4),
	('1106112042', '110611', 'Meunasah Bak Trieng', 4),
	('1106112043', '110611', 'Babah Jurong', 4),
	('1106112044', '110611', 'Lam Glumpang', 4),
	('1106112045', '110611', 'Rabeu', 4),
	('1106112046', '110611', 'Cucum', 4),
	('1106112047', '110611', 'Deyah', 4),
	('1106112048', '110611', 'Lam Trieng', 4),
	('1106112049', '110611', 'Beurangong', 4),
	('1106112050', '110611', 'Cot Preh', 4),
	('1106112051', '110611', 'Cot Raya', 4),
	('1106112052', '110611', 'Cot Yang', 4),
	('1106112053', '110611', 'Ujong Blang', 4),
	('1106112054', '110611', 'Lam Ceu', 4),
	('1106122001', '110612', 'Angan', 4),
	('1106122002', '110612', 'Lam Peudaya', 4),
	('1106122003', '110612', 'Lambada Peukan', 4),
	('1106122004', '110612', 'Lam Biheu', 4),
	('1106122005', '110612', 'Lambaro Sukon', 4),
	('1106122006', '110612', 'Miruek Taman', 4),
	('1106122007', '110612', 'Seuleu', 4),
	('1106122008', '110612', 'Gampong Cot', 4),
	('1106122009', '110612', 'Gampong Blang', 4),
	('1106122010', '110612', 'Lam Puja', 4),
	('1106122011', '110612', 'Tanjung Deyah', 4),
	('1106122012', '110612', 'Limpok', 4),
	('1106122013', '110612', 'Lam Puuk', 4),
	('1106122014', '110612', 'Lam Ujong', 4),
	('1106122015', '110612', 'Lam Gawee', 4),
	('1106122016', '110612', 'Beurabung', 4),
	('1106122017', '110612', 'Lam Timpeung', 4),
	('1106122018', '110612', 'Tungkop', 4),
	('1106122019', '110612', 'Tanjong Seulamat', 4),
	('1106122020', '110612', 'Lam Keunung', 4),
	('1106122021', '110612', 'Lam Duroy', 4),
	('1106122022', '110612', 'Lam Klat', 4),
	('1106122023', '110612', 'Lambiheu Siem', 4),
	('1106122024', '110612', 'Lam Bitra', 4),
	('1106122025', '110612', 'Lie Eue', 4),
	('1106122026', '110612', 'Krueng Kalee', 4),
	('1106122027', '110612', 'Lam Asan', 4),
	('1106122028', '110612', 'Lam Reh', 4),
	('1106122029', '110612', 'Siem', 4),
	('1106132001', '110613', 'Rinon', 4),
	('1106132002', '110613', 'Alue Raya', 4),
	('1106132003', '110613', 'Meu Lingge', 4),
	('1106132004', '110613', 'Lapeng', 4),
	('1106132005', '110613', 'Ulee Paya', 4),
	('1106132006', '110613', 'Gugop', 4),
	('1106132007', '110613', 'Seurapong', 4),
	('1106132008', '110613', 'Blang Situngkoh', 4),
	('1106132009', '110613', 'Paloh', 4),
	('1106132010', '110613', 'Lam Puyang', 4),
	('1106132011', '110613', 'Lhok', 4),
	('1106132012', '110613', 'Teunom', 4),
	('1106132013', '110613', 'Lam Teng', 4),
	('1106132014', '110613', 'Pasi Janeng', 4),
	('1106132015', '110613', 'Rabo', 4),
	('1106132016', '110613', 'Alue Ruyung', 4),
	('1106132017', '110613', 'Deudap', 4),
	('1106142001', '110614', 'Lamtamot', 4),
	('1106142002', '110614', 'Lambaro Tunong', 4),
	('1106142003', '110614', 'Lon Baroh', 4),
	('1106142004', '110614', 'Lon Asan', 4),
	('1106142005', '110614', 'Paya Keureleh', 4),
	('1106142006', '110614', 'Panca', 4),
	('1106142007', '110614', 'Lamkubu', 4),
	('1106142008', '110614', 'Panca Kubu', 4),
	('1106142009', '110614', 'Suka Damai', 4),
	('1106142010', '110614', 'Suka Mulia', 4),
	('1106142011', '110614', 'Saree Aceh', 4),
	('1106142012', '110614', 'Desa Teuladan', 4),
	('1106152001', '110615', 'Teureubeh', 4),
	('1106152002', '110615', 'Barueh', 4),
	('1106152003', '110615', 'Jantho', 4),
	('1106152004', '110615', 'Awee', 4),
	('1106152005', '110615', 'Data Cut', 4),
	('1106152006', '110615', 'Beung', 4),
	('1106152007', '110615', 'Weu', 4),
	('1106152008', '110615', 'Jalin', 4),
	('1106152009', '110615', 'Suka Tani', 4),
	('1106152010', '110615', 'Cucum', 4),
	('1106152011', '110615', 'Jantho Baru', 4),
	('1106152012', '110615', 'Jantho Makmur', 4),
	('1106152013', '110615', 'Bukit Meusara', 4),
	('1106162001', '110616', 'Lampakuk', 4),
	('1106162002', '110616', 'Lampoh Raja', 4),
	('1106162003', '110616', 'Lam Alieng', 4),
	('1106162004', '110616', 'Lam Leupung', 4),
	('1106162005', '110616', 'Lam Kleng', 4),
	('1106162006', '110616', 'Ia Alang Lam K.', 4),
	('1106162007', '110616', 'Ie Alang Lamghui', 4),
	('1106162008', '110616', 'Ie Alang Mesjid', 4),
	('1106162009', '110616', 'Ie Alang Dayah', 4),
	('1106162010', '110616', 'Lamtui', 4),
	('1106162011', '110616', 'Barih Lhok', 4),
	('1106162012', '110616', 'Bung Simek', 4),
	('1106162013', '110616', 'Banda Safa', 4),
	('1106162014', '110616', 'Bithak', 4),
	('1106162015', '110616', 'Lam Beugak', 4),
	('1106162016', '110616', 'Pakuk', 4),
	('1106162017', '110616', 'Lam Sie', 4),
	('1106162018', '110616', 'Siegapang', 4),
	('1106162019', '110616', 'Tutui', 4),
	('1106162020', '110616', 'Pasar Lampakuk', 4),
	('1106162021', '110616', 'Maheng', 4),
	('1106162022', '110616', 'Leupung Bruek', 4),
	('1106162023', '110616', 'Keumireu', 4),
	('1106162024', '110616', 'Lamleuot', 4),
	('1106162025', '110616', 'Leupung Balue', 4),
	('1106162026', '110616', 'Bak Sukon', 4),
	('1106162027', '110616', 'Cot Bayu', 4),
	('1106162028', '110616', 'Glee Jai', 4),
	('1106162029', '110616', 'Keureweung Blang', 4),
	('1106162030', '110616', 'Keureweung Krueng', 4),
	('1106162031', '110616', 'Siron Blang', 4),
	('1106162032', '110616', 'Siron Krueng', 4),
	('1106172001', '110617', 'Lambaro Samahani', 4),
	('1106172002', '110617', 'Lam Ara Cut', 4),
	('1106172003', '110617', 'Lam Ara Engkit', 4),
	('1106172004', '110617', 'Lam Ara Tunong', 4),
	('1106172005', '110617', 'Leupung Riwat', 4),
	('1106172006', '110617', 'Tumbo Baro', 4),
	('1106172007', '110617', 'Leupung Cut', 4),
	('1106172008', '110617', 'Lamsiteh Cot', 4),
	('1106172009', '110617', 'Reuleung Karieng', 4),
	('1106172010', '110617', 'Leubok Buni', 4),
	('1106172011', '110617', 'Leubok Batee', 4),
	('1106172012', '110617', 'Bunghu', 4),
	('1106172013', '110617', 'Teu Dayah', 4),
	('1106172014', '110617', 'Leupung Rayeuk', 4),
	('1106172015', '110617', 'Reuleung Glumpang', 4),
	('1106182001', '110618', 'Ateuk Lamphang', 4),
	('1106182002', '110618', 'Ateuk Lam Puot', 4),
	('1106182003', '110618', 'Ateuk Mon Panah', 4),
	('1106182004', '110618', 'Ateuk Lam Ura', 4),
	('1106182005', '110618', 'Ateuk Cut', 4),
	('1106182006', '110618', 'Ateuk Blang Asan', 4),
	('1106182007', '110618', 'Lamjamee Dayah', 4),
	('1106182008', '110618', 'Lam Batee', 4),
	('1106182009', '110618', 'Nya', 4),
	('1106182010', '110618', 'Bantee Linteung', 4),
	('1106182011', '110618', 'Krueng Mak', 4),
	('1106182012', '110618', 'Lambunot', 4),
	('1106182013', '110618', 'Lamjamee Lamkrak', 4),
	('1106182014', '110618', 'Blang Miro', 4),
	('1106182015', '110618', 'Blang Preh', 4),
	('1106182016', '110618', 'Bha Ulee Tutu', 4),
	('1106182017', '110618', 'Lam Urit', 4),
	('1106182018', '110618', 'Tantuha', 4),
	('1106192001', '110619', 'Lhang', 4),
	('1106192002', '110619', 'Biluy', 4),
	('1106192003', '110619', 'Lambatee', 4),
	('1106192004', '110619', 'Lam Kunyet', 4),
	('1106192005', '110619', 'Lamtadok', 4),
	('1106192006', '110619', 'Neusok', 4),
	('1106192007', '110619', 'Turam', 4),
	('1106192008', '110619', 'Teubaluy', 4),
	('1106192009', '110619', 'Blang Kiree', 4),
	('1106192010', '110619', 'Mane Dayah', 4),
	('1106192011', '110619', 'Lam Sot', 4),
	('1106192012', '110619', 'Lam Bleut', 4),
	('1106192013', '110619', 'Empee Trieng', 4),
	('1106192014', '110619', 'Lambaro Biluy', 4),
	('1106202001', '110620', 'Cadek', 4),
	('1106202002', '110620', 'Kajhu', 4),
	('1106202003', '110620', 'Baet', 4),
	('1106202004', '110620', 'Blang Krueng', 4),
	('1106202005', '110620', 'Klieng Muria', 4),
	('1106202006', '110620', 'Lambada Lhok', 4),
	('1106202007', '110620', 'Lampineung', 4),
	('1106202008', '110620', 'Lam Asan', 4),
	('1106202009', '110620', 'Labuy', 4),
	('1106202010', '110620', 'Lam Ujong', 4),
	('1106202011', '110620', 'Klieng Cot Aron', 4),
	('1106202012', '110620', 'Cot Paya', 4),
	('1106202013', '110620', 'Miruk Lamreudep', 4),
	('1106212001', '110621', 'Meunasah Papeun', 4),
	('1106212002', '110621', 'Meunasah Brang Trieng', 4),
	('1106212003', '110621', 'Leung Ie', 4),
	('1106212004', '110621', 'Lampeureume', 4),
	('1106212005', '110621', 'Gla Dayah', 4),
	('1106212006', '110621', 'Miruek', 4),
	('1106212007', '110621', 'Lam Gapang', 4),
	('1106212008', '110621', 'Meunasah Manyang', 4),
	('1106212009', '110621', 'Meunasah Baet', 4),
	('1106212010', '110621', 'Meunasah Intan', 4),
	('1106212011', '110621', 'Rumpet', 4),
	('1106212012', '110621', 'Gla Meunasah Baro', 4),
	('1106222001', '110622', 'Layeun', 4),
	('1106222002', '110622', 'Pulot', 4),
	('1106222003', '110622', 'Lamseunia', 4),
	('1106222004', '110622', 'Meunasah Mesjid', 4),
	('1106222005', '110622', 'Meunasah Bak Ue', 4),
	('1106222006', '110622', 'Dayah Mamplam', 4),
	('1106232001', '110623', 'Cot Puklat', 4),
	('1106232002', '110623', 'Lam Mee', 4),
	('1106232003', '110623', 'Meulayo', 4),
	('1106232004', '110623', 'Lam Siem', 4),
	('1106232005', '110623', 'Cot Geundret', 4),
	('1106232006', '110623', 'Paya Ue', 4),
	('1106232007', '110623', 'Cot Mon Raya', 4),
	('1106232008', '110623', 'Cot Meulangeun', 4),
	('1106232009', '110623', 'Cot Madi', 4),
	('1106232010', '110623', 'Bung Sidom', 4),
	('1106232011', '110623', 'Cot Karieng', 4),
	('1106232012', '110623', 'Gampong Blang', 4),
	('1106232013', '110623', 'Cot Malem', 4),
	('1106232014', '110623', 'Cot Rumpun', 4),
	('1106232015', '110623', 'Cot Hoho', 4),
	('1106232016', '110623', 'Cot Jambo', 4),
	('1106232017', '110623', 'Cot Nambak', 4),
	('1106232018', '110623', 'Bung Pageu', 4),
	('1106232019', '110623', 'Cot Sayun', 4),
	('1106232020', '110623', 'Teupin Batee', 4),
	('1106232021', '110623', 'Cot Leuot', 4),
	('1106232022', '110623', 'Cot Bagie', 4),
	('1106232023', '110623', 'Kayee Kunyet', 4),
	('1106232024', '110623', 'Cot Mancang', 4),
	('1106232025', '110623', 'Empee Bata', 4),
	('1106232026', '110623', 'Data Makmur', 4),
	('1107032001', '110703', 'Dayah Tua', 4),
	('1107032002', '110703', 'Dayah Baroh', 4),
	('1107032003', '110703', 'Bintang Hu', 4),
	('1107032004', '110703', 'Pulo Tukok', 4),
	('1107032005', '110703', 'Pulo Bungong', 4),
	('1107032006', '110703', 'Geunteng Barat', 4),
	('1107032007', '110703', 'Geunteng Timur', 4),
	('1107032008', '110703', 'Calong Cut', 4),
	('1107032009', '110703', 'Geulumpang Lhee', 4),
	('1107032010', '110703', 'Aron', 4),
	('1107032011', '110703', 'Tuha', 4),
	('1107032012', '110703', 'Dayah', 4),
	('1107032013', '110703', 'Mesjid Calong', 4),
	('1107032014', '110703', 'Meucat', 4),
	('1107032015', '110703', 'Teupin Raya', 4),
	('1107032016', '110703', 'Rungkom', 4),
	('1107032017', '110703', 'Meunasah Mee', 4),
	('1107032018', '110703', 'Pulo Pande', 4),
	('1107032019', '110703', 'Seulatan', 4),
	('1107032020', '110703', 'Alue Lada', 4),
	('1107032021', '110703', 'Teupin Jeue', 4),
	('1107032022', '110703', 'Neuheun', 4),
	('1107032023', '110703', 'Crueng', 4),
	('1107032024', '110703', 'Kareung', 4),
	('1107032025', '110703', 'Kule', 4),
	('1107032026', '110703', 'Kulam', 4),
	('1107032027', '110703', 'Awee', 4),
	('1107042001', '110704', 'Tunong', 4),
	('1107042002', '110704', 'Raya', 4),
	('1107042003', '110704', 'Daboh', 4),
	('1107042004', '110704', 'Cut', 4),
	('1107042005', '110704', 'Mesjid Reubee', 4),
	('1107042006', '110704', 'Tanjong', 4),
	('1107042007', '110704', 'Geudong', 4),
	('1107042008', '110704', 'Reuntoh', 4),
	('1107042009', '110704', 'Reuba', 4),
	('1107042010', '110704', 'Mns. Krueng', 4),
	('1107042011', '110704', 'Neulop', 4),
	('1107042012', '110704', 'Glee', 4),
	('1107042013', '110704', 'Kumbang', 4),
	('1107042014', '110704', 'Buloh', 4),
	('1107042015', '110704', 'Bungoe', 4),
	('1107042016', '110704', 'Dayah Reubee', 4),
	('1107042017', '110704', 'Jambee', 4),
	('1107042018', '110704', 'Dayah Baro', 4),
	('1107042019', '110704', 'Puuk', 4),
	('1107042020', '110704', 'Lhee Meunasah', 4),
	('1107042021', '110704', 'Ulee Tutu Raya', 4),
	('1107042022', '110704', 'Mesjid Aree', 4),
	('1107042023', '110704', 'Keutapang Aree', 4),
	('1107042024', '110704', 'Pante Aree', 4),
	('1107042025', '110704', 'Pulo Tunong', 4),
	('1107042026', '110704', 'Pulo Baroh', 4),
	('1107042027', '110704', 'Krumbok', 4),
	('1107042028', '110704', 'Ceurih Blang Mee', 4),
	('1107042029', '110704', 'Ceurih Keupula', 4),
	('1107042030', '110704', 'Ceurih Alue', 4),
	('1107042031', '110704', 'Ceurih Cot', 4),
	('1107042032', '110704', 'Seupeung', 4),
	('1107042033', '110704', 'Sukon', 4),
	('1107042034', '110704', 'Dayah Beuah', 4),
	('1107042035', '110704', 'Krueng Cot', 4),
	('1107042036', '110704', 'Mesjid Beuah', 4),
	('1107042037', '110704', 'Lueng Dama', 4),
	('1107042038', '110704', 'Mesjid Bambong', 4),
	('1107042039', '110704', 'Reuseb', 4),
	('1107042040', '110704', 'Sagoe', 4),
	('1107042041', '110704', 'Seukeum', 4),
	('1107042042', '110704', 'Pengoe', 4),
	('1107042043', '110704', 'Keutapang Bambong', 4),
	('1107042044', '110704', 'Metareum', 4),
	('1107052001', '110705', 'Bangkeh', 4),
	('1107052002', '110705', 'Pucok', 4),
	('1107052004', '110705', 'Leupu', 4),
	('1107052005', '110705', 'Pulau Loih', 4),
	('1107052006', '110705', 'Keune', 4),
	('1107062001', '110706', 'Simpang', 4),
	('1107062002', '110706', 'Krueng Jangko', 4),
	('1107062003', '110706', 'Krueng Nyong', 4),
	('1107062004', '110706', 'Cot Baroh', 4),
	('1107062005', '110706', 'Cot Tunong', 4),
	('1107062006', '110706', 'Bili', 4),
	('1107062007', '110706', 'Panjoe', 4),
	('1107062008', '110706', 'Mesjid Amud', 4),
	('1107062009', '110706', 'Reudeup Meulayu', 4),
	('1107062010', '110706', 'Dayah Tanoh', 4),
	('1107062011', '110706', 'Mamplam', 4),
	('1107062012', '110706', 'Balee', 4),
	('1107062013', '110706', 'Keupula', 4),
	('1107062014', '110706', 'Pulo Lueng Teuga', 4),
	('1107062015', '110706', 'Sukon Mesjid', 4),
	('1107062016', '110706', 'Sukon Baroh', 4),
	('1107062017', '110706', 'Krut Teumpeun', 4),
	('1107062018', '110706', 'Blang Drang', 4),
	('1107062019', '110706', 'Ude Gampong', 4),
	('1107062020', '110706', 'Kayee Jatou', 4),
	('1107062021', '110706', 'Kampong Jeumpa', 4),
	('1107062022', '110706', 'Pulo Dayah/Pulo Lon', 4),
	('1107062023', '110706', 'Jurong Pande', 4),
	('1107062024', '110706', 'Pulo Gajah Mate', 4),
	('1107062025', '110706', 'Tufah Jeulatang', 4),
	('1107062026', '110706', 'Kumbang Keupula', 4),
	('1107062027', '110706', 'Pulo Batee', 4),
	('1107062028', '110706', 'Meunjee', 4),
	('1107062029', '110706', 'Keutapang Mesjid', 4),
	('1107062030', '110706', 'Dayah Kampung Pisang', 4),
	('1107062031', '110706', 'Blang Tunong', 4),
	('1107062032', '110706', 'Blang Pueb', 4),
	('1107062033', '110706', 'Lambaro', 4),
	('1107062034', '110706', 'Neurok', 4),
	('1107072001', '110707', 'Tamping Tunong', 4),
	('1107072002', '110707', 'Tamping Baroh', 4),
	('1107072003', '110707', 'Dayah Caleue', 4),
	('1107072004', '110707', 'Jurong', 4),
	('1107072005', '110707', 'Keutapang', 4),
	('1107072006', '110707', 'Dayah Keurako', 4),
	('1107072007', '110707', 'Mesjid Lam Ujong', 4),
	('1107072008', '110707', 'Baro Jruek', 4),
	('1107072009', '110707', 'Yub Mee', 4),
	('1107072010', '110707', 'Raya', 4),
	('1107072011', '110707', 'Pulo Gampong U', 4),
	('1107072012', '110707', 'Pante Lhok Kaju', 4),
	('1107072014', '110707', 'Sukon', 4),
	('1107072015', '110707', 'Rawa', 4),
	('1107072016', '110707', 'Mesjid Tungkop', 4),
	('1107072017', '110707', 'Dayah Muara', 4),
	('1107072018', '110707', 'Pante Garot', 4),
	('1107072019', '110707', 'Garot Cut', 4),
	('1107072020', '110707', 'Keubang', 4),
	('1107072021', '110707', 'Blang Garot', 4),
	('1107072022', '110707', 'Meulayu', 4),
	('1107072023', '110707', 'Tungkop Cut', 4),
	('1107072024', '110707', 'Guci', 4),
	('1107072025', '110707', 'Teungoh Blang', 4),
	('1107072026', '110707', 'Mesjid Jim Jim', 4),
	('1107072027', '110707', 'Sukon Ulee Gampong', 4),
	('1107072028', '110707', 'Lam Kabu', 4),
	('1107072029', '110707', 'Ulee Birah', 4),
	('1107072030', '110707', 'Mesjid Baro', 4),
	('1107072031', '110707', 'Lam Reuneng', 4),
	('1107072032', '110707', 'Cot Seuke', 4),
	('1107072033', '110707', 'Drien', 4),
	('1107072034', '110707', 'Rumia', 4),
	('1107072035', '110707', 'Wakheuh', 4),
	('1107072036', '110707', 'Baro Bluek', 4),
	('1107072037', '110707', 'Mesjid Ulee Gampong', 4),
	('1107072038', '110707', 'Dayah Bie', 4),
	('1107072039', '110707', 'Bale Baro Bluek', 4),
	('1107072040', '110707', 'Putoe', 4),
	('1107072041', '110707', 'Blang Rapai', 4),
	('1107072042', '110707', 'Neulop II', 4),
	('1107072043', '110707', 'Baro Gapui', 4),
	('1107072044', '110707', 'Bale Baroh Gapui', 4),
	('1107072045', '110707', 'Meunasah Glee Gapui', 4),
	('1107072046', '110707', 'Teungoh Seuwiek', 4),
	('1107072047', '110707', 'Mesjid Seuwiek', 4),
	('1107072048', '110707', 'Tuha', 4),
	('1107072049', '110707', 'Beureudep', 4),
	('1107072050', '110707', 'Blang Lhok Kaju', 4),
	('1107082001', '110708', 'Jurong Balee', 4),
	('1107082002', '110708', 'Aron Asan Kumbang', 4),
	('1107082003', '110708', 'Cebrek', 4),
	('1107082004', '110708', 'Jurong Mesjid', 4),
	('1107082005', '110708', 'Meunasah Gantung', 4),
	('1107082006', '110708', 'Babah Jurong', 4),
	('1107082007', '110708', 'Keupula', 4),
	('1107082008', '110708', 'Jareng', 4),
	('1107082009', '110708', 'Arosan', 4),
	('1107082010', '110708', 'Tanjong Krueng', 4),
	('1107082011', '110708', 'Lancang', 4),
	('1107082012', '110708', 'Pasi Lhok', 4),
	('1107082013', '110708', 'Jeumeurang', 4),
	('1107082014', '110708', 'Pusong', 4),
	('1107082015', '110708', 'Meuraksa', 4),
	('1107082016', '110708', 'Kayee Panyang', 4),
	('1107082017', '110708', 'Kampong Panjoe', 4),
	('1107082018', '110708', 'Kampong Asan', 4),
	('1107082019', '110708', 'Meunasah Mesjid', 4),
	('1107082020', '110708', 'Meunasah Mee', 4),
	('1107082021', '110708', 'Meunasah Teungoh', 4),
	('1107082022', '110708', 'Pasi ie Leubeue', 4),
	('1107082023', '110708', 'Keude ie Leubeue', 4),
	('1107082024', '110708', 'Sukon', 4),
	('1107082025', '110708', 'Are', 4),
	('1107082026', '110708', 'Meunasah Krueng', 4),
	('1107082027', '110708', 'Krueng Dhoe', 4),
	('1107082028', '110708', 'Meunasah Baro', 4),
	('1107082029', '110708', 'Bentayan', 4),
	('1107082030', '110708', 'Kandang', 4),
	('1107082031', '110708', 'Lamkawe', 4),
	('1107082032', '110708', 'Puuk', 4),
	('1107082033', '110708', 'Tanjong', 4),
	('1107082034', '110708', 'Deyah Blang', 4),
	('1107082035', '110708', 'Deyah Mon Ara', 4),
	('1107082036', '110708', 'Keureumbok', 4),
	('1107082037', '110708', 'Mayang', 4),
	('1107082038', '110708', 'Matang Kuli', 4),
	('1107082039', '110708', 'Rheung Rheung', 4),
	('1107082040', '110708', 'Tumpeun', 4),
	('1107082041', '110708', 'Blang Cut', 4),
	('1107082042', '110708', 'Geulumpang', 4),
	('1107082043', '110708', 'Aron Kuta Baro', 4),
	('1107082044', '110708', 'Kampong Barat', 4),
	('1107082045', '110708', 'Kampong Araih', 4),
	('1107092001', '110709', 'Blang Paseh', 4),
	('1107092002', '110709', 'Benteng', 4),
	('1107092003', '110709', 'Blok Bengkel', 4),
	('1107092004', '110709', 'Pante Teungoh', 4),
	('1107092005', '110709', 'Kuala Pidie', 4),
	('1107092006', '110709', 'Keramat Luar', 4),
	('1107092007', '110709', 'Keramat Dalam', 4),
	('1107092008', '110709', 'Blok Sawah', 4),
	('1107092009', '110709', 'Blang Asan', 4),
	('1107092010', '110709', 'Lampoh Krueng', 4),
	('1107092011', '110709', 'Kampong Asan', 4),
	('1107092012', '110709', 'Meunasah Peukan', 4),
	('1107092013', '110709', 'Pasi Rawa', 4),
	('1107092014', '110709', 'Pasi Peukan Baro', 4),
	('1107092015', '110709', 'Tanjong Krueng', 4),
	('1107112001', '110711', 'Blang', 4),
	('1107112002', '110711', 'Teumeucet', 4),
	('1107112003', '110711', 'Blang Cut', 4),
	('1107112004', '110711', 'Kumbang', 4),
	('1107112005', '110711', 'Pulo Tanjong', 4),
	('1107112006', '110711', 'Ara Bungkok', 4),
	('1107112007', '110711', 'Lagang', 4),
	('1107112008', '110711', 'Mesjid', 4),
	('1107112009', '110711', 'Baroh', 4),
	('1107112010', '110711', 'Tunong', 4),
	('1107112011', '110711', 'Teungoh', 4),
	('1107112012', '110711', 'Dayah Andeue', 4),
	('1107112013', '110711', 'Dayah Sinthop', 4),
	('1107112014', '110711', 'Kulu', 4),
	('1107112015', '110711', 'Mesjid Andeue', 4),
	('1107112016', '110711', 'Meuyub', 4),
	('1107112017', '110711', 'Tuha Lada', 4),
	('1107112018', '110711', 'Lhok Lubue', 4),
	('1107112019', '110711', 'Babah Jurong', 4),
	('1107112020', '110711', 'Krueng Lala', 4),
	('1107122001', '110712', 'Cot', 4),
	('1107122002', '110712', 'Tgk Di Laweung', 4),
	('1107122003', '110712', 'Mesjid', 4),
	('1107122004', '110712', 'Keupula', 4),
	('1107122005', '110712', 'Suka Jaya', 4),
	('1107122006', '110712', 'Pawod', 4),
	('1107122007', '110712', 'Dayah', 4),
	('1107122008', '110712', 'Krueng', 4),
	('1107122009', '110712', 'Gle Cut', 4),
	('1107122010', '110712', 'IE Masen', 4),
	('1107122011', '110712', 'Sagoe', 4),
	('1107122012', '110712', 'Ujong Pie', 4),
	('1107122013', '110712', 'Blang Raya', 4),
	('1107122014', '110712', 'Batee', 4),
	('1107122015', '110712', 'Ingin Jaya', 4),
	('1107122016', '110712', 'Papeun', 4),
	('1107122017', '110712', 'Tuha Biheue', 4),
	('1107132001', '110713', 'Mesjid Yaman', 4),
	('1107132002', '110713', 'Baro Yaman', 4),
	('1107132003', '110713', 'Mee Teungoh Yaman', 4),
	('1107132004', '110713', 'Sentosa', 4),
	('1107132005', '110713', 'Baroh Barat Yaman', 4),
	('1107132006', '110713', 'Tuha G. Gajah', 4),
	('1107132007', '110713', 'Jadan', 4),
	('1107132008', '110713', 'Balee Keumangan', 4),
	('1107132009', '110713', 'Blang Tidiek', 4),
	('1107132010', '110713', 'Blang Lilue', 4),
	('1107132011', '110713', 'Keumangan Cut', 4),
	('1107132012', '110713', 'Mesjid Keumangan', 4),
	('1107132013', '110713', 'Dayah Tidiek', 4),
	('1107132014', '110713', 'Lueng Sagoe', 4),
	('1107132015', '110713', 'Blang', 4),
	('1107132016', '110713', 'Dayah', 4),
	('1107132017', '110713', 'Pante', 4),
	('1107132018', '110713', 'Rapana', 4),
	('1107132019', '110713', 'Paya Tiba', 4),
	('1107132020', '110713', 'Paloh Kambuek', 4),
	('1107132021', '110713', 'Lampoh Sirong', 4),
	('1107132022', '110713', 'Mee Panyang', 4),
	('1107132023', '110713', 'Reulue', 4),
	('1107132024', '110713', 'Dayah Syarif', 4),
	('1107132025', '110713', 'Peureulak', 4),
	('1107132026', '110713', 'Riubuen', 4),
	('1107132027', '110713', 'Balee Busu', 4),
	('1107132028', '110713', 'Lingkok Busu', 4),
	('1107132029', '110713', 'Kumbang', 4),
	('1107142001', '110714', 'Mesjid Kunyet', 4),
	('1107142002', '110714', 'Piala Kunyet', 4),
	('1107142003', '110714', 'Hagu', 4),
	('1107142004', '110714', 'Baro Kunyet', 4),
	('1107142005', '110714', 'Dayah Tanoh', 4),
	('1107142006', '110714', 'Kambuk Nicah', 4),
	('1107142007', '110714', 'Kambuk Payapi', 4),
	('1107142008', '110714', 'Seunadeu', 4),
	('1107142009', '110714', 'Blang Guci', 4),
	('1107142010', '110714', 'Dayah Baroh Kunyet', 4),
	('1107142011', '110714', 'Blang Geuleudieng', 4),
	('1107142012', '110714', 'Geulumpang', 4),
	('1107142013', '110714', 'Mesjid Geuleudieng', 4),
	('1107142014', '110714', 'Sukon', 4),
	('1107142015', '110714', 'Mesjid Peudaya', 4),
	('1107142016', '110714', 'Cut', 4),
	('1107142017', '110714', 'Buloh Buni', 4),
	('1107142018', '110714', 'Perlak', 4),
	('1107142019', '110714', 'Dayah Baroh Peudaya', 4),
	('1107142020', '110714', 'Teungoh', 4),
	('1107142021', '110714', 'Tuha', 4),
	('1107142022', '110714', 'Tunong Peudaya', 4),
	('1107142023', '110714', 'Buni Reuleung', 4),
	('1107142024', '110714', 'Trieng', 4),
	('1107142025', '110714', 'Leuhob', 4),
	('1107142026', '110714', 'Gurong Cot', 4),
	('1107142027', '110714', 'Suyo', 4),
	('1107142028', '110714', 'Kret', 4),
	('1107142029', '110714', 'Capa', 4),
	('1107142030', '110714', 'Jurong Anoe', 4),
	('1107142031', '110714', 'Balee', 4),
	('1107142032', '110714', 'Siron', 4),
	('1107142033', '110714', 'Gampong Cut', 4),
	('1107142034', '110714', 'Pante Cermen', 4),
	('1107142035', '110714', 'Pasar', 4),
	('1107142036', '110714', 'Mesjid Paloh', 4),
	('1107142037', '110714', 'Mukee', 4),
	('1107142038', '110714', 'Mesjid Beurabo', 4),
	('1107142039', '110714', 'Sekeumbrok', 4),
	('1107142040', '110714', 'Baro Beurabo', 4),
	('1107142041', '110714', 'Adang', 4),
	('1107142042', '110714', 'Paloh Jeurat', 4),
	('1107142043', '110714', 'Seuleunggieng', 4),
	('1107142044', '110714', 'Teungoh Drien', 4),
	('1107142045', '110714', 'Kumbang', 4),
	('1107142046', '110714', 'Mesjid Gogo', 4),
	('1107142047', '110714', 'Tuha Gogo', 4),
	('1107142048', '110714', 'Gle', 4),
	('1107142049', '110714', 'Muko', 4),
	('1107142050', '110714', 'Raya', 4),
	('1107142051', '110714', 'Grong Grong', 4),
	('1107142052', '110714', 'Aron Beunot', 4),
	('1107142053', '110714', 'Buloh', 4),
	('1107142054', '110714', 'Tonoeng Tanjong', 4),
	('1107142055', '110714', 'Keupula', 4),
	('1107142056', '110714', 'Jok', 4),
	('1107142057', '110714', 'Leuen', 4),
	('1107142058', '110714', 'Crueng', 4),
	('1107142059', '110714', 'Cot Keutapang', 4),
	('1107142060', '110714', 'Siron Tanjong', 4),
	('1107142061', '110714', 'Mesjid Tanjong', 4),
	('1107142062', '110714', 'Khang Tanjong', 4),
	('1107142063', '110714', 'Meurinya', 4),
	('1107142064', '110714', 'Pulo Hagu', 4),
	('1107152001', '110715', 'Dua Paya', 4),
	('1107152002', '110715', 'Cot Meulu', 4),
	('1107152003', '110715', 'Dayah Bubue', 4),
	('1107152004', '110715', 'Tanjong Hagu', 4),
	('1107152005', '110715', 'Sumboe Buga', 4),
	('1107152006', '110715', 'Rambayan Kupula', 4),
	('1107152007', '110715', 'Rambayan Lueng', 4),
	('1107152008', '110715', 'Cempala Kuneng', 4),
	('1107152009', '110715', 'Peunayong', 4),
	('1107152010', '110715', 'Leuhop', 4),
	('1107152011', '110715', 'Kumbang waido', 4),
	('1107152012', '110715', 'Gampong waido', 4),
	('1107152013', '110715', 'Mee Krukon', 4),
	('1107152014', '110715', 'Mee Lampoh Saka', 4),
	('1107152015', '110715', 'Meunasah Lueng', 4),
	('1107152016', '110715', 'Dayah Seumideun', 4),
	('1107152017', '110715', 'Mesjid Rumpong', 4),
	('1107152018', '110715', 'Reuba Waido', 4),
	('1107152019', '110715', 'Dayah Tungku', 4),
	('1107152020', '110715', 'Jurong Raya', 4),
	('1107152021', '110715', 'Balee Restong', 4),
	('1107152022', '110715', 'Lueng Mesjid', 4),
	('1107152023', '110715', 'Teungoh Baroh', 4),
	('1107152024', '110715', 'Mee Hagu', 4),
	('1107152025', '110715', 'Dayah Sukon', 4),
	('1107152026', '110715', 'Blang Raya', 4),
	('1107152027', '110715', 'Balee', 4),
	('1107152028', '110715', 'Menje Mesjid', 4),
	('1107152029', '110715', 'Me Tanoh', 4),
	('1107152030', '110715', 'Sialet-Alet', 4),
	('1107152031', '110715', 'Bluk Arab', 4),
	('1107152032', '110715', 'Puuk', 4),
	('1107152033', '110715', 'Dayah Muara', 4),
	('1107152034', '110715', 'Sawiet', 4),
	('1107152035', '110715', 'Ulee Tutue', 4),
	('1107152036', '110715', 'Jim', 4),
	('1107152037', '110715', 'Keutapang', 4),
	('1107152038', '110715', 'Meuleuweuk', 4),
	('1107152039', '110715', 'Jurong', 4),
	('1107152040', '110715', 'Meunasah Raya', 4),
	('1107152041', '110715', 'Meunasah Sukon', 4),
	('1107152042', '110715', 'Mee Krueng Seumideun', 4),
	('1107152043', '110715', 'Meunasah Blang', 4),
	('1107152044', '110715', 'Meunasah Krumbok', 4),
	('1107152045', '110715', 'Ulee Cot Seupeng', 4),
	('1107152046', '110715', 'Meunasah Kabat', 4),
	('1107152049', '110715', 'Kampong Blang Seupeng', 4),
	('1107152050', '110715', 'Kabat', 4),
	('1107162001', '110716', 'Tijue', 4),
	('1107162002', '110716', 'Lampeudue Tunong', 4),
	('1107162003', '110716', 'Pu"uk', 4),
	('1107162004', '110716', 'Lampeudue Baroh', 4),
	('1107162005', '110716', 'Paya', 4),
	('1107162006', '110716', 'Mesjid Reuntoh', 4),
	('1107162007', '110716', 'Dayah Teungoh', 4),
	('1107162008', '110716', 'Baroh', 4),
	('1107162009', '110716', 'Dayah Tanoh', 4),
	('1107162010', '110716', 'Cot Geunduk', 4),
	('1107162011', '110716', 'Tumpok Laweung', 4),
	('1107162012', '110716', 'Ulee Ceue Klibeut', 4),
	('1107162013', '110716', 'Keude Keulibeut', 4),
	('1107162014', '110716', 'Ulee Tutue', 4),
	('1107162015', '110716', 'Dayah Tutong', 4),
	('1107162016', '110716', 'Lampoh Lada', 4),
	('1107162017', '110716', 'Keunire', 4),
	('1107162018', '110716', 'Tumpok.', 4),
	('1107162019', '110716', 'Cot Teungoh', 4),
	('1107162020', '110716', 'Cot Rheng', 4),
	('1107162021', '110716', 'Labue', 4),
	('1107162022', '110716', 'Mns Gampong', 4),
	('1107162023', '110716', 'Pulo Pisang', 4),
	('1107162024', '110716', 'Lam Kuta', 4),
	('1107162025', '110716', 'kampong Pukat', 4),
	('1107162026', '110716', 'Kampong Barat', 4),
	('1107162027', '110716', 'Paloh', 4),
	('1107162028', '110716', 'Kampong Baro', 4),
	('1107162029', '110716', 'Pulo Bubee', 4),
	('1107162030', '110716', 'Tibang', 4),
	('1107162031', '110716', 'Rawa', 4),
	('1107162032', '110716', 'Peukan Baro', 4),
	('1107162033', '110716', 'Mancang', 4),
	('1107162034', '110716', 'Gajah Aye', 4),
	('1107162035', '110716', 'Lhok Keutapang', 4),
	('1107162036', '110716', 'Dalueng', 4),
	('1107162037', '110716', 'Ulee Ceue', 4),
	('1107162038', '110716', 'Meucat', 4),
	('1107162039', '110716', 'Dayah Teubeng', 4),
	('1107162040', '110716', 'Tanjong', 4),
	('1107162041', '110716', 'Jawa', 4),
	('1107162042', '110716', 'Bayu', 4),
	('1107162043', '110716', 'Abo', 4),
	('1107162044', '110716', 'Keutapang', 4),
	('1107162045', '110716', 'Krueng Dhoe', 4),
	('1107162046', '110716', 'Sirong', 4),
	('1107162047', '110716', 'Keutumbu', 4),
	('1107162048', '110716', 'Jeumpa', 4),
	('1107162049', '110716', 'Raya sanggeue', 4),
	('1107162050', '110716', 'Jeuleupee', 4),
	('1107162051', '110716', 'Ujong Langgoe', 4),
	('1107162052', '110716', 'Cot Glumpang', 4),
	('1107162053', '110716', 'Seriweuk', 4),
	('1107162054', '110716', 'Mesjid Utue', 4),
	('1107162055', '110716', 'Leubue', 4),
	('1107162056', '110716', 'Batee', 4),
	('1107162057', '110716', 'Raya Uteu', 4),
	('1107162058', '110716', 'Seukembrok', 4),
	('1107162059', '110716', 'Bie', 4),
	('1107162060', '110716', 'Blang Kula', 4),
	('1107162061', '110716', 'ALue', 4),
	('1107162062', '110716', 'Seuke', 4),
	('1107162063', '110716', 'Paya Linteung', 4),
	('1107162064', '110716', 'Puli', 4),
	('1107172001', '110717', 'Balee Tanoh', 4),
	('1107172002', '110717', 'Balee Kulu', 4),
	('1107172003', '110717', 'Meunasah Empeh', 4),
	('1107172004', '110717', 'Cot Sukon', 4),
	('1107172005', '110717', 'Mns Dayah Tuha', 4),
	('1107172006', '110717', 'Kampong Cot', 4),
	('1107172007', '110717', 'Paloh Jeureula', 4),
	('1107172008', '110717', 'Barieh', 4),
	('1107172009', '110717', 'Kandang', 4),
	('1107172010', '110717', 'Riweuek', 4),
	('1107172011', '110717', 'Mancang', 4),
	('1107172012', '110717', 'Kampong P. Bucue', 4),
	('1107172013', '110717', 'Bucue', 4),
	('1107172014', '110717', 'Lhok Panah', 4),
	('1107172015', '110717', 'Murong Cot', 4),
	('1107172016', '110717', 'Cumbok Lie', 4),
	('1107172017', '110717', 'Jam Ujong', 4),
	('1107172018', '110717', 'Murong Lhok', 4),
	('1107172019', '110717', 'Blang Cut', 4),
	('1107172020', '110717', 'Cot Cantek', 4),
	('1107172021', '110717', 'Blang Kumot Baroh', 4),
	('1107172022', '110717', 'B. Kumot Tunong', 4),
	('1107172023', '110717', 'Cumbok Niwa', 4),
	('1107172024', '110717', 'Leupeuem Mesjid', 4),
	('1107172025', '110717', 'Pulo Jeumpa', 4),
	('1107172026', '110717', 'Beutong Pocut', 4),
	('1107172027', '110717', 'Beutong Peureulat', 4),
	('1107172028', '110717', 'Gampong Jumpa', 4),
	('1107172029', '110717', 'Pantee Krueng', 4),
	('1107172030', '110717', 'Jurong Pante', 4),
	('1107172032', '110717', 'Lamkuta', 4),
	('1107172033', '110717', 'Mali Mns Uke', 4),
	('1107172034', '110717', 'Mns Mali Mesjid', 4),
	('1107172035', '110717', 'Mali Cot', 4),
	('1107172036', '110717', 'Tangkueng', 4),
	('1107172037', '110717', 'Lhok Mee', 4),
	('1107172038', '110717', 'Mns Raya', 4),
	('1107172039', '110717', 'Mns Baro', 4),
	('1107172040', '110717', 'Mns Lueng', 4),
	('1107172041', '110717', 'Pulo Kreumbok', 4),
	('1107172042', '110717', 'Mns Raya Kp Pisang', 4),
	('1107172043', '110717', 'Mns Blang Sakti', 4),
	('1107172044', '110717', 'Perlak Baroh', 4),
	('1107172045', '110717', 'Lingkok', 4),
	('1107172046', '110717', 'Pasar Kota Bakti', 4),
	('1107172047', '110717', 'Mns Balee', 4),
	('1107172048', '110717', 'Perlak Asan', 4),
	('1107172049', '110717', 'Gampong Baroh', 4),
	('1107172050', '110717', 'Mali Guyui', 4),
	('1107182001', '110718', 'Mns Raya Paya', 4),
	('1107182002', '110718', 'Mesjid Bungie', 4),
	('1107182003', '110718', 'Mns Liliet', 4),
	('1107182004', '110718', 'Ujong Baroh', 4),
	('1107182005', '110718', 'Peukan Sot', 4),
	('1107182006', '110718', 'Mns Sukon', 4),
	('1107182007', '110718', 'Raya Paleue', 4),
	('1107182008', '110718', 'Lambideng', 4),
	('1107182009', '110718', 'Cot Paleu', 4),
	('1107182010', '110718', 'Seukee', 4),
	('1107182011', '110718', 'Cebrek', 4),
	('1107182012', '110718', 'Linggong Sagoe', 4),
	('1107182013', '110718', 'Kulam Baro', 4),
	('1107182014', '110718', 'Meunasah Empeh', 4),
	('1107182015', '110718', 'Meunasah Nien', 4),
	('1107182016', '110718', 'Ceureucok Timur', 4),
	('1107182017', '110718', 'Ceureukcok Barat', 4),
	('1107182018', '110718', 'Jaja Baroh', 4),
	('1107182019', '110718', 'Jaja Tunong', 4),
	('1107182020', '110718', 'Mesjid Gigieng', 4),
	('1107182021', '110718', 'Meunasah Gong', 4),
	('1107182022', '110718', 'Pulo Raya', 4),
	('1107182023', '110718', 'Pulo Blang', 4),
	('1107182024', '110718', 'Mamplam', 4),
	('1107182025', '110718', 'Meunasah Lhee', 4),
	('1107182026', '110718', 'Meunasah Pante', 4),
	('1107182027', '110718', 'Kupula', 4),
	('1107182028', '110718', 'Mantak Raya', 4),
	('1107182029', '110718', 'Peukan Tuha', 4),
	('1107182030', '110718', 'Dayah Lampoh Awe', 4),
	('1107182031', '110718', 'Meunasah Blang', 4),
	('1107182032', '110718', 'Pulo Gajah Mate', 4),
	('1107182033', '110718', 'Seuk Ceukok', 4),
	('1107182034', '110718', 'Pulo Tu', 4),
	('1107182035', '110718', 'Jurong', 4),
	('1107182036', '110718', 'Kampong Blang', 4),
	('1107182037', '110718', 'Padang', 4),
	('1107182038', '110718', 'Cot Ara', 4),
	('1107182039', '110718', 'Dayah Bale Cut', 4),
	('1107182040', '110718', 'Teungoh Mangki', 4),
	('1107182041', '110718', 'Dayah Blang', 4),
	('1107182042', '110718', 'Madika', 4),
	('1107182043', '110718', 'Sagoe', 4),
	('1107182044', '110718', 'Cereucok sagoe', 4),
	('1107182045', '110718', 'Bunien', 4),
	('1107182046', '110718', 'Paloh Tok Due', 4),
	('1107182047', '110718', 'Mesjid Tungoe', 4),
	('1107182048', '110718', 'Blang Leuen', 4),
	('1107182049', '110718', 'Ujong Gampong', 4),
	('1107182050', '110718', 'Cot Jaja', 4),
	('1107182051', '110718', 'Lheue', 4),
	('1107182052', '110718', 'Ulee Barat', 4),
	('1107192001', '110719', 'Keudee', 4),
	('1107192002', '110719', 'Pulo Mesjid I', 4),
	('1107192003', '110719', 'Pulo Mesjid II', 4),
	('1107192004', '110719', 'Pulo Sejahtera', 4),
	('1107192005', '110719', 'Pulo Kawa', 4),
	('1107192006', '110719', 'Pulo Seunong', 4),
	('1107192007', '110719', 'Nubok Badeuk', 4),
	('1107192008', '110719', 'Blang Jeurat', 4),
	('1107192009', '110719', 'Pulo Baro', 4),
	('1107192010', '110719', 'Layan', 4),
	('1107192011', '110719', 'Blang Dalam', 4),
	('1107192012', '110719', 'Peunalon I', 4),
	('1107192013', '110719', 'Peunalon II', 4),
	('1107192014', '110719', 'Krueng Meuriyam', 4),
	('1107192015', '110719', 'T. Blang Beungoh', 4),
	('1107192016', '110719', 'Blang Dhot', 4),
	('1107192017', '110719', 'Blang Bungong', 4),
	('1107192018', '110719', 'Ulee Gunong', 4),
	('1107192019', '110719', 'Keubon Nilam', 4),
	('1107192020', '110719', 'Paya Guci', 4),
	('1107192021', '110719', 'Rantau Panyang', 4),
	('1107192022', '110719', 'Blang Malo', 4),
	('1107192023', '110719', 'Krueng Sikeuek', 4),
	('1107192024', '110719', 'Beungga', 4),
	('1107192025', '110719', 'Alue Calong', 4),
	('1107192026', '110719', 'Pulo Lhok', 4),
	('1107192027', '110719', 'Lhok Keutapang', 4),
	('1107212001', '110721', 'Rabo', 4),
	('1107212002', '110721', 'Pulo Siblah', 4),
	('1107212003', '110721', 'Lhok Igeuh', 4),
	('1107212004', '110721', 'Pulo Geulumpang', 4),
	('1107212005', '110721', 'Meunasah Mancang', 4),
	('1107212006', '110721', 'Pulo Tambo', 4),
	('1107212007', '110721', 'Pulo Kemiri', 4),
	('1107212008', '110721', 'Peunadok', 4),
	('1107212009', '110721', 'Pulo Mesjid', 4),
	('1107212010', '110721', 'Meunasah Dayah', 4),
	('1107212011', '110721', 'Trieng Cudo Baroh', 4),
	('1107212012', '110721', 'Trieng Cudo Tunong', 4),
	('1107212013', '110721', 'Mampre', 4),
	('1107212014', '110721', 'Dayah Baroh', 4),
	('1107212015', '110721', 'Dayah Teungoh', 4),
	('1107212016', '110721', 'Dayah KP Baro', 4),
	('1107212017', '110721', 'Dayah Cot', 4),
	('1107212018', '110721', 'Blang Rukui', 4),
	('1107212019', '110721', 'Panton Bunot', 4),
	('1107222001', '110722', 'U Gadeng', 4),
	('1107222002', '110722', 'Kumbang', 4),
	('1107222003', '110722', 'Sagoe', 4),
	('1107222004', '110722', 'Dayah Keumala', 4),
	('1107222005', '110722', 'Jujiem', 4),
	('1107222006', '110722', 'Rheng', 4),
	('1107222007', '110722', 'Cot Neuron', 4),
	('1107222008', '110722', 'Pulo Pantee', 4),
	('1107222009', '110722', 'Pulo Teungoh', 4),
	('1107222010', '110722', 'Asan Nicah', 4),
	('1107222011', '110722', 'Papeun', 4),
	('1107222012', '110722', 'Pulo Seupeng', 4),
	('1107222013', '110722', 'Mesjid Nicah', 4),
	('1107222014', '110722', 'Tunong', 4),
	('1107222015', '110722', 'Pako', 4),
	('1107222016', '110722', 'Pulo Baro', 4),
	('1107222017', '110722', 'Cot Kreh', 4),
	('1107222031', '110722', 'Pulo Cahi', 4),
	('1107242001', '110724', 'Baroh', 4),
	('1107242002', '110724', 'Alue Jojo', 4),
	('1107242003', '110724', 'Kampong Cot Usi', 4),
	('1107242004', '110724', 'Dayah Usi', 4),
	('1107242005', '110724', 'Paloh lhok', 4),
	('1107242006', '110724', 'Campli', 4),
	('1107242007', '110724', 'Mee Tanjong', 4),
	('1107242008', '110724', 'Mesjid Usi', 4),
	('1107242009', '110724', 'Paloh Raya', 4),
	('1107242010', '110724', 'Nibong', 4),
	('1107242011', '110724', 'Baro', 4),
	('1107242012', '110724', 'Rinti', 4),
	('1107242013', '110724', 'Didoh', 4),
	('1107242014', '110724', 'Meugit', 4),
	('1107242015', '110724', 'Empeh', 4),
	('1107242016', '110724', 'Blang Riek', 4),
	('1107242017', '110724', 'Bale Uj. Rimba', 4),
	('1107242018', '110724', 'Mon Ara', 4),
	('1107242019', '110724', 'Kulam Ara', 4),
	('1107242020', '110724', 'Blangon Basah', 4),
	('1107242021', '110724', 'Rambong', 4),
	('1107242022', '110724', 'Kampong Lada', 4),
	('1107242023', '110724', 'Dayah Kumba', 4),
	('1107242024', '110724', 'Cot Khutang', 4),
	('1107242025', '110724', 'Dayah Tanoh', 4),
	('1107242026', '110724', 'Ulee Tutue', 4),
	('1107242027', '110724', 'Beureueh II', 4),
	('1107242028', '110724', 'Mesj. Jeurat Manyang', 4),
	('1107242029', '110724', 'Paloh Tinggi', 4),
	('1107242030', '110724', 'Karieng', 4),
	('1107242031', '110724', 'Sagoe Tumpeun', 4),
	('1107242032', '110724', 'Tong Peuria', 4),
	('1107242033', '110724', 'Tong Weng', 4),
	('1107242034', '110724', 'Pulo Drien', 4),
	('1107242035', '110724', 'Mesjid Gumpueng', 4),
	('1107242036', '110724', 'Ulee Gampong', 4),
	('1107242037', '110724', 'Barieh', 4),
	('1107242038', '110724', 'Jumploih', 4),
	('1107242039', '110724', 'Meunasah Mee', 4),
	('1107242040', '110724', 'Meunasah Dayah', 4),
	('1107242041', '110724', 'Alue Adan', 4),
	('1107242042', '110724', 'Meunasah Rambot', 4),
	('1107242043', '110724', 'Meunasah Meucat', 4),
	('1107242044', '110724', 'Tiba Mesjid', 4),
	('1107242045', '110724', 'Tiba Raya', 4),
	('1107242046', '110724', 'Reubat', 4),
	('1107242047', '110724', 'Blang Simbe', 4),
	('1107242048', '110724', 'Jiem', 4),
	('1107252001', '110725', 'Gintong', 4),
	('1107252002', '110725', 'Mesj. Beureuleung', 4),
	('1107252003', '110725', 'Beureuleung', 4),
	('1107252004', '110725', 'Baroh', 4),
	('1107252005', '110725', 'Meunasah Mee', 4),
	('1107252006', '110725', 'Paya', 4),
	('1107252007', '110725', 'Teungoh', 4),
	('1107252008', '110725', 'Pangge Pilok', 4),
	('1107252009', '110725', 'Karieng', 4),
	('1107252010', '110725', 'Grong-Grong', 4),
	('1107252011', '110725', 'Nicah', 4),
	('1107252012', '110725', 'Mesj. Memeuaneuk', 4),
	('1107252013', '110725', 'Daka', 4),
	('1107252014', '110725', 'Sentosa', 4),
	('1107252015', '110725', 'Sukon', 4),
	('1107272001', '110727', 'Leuuteung', 4),
	('1107272002', '110727', 'Blang Dalam', 4),
	('1107272003', '110727', 'Mane', 4),
	('1107272004', '110727', 'Teu Rucut', 4),
	('1107292001', '110729', 'U. Bungkok', 4),
	('1107292002', '110729', 'Meuteumpeun', 4),
	('1107292003', '110729', 'Kumbang Unoe', 4),
	('1107292004', '110729', 'Mns. Sagoe', 4),
	('1107292005', '110729', 'Geunteng', 4),
	('1107292006', '110729', 'Jurong Baro', 4),
	('1107292007', '110729', 'Sukon Paku', 4),
	('1107292008', '110729', 'Pulo Iboih', 4),
	('1107292009', '110729', 'Sangget', 4),
	('1107292010', '110729', 'Blang Baroh', 4),
	('1107292011', '110729', 'Manyang', 4),
	('1107292012', '110729', 'Pulo Panjoe', 4),
	('1107292013', '110729', 'Bale Gantung', 4),
	('1107292014', '110729', 'Daboih', 4),
	('1107292015', '110729', 'Seureukui Cebrek', 4),
	('1107292016', '110729', 'Glumpang Bungkok', 4),
	('1107292017', '110729', 'Meunasah Ukee', 4),
	('1107292018', '110729', 'K. Trung Campli', 4),
	('1107292019', '110729', 'Palong', 4),
	('1107292020', '110729', 'Seuke', 4),
	('1107292021', '110729', 'Mns. Bungong', 4),
	('1107312001', '110731', 'Lingkok', 4),
	('1107312002', '110731', 'Pante Kulu', 4),
	('1107312003', '110731', 'Uke', 4),
	('1107312004', '110731', 'Pante Siren', 4),
	('1107312005', '110731', 'Pulo Raya', 4),
	('1107312006', '110731', 'Cut', 4),
	('1107312007', '110731', 'Dayah Meunara', 4),
	('1107312008', '110731', 'Paloh Naleung', 4),
	('1107312009', '110731', 'Pulo Lhoih', 4),
	('1107312010', '110731', 'Mesjid Tongpudeng', 4),
	('1107312011', '110731', 'Blang Thoe', 4),
	('1107312012', '110731', 'Asan Tongpudeng', 4),
	('1107312013', '110731', 'Alue', 4),
	('1108012001', '110801', 'Keude Alue Ie Puteh', 4),
	('1108012002', '110801', 'Mnsh Alue I Puteh', 4),
	('1108012003', '110801', 'Pucok Alue', 4),
	('1108012004', '110801', 'Alue Anou Timu', 4),
	('1108012005', '110801', 'Alue Anou Barat', 4),
	('1108012006', '110801', 'Pulo Seuke', 4),
	('1108012007', '110801', 'Alue Serdang', 4),
	('1108012008', '110801', 'Cot Mane', 4),
	('1108012009', '110801', 'Cot Kumbang', 4),
	('1108012010', '110801', 'Matang Kumbang', 4),
	('1108012011', '110801', 'Matang Kareung', 4),
	('1108012012', '110801', 'Cot Ulaya', 4),
	('1108012013', '110801', 'Alue Geudong', 4),
	('1108012014', '110801', 'Tanjong Glumpang', 4),
	('1108012015', '110801', 'Matang Raya Timu', 4),
	('1108012016', '110801', 'Matang Raya Barat', 4),
	('1108012017', '110801', 'Matang Kelayu', 4),
	('1108012018', '110801', 'Alue Buya', 4),
	('1108012019', '110801', 'Matang Cut', 4),
	('1108012020', '110801', 'Keude Panteu Brueh', 4),
	('1108012021', '110801', 'Meudang Ara', 4),
	('1108012022', '110801', 'Meunasah Bujok', 4),
	('1108012023', '110801', 'Alue Dama', 4),
	('1108012024', '110801', 'Cot Ara', 4),
	('1108012025', '110801', 'Rambong Dalam', 4),
	('1108012026', '110801', 'Meunasah Geudong', 4),
	('1108012027', '110801', 'Alue Keutapang', 4),
	('1108012028', '110801', 'Krueng Lingka Barat', 4),
	('1108012029', '110801', 'Krueng Lingka Timu', 4),
	('1108012030', '110801', 'Alue Jambok', 4),
	('1108012031', '110801', 'Alue Bili Geulumpang', 4),
	('1108012032', '110801', 'Lhok Seutuy', 4),
	('1108012033', '110801', 'Alue Bili Rayeuk', 4),
	('1108012034', '110801', 'Keude Menyee IV', 4),
	('1108012035', '110801', 'Geulumpang Bungkok', 4),
	('1108012036', '110801', 'Matang Rawa', 4),
	('1108012037', '110801', 'Glumpang Samlakoe', 4),
	('1108012038', '110801', 'Arongan Lise', 4),
	('1108012039', '110801', 'Matang Reudep', 4),
	('1108012040', '110801', 'Matang Manyam', 4),
	('1108012041', '110801', 'Matang Ulim', 4),
	('1108012042', '110801', 'Matang Beringin', 4),
	('1108012043', '110801', 'Cot Manyang', 4),
	('1108012044', '110801', 'Alue Ie Tarek', 4),
	('1108012045', '110801', 'Alue Rambong', 4),
	('1108012046', '110801', 'Matang Linya', 4),
	('1108012047', '110801', 'Matang Lawang', 4),
	('1108012048', '110801', 'Glumpang payong', 4),
	('1108012049', '110801', 'Mon Sukon', 4),
	('1108012050', '110801', 'Lueng Bata', 4),
	('1108012051', '110801', 'Ceumpeudak', 4),
	('1108012052', '110801', 'Buket Dara Baro', 4),
	('1108012053', '110801', 'Matang Pineung', 4),
	('1108012054', '110801', 'Matang Baro', 4),
	('1108012055', '110801', 'Ujong Dama', 4),
	('1108012056', '110801', 'Babussalam', 4),
	('1108012057', '110801', 'Cinta Makmur', 4),
	('1108022001', '110802', 'Keude Kr. Geukuh', 4),
	('1108022002', '110802', 'Tambon Baroh', 4),
	('1108022003', '110802', 'Tambon Tunong', 4),
	('1108022004', '110802', 'Paloh Gadeng', 4),
	('1108022005', '110802', 'Paloh Lada', 4),
	('1108022006', '110802', 'Uteun Gelinggang', 4),
	('1108022007', '110802', 'Pulo Rungkom', 4),
	('1108022008', '110802', 'Paloh Igeuh', 4),
	('1108022009', '110802', 'Bangka Jaya', 4),
	('1108022010', '110802', 'Ulee Pulo', 4),
	('1108022011', '110802', 'Ulee Reuleung', 4),
	('1108022012', '110802', 'Glumpang Sulu Tmr.', 4),
	('1108022013', '110802', 'Glumpang Sulu Brt.', 4),
	('1108022014', '110802', 'Bluka Teubai', 4),
	('1108022015', '110802', 'Lancang Barat', 4),
	('1108032001', '110803', 'Meunasah Blang Ara', 4),
	('1108032002', '110803', 'Meunasah Buket', 4),
	('1108032003', '110803', 'Blang Talon', 4),
	('1108032004', '110803', 'Cot Rheu', 4),
	('1108032005', '110803', 'Krueng Manyang', 4),
	('1108032006', '110803', 'Bayu', 4),
	('1108032007', '110803', 'Blang Ado', 4),
	('1108032008', '110803', 'Mnsh Dayah Meunara', 4),
	('1108032009', '110803', 'Meunasah Kumbang', 4),
	('1108032010', '110803', 'Meunyecut Bahagia', 4),
	('1108032011', '110803', 'Lhok Jok', 4),
	('1108032012', '110803', 'Alue Rambee', 4),
	('1108032013', '110803', 'Blang Riek', 4),
	('1108032014', '110803', 'Cempeudak', 4),
	('1108032015', '110803', 'Seuneubok Drien', 4),
	('1108032016', '110803', 'Cot Merbo', 4),
	('1108032017', '110803', 'Keude Blang Ara', 4),
	('1108032018', '110803', 'Keude Krueng', 4),
	('1108032019', '110803', 'Krueng Seunong', 4),
	('1108032020', '110803', 'Pulo Iboih', 4),
	('1108032021', '110803', 'Blang Gurah', 4),
	('1108032022', '110803', 'Guha Uleu', 4),
	('1108032023', '110803', 'Ceumeucat', 4),
	('1108032024', '110803', 'Pulo Barat', 4),
	('1108032025', '110803', 'Pulo Rayeuk', 4),
	('1108032026', '110803', 'Cot Seutui', 4),
	('1108032027', '110803', 'Langkuta', 4),
	('1108032028', '110803', 'Saweuk', 4),
	('1108032029', '110803', 'Meuriya', 4),
	('1108032030', '110803', 'Meunasah Kulam', 4),
	('1108032031', '110803', 'Cot Seumiyong', 4),
	('1108032032', '110803', 'Keureusek', 4),
	('1108032033', '110803', 'Krueng Seupeng', 4),
	('1108032034', '110803', 'Meuling Manyang', 4),
	('1108032035', '110803', 'Muling Meucat', 4),
	('1108032036', '110803', 'Babah Lueng', 4),
	('1108032037', '110803', 'Panton Rayeuk I', 4),
	('1108032038', '110803', 'Panton Reyaeuk II', 4),
	('1108032039', '110803', 'Sido Muliyo', 4),
	('1108042001', '110804', 'Kota Lhoksukon', 4),
	('1108042002', '110804', 'Cot U Sibak', 4),
	('1108042003', '110804', 'Bintang Hu', 4),
	('1108042004', '110804', 'Blang Aman', 4),
	('1108042005', '110804', 'Cot Ara', 4),
	('1108042006', '110804', 'Blang Rubek', 4),
	('1108042007', '110804', 'Nga Matang Ubi', 4),
	('1108042008', '110804', 'Reudep', 4),
	('1108042009', '110804', 'Alue Buket', 4),
	('1108042010', '110804', 'Meunyeu Matang Ubi', 4),
	('1108042011', '110804', 'Trieng Matang Ubi', 4),
	('1108042012', '110804', 'Ceubrek', 4),
	('1108042013', '110804', 'Blang', 4),
	('1108042014', '110804', 'Buket Seuntang', 4),
	('1108042015', '110804', 'Arongan Ara Bungkok', 4),
	('1108042016', '110804', 'Trieng Pantang', 4),
	('1108042017', '110804', 'Leubok', 4),
	('1108042018', '110804', 'Cot Glumpang', 4),
	('1108042019', '110804', 'Abeuk Leupon', 4),
	('1108042020', '110804', 'Ara', 4),
	('1108042021', '110804', 'Mancang', 4),
	('1108042022', '110804', 'Matang Pupanji', 4),
	('1108042023', '110804', 'Asan Ara Bungkok', 4),
	('1108042024', '110804', 'Matang Teungoh AB', 4),
	('1108042025', '110804', 'Pante', 4),
	('1108042026', '110804', 'Rambot', 4),
	('1108042027', '110804', 'Alue Drien', 4),
	('1108042028', '110804', 'Alue Meudem', 4),
	('1108042029', '110804', 'Geulingang', 4),
	('1108042030', '110804', 'Asan Lhoksukon Brt', 4),
	('1108042031', '110804', 'Beuringin', 4),
	('1108042032', '110804', 'Teungoh LB', 4),
	('1108042033', '110804', 'Rayeuk', 4),
	('1108042034', '110804', 'Ulee Barat', 4),
	('1108042035', '110804', 'Ranto', 4),
	('1108042036', '110804', 'Tutong', 4),
	('1108042037', '110804', 'Nga Lhoksukon Brt', 4),
	('1108042038', '110804', 'Keutapang', 4),
	('1108042039', '110804', 'Matang Munjee', 4),
	('1108042040', '110804', 'Pulo Dulang', 4),
	('1108042041', '110804', 'Dayah LB', 4),
	('1108042042', '110804', 'Geumata', 4),
	('1108042043', '110804', 'Meureubo', 4),
	('1108042044', '110804', 'Dayah Lhoksukon Teungoh', 4),
	('1108042045', '110804', 'Arongan LT', 4),
	('1108042046', '110804', 'Tuha', 4),
	('1108042047', '110804', 'Krueng', 4),
	('1108042048', '110804', 'Babah Geudeubang', 4),
	('1108042049', '110804', 'Grong-grong', 4),
	('1108042050', '110804', 'Alue Itam Reudep', 4),
	('1108042051', '110804', 'Teupin Keubeu', 4),
	('1108042052', '110804', 'Nga Lhoksukon Tgh.', 4),
	('1108042053', '110804', 'Meuria', 4),
	('1108042054', '110804', 'Kumbang', 4),
	('1108042055', '110804', 'Seneubok Dalam', 4),
	('1108042056', '110804', 'Aleu Empok', 4),
	('1108042057', '110804', 'Jok', 4),
	('1108042058', '110804', 'Manyang', 4),
	('1108042059', '110804', 'Lhok Kareung', 4),
	('1108042060', '110804', 'Cot Asan', 4),
	('1108042061', '110804', 'Alue Abee', 4),
	('1108042062', '110804', 'Buloh', 4),
	('1108042063', '110804', 'Glumpang', 4),
	('1108042064', '110804', 'Teungoh LT', 4),
	('1108042065', '110804', 'Mata U', 4),
	('1108042066', '110804', 'Meucat', 4),
	('1108042067', '110804', 'Buket Me', 4),
	('1108042068', '110804', 'Ulee Tanoh', 4),
	('1108042069', '110804', 'Buket Kreung', 4),
	('1108042070', '110804', 'Ulee Gunong', 4),
	('1108042071', '110804', 'Lhok Seuntang', 4),
	('1108042072', '110804', 'Alue Itam Baroh', 4),
	('1108042073', '110804', 'Mata Ie', 4),
	('1108042074', '110804', 'Rawa', 4),
	('1108042075', '110804', 'Buket Hagu', 4),
	('1108052001', '110805', 'Keude Matangkuli', 4),
	('1108052002', '110805', 'Ude', 4),
	('1108052003', '110805', 'Blang Matangkuli', 4),
	('1108052004', '110805', 'Rayeuk Matangkuli', 4),
	('1108052005', '110805', 'Tumpok Perlak', 4),
	('1108052006', '110805', 'Ujong Kulam', 4),
	('1108052007', '110805', 'Tanjong Teungku Ali', 4),
	('1108052008', '110805', 'Rayek Glang Glong', 4),
	('1108052009', '110805', 'Punti Glumpang VII', 4),
	('1108052010', '110805', 'Glumpang VII', 4),
	('1108052011', '110805', 'Teungoh Glumpang VII', 4),
	('1108052012', '110805', 'Aron Glumpang VII', 4),
	('1108052013', '110805', 'Matang Menye', 4),
	('1108052014', '110805', 'Parang Sikureung', 4),
	('1108052015', '110805', 'Baro', 4),
	('1108052016', '110805', 'Mee', 4),
	('1108052017', '110805', 'Tanjong Babah Krueng', 4),
	('1108052018', '110805', 'Punti Matangkuli', 4),
	('1108052019', '110805', 'Teupin Keubue', 4),
	('1108052020', '110805', 'Trieng Teupin Keubue', 4),
	('1108052021', '110805', 'Matang Mee', 4),
	('1108052022', '110805', 'Jeumpa Glumpang VII', 4),
	('1108052034', '110805', 'Tumpok Barat', 4),
	('1108052035', '110805', 'Meuria Matangkuli', 4),
	('1108052036', '110805', 'Hagu', 4),
	('1108052037', '110805', 'Alue Tho', 4),
	('1108052039', '110805', 'Ceubrek Pirak', 4),
	('1108052040', '110805', 'Rayeuk Pirak', 4),
	('1108052041', '110805', 'Aron Pirak', 4),
	('1108052042', '110805', 'Lawang', 4),
	('1108052043', '110805', 'Tanjong Haji Muda', 4),
	('1108052044', '110805', 'Siren', 4),
	('1108052045', '110805', 'Munye Pirak', 4),
	('1108052046', '110805', 'Beuringen Pirak', 4),
	('1108052047', '110805', 'Teungoh Pirak', 4),
	('1108052048', '110805', 'Mesjid Pirak', 4),
	('1108052049', '110805', 'Matang Peusangan', 4),
	('1108052050', '110805', 'Pantee Pirak', 4),
	('1108052052', '110805', 'Leubok Pirak', 4),
	('1108052053', '110805', 'Blang Kuta', 4),
	('1108052054', '110805', 'Blang Supeng', 4),
	('1108052055', '110805', 'Beurancan Pirak', 4),
	('1108052066', '110805', 'Alue Entok', 4),
	('1108052067', '110805', 'Tanjung Tengku Kari', 4),
	('1108052068', '110805', 'Teungoh Seuleumak', 4),
	('1108052069', '110805', 'Seuriweuk', 4),
	('1108052070', '110805', 'Dayah Baro', 4),
	('1108052071', '110805', 'Kunyet Mule', 4),
	('1108052072', '110805', 'Tutong', 4),
	('1108062001', '110806', 'Keude Mane', 4),
	('1108062002', '110806', 'Meunasah Drang', 4),
	('1108062003', '110806', 'Meunasah Baro', 4),
	('1108062004', '110806', 'Meunasah Lhok', 4),
	('1108062005', '110806', 'Cot Seurani', 4),
	('1108062006', '110806', 'Mane Tunong', 4),
	('1108062007', '110806', 'Kuala Dewa', 4),
	('1108062008', '110806', 'Meunasah Pinto', 4),
	('1108062009', '110806', 'Keude Bungkaih', 4),
	('1108062010', '110806', 'Kambam', 4),
	('1108062011', '110806', 'Meunasah Aron', 4),
	('1108062012', '110806', 'Cot Trueng', 4),
	('1108062013', '110806', 'Dakuta', 4),
	('1108062014', '110806', 'Paloh Awe', 4),
	('1108062015', '110806', 'Tanoh Anoe', 4),
	('1108062016', '110806', 'Pante Gurah', 4),
	('1108062017', '110806', 'Teupin Banja', 4),
	('1108062018', '110806', 'Teumpok Beurandang', 4),
	('1108062019', '110806', 'Paloh Raya', 4),
	('1108062020', '110806', 'Panigah', 4),
	('1108062021', '110806', 'Ulee Madon', 4),
	('1108062022', '110806', 'Releut Timu', 4),
	('1108062023', '110806', 'Releut Barat', 4),
	('1108062024', '110806', 'Pinto Makmur', 4),
	('1108072001', '110807', 'Dayah Bluek', 4),
	('1108072002', '110807', 'Mesjid Bluek', 4),
	('1108072003', '110807', 'Meuria Bluek', 4),
	('1108072004', '110807', 'Rheng Bluek', 4),
	('1108072005', '110807', 'Pulo Bluek', 4),
	('1108072006', '110807', 'Rangkileh', 4),
	('1108072007', '110807', 'Rayeuk Matang', 4),
	('1108072008', '110807', 'Ulee Meuria', 4),
	('1108072009', '110807', 'Tanjong', 4),
	('1108072010', '110807', 'Keude Karieng', 4),
	('1108072011', '110807', 'Manyang', 4),
	('1108072012', '110807', 'Ulee Ceubrek', 4),
	('1108072013', '110807', 'Tumpok Teungku', 4),
	('1108072014', '110807', 'Geulumpang', 4),
	('1108072015', '110807', 'Reudeup', 4),
	('1108072016', '110807', 'Barat Paya Itek', 4),
	('1108072017', '110807', 'Paya Kambuk', 4),
	('1108072018', '110807', 'Paya Bili', 4),
	('1108072019', '110807', 'Mee', 4),
	('1108072020', '110807', 'Nga', 4),
	('1108072021', '110807', 'Ubit Paya Itek', 4),
	('1108072022', '110807', 'Rayeuk Paya Itek', 4),
	('1108072023', '110807', 'Blang Cut', 4),
	('1108072024', '110807', 'Keh', 4),
	('1108072025', '110807', 'Kumbang', 4),
	('1108072026', '110807', 'Pri Keutapang', 4),
	('1108072027', '110807', 'Mesjid', 4),
	('1108072028', '110807', 'Teungoh Reuba', 4),
	('1108072029', '110807', 'Blang Reuma', 4),
	('1108072030', '110807', 'Drien Puntong', 4),
	('1108072031', '110807', 'Pulo Kiton', 4),
	('1108072032', '110807', 'Cibrek', 4),
	('1108072033', '110807', 'Meunye Peut', 4),
	('1108072034', '110807', 'Beuringen', 4),
	('1108072035', '110807', 'Nibong', 4),
	('1108072036', '110807', 'Tualang', 4),
	('1108072037', '110807', 'Pulo Drien Beukah', 4),
	('1108072038', '110807', 'Teungoh K. Batee', 4),
	('1108072039', '110807', 'Ujung Kuta Batee', 4),
	('1108072040', '110807', 'Pulo Blang', 4),
	('1108072041', '110807', 'Leubeuk Tuwe', 4),
	('1108072042', '110807', 'Baroh Kuta Batee', 4),
	('1108072043', '110807', 'Gampong Teungoh', 4),
	('1108072044', '110807', 'Ranto', 4),
	('1108072045', '110807', 'Meunye Payong', 4),
	('1108072046', '110807', 'Ujong Reuba', 4),
	('1108072047', '110807', 'Paya Sutra', 4),
	('1108072048', '110807', 'Bare Blang', 4),
	('1108072049', '110807', 'Keude Jungka Gajah', 4),
	('1108072050', '110807', 'Saramaba', 4),
	('1108082001', '110808', 'Pie', 4),
	('1108082002', '110808', 'Asan', 4),
	('1108082003', '110808', 'Murong', 4),
	('1108082004', '110808', 'Blang Kabu', 4),
	('1108082005', '110808', 'Mancang', 4),
	('1108082006', '110808', 'Keude Geudong', 4),
	('1108082007', '110808', 'Blang Peuria', 4),
	('1108082008', '110808', 'Teupin Ara', 4),
	('1108082009', '110808', 'Teupin Beulangan', 4),
	('1108082010', '110808', 'Kr. Baro Langkahan', 4),
	('1108082011', '110808', 'Pusong', 4),
	('1108082012', '110808', 'Tanjong Kleng', 4),
	('1108082013', '110808', 'Gampong Baro', 4),
	('1108082014', '110808', 'Beuringen', 4),
	('1108082015', '110808', 'Kuta Krueng', 4),
	('1108082016', '110808', 'Kuta Glumpang', 4),
	('1108082017', '110808', 'Meucat', 4),
	('1108082018', '110808', 'Krueng Baro BM', 4),
	('1108082019', '110808', 'Ujong', 4),
	('1108082020', '110808', 'Mesjid', 4),
	('1108082021', '110808', 'Teungoh', 4),
	('1108082022', '110808', 'Keude Blang Mee PK', 4),
	('1108082023', '110808', 'Puuk', 4),
	('1108082024', '110808', 'Lancang', 4),
	('1108082025', '110808', 'Matang Ulim', 4),
	('1108082026', '110808', 'Sawang', 4),
	('1108082027', '110808', 'Laga Baro', 4),
	('1108082028', '110808', 'Pulo', 4),
	('1108082029', '110808', 'Matang Tunong', 4),
	('1108082030', '110808', 'Matang Puntong', 4),
	('1108082031', '110808', 'Blang Nibong', 4),
	('1108082032', '110808', 'Tanjong Baroh', 4),
	('1108082033', '110808', 'Tanjong Hagu', 4),
	('1108082034', '110808', 'Tanjong Rengkam', 4),
	('1108082035', '110808', 'Tanjong Mesjid', 4),
	('1108082036', '110808', 'Paya Terbang', 4),
	('1108082037', '110808', 'Madan', 4),
	('1108082038', '110808', 'Tanjong Awe', 4),
	('1108082039', '110808', 'Kitou', 4),
	('1108082040', '110808', 'Krueng Matee', 4),
	('1108092001', '110809', 'Tanjong Pineng', 4),
	('1108092002', '110809', 'Merbo Puntong', 4),
	('1108092003', '110809', 'Mane Kawan', 4),
	('1108092004', '110809', 'Alue Bareuh', 4),
	('1108092005', '110809', 'Keude Simpang Jln', 4),
	('1108092006', '110809', 'Blang Pha', 4),
	('1108092007', '110809', 'Alue Kiran', 4),
	('1108092008', '110809', 'Blang Tue', 4),
	('1108092009', '110809', 'Cot Kafiraton', 4),
	('1108092010', '110809', 'Tanjong Dama', 4),
	('1108092011', '110809', 'Paya Dua Uram', 4),
	('1108092012', '110809', 'Paya Dua Ujong', 4),
	('1108092013', '110809', 'Alue Capli', 4),
	('1108092014', '110809', 'Simpang Peut', 4),
	('1108092015', '110809', 'Meunasah Sagoe', 4),
	('1108092016', '110809', 'Matang Puntong', 4),
	('1108092017', '110809', 'Matang Panyang', 4),
	('1108092018', '110809', 'Cot Patisah', 4),
	('1108092019', '110809', 'Cot Trueng', 4),
	('1108092020', '110809', 'Darul Aman', 4),
	('1108092021', '110809', 'Matang Jeulikat', 4),
	('1108092022', '110809', 'Lhok Puuk', 4),
	('1108092023', '110809', 'Ulee Rubek Barat', 4),
	('1108092024', '110809', 'Ulee Rubek Timu', 4),
	('1108092025', '110809', 'Bantayan', 4),
	('1108092026', '110809', 'Teupin Kuyun', 4),
	('1108092027', '110809', 'Matang Lada', 4),
	('1108092028', '110809', 'Ule Matang', 4),
	('1108092029', '110809', 'Matang Karieng', 4),
	('1108092030', '110809', 'Lhok Rambideng', 4),
	('1108092031', '110809', 'Matang Anoe', 4),
	('1108092032', '110809', 'Lhok Geulitut', 4),
	('1108092033', '110809', 'Ulee Titi', 4),
	('1108102001', '110810', 'Keude Aron', 4),
	('1108102002', '110810', 'Dayah Aron', 4),
	('1108102003', '110810', 'Moncrang', 4),
	('1108102004', '110810', 'Kanot', 4),
	('1108102005', '110810', 'Meuria Aron', 4),
	('1108102006', '110810', 'Me Aron', 4),
	('1108102007', '110810', 'Glok', 4),
	('1108102008', '110810', 'Cibrek Baroh', 4),
	('1108102009', '110810', 'Cibrek Tunong', 4),
	('1108102010', '110810', 'Matang Munye', 4),
	('1108102011', '110810', 'Pante', 4),
	('1108102012', '110810', 'Keutapang', 4),
	('1108102013', '110810', 'Blang', 4),
	('1108102014', '110810', 'Teungoh', 4),
	('1108102015', '110810', 'Tanjong Krueng Pase', 4),
	('1108102016', '110810', 'Mesjid', 4),
	('1108102017', '110810', 'Keude Teupin Punti', 4),
	('1108102018', '110810', 'Kumbang', 4),
	('1108102019', '110810', 'U Blang Asan', 4),
	('1108102020', '110810', 'Calong', 4),
	('1108102021', '110810', 'Manyang Baroh', 4),
	('1108102022', '110810', 'Peureupok', 4),
	('1108102023', '110810', 'Alue Ganto', 4),
	('1108102024', '110810', 'Pulo Blang Asan', 4),
	('1108102025', '110810', 'Kulam', 4),
	('1108102026', '110810', 'Ampeh', 4),
	('1108102027', '110810', 'Dayah Meuria', 4),
	('1108102028', '110810', 'Mampre', 4),
	('1108102029', '110810', 'Meucat', 4),
	('1108102030', '110810', 'Ara', 4),
	('1108102031', '110810', 'Hagu', 4),
	('1108102032', '110810', 'Awe', 4),
	('1108102033', '110810', 'Tanjong Meuling', 4),
	('1108102034', '110810', 'Daya Teungku', 4),
	('1108112001', '110811', 'Bale', 4),
	('1108112002', '110811', 'Bie', 4),
	('1108112003', '110811', 'Beurandang', 4),
	('1108112004', '110811', 'Baro Kulam Gajah', 4),
	('1108112005', '110811', 'Glong', 4),
	('1108112006', '110811', 'Nibong', 4),
	('1108112007', '110811', 'Langa', 4),
	('1108112008', '110811', 'Beunot', 4),
	('1108112009', '110811', 'Keude Bayu', 4),
	('1108112010', '110811', 'Blang Bayu', 4),
	('1108112011', '110811', 'Dayah Tuda', 4),
	('1108112012', '110811', 'Dayah Baro', 4),
	('1108112013', '110811', 'Lancok', 4),
	('1108112014', '110811', 'Punti', 4),
	('1108112015', '110811', 'Bungong', 4),
	('1108112016', '110811', 'Baroh Blang Rimueng', 4),
	('1108112017', '110811', 'Ulee Meuria', 4),
	('1108112018', '110811', 'Kayee Panyang', 4),
	('1108112019', '110811', 'Rheng', 4),
	('1108112020', '110811', 'Trieng Meuduro', 4),
	('1108112021', '110811', 'Ulee Gampong', 4),
	('1108112022', '110811', 'Garot', 4),
	('1108112023', '110811', 'Blang Awe', 4),
	('1108112024', '110811', 'Pulo Blang Mangat', 4),
	('1108112025', '110811', 'Cebrek', 4),
	('1108112026', '110811', 'Pulo Blang Trieng', 4),
	('1108112027', '110811', 'Meudang Ara', 4),
	('1108112028', '110811', 'Cot Neuheum', 4),
	('1108112029', '110811', 'Tumpeun', 4),
	('1108112030', '110811', 'Alen', 4),
	('1108112031', '110811', 'Dayah B. Sereikuy', 4),
	('1108112032', '110811', 'Blang Patra', 4),
	('1108112033', '110811', 'Blang Majron', 4),
	('1108112034', '110811', 'Seuneubok Baro', 4),
	('1108112035', '110811', 'Buket Glumpang', 4),
	('1108112037', '110811', 'Alue Majron', 4),
	('1108112038', '110811', 'Siren Tujoh', 4),
	('1108112047', '110811', 'Blang Serikuy', 4),
	('1108122001', '110812', 'Pulo Blang', 4),
	('1108122002', '110812', 'Matang Ben', 4),
	('1108122003', '110812', 'Matang Cibrek', 4),
	('1108122004', '110812', 'Deng', 4),
	('1108122005', '110812', 'Rawa', 4),
	('1108122006', '110812', 'Punti Pulo Agam', 4),
	('1108122007', '110812', 'Alue Pangkat', 4),
	('1108122008', '110812', 'Teungoh Pulo Agam', 4),
	('1108122009', '110812', 'Hueng', 4),
	('1108122010', '110812', 'Pulo U', 4),
	('1108122011', '110812', 'Alue Keujruen', 4),
	('1108122012', '110812', 'Paya Berandang', 4),
	('1108122013', '110812', 'Manyang Tunong', 4),
	('1108122014', '110812', 'Tutong', 4),
	('1108122015', '110812', 'Ampeh', 4),
	('1108122016', '110812', 'Alue', 4),
	('1108122017', '110812', 'Teungku Dibalee', 4),
	('1108122018', '110812', 'Keude Blang Jruen', 4),
	('1108122019', '110812', 'Blang Jruen', 4),
	('1108122020', '110812', 'Uj. Baroh Berghang', 4),
	('1108122021', '110812', 'Jeumpa', 4),
	('1108122022', '110812', 'Teungoh Berghang', 4),
	('1108122023', '110812', 'Pante', 4),
	('1108122024', '110812', 'Serba Jaman', 4),
	('1108122025', '110812', 'Rayeuk Naleung', 4),
	('1108122026', '110812', 'Rangkaya', 4),
	('1108122027', '110812', 'Paya', 4),
	('1108122028', '110812', 'Blang Bidok', 4),
	('1108122029', '110812', 'Rayeuk Kuta', 4),
	('1108122030', '110812', 'Rayeuk Munye', 4),
	('1108122031', '110812', 'Ujong Baroh SB', 4),
	('1108122032', '110812', 'Trieng', 4),
	('1108122033', '110812', 'Manyang', 4),
	('1108122034', '110812', 'Cibrek', 4),
	('1108122035', '110812', 'Keutapang', 4),
	('1108122036', '110812', 'Matang Mane', 4),
	('1108122037', '110812', 'Alue Gampong', 4),
	('1108122038', '110812', 'Bayi', 4),
	('1108122039', '110812', 'Tumpok Aceh', 4),
	('1108122040', '110812', 'Ulee Buket', 4),
	('1108122041', '110812', 'Cot Dah', 4),
	('1108122042', '110812', 'Leupon Siren', 4),
	('1108122043', '110812', 'Blang Trieng', 4),
	('1108122044', '110812', 'Alue Sijuek', 4),
	('1108122045', '110812', 'Hagu', 4),
	('1108122046', '110812', 'Teupin Me', 4),
	('1108122047', '110812', 'Plu Pukam', 4),
	('1108122048', '110812', 'Blang Pie', 4),
	('1108122049', '110812', 'Punti Seuleumak Brt.', 4),
	('1108122050', '110812', 'Serba Yaman Tunong', 4),
	('1108122051', '110812', 'Leuhong', 4),
	('1108122052', '110812', 'Blang', 4),
	('1108122053', '110812', 'Tanjong Mesjid', 4),
	('1108122054', '110812', 'Serba Yaman Baroh', 4),
	('1108122055', '110812', 'Cot Barat', 4),
	('1108122056', '110812', 'Matang Baloi', 4),
	('1108122057', '110812', 'Buket Makarti', 4),
	('1108132001', '110813', 'Alue', 4),
	('1108132002', '110813', 'Me Matang Panyang', 4),
	('1108132003', '110813', 'Blang', 4),
	('1108132004', '110813', 'Paloh', 4),
	('1108132005', '110813', 'Keude Matang Pyg', 4),
	('1108132006', '110813', 'Gampong pande', 4),
	('1108132007', '110813', 'Matang Ranup Laseh', 4),
	('1108132008', '110813', 'Cangguek', 4),
	('1108132009', '110813', 'Kumbang', 4),
	('1108132010', '110813', 'Prey', 4),
	('1108132011', '110813', 'Keutapang', 4),
	('1108132012', '110813', 'Keude Jrat Manyang', 4),
	('1108132013', '110813', 'Teupin Gapeuh', 4),
	('1108132014', '110813', 'Cibrek', 4),
	('1108132015', '110813', 'Me Meureubo', 4),
	('1108132016', '110813', 'Ulee Tanoh', 4),
	('1108132017', '110813', 'Matang Janeng', 4),
	('1108132018', '110813', 'Kuala Keureuteu Barat', 4),
	('1108142001', '110814', 'Teupin Gajah', 4),
	('1108142002', '110814', 'Glumpang Umpong Unou', 4),
	('1108142003', '110814', 'Ranto Panyang', 4),
	('1108142004', '110814', 'Seuneubok D', 4),
	('1108142005', '110814', 'Meunasah Geudong', 4),
	('1108142006', '110814', 'Meunasah Merbo', 4),
	('1108142007', '110814', 'Tanjong Meunye', 4),
	('1108142008', '110814', 'Matang Jurong', 4),
	('1108142009', '110814', 'Tanjong Dalam Utara', 4),
	('1108142010', '110814', 'Meunasah Dayah', 4),
	('1108142011', '110814', 'Seuneubok Pidie', 4),
	('1108142012', '110814', 'Tanjong Menuang', 4),
	('1108142013', '110814', 'Matang Teungoh-Teungoh', 4),
	('1108142014', '110814', 'Lhok Reudeup', 4),
	('1108142015', '110814', 'Lhok Merbo', 4),
	('1108142016', '110814', 'Tanjong Ara', 4),
	('1108142017', '110814', 'Alue Ie Mirah', 4),
	('1108142018', '110814', 'Tanjong Punti', 4),
	('1108142019', '110814', 'Bukit Alue Puteh', 4),
	('1108142020', '110814', 'Buket Jrat Manyang', 4),
	('1108142021', '110814', 'Matang Maneh', 4),
	('1108142022', '110814', 'Pucok Alue', 4),
	('1108142023', '110814', 'Matang Serdang', 4),
	('1108142024', '110814', 'Matang Santot', 4),
	('1108142025', '110814', 'Buket Padang', 4),
	('1108142026', '110814', 'Matang Seuke Pulot', 4),
	('1108142027', '110814', 'Lhok Beuringin', 4),
	('1108142028', '110814', 'Lueng Tuha', 4),
	('1108142029', '110814', 'Matang Raya', 4),
	('1108142030', '110814', 'Tanjong Cengai', 4),
	('1108142031', '110814', 'Teupin Bayu', 4),
	('1108142032', '110814', 'Meunasah Panton Labu', 4),
	('1108142033', '110814', 'Kota Panton Labu', 4),
	('1108142034', '110814', 'Rawang Itek', 4),
	('1108142035', '110814', 'Sama Kurok', 4),
	('1108142036', '110814', 'Biara Barat', 4),
	('1108142037', '110814', 'Biara Timur', 4),
	('1108142038', '110814', 'Matang Drien', 4),
	('1108142039', '110814', 'Ceumpeudak', 4),
	('1108142040', '110814', 'Alue Papeun', 4),
	('1108142041', '110814', 'Lhok Bintang Hu', 4),
	('1108142042', '110814', 'Biram Rayeuk', 4),
	('1108142043', '110814', 'Cot Biek', 4),
	('1108142044', '110814', 'Matang Arongan', 4),
	('1108142045', '110814', 'Biram Cut', 4),
	('1108142046', '110814', 'Buket Batee Badan', 4),
	('1108142047', '110814', 'Ulee Glee', 4),
	('1108152001', '110815', 'Lagang', 4),
	('1108152002', '110815', 'Abeuk Reuling', 4),
	('1108152003', '110815', 'Lhok Krek', 4),
	('1108152004', '110815', 'Lhok Merbo', 4),
	('1108152005', '110815', 'Gle Dagang', 4),
	('1108152006', '110815', 'Kuta Meuligoe', 4),
	('1108152007', '110815', 'Gampong Teungoh', 4),
	('1108152008', '110815', 'Babah Buloh', 4),
	('1108152009', '110815', 'Meunasah Pulo', 4),
	('1108152010', '110815', 'Punteut', 4),
	('1108152011', '110815', 'Pante Jaloh', 4),
	('1108152012', '110815', 'Lhok Kuyun', 4),
	('1108152013', '110815', 'Blang Reuling', 4),
	('1108152014', '110815', 'Lhok Gajah', 4),
	('1108152015', '110815', 'Teupin Reuseb', 4),
	('1108152016', '110815', 'Ulee Geudong', 4),
	('1108152017', '110815', 'Tanjong Keumala', 4),
	('1108152018', '110815', 'Cot Keumuneng', 4),
	('1108152019', '110815', 'Cot Lambideng', 4),
	('1108152020', '110815', 'Paya Gaboh', 4),
	('1108152021', '110815', 'Paya Rabo Lhok', 4),
	('1108152022', '110815', 'Paya Rabo Timu', 4),
	('1108152023', '110815', 'Lancok', 4),
	('1108152024', '110815', 'Rambong Payong', 4),
	('1108152025', '110815', 'Lhok Bayu', 4),
	('1108152026', '110815', 'Krueng Baro', 4),
	('1108152027', '110815', 'Babah Krueng', 4),
	('1108152028', '110815', 'Jurong', 4),
	('1108152029', '110815', 'Blang Manyak', 4),
	('1108152030', '110815', 'Lhok Jok', 4),
	('1108152031', '110815', 'Blang Teurakan', 4),
	('1108152032', '110815', 'Sawang', 4),
	('1108152033', '110815', 'Riseh Baroh', 4),
	('1108152034', '110815', 'Riseh Teungoh', 4),
	('1108152035', '110815', 'Riseh Tunong', 4),
	('1108152036', '110815', 'Gunci', 4),
	('1108152037', '110815', 'Kubu', 4),
	('1108152038', '110815', 'Blang Cut', 4),
	('1108152039', '110815', 'Lhok Cut', 4),
	('1108162015', '110816', 'Paloh Mambu', 4),
	('1108162017', '110816', 'Blang Karieng', 4),
	('1108162018', '110816', 'Paloh Kayee Kunyet', 4),
	('1108162019', '110816', 'Gampong Barat', 4),
	('1108162020', '110816', 'Meunasah Beunot', 4),
	('1108162021', '110816', 'Seuneubok', 4),
	('1108162022', '110816', 'Cot Leupee', 4),
	('1108162023', '110816', 'Gampong Teungoh', 4),
	('1108162024', '110816', 'Meunasah Meucat', 4),
	('1108162025', '110816', 'Meunasah Alue', 4),
	('1108162026', '110816', 'Panton', 4),
	('1108162027', '110816', 'Paloh Mampre', 4),
	('1108162028', '110816', 'Peunayan', 4),
	('1108162029', '110816', 'Tingkeum', 4),
	('1108162030', '110816', 'Meunasah Rayeuk', 4),
	('1108162031', '110816', 'Meunasah Cut', 4),
	('1108162032', '110816', 'Jeulikat', 4),
	('1108162033', '110816', 'Alue Bilie', 4),
	('1108162034', '110816', 'Cot Mambong', 4),
	('1108162035', '110816', 'Blang D. Geunteng', 4),
	('1108162036', '110816', 'B. Dalam Tunong', 4),
	('1108162037', '110816', 'B. Dalam Baroh', 4),
	('1108162038', '110816', 'Cot Mee', 4),
	('1108162039', '110816', 'Cot Euntong', 4),
	('1108162040', '110816', 'Blang Crok', 4),
	('1108162041', '110816', 'Meunasah Krueng', 4),
	('1108162042', '110816', 'Binjee', 4),
	('1108162043', '110816', 'Keutapang', 4),
	('1108162044', '110816', 'Ulee Blang', 4),
	('1108172001', '110817', 'Cot Girek', 4),
	('1108172002', '110817', 'Meurebo', 4),
	('1108172003', '110817', 'Kampung Bantan', 4),
	('1108172004', '110817', 'Alue Seumambu', 4),
	('1108172005', '110817', 'Ulee Gampong', 4),
	('1108172006', '110817', 'Batu XII', 4),
	('1108172007', '110817', 'Kampung Tempel', 4),
	('1108172008', '110817', 'Alue Leuhob', 4),
	('1108172009', '110817', 'Seuneubok Baro', 4),
	('1108172010', '110817', 'Alue Drien LS', 4),
	('1108172011', '110817', 'Ceumpeudak', 4),
	('1108172012', '110817', 'Matang Teungoh L', 4),
	('1108172013', '110817', 'Pucok Alue', 4),
	('1108172014', '110817', 'U Baro.', 4),
	('1108172015', '110817', 'Trieng Lhoksukon Slt', 4),
	('1108172016', '110817', 'Lhok Reuhat', 4),
	('1108172017', '110817', 'Lueng Baro', 4),
	('1108172018', '110817', 'Jeulikat', 4),
	('1108172019', '110817', 'Ara Lkoksukon Slt', 4),
	('1108172020', '110817', 'Beurandang Dayah', 4),
	('1108172021', '110817', 'Beurandang Krueng', 4),
	('1108172022', '110817', 'Seupeng', 4),
	('1108172023', '110817', 'Beurandang Asan', 4),
	('1108172024', '110817', 'Drien Dua', 4),
	('1108182001', '110818', 'Cot Bada', 4),
	('1108182002', '110818', 'Alue Dua', 4),
	('1108182003', '110818', 'Bantayan', 4),
	('1108182004', '110818', 'Kampong Blang', 4),
	('1108182005', '110818', 'Paya Tukai', 4),
	('1108182006', '110818', 'Matang Keutapang', 4),
	('1108182007', '110818', 'Krueng Lingka', 4),
	('1108182008', '110818', 'Simpang Tiga', 4),
	('1108182009', '110818', 'Matang Rubek', 4),
	('1108182010', '110818', 'Leubok Mane', 4),
	('1108182011', '110818', 'Matang Teungoh Slt', 4),
	('1108182012', '110818', 'Padang Meuria', 4),
	('1108182013', '110818', 'Alue Krak Kayee', 4),
	('1108182014', '110818', 'Tanjong Jawa', 4),
	('1108182015', '110818', 'Meunasah Blang', 4),
	('1108182016', '110818', 'Tanjung Dalam Slt', 4),
	('1108182017', '110818', 'Geudumbak', 4),
	('1108182018', '110818', 'Langkahan', 4),
	('1108182019', '110818', 'Rumoh Rayeuk', 4),
	('1108182020', '110818', 'Buket Linteung', 4),
	('1108182021', '110818', 'Lubok Pusaka', 4),
	('1108182022', '110818', 'Seureuke', 4),
	('1108182023', '110818', 'Pante Gaki Bale', 4),
	('1108192001', '110819', 'Keude Sampoiniet', 4),
	('1108192002', '110819', 'Lhok Iboh', 4),
	('1108192003', '110819', 'Matang Bayu', 4),
	('1108192004', '110819', 'Blang Nibong', 4),
	('1108192005', '110819', 'Blang Seunong', 4),
	('1108192006', '110819', 'Singgah Mata', 4),
	('1108192007', '110819', 'Matang Panyang', 4),
	('1108192008', '110819', 'Matang Ceubrek', 4),
	('1108192009', '110819', 'Matang Teungoh', 4),
	('1108192010', '110819', 'Cot Paya', 4),
	('1108192011', '110819', 'Cot Kupok', 4),
	('1108192012', '110819', 'MPG Raya Blang Sialet', 4),
	('1108192013', '110819', 'Pucok Alue Buket', 4),
	('1108192014', '110819', 'Matang Sijuek Timu', 4),
	('1108192015', '110819', 'Matang Sijuek Teungoh', 4),
	('1108192016', '110819', 'Matang Sijuek Barat', 4),
	('1108192017', '110819', 'Cot Laba', 4),
	('1108192018', '110819', 'Meunasah Pante', 4),
	('1108192019', '110819', 'Meurandeh Raya', 4),
	('1108192020', '110819', 'Cot Murong', 4),
	('1108192021', '110819', 'Matang Paya', 4),
	('1108192022', '110819', 'Lhok Euncien', 4),
	('1108192023', '110819', 'Cot Usen', 4),
	('1108192024', '110819', 'Meunasah Hagu', 4),
	('1108192025', '110819', 'Blang Rheu', 4),
	('1108192026', '110819', 'Paya Bateung', 4),
	('1108202001', '110820', 'Blang Ara', 4),
	('1108202002', '110820', 'T. Dibanda Pirak', 4),
	('1108202003', '110820', 'Paya Meudru', 4),
	('1108202004', '110820', 'Blang Sialet', 4),
	('1108202005', '110820', 'Buket Guru', 4),
	('1108202006', '110820', 'Glumpang Pirak', 4),
	('1108202007', '110820', 'Alue Lhok', 4),
	('1108202008', '110820', 'Seuneubok A', 4),
	('1108202009', '110820', 'Buket Pidie', 4),
	('1108202010', '110820', 'Kebon Pirak', 4),
	('1108202011', '110820', 'Alue Leukot', 4),
	('1108202012', '110820', 'Blang Mane', 4),
	('1108202013', '110820', 'Peureupok', 4),
	('1108202014', '110820', 'Ulue Bieng', 4),
	('1108202015', '110820', 'Pante Seuleumak', 4),
	('1108202016', '110820', 'Meuria Seuleumak', 4),
	('1108202017', '110820', 'Tunong Krueng', 4),
	('1108202018', '110820', 'Geureughek', 4),
	('1108202019', '110820', 'Munnye Seuleumak', 4),
	('1108202020', '110820', 'Simpang', 4),
	('1108202021', '110820', 'Tumpok Mesjid', 4),
	('1108202022', '110820', 'Jok', 4),
	('1108202023', '110820', 'Leuhong', 4),
	('1108202024', '110820', 'Tanjong Beurenyong', 4),
	('1108202025', '110820', 'Keude Paya Bakong', 4),
	('1108202026', '110820', 'Blang Guci', 4),
	('1108202027', '110820', 'Nga', 4),
	('1108202028', '110820', 'Mampree', 4),
	('1108202029', '110820', 'Matang Panyang', 4),
	('1108202030', '110820', 'Tanjung Drien', 4),
	('1108202031', '110820', 'Asan Seuleumak', 4),
	('1108202032', '110820', 'T. Dibanda Tek-Tek', 4),
	('1108202033', '110820', 'Cot Teufah', 4),
	('1108202034', '110820', 'Pucok Alue Seulemak', 4),
	('1108202035', '110820', 'Lueng', 4),
	('1108202036', '110820', 'Ceumpeudak', 4),
	('1108202037', '110820', 'Blang Paku', 4),
	('1108202038', '110820', 'Blang Dalam', 4),
	('1108202039', '110820', 'Blang Pante', 4),
	('1108212001', '110821', 'Nibong Baroh', 4),
	('1108212002', '110821', 'Nibong Wakheuh', 4),
	('1108212003', '110821', 'Keude Nibong', 4),
	('1108212004', '110821', 'Keupok Nibong', 4),
	('1108212005', '110821', 'Dayah Nibong', 4),
	('1108212006', '110821', 'Sumbok Rayeuk', 4),
	('1108212007', '110821', 'Paya Terbang', 4),
	('1108212008', '110821', 'Teupin Jok', 4),
	('1108212009', '110821', 'Mamplam', 4),
	('1108212010', '110821', 'Keulilee', 4),
	('1108212011', '110821', 'Munye Lhee', 4),
	('1108212012', '110821', 'Ranto', 4),
	('1108212013', '110821', 'Seulunyok', 4),
	('1108212014', '110821', 'Keh Nibong', 4),
	('1108212015', '110821', 'Alue Ie Mirah', 4),
	('1108212016', '110821', 'Maddi', 4),
	('1108212017', '110821', 'Alue Ngom', 4),
	('1108212018', '110821', 'Tanjong Putoh', 4),
	('1108212019', '110821', 'Bumban', 4),
	('1108212020', '110821', 'Alue Panah', 4),
	('1108222001', '110822', 'Keude Simpang Empat', 4),
	('1108222002', '110822', 'Seuneubok Punti', 4),
	('1108222003', '110822', 'Paya Leupah', 4),
	('1108222004', '110822', 'Paya Teungoh', 4),
	('1108222005', '110822', 'Kebon Baro', 4),
	('1108222006', '110822', 'Meunasah Teungoh', 4),
	('1108222007', '110822', 'Meunasah Baroeh', 4),
	('1108222008', '110822', 'Mancang', 4),
	('1108222009', '110822', 'Alue Badee', 4),
	('1108222010', '110822', 'Mnsh Dayah Sp.K', 4),
	('1108222011', '110822', 'Kilometer VI', 4),
	('1108222012', '110822', 'Kilometer VIII', 4),
	('1108222013', '110822', 'Ie Tarek I', 4),
	('1108222014', '110822', 'Ie Tarek II', 4),
	('1108222015', '110822', 'Pase Seuntosa', 4),
	('1108222016', '110822', 'Plang Raleu', 4),
	('1108232001', '110823', 'Keureutou', 4),
	('1108232002', '110823', 'Lueng Baro', 4),
	('1108232003', '110823', 'Merbo Jurong', 4),
	('1108232004', '110823', 'Merbo Lama', 4),
	('1108232005', '110823', 'Tanjong Dama', 4),
	('1108232006', '110823', 'Geulanggang Baro', 4),
	('1108232007', '110823', 'Matang Tunong', 4),
	('1108232008', '110823', 'Keude Lapang', 4),
	('1108232009', '110823', 'Matang Baroh', 4),
	('1108232010', '110823', 'Kuala Keurutou', 4),
	('1108232011', '110823', 'Kuala Cangkoi', 4),
	('1108242001', '110824', 'Rayeuk Pange', 4),
	('1108242002', '110824', 'Bungong', 4),
	('1108242003', '110824', 'Geulumpang Matangkuli', 4),
	('1108242004', '110824', 'Asan Krueng Kreh', 4),
	('1108242005', '110824', 'Beuracan Rata', 4),
	('1108242006', '110824', 'Reungkam', 4),
	('1108242007', '110824', 'Trieng Krueng Kreh', 4),
	('1108242008', '110824', 'Keutapang', 4),
	('1108242009', '110824', 'Bili Baro', 4),
	('1108242010', '110824', 'Payo Lueng Jalo', 4),
	('1108242011', '110824', 'Alue Rima', 4),
	('1108242012', '110824', 'Serdang', 4),
	('1108242013', '110824', 'Ara Ton-ton Monerang', 4),
	('1108242014', '110824', 'Tanjong Seurukuy', 4),
	('1108242015', '110824', 'Ulee Blang', 4),
	('1108242016', '110824', 'Krueng', 4),
	('1108242017', '110824', 'Matang Keh', 4),
	('1108242018', '110824', 'Leupe', 4),
	('1108242019', '110824', 'Ceumecet', 4),
	('1108242020', '110824', 'Teupin U', 4),
	('1108242021', '110824', 'Alue Bungkoh', 4),
	('1108242022', '110824', 'Pucok Alue', 4),
	('1108242023', '110824', 'Munye Tujoh', 4),
	('1108252001', '110825', 'Lhok Asan', 4),
	('1108252002', '110825', 'Darul Aman', 4),
	('1108252003', '110825', 'Alue Awe', 4),
	('1108252004', '110825', 'Darussalam', 4),
	('1108252005', '110825', 'Rayeuk Jawa', 4),
	('1108252006', '110825', 'Dayah Seupeng', 4),
	('1108252007', '110825', 'Uram Jalan', 4),
	('1108252008', '110825', 'Peudari', 4),
	('1108252009', '110825', 'Krueng Mbang', 4),
	('1108252010', '110825', 'Pulo Meuria', 4),
	('1108252011', '110825', 'Suka Damai SP I', 4),
	('1108262001', '110826', 'Paya Dua', 4),
	('1108262002', '110826', 'Cot Jabet', 4),
	('1108262003', '110826', 'Ulee Nyeue', 4),
	('1108262004', '110826', 'Paya Ulue', 4),
	('1108262005', '110826', 'Jamuan', 4),
	('1108262006', '110826', 'Alue Keureunyai', 4),
	('1108262007', '110826', 'Sangkalan', 4),
	('1108262008', '110826', 'Blang Pala', 4),
	('1108262009', '110826', 'Paya Beunyet', 4),
	('1108272001', '110827', 'Alue Dua', 4),
	('1108272002', '110827', 'Seumirah', 4),
	('1108272003', '110827', 'Darussalam', 4),
	('1108272004', '110827', 'Alue Papeun', 4),
	('1108272005', '110827', 'Blang Jrat', 4),
	('1108272006', '110827', 'Blang Poroh', 4),
	('1109012007', '110901', 'Wel Wel', 4),
	('1109012008', '110901', 'Kampung Aie', 4),
	('1109012009', '110901', 'Laure - e', 4),
	('1109012010', '110901', 'Lamanyang', 4),
	('1109012011', '110901', 'Lakubang', 4),
	('1109012012', '110901', 'Lambaya', 4),
	('1109012013', '110901', 'Dihit', 4),
	('1109012016', '110901', 'Latitik', 4),
	('1109012017', '110901', 'Welang Kum', 4),
	('1109012018', '110901', 'Kuta Baru', 4),
	('1109012019', '110901', 'Sebbe', 4),
	('1109012020', '110901', 'Suak Baru', 4),
	('1109012021', '110901', 'Luan Sorep', 4),
	('1109012022', '110901', 'Putra Jaya', 4),
	('1109012023', '110901', 'Lauke', 4),
	('1109012024', '110901', 'Situpa Jaya', 4),
	('1109022001', '110902', 'Ujung Salang', 4),
	('1109022002', '110902', 'Padang Anoi', 4),
	('1109022003', '110902', 'Nasreuhe', 4),
	('1109022004', '110902', 'Meunafa', 4),
	('1109022005', '110902', 'Along Jaya', 4),
	('1109022006', '110902', 'Panton Lawe', 4),
	('1109022007', '110902', 'Mutiara', 4),
	('1109022008', '110902', 'Tamon Jaya', 4),
	('1109022009', '110902', 'Karya Bakti', 4),
	('1109022010', '110902', 'Jaya Baru', 4),
	('1109022011', '110902', 'Tameng', 4),
	('1109022012', '110902', 'Lalla Bahagia', 4),
	('1109022013', '110902', 'Suak Manang', 4),
	('1109022014', '110902', 'Ganang Pusako', 4),
	('1109022015', '110902', 'Kenang Jaya', 4),
	('1109022016', '110902', 'Bunga', 4),
	('1109032001', '110903', 'Silengas', 4),
	('1109032002', '110903', 'Bunon', 4),
	('1109032003', '110903', 'Angkeo', 4),
	('1109032004', '110903', 'Awe Seubal', 4),
	('1109032005', '110903', 'Laayon', 4),
	('1109032006', '110903', 'Inor', 4),
	('1109032007', '110903', 'Salur Lasengalu', 4),
	('1109032008', '110903', 'Salur Latun', 4),
	('1109032009', '110903', 'Salur', 4),
	('1109032010', '110903', 'Pulau Teupah', 4),
	('1109032011', '110903', 'Awe Kecil', 4),
	('1109032012', '110903', 'Naibos', 4),
	('1109032013', '110903', 'Lantik', 4),
	('1109032014', '110903', 'Leubang Hulu', 4),
	('1109032015', '110903', 'Leubang', 4),
	('1109032016', '110903', 'Sitai', 4),
	('1109032017', '110903', 'Maudil', 4),
	('1109032018', '110903', 'Nancala', 4),
	('1109042009', '110904', 'Suak Buluh', 4),
	('1109042012', '110904', 'Air Dingin', 4),
	('1109042013', '110904', 'Amiria Bahagia', 4),
	('1109042014', '110904', 'Suka Jaya', 4),
	('1109042015', '110904', 'Suka Maju', 4),
	('1109042016', '110904', 'Suka Karya', 4),
	('1109042017', '110904', 'Sinabang', 4),
	('1109042018', '110904', 'Suka Mulia (Amaneng)', 4),
	('1109042019', '110904', 'Lugu', 4),
	('1109042020', '110904', 'Sefoyan', 4),
	('1109042021', '110904', 'Ganting', 4),
	('1109042022', '110904', 'Kuala Makmur', 4),
	('1109042023', '110904', 'Ujung Tinggi', 4),
	('1109042024', '110904', 'Air Pinang', 4),
	('1109042025', '110904', 'Pulau Sumat', 4),
	('1109042026', '110904', 'Kota Batu', 4),
	('1109042028', '110904', 'Linggi', 4),
	('1109052001', '110905', 'Babussalam', 4),
	('1109052002', '110905', 'Muara Aman', 4),
	('1109052003', '110905', 'Gunung Putih', 4),
	('1109052004', '110905', 'Lugu Sek Bahak', 4),
	('1109052005', '110905', 'Kuala Bakti', 4),
	('1109052006', '110905', 'Bulu Hadik', 4),
	('1109052007', '110905', 'Sambay', 4),
	('1109052008', '110905', 'Luan Balu', 4),
	('1109052009', '110905', 'Tanjung Raya', 4),
	('1109052010', '110905', 'Kuala Baru', 4),
	('1109062001', '110906', 'Laya Baung', 4),
	('1109062002', '110906', 'Sembilan', 4),
	('1109062003', '110906', 'Sigulai', 4),
	('1109062004', '110906', 'Sinar Bahagia', 4),
	('1109062005', '110906', 'Lamamek', 4),
	('1109062006', '110906', 'Batu Ragi', 4),
	('1109062007', '110906', 'Malasin', 4),
	('1109062008', '110906', 'Babul Makmur', 4),
	('1109062009', '110906', 'Amabaan', 4),
	('1109062010', '110906', 'Miteum', 4),
	('1109062011', '110906', 'Lhok Bihao', 4),
	('1109062012', '110906', 'Ujung Harapan', 4),
	('1109062013', '110906', 'Sanggiran', 4),
	('1109062014', '110906', 'Lhok Makmur', 4),
	('1109072001', '110907', 'Seunebuk', 4),
	('1109072002', '110907', 'Suak Lamatan', 4),
	('1109072003', '110907', 'Alus-Alus', 4),
	('1109072004', '110907', 'Batu Ralang', 4),
	('1109072005', '110907', 'Ulul Mayang', 4),
	('1109072006', '110907', 'Kebun Baru', 4),
	('1109072007', '110907', 'Badegong', 4),
	('1109072008', '110907', 'Latiung', 4),
	('1109072009', '110907', 'Pasir Tinggi', 4),
	('1109072010', '110907', 'Labuhan Jaya', 4),
	('1109072011', '110907', 'Labuhan Bajau', 4),
	('1109072012', '110907', 'Blang Sebel', 4),
	('1109072013', '110907', 'Ana Ao', 4),
	('1109072014', '110907', 'Lataling', 4),
	('1109072015', '110907', 'Pulau Bangkalak', 4),
	('1109072016', '110907', 'Labuhan Bakti', 4),
	('1109072017', '110907', 'Trans Jernge', 4),
	('1109072018', '110907', 'Trans Maranti', 4),
	('1109072019', '110907', 'Trans Baru', 4),
	('1109082001', '110908', 'Lewak', 4),
	('1109082002', '110908', 'Lamerem', 4),
	('1109082003', '110908', 'Lhok Pauh', 4),
	('1109082004', '110908', 'Serafon', 4),
	('1109082005', '110908', 'Langi', 4),
	('1109082006', '110908', 'Lubuk Baik', 4),
	('1109082007', '110908', 'Lhok Dalam', 4),
	('1109082008', '110908', 'Lafakha', 4),
	('1109092001', '110909', 'Matanurung', 4),
	('1109092002', '110909', 'Lasikin', 4),
	('1109092003', '110909', 'Lanting', 4),
	('1109092004', '110909', 'Busung Indah', 4),
	('1109092005', '110909', 'Kahat', 4),
	('1109092006', '110909', 'Simpang Abail', 4),
	('1109092007', '110909', 'Abail', 4),
	('1109092008', '110909', 'Nancawa', 4),
	('1109092009', '110909', 'Labuah', 4),
	('1109092010', '110909', 'Sua-Sua', 4),
	('1109092011', '110909', 'Batu-Batu', 4),
	('1109092012', '110909', 'Situbuk', 4),
	('1109102001', '110910', 'Bubuhan', 4),
	('1109102002', '110910', 'Amarabu', 4),
	('1109102003', '110910', 'Kuta Inang', 4),
	('1109102004', '110910', 'Kuta Padang', 4),
	('1109102005', '110910', 'Sibuluh', 4),
	('1109102006', '110910', 'Latak Ayah', 4),
	('1109102007', '110910', 'Borengan', 4),
	('1109102008', '110910', 'Ujung Pandang', 4),
	('1110012001', '111001', 'Pulau Balai', 4),
	('1110012002', '111001', 'Pulau Baguk', 4),
	('1110012004', '111001', 'Teluk Nibung', 4),
	('1110022001', '111002', 'Lipat Kajang', 4),
	('1110022002', '111002', 'Kain Golong', 4),
	('1110022003', '111002', 'Kuta Kerangan', 4),
	('1110022004', '111002', 'Siantas', 4),
	('1110022005', '111002', 'Pangi', 4),
	('1110022006', '111002', 'Sukarejo', 4),
	('1110022007', '111002', 'Ujung Limus', 4),
	('1110022008', '111002', 'Silatong', 4),
	('1110022009', '111002', 'Pertabas', 4),
	('1110022010', '111002', 'Lae Riman', 4),
	('1110022011', '111002', 'Pakiraman', 4),
	('1110022012', '111002', 'Kuta Batu', 4),
	('1110022013', '111002', 'Lae Nipe', 4),
	('1110022014', '111002', 'Kuta Tinggi', 4),
	('1110022015', '111002', 'Tuh Tuhan', 4),
	('1110022016', '111002', 'Lae Gecih', 4),
	('1110022017', '111002', 'Guha', 4),
	('1110022018', '111002', 'Lae Gambir', 4),
	('1110022019', '111002', 'Cibubukan', 4),
	('1110022020', '111002', 'Serasa', 4),
	('1110022021', '111002', 'Tugan', 4),
	('1110022022', '111002', 'Tanjung Mas', 4),
	('1110022023', '111002', 'Lipat Kajang Atas', 4),
	('1110022024', '111002', 'Sidodadi', 4),
	('1110022025', '111002', 'Pandan Sari', 4),
	('1110042001', '111004', 'Pasar Singkil', 4),
	('1110042002', '111004', 'Kampung Ujung', 4),
	('1110042003', '111004', 'Pulo Sarok', 4),
	('1110042004', '111004', 'Kilangan', 4),
	('1110042005', '111004', 'Kuta Simboling', 4),
	('1110042007', '111004', 'Teluk Ambon', 4),
	('1110042008', '111004', 'Rantau Gedang', 4),
	('1110042009', '111004', 'Teluk Rumbia', 4),
	('1110042010', '111004', 'Paya Bumbung', 4),
	('1110042011', '111004', 'Pemuka', 4),
	('1110042012', '111004', 'Takal pasir', 4),
	('1110042014', '111004', 'Selok Aceh', 4),
	('1110042016', '111004', 'Suka Makmur', 4),
	('1110042017', '111004', 'Ujung Bawang', 4),
	('1110042019', '111004', 'Siti Ambia', 4),
	('1110042020', '111004', 'Suka Damai', 4),
	('1110062001', '111006', 'Tanjung Betik', 4),
	('1110062002', '111006', 'Panjahitan', 4),
	('1110062003', '111006', 'Bukit Harapan', 4),
	('1110062004', '111006', 'Cingkam', 4),
	('1110062005', '111006', 'Labuhan Kera', 4),
	('1110062006', '111006', 'Tanah Bara', 4),
	('1110062007', '111006', 'Rimo', 4),
	('1110062008', '111006', 'Blok IV Baru', 4),
	('1110062009', '111006', 'Blok', 4),
	('1110062010', '111006', 'Blok', 4),
	('1110062011', '111006', 'Blok', 4),
	('1110062012', '111006', 'Sidorejo', 4),
	('1110062013', '111006', 'Suka Makmur', 4),
	('1110062014', '111006', 'Gunung Lagan', 4),
	('1110062015', '111006', 'Parangusan', 4),
	('1110062016', '111006', 'Seping Baru', 4),
	('1110062017', '111006', 'Sebatang', 4),
	('1110062018', '111006', 'Tanah Merah', 4),
	('1110062019', '111006', 'Pertampakan', 4),
	('1110062020', '111006', 'Panda Sari', 4),
	('1110062021', '111006', 'Sangga B. Selulusan', 4),
	('1110062022', '111006', 'Tulaan', 4),
	('1110062023', '111006', 'Tunas Harapan', 4),
	('1110062024', '111006', 'Lae Butar', 4),
	('1110062025', '111006', 'Sianjo Anjo Mariah', 4),
	('1110092001', '111009', 'Lentong', 4),
	('1110092002', '111009', 'Lapahan Buaya', 4),
	('1110092003', '111009', 'Butar', 4),
	('1110092004', '111009', 'Samar Dua', 4),
	('1110092005', '111009', 'Ladang Bisik', 4),
	('1110092006', '111009', 'Muara Pea', 4),
	('1110092008', '111009', 'Sumber Mukti', 4),
	('1110092009', '111009', 'Pea Jambu', 4),
	('1110092010', '111009', 'Danau Bungara', 4),
	('1110102001', '111010', 'Gosong Telaga Utara', 4),
	('1110102002', '111010', 'Gosong Telaga Sel.', 4),
	('1110102003', '111010', 'Kampung Baru', 4),
	('1110102004', '111010', 'Ketapang Indah', 4),
	('1110102005', '111010', 'Gosong Telaga Timur', 4),
	('1110102006', '111010', 'Gosong Telaga Barat', 4),
	('1110102007', '111010', 'Telaga Bakti', 4),
	('1110112001', '111011', 'Lae Balno', 4),
	('1110112002', '111011', 'Napa Galuh', 4),
	('1110112003', '111011', 'Sikoran', 4),
	('1110112004', '111011', 'Situbuh Tubuh', 4),
	('1110112005', '111011', 'Biskang', 4),
	('1110112006', '111011', 'Sintuban Makmur', 4),
	('1110122001', '111012', 'Suro', 4),
	('1110122002', '111012', 'Pangkalan Sulampi', 4),
	('1110122003', '111012', 'Bulu Sema', 4),
	('1110122004', '111012', 'Lae Bangun', 4),
	('1110122005', '111012', 'Alur Linci', 4),
	('1110122006', '111012', 'Siompin', 4),
	('1110122007', '111012', 'Ketangkuhan', 4),
	('1110122008', '111012', 'Keras', 4),
	('1110122009', '111012', 'Mandumpang', 4),
	('1110122010', '111012', 'Sirimo Mungkur', 4),
	('1110122011', '111012', 'Bulu Ara', 4),
	('1110132001', '111013', 'Singkohor', 4),
	('1110132002', '111013', 'Lae Sipola', 4),
	('1110132003', '111013', 'Lae Pinang', 4),
	('1110132004', '111013', 'Mukti Jaya', 4),
	('1110132006', '111013', 'Srikayu', 4),
	('1110132007', '111013', 'Pea Jambu', 4),
	('1110142001', '111014', 'Kp. Kuala Baru Laut', 4),
	('1110142002', '111014', 'Kp. Kuala Baru Sungai', 4),
	('1110142003', '111014', 'Suka Jaya', 4),
	('1110142004', '111014', 'Kayu Menang', 4),
	('1110162001', '111016', 'Haloban', 4),
	('1110162002', '111016', 'Asan Tola', 4),
	('1110162003', '111016', 'Ujung Sialit', 4),
	('1110162004', '111016', 'Suka Makmur', 4),
	('1111012001', '111101', 'Keude Aceh', 4),
	('1111012002', '111101', 'Sangso', 4),
	('1111012003', '111101', 'Pante Rheng', 4),
	('1111012004', '111101', 'Meuliek', 4),
	('1111012005', '111101', 'Namploh Baro', 4),
	('1111012006', '111101', 'Namp. Manyang', 4),
	('1111012007', '111101', 'Namp.Blanggarang', 4),
	('1111012008', '111101', 'Namp. Krueng', 4),
	('1111012009', '111101', 'Namp. Papeun', 4),
	('1111012010', '111101', 'Meunasah Lueng', 4),
	('1111012011', '111101', 'Lhok Seumira', 4),
	('1111012012', '111101', 'Ulee Jeumatan', 4),
	('1111012013', '111101', 'Lan Cok', 4),
	('1111012014', '111101', 'Paloh', 4),
	('1111012015', '111101', 'Mesjid Baro', 4),
	('1111012016', '111101', 'Batee Iliek', 4),
	('1111012017', '111101', 'Pulo Baroh', 4),
	('1111012018', '111101', 'Matang Wakeuh', 4),
	('1111012019', '111101', 'Darussalam', 4),
	('1111012020', '111101', 'Matang Jereung', 4),
	('1111012021', '111101', 'Matang', 4),
	('1111012022', '111101', 'Cot Mane', 4),
	('1111012023', '111101', 'Alue Barat', 4),
	('1111012024', '111101', 'Cot Siren', 4),
	('1111012025', '111101', 'Ulee Alue', 4),
	('1111012026', '111101', 'Pineung Seribee', 4),
	('1111012027', '111101', 'Gamp. Baro', 4),
	('1111012028', '111101', 'Kandang', 4),
	('1111012029', '111101', 'Gamp. Putoh', 4),
	('1111012030', '111101', 'Mideun Jok', 4),
	('1111012031', '111101', 'Mideun Geudong', 4),
	('1111012032', '111101', 'Lueng Keubu', 4),
	('1111012033', '111101', 'Glu. Bungkok', 4),
	('1111012034', '111101', 'Gamp. Meulum', 4),
	('1111012035', '111101', 'Cot M. Baraoh', 4),
	('1111012036', '111101', 'Cot M. Blang', 4),
	('1111012037', '111101', 'Meurah', 4),
	('1111012038', '111101', 'Ulee Ue', 4),
	('1111012039', '111101', 'Matang Teungoh', 4),
	('1111012040', '111101', 'Tj. Baro', 4),
	('1111012041', '111101', 'Angkieng Barat', 4),
	('1111012042', '111101', 'Meun. Lincah', 4),
	('1111012043', '111101', 'Meun. Lancok', 4),
	('1111012044', '111101', 'Meun. Puuk', 4),
	('1111012045', '111101', 'Tonjongan Idem', 4),
	('1111012084', '111101', 'Geulumpang Payong', 4),
	('1111022018', '111102', 'Blang Me Timu', 4),
	('1111022019', '111102', 'Lancang', 4),
	('1111022020', '111102', 'Blang Lancang', 4),
	('1111022021', '111102', 'Teupin Kupula', 4),
	('1111022022', '111102', 'Tanjong Bungong', 4),
	('1111022023', '111102', 'Dayah Baro', 4),
	('1111022024', '111102', 'Ulee Rabo', 4),
	('1111022025', '111102', 'Lueng Teungoh', 4),
	('1111022026', '111102', 'Lampoh Oe', 4),
	('1111022027', '111102', 'Pulo Rangkileh', 4),
	('1111022028', '111102', 'Tufah', 4),
	('1111022029', '111102', 'Sampo Ajad', 4),
	('1111022030', '111102', 'Darul Aman', 4),
	('1111022031', '111102', 'Lhok Kulam', 4),
	('1111022032', '111102', 'Ulee Blang', 4),
	('1111022033', '111102', 'Uteun Peupaleh', 4),
	('1111022034', '111102', 'Ulee Gajah', 4),
	('1111022035', '111102', 'Alue Seutui', 4),
	('1111022036', '111102', 'Blang Neubok', 4),
	('1111022037', '111102', 'Matang Bangka', 4),
	('1111022038', '111102', 'Matang Teungoh', 4),
	('1111022039', '111102', 'Matang Nibong', 4),
	('1111022040', '111102', 'Blang Me Barat', 4),
	('1111022041', '111102', 'Keude Jeunieb', 4),
	('1111022042', '111102', 'C G Baroh', 4),
	('1111022043', '111102', 'C G Tunong', 4),
	('1111022044', '111102', 'Meunasah Keutapang', 4),
	('1111022045', '111102', 'Meunasah Dayah', 4),
	('1111022046', '111102', 'Lhue Simpang', 4),
	('1111022047', '111102', 'Lhue Barat', 4),
	('1111022048', '111102', 'Jeumpa Sikureng', 4),
	('1111022049', '111102', 'Janggot Seungko', 4),
	('1111022050', '111102', 'Meunasah Tambo', 4),
	('1111022051', '111102', 'Meunasah Keupula', 4),
	('1111022052', '111102', 'Meunasah Tunong L', 4),
	('1111022053', '111102', 'Meunasah Alue', 4),
	('1111022054', '111102', 'Blang Pohroh', 4),
	('1111022057', '111102', 'Meunasah Lueng', 4),
	('1111022058', '111102', 'Dayah Blang Raleu', 4),
	('1111022059', '111102', 'Meunasah Blang', 4),
	('1111022060', '111102', 'Alue Lamsaba', 4),
	('1111022061', '111102', 'Meunasah Kota', 4),
	('1111022062', '111102', 'Paya Bili', 4),
	('1111032001', '111103', 'Lawang', 4),
	('1111032002', '111103', 'Matang Reuleut', 4),
	('1111032003', '111103', 'Meunasah Krueng', 4),
	('1111032004', '111103', 'Cot Keutapang', 4),
	('1111032005', '111103', 'Meunasah Rabo', 4),
	('1111032006', '111103', 'Meunasah Tambo', 4),
	('1111032007', '111103', 'Meunasah Baroh', 4),
	('1111032008', '111103', 'Meunasah Pulo', 4),
	('1111032009', '111103', 'Matang Pasi', 4),
	('1111032010', '111103', 'Blang Kubu', 4),
	('1111032011', '111103', 'Meunasah Garot', 4),
	('1111032012', '111103', 'Ara Bungong', 4),
	('1111032013', '111103', 'Jabet', 4),
	('1111032014', '111103', 'Sawang', 4),
	('1111032015', '111103', 'Blang Beururu', 4),
	('1111032016', '111103', 'Hagu', 4),
	('1111032017', '111103', 'Blang Rangkuluh', 4),
	('1111032018', '111103', 'Meunasah Bungo', 4),
	('1111032019', '111103', 'Paya Bunot', 4),
	('1111032020', '111103', 'Meunasah Tunong', 4),
	('1111032021', '111103', 'Meunasah Alue', 4),
	('1111032022', '111103', 'Meunasah Cut', 4),
	('1111032023', '111103', 'Mesjid', 4),
	('1111032024', '111103', 'Meunasah Teungoh', 4),
	('1111032025', '111103', 'Meunasah Blang', 4),
	('1111032026', '111103', 'Kukue', 4),
	('1111032027', '111103', 'Blang Matang', 4),
	('1111032028', '111103', 'Blang Gleumpang', 4),
	('1111032029', '111103', 'Gampong Baro', 4),
	('1111032030', '111103', 'Gampong Paya', 4),
	('1111032031', '111103', 'Seuneubok Paya', 4),
	('1111032032', '111103', 'Pulo Lawang', 4),
	('1111032033', '111103', 'Keude Alue Rheng', 4),
	('1111032034', '111103', 'Karieng', 4),
	('1111032035', '111103', 'Pulo Ara', 4),
	('1111032036', '111103', 'Cot Laot', 4),
	('1111032037', '111103', 'Aleu Sijuk', 4),
	('1111032038', '111103', 'Blang Bati', 4),
	('1111032039', '111103', 'Buket Paya', 4),
	('1111032040', '111103', 'Dayah Mon Ara', 4),
	('1111032041', '111103', 'Calok', 4),
	('1111032042', '111103', 'Cot Kruet', 4),
	('1111032043', '111103', 'Tanjong Selamat', 4),
	('1111032044', '111103', 'Jaba', 4),
	('1111032045', '111103', 'Alue Gandai', 4),
	('1111032046', '111103', 'Neubok Naleung', 4),
	('1111032047', '111103', 'Paya Timu', 4),
	('1111032048', '111103', 'Mulia', 4),
	('1111032049', '111103', 'Pinto Rimba', 4),
	('1111032050', '111103', 'Alue Keutapang', 4),
	('1111032051', '111103', 'Tgk. Di Bathon', 4),
	('1111032052', '111103', 'Paya Barat', 4),
	('1111042032', '111104', 'Gleumpang Payong', 4),
	('1111042033', '111104', 'Blang Seunong', 4),
	('1111042034', '111104', 'Cot Leusong', 4),
	('1111042035', '111104', 'Batee Timoh', 4),
	('1111042036', '111104', 'Lipah Rayeuk', 4),
	('1111042037', '111104', 'Cot Geureundong', 4),
	('1111042038', '111104', 'Lipah Cut', 4),
	('1111042039', '111104', 'Beurawang', 4),
	('1111042042', '111104', 'Geudong Tampu', 4),
	('1111042043', '111104', 'Cot Tarom Baroh', 4),
	('1111042044', '111104', 'Blang C Baroh', 4),
	('1111042045', '111104', 'Blang C Tunong', 4),
	('1111042046', '111104', 'Seuleumbah', 4),
	('1111042047', '111104', 'Cot Keutapang', 4),
	('1111042048', '111104', 'Cot Tarom Tunong', 4),
	('1111042049', '111104', 'Blang Bladeh', 4),
	('1111042050', '111104', 'Mon Jambee', 4),
	('1111042051', '111104', 'Blang Dalam', 4),
	('1111042052', '111104', 'Kuala Jeumpa', 4),
	('1111042053', '111104', 'Cot Gadong', 4),
	('1111042054', '111104', 'Cot Bada', 4),
	('1111042055', '111104', 'Teupok Baroh', 4),
	('1111042056', '111104', 'Teupok Tunong', 4),
	('1111042057', '111104', 'Pulo Lawang', 4),
	('1111042058', '111104', 'Abeuk Usong', 4),
	('1111042059', '111104', 'Paloh Seulimeng', 4),
	('1111042060', '111104', 'Abeuk Tingkeum', 4),
	('1111042061', '111104', 'Blang Mee', 4),
	('1111042062', '111104', 'Blang Seupeung', 4),
	('1111042063', '111104', 'Blang Gandai', 4),
	('1111042064', '111104', 'Cot Ulim', 4),
	('1111042065', '111104', 'Cot Iboih', 4),
	('1111042071', '111104', 'Blang Rheum', 4),
	('1111042072', '111104', 'Paloh Panyang', 4),
	('1111042073', '111104', 'Seuneubok Lhong', 4),
	('1111042075', '111104', 'Salah Sirong Jaya', 4),
	('1111042076', '111104', 'Mon Mane', 4),
	('1111042077', '111104', 'Alue Limeng', 4),
	('1111042078', '111104', 'Cot Meugoe', 4),
	('1111042079', '111104', 'Cot Iboeh Timu', 4),
	('1111042080', '111104', 'Kuta Meuligoe', 4),
	('1111042081', '111104', 'Lhaksmana', 4),
	('1111052003', '111105', 'Mt Glp Mns Timu X', 4),
	('1111052004', '111105', 'Keude Mtg GLP Dua', 4),
	('1111052005', '111105', 'MTG GLP II MNS Dayah', 4),
	('1111052006', '111105', 'Pante Gajah', 4),
	('1111052007', '111105', 'Blang Asan', 4),
	('1111052008', '111105', 'Paya Cut', 4),
	('1111052009', '111105', 'Seuneubok Aceh', 4),
	('1111052010', '111105', 'Panton Geulima', 4),
	('1111052011', '111105', 'Neuheun', 4),
	('1111052012', '111105', 'Matang Sagoe', 4),
	('1111052013', '111105', 'Matang Mesjid', 4),
	('1111052014', '111105', 'Matang Cot Paseh', 4),
	('1111052015', '111105', 'Cot Panjoe', 4),
	('1111052016', '111105', 'Paya Lipah', 4),
	('1111052017', '111105', 'Paya Meuneng', 4),
	('1111052018', '111105', 'Keude Tanjong', 4),
	('1111052019', '111105', 'Tanjong Paya', 4),
	('1111052020', '111105', 'Tanjong Nie', 4),
	('1111052021', '111105', 'Tanjong Mesjid', 4),
	('1111052022', '111105', 'Pante Cut', 4),
	('1111052023', '111105', 'Blang Cut', 4),
	('1111052024', '111105', 'Pulo Pisang', 4),
	('1111052025', '111105', 'Pante Piyeu', 4),
	('1111052026', '111105', 'Meunasah Nibong', 4),
	('1111052027', '111105', 'KR. Baro Babah K', 4),
	('1111052028', '111105', 'Krueng B Mesjid', 4),
	('1111052029', '111105', 'Bayu', 4),
	('1111052030', '111105', 'Gampong Putoh', 4),
	('1111052031', '111105', 'Meunasah Meucap', 4),
	('1111052032', '111105', 'Pante Ara', 4),
	('1111052033', '111105', 'Gampong R Dagang', 4),
	('1111052034', '111105', 'GR. Tambo', 4),
	('1111052035', '111105', 'Kapa', 4),
	('1111052036', '111105', 'Blang Panjoe', 4),
	('1111052037', '111105', 'Pantee Lhong', 4),
	('1111052038', '111105', 'Asan Bideun', 4),
	('1111052040', '111105', 'C R Baroh', 4),
	('1111052041', '111105', 'C R Tunong', 4),
	('1111052042', '111105', 'Cot Nga', 4),
	('1111052043', '111105', 'Pulo Naleung', 4),
	('1111052044', '111105', 'Mata Mamplam', 4),
	('1111052045', '111105', 'Alue Gleumpang', 4),
	('1111052046', '111105', 'Karieng', 4),
	('1111052047', '111105', 'Krueng Dheu', 4),
	('1111052048', '111105', 'Cot Ijue', 4),
	('1111052049', '111105', 'Cot Buket', 4),
	('1111052050', '111105', 'Nicah', 4),
	('1111052051', '111105', 'Cot Keuranji', 4),
	('1111052052', '111105', 'Paloh', 4),
	('1111052054', '111105', 'C B Tunong', 4),
	('1111052055', '111105', 'C B Baroh', 4),
	('1111052056', '111105', 'Cot Girek', 4),
	('1111052057', '111105', 'Cot Keumude', 4),
	('1111052058', '111105', 'Sagoe', 4),
	('1111052059', '111105', 'Kareueng', 4),
	('1111052060', '111105', 'C B Barat', 4),
	('1111052061', '111105', 'Tanoh Mirah', 4),
	('1111052062', '111105', 'Seuneubok Rawa', 4),
	('1111052063', '111105', 'Paya Aboe', 4),
	('1111052064', '111105', 'Blang Rambong', 4),
	('1111052065', '111105', 'Blang Geulanggang', 4),
	('1111052066', '111105', 'Paya Reuhat', 4),
	('1111052067', '111105', 'Uteun Bunta', 4),
	('1111052068', '111105', 'Alue Udeng', 4),
	('1111052069', '111105', 'Alue Peuno', 4),
	('1111052105', '111105', 'Cot Puuk', 4),
	('1111052106', '111105', 'Pante Pisang', 4),
	('1111052107', '111105', 'Gampong Baro', 4),
	('1111052108', '111105', 'Blang Dalam', 4),
	('1111062001', '111106', 'Leube Me', 4),
	('1111062002', '111106', 'Paya Dua', 4),
	('1111062003', '111106', 'Leubu Cot', 4),
	('1111062004', '111106', 'Leubu Mesjid', 4),
	('1111062005', '111106', 'Kuta Barat', 4),
	('1111062006', '111106', 'Trienggadeng', 4),
	('1111062007', '111106', 'Cot Kruet', 4),
	('1111062008', '111106', 'Blang Khutang', 4),
	('1111062009', '111106', 'Buket Seulamat', 4),
	('1111062010', '111106', 'Lapehan Mesjid', 4),
	('1111062011', '111106', 'Ulee Glee', 4),
	('1111062012', '111106', 'Mon Ara', 4),
	('1111062013', '111106', 'Pandak', 4),
	('1111062014', '111106', 'Blang Dalam', 4),
	('1111062015', '111106', 'Alue Dua', 4),
	('1111062016', '111106', 'Seun. Baro', 4),
	('1111062017', '111106', 'Panteu Brueh', 4),
	('1111062018', '111106', 'Tj. Mulia', 4),
	('1111062019', '111106', 'Blang Mane', 4),
	('1111062020', '111106', 'Meureubo', 4),
	('1111062021', '111106', 'Blang Perlak', 4),
	('1111062022', '111106', 'Panton Mesjid', 4),
	('1111062023', '111106', 'Sukarame', 4),
	('1111062024', '111106', 'Matang Kumbang', 4),
	('1111062025', '111106', 'Pulo Teungoh', 4),
	('1111062026', '111106', 'Batee Dabai', 4),
	('1111062027', '111106', 'Ara Lipeh', 4),
	('1111072001', '111107', 'Keude Lapang', 4),
	('1111072002', '111107', 'Lapang Barat', 4),
	('1111072003', '111107', 'Lingka Kuta', 4),
	('1111072004', '111107', 'Lapang Timu', 4),
	('1111072005', '111107', 'Teupin Siron', 4),
	('1111072006', '111107', 'Ie Rhop', 4),
	('1111072007', '111107', 'Ceubo', 4),
	('1111072008', '111107', 'Paloh Me', 4),
	('1111072009', '111107', 'Lhok Mambang', 4),
	('1111072010', '111107', 'Samuti Krueng', 4),
	('1111072011', '111107', 'Cot Mane', 4),
	('1111072012', '111107', 'Samuti Makmur', 4),
	('1111072013', '111107', 'Samuti Rayeuk', 4),
	('1111072014', '111107', 'Cot Puuk', 4),
	('1111072015', '111107', 'Samuti Aman', 4),
	('1111072016', '111107', 'Alue Mangki', 4),
	('1111072017', '111107', 'Mon Keulayu', 4),
	('1111072018', '111107', 'Geurugok', 4),
	('1111072019', '111107', 'Blang Keude', 4),
	('1111072020', '111107', 'Cot Tufah', 4),
	('1111072021', '111107', 'Cot Tunong', 4),
	('1111072022', '111107', 'Paya Baro', 4),
	('1111072023', '111107', 'Paloh Kayekunyet', 4),
	('1111072024', '111107', 'Cot Jabet', 4),
	('1111072025', '111107', 'Cot Tube', 4),
	('1111072026', '111107', 'Pante Sikumbong', 4),
	('1111072027', '111107', 'Blang Guron', 4),
	('1111072028', '111107', 'Dama Kawan', 4),
	('1111072029', '111107', 'Paya Seupat', 4),
	('1111072030', '111107', 'Cot Rambat', 4),
	('1111072031', '111107', 'Paya Kareung', 4),
	('1111072032', '111107', 'Mon Jeurujak', 4),
	('1111072033', '111107', 'Tj. Raya', 4),
	('1111072034', '111107', 'Tj. Mesjid', 4),
	('1111072035', '111107', 'Blang Kubu', 4),
	('1111072036', '111107', 'Tj. Bungong', 4),
	('1111072037', '111107', 'Pulo Gisa', 4),
	('1111072038', '111107', 'Ujong Bayu', 4),
	('1111072078', '111107', 'Monjambe', 4),
	('1111072079', '111107', 'Blang Rheue', 4),
	('1111082001', '111108', 'Lancok Ulim', 4),
	('1111082002', '111108', 'Nase Mee', 4),
	('1111082003', '111108', 'Pandra Kandeh', 4),
	('1111082004', '111108', 'Panton', 4),
	('1111082005', '111108', 'Lhok Dagang', 4),
	('1111082006', '111108', 'Pandrah Janeng', 4),
	('1111082007', '111108', 'Garot', 4),
	('1111082008', '111108', 'Gamp. Blang', 4),
	('1111082009', '111108', 'Kuta Rusep', 4),
	('1111082010', '111108', 'Blang Samagadeng', 4),
	('1111082011', '111108', 'Panton Bili', 4),
	('1111082012', '111108', 'Alue Igeuh', 4),
	('1111082013', '111108', 'Meun. Reudeup', 4),
	('1111082014', '111108', 'Meun. Teungoh', 4),
	('1111082015', '111108', 'Bantayan', 4),
	('1111082016', '111108', 'Cot Leubeng', 4),
	('1111082017', '111108', 'Ceunebok Baro', 4),
	('1111082018', '111108', 'Uteun Krut', 4),
	('1111082019', '111108', 'Nase Barat', 4),
	('1111092001', '111109', 'Juli Cot Mesjid', 4),
	('1111092002', '111109', 'Juli Seutuy', 4),
	('1111092003', '111109', 'Juli Tambo Tanjong', 4),
	('1111092004', '111109', 'Juli Keude dua', 4),
	('1111092005', '111109', 'Juli Tgk Di Lampoh', 4),
	('1111092006', '111109', 'Gleumpang M. Jim', 4),
	('1111092007', '111109', 'Alue Unoe', 4),
	('1111092008', '111109', 'Batee Raya', 4),
	('1111092009', '111109', 'Seuneubok Peureraden', 4),
	('1111092010', '111109', 'Juli Mee Teungoh', 4),
	('1111092011', '111109', 'Seuneubok Gunci', 4),
	('1111092012', '111109', 'Mane Meujingki', 4),
	('1111092013', '111109', 'Abeuk Budi', 4),
	('1111092014', '111109', 'Blang Ketumba', 4),
	('1111092015', '111109', 'Pante Baro', 4),
	('1111092016', '111109', 'Beuyot', 4),
	('1111092017', '111109', 'Paya Cut', 4),
	('1111092018', '111109', 'Teupin Mane', 4),
	('1111092019', '111109', 'Simpang Jaya', 4),
	('1111092020', '111109', 'Krueng Simpo', 4),
	('1111092021', '111109', 'Suka Tani', 4),
	('1111092022', '111109', 'Juli Seupang', 4),
	('1111092023', '111109', 'Bukit Mulia', 4),
	('1111092024', '111109', 'Juli Meunasah Tambo', 4),
	('1111092025', '111109', 'Alue Rambong', 4),
	('1111092026', '111109', 'Juli Meunasah Teungoh', 4),
	('1111092027', '111109', 'Juli Paya Ru', 4),
	('1111092028', '111109', 'Paseh', 4),
	('1111092029', '111109', 'Juli Cot Meurak', 4),
	('1111092030', '111109', 'Pante Peusangan', 4),
	('1111092031', '111109', 'Bale Panah', 4),
	('1111092032', '111109', 'Ranto Panyang', 4),
	('1111092033', '111109', 'Simpang Mulia', 4),
	('1111092034', '111109', 'Seuneubok Dalam', 4),
	('1111092035', '111109', 'Juli Meunasah Jok', 4),
	('1111092036', '111109', 'Juli Uruek Anoe', 4),
	('1111102001', '111110', 'Jangka Mesjid', 4),
	('1111102002', '111110', 'Jangka Keutapang', 4),
	('1111102003', '111110', 'Jangka Alue U', 4),
	('1111102004', '111110', 'Jangka Alue', 4),
	('1111102005', '111110', 'Jangka A. Bie', 4),
	('1111102006', '111110', 'Gamp. Meulinteung', 4),
	('1111102007', '111110', 'Paya Bieng', 4),
	('1111102008', '111110', 'Meunasah Krueng', 4),
	('1111102009', '111110', 'Barat Lanyan', 4),
	('1111102010', '111110', 'Lamkuta', 4),
	('1111102011', '111110', 'Geundot', 4),
	('1111102012', '111110', 'Lueng', 4),
	('1111102013', '111110', 'Kamboek', 4),
	('1111102014', '111110', 'Ruseb Ara', 4),
	('1111102015', '111110', 'Ruseb Dayah', 4),
	('1111102016', '111110', 'Bada Barat', 4),
	('1111102017', '111110', 'Bada Timu', 4),
	('1111102018', '111110', 'Tanjongan', 4),
	('1111102019', '111110', 'Tanah Anoe', 4),
	('1111102020', '111110', 'Lhok Bugeng', 4),
	('1111102021', '111110', 'Lampoh Rayeuk', 4),
	('1111102022', '111110', 'Pulo Reudeup', 4),
	('1111102023', '111110', 'Pulo Seuna', 4),
	('1111102024', '111110', 'Linggong', 4),
	('1111102025', '111110', 'Pulo Blang', 4),
	('1111102026', '111110', 'Pulo Iboih', 4),
	('1111102027', '111110', 'Abeuk Jaloh', 4),
	('1111102028', '111110', 'Pulo U', 4),
	('1111102029', '111110', 'Alue Buya', 4),
	('1111102030', '111110', 'Alue Buya Pasi', 4),
	('1111102031', '111110', 'Pante Sukon', 4),
	('1111102032', '111110', 'Pante Paku', 4),
	('1111102033', '111110', 'Bugak Blang', 4),
	('1111102034', '111110', 'Bugak Mesjid', 4),
	('1111102035', '111110', 'Bugak Krueng Mate', 4),
	('1111102036', '111110', 'Bugak Krueng', 4),
	('1111102037', '111110', 'Pante Ranub', 4),
	('1111102038', '111110', 'Pulo Pineung Meunasah Dua', 4),
	('1111102039', '111110', 'Punjot', 4),
	('1111102040', '111110', 'Bugeng', 4),
	('1111102041', '111110', 'Alue Kuta', 4),
	('1111102042', '111110', 'Alue Bayeu Utang', 4),
	('1111102043', '111110', 'Ulee Cue', 4),
	('1111102044', '111110', 'Kuala Cerape', 4),
	('1111102045', '111110', 'Pante Peusangan', 4),
	('1111102046', '111110', 'Alue Bie Pusong', 4),
	('1111112001', '111111', 'Rheum Barat', 4),
	('1111112002', '111111', 'Rheum Baroh', 4),
	('1111112003', '111111', 'Rheum Timu', 4),
	('1111112004', '111111', 'B. Kuta Coh', 4),
	('1111112005', '111111', 'B. K. Dua Mns', 4),
	('1111112006', '111111', 'Lancang', 4),
	('1111112007', '111111', 'Blang Teumulek', 4),
	('1111112008', '111111', 'Meun. Mesjid', 4),
	('1111112009', '111111', 'Jurong Binjee', 4),
	('1111112010', '111111', 'B. Mane Dua Mns', 4),
	('1111112011', '111111', 'B. Mane Barat', 4),
	('1111112012', '111111', 'Balee', 4),
	('1111112013', '111111', 'Arongan', 4),
	('1111112014', '111111', 'Meunasah Mamplam', 4),
	('1111112015', '111111', 'Pulo Dapong', 4),
	('1111112016', '111111', 'Ceurucok', 4),
	('1111112017', '111111', 'Ie Rhob Glumpang', 4),
	('1111112018', '111111', 'Ie Rhob Barat', 4),
	('1111112019', '111111', 'Ie Rhob Timu', 4),
	('1111112020', '111111', 'I R Babah Lueng', 4),
	('1111112021', '111111', 'Glee Meudong', 4),
	('1111112022', '111111', 'Pulo Drien', 4),
	('1111112023', '111111', 'Meunasah Dayah', 4),
	('1111112024', '111111', 'Cot Trieng', 4),
	('1111112025', '111111', 'Krueng Meuseugob', 4),
	('1111112026', '111111', 'Lhok Tanoh', 4),
	('1111112027', '111111', 'Blang Tambue', 4),
	('1111112028', '111111', 'Keude Tambue', 4),
	('1111112029', '111111', 'Meunasah Asan', 4),
	('1111112030', '111111', 'Peuneulet Tunong', 4),
	('1111112031', '111111', 'Cure Tunong', 4),
	('1111112032', '111111', 'Cure Baroh', 4),
	('1111112033', '111111', 'Peuneulet Baroh', 4),
	('1111112034', '111111', 'Ulee Kareung', 4),
	('1111112035', '111111', 'Blang Panyang', 4),
	('1111112036', '111111', 'Calok', 4),
	('1111112037', '111111', 'Alue Leuhop', 4),
	('1111112038', '111111', 'Paku', 4),
	('1111112039', '111111', 'Lhok Mane', 4),
	('1111112040', '111111', 'Tambue Barat', 4),
	('1111112041', '111111', 'Meunasah Barat', 4),
	('1111122001', '111112', 'Keude Plimbang', 4),
	('1111122002', '111112', 'Krueng Baro', 4),
	('1111122003', '111112', 'Seuneubok Nalan', 4),
	('1111122004', '111112', 'Rambong Payong', 4),
	('1111122005', '111112', 'Seuneubok Aceh', 4),
	('1111122006', '111112', 'S. Plimbing', 4),
	('1111122007', '111112', 'S. Punti', 4),
	('1111122008', '111112', 'Uteun Dikumbong', 4),
	('1111122009', '111112', 'Teupin Panah', 4),
	('1111122010', '111112', 'Matang Kulee', 4),
	('1111122011', '111112', 'Lancok Bungo', 4),
	('1111122012', '111112', 'Uteun Rungkom', 4),
	('1111122013', '111112', 'Padang Kasab', 4),
	('1111122014', '111112', 'Seuneubok Seumawe', 4),
	('1111122015', '111112', 'Jambo Dalam', 4),
	('1111122016', '111112', 'Cot Gleumpang', 4),
	('1111122017', '111112', 'Puuek', 4),
	('1111122018', '111112', 'Balee Daka', 4),
	('1111122019', '111112', 'Paloh Pupu', 4),
	('1111122020', '111112', 'Seunebok Teungoh', 4),
	('1111122021', '111112', 'Garab', 4),
	('1111122022', '111112', 'Kuta Trieng', 4),
	('1111132001', '111113', 'Kota Bireuen', 4),
	('1111132002', '111113', 'Bireuen MNS Reulet', 4),
	('1111132003', '111113', 'Bireuen MNS Blang', 4),
	('1111132004', '111113', 'Bireuen MNS Capa', 4),
	('1111132005', '111113', 'Bireuen Meunasah Dayah', 4),
	('1111132006', '111113', 'Bireuen MNS TGK Digadong', 4),
	('1111132007', '111113', 'Geudong-Geudong', 4),
	('1111132008', '111113', 'P A Geudong TGH', 4),
	('1111132009', '111113', 'Geudong Aleu', 4),
	('1111132010', '111113', 'Pulo Kiton', 4),
	('1111132011', '111113', 'Lhok Awe Teungoh', 4),
	('1111132012', '111113', 'Geulanggang Teungoh', 4),
	('1111132013', '111113', 'Cot Gapu', 4),
	('1111132014', '111113', 'Geulanggang Kulam', 4),
	('1111132015', '111113', 'Geulanggang Gampong', 4),
	('1111132016', '111113', 'Blang Tingkeum', 4),
	('1111132017', '111113', 'Buket Teukueh', 4),
	('1111132018', '111113', 'Blang Reuling', 4),
	('1111132019', '111113', 'Cot Jrat', 4),
	('1111132020', '111113', 'Cot Peutek', 4),
	('1111132021', '111113', 'Uteun Reutoh', 4),
	('1111132022', '111113', 'Geulanggang Baro', 4),
	('1111132023', '111113', 'Baro', 4),
	('1111142001', '111114', 'Cot Batee', 4),
	('1111142002', '111114', 'Cot Unou', 4),
	('1111142003', '111114', 'Kuta Baru', 4),
	('1111142004', '111114', 'Cot Gleumpang', 4),
	('1111142005', '111114', 'Cot Kuta', 4),
	('1111142006', '111114', 'Glumpang Baroh', 4),
	('1111142007', '111114', 'Krueng J Timu', 4),
	('1111142008', '111114', 'Krueng Juli Barat', 4),
	('1111142009', '111114', 'Cot Trieng', 4),
	('1111142010', '111114', 'L A Awe', 4),
	('1111142011', '111114', 'Cot L Sawa', 4),
	('1111142012', '111114', 'Cot U Sibak', 4),
	('1111142013', '111114', 'Lancok Pante Ara', 4),
	('1111142014', '111114', 'Lancok-Lancok', 4),
	('1111142015', '111114', 'Kareung', 4),
	('1111142016', '111114', 'Bale Kunyueno', 4),
	('1111142017', '111114', 'Ujong Blang', 4),
	('1111142018', '111114', 'Ujong Blang Mesjid', 4),
	('1111142019', '111114', 'Weu Jangka', 4),
	('1111142020', '111114', 'Kuala Raja', 4),
	('1111152001', '111115', 'Lueng Daneun', 4),
	('1111152002', '111115', 'Rambong Payong', 4),
	('1111152003', '111115', 'Alue Kupula', 4),
	('1111152004', '111115', 'Blang Cirih', 4),
	('1111152005', '111115', 'Kubu', 4),
	('1111152006', '111115', 'Teupin Raya', 4),
	('1111152007', '111115', 'Cot Aneuk Batee', 4),
	('1111152008', '111115', 'Kubu Raya', 4),
	('1111152009', '111115', 'Pante B. Gle Siblah', 4),
	('1111152010', '111115', 'Pante B. Kumbang', 4),
	('1111152011', '111115', 'Pante B. Bkt. Panyang', 4),
	('1111152012', '111115', 'Alue Krueb', 4),
	('1111152013', '111115', 'Alue Let', 4),
	('1111152014', '111115', 'Paloh Mampre', 4),
	('1111152015', '111115', 'Buket Sudan', 4),
	('1111152016', '111115', 'Awe Geutah', 4),
	('1111152017', '111115', 'Cot Saleuet', 4),
	('1111152018', '111115', 'Alue Gleumpang', 4),
	('1111152019', '111115', 'Pante Karya', 4),
	('1111152020', '111115', 'Awe Geutah Paya', 4),
	('1111152021', '111115', 'Dayah Baro', 4),
	('1111162001', '111116', 'Darussalam', 4),
	('1111162002', '111116', 'Blang Mane', 4),
	('1111162003', '111116', 'Tj. Beuridi', 4),
	('1111162004', '111116', 'Darul Aman', 4),
	('1111162005', '111116', 'Geulanggang Labu', 4),
	('1111162006', '111116', 'Teupin Reudeup', 4),
	('1111162007', '111116', 'Ulee Jalan', 4),
	('1111162008', '111116', 'Paya Crot', 4),
	('1111162009', '111116', 'Pulo Panyang', 4),
	('1111162010', '111116', 'Me Ra Yeuk', 4),
	('1111162011', '111116', 'Uteun Gathom', 4),
	('1111162012', '111116', 'Lungkuli', 4),
	('1111162013', '111116', 'Lueng Baro', 4),
	('1111162014', '111116', 'Mate Le', 4),
	('1111162015', '111116', 'Blang Cut', 4),
	('1111162016', '111116', 'Blang Pala', 4),
	('1111162017', '111116', 'Krueng Beukah', 4),
	('1111162018', '111116', 'Ceurek', 4),
	('1111162019', '111116', 'Uteun Raya', 4),
	('1111162020', '111116', 'Pulo Harapan', 4),
	('1111162021', '111116', 'Suwak', 4),
	('1111172001', '111117', 'Paloh Dama', 4),
	('1111172002', '111117', 'Paya Rangkuluh', 4),
	('1111172003', '111117', 'Paloh Raya', 4),
	('1111172004', '111117', 'Crueng Kumbang', 4),
	('1111172005', '111117', 'Tanjong Siron', 4),
	('1111172006', '111117', 'Balee Mee', 4),
	('1111172007', '111117', 'Buket Dalam', 4),
	('1111172008', '111117', 'Parang Sikureung', 4),
	('1111172009', '111117', 'Cot Baroh', 4),
	('1111172010', '111117', 'Paloh Peuradi', 4),
	('1111172011', '111117', 'Cot Mee', 4),
	('1111172012', '111117', 'Blang Mee', 4),
	('1111172013', '111117', 'Glee Putoh', 4),
	('1111172014', '111117', 'Tingkeum Baro', 4),
	('1111172015', '111117', 'Tingkeum Manyang', 4),
	('1111172016', '111117', 'Kulu', 4),
	('1111172017', '111117', 'Babah Suak', 4),
	('1111172018', '111117', 'Ulee Pusong', 4),
	('1111172019', '111117', 'Pulo Nga', 4),
	('1111172020', '111117', 'Meusee', 4),
	('1111172021', '111117', 'Blang Panjo', 4),
	('1111172022', '111117', 'Babah Jurong', 4),
	('1111172023', '111117', 'Dayah Panjoe', 4),
	('1111172024', '111117', 'Pulo Blang', 4),
	('1111172025', '111117', 'Im Budee', 4),
	('1111172026', '111117', 'Pulo Siren', 4),
	('1111172027', '111117', 'Jarommah Me', 4),
	('1111172028', '111117', 'Jaromah Baroh', 4),
	('1111172029', '111117', 'Lhok Nga', 4),
	('1111172030', '111117', 'Pulo Reudeup', 4),
	('1111172031', '111117', 'Geulang. Meunjee', 4),
	('1111172032', '111117', 'Geunlang. Panah', 4),
	('1111172033', '111117', 'Ujong Blang', 4),
	('1111172034', '111117', 'Geulang Rayeuk', 4),
	('1111172035', '111117', 'Dayah Mesjid', 4),
	('1111172036', '111117', 'Keurumbok', 4),
	('1111172037', '111117', 'Cot Ara', 4),
	('1111172038', '111117', 'Rancong', 4),
	('1111172039', '111117', 'Jambo Kajeung', 4),
	('1111172040', '111117', 'Kulu Kuta', 4),
	('1111172041', '111117', 'Pulo Awe', 4),
	('1112012006', '111201', 'Guhang', 4),
	('1112012007', '111201', 'Seunaloh', 4),
	('1112012008', '111201', 'Lhung Asan', 4),
	('1112012010', '111201', 'Lhung Tarok', 4),
	('1112012014', '111201', 'Cot Jeurat', 4),
	('1112012015', '111201', 'Meudang Ara', 4),
	('1112012016', '111201', 'Keude Siblah', 4),
	('1112012017', '111201', 'Kuta Bahagia', 4),
	('1112012018', '111201', 'Kuta Tinggi', 4),
	('1112012019', '111201', 'Mata Ie', 4),
	('1112012020', '111201', 'Geulumpang Payong', 4),
	('1112012021', '111201', 'Panton Raya', 4),
	('1112012022', '111201', 'Alue Manggota', 4),
	('1112012023', '111201', 'Lam Kuta', 4),
	('1112012024', '111201', 'Baharu', 4),
	('1112012025', '111201', 'Keude Paya', 4),
	('1112012026', '111201', 'Pasar Blang Pidie', 4),
	('1112012028', '111201', 'Kuta Tuha', 4),
	('1112012029', '111201', 'Gudang', 4),
	('1112022001', '111202', 'Adan', 4),
	('1112022002', '111202', 'Pante Geulumpang', 4),
	('1112022003', '111202', 'Mesjid', 4),
	('1112022004', '111202', 'Gunong Cut', 4),
	('1112022005', '111202', 'Padang Kawa', 4),
	('1112022006', '111202', 'Blang Padang', 4),
	('1112022007', '111202', 'Padang Bak Jeumpa', 4),
	('1112022008', '111202', 'Suak Labu', 4),
	('1112022014', '111202', 'Bineh Krueng', 4),
	('1112022015', '111202', 'Drien Kipah', 4),
	('1112022016', '111202', 'Drien Jalo', 4),
	('1112022017', '111202', 'Padang Bak Jok', 4),
	('1112022018', '111202', 'Suak Nibong', 4),
	('1112022019', '111202', 'Kuta Bak Drien', 4),
	('1112032001', '111203', 'Kedai', 4),
	('1112032002', '111203', 'Padang', 4),
	('1112032003', '111203', 'Tengah', 4),
	('1112032005', '111203', 'Paya', 4),
	('1112032006', '111203', 'Seuneulop', 4),
	('1112032007', '111203', 'Lhok Puntol', 4),
	('1112032009', '111203', 'Ladang Panah', 4),
	('1112032010', '111203', 'Pusu Ingin Jaya', 4),
	('1112032011', '111203', 'Panton Makmur', 4),
	('1112032018', '111203', 'Ladang Tuha I', 4),
	('1112032019', '111203', 'Ladang Tuha II', 4),
	('1112032022', '111203', 'Lhung Baro', 4),
	('1112032023', '111203', 'Tokoh', 4),
	('1112032024', '111203', 'Blang Manggeng', 4),
	('1112032025', '111203', 'Pante Raja', 4),
	('1112032026', '111203', 'Sejahtera', 4),
	('1112032027', '111203', 'Lhok Pawoh', 4),
	('1112032028', '111203', 'Alue Rambot', 4),
	('1112032029', '111203', 'Pante Pirak', 4),
	('1112032030', '111203', 'Ujung Tanah', 4),
	('1112042001', '111204', 'Pante Perak', 4),
	('1112042002', '111204', 'Durian Rampak', 4),
	('1112042003', '111204', 'Barat', 4),
	('1112042004', '111204', 'Palak Hulu', 4),
	('1112042005', '111204', 'Palak Hilir', 4),
	('1112042006', '111204', 'Durian Jangek', 4),
	('1112042007', '111204', 'Rumah Dua Lapis', 4),
	('1112042008', '111204', 'Pinang', 4),
	('1112042009', '111204', 'Rumah Panjang', 4),
	('1112042010', '111204', 'Baharu', 4),
	('1112042011', '111204', 'Pawoh', 4),
	('1112042012', '111204', 'Padang Baru', 4),
	('1112042013', '111204', 'Pulau Kayu', 4),
	('1112042014', '111204', 'Ujung Padang', 4),
	('1112042015', '111204', 'Kedai Susoh', 4),
	('1112042016', '111204', 'Panjang Baru', 4),
	('1112042017', '111204', 'Kedai Palak Kerambil', 4),
	('1112042018', '111204', 'Ladang', 4),
	('1112042019', '111204', 'Kepala Bandar', 4),
	('1112042020', '111204', 'Tengah', 4),
	('1112042021', '111204', 'Gadang', 4),
	('1112042022', '111204', 'Padang Hilir', 4),
	('1112042023', '111204', 'Blang Dalam', 4),
	('1112042024', '111204', 'Meunasah', 4),
	('1112042025', '111204', 'Lampoh Drien', 4),
	('1112042026', '111204', 'Padang Panjang', 4),
	('1112042027', '111204', 'Rubek Meupayong', 4),
	('1112042028', '111204', 'Cot Mancang', 4),
	('1112052001', '111205', 'Kota Bahagia', 4),
	('1112052002', '111205', 'Pasar Kota Bahagia', 4),
	('1112052003', '111205', 'Geulanggang Gajah', 4),
	('1112052004', '111205', 'Kuala Teurubue', 4),
	('1112052005', '111205', 'Blang Makmur', 4),
	('1112052006', '111205', 'Ponto Cut', 4),
	('1112052007', '111205', 'Alue Padee', 4),
	('1112052008', '111205', 'Muka Blang', 4),
	('1112052009', '111205', 'Lhung Geulumpang', 4),
	('1112052010', '111205', 'Padang Sikabu', 4),
	('1112052011', '111205', 'Kampung Teungoh', 4),
	('1112052012', '111205', 'Blang Panyang', 4),
	('1112052013', '111205', 'Krueng Batee', 4),
	('1112052014', '111205', 'Alue Pisang', 4),
	('1112052015', '111205', 'Lhok Gajah', 4),
	('1112052016', '111205', 'Ie Mameh', 4),
	('1112052017', '111205', 'Keude Baro', 4),
	('1112052018', '111205', 'Lama Tuha', 4),
	('1112062001', '111206', 'Pante Rakyat', 4),
	('1112062002', '111206', 'Ie Mirah', 4),
	('1112062003', '111206', 'Gunung Samarinda', 4),
	('1112062004', '111206', 'Alue Jeurejak', 4),
	('1112062005', '111206', 'Blang Dalam', 4),
	('1112062006', '111206', 'Alue Peunawa', 4),
	('1112062007', '111206', 'Pante Cermin', 4),
	('1112072001', '111207', 'Lhang', 4),
	('1112072002', '111207', 'Rambong', 4),
	('1112072003', '111207', 'Pisang', 4),
	('1112072004', '111207', 'Ujung Tanah', 4),
	('1112072005', '111207', 'Alue Dama', 4),
	('1112072006', '111207', 'IE Lhob', 4),
	('1112072007', '111207', 'Tangan-Tangan Cut', 4),
	('1112082001', '111208', 'Baru', 4),
	('1112082002', '111208', 'Alue Rambot', 4),
	('1112082003', '111208', 'Kuta Jeumpa', 4),
	('1112082004', '111208', 'Alue Sungai Pinang', 4),
	('1112082005', '111208', 'Cot Mane', 4),
	('1112082006', '111208', 'Ladang Neubok', 4),
	('1112082007', '111208', 'Asoe Nanggroe', 4),
	('1112082008', '111208', 'Padang Geulumpang', 4),
	('1112082009', '111208', 'Ikue Lhung', 4),
	('1112082010', '111208', 'Kuta Makmur', 4),
	('1112092001', '111209', 'Meurandeh', 4),
	('1112092002', '111209', 'Sukadamai', 4),
	('1112092003', '111209', 'Cot Bak-U', 4),
	('1112092004', '111209', 'Meunasah Sukon', 4),
	('1112092005', '111209', 'Meunasah Tengah', 4),
	('1112092006', '111209', 'Geulanggang Batee', 4),
	('1112092007', '111209', 'Kuta Paya', 4),
	('1112092008', '111209', 'Ujung Tanah', 4),
	('1112092009', '111209', 'Padang Keulele', 4),
	('1113012001', '111301', 'Kota Blang Kejeran', 4),
	('1113012002', '111301', 'Penampaan', 4),
	('1113012003', '111301', 'Bukit', 4),
	('1113012004', '111301', 'Bacang', 4),
	('1113012005', '111301', 'Durin', 4),
	('1113012007', '111301', 'Kampung Jawa', 4),
	('1113012008', '111301', 'Porang', 4),
	('1113012011', '111301', 'Kute Lintang', 4),
	('1113012014', '111301', 'Leme', 4),
	('1113012016', '111301', 'Gele', 4),
	('1113012017', '111301', 'Sere', 4),
	('1113012018', '111301', 'Cempa', 4),
	('1113012019', '111301', 'Lempuh', 4),
	('1113012021', '111301', 'Palok', 4),
	('1113012022', '111301', 'Penggalangan', 4),
	('1113012027', '111301', 'Agusan', 4),
	('1113012031', '111301', 'Bustanussalam', 4),
	('1113012032', '111301', 'Penampaan Uken', 4),
	('1113012033', '111301', 'Raklunung', 4),
	('1113012034', '111301', 'Sepang', 4),
	('1113022002', '111302', 'Tampeng', 4),
	('1113022004', '111302', 'Bener', 4),
	('1113022005', '111302', 'Ulun Tanah', 4),
	('1113022006', '111302', 'Kuta Ujung', 4),
	('1113022008', '111302', 'Beranang', 4),
	('1113022010', '111302', 'Rikit Dekat', 4),
	('1113022011', '111302', 'Rema', 4),
	('1113022014', '111302', 'Rema Baru', 4),
	('1113022015', '111302', 'Cike', 4),
	('1113022016', '111302', 'Kerukunan Kuta Pjg.', 4),
	('1113022020', '111302', 'Tampeng Musara', 4),
	('1113022021', '111302', 'Kong Paluh', 4),
	('1113032001', '111303', 'Ampa Kolak', 4),
	('1113032002', '111303', 'Cane Toa', 4),
	('1113032003', '111303', 'Padang Pasir', 4),
	('1113032005', '111303', 'Pinang Rugub', 4),
	('1113032006', '111303', 'Kuning', 4),
	('1113032008', '111303', 'Mangang', 4),
	('1113032011', '111303', 'Rempelam', 4),
	('1113032012', '111303', 'Cane Uken', 4),
	('1113032013', '111303', 'Tungel', 4),
	('1113032014', '111303', 'Kota Rikit Gaib', 4),
	('1113032016', '111303', 'Lukup Baru', 4),
	('1113032017', '111303', 'Penomon Jaya', 4),
	('1113032018', '111303', 'Tungel Baru', 4),
	('1113042001', '111304', 'Jabo', 4),
	('1113042002', '111304', 'Kutesange', 4),
	('1113042003', '111304', 'Padang', 4),
	('1113042006', '111304', 'Rumpi', 4),
	('1113042007', '111304', 'Bukut', 4),
	('1113042008', '111304', 'Terangon', 4),
	('1113042010', '111304', 'Rempelan Pinang', 4),
	('1113042011', '111304', 'Soyo', 4),
	('1113042012', '111304', 'Terlis', 4),
	('1113042013', '111304', 'Kute Reje', 4),
	('1113042014', '111304', 'Persada Tongra', 4),
	('1113042015', '111304', 'Berhut', 4),
	('1113042016', '111304', 'Gewat', 4),
	('1113042017', '111304', 'Pantan Lues', 4),
	('1113042018', '111304', 'Makmur Jaya', 4),
	('1113042020', '111304', 'Blang Kuncir', 4),
	('1113042023', '111304', 'Reje Pudung', 4),
	('1113042024', '111304', 'Garut', 4),
	('1113042025', '111304', 'Telege Jernih', 4),
	('1113042026', '111304', 'Rime Jaya', 4),
	('1113042027', '111304', 'Lestari', 4),
	('1113042028', '111304', 'Gawar Belangi', 4),
	('1113042029', '111304', 'Blang Kala', 4),
	('1113052001', '111305', 'Pining', 4),
	('1113052002', '111305', 'Pertik', 4),
	('1113052003', '111305', 'Ekan', 4),
	('1113052004', '111305', 'Uring', 4),
	('1113052005', '111305', 'Gajah', 4),
	('1113052006', '111305', 'Pintu Rime', 4),
	('1113052007', '111305', 'Pepelah', 4),
	('1113052008', '111305', 'Pasir Putih', 4),
	('1113052009', '111305', 'Lesten', 4),
	('1113062001', '111306', 'Gantung Geluni', 4),
	('1113062002', '111306', 'Kuta Bukit', 4),
	('1113062003', '111306', 'Bener Baru', 4),
	('1113062004', '111306', 'Blangbengkik', 4),
	('1113062005', '111306', 'Kong', 4),
	('1113062006', '111306', 'Ume Lah', 4),
	('1113062007', '111306', 'Cinta Maju', 4),
	('1113062008', '111306', 'Porang Ayu', 4),
	('1113062009', '111306', 'Tetingi', 4),
	('1113062010', '111306', 'Anak Reje', 4),
	('1113062011', '111306', 'Rak Lintang', 4),
	('1113062012', '111306', 'Akang Siwah', 4),
	('1113072001', '111307', 'Gumpang', 4),
	('1113072002', '111307', 'Marpunge', 4),
	('1113072003', '111307', 'Ramung Musara', 4),
	('1113072004', '111307', 'Meloak Sepakat', 4),
	('1113072005', '111307', 'Kutelengat Sepakat', 4),
	('1113072006', '111307', 'Singah Mulo', 4),
	('1113072007', '111307', 'Uning Pune', 4),
	('1113072008', '111307', 'Gumpang Lempuh', 4),
	('1113072009', '111307', 'Putri Betung', 4),
	('1113082001', '111308', 'Pangur', 4),
	('1113082002', '111308', 'Badak', 4),
	('1113082003', '111308', 'Kendawi', 4),
	('1113082004', '111308', 'Sangir', 4),
	('1113082005', '111308', 'Panglime Linting', 4),
	('1113082006', '111308', 'Blangtemung', 4),
	('1113082007', '111308', 'Rerebe', 4),
	('1113082008', '111308', 'Uning Gelung', 4),
	('1113082009', '111308', 'Uning Sepakat', 4),
	('1113092001', '111309', 'Penosan', 4),
	('1113092002', '111309', 'Sekuelen', 4),
	('1113092003', '111309', 'Akul', 4),
	('1113092004', '111309', 'Gegarang', 4),
	('1113092005', '111309', 'Peparik Gaib', 4),
	('1113092006', '111309', 'Penosan Sepakat', 4),
	('1113092007', '111309', 'Tingkem', 4),
	('1113092008', '111309', 'Ketukah', 4),
	('1113092009', '111309', 'Peparik Dekat', 4),
	('1113092010', '111309', 'Blang Jerango', 4),
	('1113102001', '111310', 'Perlak', 4),
	('1113102002', '111310', 'Rerebe', 4),
	('1113102003', '111310', 'Pasir', 4),
	('1113102004', '111310', 'Setul', 4),
	('1113102005', '111310', 'UPT Paya Kumer', 4),
	('1113102006', '111310', 'UPT Pantan Kela', 4),
	('1113102007', '111310', 'Buntul Musara', 4),
	('1113102008', '111310', 'Kuala Jernih', 4),
	('1113102009', '111310', 'Uyem Beriring', 4),
	('1113102010', '111310', 'Pulo Gelime', 4),
	('1113112001', '111311', 'Seneran', 4),
	('1113112002', '111311', 'Remukut', 4),
	('1113112003', '111311', 'Kenyaran', 4),
	('1113112004', '111311', 'Tetinggi', 4),
	('1113112005', '111311', 'Atu Kapur', 4),
	('1113112006', '111311', 'Suri Musara', 4),
	('1113112007', '111311', 'UPT Aih Selah', 4),
	('1113112008', '111311', 'Cane Baru', 4),
	('1113112009', '111311', 'Kuning Kurnia', 4),
	('1114012001', '111401', 'Keude Teunom', 4),
	('1114012002', '111401', 'Alue Ambang', 4),
	('1114012003', '111401', 'Padang Kleng', 4),
	('1114012004', '111401', 'Panton', 4),
	('1114012005', '111401', 'Pasi Tolak Bala', 4),
	('1114012006', '111401', 'Gampong Baru', 4),
	('1114012007', '111401', 'Rambong Payong', 4),
	('1114012008', '111401', 'Pasi Pawang', 4),
	('1114012009', '111401', 'Blang Baro', 4),
	('1114012010', '111401', 'Tanoh Anoe', 4),
	('1114012011', '111401', 'Tanoh Manyang', 4),
	('1114012012', '111401', 'Batee Roo', 4),
	('1114012013', '111401', 'Seuneubok Padang', 4),
	('1114012014', '111401', 'Seumira', 4),
	('1114012015', '111401', 'Kubu', 4),
	('1114012016', '111401', 'Alue Meuraxa', 4),
	('1114012017', '111401', 'Paya Baro', 4),
	('1114012018', '111401', 'Teupin Ara', 4),
	('1114012019', '111401', 'Cot Trap', 4),
	('1114012020', '111401', 'Leung Gayo', 4),
	('1114012021', '111401', 'Pasi Geulima', 4),
	('1114012022', '111401', 'Pasi Timon', 4),
	('1114022001', '111402', 'Bahagia', 4),
	('1114022002', '111402', 'Sentosa', 4),
	('1114022003', '111402', 'Dayah Baro', 4),
	('1114022004', '111402', 'Gampong Blang', 4),
	('1114022005', '111402', 'Keutapang', 4),
	('1114022006', '111402', 'Panton Makmur', 4),
	('1114022007', '111402', 'Keude Krueng Sabe', 4),
	('1114022008', '111402', 'Kabong', 4),
	('1114022009', '111402', 'Padang Datar', 4),
	('1114022010', '111402', 'Datar Luas', 4),
	('1114022011', '111402', 'Ranto Panyang', 4),
	('1114022012', '111402', 'Buntha', 4),
	('1114022013', '111402', 'Panggong', 4),
	('1114022014', '111402', 'Curek', 4),
	('1114022015', '111402', 'Alue Tho', 4),
	('1114022016', '111402', 'Mon Mata', 4),
	('1114022017', '111402', 'Paya Seumantok', 4),
	('1114032001', '111403', 'Sawang', 4),
	('1114032002', '111403', 'Lhok Geulumpang', 4),
	('1114032003', '111403', 'Padang', 4),
	('1114032004', '111403', 'Gunong Meunasah', 4),
	('1114032005', '111403', 'Sapek', 4),
	('1114032006', '111403', 'Pante Kuyun', 4),
	('1114032007', '111403', 'Gle Seubak', 4),
	('1114032008', '111403', 'Gampong Baroh', 4),
	('1114032009', '111403', 'Lhok Timon', 4),
	('1114032010', '111403', 'Gampong Baro', 4),
	('1114032011', '111403', 'Lhok Buya', 4),
	('1114032012', '111403', 'Lhok Bot', 4),
	('1114032013', '111403', 'Paya Laot', 4),
	('1114042001', '111404', 'Lhok Kruet', 4),
	('1114042002', '111404', 'Pulo Raya', 4),
	('1114042003', '111404', 'Meunasah Kulam', 4),
	('1114042004', '111404', 'Crak Mong', 4),
	('1114042005', '111404', 'Alue Gro', 4),
	('1114042006', '111404', 'Kuala Ligan', 4),
	('1114042007', '111404', 'Babah Nipah', 4),
	('1114042008', '111404', 'Jeumpeuk', 4),
	('1114042009', '111404', 'Cot Langsat', 4),
	('1114042010', '111404', 'Mata IE', 4),
	('1114042011', '111404', 'Blang Monlueng', 4),
	('1114042012', '111404', 'Krueng No', 4),
	('1114042013', '111404', 'Seumantok', 4),
	('1114042014', '111404', 'Ranto Sabon', 4),
	('1114042015', '111404', 'Ligan', 4),
	('1114042016', '111404', 'Ie Jeureungeh', 4),
	('1114042020', '111404', 'Kuala Bakong', 4),
	('1114042036', '111404', 'Cot Punti', 4),
	('1114042037', '111404', 'Krueng Ayon', 4),
	('1114052011', '111405', 'Pante Cermin', 4),
	('1114052012', '111405', 'Sabet', 4),
	('1114052013', '111405', 'Sango', 4),
	('1114052014', '111405', 'Mareu', 4),
	('1114052015', '111405', 'Lam Asan', 4),
	('1114052016', '111405', 'Alue Rayeuk', 4),
	('1114052017', '111405', 'Sapek', 4),
	('1114052018', '111405', 'Lambaroh', 4),
	('1114052019', '111405', 'Meudheun', 4),
	('1114052020', '111405', 'Babah Ie', 4),
	('1114052021', '111405', 'Ujong Sedheun', 4),
	('1114052022', '111405', 'Kreung Tunong', 4),
	('1114052023', '111405', 'Jambo Masi', 4),
	('1114052024', '111405', 'Lam Tui', 4),
	('1114052025', '111405', 'Pasar Lamno', 4),
	('1114052026', '111405', 'Meunasah Weh', 4),
	('1114052027', '111405', 'Bak Paoh', 4),
	('1114052028', '111405', 'Babah Krueng', 4),
	('1114052029', '111405', 'Cot Dulang', 4),
	('1114052030', '111405', 'Lam Durian', 4),
	('1114052031', '111405', 'Putue', 4),
	('1114052032', '111405', 'Gle Putoh', 4),
	('1114052033', '111405', 'Pante Keutapang', 4),
	('1114052034', '111405', 'Lam Me', 4),
	('1114052035', '111405', 'Meunasah Serba', 4),
	('1114052036', '111405', 'Leupe', 4),
	('1114052037', '111405', 'Meutara', 4),
	('1114052038', '111405', 'Lhuet', 4),
	('1114052039', '111405', 'Gle Jong', 4),
	('1114052040', '111405', 'Darat', 4),
	('1114052041', '111405', 'Gampong Baro', 4),
	('1114052042', '111405', 'Panton Makmur', 4),
	('1114052043', '111405', 'Rumpet', 4),
	('1114052044', '111405', 'Nusa', 4),
	('1114062001', '111406', 'Keude Panga', 4),
	('1114062002', '111406', 'Kuta Tuha', 4),
	('1114062003', '111406', 'Tuwi Kareung', 4),
	('1114062004', '111406', 'Ladang Baro', 4),
	('1114062005', '111406', 'Panton Krueng', 4),
	('1114062006', '111406', 'Gle Putoh', 4),
	('1114062007', '111406', 'Alue Pande', 4),
	('1114062008', '111406', 'Batee Meutudong', 4),
	('1114062009', '111406', 'Gampong Harapan', 4),
	('1114062010', '111406', 'Gunong Buloh', 4),
	('1114062011', '111406', 'Gunong Meulinteung', 4),
	('1114062013', '111406', 'Alue Abed', 4),
	('1114062014', '111406', 'Gunong Mantok', 4),
	('1114062015', '111406', 'Alue Raya', 4),
	('1114062016', '111406', 'Alue Teungoh', 4),
	('1114062017', '111406', 'Babah Ceupan', 4),
	('1114062018', '111406', 'Tuwi Empeuk', 4),
	('1114062019', '111406', 'Panton Kabu', 4),
	('1114062020', '111406', 'Tuwi Kayee', 4),
	('1114062021', '111406', 'Alue Piet', 4),
	('1114072001', '111407', 'Ujung Muloh', 4),
	('1114072002', '111407', 'Jangeut', 4),
	('1114072003', '111407', 'Meunasah Rayeuk', 4),
	('1114072004', '111407', 'Mukhan', 4),
	('1114072005', '111407', 'Meunasah Teungoh', 4),
	('1114072006', '111407', 'Meunasah Tutong', 4),
	('1114072007', '111407', 'Babah Dua', 4),
	('1114072008', '111407', 'Alue Mie', 4),
	('1114072009', '111407', 'Teumareum', 4),
	('1114072010', '111407', 'Kuala', 4),
	('1114072011', '111407', 'Meudhang Ghon', 4),
	('1114072012', '111407', 'Kareung Ateuh', 4),
	('1114072013', '111407', 'Keude Unga', 4),
	('1114072014', '111407', 'Ceunamprong', 4),
	('1114082001', '111408', 'Patek', 4),
	('1114082002', '111408', 'Gampong Baro Patek', 4),
	('1114082003', '111408', 'Blang Dalam', 4),
	('1114082004', '111408', 'Pajar', 4),
	('1114082005', '111408', 'Reuntang', 4),
	('1114082006', '111408', 'Cot Pange', 4),
	('1114082007', '111408', 'Arongan', 4),
	('1114082008', '111408', 'Paya Santeut', 4),
	('1114082009', '111408', 'Kreung Tho', 4),
	('1114082010', '111408', 'Panton Krueng', 4),
	('1114082011', '111408', 'Alue Gajah', 4),
	('1114082012', '111408', 'Sayeung', 4),
	('1114082013', '111408', 'Gunong Cut', 4),
	('1114082014', '111408', 'Ujong Rimba', 4),
	('1114082015', '111408', 'Lamteungoh', 4),
	('1114082016', '111408', 'Gampong Baro Lamtengoh', 4),
	('1114082017', '111408', 'Babah Dua', 4),
	('1114082018', '111408', 'Masen', 4),
	('1114082019', '111408', 'Teupin Asan', 4),
	('1114092001', '111409', 'Pulo Tinggi', 4),
	('1114092002', '111409', 'Alue Krueng', 4),
	('1114092003', '111409', 'Pasi Teubee', 4),
	('1114092004', '111409', 'Timpleng', 4),
	('1114092005', '111409', 'Krueng Beukah', 4),
	('1114092006', '111409', 'Tuwi Kareung', 4),
	('1114092007', '111409', 'Lhok Guci', 4),
	('1114092008', '111409', 'Tuwi Peuriya', 4),
	('1114092009', '111409', 'Sarah Raya', 4),
	('1114092010', '111409', 'Alue Jang', 4),
	('1114092011', '111409', 'Ceuracee', 4),
	('1114092012', '111409', 'Alue Punti', 4),
	('1114092013', '111409', 'Bintah', 4),
	('1114092014', '111409', 'Buket Keumuning', 4),
	('1115012003', '111501', 'Lawa Batu', 4),
	('1115012004', '111501', 'Jogja', 4),
	('1115012019', '111501', 'Ujong Sikuneng', 4),
	('1115012020', '111501', 'Blang Muko', 4),
	('1115012021', '111501', 'Pulo Ie', 4),
	('1115012022', '111501', 'Purworejo', 4),
	('1115012023', '111501', 'Blang Baro', 4),
	('1115012024', '111501', 'Alue Ie Mameh', 4),
	('1115012025', '111501', 'Ujong Pasi', 4),
	('1115012026', '111501', 'Simpang Peut', 4),
	('1115012027', '111501', 'Blang Teungoh', 4),
	('1115012028', '111501', 'Ujong Padang', 4),
	('1115012029', '111501', 'Cot Kumbang', 4),
	('1115012030', '111501', 'Blang Bintang', 4),
	('1115012031', '111501', 'Ujong Patihah', 4),
	('1115012032', '111501', 'Kuta Makmue', 4),
	('1115012033', '111501', 'Gunong Reubo', 4),
	('1115022001', '111502', 'Jeuram', 4),
	('1115022002', '111502', 'Pante Ceureumen', 4),
	('1115022003', '111502', 'Kuta Baro Jeuram', 4),
	('1115022004', '111502', 'Parom', 4),
	('1115022005', '111502', 'Peureulak', 4),
	('1115022006', '111502', 'Kuta Sayeh', 4),
	('1115022007', '111502', 'Blang Baro', 4),
	('1115022008', '111502', 'Padang', 4),
	('1115022009', '111502', 'Alue Tho', 4),
	('1115022010', '111502', 'Lhok Parom', 4),
	('1115022011', '111502', 'Sapek', 4),
	('1115022012', '111502', 'Alue Dodok', 4),
	('1115022013', '111502', 'Cot Kumbang', 4),
	('1115022014', '111502', 'Kuta Kumbang', 4),
	('1115022015', '111502', 'Nigan', 4),
	('1115022016', '111502', 'Gampong Cot', 4),
	('1115022017', '111502', 'Blang Pateuk', 4),
	('1115022018', '111502', 'Blang Puuk Nigan', 4),
	('1115022019', '111502', 'Krueng Ceh', 4),
	('1115022020', '111502', 'Bantan', 4),
	('1115022021', '111502', 'Cot Lele', 4),
	('1115022022', '111502', 'Rambong Rayeuk', 4),
	('1115022023', '111502', 'Paya Udeung', 4),
	('1115022024', '111502', 'Alue Buloh', 4),
	('1115022025', '111502', 'Kuta Paya', 4),
	('1115022026', '111502', 'Krueng Ceuko', 4),
	('1115022027', '111502', 'Lhok Padang', 4),
	('1115022028', '111502', 'Kuta Aceh', 4),
	('1115022029', '111502', 'Krueng Mangkom', 4),
	('1115022030', '111502', 'Latong', 4),
	('1115022031', '111502', 'Paya Undan', 4),
	('1115022032', '111502', 'Blang Puuk Kulu', 4),
	('1115022033', '111502', 'Blang Murong', 4),
	('1115022034', '111502', 'Kulu', 4),
	('1115022035', '111502', 'Rambong Cut', 4),
	('1115032001', '111503', 'Blang Penyang', 4),
	('1115032002', '111503', 'Meugat Meh', 4),
	('1115032003', '111503', 'Lhok Pange', 4),
	('1115032004', '111503', 'Blang Lango', 4),
	('1115032005', '111503', 'Tuwi Meuleusong', 4),
	('1115032006', '111503', 'Blang Geudong', 4),
	('1115032007', '111503', 'Blang Teungku', 4),
	('1115032008', '111503', 'Sawang Mane', 4),
	('1115032009', '111503', 'Keude Neulop', 4),
	('1115032010', '111503', 'Kila', 4),
	('1115032011', '111503', 'Kandeh', 4),
	('1115032012', '111503', 'Cot Gud', 4),
	('1115032013', '111503', 'Kabu Baroh', 4),
	('1115032014', '111503', 'Kabu Tunong', 4),
	('1115032015', '111503', 'Keude Linteung', 4),
	('1115032016', '111503', 'Meurandeh Suak', 4),
	('1115032017', '111503', 'Uteun Pulo', 4),
	('1115032018', '111503', 'Cot Manyang', 4),
	('1115032019', '111503', 'Pulo Teungoh', 4),
	('1115032020', '111503', 'Cot Dirui', 4),
	('1115032021', '111503', 'Cot Teuku Dek', 4),
	('1115032022', '111503', 'Sapeng', 4),
	('1115032023', '111503', 'Peuleukung', 4),
	('1115032024', '111503', 'Paya', 4),
	('1115032025', '111503', 'Blang Preh', 4),
	('1115032026', '111503', 'Blang Ara Keude', 4),
	('1115032027', '111503', 'Blang Ara Gampong', 4),
	('1115032028', '111503', 'Ie Beudoh', 4),
	('1115032029', '111503', 'Blang Bayu', 4),
	('1115032030', '111503', 'Mon Bateung', 4),
	('1115032031', '111503', 'Suak Peureubong', 4),
	('1115032032', '111503', 'Krueng Kulu', 4),
	('1115032033', '111503', 'Cot Punti', 4),
	('1115032034', '111503', 'Lhok Mesjid', 4),
	('1115042001', '111504', 'Blang Seunong', 4),
	('1115042002', '111504', 'Pante Ara', 4),
	('1115042003', '111504', 'Gunong Nagan', 4),
	('1115042004', '111504', 'Tuwi Bunta', 4),
	('1115042005', '111504', 'Blang Mesjid', 4),
	('1115042006', '111504', 'Blang Neuang', 4),
	('1115042007', '111504', 'Panton Bayam', 4),
	('1115042008', '111504', 'Blang Baro P. Raga', 4),
	('1115042009', '111504', 'Krueng Cut', 4),
	('1115042010', '111504', 'Blang Leumak', 4),
	('1115042011', '111504', 'Babah Krueng', 4),
	('1115042012', '111504', 'Blang Seumot', 4),
	('1115042013', '111504', 'Lhok Seumot', 4),
	('1115042014', '111504', 'Meunasah Pante', 4),
	('1115042015', '111504', 'Kuta Jeumpa', 4),
	('1115042016', '111504', 'Blang Dalam', 4),
	('1115042017', '111504', 'Keude Seumot', 4),
	('1115042018', '111504', 'Blang Baro Rambong', 4),
	('1115042019', '111504', 'Ujong Blang', 4),
	('1115042020', '111504', 'Meunasah Krueng', 4),
	('1115042021', '111504', 'Meunasah Dayah', 4),
	('1115042022', '111504', 'Meunasah Teungoh', 4),
	('1115042023', '111504', 'Kulam Jerneh', 4),
	('1115042028', '111504', 'Bumi Sari', 4),
	('1115052012', '111505', 'Lamie', 4),
	('1115052013', '111505', 'Kuta Trieng', 4),
	('1115052014', '111505', 'Gelanggang Gajah', 4),
	('1115052015', '111505', 'Kayee Unoe', 4),
	('1115052016', '111505', 'Blang Baro', 4),
	('1115052017', '111505', 'Alue Bilie', 4),
	('1115052018', '111505', 'Suka Raja', 4),
	('1115052019', '111505', 'Gunong Cut', 4),
	('1115052020', '111505', 'Suka Jadi', 4),
	('1115052021', '111505', 'Tuwi Buya', 4),
	('1115052022', '111505', 'Ujong Lamie', 4),
	('1115052023', '111505', 'Suak Palembang', 4),
	('1115052024', '111505', 'Alue Waki', 4),
	('1115052025', '111505', 'Alue Geutah', 4),
	('1115052026', '111505', 'Krueng Alem', 4),
	('1115052027', '111505', 'Alue Rambot', 4),
	('1115052028', '111505', 'Krueng Seumanyam', 4),
	('1115052029', '111505', 'Pulo Teungoh', 4),
	('1115052030', '111505', 'Karang Anyer', 4),
	('1115052031', '111505', 'Kuala Seumanyam', 4),
	('1115052032', '111505', 'Pulo Ie', 4),
	('1115052033', '111505', 'Pulo Kruet', 4),
	('1115052034', '111505', 'Alue Kuyun', 4),
	('1115052035', '111505', 'Alue Raya', 4),
	('1115052036', '111505', 'Alue Jampak', 4),
	('1115052037', '111505', 'Suka Mulia', 4),
	('1115052038', '111505', 'Simpang Dua', 4),
	('1115052039', '111505', 'Sido Jadi', 4),
	('1115052040', '111505', 'Serba Jadi', 4),
	('1115052041', '111505', 'Serba Guna', 4),
	('1115052042', '111505', 'Sp. Deli Kilang', 4),
	('1115052043', '111505', 'Panton Bayu', 4),
	('1115052044', '111505', 'Ujong Tanjong', 4),
	('1115052045', '111505', 'Suka Ramai', 4),
	('1115052046', '111505', 'Ladang Baro', 4),
	('1115052047', '111505', 'Alue Bateung Brok', 4),
	('1115052048', '111505', 'Sp. Deli Kampong', 4),
	('1115052049', '111505', 'Blang Luah', 4),
	('1115052050', '111505', 'Sumber Makmur', 4),
	('1115052051', '111505', 'Makarti Jaya', 4),
	('1115062001', '111506', 'Lueng Baro', 4),
	('1115062002', '111506', 'Alue Kambuk', 4),
	('1115062003', '111506', 'Kuta Padang', 4),
	('1115062004', '111506', 'Suak Bilie', 4),
	('1115062005', '111506', 'Macah', 4),
	('1115062006', '111506', 'Seumambek', 4),
	('1115062007', '111506', 'Cot Kuta', 4),
	('1115062008', '111506', 'Kabu Blang Sapek', 4),
	('1115062009', '111506', 'Cot Peuradi', 4),
	('1115062010', '111506', 'Blang Sapek', 4),
	('1115062011', '111506', 'Lhok Beutong', 4),
	('1115062012', '111506', 'Gampong Teungoh', 4),
	('1115062013', '111506', 'Lhok Rameuan', 4),
	('1115062014', '111506', 'Blang Muling', 4),
	('1115062015', '111506', 'Krak Tampai', 4),
	('1115062016', '111506', 'Meureubo', 4),
	('1115062017', '111506', 'Kuta Baro Blang Muling', 4),
	('1115062018', '111506', 'Alue Peusaja', 4),
	('1115062019', '111506', 'Alue Gajah', 4),
	('1115072001', '111507', 'Suak Puntong', 4),
	('1115072002', '111507', 'Gampong Lhok', 4),
	('1115072003', '111507', 'Kuala Baro', 4),
	('1115072004', '111507', 'Padang Rubek', 4),
	('1115072005', '111507', 'Pulo', 4),
	('1115072006', '111507', 'Langkak', 4),
	('1115072007', '111507', 'Kuala Tuha', 4),
	('1115072008', '111507', 'Kubang Gajah', 4),
	('1115072009', '111507', 'Kuala Trang', 4),
	('1115072010', '111507', 'Cot Rambong', 4),
	('1115072011', '111507', 'Padang Panyang', 4),
	('1115072012', '111507', 'Arongan', 4),
	('1115072013', '111507', 'Jati Rejo', 4),
	('1115072014', '111507', 'Purwodadi', 4),
	('1115072015', '111507', 'Leung Teuku Ben', 4),
	('1115072016', '111507', 'Purwosari', 4),
	('1115082001', '111508', 'Alue Bata', 4),
	('1115082002', '111508', 'Gunong Sapek', 4),
	('1115082003', '111508', 'Sarah Mantok', 4),
	('1115082004', '111508', 'Pasie Luah', 4),
	('1115082005', '111508', 'Gunong Geulugo', 4),
	('1115082006', '111508', 'Gunong Keupok', 4),
	('1115082007', '111508', 'Gunong Pungki', 4),
	('1115082008', '111508', 'Alue Siron', 4),
	('1115082009', '111508', 'Cot Mue', 4),
	('1115082010', '111508', 'Babah Rot', 4),
	('1115082011', '111508', 'Babah Dua', 4),
	('1115082012', '111508', 'Batu Raja', 4),
	('1115082013', '111508', 'Simpang Jaya', 4),
	('1115082014', '111508', 'Sumber Daya', 4),
	('1115082015', '111508', 'Ranto Selamat', 4),
	('1115082016', '111508', 'Alue Seupeung', 4),
	('1115082017', '111508', 'Krueng Itam', 4),
	('1115082018', '111508', 'Alue Gajah', 4),
	('1115082019', '111508', 'Alue Labu', 4),
	('1115082020', '111508', 'Gapa Garu', 4),
	('1115082021', '111508', 'Kuala Tadu', 4),
	('1115082022', '111508', 'Cot Mee', 4),
	('1115092001', '111509', 'Kuala Tripa', 4),
	('1115092002', '111509', 'Babah Lueng', 4),
	('1115092003', '111509', 'Drien Tujoh', 4),
	('1115092004', '111509', 'Lueng Keube Jagat', 4),
	('1115092005', '111509', 'Kabu', 4),
	('1115092006', '111509', 'Pasie Keube Dom', 4),
	('1115092007', '111509', 'Neubok Yee PK', 4),
	('1115092008', '111509', 'Neubok Yee PP', 4),
	('1115092009', '111509', 'Mon Dua', 4),
	('1115092010', '111509', 'Ujong Krueng', 4),
	('1115092011', '111509', 'Panton Pange', 4),
	('1115102001', '111510', 'Blang Puuk', 4),
	('1115102002', '111510', 'Babah Suak', 4),
	('1115102003', '111510', 'Kuta Teungoh', 4),
	('1115102004', '111510', 'Blang Meurandeh', 4),
	('1116012001', '111601', 'Simpang Lhee', 4),
	('1116012002', '111601', 'Buket Panyang Sa', 4),
	('1116012003', '111601', 'Buket Panyang Dua', 4),
	('1116012004', '111601', 'Seuneubok Baro', 4),
	('1116012005', '111601', 'Sampaimah', 4),
	('1116012006', '111601', 'Krueng Sikajang', 4),
	('1116012007', '111601', 'Seuneubok Punti', 4),
	('1116012008', '111601', 'Mesjid', 4),
	('1116012009', '111601', 'Paya Ketenggar', 4),
	('1116012010', '111601', 'Pahlawan', 4),
	('1116012011', '111601', 'Matang Ara Aceh', 4),
	('1116012012', '111601', 'Ie Bintah', 4),
	('1116012013', '111601', 'Geudham', 4),
	('1116012014', '111601', 'Geulanggang Merak', 4),
	('1116012015', '111601', 'Bukit Paya', 4),
	('1116012016', '111601', 'Dagang Setia', 4),
	('1116012017', '111601', 'Meunasah Paya', 4),
	('1116012018', '111601', 'Benteng Anyer', 4),
	('1116012019', '111601', 'Tanjong Neuraca', 4),
	('1116012020', '111601', 'Lueng Manyo', 4),
	('1116012021', '111601', 'Tualang Baro', 4),
	('1116012022', '111601', 'Lhok Medang Ara', 4),
	('1116012023', '111601', 'Kaseh Sayang', 4),
	('1116012024', '111601', 'Seuneubok Pidie', 4),
	('1116012025', '111601', 'Matang Cincin', 4),
	('1116012026', '111601', 'Matang Ara Jawa', 4),
	('1116012027', '111601', 'Meurandeh', 4),
	('1116012028', '111601', 'Raja Tuha', 4),
	('1116012029', '111601', 'Ujong Tanjong', 4),
	('1116012030', '111601', 'Alue Ie Puteh', 4),
	('1116012031', '111601', 'Alue Sentang', 4),
	('1116012032', '111601', 'Seuneubok Cantek', 4),
	('1116012033', '111601', 'Sapta Marga', 4),
	('1116012034', '111601', 'Paya Baru', 4),
	('1116012035', '111601', 'Bandung Jaya', 4),
	('1116012036', '111601', 'Pandan Sari', 4),
	('1116022001', '111602', 'Mesjid Sungai Iyu', 4),
	('1116022002', '111602', 'Alue Cantek', 4),
	('1116022003', '111602', 'Tanjong Lipat I', 4),
	('1116022004', '111602', 'Tanjong Lipat II', 4),
	('1116022005', '111602', 'Seuneubok Dalam Mesjid', 4),
	('1116022006', '111602', 'Bandar Baru', 4),
	('1116022007', '111602', 'Cinta Raja', 4),
	('1116022008', '111602', 'Kuala Genting', 4),
	('1116022009', '111602', 'Bandar Khalifah', 4),
	('1116022010', '111602', 'Suka Mulia Bendahara', 4),
	('1116022011', '111602', 'Seuneubok Aceh', 4),
	('1116022012', '111602', 'Tengku Tinggi', 4),
	('1116022013', '111602', 'Perk. Sungai Iyu', 4),
	('1116022014', '111602', 'Marlempang', 4),
	('1116022015', '111602', 'Balai', 4),
	('1116022016', '111602', 'Lubok Bathil', 4),
	('1116022017', '111602', 'Lambung Blang', 4),
	('1116022018', '111602', 'Tanjong Parit', 4),
	('1116022019', '111602', 'Tanjong', 4),
	('1116022020', '111602', 'Raja', 4),
	('1116022021', '111602', 'Tumpok Teungoh', 4),
	('1116022029', '111602', 'Upah', 4),
	('1116022030', '111602', 'Perk. Upah', 4),
	('1116022031', '111602', 'Matang Teupah', 4),
	('1116022035', '111602', 'Seuneubok Dalam Upah', 4),
	('1116022036', '111602', 'Mesjid Bendahara', 4),
	('1116022037', '111602', 'Teluk Kemiri', 4),
	('1116022038', '111602', 'Teluk Kepayang', 4),
	('1116022039', '111602', 'Teluk Halban', 4),
	('1116022040', '111602', 'Rantau Pakam', 4),
	('1116022041', '111602', 'Tanjong Binjei', 4),
	('1116022042', '111602', 'Tanjong Mulia', 4),
	('1116022043', '111602', 'Kuala Penaga', 4),
	('1116032001', '111603', 'Kesehatan', 4),
	('1116032002', '111603', 'Suka Jadi', 4),
	('1116032006', '111603', 'Menanggini', 4),
	('1116032007', '111603', 'Tanjong Karang', 4),
	('1116032009', '111603', 'Bundar', 4),
	('1116032011', '111603', 'Dalam', 4),
	('1116032012', '111603', 'Tana Terban', 4),
	('1116032013', '111603', 'Air Tenang', 4),
	('1116032014', '111603', 'Johar', 4),
	('1116032015', '111603', 'Tupah', 4),
	('1116032016', '111603', 'Banai', 4),
	('1116032017', '111603', 'Rantau Panjang', 4),
	('1116032018', '111603', 'Meudang Ara', 4),
	('1116032019', '111603', 'Pahlawan', 4),
	('1116032020', '111603', 'Alur Selaras', 4),
	('1116032021', '111603', 'Paya Tampah', 4),
	('1116032022', '111603', 'Alur Baung', 4),
	('1116032023', '111603', 'Kebun T. Terban', 4),
	('1116032024', '111603', 'Kebun Medang Ara', 4),
	('1116032025', '111603', 'Kebun Afdeling S', 4),
	('1116032026', '111603', 'Paya Awe', 4),
	('1116032027', '111603', 'Simpang Empat', 4),
	('1116032028', '111603', 'Paya Kulbi', 4),
	('1116032029', '111603', 'Alur Bemban', 4),
	('1116032030', '111603', 'Paya Meta', 4),
	('1116032031', '111603', 'Tanjong Seumantoh', 4),
	('1116032032', '111603', 'Kebun Bukit Keranji', 4),
	('1116032033', '111603', 'Kb Tj. Seumentotoh', 4),
	('1116032034', '111603', 'Bukit Panjang', 4),
	('1116032035', '111603', 'Alue Lhok', 4),
	('1116032036', '111603', 'Sukajadi Paya Bj', 4),
	('1116042002', '111604', 'Seruway/Peukan', 4),
	('1116042003', '111604', 'Binjai', 4),
	('1116042004', '111604', 'Pantai Balee', 4),
	('1116042005', '111604', 'Padang Langgis', 4),
	('1116042006', '111604', 'Suka Ramai Satu', 4),
	('1116042007', '111604', 'Suka Ramai Dua', 4),
	('1116042008', '111604', 'Perkebunan Seruway', 4),
	('1116042009', '111604', 'Gedung Biara', 4),
	('1116042010', '111604', 'Alur Alim', 4),
	('1116042011', '111604', 'Tualang', 4),
	('1116042012', '111604', 'Matang Sentang', 4),
	('1116042013', '111604', 'Air Masin', 4),
	('1116042014', '111604', 'Sidodadi', 4),
	('1116042015', '111604', 'Perkebunan Gd Biara', 4),
	('1116042016', '111604', 'Muka Sungai Kuruk', 4),
	('1116042017', '111604', 'Paya Udang', 4),
	('1116042018', '111604', 'Gelung', 4),
	('1116042019', '111604', 'Kampung Baru', 4),
	('1116042020', '111604', 'Kuala Pusong Kapal', 4),
	('1116042021', '111604', 'Sungai Kuruk I', 4),
	('1116042022', '111604', 'Sungai Kuruk II', 4),
	('1116042023', '111604', 'Sungai Kuruk III', 4),
	('1116042024', '111604', 'Tangsi Lama', 4),
	('1116042025', '111604', 'Lubuk Damar', 4),
	('1116052001', '111605', 'Kota Kuala Simpang', 4),
	('1116052002', '111605', 'Perdamaian', 4),
	('1116052003', '111605', 'Sriwijaya', 4),
	('1116052004', '111605', 'Bukit Tempurung', 4),
	('1116052005', '111605', 'Kota Lintang', 4),
	('1116062001', '111606', 'Bukit Rata', 4),
	('1116062002', '111606', 'Pangkalan', 4),
	('1116062003', '111606', 'Tanjung Mancang', 4),
	('1116062004', '111606', 'Simpang Kanan', 4),
	('1116062005', '111606', 'Tanjung Genteng', 4),
	('1116062006', '111606', 'Gerenggam', 4),
	('1116062007', '111606', 'Suka Makmur', 4),
	('1116062008', '111606', 'Alur Selabu', 4),
	('1116062010', '111606', 'Sungai Liput', 4),
	('1116062011', '111606', 'Kebun Sungai Liput', 4),
	('1116062012', '111606', 'Purwodadi', 4),
	('1116062013', '111606', 'Kp. Jawa Sungai L', 4),
	('1116062014', '111606', 'Sidodadi S Liput', 4),
	('1116062015', '111606', 'Karang Jadi', 4),
	('1116062016', '111606', 'Seumadam', 4),
	('1116072001', '111607', 'Alur Tani I', 4),
	('1116072002', '111607', 'Alur Tani II', 4),
	('1116072003', '111607', 'Bandar Khalifah', 4),
	('1116072004', '111607', 'Kaloy', 4),
	('1116072005', '111607', 'Perk. Pulai Tiga', 4),
	('1116072006', '111607', 'Harum Sari', 4),
	('1116072007', '111607', 'Bandar Setia', 4),
	('1116072008', '111607', 'Rongoh', 4),
	('1116072010', '111607', 'Wono Sari', 4),
	('1116082001', '111608', 'Benua Raja', 4),
	('1116082002', '111608', 'Landuh', 4),
	('1116082003', '111608', 'Paya Bedi', 4),
	('1116082004', '111608', 'Ingin Jaya', 4),
	('1116082005', '111608', 'Suka Rahmat', 4),
	('1116082006', '111608', 'Suka Jadi', 4),
	('1116082007', '111608', 'Kampong Durian', 4),
	('1116082008', '111608', 'Rantau Pauh', 4),
	('1116082009', '111608', 'Alur Cucur', 4),
	('1116082010', '111608', 'Pertamina', 4),
	('1116082011', '111608', 'Kebun Rantau', 4),
	('1116082012', '111608', 'Alur Manis', 4),
	('1116082013', '111608', 'Jamur Jelatang', 4),
	('1116082014', '111608', 'Suka Rakyat', 4),
	('1116082015', '111608', 'Jamur Labu', 4),
	('1116082016', '111608', 'Suka Mulia', 4),
	('1116092001', '111609', 'Telaga Meuku Sa', 4),
	('1116092002', '111609', 'Telaga Meuku Dua', 4),
	('1116092003', '111609', 'Alur Nunang', 4),
	('1116092004', '111609', 'Tanjong Keuramat', 4),
	('1116092005', '111609', 'Matang Seping', 4),
	('1116092006', '111609', 'Kampung Besar', 4),
	('1116092007', '111609', 'Paya Rahat', 4),
	('1116092008', '111609', 'Suka Jadi', 4),
	('1116092009', '111609', 'Suka Mulia', 4),
	('1116092010', '111609', 'Suka Damai', 4),
	('1116102001', '111610', 'Aras Sembilan', 4),
	('1116102002', '111610', 'Jambo Rambong', 4),
	('1116102003', '111610', 'Blang Kandis', 4),
	('1116102004', '111610', 'Alur Jambu', 4),
	('1116102005', '111610', 'Perk. Alur Jambu', 4),
	('1116102006', '111610', 'Batang Ara', 4),
	('1116102007', '111610', 'Perupuk', 4),
	('1116102008', '111610', 'Serba', 4),
	('1116102009', '111610', 'Sunting', 4),
	('1116102010', '111610', 'Rantau Bintang', 4),
	('1116102011', '111610', 'Babo', 4),
	('1116102012', '111610', 'Pantai Campa', 4),
	('1116102013', '111610', 'Pengidam', 4),
	('1116102014', '111610', 'Bengkelang', 4),
	('1116102015', '111610', 'Batu Bedulang', 4),
	('1116112001', '111611', 'Tebing Tinggi', 4),
	('1116112002', '111611', 'Rimba Sawang', 4),
	('1116112003', '111611', 'Tenggulun', 4),
	('1116112004', '111611', 'Selamat', 4),
	('1116112005', '111611', 'Simpang Kiri', 4),
	('1116122001', '111612', 'Banda Mahligai', 4),
	('1116122002', '111612', 'Sekerak Kiri', 4),
	('1116122003', '111612', 'Pantai Tinjau', 4),
	('1116122004', '111612', 'Pantai Perlak', 4),
	('1116122005', '111612', 'Kebon Batang Ara', 4),
	('1116122006', '111612', 'Sekerak Kanan', 4),
	('1116122007', '111612', 'Lubuk Sidup', 4),
	('1116122008', '111612', 'Sekumur', 4),
	('1116122009', '111612', 'Tj. Gelumpang', 4),
	('1116122010', '111612', 'Pematang Durian', 4),
	('1116122011', '111612', 'Juar', 4),
	('1116122012', '111612', 'Sulum', 4),
	('1116122013', '111612', 'Suka Makmur', 4),
	('1116122014', '111612', 'Baling Karang', 4),
	('1117012001', '111701', 'Blang Rakal', 4),
	('1117012002', '111701', 'Neger Antara', 4),
	('1117012003', '111701', 'Alur Cincin', 4),
	('1117012004', '111701', 'Pantai Sinaku', 4),
	('1117012005', '111701', 'Bintang Beringin', 4),
	('1117012006', '111701', 'Taman Firdaus', 4),
	('1117012007', '111701', 'Uning Mas', 4),
	('1117012008', '111701', 'Perdamaian', 4),
	('1117012009', '111701', 'Ulu Naron', 4),
	('1117012010', '111701', 'Pantan Lah', 4),
	('1117012011', '111701', 'Pancar Jelobok', 4),
	('1117012012', '111701', 'Alur Gading', 4),
	('1117012013', '111701', 'Rimba Raya', 4),
	('1117012014', '111701', 'Singah Mulo', 4),
	('1117012015', '111701', 'Simpang Lancang', 4),
	('1117012016', '111701', 'Wih Porak', 4),
	('1117012017', '111701', 'Bener Meriah', 4),
	('1117012018', '111701', 'Musara-', 4),
	('1117012019', '111701', 'Musara Pakat', 4),
	('1117012020', '111701', 'Rata Ara', 4),
	('1117012021', '111701', 'Gemasih', 4),
	('1117012022', '111701', 'Pulo Intan', 4),
	('1117012023', '111701', 'Blang Ara', 4),
	('1117022001', '111702', 'Bener Pepanyi', 4),
	('1117022002', '111702', 'Bintang Bener', 4),
	('1117022003', '111702', 'Bintang Permata', 4),
	('1117022004', '111702', 'Buntul Peteri', 4),
	('1117022005', '111702', 'Darul Aman Ramung', 4),
	('1117022006', '111702', 'GLP Wih Tenag Uken', 4),
	('1117022007', '111702', 'Pantan Tengah Jaya', 4),
	('1117022008', '111702', 'Penosan Jaya', 4),
	('1117022009', '111702', 'Ramung Jaya', 4),
	('1117022010', '111702', 'Seni Antara', 4),
	('1117022011', '111702', 'Temas Mumanang', 4),
	('1117022012', '111702', 'Wih Tenang Toa', 4),
	('1117022013', '111702', 'Wih Tenang Uken', 4),
	('1117022014', '111702', 'Ayu Ara', 4),
	('1117022015', '111702', 'Ceding Ayu', 4),
	('1117022016', '111702', 'Uning Sejuk', 4),
	('1117022017', '111702', 'Suku Sara Tengke', 4),
	('1117022018', '111702', 'Rikit Musara', 4),
	('1117022019', '111702', 'Jungke', 4),
	('1117022020', '111702', 'Burni Pase', 4),
	('1117022021', '111702', 'Bale Musara', 4),
	('1117022022', '111702', 'Pemanggo', 4),
	('1117022023', '111702', 'Jelobok', 4),
	('1117022024', '111702', 'Kepies', 4),
	('1117022025', '111702', 'Timur Jaya', 4),
	('1117022026', '111702', 'Bale Purnama', 4),
	('1117022027', '111702', 'Tawar Bengi', 4),
	('1117032001', '111703', 'Belang Panu', 4),
	('1117032003', '111703', 'Gerpa', 4),
	('1117032004', '111703', 'Goneng', 4),
	('1117032007', '111703', 'Kerlang', 4),
	('1117032008', '111703', 'Kute Lah Lane', 4),
	('1117032009', '111703', 'Pasir Putih', 4),
	('1117032010', '111703', 'Payung', 4),
	('1117032012', '111703', 'Rusip', 4),
	('1117032014', '111703', 'Tembolon', 4),
	('1117032015', '111703', 'Uning', 4),
	('1117032016', '111703', 'Wihni Durin', 4),
	('1117032017', '111703', 'Rata Mulie', 4),
	('1117032018', '111703', 'Tempen Baru', 4),
	('1117032019', '111703', 'Geruti Jaya', 4),
	('1117042001', '111704', 'Bahgie Bertona', 4),
	('1117042003', '111704', 'Bathin Baru', 4),
	('1117042004', '111704', 'Blang Pulo', 4),
	('1117042009', '111704', 'Bukit Wih Ilang', 4),
	('1117042010', '111704', 'Hakim Wih Ilang', 4),
	('1117042011', '111704', 'Jana Rata', 4),
	('1117042012', '111704', 'Keramat Jaya', 4),
	('1117042013', '111704', 'Lewa Jadi', 4),
	('1117042014', '111704', 'Muyang Kute Mangku', 4),
	('1117042016', '111704', 'Pakat Jeroh', 4),
	('1117042017', '111704', 'Paya Baning', 4),
	('1117042018', '111704', 'Petukel Blang Jorong', 4),
	('1117042019', '111704', 'Pondok Baru', 4),
	('1117042020', '111704', 'Pondok Gajah', 4),
	('1117042021', '111704', 'Pondok Ulung', 4),
	('1117042022', '111704', 'Puja Mulia', 4),
	('1117042023', '111704', 'Purwosari', 4),
	('1117042024', '111704', 'Selamat Rejo', 4),
	('1117042025', '111704', 'Sidodadi', 4),
	('1117042026', '111704', 'Simpang Utama', 4),
	('1117042027', '111704', 'Suku Wih Ilang', 4),
	('1117042028', '111704', 'Tanjung Pura', 4),
	('1117042029', '111704', 'Wonosari', 4),
	('1117042030', '111704', 'Mutiara', 4),
	('1117042032', '111704', 'Tansaran Bidin', 4),
	('1117042033', '111704', 'Jadi Sepakat', 4),
	('1117042034', '111704', 'Selisih Mara', 4),
	('1117042035', '111704', 'Kala Nempan', 4),
	('1117042036', '111704', 'Gunung Antara', 4),
	('1117042037', '111704', 'Gele Semayang', 4),
	('1117042042', '111704', 'Tawar Sedenge', 4),
	('1117042043', '111704', 'Beranun Teleden', 4),
	('1117042044', '111704', 'Remang Ketike Jaya', 4),
	('1117042045', '111704', 'Makmur Sentosa', 4),
	('1117052001', '111705', 'Bale Atu', 4),
	('1117052002', '111705', 'Bale Redelong', 4),
	('1117052003', '111705', 'Batin Wih Pongas', 4),
	('1117052004', '111705', 'Blang Ara', 4),
	('1117052005', '111705', 'Blang Sentang', 4),
	('1117052006', '111705', 'Blang Tampu', 4),
	('1117052007', '111705', 'Bujang', 4),
	('1117052008', '111705', 'Burni Telong', 4),
	('1117052009', '111705', 'Delung Tue', 4),
	('1117052010', '111705', 'Hakim Tunggul Naru', 4),
	('1117052011', '111705', 'Isaq Busur', 4),
	('1117052012', '111705', 'Kenawat Redlong', 4),
	('1117052013', '111705', 'Kute Lintang', 4),
	('1117052014', '111705', 'Panji Mulia I', 4),
	('1117052015', '111705', 'Panji Mulia II', 4),
	('1117052016', '111705', 'Pasar Simpang Tiga', 4),
	('1117052017', '111705', 'Reje Guru', 4),
	('1117052018', '111705', 'Rembele', 4),
	('1117052019', '111705', 'Sidie Jadi', 4),
	('1117052020', '111705', 'Tingkem Asli', 4),
	('1117052021', '111705', 'Tingkem Benyer', 4),
	('1117052022', '111705', 'Tingkem Bersatu', 4),
	('1117052023', '111705', 'Ujung Gele', 4),
	('1117052024', '111705', 'Uning Bersah', 4),
	('1117052025', '111705', 'Uning Teritit', 4),
	('1117052026', '111705', 'Waq Pondok Sayur', 4),
	('1117052027', '111705', 'Babussalam', 4),
	('1117052028', '111705', 'Paya Gajah', 4),
	('1117052029', '111705', 'Kute Tanjung', 4),
	('1117052030', '111705', 'Meluem', 4),
	('1117052031', '111705', 'Delung Asli', 4),
	('1117052032', '111705', 'Pilar Jaya', 4),
	('1117052033', '111705', 'Serule Kayu', 4),
	('1117052034', '111705', 'Uring', 4),
	('1117052035', '111705', 'Mupakat Jadi', 4),
	('1117052036', '111705', 'Kute Kering', 4),
	('1117052037', '111705', 'Blang Panas', 4),
	('1117052038', '111705', 'Mutiara Baru', 4),
	('1117052039', '111705', 'Bukit Bersatu', 4),
	('1117052040', '111705', 'Godang', 4),
	('1117062001', '111706', 'Blang Paku', 4),
	('1117062002', '111706', 'Bandar Baru', 4),
	('1117062003', '111706', 'Karang Rejo', 4),
	('1117062004', '111706', 'Pante Raya', 4),
	('1117062005', '111706', 'Simpang Bolek', 4),
	('1117062006', '111706', 'Simpang Teririt', 4),
	('1117062007', '111706', 'Suka Jadi', 4),
	('1117062008', '111706', 'Suka Makmur', 4),
	('1117062009', '111706', 'Suka Rami Atas', 4),
	('1117062010', '111706', 'Suka Rami Bawah', 4),
	('1117062011', '111706', 'Syura Jadi', 4),
	('1117062012', '111706', 'Jamur Uluh', 4),
	('1117062013', '111706', 'Gegerung', 4),
	('1117062014', '111706', 'Merie Satu', 4),
	('1117062015', '111706', 'Blang Menara', 4),
	('1117062016', '111706', 'Bukit Pepanyi', 4),
	('1117062017', '111706', 'Wih Pesam', 4),
	('1117062018', '111706', 'Cinta Damai', 4),
	('1117062019', '111706', 'Mekar Jadi Ayu', 4),
	('1117062020', '111706', 'Bener Mulie', 4),
	('1117062021', '111706', 'Blang Kucak', 4),
	('1117062022', '111706', 'Wonosobo', 4),
	('1117062023', '111706', 'Lut Kucak', 4),
	('1117062024', '111706', 'Kebun Baru', 4),
	('1117062025', '111706', 'Simpang Antara', 4),
	('1117062026', '111706', 'Jamur Ujung', 4),
	('1117062027', '111706', 'Suka Makmur Timur', 4),
	('1117072001', '111707', 'Bandar Lampahan', 4),
	('1117072002', '111707', 'Blang Rongka', 4),
	('1117072003', '111707', 'Cekal Baru', 4),
	('1117072004', '111707', 'Gegur Sepakat', 4),
	('1117072005', '111707', 'Karang Jadi', 4),
	('1117072006', '111707', 'Lampahan', 4),
	('1117072010', '111707', 'Setie', 4),
	('1117072011', '111707', 'Simpang Layang', 4),
	('1117072012', '111707', 'Suka Damai', 4),
	('1117072014', '111707', 'Tunyang', 4),
	('1117072016', '111707', 'Datu Beru Tunyang', 4),
	('1117072017', '111707', 'Kenine', 4),
	('1117072018', '111707', 'Rembune', 4),
	('1117072019', '111707', 'Damaran Baru', 4),
	('1117072020', '111707', 'Fajar Harapan', 4),
	('1117072021', '111707', 'Mude Benara', 4),
	('1117072022', '111707', 'Kampung Baru', 4),
	('1117072023', '111707', 'Pantai Pediangin', 4),
	('1117072024', '111707', 'Bumi Ayu', 4),
	('1117072025', '111707', 'Kulem Para Kanis', 4),
	('1117072026', '111707', 'Mekar Ayu', 4),
	('1117072027', '111707', 'Lampahan Barat', 4),
	('1117072028', '111707', 'Lampahan Timur', 4),
	('1117072029', '111707', 'Timang Rasa', 4),
	('1117072030', '111707', 'Gunung Tunyang', 4),
	('1117072031', '111707', 'Bukit Tunyang', 4),
	('1117072032', '111707', 'Linung Bale', 4),
	('1117072033', '111707', 'Pantan Kemuning', 4),
	('1117072034', '111707', 'Sumber Jaya', 4),
	('1117072035', '111707', 'Bukit Mulie', 4),
	('1117082001', '111708', 'Batin Bandar Jaya', 4),
	('1117082002', '111708', 'Jongok Meluem', 4),
	('1117082003', '111708', 'Suku Bener', 4),
	('1117082004', '111708', 'Bener Lukup II', 4),
	('1117082005', '111708', 'Gunung Musara', 4),
	('1117082006', '111708', 'Bener Kelipah Selatan', 4),
	('1117082007', '111708', 'Bintang Musara', 4),
	('1117082008', '111708', 'Kala Tenang', 4),
	('1117082009', '111708', 'Bener Kelipah Utara', 4),
	('1117082010', '111708', 'Lot Bener Kelipah', 4),
	('1117082011', '111708', 'Nosar Tawar Jaya', 4),
	('1117082012', '111708', 'Nosar Baru', 4),
	('1117092001', '111709', 'Cemparan Lama', 4),
	('1117092002', '111709', 'Cemparam Pakat Jeroh', 4),
	('1117092003', '111709', 'Cemparam Jaya', 4),
	('1117092004', '111709', 'Pantan Kuli', 4),
	('1117092005', '111709', 'Simpang Renggali', 4),
	('1117092006', '111709', 'Jamur Atu', 4),
	('1117092007', '111709', 'Sosial', 4),
	('1117092008', '111709', 'Gunung Sayang', 4),
	('1117092009', '111709', 'Amor', 4),
	('1117092010', '111709', 'Buntul Gayo', 4),
	('1117092011', '111709', 'Wih Resap', 4),
	('1117092012', '111709', 'Wer Tingkem', 4),
	('1117092013', '111709', 'Perumpaken Benjadi', 4),
	('1117092014', '111709', 'Hakim Peteri Pintu', 4),
	('1117092015', '111709', 'Simpur', 4),
	('1117102001', '111710', 'Simpang Rahmat', 4),
	('1117102002', '111710', 'Gajah Putih', 4),
	('1117102003', '111710', 'Gayo Setie', 4),
	('1117102004', '111710', 'Umah Besi', 4),
	('1117102005', '111710', 'Pante Karya', 4),
	('1117102006', '111710', 'Meriah Jaya', 4),
	('1117102007', '111710', 'Timang Gajah', 4),
	('1117102008', '111710', 'Pantan Lues', 4),
	('1117102009', '111710', 'Alam Jaya', 4),
	('1117102010', '111710', 'Reronga', 4),
	('1118012001', '111801', 'Meunasah Balek', 4),
	('1118012002', '111801', 'Kota Meurendu', 4),
	('1118012003', '111801', 'Mesjid Tuha', 4),
	('1118012004', '111801', 'Rungkom', 4),
	('1118012005', '111801', 'Blang Awe', 4),
	('1118012006', '111801', 'Mayang Lancot', 4),
	('1118012007', '111801', 'Manyang Cut', 4),
	('1118012008', '111801', 'Beurawang', 4),
	('1118012009', '111801', 'Rhing Blang', 4),
	('1118012010', '111801', 'Ring Krueng', 4),
	('1118012011', '111801', 'Rhing Tunong', 4),
	('1118012012', '111801', 'Meunasah Lhok', 4),
	('1118012013', '111801', 'Meuraksa', 4),
	('1118012014', '111801', 'Pulo U', 4),
	('1118012015', '111801', 'Geuleudah', 4),
	('1118012016', '111801', 'Dayah Timur', 4),
	('1118012017', '111801', 'Bunot', 4),
	('1118012018', '111801', 'Glimpang Tutong', 4),
	('1118012019', '111801', 'Meunasah Hagu', 4),
	('1118012020', '111801', 'Pohroh', 4),
	('1118012021', '111801', 'Kudrang', 4),
	('1118012022', '111801', 'Lampoh Lada', 4),
	('1118012023', '111801', 'Mulieng', 4),
	('1118012024', '111801', 'Dayah Tuha', 4),
	('1118012025', '111801', 'Rumpuen', 4),
	('1118012026', '111801', 'Rambong', 4),
	('1118012027', '111801', 'Meunasah Kulam', 4),
	('1118012028', '111801', 'Grong-Grong', 4),
	('1118012029', '111801', 'Kuta Trieng', 4),
	('1118012030', '111801', 'Teupin Peuraho', 4),
	('1118022001', '111802', 'Dayah Boroh', 4),
	('1118022002', '111802', 'Reuleut', 4),
	('1118022003', '111802', 'Sambungan Baro', 4),
	('1118022004', '111802', 'Tijiem Husen', 4),
	('1118022005', '111802', 'Meunasah Krueng', 4),
	('1118022006', '111802', 'Geulanggang', 4),
	('1118022007', '111802', 'Mesjid Ulim Baroh', 4),
	('1118022008', '111802', 'Pulo Lhok', 4),
	('1118022009', '111802', 'Dayah Leubue', 4),
	('1118022010', '111802', 'Tijiem Daboh', 4),
	('1118022011', '111802', 'Keude Ulim', 4),
	('1118022012', '111802', 'Meunasah Bueng', 4),
	('1118022013', '111802', 'Balee Ulim', 4),
	('1118022014', '111802', 'Grong Grong Capa', 4),
	('1118022015', '111802', 'Meunasah Kumbang', 4),
	('1118022016', '111802', 'Tanjong Ulim', 4),
	('1118022017', '111802', 'Mesjid Ulom Tunong', 4),
	('1118022018', '111802', 'Pulo Ulim', 4),
	('1118022019', '111802', 'Siblah Coh', 4),
	('1118022020', '111802', 'Bidok', 4),
	('1118022021', '111802', 'Pante Cot Baloi', 4),
	('1118022022', '111802', 'Meunesah Pupu', 4),
	('1118022023', '111802', 'Nanggroe Barat', 4),
	('1118022024', '111802', 'Nanggroe Timur', 4),
	('1118022025', '111802', 'Meunasah Mesjid', 4),
	('1118022026', '111802', 'Blang Rheue', 4),
	('1118022027', '111802', 'Cot Seutui', 4),
	('1118022028', '111802', 'Lhok Gajah', 4),
	('1118022029', '111802', 'Alue Kemiki', 4),
	('1118022030', '111802', 'Blang Cari', 4),
	('1118032001', '111803', 'Muko Jurong', 4),
	('1118032002', '111803', 'Kuta Baroh', 4),
	('1118032003', '111803', 'Muko Meugit', 4),
	('1118032004', '111803', 'Kiran Dayah', 4),
	('1118032005', '111803', 'Kiran Baroh', 4),
	('1118032006', '111803', 'Kiran Meunasah Raya', 4),
	('1118032007', '111803', 'Kiran Meunasah Lueng', 4),
	('1118032008', '111803', 'K. Mns. Beureumbang', 4),
	('1118032009', '111803', 'Meunasah Mee', 4),
	('1118032010', '111803', 'Meunasah Kumbang', 4),
	('1118032011', '111803', 'Meunasah Krueng', 4),
	('1118032012', '111803', 'Buket Teungoh', 4),
	('1118032013', '111803', 'Reuleu Mangat', 4),
	('1118032014', '111803', 'Gampong Cot', 4),
	('1118032015', '111803', 'Jurong Binje', 4),
	('1118032016', '111803', 'Jurong Teungoh', 4),
	('1118032017', '111803', 'Jurong Ara', 4),
	('1118032018', '111803', 'Keude Jangka Buya', 4),
	('1118042001', '111804', 'Keude Ulee Gle', 4),
	('1118042002', '111804', 'gampong Ule Gle', 4),
	('1118042003', '111804', 'Blang Dalam', 4),
	('1118042004', '111804', 'Pulo', 4),
	('1118042005', '111804', 'Gampong Baro', 4),
	('1118042006', '111804', 'Muko Kuthang', 4),
	('1118042007', '111804', 'Uteun Bayu', 4),
	('1118042008', '111804', 'Alue Ketapang', 4),
	('1118042009', '111804', 'Jaulanga Barat', 4),
	('1118042010', '111804', 'Kumba', 4),
	('1118042011', '111804', 'Babah Kreung', 4),
	('1118042012', '111804', 'Pohroh', 4),
	('1118042013', '111804', 'Seunong', 4),
	('1118042014', '111804', 'Alue Mee', 4),
	('1118042015', '111804', 'Blang Kuta', 4),
	('1118042016', '111804', 'Drien Tujoh', 4),
	('1118042017', '111804', 'Alue Sane', 4),
	('1118042018', '111804', 'Gaharu', 4),
	('1118042019', '111804', 'Lhok Pusong', 4),
	('1118042020', '111804', 'Paya Pisang Klat', 4),
	('1118042021', '111804', 'Cot Geureufai', 4),
	('1118042022', '111804', 'Muko Dayah', 4),
	('1118042023', '111804', 'Muko Buloh', 4),
	('1118042024', '111804', 'Peulakan Tunong', 4),
	('1118042025', '111804', 'Adan', 4),
	('1118042026', '111804', 'Meugit K. Panyang', 4),
	('1118042027', '111804', 'Meugit Sagoe', 4),
	('1118042028', '111804', 'Meurandeh Alue', 4),
	('1118042029', '111804', 'Reudeup Melayu', 4),
	('1118042030', '111804', 'Meunasah Paku', 4),
	('1118042031', '111804', 'Jeulanga Mata Ie', 4),
	('1118042032', '111804', 'Jeulanga Mesjid', 4),
	('1118042033', '111804', 'Pulo Gapu', 4),
	('1118042034', '111804', 'Blang Miroe', 4),
	('1118042035', '111804', 'Beurasan', 4),
	('1118042036', '111804', 'Cot Keng', 4),
	('1118042037', '111804', 'Krueng Kiran', 4),
	('1118042038', '111804', 'Asan Kumbang', 4),
	('1118042039', '111804', 'Drien Bungong', 4),
	('1118042040', '111804', 'Peulakan Cebrek', 4),
	('1118042041', '111804', 'Paya Tunong', 4),
	('1118042042', '111804', 'Peulakan Tambo', 4),
	('1118042043', '111804', 'Paya Baroh', 4),
	('1118042044', '111804', 'Muko Baroh', 4),
	('1118042045', '111804', 'Kuto Krueng', 4),
	('1118052001', '111805', 'Lhok Sandeng', 4),
	('1118052002', '111805', 'Sara Mane', 4),
	('1118052003', '111805', 'Seunong', 4),
	('1118052004', '111805', 'Lamcok', 4),
	('1118052005', '111805', 'Meunasah Kulam', 4),
	('1118052006', '111805', 'Meunasah Teungoh', 4),
	('1118052007', '111805', 'Meunasah Bie', 4),
	('1118052008', '111805', 'Meunasah Raya', 4),
	('1118052009', '111805', 'Geunteng', 4),
	('1118052010', '111805', 'Kampong Blang', 4),
	('1118052011', '111805', 'Meunasah Blang Cut', 4),
	('1118052012', '111805', 'Dayah Kruet', 4),
	('1118052013', '111805', 'Meunasah Mancang', 4),
	('1118052014', '111805', 'Mensh. Dayah Usen', 4),
	('1118052015', '111805', 'Lueng Bimba', 4),
	('1118052016', '111805', 'Beuringen', 4),
	('1118052017', '111805', 'Buanga', 4),
	('1118052018', '111805', 'Jurong', 4),
	('1118052019', '111805', 'Pante Beureunee', 4),
	('1118062001', '111806', 'Mns. Cut Nyong', 4),
	('1118062002', '111806', 'Mns. Gampong', 4),
	('1118062003', '111806', 'Mns. Baro', 4),
	('1118062004', '111806', 'Mns.Pulo Rheng', 4),
	('1118062005', '111806', 'Mns Dayang Nyong', 4),
	('1118062006', '111806', 'Mns Daboih', 4),
	('1118062007', '111806', 'Mns. Beurandeh', 4),
	('1118062008', '111806', 'Mns. Kaye Raya', 4),
	('1118062009', '111806', 'Mns. Blang Glong', 4),
	('1118062010', '111806', 'Meunasah Tutong', 4),
	('1118062011', '111806', 'Meunasah Siren', 4),
	('1118062012', '111806', 'Meunasah Keude', 4),
	('1118062013', '111806', 'Mns Pup/Lueng Nibong', 4),
	('1118062014', '111806', 'Mns. Baroh Musa', 4),
	('1118062015', '111806', 'Mns Teungoh', 4),
	('1118062016', '111806', 'Mns Balee', 4),
	('1118062017', '111806', 'Mns Udeung', 4),
	('1118062018', '111806', 'Meunasah Ara', 4),
	('1118062019', '111806', 'Mns Baroh Lancok', 4),
	('1118062020', '111806', 'Mns Manyang', 4),
	('1118062021', '111806', 'Mns Mesjid', 4),
	('1118062022', '111806', 'Mns Pulo Pueb', 4),
	('1118062023', '111806', 'Mns Sawang', 4),
	('1118062024', '111806', 'Mns Tuha Lada', 4),
	('1118062025', '111806', 'Mns Cut Langgieng', 4),
	('1118062026', '111806', 'Mns Sagou', 4),
	('1118062027', '111806', 'Mns Dayah Langgieng', 4),
	('1118062028', '111806', 'Mns Baroh Cot', 4),
	('1118062029', '111806', 'Mns Blang Iboh', 4),
	('1118062030', '111806', 'Mns Blang Sukon', 4),
	('1118062031', '111806', 'Mns Kayee Jatou', 4),
	('1118062032', '111806', 'Mns Blang Baro', 4),
	('1118062033', '111806', 'Mns Lancang', 4),
	('1118062034', '111806', 'Mns Paru Keude', 4),
	('1118062035', '111806', 'Mns Blang Krueng', 4),
	('1118062036', '111806', 'Mns Jijieum', 4),
	('1118062037', '111806', 'Mns Sarah Panyang', 4),
	('1118062038', '111806', 'Mns Abah Lueng', 4),
	('1118062039', '111806', 'Mns Aki Neungoh', 4),
	('1118062040', '111806', 'Mns Ujong Lebat', 4),
	('1118062041', '111806', 'Meunasah Alue', 4),
	('1118062042', '111806', 'Mns Tanoh Mirah', 4),
	('1118062043', '111806', 'Paru Cot', 4),
	('1118072001', '111807', 'Keude', 4),
	('1118072002', '111807', 'Tu Pante Raja', 4),
	('1118072003', '111807', 'Hagu', 4),
	('1118072004', '111807', 'Muka Blang', 4),
	('1118072005', '111807', 'Lhok Puuk', 4),
	('1118072006', '111807', 'Mesj. P. Raja Timur', 4),
	('1118072007', '111807', 'Teungoh', 4),
	('1118072008', '111807', 'Tunong', 4),
	('1118072009', '111807', 'Peurade', 4),
	('1118072010', '111807', 'Reudep/Peud.Baroh', 4),
	('1118082001', '111808', 'Sagoe', 4),
	('1118082002', '111808', 'Meunasah Mee', 4),
	('1118082003', '111808', 'Mesjid Peuduk Baroh', 4),
	('1118082004', '111808', 'Tuha', 4),
	('1118082005', '111808', 'Reusep', 4),
	('1118082006', '111808', 'Deepeuduk Tunong', 4),
	('1118082007', '111808', 'Panton Raya', 4),
	('1118082008', '111808', 'Dayah Teumamah', 4),
	('1118082009', '111808', 'Tampui', 4),
	('1118082010', '111808', 'K. Krieng Gadeng', 4),
	('1118082011', '111808', 'Raya Trieng Gd.', 4),
	('1118082012', '111808', 'Paya Trieng Gd.', 4),
	('1118082013', '111808', 'Meue', 4),
	('1118082014', '111808', 'Mjd. Trieng Gadeng', 4),
	('1118082015', '111808', 'Teungklut Raya Sari Matang', 4),
	('1118082016', '111808', 'Matang', 4),
	('1118082017', '111808', 'Dayah Ujong Baroh', 4),
	('1118082018', '111808', 'Peulandok Teungoh', 4),
	('1118082019', '111808', 'Peulandok Tunong', 4),
	('1118082020', '111808', 'Dayah', 4),
	('1118082021', '111808', 'Meucat', 4),
	('1118082022', '111808', 'Cot Makaso', 4),
	('1118082023', '111808', 'Buloh', 4),
	('1118082024', '111808', 'Mee Pungwa', 4),
	('1118082025', '111808', 'Kuta', 4),
	('1118082026', '111808', 'Cot Lheu rheng', 4),
	('1118082027', '111808', 'Rawa Sari', 4),
	('1171012001', '117101', 'Kampung Baru', 4),
	('1171012002', '117101', 'Neusu Jaya', 4),
	('1171012003', '117101', 'Suka Ramai', 4),
	('1171012004', '117101', 'Setui', 4),
	('1171012005', '117101', 'Peuniti', 4),
	('1171012006', '117101', 'Neusu Aceh', 4),
	('1171012007', '117101', 'Ateuk Pahlawan', 4),
	('1171012008', '117101', 'Ateuk Jawo', 4),
	('1171012009', '117101', 'Ateuk Dayah Tanoh', 4),
	('1171012010', '117101', 'Ateuk Munjeng', 4),
	('1171022001', '117102', 'Mulia', 4),
	('1171022002', '117102', 'Peunayong', 4),
	('1171022003', '117102', 'KP. Laksana', 4),
	('1171022004', '117102', 'Keuramat', 4),
	('1171022005', '117102', 'Kota Baru', 4),
	('1171022006', '117102', 'Beurawe', 4),
	('1171022007', '117102', 'Kuta Alam', 4),
	('1171022008', '117102', 'Bandar Baru', 4),
	('1171022009', '117102', 'Lamdingin', 4),
	('1171022010', '117102', 'Lampula', 4),
	('1171022011', '117102', 'Lambaro Skep', 4),
	('1171032001', '117103', 'Punge Jurong', 4),
	('1171032002', '117103', 'Ulee Lheue', 4),
	('1171032003', '117103', 'Lambung', 4),
	('1171032004', '117103', 'Deyah Gelumpang', 4),
	('1171032005', '117103', 'Deyah Baro', 4),
	('1171032006', '117103', 'Alue Deyah Tengoh', 4),
	('1171032007', '117103', 'Lampaseh Aceh', 4),
	('1171032008', '117103', 'Blang Oi', 4),
	('1171032009', '117103', 'Asoi Nanggroi', 4),
	('1171032010', '117103', 'Gampong Blang', 4),
	('1171032011', '117103', 'Gampong Pie', 4),
	('1171032012', '117103', 'Lamjabat', 4),
	('1171032013', '117103', 'Cot Lamkuweuh', 4),
	('1171032014', '117103', 'Surien', 4),
	('1171032015', '117103', 'Gampong Baro', 4),
	('1171032016', '117103', 'Punge Ujong', 4),
	('1171042001', '117104', 'Jeulingke', 4),
	('1171042002', '117104', 'Tibang', 4),
	('1171042003', '117104', 'Deyah Raya', 4),
	('1171042004', '117104', 'Alue Naga', 4),
	('1171042005', '117104', 'Ie Masen K Adang', 4),
	('1171042006', '117104', 'Pineung', 4),
	('1171042007', '117104', 'Lamgugop', 4),
	('1171042008', '117104', 'Kopelma Darussalam', 4),
	('1171042009', '117104', 'Rukoh', 4),
	('1171042010', '117104', 'Gampong Peurada', 4),
	('1171052001', '117105', 'Leung Bata', 4),
	('1171052002', '117105', 'Cot Mesjid', 4),
	('1171052003', '117105', 'Panteriek', 4),
	('1171052004', '117105', 'Blang Cut', 4),
	('1171052005', '117105', 'Lamseupeung', 4),
	('1171052006', '117105', 'Batoh', 4),
	('1171052007', '117105', 'Sukadamai', 4),
	('1171052008', '117105', 'Lamdom', 4),
	('1171052009', '117105', 'Lampaloh', 4),
	('1171062001', '117106', 'Keudah', 4),
	('1171062002', '117106', 'Peulanggahan', 4),
	('1171062003', '117106', 'Merduati', 4),
	('1171062004', '117106', 'Lampaseh Kota', 4),
	('1171062005', '117106', 'Gampong Pandee', 4),
	('1171062006', '117106', 'Gampong Jawo', 4),
	('1171072001', '117107', 'Geuceu Komplek', 4),
	('1171072002', '117107', 'Lamlagang', 4),
	('1171072003', '117107', 'Geuceu Iniem', 4),
	('1171072004', '117107', 'Geuceu Kayee Jato', 4),
	('1171072005', '117107', 'Lam Ara', 4),
	('1171072006', '117107', 'Lhong Raya', 4),
	('1171072007', '117107', 'Mibo', 4),
	('1171072008', '117107', 'Peunyeret', 4),
	('1171072009', '117107', 'Lhong Cut', 4),
	('1171072010', '117107', 'Lampeu Ot', 4),
	('1171082001', '117108', 'Punge Blang Cut', 4),
	('1171082002', '117108', 'Bitai', 4),
	('1171082003', '117108', 'Lam Jamee', 4),
	('1171082004', '117108', 'Ulee Pata', 4),
	('1171082005', '117108', 'Lampoh Daya', 4),
	('1171082006', '117108', 'Empeerom', 4),
	('1171082007', '117108', 'Geuceun Meunara', 4),
	('1171082008', '117108', 'Lamteumen Timur', 4),
	('1171082009', '117108', 'Lamteumen Barat', 4),
	('1171092001', '117109', 'Lambhuk', 4),
	('1171092002', '117109', 'Lamteh', 4),
	('1171092003', '117109', 'Ilie', 4),
	('1171092004', '117109', 'Pango Raya', 4),
	('1171092005', '117109', 'Pango Deyah', 4),
	('1171092006', '117109', 'Ceurih', 4),
	('1171092007', '117109', 'Doi', 4),
	('1171092008', '117109', 'Lamglumpang', 4),
	('1171092009', '117109', 'Ie MU Kareng', 4),
	('1172012001', '117201', 'Iboih', 4),
	('1172012002', '117201', 'Batee Shok', 4),
	('1172012003', '117201', 'Paya Seunara', 4),
	('1172012004', '117201', 'Krueng Raya', 4),
	('1172012005', '117201', 'Aneuk Laot', 4),
	('1172012006', '117201', 'Kota Bawah Timur', 4),
	('1172012007', '117201', 'Kota Bawah Barat', 4),
	('1172012008', '117201', 'Kota Atas', 4),
	('1172022001', '117202', 'Paya', 4),
	('1172022002', '117202', 'Keuneukai', 4),
	('1172022003', '117202', 'Beurawang', 4),
	('1172022004', '117202', 'Jaboi', 4),
	('1172022005', '117202', 'Balohan', 4),
	('1172022006', '117202', 'Cot Abeuek', 4),
	('1172022007', '117202', 'Cot Ba U', 4),
	('1172022008', '117202', 'Ie Meulee', 4),
	('1172022009', '117202', 'Ujong Kareueng', 4),
	('1172022010', '117202', 'Anoi Itam', 4),
	('1173012002', '117301', 'Alue Awe', 4),
	('1173012003', '117301', 'Blang Crum', 4),
	('1173012004', '117301', 'Cot Mamplam', 4),
	('1173012005', '117301', 'Meunasah Mee', 4),
	('1173012006', '117301', 'Cot Girek Kandang', 4),
	('1173012007', '117301', 'Keude Cunda', 4),
	('1173012008', '117301', 'Mns Uteunko Cunda', 4),
	('1173012009', '117301', 'Lhok Mon Puteh', 4),
	('1173012010', '117301', 'Meunasah Mesjid', 4),
	('1173012011', '117301', 'Meunasah Panggoi', 4),
	('1173012013', '117301', 'Mnsh Paya Bili', 4),
	('1173012014', '117301', 'Meunasah Alue', 4),
	('1173012015', '117301', 'Paya Punteet', 4),
	('1173012016', '117301', 'Blang Poroh', 4),
	('1173012024', '117301', 'Meunasah Manyang', 4),
	('1173012025', '117301', 'Meunasah Blang', 4),
	('1173012026', '117301', 'Paloh Bate', 4),
	('1173022001', '117302', 'Kuta Blang', 4),
	('1173022002', '117302', 'Tumpok Teungoh', 4),
	('1173022003', '117302', 'Simpang Empat', 4),
	('1173022004', '117302', 'Kampong Jawa', 4),
	('1173022005', '117302', 'Kota Lhokseumawe', 4),
	('1173022006', '117302', 'Mon Geudong', 4),
	('1173022007', '117302', 'Keude Aceh', 4),
	('1173022008', '117302', 'Pusong Lhokseumawe', 4),
	('1173022009', '117302', 'Hagu Teungoh', 4),
	('1173022010', '117302', 'Uteun Bayi', 4),
	('1173022011', '117302', 'Ujong Blang', 4),
	('1173022012', '117302', 'Hagu Selatan', 4),
	('1173022013', '117302', 'Pusong Baru', 4),
	('1173022014', '117302', 'Ulee Jalan', 4),
	('1173022015', '117302', 'Banda Masen', 4),
	('1173022016', '117302', 'Lancang Garam', 4),
	('1173022017', '117302', 'KP. Jawa Baroe', 4),
	('1173022018', '117302', 'Hagu Barat Laut', 4),
	('1173032001', '117303', 'Kuala', 4),
	('1173032002', '117303', 'Blang Cut', 4),
	('1173032003', '117303', 'Mesjid Meuraya', 4),
	('1173032004', '117303', 'Jambo Timu', 4),
	('1173032005', '117303', 'Tunong', 4),
	('1173032006', '117303', 'Blang Teue', 4),
	('1173032007', '117303', 'Teungoh', 4),
	('1173032008', '117303', 'Baloy', 4),
	('1173032009', '117303', 'Mane Kareung', 4),
	('1173032010', '117303', 'Asan Kareung', 4),
	('1173032011', '117303', 'Rayeuk Kareung', 4),
	('1173032012', '117303', 'Blang Punteuet', 4),
	('1173032013', '117303', 'Kumbang Punteuet', 4),
	('1173032014', '117303', 'Mesjid Punteuet', 4),
	('1173032015', '117303', 'Ulee Blang Mane', 4),
	('1173032016', '117303', 'Keude Panteuet', 4),
	('1173032017', '117303', 'Alue Lim', 4),
	('1173032018', '117303', 'Blang Buloh', 4),
	('1173032019', '117303', 'Blang Weu Panjou', 4),
	('1173032020', '117303', 'Jeulikat', 4),
	('1173032021', '117303', 'Blang Weu Baroh', 4),
	('1173032022', '117303', 'Seuneubok', 4),
	('1173042001', '117304', 'Batuphat Barat', 4),
	('1173042002', '117304', 'Blang Panyang', 4),
	('1173042003', '117304', 'Meunasah Dayah', 4),
	('1173042004', '117304', 'Paloh Panti', 4),
	('1173042005', '117304', 'Blang Pulo', 4),
	('1173042006', '117304', 'Batuphat Timur', 4),
	('1173042007', '117304', 'Blang N. Mameh', 4),
	('1173042008', '117304', 'Cot Trieng', 4),
	('1173042009', '117304', 'Padang Sakti', 4),
	('1173042010', '117304', 'Meuria Paloh', 4),
	('1173042011', '117304', 'Ujong Pancu', 4),
	('1174012007', '117401', 'Buket Medang Ara', 4),
	('1174012009', '117401', 'Matang Seutui', 4),
	('1174012010', '117401', 'Buket Pulo', 4),
	('1174012011', '117401', 'Matang Panyang', 4),
	('1174012012', '117401', 'Simpang Wie', 4),
	('1174012013', '117401', 'Buket Rata', 4),
	('1174012014', '117401', 'Buket Meutuah', 4),
	('1174012015', '117401', 'Alue Merbau', 4),
	('1174012016', '117401', 'Matang Cengai', 4),
	('1174012017', '117401', 'Seunebok Antara', 4),
	('1174012018', '117401', 'Alue Pineung', 4),
	('1174012019', '117401', 'Sukarejo', 4),
	('1174012020', '117401', 'Cinta Raja', 4),
	('1174012021', '117401', 'Sungai Lueng', 4),
	('1174012025', '117401', 'Alue Pineung Timue', 4),
	('1174012026', '117401', 'Kapa', 4),
	('1174022005', '117402', 'Lhok Banie', 4),
	('1174022006', '117402', 'Paya BujokTeungoh', 4),
	('1174022007', '117402', 'Paya Bujok Beuramo', 4),
	('1174022008', '117402', 'Simpang Lhee', 4),
	('1174022009', '117402', 'Seuriget', 4),
	('1174022015', '117402', 'Matang Seulimeng', 4),
	('1174022016', '117402', 'Sungai Pauh', 4),
	('1174022017', '117402', 'Kuala Langsa', 4),
	('1174022018', '117402', 'Telaga Tujuh', 4),
	('1174022019', '117402', 'Serambi Indah', 4),
	('1174022020', '117402', 'Sungai Paus Pusaka', 4),
	('1174022021', '117402', 'Sungai Paus Tanjong', 4),
	('1174022022', '117402', 'Sungai Paus Firdaus', 4),
	('1174032001', '117403', 'Gampong Teungoh', 4),
	('1174032002', '117403', 'Peukan Langsa', 4),
	('1174032004', '117403', 'Gampong Jawa', 4),
	('1174032005', '117403', 'PB. Blang Pase', 4),
	('1174032006', '117403', 'Blang', 4),
	('1174032007', '117403', 'Alue Beurawe', 4),
	('1174032009', '117403', 'Daulat', 4),
	('1174032010', '117403', 'Meutia', 4),
	('1174032011', '117403', 'Blang Seunibong', 4),
	('1174032013', '117403', 'Tualang Teungoh', 4),
	('1174042001', '117404', 'Pondok Kemuning', 4),
	('1174042002', '117404', 'Seulalah', 4),
	('1174042003', '117404', 'Pondok Pabrik', 4),
	('1174042004', '117404', 'Sidodadi', 4),
	('1174042005', '117404', 'Sidorejo', 4),
	('1174042006', '117404', 'Baro', 4),
	('1174042007', '117404', 'Meurandeh', 4),
	('1174042008', '117404', 'Asam Peutik', 4),
	('1174042009', '117404', 'Baroh Langsa Lama', 4),
	('1174042010', '117404', 'Seulalah Baru', 4),
	('1174042011', '117404', 'Suka JD KBN Ireng', 4),
	('1174042012', '117404', 'Meurandeh Teungoh', 4),
	('1174042013', '117404', 'Meurandeh Dayah', 4),
	('1174042014', '117404', 'Meurandeh Aceh', 4),
	('1174042015', '117404', 'Bate Puteh', 4),
	('1174052001', '117405', 'Timbang Langsa', 4),
	('1174052002', '117405', 'Alue Dua', 4),
	('1174052003', '117405', 'Birem Puntong', 4),
	('1174052004', '117405', 'Paya Bujok Seuleumak', 4),
	('1174052005', '117405', 'Pondok Kelapa', 4),
	('1174052006', '117405', 'Karang Anyar', 4),
	('1174052007', '117405', 'Paya Bujok Tunong', 4),
	('1174052008', '117405', 'Geudubang Jawa', 4),
	('1174052009', '117405', 'Geudubang Aceh', 4),
	('1174052010', '117405', 'Alue Dua Bakaran Bate', 4),
	('1174052011', '117405', 'Lengkong', 4),
	('1174052012', '117405', 'Suka Jadi Makmur', 4),
	('1175012001', '117501', 'Subulussalam', 4),
	('1175012002', '117501', 'Pegayo', 4),
	('1175012003', '117501', 'Sikelondang', 4),
	('1175012004', '117501', 'Buluh Dori', 4),
	('1175012005', '117501', 'Subulussalam Utara', 4),
	('1175012006', '117501', 'Subulussalam Selatan', 4),
	('1175012007', '117501', 'Subulussalam Barat', 4),
	('1175012008', '117501', 'Suka Makmur', 4),
	('1175012009', '117501', 'Tangga Besi', 4),
	('1175012010', '117501', 'Kuta Cepu', 4),
	('1175012011', '117501', 'Pasir Panjang', 4),
	('1175012012', '117501', 'Mukti Makmur', 4),
	('1175012013', '117501', 'Lae Oram', 4),
	('1175012014', '117501', 'Makmur Jaya', 4),
	('1175012015', '117501', 'Belegen Mulia', 4),
	('1175012016', '117501', 'Danau Tras', 4),
	('1175012017', '117501', 'Subulussalam Timur', 4),
	('1175022001', '117502', 'Penanggalan', 4),
	('1175022002', '117502', 'Cepu', 4),
	('1175022003', '117502', 'Kuta Tengah', 4),
	('1175022004', '117502', 'Kampung Baru', 4),
	('1175022005', '117502', 'Sikelang', 4),
	('1175022006', '117502', 'Penuntungan', 4),
	('1175022007', '117502', 'Jontor', 4),
	('1175022008', '117502', 'Lae Motong', 4),
	('1175022009', '117502', 'Lae Ikan', 4),
	('1175022010', '117502', 'Lae Bersih', 4),
	('1175022011', '117502', 'Dasan Raja', 4),
	('1175022012', '117502', 'Penanggalan Timur', 4),
	('1175022013', '117502', 'Penanggalan Barat', 4),
	('1175032001', '117503', 'Pasar Rundeng', 4),
	('1175032002', '117503', 'Dah', 4),
	('1175032003', '117503', 'Oboh', 4),
	('1175032004', '117503', 'Sepadan', 4),
	('1175032005', '117503', 'Sibuasan', 4),
	('1175032006', '117503', 'Binanga', 4),
	('1175032007', '117503', 'Kuta Beringin', 4),
	('1175032008', '117503', 'Muara Batu-batu', 4),
	('1175032009', '117503', 'Siperkas', 4),
	('1175032010', '117503', 'Lae Mate', 4),
	('1175032011', '117503', 'Sibungke', 4),
	('1175032012', '117503', 'Harapan Baru', 4),
	('1175032013', '117503', 'Teladan Baru', 4),
	('1175032014', '117503', 'Bulukur Makmur', 4),
	('1175032015', '117503', 'Kampong Badar', 4),
	('1175032016', '117503', 'Lae Pemualan', 4),
	('1175032017', '117503', 'Panglima Sahman', 4),
	('1175032018', '117503', 'Suak Jampak', 4),
	('1175032019', '117503', 'Geruguh', 4),
	('1175032020', '117503', 'Mandilam', 4),
	('1175032021', '117503', 'Tualang', 4),
	('1175032022', '117503', 'Kuala Kepeng', 4),
	('1175032023', '117503', 'Tanah Tumbuh', 4),
	('1175042001', '117504', 'Pasir Belo', 4),
	('1175042002', '117504', 'Bawan', 4),
	('1175042003', '117504', 'Sigrun', 4),
	('1175042004', '117504', 'Jabi-jabi', 4),
	('1175042005', '117504', 'Lae Simolap', 4),
	('1175042006', '117504', 'Lae Langge', 4),
	('1175042007', '117504', 'Suka Maju', 4),
	('1175042008', '117504', 'Gunung Bakti', 4),
	('1175042009', '117504', 'Jambi Baru', 4),
	('1175042010', '117504', 'Pulau Kedep', 4),
	('1175042011', '117504', 'Pulau Belen', 4),
	('1175042012', '117504', 'Singgersing', 4),
	('1175042013', '117504', 'Namo Buaya', 4),
	('1175042014', '117504', 'Cipare-pare', 4),
	('1175042015', '117504', 'Bunga Tanjung', 4),
	('1175042016', '117504', 'Cipar Pari Timur', 4),
	('1175042018', '117504', 'Darul Makmur', 4),
	('1175042019', '117504', 'Jabi-Jabi Barat', 4),
	('1175042020', '117504', 'Batu Napal', 4),
	('1175052001', '117505', 'Longkib', 4),
	('1175052002', '117505', 'Sepang', 4),
	('1175052003', '117505', 'Panji', 4),
	('1175052004', '117505', 'Lae Saga', 4),
	('1175052005', '117505', 'Sikerabang', 4),
	('1175052006', '117505', 'Rantau Panjang', 4),
	('1175052007', '117505', 'Bukit Panjang', 4),
	('1175052008', '117505', 'Darul Aman Ginansing', 4),
	('1175052009', '117505', 'Bangun Sari', 4),
	('1175052010', '117505', 'Darussalam', 4),
	('1201011001', '120101', 'Pasar Batu Gerigis', 3),
	('1201011002', '120101', 'Padang Masiang', 3),
	('1201012003', '120101', 'Kampung Solok', 4),
	('1201012004', '120101', 'Pasar Terandam', 4),
	('1201012005', '120101', 'Sigambo Gambo', 4),
	('1201012006', '120101', 'Ujung Batu', 4),
	('1201012007', '120101', 'Kinali', 4),
	('1201012008', '120101', 'Kampung Mudik', 4),
	('1201012009', '120101', 'Aek Dakka', 4),
	('1201012010', '120101', 'Patupangan', 4),
	('1201012011', '120101', 'Gabungan Hasang', 4),
	('1201012017', '120101', 'Bungo Tanjung', 4),
	('1201012018', '120101', 'Kedai Gedang', 4),
	('1201021001', '120102', 'Sorkam', 3),
	('1201021002', '120102', 'Pargarutan', 3),
	('1201021004', '120102', 'Tarutung Bolak', 3),
	('1201021009', '120102', 'Naipospos Barat', 3),
	('1201022003', '120102', 'Teluk Roban', 4),
	('1201022005', '120102', 'Fajar', 4),
	('1201022006', '120102', 'Pardamean', 4),
	('1201022007', '120102', 'Pelita', 4),
	('1201022008', '120102', 'Rianiate', 4),
	('1201022010', '120102', 'Gonting Mahe', 4),
	('1201022011', '120102', 'Dolok Pantis', 4),
	('1201022014', '120102', 'Pea Raja', 4),
	('1201022015', '120102', 'Bottot', 4),
	('1201022016', '120102', 'Sorkam Tengah', 4),
	('1201022017', '120102', 'Sorkam Kiri', 4),
	('1201022018', '120102', 'Pananggahan', 4),
	('1201022019', '120102', 'Pagaran Julu', 4),
	('1201022020', '120102', 'Hite Urat', 4),
	('1201022021', '120102', 'Sihapas', 4),
	('1201022022', '120102', 'Nauli', 4),
	('1201022023', '120102', 'Muara Nauli', 4),
	('1201031001', '120103', 'Pandan', 3),
	('1201031002', '120103', 'Hajoran', 3),
	('1201031003', '120103', 'Aek Tolang', 3),
	('1201031004', '120103', 'Lubuk Tukko', 3),
	('1201031005', '120103', 'Sibuluan Indah', 3),
	('1201031006', '120103', 'Sibuluan Nauli', 3),
	('1201031011', '120103', 'Aek Sitio-tio', 3),
	('1201031012', '120103', 'Sibuluan Raya', 3),
	('1201031013', '120103', 'Kalangan', 3),
	('1201031016', '120103', 'Pandan Wangi', 3),
	('1201031017', '120103', 'Lubuk Tukko Baru', 3),
	('1201031018', '120103', 'Sibuluan Baru', 3),
	('1201031019', '120103', 'Sibuluan Terpadu', 3),
	('1201031020', '120103', 'Sihaporas Nauli', 3),
	('1201031021', '120103', 'Pasar Baru', 3),
	('1201031022', '120103', 'Budi Luhur', 3),
	('1201031023', '120103', 'Kalangan Indah', 3),
	('1201031024', '120103', 'Mangga Dua', 3),
	('1201031025', '120103', 'Muara Nibung', 3),
	('1201031026', '120103', 'Hajoran Indah', 3),
	('1201032014', '120103', 'Aek Garut', 4),
	('1201032015', '120103', 'Sitio-Tio Hilir', 4),
	('1201041001', '120104', 'Pinangsori', 3),
	('1201041004', '120104', 'Sitonong Bangun', 3),
	('1201041007', '120104', 'Pinangbaru', 3),
	('1201041009', '120104', 'Albion Prancis', 3),
	('1201041010', '120104', 'Sori Nauli', 3),
	('1201042002', '120104', 'Gunung Marijo', 4),
	('1201042003', '120104', 'Sihaporas', 4),
	('1201042005', '120104', 'Toga Basir', 4),
	('1201042006', '120104', 'Parjalihotan Baru', 4),
	('1201042008', '120104', 'Danau Pandan', 4),
	('1201051001', '120105', 'P.O. Manduamas', 3),
	('1201051003', '120105', 'Binjohara', 3),
	('1201051020', '120105', 'Perluasan', 3),
	('1201052002', '120105', 'Saragih', 4),
	('1201052004', '120105', 'Pagaran Nauli', 4),
	('1201052005', '120105', 'Sarma Nauli', 4),
	('1201052006', '120105', 'Manduamas Lama', 4),
	('1201052007', '120105', 'Tumba', 4),
	('1201052008', '120105', 'Tumba Jae', 4),
	('1201052009', '120105', 'Lae Monong', 4),
	('1201052010', '120105', 'Saragih Barat', 4),
	('1201052011', '120105', 'Saragih Timur', 4),
	('1201052012', '120105', 'Binjohara Uruk', 4),
	('1201052013', '120105', 'Binjohara Baru', 4),
	('1201052014', '120105', 'Tumba Nauli', 4),
	('1201052015', '120105', 'Manduamas Baru', 4),
	('1201052016', '120105', 'Muara Tapus', 4),
	('1201052017', '120105', 'Pagaran Baru', 4),
	('1201052018', '120105', 'Parsihotangan', 4),
	('1201052019', '120105', 'Tambahan Nanjur', 4),
	('1201061006', '120106', 'P.O. Hurlang', 3),
	('1201061007', '120106', 'Kolang Nauli', 3),
	('1201062001', '120106', 'Unte Mungkur IV', 4),
	('1201062002', '120106', 'Unte Mungkur III', 4),
	('1201062003', '120106', 'Unte Mungkur II', 4),
	('1201062004', '120106', 'Unte Mungkur I', 4),
	('1201062005', '120106', 'Satahi Nauli', 4),
	('1201062008', '120106', 'Hurlang Muara Nauli', 4),
	('1201062009', '120106', 'Sipakpahi Aek Lobu', 4),
	('1201062010', '120106', 'Hodopa Nauli', 4),
	('1201062011', '120106', 'Makarti Nauli', 4),
	('1201062012', '120106', 'Rawa Makmur', 4),
	('1201062013', '120106', 'Simarpinggang', 4),
	('1201062014', '120106', 'Pargaringan', 4),
	('1201071001', '120107', 'Tapian Nauli II', 3),
	('1201072002', '120107', 'Tapian Nauli I', 4),
	('1201072003', '120107', 'Tapian Nauli III', 4),
	('1201072004', '120107', 'Tapian Nauli IV', 4),
	('1201072005', '120107', 'Aloban Bair', 4),
	('1201072006', '120107', 'Mela Dolok', 4),
	('1201072007', '120107', 'Mela I', 4),
	('1201072008', '120107', 'Mela II', 4),
	('1201072009', '120107', 'Bair', 4),
	('1201081002', '120108', 'Sibabangun', 3),
	('1201082005', '120108', 'Mombang Boru', 4),
	('1201082006', '120108', 'Anggoli', 4),
	('1201082007', '120108', 'Muara Sibuntuon', 4),
	('1201082008', '120108', 'Sibio bio', 4),
	('1201082010', '120108', 'Simanosor', 4),
	('1201082011', '120108', 'Hutagur-gur', 4),
	('1201091001', '120109', 'Sosor Gadong', 3),
	('1201092002', '120109', 'Unte Boang', 4),
	('1201092003', '120109', 'Sibintang', 4),
	('1201092004', '120109', 'Barambang', 4),
	('1201092005', '120109', 'Siantar Ca.', 4),
	('1201092006', '120109', 'Muara Bolak', 4),
	('1201092007', '120109', 'Huta Tombak', 4),
	('1201092008', '120109', 'Siantar Dolok', 4),
	('1201092009', '120109', 'Baringin', 4),
	('1201101001', '120110', 'Sorkam Kanan', 3),
	('1201101019', '120110', 'Binasi', 3),
	('1201102002', '120110', 'Sipea Pea', 4),
	('1201102003', '120110', 'Pahieme I', 4),
	('1201102004', '120110', 'Pasar Sorkam', 4),
	('1201102005', '120110', 'Aek Raso', 4),
	('1201102006', '120110', 'Pasaribu Tobing Jae', 4),
	('1201102014', '120110', 'Maduma', 4),
	('1201102016', '120110', 'Sidikalang', 4),
	('1201102017', '120110', 'Pahieme II', 4),
	('1201102018', '120110', 'Sorkam Kanan', 4),
	('1201102020', '120110', 'Madani', 4),
	('1201111001', '120111', 'Bajamas', 3),
	('1201112002', '120111', 'Sampang Maruhur', 4),
	('1201112004', '120111', 'Pardomuan', 4),
	('1201112005', '120111', 'Simpang III Lae Bingke', 4),
	('1201112006', '120111', 'Sigodung', 4),
	('1201112007', '120111', 'Masnauli', 4),
	('1201112008', '120111', 'Muara Ode', 4),
	('1201121007', '120112', 'Rina Bolak', 3),
	('1201122001', '120112', 'Sijungkang', 4),
	('1201122002', '120112', 'Pangaribuan', 4),
	('1201122003', '120112', 'Sogar', 4),
	('1201122004', '120112', 'Sirami Ramian', 4),
	('1201122005', '120112', 'Sigolang', 4),
	('1201122006', '120112', 'Sosor Gonting', 4),
	('1201122008', '120112', 'Bondar Sihudon I', 4),
	('1201122009', '120112', 'Uratan', 4),
	('1201122010', '120112', 'Ladang Tengah', 4),
	('1201122011', '120112', 'Lobu Tua', 4),
	('1201122012', '120112', 'Bondar Sihudon II', 4),
	('1201122013', '120112', 'Sitiris-Tiris', 4),
	('1201122014', '120112', 'Sawah Lamo', 4),
	('1201131003', '120113', 'Nauli', 3),
	('1201132001', '120113', 'Bonandolok', 4),
	('1201132002', '120113', 'Rampa', 4),
	('1201132004', '120113', 'Mardame', 4),
	('1201132005', '120113', 'Naga Timbul', 4),
	('1201132006', '120113', 'Simaninggir', 4),
	('1201141001', '120114', 'Tukka', 3),
	('1201141002', '120114', 'Bona Lumban', 3),
	('1201141003', '120114', 'Huta Nabolon', 3),
	('1201141007', '120114', 'Sipange', 3),
	('1201141009', '120114', 'Aek Tolang Induk', 3),
	('1201142004', '120114', 'Sigiring Giring', 4),
	('1201142005', '120114', 'Tapian Nauli/ Saurmanggita', 4),
	('1201142006', '120114', 'Sait Kalangan II', 4),
	('1201142008', '120114', 'Aek Bottar', 4),
	('1201151001', '120115', 'Hutabalang', 3),
	('1201151002', '120115', 'Lopian', 3),
	('1201152003', '120115', 'Jago Jago', 4),
	('1201152004', '120115', 'Aek Horsik', 4),
	('1201152005', '120115', 'Gunung Kelambu', 4),
	('1201152006', '120115', 'Kebun Pisang', 4),
	('1201152007', '120115', 'Lubuk Ampolu', 4),
	('1201152008', '120115', 'Pagaran Honas', 4),
	('1201152009', '120115', 'Sitardas', 4),
	('1201162001', '120116', 'Suga Suga Hutagodang', 4),
	('1201162002', '120116', 'Suka Maju', 4),
	('1201162003', '120116', 'Makmur', 4),
	('1201162004', '120116', 'Pasaribu Tobing', 4),
	('1201162005', '120116', 'Aek Nadua', 4),
	('1201162006', '120116', 'Simargarap', 4),
	('1201162007', '120116', 'Sidaling', 4),
	('1201162008', '120116', 'Sipakpahi', 4),
	('1201162009', '120116', 'PO Simargarap', 4),
	('1201172001', '120117', 'Hutaginjang', 4),
	('1201172002', '120117', 'Sihorbo', 4),
	('1201172003', '120117', 'Parik Sinomba', 4),
	('1201172004', '120117', 'Purba Tua', 4),
	('1201172005', '120117', 'Pananggahan', 4),
	('1201172006', '120117', 'Siharbangan', 4),
	('1201182001', '120118', 'Pulo Pakkat', 4),
	('1201182002', '120118', 'Tebing Tinggi', 4),
	('1201182003', '120118', 'Pulo Pakkat II', 4),
	('1201182004', '120118', 'Janji Maria', 4),
	('1201182005', '120118', 'Sihadatuon', 4),
	('1201182006', '120118', 'Sihapas', 4),
	('1201191001', '120119', 'Lumut', 3),
	('1201192002', '120119', 'Aek Gambir', 4),
	('1201192003', '120119', 'Masundung', 4),
	('1201192004', '120119', 'Sihalogo', 4),
	('1201192005', '120119', 'Lumut Nauli', 4),
	('1201192006', '120119', 'Lumut Maju', 4),
	('1201192007', '120119', 'Sialogo', 4),
	('1201201001', '120120', 'Sibuluan Nalambok', 3),
	('1201201002', '120120', 'Sarudik', 3),
	('1201201004', '120120', 'Pasir Bidang', 3),
	('1201201005', '120120', 'Pondok Batu', 3),
	('1201202003', '120120', 'Sipan', 4),
	('1202011001', '120201', 'Partoli Toruan', 3),
	('1202011002', '120201', 'Hutatoruan V', 3),
	('1202011003', '120201', 'Hutatoruan VI', 3),
	('1202011004', '120201', 'Hutatoruan VII', 3),
	('1202011005', '120201', 'Hutatoruan IX', 3),
	('1202011006', '120201', 'Hutatoruan X', 3),
	('1202011007', '120201', 'Hutatoruan XI', 3),
	('1202012008', '120201', 'Parbubu I', 4),
	('1202012009', '120201', 'Parbubu II', 4),
	('1202012010', '120201', 'Hutapea Banuarea', 4),
	('1202012011', '120201', 'Siandor-andor', 4),
	('1202012012', '120201', 'Hutauruk', 4),
	('1202012013', '120201', 'Hapoltahan', 4),
	('1202012014', '120201', 'Parbubu Dolok', 4),
	('1202012015', '120201', 'Aek Siansimun', 4),
	('1202012016', '120201', 'Htgalung Siwaluompo', 4),
	('1202012017', '120201', 'Parbubu Pea', 4),
	('1202012018', '120201', 'Hutatoruan IV', 4),
	('1202012019', '120201', 'Sosunggulon', 4),
	('1202012020', '120201', 'Hutatoruan VIII', 4),
	('1202012021', '120201', 'Simamora', 4),
	('1202012022', '120201', 'Parbaju Toruan', 4),
	('1202012023', '120201', 'Parbaju Julu', 4),
	('1202012024', '120201', 'Parbaju Tonga', 4),
	('1202012025', '120201', 'Sitampurung', 4),
	('1202012026', '120201', 'Siraja Oloan', 4),
	('1202012027', '120201', 'Jambur Nauli', 4),
	('1202012028', '120201', 'Sihujur', 4),
	('1202012029', '120201', 'Partali Julu', 4),
	('1202012030', '120201', 'Hutatoruan I', 4),
	('1202012031', '120201', 'Hutatoruan III', 4),
	('1202022001', '120202', 'Siraja Hutagalung', 4),
	('1202022002', '120202', 'Pansur Napitu', 4),
	('1202022003', '120202', 'Simanampang', 4),
	('1202022004', '120202', 'Sidagal', 4),
	('1202022005', '120202', 'Simarakir Julu', 4),
	('1202022006', '120202', 'Enda Portibi', 4),
	('1202022007', '120202', 'Simorangkir Habinsaran', 4),
	('1202022008', '120202', 'Sangkaran', 4),
	('1202022009', '120202', 'Lumban Siagian Jae', 4),
	('1202022010', '120202', 'Lumban Siagian Julu', 4),
	('1202022011', '120202', 'Sitompul', 4),
	('1202022012', '120202', 'Lobu Hole', 4),
	('1202032001', '120203', 'Dolok Nauli', 4),
	('1202032002', '120203', 'Pansurbatu', 4),
	('1202032003', '120203', 'Pardomuan Nauli', 4),
	('1202032004', '120203', 'Siantar Naipospos', 4),
	('1202032005', '120203', 'Sibalanga', 4),
	('1202032006', '120203', 'Pagaran Lambung III', 4),
	('1202032007', '120203', 'Pagaran Lambung IV', 4),
	('1202032008', '120203', 'Adian Koting', 4),
	('1202032009', '120203', 'Pangaran Pisang', 4),
	('1202032010', '120203', 'Banuaji IV', 4),
	('1202032011', '120203', 'Banuaji I', 4),
	('1202032012', '120203', 'Banuaji II', 4),
	('1202032013', '120203', 'Pangaran Lambung I', 4),
	('1202032014', '120203', 'Pangaran Lambung II', 4),
	('1202032015', '120203', 'Pansurbatu I', 4),
	('1202032016', '120203', 'Pansurbatu II', 4),
	('1202041001', '120204', 'Situmeang Habinsaran', 3),
	('1202042002', '120204', 'Hutauruk', 4),
	('1202042003', '120204', 'Simanungkalit', 4),
	('1202042004', '120204', 'Situmeang Hasundutan', 4),
	('1202042005', '120204', 'Sipahutar', 4),
	('1202042007', '120204', 'Tapian Nauli', 4),
	('1202042008', '120204', 'Huta Raja', 4),
	('1202042009', '120204', 'Lobu Singkam', 4),
	('1202042010', '120204', 'Rura Julu Dolok', 4),
	('1202042011', '120204', 'Rura Julu Toruan', 4),
	('1202042012', '120204', 'Hutaraja Hasundutan', 4),
	('1202042013', '120204', 'Pagarbatu', 4),
	('1202042014', '120204', 'Hutaraja Simanungkalit', 4),
	('1202042015', '120204', 'Hutauruk Hasundutan', 4),
	('1202051001', '120205', 'Onan Hasang', 3),
	('1202052002', '120205', 'Simasom', 4),
	('1202052003', '120205', 'Janji Natogu', 4),
	('1202052004', '120205', 'Pagur Dotan', 4),
	('1202052005', '120205', 'Sibaganding', 4),
	('1202052006', '120205', 'Lumban Garaga', 4),
	('1202052007', '120205', 'Sitolu Ama', 4),
	('1202052008', '120205', 'Lumban Tonga', 4),
	('1202052009', '120205', 'Lumban Dolok', 4),
	('1202052010', '120205', 'Simataniari', 4),
	('1202052011', '120205', 'Lumban Jaean', 4),
	('1202052012', '120205', 'Huta Barat', 4),
	('1202052013', '120205', 'Lontung Dolok', 4),
	('1202052014', '120205', 'Simanampang', 4),
	('1202052015', '120205', 'Lobu Pining', 4),
	('1202052016', '120205', 'Pantis', 4),
	('1202052017', '120205', 'Lumban Gaol', 4),
	('1202052018', '120205', 'Simardangiang', 4),
	('1202052019', '120205', 'Simasom Toruan', 4),
	('1202061001', '120206', 'Sarulla', 3),
	('1202062002', '120206', 'Tordolok Nauli', 4),
	('1202062003', '120206', 'Sigurung-gurung', 4),
	('1202062004', '120206', 'Silangkitang', 4),
	('1202062005', '120206', 'Sitoluompu', 4),
	('1202062006', '120206', 'Siopat Bahal', 4),
	('1202062007', '120206', 'Pardomuan Nainggolan', 4),
	('1202062008', '120206', 'Nahornop Marsada', 4),
	('1202062009', '120206', 'Parsaoran Samosir', 4),
	('1202062010', '120206', 'Suka Maju', 4),
	('1202062011', '120206', 'Setia', 4),
	('1202062012', '120206', 'Parsaoran Nainggolan', 4),
	('1202062013', '120206', 'Pardamean Nainggolan', 4),
	('1202072001', '120207', 'Silosung', 4),
	('1202072002', '120207', 'Dolok Sanggul', 4),
	('1202072003', '120207', 'Simangumban Jae', 4),
	('1202072004', '120207', 'Aek Nabara', 4),
	('1202072005', '120207', 'Dolok Saut', 4),
	('1202072006', '120207', 'Simangumban Julu', 4),
	('1202072007', '120207', 'Lobu Sihim', 4),
	('1202072008', '120207', 'Pardomuan', 4),
	('1202082001', '120208', 'Sidua Bahal', 4),
	('1202082002', '120208', 'Sibulan Bulan', 4),
	('1202082003', '120208', 'Bonani Dolok', 4),
	('1202082004', '120208', 'Pardomuan J. Angkola', 4),
	('1202082005', '120208', 'Hutanagodang', 4),
	('1202082006', '120208', 'Robean', 4),
	('1202082007', '120208', 'Janji Nauli', 4),
	('1202082008', '120208', 'Selamat', 4),
	('1202082009', '120208', 'Purba Tua', 4),
	('1202082010', '120208', 'Sitolu Bahal', 4),
	('1202082011', '120208', 'Parsaoran J. Angkola', 4),
	('1202091001', '120209', 'Psr Siborong Borong', 3),
	('1202092002', '120209', 'Siborong Borong I', 4),
	('1202092003', '120209', 'Siborong Borong II', 4),
	('1202092004', '120209', 'Sitampurung', 4),
	('1202092005', '120209', 'Sitabotabo', 4),
	('1202092006', '120209', 'Bahal Batu I', 4),
	('1202092007', '120209', 'Bahal Batu II', 4),
	('1202092008', '120209', 'Bahal Batu III', 4),
	('1202092009', '120209', 'Lobu Siregar I', 4),
	('1202092010', '120209', 'Lobu Siregar II', 4),
	('1202092011', '120209', 'Pohan Julu', 4),
	('1202092012', '120209', 'Pohan Tonga', 4),
	('1202092013', '120209', 'Pohan Jae', 4),
	('1202092014', '120209', 'Paniaran', 4),
	('1202092015', '120209', 'Parik Sabungan', 4),
	('1202092016', '120209', 'Hutabulu', 4),
	('1202092017', '120209', 'Lumban Tonga Tonga', 4),
	('1202092018', '120209', 'Sigumbang', 4),
	('1202092019', '120209', 'Siaro', 4),
	('1202092020', '120209', 'Silait-Lait', 4),
	('1202092021', '120209', 'Sitabotabo Toruan', 4),
	('1202102001', '120210', 'Simamora Hasibuan', 4),
	('1202102002', '120210', 'Lumban Julu', 4),
	('1202102003', '120210', 'Pagaran', 4),
	('1202102004', '120210', 'Sibaragas', 4),
	('1202102005', '120210', 'Sipultak', 4),
	('1202102006', '120210', 'Lubis', 4),
	('1202102007', '120210', 'Banualuhu', 4),
	('1202102008', '120210', 'Parhorboan', 4),
	('1202102009', '120210', 'Lumban Motung', 4),
	('1202102010', '120210', 'Lumban Ina Ina', 4),
	('1202102011', '120210', 'Doloksaribu', 4),
	('1202102012', '120210', 'Lumban Silintong', 4),
	('1202102013', '120210', 'Sipultak Dolok', 4),
	('1202102014', '120210', 'Hasibuan', 4),
	('1202112001', '120211', 'Manalu', 4),
	('1202112002', '120211', 'Manalu Purba', 4),
	('1202112003', '120211', 'Manalu Dolok', 4),
	('1202112004', '120211', 'Hutajulu', 4),
	('1202112005', '120211', 'Aek Raja', 4),
	('1202112006', '120211', 'Hutatinggi', 4),
	('1202112007', '120211', 'Lobusunut', 4),
	('1202112008', '120211', 'Sisordak', 4),
	('1202112009', '120211', 'Pertengahan', 4),
	('1202112010', '120211', 'Hutatua', 4),
	('1202112011', '120211', 'Hutajulu Parbalik', 4),
	('1202112012', '120211', 'Horisan Ranggitgit', 4),
	('1202112013', '120211', 'Purba Dolok', 4),
	('1202112014', '120211', 'Batuarimo', 4),
	('1202122001', '120212', 'Sabungannihuta IV', 4),
	('1202122002', '120212', 'Sabungannihuta I', 4),
	('1202122003', '120212', 'Sipahutar I', 4),
	('1202122004', '120212', 'Sipahutar II', 4),
	('1202122005', '120212', 'Sipahutar III', 4),
	('1202122006', '120212', 'Onan Runggu I', 4),
	('1202122007', '120212', 'Tapian Nauli III', 4),
	('1202122008', '120212', 'Onan Runggu III', 4),
	('1202122009', '120212', 'Siabal-abal III', 4),
	('1202122010', '120212', 'Siabal-abal I', 4),
	('1202122011', '120212', 'Aek Nauli II', 4),
	('1202122012', '120212', 'Tapian Nauli II', 4),
	('1202122013', '120212', 'Sabungannihuta III', 4),
	('1202122014', '120212', 'Onan Runggu IV', 4),
	('1202122015', '120212', 'Siabal-abal II', 4),
	('1202122016', '120212', 'Aek Nauli I', 4),
	('1202122017', '120212', 'Aek Nauli III', 4),
	('1202122018', '120212', 'Onan Runggu II', 4),
	('1202122019', '120212', 'Tapian Nauli I', 4),
	('1202122020', '120212', 'Sabungannihuta II', 4),
	('1202122021', '120212', 'Sabungannihuta V', 4),
	('1202122022', '120212', 'Siabal-abal IV', 4),
	('1202122023', '120212', 'Aek Nauli IV', 4),
	('1202122024', '120212', 'Siabal-abal V', 4),
	('1202122025', '120212', 'Siabal-abal VI', 4),
	('1202132001', '120213', 'Pakpahan', 4),
	('1202132002', '120213', 'Sampagul', 4),
	('1202132003', '120213', 'Godung Borotan', 4),
	('1202132004', '120213', 'Parratusan', 4),
	('1202132005', '120213', 'Lumban Siregar', 4),
	('1202132006', '120213', 'Sigotom Julu', 4),
	('1202132007', '120213', 'Rahut Bosi', 4),
	('1202132008', '120213', 'Batu Nadua', 4),
	('1202132009', '120213', 'Silantom Tonga', 4),
	('1202132010', '120213', 'Silantom Julu', 4),
	('1202132011', '120213', 'Pansurnatolu', 4),
	('1202132012', '120213', 'Parlombuan', 4),
	('1202132013', '120213', 'Purbatua', 4),
	('1202132014', '120213', 'Lumban Sinaga Simatupang', 4),
	('1202132015', '120213', 'Batumanumpak', 4),
	('1202132016', '120213', 'Sibingke', 4),
	('1202132017', '120213', 'Najumambe', 4),
	('1202132018', '120213', 'Parsibarungan', 4),
	('1202132019', '120213', 'Harianja', 4),
	('1202132020', '120213', 'Silantom Jae', 4),
	('1202132021', '120213', 'Padang Parsadaan', 4),
	('1202132022', '120213', 'Parsorminan I', 4),
	('1202132023', '120213', 'Hutaraja', 4),
	('1202132024', '120213', 'Rahut Bosi Onan', 4),
	('1202132025', '120213', 'Sigotom Timur', 4),
	('1202132026', '120213', 'Sigotom Dolok Nauli', 4),
	('1202142001', '120214', 'Garoga Sibargot', 4),
	('1202142002', '120214', 'Lontung Jae I', 4),
	('1202142003', '120214', 'Parsosoran', 4),
	('1202142004', '120214', 'Padang Siandomang', 4),
	('1202142005', '120214', 'Sibaganding', 4),
	('1202142006', '120214', 'Sirmpang Bolon', 4),
	('1202142007', '120214', 'Gonting Garoga', 4),
	('1202142008', '120214', 'Lontung Jae II', 4),
	('1202142009', '120214', 'Gonting Salak', 4),
	('1202142010', '120214', 'Sibalanga', 4),
	('1202142011', '120214', 'Aek Tangga', 4),
	('1202142012', '120214', 'Parinsoran', 4),
	('1202142013', '120214', 'Parmanuhan', 4),
	('1202152001', '120215', 'Hutanagodang', 4),
	('1202152002', '120215', 'Unte Mungkur', 4),
	('1202152003', '120215', 'Hutalontung', 4),
	('1202152004', '120215', 'Hutaginjang', 4),
	('1202152005', '120215', 'Dolok Matumbur', 4),
	('1202152006', '120215', 'Mariba Ni Aek', 4),
	('1202152007', '120215', 'Sampuran', 4),
	('1202152008', '120215', 'Silando', 4),
	('1202152009', '120215', 'Sibandang', 4),
	('1202152010', '120215', 'Simatupang', 4),
	('1202152011', '120215', 'Silali Toruan', 4),
	('1202152012', '120215', 'Batubinumbun', 4),
	('1202152013', '120215', 'Sitanggor', 4),
	('1202152014', '120215', 'Papande', 4),
	('1202152015', '120215', 'Aritonang', 4),
	('1203011001', '120301', 'Sitinjak', 3),
	('1203011003', '120301', 'Simatorkis Sisoma', 3),
	('1203012002', '120301', 'Panobasan', 4),
	('1203012004', '120301', 'Siuhom', 4),
	('1203012005', '120301', 'Sigumuru', 4),
	('1203012006', '120301', 'Sibangkua', 4),
	('1203012007', '120301', 'Sisundung', 4),
	('1203012008', '120301', 'Aek Nabara', 4),
	('1203012011', '120301', 'Parsalakan', 4),
	('1203012015', '120301', 'Sitaratoit', 4),
	('1203012016', '120301', 'Sialogo', 4),
	('1203012024', '120301', 'Lembah Lubuk Raya', 4),
	('1203012031', '120301', 'Lobulayan Sigordang', 4),
	('1203012035', '120301', 'Panobasan Lombang', 4),
	('1203021001', '120302', 'Wek I', 3),
	('1203021002', '120302', 'Wek II', 3),
	('1203021011', '120302', 'Perkebunan Btg. Toru', 3),
	('1203021030', '120302', 'Padang Lancat', 3),
	('1203021032', '120302', 'Aek Pining', 3),
	('1203022003', '120302', 'Garoga', 4),
	('1203022004', '120302', 'Hutagodang', 4),
	('1203022005', '120302', 'Batu Horing', 4),
	('1203022008', '120302', 'Batu Hula', 4),
	('1203022009', '120302', 'Sumuran', 4),
	('1203022015', '120302', 'Napa', 4),
	('1203022016', '120302', 'Wek IV Batang Toru', 4),
	('1203022017', '120302', 'Hapesong Baru', 4),
	('1203022018', '120302', 'Telo', 4),
	('1203022019', '120302', 'Wek III Batang Toru', 4),
	('1203022020', '120302', 'Perkebunan Sigala-Gala', 4),
	('1203022021', '120302', 'Perkebunan Hapesong', 4),
	('1203022022', '120302', 'Hapesong Lama', 4),
	('1203022023', '120302', 'Sipenggeng', 4),
	('1203022025', '120302', 'Sianggunan', 4),
	('1203022026', '120302', 'Huta Baru', 4),
	('1203022036', '120302', 'Aek Nauli', 4),
	('1203022037', '120302', 'Sisipa', 4),
	('1203031098', '120303', 'Pasar Pargarutan', 3),
	('1203031099', '120303', 'Batang Tura Sirumambe', 3),
	('1203032003', '120303', 'Panompuan Jae', 4),
	('1203032004', '120303', 'Pargarutan Tonga', 4),
	('1203032008', '120303', 'Huraba', 4),
	('1203032012', '120303', 'Marisi', 4),
	('1203032013', '120303', 'Pargarutan Julu', 4),
	('1203032014', '120303', 'Huta Ginjang', 4),
	('1203032049', '120303', 'Pargarutan Huta Baru', 4),
	('1203032069', '120303', 'Lantosan Rogas', 4),
	('1203032079', '120303', 'Sijungkang', 4),
	('1203032083', '120303', 'Pargarutan Jae', 4),
	('1203032094', '120303', 'Panompuan', 4),
	('1203032095', '120303', 'Pargarutan Dolok', 4),
	('1203032096', '120303', 'Sanggapati', 4),
	('1203032097', '120303', 'Pall XI', 4),
	('1203041001', '120304', 'Pasar Sipirok', 3),
	('1203041003', '120304', 'Hutasuhut', 3),
	('1203041004', '120304', 'Baringin', 3),
	('1203041005', '120304', 'Bunga Bondar', 3),
	('1203041061', '120304', 'Parau Sorat', 3),
	('1203041114', '120304', 'Sipirok Godang', 3),
	('1203042010', '120304', 'Bagas Lombang', 4),
	('1203042017', '120304', 'Batu Satail', 4),
	('1203042025', '120304', 'Hasang Marsada', 4),
	('1203042034', '120304', 'Janji Mauli', 4),
	('1203042048', '120304', 'Paran Julu', 4),
	('1203042051', '120304', 'Pangaribuan', 4),
	('1203042052', '120304', 'Pargarutan', 4),
	('1203042054', '120304', 'Panaungan', 4),
	('1203042059', '120304', 'Padang Bujur', 4),
	('1203042060', '120304', 'Paran padang', 4),
	('1203042064', '120304', 'Pangurabaan', 4),
	('1203042068', '120304', 'Ramba Sihasur', 4),
	('1203042069', '120304', 'Tolang', 4),
	('1203042072', '120304', 'Sampean', 4),
	('1203042075', '120304', 'Simaninggir', 4),
	('1203042076', '120304', 'Sibadoar', 4),
	('1203042085', '120304', 'Siala Gundi', 4),
	('1203042096', '120304', 'Bulu Mario', 4),
	('1203042097', '120304', 'Barnang Koling', 4),
	('1203042101', '120304', 'Dolok Sordang Julu', 4),
	('1203042102', '120304', 'Situmba Julu', 4),
	('1203042103', '120304', 'Situmba', 4),
	('1203042104', '120304', 'Kilang Papan', 4),
	('1203042105', '120304', 'Sialaman', 4),
	('1203042106', '120304', 'Paran Dolok Mardomu', 4),
	('1203042107', '120304', 'Batang Tura Julu', 4),
	('1203042108', '120304', 'Batang Tura', 4),
	('1203042109', '120304', 'Dolok Sordang', 4),
	('1203042110', '120304', 'Pahae Aek Sagala', 4),
	('1203042111', '120304', 'Marsada', 4),
	('1203042112', '120304', 'Luat Lombang', 4),
	('1203042113', '120304', 'Aek Batang Paya', 4),
	('1203042115', '120304', 'Saba Batang Miha', 4),
	('1203042116', '120304', 'Sarogodung', 4),
	('1203051001', '120305', 'Pasar Sipagimbar', 3),
	('1203051080', '120305', 'Aek Simotung', 3),
	('1203052018', '120305', 'Simangambat Godang', 4),
	('1203052039', '120305', 'Huta Pohan', 4),
	('1203052053', '120305', 'Purba Sinomba Sena', 4),
	('1203052059', '120305', 'Huta Hombang', 4),
	('1203052069', '120305', 'Sidapdap Simanosor', 4),
	('1203052070', '120305', 'Saut Banua Simanosor', 4),
	('1203052071', '120305', 'Damparan Haunatas', 4),
	('1203052072', '120305', 'Somba Debata Purba', 4),
	('1203052073', '120305', 'Padang Mandailing Garugur', 4),
	('1203052074', '120305', 'Ulu Mamis Situnggaling', 4),
	('1203052075', '120305', 'Parau Sorat Sitabo Tabo', 4),
	('1203052076', '120305', 'Pintu Padang Mandalasena', 4),
	('1203052077', '120305', 'Sunge Sigiring Giring', 4),
	('1203052078', '120305', 'Silangkitang Tambiski', 4),
	('1203052079', '120305', 'Batang Parsuluman', 4),
	('1203061001', '120306', 'Simarpinggan', 3),
	('1203061007', '120306', 'Napa', 3),
	('1203061014', '120306', 'Tapian Nauli', 3),
	('1203061019', '120306', 'Pardomuan', 3),
	('1203062004', '120306', 'Situmbaga', 4),
	('1203062005', '120306', 'Sinyior', 4),
	('1203062006', '120306', 'Pintu Padang', 4),
	('1203062008', '120306', 'Sibongbong', 4),
	('1203062009', '120306', 'Siamporik Dolok', 4),
	('1203062010', '120306', 'Siamporik Lombang', 4),
	('1203062011', '120306', 'Sihopur', 4),
	('1203062012', '120306', 'Tandihat', 4),
	('1203062013', '120306', 'Perk. Simarpinggan', 4),
	('1203062015', '120306', 'Aek Natas', 4),
	('1203062016', '120306', 'Dolok Godang', 4),
	('1203062017', '120306', 'Sihuik Huik', 4),
	('1203062018', '120306', 'Gunung Baringin', 4),
	('1203071001', '120307', 'Sigalangan', 3),
	('1203071009', '120307', 'Bintuju', 3),
	('1203071059', '120307', 'Huta Tonga', 3),
	('1203071060', '120307', 'Pintu Padang Raya Satu', 3),
	('1203071061', '120307', 'Pintu Padang Raya Dua', 3),
	('1203071068', '120307', 'Sijungkit', 3),
	('1203072004', '120307', 'Pasir', 4),
	('1203072005', '120307', 'Aek Nauli', 4),
	('1203072006', '120307', 'Basilam Baru', 4),
	('1203072007', '120307', 'Sipangko', 4),
	('1203072008', '120307', 'Huta Holdung', 4),
	('1203072010', '120307', 'Muara Tais II', 4),
	('1203072011', '120307', 'Muara Tais I', 4),
	('1203072012', '120307', 'Muara Tais III', 4),
	('1203072013', '120307', 'Janji Mauli MT', 4),
	('1203072016', '120307', 'Sidadi I', 4),
	('1203072018', '120307', 'Janji Manaon', 4),
	('1203072020', '120307', 'Sitampa', 4),
	('1203072021', '120307', 'Pasar Lama', 4),
	('1203072027', '120307', 'Benteng Huraba', 4),
	('1203072029', '120307', 'Padang Kahombu', 4),
	('1203072030', '120307', 'Sorik', 4),
	('1203072032', '120307', 'Pargumbangan', 4),
	('1203072040', '120307', 'Pangaribuan', 4),
	('1203072045', '120307', 'Sibulele', 4),
	('1203072047', '120307', 'Bargot Topong', 4),
	('1203072053', '120307', 'Sigulang Losung', 4),
	('1203072055', '120307', 'Hurase', 4),
	('1203072057', '120307', 'Sori Madingin PP.', 4),
	('1203072058', '120307', 'Huta Padang', 4),
	('1203072062', '120307', 'Tahalak Ujung', 4),
	('1203072063', '120307', 'Sidadi II', 4),
	('1203072064', '120307', 'Sorimadingin', 4),
	('1203072065', '120307', 'Muara Nauli', 4),
	('1203072066', '120307', 'Tatengger', 4),
	('1203072067', '120307', 'Aek Gunung', 4),
	('1203141039', '120314', 'Arse', 3),
	('1203141040', '120314', 'Lancat', 3),
	('1203142028', '120314', 'Sipogu', 4),
	('1203142032', '120314', 'Pinagar', 4),
	('1203142033', '120314', 'Pardomuan', 4),
	('1203142034', '120314', 'Arse Hanopan', 4),
	('1203142035', '120314', 'Nanggar Jati Hutapadang', 4),
	('1203142036', '120314', 'Nanggar Jati', 4),
	('1203142037', '120314', 'Natambang Roncitan', 4),
	('1203142038', '120314', 'Dalihan Natolu', 4),
	('1203201004', '120320', 'Pasar Sempurna', 3),
	('1203202002', '120320', 'Huraba', 4),
	('1203202014', '120320', 'Mombang Boru', 4),
	('1203202015', '120320', 'Marancar Godang', 4),
	('1203202016', '120320', 'Simaninggir', 4),
	('1203202023', '120320', 'Sugi Tonga', 4),
	('1203202028', '120320', 'Haunatas', 4),
	('1203202032', '120320', 'Aek Nabara', 4),
	('1203202033', '120320', 'Gapuk Tua', 4),
	('1203202034', '120320', 'Marancar', 4),
	('1203202035', '120320', 'Aek Sabaon', 4),
	('1203202036', '120320', 'Tanjung Dolok', 4),
	('1203211063', '120321', 'Sayur Matinggi', 3),
	('1203212003', '120321', 'Janji Mauli Baringin', 4),
	('1203212004', '120321', 'Mondang', 4),
	('1203212005', '120321', 'Sialang', 4),
	('1203212006', '120321', 'Sipange Julu', 4),
	('1203212007', '120321', 'Sipange Godang', 4),
	('1203212008', '120321', 'Tolang Julu', 4),
	('1203212009', '120321', 'Tolang Jae', 4),
	('1203212012', '120321', 'Bange', 4),
	('1203212013', '120321', 'Bulugading', 4),
	('1203212018', '120321', 'Aek Libung', 4),
	('1203212023', '120321', 'Aek Badak Jae', 4),
	('1203212024', '120321', 'Aek Badak Julu', 4),
	('1203212026', '120321', 'Huta Pardomuan', 4),
	('1203212056', '120321', 'Sipange Siunjam', 4),
	('1203212057', '120321', 'Silaiya', 4),
	('1203212058', '120321', 'Samonggal Parmonangan', 4),
	('1203212059', '120321', 'Lumban Huayan', 4),
	('1203212062', '120321', 'Silaiya Tanjung Leuk', 4),
	('1203222003', '120322', 'Sigolang', 4),
	('1203222005', '120322', 'Biru', 4),
	('1203222008', '120322', 'Tapus Godang', 4),
	('1203222017', '120322', 'Lobu Tayas', 4),
	('1203222020', '120322', 'Silangkitang', 4),
	('1203222033', '120322', 'Sihulambu', 4),
	('1203222043', '120322', 'Tolang', 4),
	('1203222044', '120322', 'Tapus Sipagabu', 4),
	('1203222045', '120322', 'Huta baru', 4),
	('1203222046', '120322', 'Aek Latong', 4),
	('1203222047', '120322', 'Aek Urat', 4),
	('1203222048', '120322', 'Huta Tonga', 4),
	('1203291002', '120329', 'Hutaraja', 3),
	('1203291008', '120329', 'Muara Manompas', 3),
	('1203291009', '120329', 'Muara Ampolu', 3),
	('1203292001', '120329', 'Bandar Hapinis', 4),
	('1203292003', '120329', 'Pardamean', 4),
	('1203292004', '120329', 'Tarapung Raya', 4),
	('1203292007', '120329', 'Muara Upu', 4),
	('1203292010', '120329', 'Simarlelan', 4),
	('1203292011', '120329', 'Muara Huta Raja', 4),
	('1203301001', '120330', 'Panabari Hutatonga', 3),
	('1203302002', '120330', 'Aek Uncim', 4),
	('1203302003', '120330', 'Panindoan', 4),
	('1203302004', '120330', 'Aek Kahombu', 4),
	('1203302005', '120330', 'Batu Horpak', 4),
	('1203302006', '120330', 'Situmba', 4),
	('1203302007', '120330', 'Purba Tua', 4),
	('1203302008', '120330', 'Lumban Jabi Jabi', 4),
	('1203302009', '120330', 'Ingul Jae', 4),
	('1203302010', '120330', 'Sisoma', 4),
	('1203302011', '120330', 'Lumban Ratus', 4),
	('1203302012', '120330', 'Kota Tua', 4),
	('1203302013', '120330', 'Simaninggir TT', 4),
	('1203302014', '120330', 'Hutaraja', 4),
	('1203302015', '120330', 'Harean', 4),
	('1203302016', '120330', 'Aek Parupuk', 4),
	('1203302017', '120330', 'Tanjung Medan', 4),
	('1203311001', '120331', 'Sangkunur', 3),
	('1203311002', '120331', 'Rianiate', 3),
	('1203312003', '120331', 'Simatohir', 4),
	('1203312004', '120331', 'Perkebunan', 4),
	('1203312005', '120331', 'Bandar Tarutung', 4),
	('1203312006', '120331', 'Aek Pardomuan', 4),
	('1203312007', '120331', 'Tindoan Laut', 4),
	('1203312008', '120331', 'Simataniari', 4),
	('1203312009', '120331', 'Batu Godang', 4),
	('1203312010', '120331', 'Malombu', 4),
	('1204052001', '120405', 'Ononamolo I Bot', 4),
	('1204052021', '120405', 'Dima', 4),
	('1204052022', '120405', 'Sinarikhi', 4),
	('1204052023', '120405', 'Ombolalasalo\'o', 4),
	('1204052024', '120405', 'Sisobalauru', 4),
	('1204052025', '120405', 'Tuhegafoa II', 4),
	('1204052027', '120405', 'Fadoro Lauru', 4),
	('1204052028', '120405', 'Lasara Tanose\'o', 4),
	('1204052030', '120405', 'Hiliduho', 4),
	('1204052031', '120405', 'Hiligodu Tanoseo', 4),
	('1204052032', '120405', 'Sisobahili I Tanoseo', 4),
	('1204052033', '120405', 'Onozitolidulu', 4),
	('1204052034', '120405', 'Mazingo Tanose\'o', 4),
	('1204052040', '120405', 'Onowaembo Hiligara', 4),
	('1204052041', '120405', 'Silimabanua', 4),
	('1204052042', '120405', 'Ombolata Sisarahili', 4),
	('1204062006', '120406', 'Hiliotalua', 4),
	('1204062008', '120406', 'Akhelauwe', 4),
	('1204062016', '120406', 'Hilisebua', 4),
	('1204062017', '120406', 'Somi', 4),
	('1204062018', '120406', 'Sirete', 4),
	('1204062019', '120406', 'Heliweto Gido', 4),
	('1204062020', '120406', 'Loloana\'a Gido', 4),
	('1204062022', '120406', 'Sisobahili', 4),
	('1204062023', '120406', 'Lahemo', 4),
	('1204062024', '120406', 'Ladea', 4),
	('1204062027', '120406', 'Umbu', 4),
	('1204062028', '120406', 'Soewe', 4),
	('1204062029', '120406', 'Lolozasai', 4),
	('1204062030', '120406', 'Lazara Idanoi', 4),
	('1204062050', '120406', 'Lasela', 4),
	('1204062051', '120406', 'Ladea Orahua', 4),
	('1204062052', '120406', 'Tulumbaho Salo\'o', 4),
	('1204062053', '120406', 'Nifolo\'o Lauru', 4),
	('1204062054', '120406', 'Hilizoi', 4),
	('1204062055', '120406', 'Somi Botogo\'o', 4),
	('1204062056', '120406', 'Olindrawa Sisarahili', 4),
	('1204102005', '120410', 'Hilimoasio', 4),
	('1204102006', '120410', 'Tetegeona\'ai', 4),
	('1204102007', '120410', 'Laowo Hilimbaruzo', 4),
	('1204102008', '120410', 'Hililawae', 4),
	('1204102009', '120410', 'Tuhewaebu', 4),
	('1204102014', '120410', 'Sisobahili Iraono Hura', 4),
	('1204102015', '120410', 'Bozihona', 4),
	('1204102016', '120410', 'Oladano', 4),
	('1204102017', '120410', 'Ahedano', 4),
	('1204102018', '120410', 'Hilina\'a Tafuo', 4),
	('1204102019', '120410', 'Hiliono Zega', 4),
	('1204102020', '120410', 'Mondrali', 4),
	('1204102022', '120410', 'Tetehosi', 4),
	('1204102023', '120410', 'Saiwahili Hili\'adulo', 4),
	('1204102024', '120410', 'Maliwa\'a', 4),
	('1204102025', '120410', 'Biouti', 4),
	('1204102026', '120410', 'Awoni Lauso', 4),
	('1204102027', '120410', 'Bobozioli Loloana\'a', 4),
	('1204102028', '120410', 'Sandruta', 4),
	('1204102029', '120410', 'Laira', 4),
	('1204102030', '120410', 'Otalua', 4),
	('1204102031', '120410', 'Baruzo', 4),
	('1204102032', '120410', 'Orahili Zuzundrao', 4),
	('1204102033', '120410', 'Tiga Serangkai Maliwa\'a', 4),
	('1204102034', '120410', 'Hiligogowaya Maliwa\'a', 4),
	('1204102035', '120410', 'Hili\'adulo', 4),
	('1204102036', '120410', 'Hilimoasio Dua', 4),
	('1204102037', '120410', 'Biouti Timur', 4),
	('1204112002', '120411', 'Sisarahili Bawolato', 4),
	('1204112003', '120411', 'Hiliganoita', 4),
	('1204112004', '120411', 'Gazamanu', 4),
	('1204112005', '120411', 'Hilihoru', 4),
	('1204112006', '120411', 'Hilialawa', 4),
	('1204112007', '120411', 'Hilifaosi', 4),
	('1204112008', '120411', 'Hiliwarokha', 4),
	('1204112009', '120411', 'Sitolu Banua', 4),
	('1204112010', '120411', 'Siofaewali', 4),
	('1204112011', '120411', 'Sohoya', 4),
	('1204112012', '120411', 'Botohaenga', 4),
	('1204112013', '120411', 'Orahili', 4),
	('1204112014', '120411', 'Tagaule', 4),
	('1204112015', '120411', 'Siofabanua', 4),
	('1204112016', '120411', 'Sifaoroasi Ulu Hou', 4),
	('1204112017', '120411', 'Dahana', 4),
	('1204112018', '120411', 'Orahua', 4),
	('1204112019', '120411', 'Banua Sibohou Silima Ewali', 4),
	('1204112020', '120411', 'Si\'ofaewali Selatan', 4),
	('1204112021', '120411', 'Lagasimahe', 4),
	('1204112022', '120411', 'Hilihao Cugala', 4),
	('1204112023', '120411', 'Orahua Faondrato', 4),
	('1204112024', '120411', 'Hou', 4),
	('1204112025', '120411', 'Sindrondro', 4),
	('1204112026', '120411', 'Balale Toba\'a', 4),
	('1204202001', '120420', 'Fadoro Hunogoa', 4),
	('1204202002', '120420', 'Lolofaoso Lalai', 4),
	('1204202003', '120420', 'Fulolo Lalai', 4),
	('1204202004', '120420', 'Lawa-Lawa', 4),
	('1204202005', '120420', 'Lalai I/II', 4),
	('1204202006', '120420', 'Lolowua', 4),
	('1204202007', '120420', 'Dahadano Botombawo', 4),
	('1204202008', '120420', 'Fadoro Lalai', 4),
	('1204202009', '120420', 'Lolowua Hiliwarasi', 4),
	('1204202010', '120420', 'Hilizia Lauru', 4),
	('1204202011', '120420', 'Ehosakhozi', 4),
	('1204202012', '120420', 'Awela', 4),
	('1204202013', '120420', 'Onombongi', 4),
	('1204202014', '120420', 'Orahili Idanoi', 4),
	('1204202015', '120420', 'Lolofaoso', 4),
	('1204212001', '120421', 'Hiligodu Botomuzoi', 4),
	('1204212002', '120421', 'Lasara Botomuzoi', 4),
	('1204212003', '120421', 'Hiliwaele I', 4),
	('1204212004', '120421', 'Hilimbowo Botomuzoi', 4),
	('1204212005', '120421', 'Simanaere Botomuzoi', 4),
	('1204212006', '120421', 'Hiliwaele II', 4),
	('1204212007', '120421', 'Tuhegafoa I', 4),
	('1204212008', '120421', 'Balohili Botomuzoi', 4),
	('1204212009', '120421', 'Hilihambawa Botomuzoi', 4),
	('1204212010', '120421', 'Fulolo Botomuzoi', 4),
	('1204212011', '120421', 'Loloana\'a', 4),
	('1204212012', '120421', 'Ononamolo Talafu', 4),
	('1204212013', '120421', 'Sisobahili Dola', 4),
	('1204212014', '120421', 'Banua Sibohou Botomuzoi', 4),
	('1204212015', '120421', 'Mohili Berua Botomuzoi', 4),
	('1204212016', '120421', 'Tetehosi Botomuzoi', 4),
	('1204212017', '120421', 'Talafu', 4),
	('1204212018', '120421', 'Ola Nori', 4),
	('1204272001', '120427', 'Orahili', 4),
	('1204272002', '120427', 'Hiliwetogela', 4),
	('1204272003', '120427', 'Lawalawa Luo', 4),
	('1204272004', '120427', 'Hilimbowo', 4),
	('1204272005', '120427', 'Hilibadalu', 4),
	('1204272006', '120427', 'Fatodano', 4),
	('1204272007', '120427', 'Fahandrona', 4),
	('1204272008', '120427', 'Onodalinga', 4),
	('1204272009', '120427', 'Holi', 4),
	('1204272010', '120427', 'Sisobahili Ulu Gawo', 4),
	('1204272011', '120427', 'Sifaro\'asi Ulu Gawo', 4),
	('1204272012', '120427', 'Mohili', 4),
	('1204272013', '120427', 'Hiligafoa', 4),
	('1204272014', '120427', 'Sisarahili Soroma\'asi', 4),
	('1204282001', '120428', 'Balodano', 4),
	('1204282002', '120428', 'Lewu Oguru II', 4),
	('1204282003', '120428', 'Sihare\'o III', 4),
	('1204282004', '120428', 'Sisarahilima\'u', 4),
	('1204282005', '120428', 'Lasara Siwalu Banua', 4),
	('1204282006', '120428', 'Tuhemberua', 4),
	('1204282007', '120428', 'Atualuo', 4),
	('1204282008', '120428', 'Lewa Lewa', 4),
	('1204282009', '120428', 'Dekha', 4),
	('1204282010', '120428', 'Sihare\'o III Bawosalo\'o Berua', 4),
	('1204282011', '120428', 'Sihare\'o III Hilibadalu', 4),
	('1204292001', '120429', 'Sisobawino I', 4),
	('1204292002', '120429', 'I\'odano', 4),
	('1204292003', '120429', 'Huno', 4),
	('1204292004', '120429', 'Sisaratandrawa', 4),
	('1204292005', '120429', 'Somolo Molo', 4),
	('1204292006', '120429', 'Lewu Oguru I', 4),
	('1204292007', '120429', 'Sifaoro Asi', 4),
	('1204292008', '120429', 'Lewuombanua', 4),
	('1204292009', '120429', 'Hiligodu Somolo-Molo', 4),
	('1204292010', '120429', 'Hiliborodano', 4),
	('1204292011', '120429', 'So\'ewali', 4),
	('1204352001', '120435', 'Tuhembuasi', 4),
	('1204352002', '120435', 'Hilibadalu', 4),
	('1204352003', '120435', 'La\'uri', 4),
	('1204352004', '120435', 'Hilimbana', 4),
	('1204352005', '120435', 'Saitagaramba', 4),
	('1204352006', '120435', 'Sogae\'adu', 4),
	('1204352007', '120435', 'Baruzo', 4),
	('1204352008', '120435', 'Tulumbaho', 4),
	('1204352009', '120435', 'Sisarahili Sogae\'adu', 4),
	('1204352010', '120435', 'We\'a-we\'a', 4),
	('1204352011', '120435', 'Sihare\'o Sogae\'adu', 4),
	('1205011001', '120501', 'Pekan Bahorok', 3),
	('1205012002', '120501', 'Lau Damak', 4),
	('1205012003', '120501', 'Timbang Lawan', 4),
	('1205012004', '120501', 'Samperaya', 4),
	('1205012005', '120501', 'Tanjung Lenggang', 4),
	('1205012006', '120501', 'Suka Rakyat', 4),
	('1205012007', '120501', 'Perkebunan Turangi', 4),
	('1205012008', '120501', 'Perkebunan Bungara', 4),
	('1205012009', '120501', 'Perkebunan B. Lawang', 4),
	('1205012011', '120501', 'Empus', 4),
	('1205012012', '120501', 'Simpang Pulau Rambung', 4),
	('1205012013', '120501', 'Perkebunan S Musam', 4),
	('1205012014', '120501', 'Batu Jonjong', 4),
	('1205012015', '120501', 'Sematar', 4),
	('1205012016', '120501', 'Perkebunan P Rambung', 4),
	('1205012017', '120501', 'Sei Musam Kendit', 4),
	('1205012020', '120501', 'Timbang Jaya', 4),
	('1205012021', '120501', 'Sei Musam Pembangunan', 4),
	('1205012022', '120501', 'Ujung Bandar', 4),
	('1205021007', '120502', 'Tanjung Langkat', 3),
	('1205022002', '120502', 'Perk. Tj. Keliling', 4),
	('1205022004', '120502', 'Perk.Gelugur Langkat', 4),
	('1205022005', '120502', 'Perk.Tambunan', 4),
	('1205022006', '120502', 'Perk.Bandar Telu', 4),
	('1205022008', '120502', 'Naman Jahe', 4),
	('1205022009', '120502', 'Turangi', 4),
	('1205022010', '120502', 'Ujung Teran', 4),
	('1205022011', '120502', 'Pama Tambunan', 4),
	('1205022014', '120502', 'Minta Kasih', 4),
	('1205022019', '120502', 'Ujung Bandar', 4),
	('1205022020', '120502', 'Lau Tepu', 4),
	('1205022021', '120502', 'Parangguam', 4),
	('1205022023', '120502', 'Panco Warno', 4),
	('1205022024', '120502', 'Adin Tengah', 4),
	('1205022025', '120502', 'Lau Lugur', 4),
	('1205022026', '120502', 'Pancur Ido', 4),
	('1205031001', '120503', 'Pekan Kuala', 3),
	('1205031019', '120503', 'Bela Rakyat', 3),
	('1205032002', '120503', 'Dalan Naman', 4),
	('1205032003', '120503', 'Balai Kasih', 4),
	('1205032004', '120503', 'Bekiung', 4),
	('1205032005', '120503', 'Belangkahan', 4),
	('1205032006', '120503', 'Besadi', 4),
	('1205032007', '120503', 'Beruam', 4),
	('1205032009', '120503', 'Raja Tengah', 4),
	('1205032011', '120503', 'Namo Mbelin', 4),
	('1205032012', '120503', 'Parit Rindu', 4),
	('1205032013', '120503', 'Sei Penjara', 4),
	('1205032015', '120503', 'Perkebunan Bekiun', 4),
	('1205032016', '120503', 'Garunggang', 4),
	('1205032017', '120503', 'Suka Damai', 4),
	('1205032018', '120503', 'Sido Makmur', 4),
	('1205041005', '120504', 'Namu Ukur Selatan', 3),
	('1205042001', '120504', 'Telaga', 4),
	('1205042002', '120504', 'Rumah Galuh', 4),
	('1205042003', '120504', 'Simpang Kuta Buluh', 4),
	('1205042004', '120504', 'Gunung Ambat', 4),
	('1205042006', '120504', 'Belinten', 4),
	('1205042007', '120504', 'Namu Ukur Utara', 4),
	('1205042008', '120504', 'Pasar VI.KW.Mencirim', 4),
	('1205042009', '120504', 'EMP. KW. Mencirim', 4),
	('1205042010', '120504', 'Pursobinangun', 4),
	('1205042011', '120504', 'Pasar IV.Namo Terasi', 4),
	('1205042012', '120504', 'Pasar VIII.Namo Terasi', 4),
	('1205042013', '120504', 'Durian Lingga', 4),
	('1205042014', '120504', 'Pekan Sawah', 4),
	('1205042015', '120504', 'Tanjung Gunung', 4),
	('1205042016', '120504', 'Mekar Jaya', 4),
	('1205051001', '120505', 'Kwala Begumit', 3),
	('1205052002', '120505', 'Sambi Rejo', 4),
	('1205052003', '120505', 'Sendang Rejo', 4),
	('1205052004', '120505', 'Tanjung Jati', 4),
	('1205052005', '120505', 'Sidomulyo', 4),
	('1205052006', '120505', 'Perdamaian', 4),
	('1205052007', '120505', 'Suka Makmur', 4),
	('1205061001', '120506', 'Pekan Selesai', 3),
	('1205062002', '120506', 'Sei Limbat', 4),
	('1205062003', '120506', 'Padang Brahrang', 4),
	('1205062004', '120506', 'Tanjung Merahe', 4),
	('1205062005', '120506', 'Nambiki', 4),
	('1205062006', '120506', 'Laumulgab', 4),
	('1205062007', '120506', 'Kutaparit', 4),
	('1205062008', '120506', 'Bekulap', 4),
	('1205062009', '120506', 'Perhiasan', 4),
	('1205062010', '120506', 'Selayang', 4),
	('1205062011', '120506', 'Mancang', 4),
	('1205062012', '120506', 'Kwala Air Hitam', 4),
	('1205062013', '120506', 'Padang Cermin', 4),
	('1205062014', '120506', 'Selayang Baru', 4),
	('1205071004', '120507', 'Perdamaian', 3),
	('1205071005', '120507', 'Kwala Bingai', 3),
	('1205071006', '120507', 'Sidomulyo', 3),
	('1205071010', '120507', 'Stabat Baru', 3),
	('1205071011', '120507', 'Dendang', 3),
	('1205071012', '120507', 'Paya Mabar', 3),
	('1205072001', '120507', 'Karang Rejo', 4),
	('1205072002', '120507', 'Kwala Begumit', 4),
	('1205072003', '120507', 'Mangga', 4),
	('1205072007', '120507', 'Banyumas', 4),
	('1205072008', '120507', 'Pantai Gemi', 4),
	('1205072009', '120507', 'Ara Condong', 4),
	('1205081001', '120508', 'Bingai', 3),
	('1205082002', '120508', 'Gohor Lama', 4),
	('1205082003', '120508', 'Stabat Lama', 4),
	('1205082004', '120508', 'Besilam Bukit Lambasa', 4),
	('1205082005', '120508', 'Kebun Balok', 4),
	('1205082006', '120508', 'Bukit Melintang', 4),
	('1205082007', '120508', 'Gergas', 4),
	('1205082008', '120508', 'Stabat Lama Barat', 4),
	('1205082009', '120508', 'Sumber Mulyo', 4),
	('1205082010', '120508', 'Pertumbukan', 4),
	('1205082011', '120508', 'Paya Tusam', 4),
	('1205082012', '120508', 'Mekar Jaya', 4),
	('1205082013', '120508', 'Jentera Stabat', 4),
	('1205082014', '120508', 'Stungkit', 4),
	('1205091004', '120509', 'Hinai Kiri', 3),
	('1205092001', '120509', 'Kepala Sungai', 4),
	('1205092002', '120509', 'Teluk', 4),
	('1205092003', '120509', 'Cinta Raja', 4),
	('1205092005', '120509', 'Kebun Kelapa', 4),
	('1205092006', '120509', 'Sungai Ular', 4),
	('1205092007', '120509', 'Tanjung Ibus', 4),
	('1205092008', '120509', 'Secanggang', 4),
	('1205092009', '120509', 'Selotong', 4),
	('1205092010', '120509', 'Karang Gading', 4),
	('1205092011', '120509', 'Jaring Halus', 4),
	('1205092012', '120509', 'Telaga Jernih', 4),
	('1205092013', '120509', 'Perkotaan', 4),
	('1205092014', '120509', 'Kwala Besar', 4),
	('1205092015', '120509', 'Karang Anyar', 4),
	('1205092016', '120509', 'Pantai Gading', 4),
	('1205092017', '120509', 'Suka Mulia', 4),
	('1205101008', '120510', 'Kebun Lada', 3),
	('1205102001', '120510', 'Cempa', 4),
	('1205102002', '120510', 'Batu Malenggang', 4),
	('1205102003', '120510', 'Tamaran', 4),
	('1205102004', '120510', 'Tanjung Mulya', 4),
	('1205102005', '120510', 'Muka Paya', 4),
	('1205102006', '120510', 'Hinai Kanan', 4),
	('1205102007', '120510', 'Suka Damai', 4),
	('1205102009', '120510', 'Baru Psr.VIII', 4),
	('1205102010', '120510', 'Perkebunan Tj.Beringin', 4),
	('1205102011', '120510', 'Suka Jadi', 4),
	('1205102012', '120510', 'Paya Rengas', 4),
	('1205102013', '120510', 'Suka Damai Timur', 4),
	('1205111005', '120511', 'Pekan Tj. Pura', 3),
	('1205112001', '120511', 'Serapuh Asli', 4),
	('1205112002', '120511', 'Pematang Tengah', 4),
	('1205112003', '120511', 'Paya Perupuk', 4),
	('1205112004', '120511', 'Lalang', 4),
	('1205112006', '120511', 'Pekubuan', 4),
	('1205112007', '120511', 'Teluk Bakung', 4),
	('1205112008', '120511', 'Pantai Cermin', 4),
	('1205112009', '120511', 'Pematang Serai', 4),
	('1205112010', '120511', 'Baja Kuning', 4),
	('1205112011', '120511', 'Pulau Banyak', 4),
	('1205112012', '120511', 'Pematang Cengal', 4),
	('1205112013', '120511', 'Kwala Serapuh', 4),
	('1205112014', '120511', 'Kwala Langkat', 4),
	('1205112015', '120511', 'Bubun', 4),
	('1205112016', '120511', 'Tapak Kuda', 4),
	('1205112017', '120511', 'Suka Maju', 4),
	('1205112018', '120511', 'Karya Maju', 4),
	('1205112019', '120511', 'Pematang Cengal Barat', 4),
	('1205121006', '120512', 'Tanjung Selamat', 3),
	('1205122001', '120512', 'Serapuh ABC', 4),
	('1205122002', '120512', 'Padang Tualang', 4),
	('1205122003', '120512', 'Kwala Besilam', 4),
	('1205122004', '120512', 'Bulu Telang', 4),
	('1205122005', '120512', 'Besilam', 4),
	('1205122007', '120512', 'Tebing Tanjung Selamat', 4),
	('1205122008', '120512', 'Tanjung Putus', 4),
	('1205122009', '120512', 'Suka Ramai', 4),
	('1205122010', '120512', 'Jati Sari', 4),
	('1205122011', '120512', 'Banjar Jaya', 4),
	('1205122012', '120512', 'Bukit Sari', 4),
	('1205131001', '120513', 'Pekan Gebang', 3),
	('1205132002', '120513', 'Paluh Manis', 4),
	('1205132003', '120513', 'Pasar Rawa', 4),
	('1205132004', '120513', 'Padang Langkat', 4),
	('1205132005', '120513', 'Air Hitam', 4),
	('1205132006', '120513', 'Paya Bengkuang', 4),
	('1205132007', '120513', 'Dogang', 4),
	('1205132008', '120513', 'Sangka Lima', 4),
	('1205132009', '120513', 'Kwala Gebang', 4),
	('1205132010', '120513', 'Bukit Mengkiri', 4),
	('1205132011', '120513', 'Pasiran', 4),
	('1205141001', '120514', 'Pelawi Utara', 3),
	('1205141006', '120514', 'Brandan Barat', 3),
	('1205141007', '120514', 'Brandan Timur Baru', 3),
	('1205141008', '120514', 'Brandan Timur', 3),
	('1205142002', '120514', 'Securai Utara', 4),
	('1205142003', '120514', 'Teluk Meku', 4),
	('1205142004', '120514', 'Pelawi Selatan', 4),
	('1205142005', '120514', 'Securai Selatan', 4),
	('1205151009', '120515', 'Beras Basah', 3),
	('1205151010', '120515', 'Bukit Jengkol', 3),
	('1205152001', '120515', 'Alur Cempedak', 4),
	('1205152002', '120515', 'Sei Siur', 4),
	('1205152003', '120515', 'Tanjung Pasar', 4),
	('1205152004', '120515', 'Paya Kampak', 4),
	('1205152005', '120515', 'Pintu Air', 4),
	('1205152006', '120515', 'Sei Meran', 4),
	('1205152007', '120515', 'Pulau Sembilan', 4),
	('1205152008', '120515', 'Pulau Kampai', 4),
	('1205152011', '120515', 'Pangkalan Siata', 4),
	('1205161009', '120516', 'Pekan Besitang', 3),
	('1205161010', '120516', 'Bukit Kubu', 3),
	('1205161011', '120516', 'Kampung Lama', 3),
	('1205162001', '120516', 'Halaban', 4),
	('1205162002', '120516', 'Bukit Mas', 4),
	('1205162005', '120516', 'Pir ABD Besitang', 4),
	('1205162006', '120516', 'Sekoci', 4),
	('1205162007', '120516', 'Suka Jaya', 4),
	('1205162008', '120516', 'Bukit Selamat', 4),
	('1205171001', '120517', 'Sei Bilah', 3),
	('1205171002', '120517', 'Alur Dua', 3),
	('1205171008', '120517', 'Alur Dua Baru', 3),
	('1205171009', '120517', 'Harapan Jaya', 3),
	('1205171010', '120517', 'Sei Bilah Timur', 3),
	('1205172003', '120517', 'Puraka I', 4),
	('1205172004', '120517', 'Puraka II', 4),
	('1205172005', '120517', 'Lama', 4),
	('1205172006', '120517', 'Telaga Said', 4),
	('1205172007', '120517', 'Lama Baru', 4),
	('1205172011', '120517', 'Mekar Makmur', 4),
	('1205172012', '120517', 'Harapan Baru', 4),
	('1205172013', '120517', 'Harapan Maju', 4),
	('1205172014', '120517', 'Harapan Makmur', 4),
	('1205181001', '120518', 'Tangkahan Durian', 3),
	('1205181004', '120518', 'Pangkalan Batu', 3),
	('1205182002', '120518', 'Sei Tualang', 4),
	('1205182003', '120518', 'Lubuk Kasih', 4),
	('1205182005', '120518', 'Lubuk Kertang', 4),
	('1205182006', '120518', 'Perlis', 4),
	('1205182007', '120518', 'Kelantan', 4),
	('1205191001', '120519', 'Batang Serangan', 3),
	('1205192002', '120519', 'Sei Bamban', 4),
	('1205192003', '120519', 'Sei Musam', 4),
	('1205192004', '120519', 'Sei Serdang', 4),
	('1205192005', '120519', 'Namo Sialang', 4),
	('1205192006', '120519', 'Kwala Musam', 4),
	('1205192007', '120519', 'Karya Jadi', 4),
	('1205192008', '120519', 'Palu Pakih Babussalam', 4),
	('1205201001', '120520', 'Sawit Seberang', 3),
	('1205202002', '120520', 'Alung Gadung', 4),
	('1205202003', '120520', 'Simpang Tiga', 4),
	('1205202004', '120520', 'Sei Litur Tasik', 4),
	('1205202005', '120520', 'Sawit Hulu', 4),
	('1205202006', '120520', 'Mekar Sawit', 4),
	('1205202007', '120520', 'Alur Melati', 4),
	('1205212001', '120521', 'Serapit', 4),
	('1205212002', '120521', 'Gunung Tinggi', 4),
	('1205212003', '120521', 'Sidorejo', 4),
	('1205212004', '120521', 'Suka Pulung', 4),
	('1205212005', '120521', 'Aman Damai', 4),
	('1205212006', '120521', 'Tanjung Kariahan', 4),
	('1205212007', '120521', 'Sebertung', 4),
	('1205212008', '120521', 'Pulau Semikat', 4),
	('1205212009', '120521', 'Sumber Jaya', 4),
	('1205212010', '120521', 'Perkebunan Amal Tani', 4),
	('1205222001', '120522', 'Namotogan', 4),
	('1205222002', '120522', 'Kuta Gajah', 4),
	('1205222003', '120522', 'Perk. Marike', 4),
	('1205222004', '120522', 'Kaperas', 4),
	('1205222005', '120522', 'Namoteras', 4),
	('1205222006', '120522', 'Rampah', 4),
	('1205222007', '120522', 'Sulkam', 4),
	('1205222008', '120522', 'Kutambaru', 4),
	('1205232001', '120523', 'Pematang Tengah', 4),
	('1205232002', '120523', 'Damar Condong', 4),
	('1205232003', '120523', 'Perk.Damar Condong', 4),
	('1205232004', '120523', 'Perk. Perapen', 4),
	('1205232005', '120523', 'Limau Mungkur', 4),
	('1205232006', '120523', 'Serang Jaya Hilir', 4),
	('1205232007', '120523', 'Serang Jaya', 4),
	('1205232008', '120523', 'Sala Haji', 4),
	('1206011009', '120601', 'Padang Mas', 3),
	('1206011010', '120601', 'Lau Cimba', 3),
	('1206011011', '120601', 'Gung Leto', 3),
	('1206011012', '120601', 'Gung Negeri', 3),
	('1206011013', '120601', 'Kampung Dalam', 3),
	('1206012001', '120601', 'Rumah Kabanjahe', 4),
	('1206012002', '120601', 'Kaban', 4),
	('1206012003', '120601', 'Ketaren', 4),
	('1206012004', '120601', 'Samura', 4),
	('1206012005', '120601', 'Lau Simomo', 4),
	('1206012006', '120601', 'Sumber Mufakat', 4),
	('1206012007', '120601', 'Kandibata', 4),
	('1206012008', '120601', 'Kacaribu', 4),
	('1206021006', '120602', 'Tambak Lau Mulgap I', 3),
	('1206021007', '120602', 'Tambak Lau Mulgap II', 3),
	('1206021008', '120602', 'Gundaling I', 3),
	('1206021009', '120602', 'Gundaling II', 3),
	('1206022001', '120602', 'Doulu', 4),
	('1206022002', '120602', 'Gurusinga', 4),
	('1206022003', '120602', 'R a y a', 4),
	('1206022004', '120602', 'Rumah Berastagi', 4),
	('1206022005', '120602', 'Sempa Jaya', 4),
	('1206022010', '120602', 'Lau Gumba', 4),
	('1206032001', '120603', 'Paribun', 4),
	('1206032002', '120603', 'Rumamis', 4),
	('1206032003', '120603', 'Sinaman', 4),
	('1206032004', '120603', 'Sukanalu', 4),
	('1206032005', '120603', 'Barusjulu', 4),
	('1206032006', '120603', 'Tangkidik', 4),
	('1206032007', '120603', 'Sukajulu', 4),
	('1206032008', '120603', 'Barusjahe', 4),
	('1206032009', '120603', 'Bulanjahe', 4),
	('1206032010', '120603', 'Pertumbuken', 4),
	('1206032011', '120603', 'Talimbaru', 4),
	('1206032012', '120603', 'Sikap', 4),
	('1206032013', '120603', 'Persadanta', 4),
	('1206032014', '120603', 'Bulanjulu', 4),
	('1206032015', '120603', 'Semangat', 4),
	('1206032016', '120603', 'Serdang', 4),
	('1206032017', '120603', 'Tanjung Barus', 4),
	('1206032018', '120603', 'Sarimanis', 4),
	('1206032019', '120603', 'Penampen', 4),
	('1206042001', '120604', 'Kutakepar', 4),
	('1206042002', '120604', 'Ajijulu', 4),
	('1206042004', '120604', 'Singa', 4),
	('1206042007', '120604', 'Ajijahe', 4),
	('1206042008', '120604', 'Bunuraya', 4),
	('1206042010', '120604', 'Kubusimbelang', 4),
	('1206042011', '120604', 'Tigapanah', 4),
	('1206042012', '120604', 'Suka', 4),
	('1206042014', '120604', 'Kacinambun', 4),
	('1206042015', '120604', 'Kutajulu', 4),
	('1206042016', '120604', 'Bertah', 4),
	('1206042017', '120604', 'Manukmulia', 4),
	('1206042018', '120604', 'Lau Riman', 4),
	('1206042019', '120604', 'Sukadame', 4),
	('1206042020', '120604', 'Mulawari', 4),
	('1206042023', '120604', 'Sukamaju', 4),
	('1206042024', '120604', 'Kutambelin', 4),
	('1206042025', '120604', 'Kutabale', 4),
	('1206042026', '120604', 'Lepar Samura', 4),
	('1206042027', '120604', 'Seberaya', 4),
	('1206042028', '120604', 'Ajimbelang', 4),
	('1206042029', '120604', 'Aji Buhara', 4),
	('1206042030', '120604', 'Lambar', 4),
	('1206042031', '120604', 'Salit', 4),
	('1206042032', '120604', 'Suka Mbayak', 4),
	('1206042033', '120604', 'Sukapilihen', 4),
	('1206052001', '120605', 'Pertibi Tembe', 4),
	('1206052002', '120605', 'Negeri Tongging', 4),
	('1206052003', '120605', 'Kodon-kodon', 4),
	('1206052004', '120605', 'Dokan', 4),
	('1206052005', '120605', 'Nagara', 4),
	('1206052006', '120605', 'Sibolangit', 4),
	('1206052007', '120605', 'Sukamandi', 4),
	('1206052008', '120605', 'Nagalingga', 4),
	('1206052009', '120605', 'Pengambaten', 4),
	('1206052010', '120605', 'Tongging', 4),
	('1206052011', '120605', 'Pertibi Lama', 4),
	('1206052012', '120605', 'Regaji', 4),
	('1206052013', '120605', 'Ajinembah', 4),
	('1206052014', '120605', 'Situnggaling', 4),
	('1206052015', '120605', 'Garingging', 4),
	('1206052016', '120605', 'Mulia Rayat', 4),
	('1206052017', '120605', 'Bandar Tongging', 4),
	('1206052018', '120605', 'Pancur Batu', 4),
	('1206052019', '120605', 'Merek', 4),
	('1206062001', '120606', 'Nageri', 4),
	('1206062002', '120606', 'Munte', 4),
	('1206062003', '120606', 'Kineppen', 4),
	('1206062004', '120606', 'Bandar Meriah', 4),
	('1206062005', '120606', 'Barung Kersap', 4),
	('1206062006', '120606', 'Kutambaru', 4),
	('1206062007', '120606', 'Buluh Naman', 4),
	('1206062008', '120606', 'Singgamanik', 4),
	('1206062009', '120606', 'Kuta Gerat', 4),
	('1206062010', '120606', 'Pertumbuken', 4),
	('1206062011', '120606', 'Sarimunte', 4),
	('1206062012', '120606', 'Kabantua', 4),
	('1206062013', '120606', 'Gunung Manumpak', 4),
	('1206062014', '120606', 'Tanjung Beringin', 4),
	('1206062015', '120606', 'Kutasuah', 4),
	('1206062016', '120606', 'Sarinembah', 4),
	('1206062017', '120606', 'Selakkar', 4),
	('1206062018', '120606', 'Parimbalang', 4),
	('1206062019', '120606', 'Gunung Saribu', 4),
	('1206062020', '120606', 'Sukaramai', 4),
	('1206062021', '120606', 'Gurubenua', 4),
	('1206062022', '120606', 'Biaknampe', 4),
	('1206072001', '120607', 'Juhar Perangin-angin', 4),
	('1206072002', '120607', 'Lau Lingga', 4),
	('1206072003', '120607', 'Kidupen', 4),
	('1206072004', '120607', 'Namosuro', 4),
	('1206072005', '120607', 'Bekilang', 4),
	('1206072006', '120607', 'Sugihen', 4),
	('1206072007', '120607', 'Pernantin', 4),
	('1206072008', '120607', 'Nageri', 4),
	('1206072009', '120607', 'Juhar Ginting', 4),
	('1206072010', '120607', 'Juhar Tarigan', 4),
	('1206072011', '120607', 'Pasar Baru', 4),
	('1206072012', '120607', 'Batu Mamak', 4),
	('1206072013', '120607', 'Naga', 4),
	('1206072014', '120607', 'Kutambelin', 4),
	('1206072015', '120607', 'Mbetong', 4),
	('1206072016', '120607', 'Keriahen', 4),
	('1206072017', '120607', 'Gunung Juhar', 4),
	('1206072018', '120607', 'Ketawaren', 4),
	('1206072019', '120607', 'Jandi', 4),
	('1206072020', '120607', 'Buluh Pancur', 4),
	('1206072021', '120607', 'Kutagugung', 4),
	('1206072022', '120607', 'Sukababo', 4),
	('1206072023', '120607', 'Lau Kidupen', 4),
	('1206072024', '120607', 'Sigenderang', 4),
	('1206072025', '120607', 'Juhar Ginting Sadanioga', 4),
	('1206081019', '120608', 'Tiga Binanga', 3),
	('1206082001', '120608', 'Gunung', 4),
	('1206082002', '120608', 'Kemkem', 4),
	('1206082003', '120608', 'Pertumbuken', 4),
	('1206082004', '120608', 'Kuala', 4),
	('1206082005', '120608', 'Limang', 4),
	('1206082006', '120608', 'Perbesi', 4),
	('1206082007', '120608', 'Lau Kapor', 4),
	('1206082008', '120608', 'Kutabangun', 4),
	('1206082009', '120608', 'Kuta Raja', 4),
	('1206082010', '120608', 'Pergendangen', 4),
	('1206082011', '120608', 'Simolap', 4),
	('1206082012', '120608', 'Simpang Pergendangen', 4),
	('1206082013', '120608', 'Kutagerat', 4),
	('1206082014', '120608', 'Sukajulu', 4),
	('1206082015', '120608', 'Kutagaluh', 4),
	('1206082016', '120608', 'Bunga Baru', 4),
	('1206082017', '120608', 'Kutambaru Punti', 4),
	('1206082018', '120608', 'Kuta Buara', 4),
	('1206082020', '120608', 'Batumanak', 4),
	('1206092001', '120609', 'Martelu', 4),
	('1206092002', '120609', 'Mbal-Mbal Petarum', 4),
	('1206092003', '120609', 'Lau Peranggunen', 4),
	('1206092004', '120609', 'Tanjung Gunung', 4),
	('1206092005', '120609', 'Lau Baleng', 4),
	('1206092006', '120609', 'Durin Rugun', 4),
	('1206092007', '120609', 'Perbulan', 4),
	('1206092008', '120609', 'Kutambelin', 4),
	('1206092009', '120609', 'Lingga Muda', 4),
	('1206092010', '120609', 'Kinangkong', 4),
	('1206092011', '120609', 'Rambah Tampu', 4),
	('1206092012', '120609', 'Lau Peradep', 4),
	('1206092013', '120609', 'Buluh Pancur', 4),
	('1206102001', '120610', 'Lau Pengulu', 4),
	('1206102002', '120610', 'Lau Mulgap', 4),
	('1206102003', '120610', 'Lau Kesumpat', 4),
	('1206102004', '120610', 'Rimo Bunga', 4),
	('1206102005', '120610', 'Tanjung Pamah', 4),
	('1206102006', '120610', 'Kuta Pengkih', 4),
	('1206102007', '120610', 'Bandar Purba', 4),
	('1206102008', '120610', 'Mardingding', 4),
	('1206102009', '120610', 'Lau Pakam', 4),
	('1206102010', '120610', 'Lau Solu', 4),
	('1206112001', '120611', 'Payung', 4),
	('1206112004', '120611', 'Rimo Kayu', 4),
	('1206112005', '120611', 'Suka Meriah', 4),
	('1206112007', '120611', 'Selandi', 4),
	('1206112012', '120611', 'Batukarang', 4),
	('1206112015', '120611', 'Guru Kinayan', 4),
	('1206112017', '120611', 'Cimbang', 4),
	('1206112025', '120611', 'Ujung Payung', 4),
	('1206122005', '120612', 'Kutatengah', 4),
	('1206122006', '120612', 'Tigapancur', 4),
	('1206122007', '120612', 'Pintubesi', 4),
	('1206122009', '120612', 'Gamber', 4),
	('1206122012', '120612', 'Sirumbia', 4),
	('1206122014', '120612', 'Ndokum Siroga', 4),
	('1206122016', '120612', 'Lingga Julu', 4),
	('1206122017', '120612', 'Gajah', 4),
	('1206122018', '120612', 'Lingga', 4),
	('1206122019', '120612', 'Nangbelawan', 4),
	('1206122022', '120612', 'Beganding', 4),
	('1206122024', '120612', 'Torong', 4),
	('1206122025', '120612', 'Berastepu', 4),
	('1206122026', '120612', 'Surbakti', 4),
	('1206122028', '120612', 'Jeraya', 4),
	('1206122030', '120612', 'Perteguhen', 4),
	('1206122035', '120612', 'Bulanbaru', 4),
	('1206132001', '120613', 'Negeri Jahe', 4),
	('1206132002', '120613', 'Kutabuluh Gugung', 4),
	('1206132003', '120613', 'Siabang-abang', 4),
	('1206132004', '120613', 'Lau Buluh', 4),
	('1206132005', '120613', 'Bintang Meriah', 4),
	('1206132006', '120613', 'Jinabun', 4),
	('1206132007', '120613', 'Kuta Male', 4),
	('1206132008', '120613', 'Ujung Deleng', 4),
	('1206132009', '120613', 'Gunung Meriah', 4),
	('1206132010', '120613', 'Buah Raya', 4),
	('1206132011', '120613', 'Tanjung Merahe', 4),
	('1206132012', '120613', 'Rih Tengah', 4),
	('1206132013', '120613', 'Kutabuluh', 4),
	('1206132014', '120613', 'Liang Merdeka', 4),
	('1206132015', '120613', 'Pola Tebu', 4),
	('1206132016', '120613', 'Amburidi', 4),
	('1206142001', '120614', 'Kubu Colia', 4),
	('1206142002', '120614', 'Ujung Sampun', 4),
	('1206142003', '120614', 'Bukit', 4),
	('1206142004', '120614', 'Melas', 4),
	('1206142005', '120614', 'Sampun', 4),
	('1206142006', '120614', 'Sugihen', 4),
	('1206142007', '120614', 'Dolat Rayat', 4),
	('1206152001', '120615', 'Cinta Rakyat', 4),
	('1206152002', '120615', 'Semangat', 4),
	('1206152003', '120615', 'Ujung Teran', 4),
	('1206152004', '120615', 'Gongsol', 4),
	('1206152005', '120615', 'Jaranguda', 4),
	('1206152006', '120615', 'Semangat Gunung', 4),
	('1206152007', '120615', 'Deram', 4),
	('1206152008', '120615', 'Merdeka', 4),
	('1206152009', '120615', 'Sadaperarih', 4),
	('1206162001', '120616', 'Simacem', 4),
	('1206162002', '120616', 'Kutagugung', 4),
	('1206162003', '120616', 'Kuta Tonggal', 4),
	('1206162004', '120616', 'Naman', 4),
	('1206162005', '120616', 'Sukanalu', 4),
	('1206162006', '120616', 'Kebayaken', 4),
	('1206162007', '120616', 'Kutarayat', 4),
	('1206162008', '120616', 'Bekerah', 4),
	('1206162009', '120616', 'Sukandebi', 4),
	('1206162010', '120616', 'Gung Pinto', 4),
	('1206162011', '120616', 'Kutambelin', 4),
	('1206162012', '120616', 'Ndeskati', 4),
	('1206162013', '120616', 'Sukatepu', 4),
	('1206162014', '120616', 'Sigarang-garang', 4),
	('1206172001', '120617', 'Sukatendel', 4),
	('1206172002', '120617', 'Mardingding', 4),
	('1206172003', '120617', 'Kutagaluh', 4),
	('1206172004', '120617', 'Kutambaru', 4),
	('1206172005', '120617', 'Jandimeriah', 4),
	('1206172006', '120617', 'Tiganderket', 4),
	('1206172007', '120617', 'Tanjung Pulo', 4),
	('1206172008', '120617', 'Tanjung Merawa', 4),
	('1206172009', '120617', 'Perbaji', 4),
	('1206172010', '120617', 'Temburun', 4),
	('1206172011', '120617', 'Kutakepar', 4),
	('1206172012', '120617', 'Penampen', 4),
	('1206172013', '120617', 'Tanjung Mbelang', 4),
	('1206172014', '120617', 'Narigunung I', 4),
	('1206172015', '120617', 'Narigunung II', 4),
	('1206172016', '120617', 'Gunung Merlawan', 4),
	('1206172017', '120617', 'Susuk', 4),
	('1207012001', '120701', 'Kuta Bayu', 4),
	('1207012002', '120701', 'Gunung Paribuan', 4),
	('1207012003', '120701', 'Simempar', 4),
	('1207012004', '120701', 'Gunung Seribu', 4),
	('1207012005', '120701', 'Gunung Sinembah', 4),
	('1207012006', '120701', 'Bintang Meriah', 4),
	('1207012007', '120701', 'Kuta Tengah', 4),
	('1207012008', '120701', 'Pekan Gunung Mariah', 4),
	('1207012009', '120701', 'Gunung Meriah', 4),
	('1207012010', '120701', 'Ujung Meriah', 4),
	('1207012011', '120701', 'Marjanji Pematang', 4),
	('1207012012', '120701', 'Marjanji Tongah', 4),
	('1207021026', '120702', 'Pekan Tg Morawa', 3),
	('1207022001', '120702', 'Medan Sinembah', 4),
	('1207022002', '120702', 'Ujung Serdang', 4),
	('1207022003', '120702', 'Limau Manis', 4),
	('1207022004', '120702', 'Bandar Labuhan', 4),
	('1207022005', '120702', 'Bangun Rejo', 4),
	('1207022006', '120702', 'Aek Pancur', 4),
	('1207022007', '120702', 'Sei Merah', 4),
	('1207022008', '120702', 'Naga Timbul', 4),
	('1207022009', '120702', 'Langau Sebrang', 4),
	('1207022010', '120702', 'Tanjung Mulia', 4),
	('1207022011', '120702', 'Punden Rejo', 4),
	('1207022012', '120702', 'Tanjung Morawa B', 4),
	('1207022013', '120702', 'Dagang Krawang', 4),
	('1207022014', '120702', 'Tanjung Morawa A', 4),
	('1207022015', '120702', 'Buntu Badimbar', 4),
	('1207022016', '120702', 'Bangun Sari', 4),
	('1207022017', '120702', 'Dagang Kelambir', 4),
	('1207022018', '120702', 'Dalu X A', 4),
	('1207022019', '120702', 'Dalu X B', 4),
	('1207022020', '120702', 'Wonosari', 4),
	('1207022021', '120702', 'Perdamean', 4),
	('1207022022', '120702', 'Menara', 4),
	('1207022023', '120702', 'Bangun Sari Baru', 4),
	('1207022024', '120702', 'Telaga Sari', 4),
	('1207022025', '120702', 'Tanjung Baru', 4),
	('1207032001', '120703', 'Bandar Baru', 4),
	('1207032002', '120703', 'Batulayang', 4),
	('1207032003', '120703', 'Batu Mbelin', 4),
	('1207032004', '120703', 'Betimus Mberu', 4),
	('1207032005', '120703', 'Bengkurung', 4),
	('1207032006', '120703', 'Bingkawan', 4),
	('1207032007', '120703', 'Buah Nabar', 4),
	('1207032008', '120703', 'Bukum', 4),
	('1207032009', '120703', 'Buluh Awar', 4),
	('1207032010', '120703', 'Cinta Rakyat', 4),
	('1207032011', '120703', 'Durin Serugun', 4),
	('1207032012', '120703', 'Ketangguhan', 4),
	('1207032013', '120703', 'Kuala', 4),
	('1207032014', '120703', 'Martelu', 4),
	('1207032015', '120703', 'Negeri Gunung', 4),
	('1207032016', '120703', 'Puangaja', 4),
	('1207032017', '120703', 'Rumah Kinangkung SP', 4),
	('1207032018', '120703', 'Rambung Baru', 4),
	('1207032019', '120703', 'Rumah Pil Pil', 4),
	('1207032020', '120703', 'Rumah Sumbul', 4),
	('1207032021', '120703', 'Sala Bulan', 4),
	('1207032022', '120703', 'Sayum Sabah', 4),
	('1207032023', '120703', 'Sembahe', 4),
	('1207032024', '120703', 'Sibolangit', 4),
	('1207032025', '120703', 'Sikebe', 4),
	('1207032026', '120703', 'Suka Maju', 4),
	('1207032027', '120703', 'Suka Makmur', 4),
	('1207032028', '120703', 'Tambunen', 4),
	('1207032029', '120703', 'Tanjung Beringin', 4),
	('1207032030', '120703', 'Ujung Deleng', 4),
	('1207042001', '120704', 'Suka Makmur', 4),
	('1207042002', '120704', 'Namo Mirik', 4),
	('1207042003', '120704', 'Suka Dame', 4),
	('1207042004', '120704', 'Pasar X', 4),
	('1207042005', '120704', 'Perpaden', 4),
	('1207042006', '120704', 'Kutalimbaru', 4),
	('1207042007', '120704', 'Sampe Cita', 4),
	('1207042008', '120704', 'Suka Rende', 4),
	('1207042009', '120704', 'Kuala Lau Bicik', 4),
	('1207042010', '120704', 'Lau Baukeni', 4),
	('1207042011', '120704', 'Silebo-lebo', 4),
	('1207042012', '120704', 'Sawit Rejo', 4),
	('1207042013', '120704', 'Namo Rube Julu', 4),
	('1207042014', '120704', 'Sei Mencirim', 4),
	('1207052001', '120705', 'Bintang Meriah', 4),
	('1207052002', '120705', 'Sugau', 4),
	('1207052003', '120705', 'Tianglayar', 4),
	('1207052004', '120705', 'Durian Simbelang', 4),
	('1207052005', '120705', 'Namo Riam', 4),
	('1207052006', '120705', 'Durian Tongga', 4),
	('1207052007', '120705', 'Kampung Hulu', 4),
	('1207052008', '120705', 'Pertampilan', 4),
	('1207052009', '120705', 'Salam Tani', 4),
	('1207052010', '120705', 'Tengah', 4),
	('1207052011', '120705', 'Namo Simpus', 4),
	('1207052012', '120705', 'Simalingkar A', 4),
	('1207052013', '120705', 'Namo Bintang', 4),
	('1207052014', '120705', 'Lama', 4),
	('1207052015', '120705', 'Namorih', 4),
	('1207052016', '120705', 'Tuntungan I', 4),
	('1207052017', '120705', 'Gunung Tinggi', 4),
	('1207052018', '120705', 'Tuntungan II', 4),
	('1207052019', '120705', 'Durian Jangak', 4),
	('1207052020', '120705', 'Sembahe Baru', 4),
	('1207052021', '120705', 'Tanjung Anom', 4),
	('1207052022', '120705', 'Sei Glugur', 4),
	('1207052023', '120705', 'Suka Raya', 4),
	('1207052024', '120705', 'Baru', 4),
	('1207052025', '120705', 'Perumnas Simalingkar', 4),
	('1207062001', '120706', 'Deli Tua', 4),
	('1207062002', '120706', 'Jati Kesuma', 4),
	('1207062003', '120706', 'Namo Rambe', 4),
	('1207062004', '120706', 'Gunung Klawas', 4),
	('1207062005', '120706', 'Ujung Labuhan', 4),
	('1207062006', '120706', 'Lubang Ido', 4),
	('1207062007', '120706', 'Silue-lue', 4),
	('1207062008', '120706', 'Timbang Lawan', 4),
	('1207062009', '120706', 'Batu Mbelin', 4),
	('1207062010', '120706', 'Namo Batang', 4),
	('1207062011', '120706', 'Tanjung Selamet', 4),
	('1207062012', '120706', 'Bekukul', 4),
	('1207062013', '120706', 'Namo Pakam', 4),
	('1207062014', '120706', 'Sukamulia Hilir', 4),
	('1207062015', '120706', 'Sukamulia Hulu', 4),
	('1207062016', '120706', 'Rumah Mbacang', 4),
	('1207062017', '120706', 'Cinta Rakyat', 4),
	('1207062018', '120706', 'Batu Penjomuran', 4),
	('1207062019', '120706', 'Kuta Tengah', 4),
	('1207062020', '120706', 'Namo Landur', 4),
	('1207062021', '120706', 'Gunung Berita', 4),
	('1207062022', '120706', 'Tangkahan', 4),
	('1207062023', '120706', 'Uruk Gedang', 4),
	('1207062024', '120706', 'Rumah Keben', 4),
	('1207062025', '120706', 'Namo Pinang', 4),
	('1207062026', '120706', 'Sidirejo', 4),
	('1207062027', '120706', 'Jabah', 4),
	('1207062028', '120706', 'Kuta Tuala', 4),
	('1207062029', '120706', 'Kwala Simeme', 4),
	('1207062030', '120706', 'Batu Gemuk', 4),
	('1207062031', '120706', 'Lau Mulgab', 4),
	('1207062032', '120706', 'Batu Rejo', 4),
	('1207062033', '120706', 'Sarang Tungir', 4),
	('1207062034', '120706', 'Namo Mbaru', 4),
	('1207062035', '120706', 'Namo Mungkur', 4),
	('1207062036', '120706', 'Namo Mbelin', 4),
	('1207072001', '120707', 'Aji Baho', 4),
	('1207072002', '120707', 'Biru-biru', 4),
	('1207072003', '120707', 'Candi Rejo', 4),
	('1207072004', '120707', 'Kuta Mulyo', 4),
	('1207072005', '120707', 'Kuala Deka', 4),
	('1207072006', '120707', 'Mbaruae', 4),
	('1207072007', '120707', 'Mardinding Julu', 4),
	('1207072008', '120707', 'Namo Suro Baru', 4),
	('1207072009', '120707', 'Peria-ria', 4),
	('1207072010', '120707', 'Penen', 4),
	('1207072011', '120707', 'Rumah Great', 4),
	('1207072012', '120707', 'Sidodadi', 4),
	('1207072013', '120707', 'Sidomulyo', 4),
	('1207072014', '120707', 'Selamat', 4),
	('1207072015', '120707', 'Sarilaba Jahe', 4),
	('1207072016', '120707', 'Tanjung Sena', 4),
	('1207072017', '120707', 'Namo Tualang', 4),
	('1207082001', '120708', 'Talun Kenas', 4),
	('1207082002', '120708', 'Gunung Rintih', 4),
	('1207082003', '120708', 'Sumbul', 4),
	('1207082004', '120708', 'Tandukan Raga', 4),
	('1207082005', '120708', 'Limau Mungkur', 4),
	('1207082006', '120708', 'Negara Beringin', 4),
	('1207082007', '120708', 'Lau Barus Baru', 4),
	('1207082008', '120708', 'Juma Tombak', 4),
	('1207082009', '120708', 'Siguji', 4),
	('1207082010', '120708', 'Kuta Jurung', 4),
	('1207082011', '120708', 'Tala Peta', 4),
	('1207082012', '120708', 'Lau Rakit', 4),
	('1207082013', '120708', 'Penungkiran', 4),
	('1207082014', '120708', 'Rambai', 4),
	('1207082015', '120708', 'Lau Rempak', 4),
	('1207092001', '120709', 'Bah Perak', 4),
	('1207092002', '120709', 'Bandar Kuala', 4),
	('1207092003', '120709', 'Bah Kuala', 4),
	('1207092005', '120709', 'Bandar Gungung', 4),
	('1207092006', '120709', 'Bandar Meriah', 4),
	('1207092007', '120709', 'Batu Gingging', 4),
	('1207092008', '120709', 'Bangun Purba', 4),
	('1207092009', '120709', 'Bangun Purba Tengah', 4),
	('1207092010', '120709', 'Bagerpang', 4),
	('1207092011', '120709', 'Batu Rata', 4),
	('1207092012', '120709', 'Cimahi', 4),
	('1207092014', '120709', 'Damak Maleho', 4),
	('1207092015', '120709', 'Geriahan', 4),
	('1207092017', '120709', 'M. Ujung Jawi', 4),
	('1207092018', '120709', 'Marumbun Barat', 4),
	('1207092019', '120709', 'Mabar', 4),
	('1207092020', '120709', 'Perguroan', 4),
	('1207092023', '120709', 'Rumah Deleng', 4),
	('1207092024', '120709', 'Sibaganding', 4),
	('1207092025', '120709', 'Sialang', 4),
	('1207092027', '120709', 'Suka Luwei', 4),
	('1207092030', '120709', 'Tanjung Purba', 4),
	('1207092032', '120709', 'Urung Ganjang', 4),
	('1207092033', '120709', 'Ujung Rambe', 4),
	('1207191038', '120719', 'Galang Kota', 3),
	('1207192001', '120719', 'Tanjung Gusti', 4),
	('1207192002', '120719', 'Baru Titi Besi', 4),
	('1207192003', '120719', 'Bandar Kuala', 4),
	('1207192004', '120719', 'Batu Lokong', 4),
	('1207192005', '120719', 'Galang Suka', 4),
	('1207192006', '120719', 'Galang Barat', 4),
	('1207192007', '120719', 'Jaharum A', 4),
	('1207192008', '120719', 'Jaharum B', 4),
	('1207192009', '120719', 'Juhar Baru', 4),
	('1207192012', '120719', 'Keramat Gajah', 4),
	('1207192013', '120719', 'Kotasan', 4),
	('1207192015', '120719', 'Kotangan', 4),
	('1207192016', '120719', 'Kelapa Satu', 4),
	('1207192019', '120719', 'Nogorejo', 4),
	('1207192022', '120719', 'Paku', 4),
	('1207192023', '120719', 'Petumbukan', 4),
	('1207192024', '120719', 'Petangguhan', 4),
	('1207192025', '120719', 'Pisang Pala', 4),
	('1207192026', '120719', 'Paya Itik', 4),
	('1207192027', '120719', 'Pulau Tagor Batu', 4),
	('1207192028', '120719', 'Paya Kuda', 4),
	('1207192029', '120719', 'Paya Sampir', 4),
	('1207192030', '120719', 'Sei Putih', 4),
	('1207192031', '120719', 'Sei Karang', 4),
	('1207192034', '120719', 'Tanah Abang', 4),
	('1207192035', '120719', 'Timbang Deli', 4),
	('1207192036', '120719', 'Tanah Merah', 4),
	('1207192037', '120719', 'Tanjung Siporkis', 4),
	('1207202001', '120720', 'Tiga Juhar', 4),
	('1207202002', '120720', 'Tanjung Bamku', 4),
	('1207202003', '120720', 'Ruma Rih', 4),
	('1207202004', '120720', 'Liang Muda', 4),
	('1207202005', '120720', 'Durian IV Mblang', 4),
	('1207202006', '120720', 'Tanah Gara Hulu', 4),
	('1207202007', '120720', 'Gunung Manumpuk A', 4),
	('1207202008', '120720', 'Bah Bah Buntu', 4),
	('1207202009', '120720', 'Tanjung Muda', 4),
	('1207202010', '120720', 'Tanjung Raya', 4),
	('1207202011', '120720', 'Kuta Mbelin', 4),
	('1207202012', '120720', 'Rumah Sumbul', 4),
	('1207202013', '120720', 'Ranggil-git', 4),
	('1207202014', '120720', 'Liang Pematang', 4),
	('1207202015', '120720', 'Gunung Manumpuk B', 4),
	('1207202016', '120720', 'Rumah Lengo', 4),
	('1207202017', '120720', 'Sipinggan', 4),
	('1207202018', '120720', 'Tanjung Timur', 4),
	('1207202019', '120720', 'Durian Tinggung', 4),
	('1207202020', '120720', 'Sibunga Bunga Hilir', 4),
	('1207212001', '120721', 'Lantasan Baru', 4),
	('1207212002', '120721', 'Patumbak I', 4),
	('1207212003', '120721', 'Patumbak II', 4),
	('1207212004', '120721', 'Lantasan Lama', 4),
	('1207212005', '120721', 'Sigara Gara', 4),
	('1207212006', '120721', 'Marendal I', 4),
	('1207212007', '120721', 'Marindal II', 4),
	('1207212008', '120721', 'Patumbak Kampung', 4),
	('1207221004', '120722', 'Delitua', 3),
	('1207221005', '120722', 'Delitua Timur', 3),
	('1207221006', '120722', 'Delitua Barat', 3),
	('1207222001', '120722', 'Kedai Durian', 4),
	('1207222002', '120722', 'Suka Makmur', 4),
	('1207222003', '120722', 'Mekar Sari', 4),
	('1207232001', '120723', 'Sei Semayang', 4),
	('1207232002', '120723', 'Kampung Lalang', 4),
	('1207232003', '120723', 'Puji Mulyo', 4),
	('1207232004', '120723', 'Paya Geli', 4),
	('1207232005', '120723', 'Mulio Rejo', 4),
	('1207232006', '120723', 'Porwodadi', 4),
	('1207232007', '120723', 'SM. Diski', 4),
	('1207232008', '120723', 'Tanjung Gusta', 4),
	('1207232009', '120723', 'Helvetia', 4),
	('1207232010', '120723', 'Medan Krio', 4),
	('1207232011', '120723', 'Sei Mencirim', 4),
	('1207232012', '120723', 'Suka Maju', 4),
	('1207232013', '120723', 'Sunggal Kanan', 4),
	('1207232014', '120723', 'Serba Jadi', 4),
	('1207232015', '120723', 'Telaga Sari', 4),
	('1207232016', '120723', 'Tanjung Selamat', 4),
	('1207232017', '120723', 'Sei Beras Sekata', 4),
	('1207242001', '120724', 'Hamparan Perak', 4),
	('1207242002', '120724', 'Sei Baharu', 4),
	('1207242003', '120724', 'Klumpang Kebon', 4),
	('1207242004', '120724', 'Klumpang Kampung', 4),
	('1207242005', '120724', 'Klambir V Kampung', 4),
	('1207242006', '120724', 'Tandem Hulu II', 4),
	('1207242007', '120724', 'Klambir', 4),
	('1207242008', '120724', 'Selemak', 4),
	('1207242009', '120724', 'Kelambir V Kebon', 4),
	('1207242010', '120724', 'Sialang Muda', 4),
	('1207242011', '120724', 'Paya Bakum', 4),
	('1207242012', '120724', 'Tandem Hulu I', 4),
	('1207242013', '120724', 'Tandem Hilir I', 4),
	('1207242014', '120724', 'Tandem Hilir II', 4),
	('1207242015', '120724', 'Kota Datar', 4),
	('1207242016', '120724', 'Bulu Cina', 4),
	('1207242017', '120724', 'Kota Rantang', 4),
	('1207242018', '120724', 'Paluh Manan', 4),
	('1207242019', '120724', 'Desa Lama', 4),
	('1207242020', '120724', 'Palu Kurau', 4),
	('1207252001', '120725', 'Helvetia', 4),
	('1207252002', '120725', 'Manunggal', 4),
	('1207252003', '120725', 'Pematang Johar', 4),
	('1207252004', '120725', 'Karang Gading', 4),
	('1207252005', '120725', 'Telaga Tujuh', 4),
	('1207261019', '120726', 'Kenangan', 3),
	('1207261020', '120726', 'Kenangan Baru', 3),
	('1207262001', '120726', 'Pematang Lalang', 4),
	('1207262002', '120726', 'Samborejo Timur', 4),
	('1207262003', '120726', 'Kolam', 4),
	('1207262004', '120726', 'Percut', 4),
	('1207262005', '120726', 'Laut Dendang', 4),
	('1207262006', '120726', 'Tembung', 4),
	('1207262007', '120726', 'Cinta Rakyat', 4),
	('1207262008', '120726', 'Amplas', 4),
	('1207262009', '120726', 'Saentis', 4),
	('1207262010', '120726', 'Sampali', 4),
	('1207262011', '120726', 'Bandar Khalipa', 4),
	('1207262012', '120726', 'Bandar Khalipa Kebon', 4),
	('1207262013', '120726', 'Tanjung Slamat', 4),
	('1207262014', '120726', 'Tanjung Rejo', 4),
	('1207262015', '120726', 'Medan Estate', 4),
	('1207262016', '120726', 'Cinta Dame', 4),
	('1207262017', '120726', 'Bandar Setia', 4),
	('1207262018', '120726', 'Sei Rotan', 4),
	('1207272001', '120727', 'Sena', 4),
	('1207272002', '120727', 'T. Nibung', 4),
	('1207272003', '120727', 'Tanjung Sari', 4),
	('1207272004', '120727', 'Kampung Baru', 4),
	('1207272005', '120727', 'Batangkuis Pekan', 4),
	('1207272006', '120727', 'Sidodadi', 4),
	('1207272007', '120727', 'Bintang Meriah', 4),
	('1207272008', '120727', 'Bakaran Batu', 4),
	('1207272009', '120727', 'Paya Gambar', 4),
	('1207272010', '120727', 'Mesjid', 4),
	('1207272011', '120727', 'Sugiharjo', 4),
	('1207281007', '120728', 'Lubuk Pakam I,II', 3),
	('1207281008', '120728', 'Lubuk Pakam III', 3),
	('1207281009', '120728', 'Paluh Kemiri', 3),
	('1207281010', '120728', 'Cemara', 3),
	('1207281011', '120728', 'Syahmad', 3),
	('1207281012', '120728', 'Petapahan', 3),
	('1207281013', '120728', 'Lubuk Pakam Pekan', 3),
	('1207282001', '120728', 'Sekip', 4),
	('1207282002', '120728', 'Pagar Jati', 4),
	('1207282003', '120728', 'Tanjung Garbus', 4),
	('1207282004', '120728', 'Pasar Melintang', 4),
	('1207282005', '120728', 'Pagar Merbau III', 4),
	('1207282006', '120728', 'Bakaran Batu', 4),
	('1207312001', '120731', 'Tanjung Mulia', 4),
	('1207312002', '120731', 'Purwodadi', 4),
	('1207312003', '120731', 'Sidodadi BT. B', 4),
	('1207312004', '120731', 'Suka Mulia', 4),
	('1207312005', '120731', 'Jati Rejo', 4),
	('1207312006', '120731', 'Pagar Merbau I', 4),
	('1207312007', '120731', 'Pagar Merbau II', 4),
	('1207312008', '120731', 'Pasar Miring', 4),
	('1207312009', '120731', 'Jati Baru', 4),
	('1207312010', '120731', 'Bandar Dolok', 4),
	('1207312011', '120731', 'Tanjung Garbus II', 4),
	('1207312012', '120731', 'Tanjung Garbus Kp', 4),
	('1207312013', '120731', 'Perbarakan', 4),
	('1207312014', '120731', 'Suka Mandi Hilir', 4),
	('1207312015', '120731', 'Suka Mandi Hulu', 4),
	('1207312016', '120731', 'Sumber Rejoh', 4),
	('1207322001', '120732', 'Sei Tuan', 4),
	('1207322002', '120732', 'KampungTengah', 4),
	('1207322003', '120732', 'Bagan Serdang', 4),
	('1207322004', '120732', 'Rantau Panjang', 4),
	('1207322005', '120732', 'Regemuk', 4),
	('1207322006', '120732', 'Kuba Sentang', 4),
	('1207322007', '120732', 'Pantai Labu Pekan', 4),
	('1207322008', '120732', 'Pantai Labu Baru', 4),
	('1207322009', '120732', 'Ramonia I', 4),
	('1207322010', '120732', 'Ramonia II', 4),
	('1207322011', '120732', 'Perk. Ramonia', 4),
	('1207322012', '120732', 'Denai Lama', 4),
	('1207322013', '120732', 'Denai Kuala', 4),
	('1207322014', '120732', 'Denai Sarang Burung', 4),
	('1207322015', '120732', 'Binjai Bakung', 4),
	('1207322016', '120732', 'Paluh Sibaji', 4),
	('1207322017', '120732', 'Kelambir', 4),
	('1207322018', '120732', 'Durian', 4),
	('1207322019', '120732', 'Pematang Biara', 4),
	('1207332001', '120733', 'Serdang', 4),
	('1207332002', '120733', 'Sidourip', 4),
	('1207332003', '120733', 'Aras Kabu', 4),
	('1207332004', '120733', 'Psr. VI Kwala Namu', 4),
	('1207332005', '120733', 'Eplasmen Kw Namu', 4),
	('1207332006', '120733', 'Psr. V Kebun Kelapa', 4),
	('1207332007', '120733', 'Beringin', 4),
	('1207332008', '120733', 'Sidoarjo II R', 4),
	('1207332009', '120733', 'Karang Anyer', 4),
	('1207332010', '120733', 'Sidodadi Ramonia', 4),
	('1207332011', '120733', 'Tumpatan', 4),
	('1208012001', '120801', 'Silampuyang', 4),
	('1208012002', '120801', 'Marihat Baris', 4),
	('1208012003', '120801', 'Dolok Marlawan', 4),
	('1208012004', '120801', 'Rambung Merah', 4),
	('1208012005', '120801', 'Silou Manik', 4),
	('1208012006', '120801', 'Sejahtera', 4),
	('1208012007', '120801', 'Siantar Estate', 4),
	('1208012008', '120801', 'Karang Bangun', 4),
	('1208012009', '120801', 'Nusa Harapan', 4),
	('1208012010', '120801', 'Sitalasari', 4),
	('1208012011', '120801', 'Lestari Indah', 4),
	('1208012012', '120801', 'Laras Dua', 4),
	('1208012013', '120801', 'Dolok Hataran', 4),
	('1208012014', '120801', 'Pantoan Maju', 4),
	('1208012015', '120801', 'Pematang Simalungun', 4),
	('1208012016', '120801', 'Silau Malaha', 4),
	('1208012017', '120801', 'Pematang Silampuyang', 4),
	('1208022001', '120802', 'Dolok Malela', 4),
	('1208022002', '120802', 'Senio', 4),
	('1208022003', '120802', 'Pematang Asilum', 4),
	('1208022004', '120802', 'Serapuh', 4),
	('1208022005', '120802', 'Margo Mulyo', 4),
	('1208022006', '120802', 'Silulu', 4),
	('1208022007', '120802', 'Silau Malela', 4),
	('1208022008', '120802', 'Bandar Siantar', 4),
	('1208022009', '120802', 'Pamatang Gajing', 4),
	('1208022010', '120802', 'Bangun', 4),
	('1208022011', '120802', 'Nagori Malela', 4),
	('1208022012', '120802', 'Bukit Maraja', 4),
	('1208022013', '120802', 'Pamatang Syahkuda', 4),
	('1208022014', '120802', 'Marihat Bukit', 4),
	('1208022015', '120802', 'Syahkuda Bayu', 4),
	('1208022016', '120802', 'Lingga', 4),
	('1208032001', '120803', 'Silau Bayu', 4),
	('1208032002', '120803', 'Karang Anyer', 4),
	('1208032003', '120803', 'Karang Rejo', 4),
	('1208032004', '120803', 'Karang Sari', 4),
	('1208032005', '120803', 'Tumorang', 4),
	('1208032006', '120803', 'Rabuhit', 4),
	('1208032007', '120803', 'Hutadipar', 4),
	('1208032008', '120803', 'Ganjing', 4),
	('1208032009', '120803', 'Bandar Malela', 4),
	('1208041011', '120804', 'Panei Tongah', 3),
	('1208042001', '120804', 'Janggir Leto', 4),
	('1208042002', '120804', 'Simpang Pane Raya', 4),
	('1208042003', '120804', 'Siborna', 4),
	('1208042004', '120804', 'Sipoldas', 4),
	('1208042005', '120804', 'Bangun Rakyat', 4),
	('1208042006', '120804', 'Sigodang', 4),
	('1208042007', '120804', 'Sigodang Barat', 4),
	('1208042008', '120804', 'Bah Bolon Tonga', 4),
	('1208042009', '120804', 'Mekar Sari Raya', 4),
	('1208042010', '120804', 'Simantin Pane Dame', 4),
	('1208042012', '120804', 'Simpang Raya Dasma', 4),
	('1208042013', '120804', 'Bangun Das Mariah', 4),
	('1208042014', '120804', 'Bangun Sitolu Bah', 4),
	('1208042015', '120804', 'Bah Liran Siborna', 4),
	('1208042016', '120804', 'Nauli Baru', 4),
	('1208042017', '120804', 'Rawang Pardomuan Nauli', 4),
	('1208052001', '120805', 'Panombeian', 4),
	('1208052002', '120805', 'Pematang Panombean', 4),
	('1208052003', '120805', 'Nagori Bosar', 4),
	('1208052004', '120805', 'Marjandi', 4),
	('1208052005', '120805', 'Simpang Panei', 4),
	('1208052006', '120805', 'Talun Kondot', 4),
	('1208052007', '120805', 'Simbolon Tengkoh', 4),
	('1208052008', '120805', 'Pematang Pane', 4),
	('1208052009', '120805', 'Marjandi Pisang', 4),
	('1208052010', '120805', 'Banuh Raya', 4),
	('1208052011', '120805', 'Rukun Mulyo', 4),
	('1208061008', '120806', 'Tiga Balata', 3),
	('1208062001', '120806', 'Kasindir', 4),
	('1208062002', '120806', 'Sibunga Bunga', 4),
	('1208062003', '120806', 'Jorlang Hataran', 4),
	('1208062004', '120806', 'Bah Sampuran', 4),
	('1208062005', '120806', 'Bah Birong Ulu', 4),
	('1208062006', '120806', 'Pinang Ratus', 4),
	('1208062007', '120806', 'Dolok Marlawan', 4),
	('1208062009', '120806', 'Panombean Hutaurung', 4),
	('1208062010', '120806', 'Dipar Hataran', 4),
	('1208062011', '120806', 'Pagar Pinang', 4),
	('1208062012', '120806', 'Dolok Parriasan', 4),
	('1208062013', '120806', 'Parmonangan', 4),
	('1208071008', '120807', 'Sindar Raya', 3),
	('1208072001', '120807', 'Sambosar Raya', 4),
	('1208072002', '120807', 'Panduman', 4),
	('1208072003', '120807', 'Ambarokan Pane Raya', 4),
	('1208072004', '120807', 'Bah Tonang', 4),
	('1208072005', '120807', 'Bah Bulian', 4),
	('1208072006', '120807', 'Bangun Raya', 4),
	('1208072007', '120807', 'Durian Banggal', 4),
	('1208072008', '120807', 'Sorba Dolog', 4),
	('1208072009', '120807', 'Gunung Datas', 4),
	('1208072010', '120807', 'Puli Buah', 4),
	('1208072011', '120807', 'Banu Raya', 4),
	('1208072012', '120807', 'Marubun Siboras', 4),
	('1208072013', '120807', 'Banjaran', 4),
	('1208081013', '120808', 'Bosar Maligas', 3),
	('1208082001', '120808', 'Parbutaran', 4),
	('1208082002', '120808', 'Mayang', 4),
	('1208082003', '120808', 'Boluk', 4),
	('1208082004', '120808', 'Sei Mangkei', 4),
	('1208082005', '120808', 'Gunung Bayu', 4),
	('1208082006', '120808', 'Talun Saragih', 4),
	('1208082007', '120808', 'Dusun Pengkolan', 4),
	('1208082008', '120808', 'Sei Torop', 4),
	('1208082009', '120808', 'Marihat Tanjung', 4),
	('1208082010', '120808', 'Marihat Butar', 4),
	('1208082011', '120808', 'Teladan', 4),
	('1208082012', '120808', 'Adil Makmur', 4),
	('1208082014', '120808', 'Tempel Jaya', 4),
	('1208082015', '120808', 'Sidomulyo', 4),
	('1208082016', '120808', 'Mekar Rejo', 4),
	('1208082017', '120808', 'Nanggar Bayu', 4),
	('1208091013', '120809', 'Sarimatondang', 3),
	('1208092001', '120809', 'Bah Butong I', 4),
	('1208092002', '120809', 'Sidamanik', 4),
	('1208092003', '120809', 'Ambarisan', 4),
	('1208092004', '120809', 'Tiga Bolon', 4),
	('1208092005', '120809', 'Bah Butong II', 4),
	('1208092006', '120809', 'Bahal Gajah', 4),
	('1208092007', '120809', 'Manik Hataran', 4),
	('1208092008', '120809', 'Mekar Sidamanik', 4),
	('1208092009', '120809', 'Manik Maraja', 4),
	('1208092010', '120809', 'Bah Biak', 4),
	('1208092011', '120809', 'Birong Ulu Manriah', 4),
	('1208092012', '120809', 'Kebun Sayur Bah Butong', 4),
	('1208092014', '120809', 'Manik Rambung', 4),
	('1208092015', '120809', 'Bukit Rejo', 4),
	('1208101009', '120810', 'Sipolha Horison', 3),
	('1208102001', '120810', 'Sait Buttu Saribu', 4),
	('1208102002', '120810', 'Pematang Sidamanik', 4),
	('1208102003', '120810', 'Sarimattin', 4),
	('1208102004', '120810', 'Bandar Manik', 4),
	('1208102005', '120810', 'Jorlang Huluan', 4),
	('1208102006', '120810', 'Sihaporas', 4),
	('1208102007', '120810', 'Pematang Tambun Raya', 4),
	('1208102008', '120810', 'Simantin', 4),
	('1208102010', '120810', 'Gorak', 4),
	('1208111018', '120811', 'Pematang Tanah Jawa', 3),
	('1208112001', '120811', 'Tanjung Pasir', 4),
	('1208112002', '120811', 'Totap Majawa', 4),
	('1208112003', '120811', 'Balimbingan', 4),
	('1208112004', '120811', 'Baja Dolok', 4),
	('1208112005', '120811', 'Bosar Galugur', 4),
	('1208112006', '120811', 'Bah Jambi II', 4),
	('1208112007', '120811', 'Bah Kisat', 4),
	('1208112008', '120811', 'Panembean Marjanji', 4),
	('1208112009', '120811', 'Muara Mulia', 4),
	('1208112010', '120811', 'Pardamean Asih', 4),
	('1208112011', '120811', 'Mekar Mulia', 4),
	('1208112012', '120811', 'Maligas Tonga', 4),
	('1208112013', '120811', 'Marubun Jaya', 4),
	('1208112014', '120811', 'Pagar Jambi', 4),
	('1208112015', '120811', 'Baliju', 4),
	('1208112016', '120811', 'Bayu Bagasan', 4),
	('1208112017', '120811', 'Bah Jambi III', 4),
	('1208112019', '120811', 'Parbalogan', 4),
	('1208112020', '120811', 'Marubun Bayu', 4),
	('1208122001', '120812', 'Buttu Bayu', 4),
	('1208122002', '120812', 'Bosar Nauli', 4),
	('1208122003', '120812', 'Tangga Batu', 4),
	('1208122004', '120812', 'Buntu Turunan', 4),
	('1208122005', '120812', 'Saribu Asih', 4),
	('1208122006', '120812', 'Jawa Tonga', 4),
	('1208122007', '120812', 'Tonduhan', 4),
	('1208122008', '120812', 'Parhundalian Jw.Dipar', 4),
	('1208122009', '120812', 'Jawa Tongah II', 4),
	('1208132001', '120813', 'Negeri Dolok', 4),
	('1208132002', '120813', 'Dolok Parmonangan', 4),
	('1208132003', '120813', 'Dolok Tomuan', 4),
	('1208132004', '120813', 'Marihat Dolok', 4),
	('1208132005', '120813', 'Tiga Dolok', 4),
	('1208132006', '120813', 'Ujung Bondar', 4),
	('1208132007', '120813', 'Marihat Raja', 4),
	('1208132008', '120813', 'Bandar Dolok', 4),
	('1208132009', '120813', 'Gunung Mariah', 4),
	('1208132010', '120813', 'Siatasan', 4),
	('1208132011', '120813', 'Marihat Marsada', 4),
	('1208132012', '120813', 'Pondok Buluh', 4),
	('1208132013', '120813', 'Marihat Pondok', 4),
	('1208132014', '120813', 'Lumban Gorat', 4),
	('1208132015', '120813', 'Palianopat', 4),
	('1208141008', '120814', 'Tiga Runggu', 3),
	('1208142001', '120814', 'Purba Tongah', 4),
	('1208142002', '120814', 'Pematang Purba', 4),
	('1208142003', '120814', 'Urung Purba', 4),
	('1208142004', '120814', 'Purba Sipinggan', 4),
	('1208142005', '120814', 'Hinalang', 4),
	('1208142006', '120814', 'Purba Dolok', 4),
	('1208142007', '120814', 'Tano Tinggir', 4),
	('1208142009', '120814', 'Seribu Jandi', 4),
	('1208142010', '120814', 'Huta Raja', 4),
	('1208142011', '120814', 'Bandar Sauhur', 4),
	('1208142012', '120814', 'Bunga Sampang', 4),
	('1208142013', '120814', 'Nagori Tongah', 4),
	('1208142014', '120814', 'Urung Pane', 4),
	('1208151005', '120815', 'Haranggaol', 3),
	('1208152001', '120815', 'Nagori Purba', 4),
	('1208152002', '120815', 'Nagori Sihalpe', 4),
	('1208152003', '120815', 'Nagori Purba Horison', 4),
	('1208152004', '120815', 'Nagori Purba Pasir', 4),
	('1208161003', '120816', 'Girsang', 3),
	('1208161004', '120816', 'Parapat', 3),
	('1208161005', '120816', 'Tiga Raja', 3),
	('1208162001', '120816', 'Sipangan Bolon', 4),
	('1208162002', '120816', 'Sabaganding', 4),
	('1208162006', '120816', 'Sipangan Bolon Mekar', 4),
	('1208171015', '120817', 'Serbelawan', 3),
	('1208171016', '120817', 'Aman Sari', 3),
	('1208172001', '120817', 'Silenduk', 4),
	('1208172002', '120817', 'Bah Tobu', 4),
	('1208172003', '120817', 'Bandar Selamat', 4),
	('1208172004', '120817', 'Dolok Ilir I', 4),
	('1208172005', '120817', 'Dolok Ilir II', 4),
	('1208172006', '120817', 'Bahung Kahean', 4),
	('1208172007', '120817', 'Dolok Mainu', 4),
	('1208172008', '120817', 'Dolok Merangir I', 4),
	('1208172009', '120817', 'Dolok Merangir II', 4),
	('1208172010', '120817', 'Kahean', 4),
	('1208172011', '120817', 'Dolok Tenera', 4),
	('1208172012', '120817', 'Dolok Kataran', 4),
	('1208172013', '120817', 'Padang Mainu', 4),
	('1208172014', '120817', 'Bahung Huluan', 4),
	('1208181013', '120818', 'Huta Bayu', 3),
	('1208182001', '120818', 'Mariah Hombang', 4),
	('1208182002', '120818', 'Pulo Bayu', 4),
	('1208182003', '120818', 'Silakkidir', 4),
	('1208182004', '120818', 'Raja Maligas', 4),
	('1208182005', '120818', 'Dolok Sinumbah', 4),
	('1208182006', '120818', 'Maligas Bayu', 4),
	('1208182007', '120818', 'Jawa Baru', 4),
	('1208182008', '120818', 'Mancuk', 4),
	('1208182009', '120818', 'Marihat Mayang', 4),
	('1208182010', '120818', 'Bosar Bayu', 4),
	('1208182011', '120818', 'Raja Maligas I', 4),
	('1208182012', '120818', 'Bahal Batu', 4),
	('1208182014', '120818', 'Pokan Baru', 4),
	('1208182015', '120818', 'Manrayap Baru', 4),
	('1208182016', '120818', 'Talang Bayu', 4),
	('1208192001', '120819', 'Jawa Maraja', 4),
	('1208192002', '120819', 'Moho', 4),
	('1208192003', '120819', 'Bahalat Bayu', 4),
	('1208192004', '120819', 'Mekar Bahalat', 4),
	('1208192005', '120819', 'Tanjung Maraja', 4),
	('1208192006', '120819', 'Mariah Jambi', 4),
	('1208192007', '120819', 'Bah Joga', 4),
	('1208192008', '120819', 'Bah Jambi', 4),
	('1208202001', '120820', 'Tigaras', 4),
	('1208202002', '120820', 'Parik Sabungan', 4),
	('1208202003', '120820', 'Sibuntuon', 4),
	('1208202004', '120820', 'Dolok Saribu', 4),
	('1208202005', '120820', 'Sinaman Labah', 4),
	('1208202006', '120820', 'Bangun Pane', 4),
	('1208202007', '120820', 'Butu Bayu Pane Raja', 4),
	('1208202008', '120820', 'Parjalangan', 4),
	('1208202009', '120820', 'Silabah Jaya', 4),
	('1208202010', '120820', 'Togu Domu Nauli', 4),
	('1208202011', '120820', 'Sirube-rube Gunung Purba', 4),
	('1208202012', '120820', 'Partuahan', 4),
	('1208202013', '120820', 'Pematang Sinaman', 4),
	('1208202014', '120820', 'Tanjung Saribu', 4),
	('1208202015', '120820', 'Sihemum Baru', 4),
	('1208202016', '120820', 'Nagori Bayu', 4),
	('1208211009', '120821', 'Kerasaan I', 3),
	('1208211010', '120821', 'Pematang Bandar', 3),
	('1208212001', '120821', 'Purwosari', 4),
	('1208212002', '120821', 'Talun Madear', 4),
	('1208212003', '120821', 'Mariah Bandar', 4),
	('1208212004', '120821', 'Kandangan', 4),
	('1208212005', '120821', 'Pardomuan Nauli', 4),
	('1208212006', '120821', 'Purba Ganda', 4),
	('1208212007', '120821', 'Kerasaan II', 4),
	('1208212008', '120821', 'Bandar Manis', 4),
	('1208212011', '120821', 'Wana Rejo', 4),
	('1208212012', '120821', 'Talun Rejo', 4),
	('1208212013', '120821', 'Purwodadi', 4),
	('1208222001', '120822', 'Naga Jaya I', 4),
	('1208222002', '120822', 'Bah Gunung', 4),
	('1208222003', '120822', 'Bandar Tonga', 4),
	('1208222004', '120822', 'Dolok Parmonangan', 4),
	('1208222005', '120822', 'Laras', 4),
	('1208222006', '120822', 'Naga Jaya II', 4),
	('1208222007', '120822', 'Tanjung Hataran', 4),
	('1208222008', '120822', 'Bandar Betsy I', 4),
	('1208222009', '120822', 'Bandar Betsy II', 4),
	('1208222010', '120822', 'Naga Soppa', 4),
	('1208231014', '120823', 'Perdagangan I', 3),
	('1208231015', '120823', 'Perdagangan III', 3),
	('1208232001', '120823', 'Pematang Kerasaan', 4),
	('1208232002', '120823', 'Marihat Bandar', 4),
	('1208232003', '120823', 'Nagori Bandar', 4),
	('1208232004', '120823', 'Bandar Rakyat', 4),
	('1208232005', '120823', 'Bandar Pulo', 4),
	('1208232006', '120823', 'Bah Lias', 4),
	('1208232007', '120823', 'Pardagangan II', 4),
	('1208232008', '120823', 'Perlanaan', 4),
	('1208232009', '120823', 'Sugarang Bayu', 4),
	('1208232010', '120823', 'Pem.Kerasaan Rejo', 4),
	('1208232011', '120823', 'Timbaan', 4),
	('1208232012', '120823', 'Bandar Jawa', 4),
	('1208232013', '120823', 'Sidotani', 4),
	('1208232016', '120823', 'Landbouw', 4),
	('1208242001', '120824', 'Bandar Masilam', 4),
	('1208242002', '120824', 'Lias Baru', 4),
	('1208242003', '120824', 'Bandar Silou', 4),
	('1208242004', '120824', 'Panombean Baru', 4),
	('1208242005', '120824', 'Gunung Serawan', 4),
	('1208242006', '120824', 'Bandar Masilam II', 4),
	('1208242007', '120824', 'Patimbalan', 4),
	('1208242008', '120824', 'Bandar Tinggi', 4),
	('1208242009', '120824', 'Bandar Rejo', 4),
	('1208242010', '120824', 'Bandar Gunung', 4),
	('1208251012', '120825', 'Seribu Dolok', 3),
	('1208252003', '120825', 'Bangun Mariah', 4),
	('1208252004', '120825', 'Purba Sinombah', 4),
	('1208252006', '120825', 'Purba Tua', 4),
	('1208252009', '120825', 'Purba Tua Baru', 4),
	('1208252014', '120825', 'Sinar Baru', 4),
	('1208252016', '120825', 'Purbatua Etek', 4),
	('1208262001', '120826', 'Cingkes', 4),
	('1208262002', '120826', 'Paribuan', 4),
	('1208262003', '120826', 'Saran Padang', 4),
	('1208262004', '120826', 'Mariah Dolok', 4),
	('1208262005', '120826', 'Marubun Lokkung', 4),
	('1208262006', '120826', 'Dolok Mariah', 4),
	('1208262007', '120826', 'Bawang', 4),
	('1208262008', '120826', 'Huta Saing', 4),
	('1208262009', '120826', 'Togur', 4),
	('1208262010', '120826', 'Perasmian', 4),
	('1208262011', '120826', 'Tanjung Purba', 4),
	('1208262012', '120826', 'Silau Marawan', 4),
	('1208262013', '120826', 'Bosi Sinumbah', 4),
	('1208262014', '120826', 'Ujung Bawang', 4),
	('1208272001', '120827', 'Simanabun', 4),
	('1208272002', '120827', 'Pardomuan Tongah', 4),
	('1208272003', '120827', 'Negeri Dolok', 4),
	('1208272004', '120827', 'Bandar Maruhur', 4),
	('1208272005', '120827', 'Silou Dunia', 4),
	('1208272006', '120827', 'Dolok Marawa', 4),
	('1208272007', '120827', 'Maria Buttu', 4),
	('1208272008', '120827', 'Dolok Saribu Bangun', 4),
	('1208272009', '120827', 'Bandar Nagori', 4),
	('1208272010', '120827', 'Silou Paribuan', 4),
	('1208272011', '120827', 'Buttu Bayu', 4),
	('1208272012', '120827', 'Nagori Tani', 4),
	('1208272013', '120827', 'Bah Sarimah', 4),
	('1208272014', '120827', 'Damaritang', 4),
	('1208272015', '120827', 'Sinasih', 4),
	('1208272016', '120827', 'Pardomuan Bandar', 4),
	('1208281009', '120828', 'Sinaksak', 3),
	('1208282001', '120828', 'Batu Silangit', 4),
	('1208282002', '120828', 'Dolok Maraja', 4),
	('1208282003', '120828', 'Dolok Ulu', 4),
	('1208282004', '120828', 'Nagur Usang', 4),
	('1208282005', '120828', 'Dolok Kahean', 4),
	('1208282006', '120828', 'Naga Dolok', 4),
	('1208282007', '120828', 'Purbasari', 4),
	('1208282008', '120828', 'Pematang Dolok Kahean', 4),
	('1208282010', '120828', 'Negri Bayu Muslimin', 4),
	('1208282011', '120828', 'Dolok Simbolon', 4),
	('1208291001', '120829', 'Merek Raya', 3),
	('1208291002', '120829', 'Dalig Raya', 3),
	('1208291005', '120829', 'Sondi Raya', 3),
	('1208291011', '120829', 'Pematang Raya', 3),
	('1208291018', '120829', 'Baringin Raya', 3),
	('1208292003', '120829', 'Dolok Huluan', 4),
	('1208292004', '120829', 'Raya Bayu', 4),
	('1208292006', '120829', 'Raya Usang', 4),
	('1208292007', '120829', 'Bahapal Raya', 4),
	('1208292008', '120829', 'Raya Huluan', 4),
	('1208292009', '120829', 'Bah Bolon', 4),
	('1208292010', '120829', 'Siporkas', 4),
	('1208292012', '120829', 'Sihubu Raya', 4),
	('1208292013', '120829', 'Raya Bosi', 4),
	('1208292014', '120829', 'Silou Huluan', 4),
	('1208292015', '120829', 'Silou Buttu', 4),
	('1208292016', '120829', 'Bongguran Kariahan', 4),
	('1208292017', '120829', 'Simbou Baru', 4),
	('1208292019', '120829', 'Bintang Mariah', 4),
	('1208292020', '120829', 'Dame Raya', 4),
	('1208292021', '120829', 'Limag Raya', 4),
	('1208292022', '120829', 'Lokkung Raya', 4),
	('1208301001', '120830', 'Ujung Padang', 3),
	('1208302002', '120830', 'Huta Parik', 4),
	('1208302003', '120830', 'Dusun Ulu', 4),
	('1208302004', '120830', 'Tinjoan', 4),
	('1208302005', '120830', 'Sayur Matinggi', 4),
	('1208302006', '120830', 'Taratak Nagodang', 4),
	('1208302007', '120830', 'Sordang Bolon', 4),
	('1208302008', '120830', 'Teluk Lapian', 4),
	('1208302009', '120830', 'Tanjung Rapuan', 4),
	('1208302010', '120830', 'Pagar Bosi', 4),
	('1208302011', '120830', 'Bangun Sordang', 4),
	('1208302012', '120830', 'Aek Gerger Sidodadi', 4),
	('1208302013', '120830', 'Pulo Pitu Marihat', 4),
	('1208302014', '120830', 'Siringan Ringan', 4),
	('1208302015', '120830', 'Riah Na Poso', 4),
	('1208302016', '120830', 'Sei Merbau', 4),
	('1208302017', '120830', 'Kampung Lalang', 4),
	('1208302018', '120830', 'Sordang Baru', 4),
	('1208302019', '120830', 'Banjar Hulu', 4),
	('1208302020', '120830', 'Rawa Masin', 4),
	('1208312001', '120831', 'Ujung Saribu', 4),
	('1208312002', '120831', 'Silimakuta Barat', 4),
	('1208312003', '120831', 'Siboras', 4),
	('1208312004', '120831', 'Mardingding', 4),
	('1208312005', '120831', 'Naga Saribu', 4),
	('1208312007', '120831', 'Saribu Jandi', 4),
	('1208312008', '120831', 'Sinar Naga Mariah', 4),
	('1208312009', '120831', 'Ujung Mariah', 4),
	('1208312010', '120831', 'Bandar Saribu', 4),
	('1208312011', '120831', 'Naga Bosar', 4),
	('1209082002', '120908', 'Meranti', 4),
	('1209082004', '120908', 'Perkebunan Sei Balai', 4),
	('1209082011', '120908', 'Sei Beluru', 4),
	('1209082012', '120908', 'Serdang', 4),
	('1209082019', '120908', 'Gajah', 4),
	('1209082021', '120908', 'Air Putih', 4),
	('1209082022', '120908', 'Sukajadi', 4),
	('1209091001', '120909', 'Binjai Serbangan', 3),
	('1209092002', '120909', 'Air Joman', 4),
	('1209092003', '120909', 'Air Joman Baru', 4),
	('1209092005', '120909', 'Banjar', 4),
	('1209092007', '120909', 'Pasar Lembu', 4),
	('1209092008', '120909', 'Punggulan', 4),
	('1209092012', '120909', 'Subur', 4),
	('1209102001', '120910', 'Asahan Mati', 4),
	('1209102002', '120910', 'Bagan Asahan', 4),
	('1209102003', '120910', 'Bagan Asahan Baru', 4),
	('1209102004', '120910', 'Bagan Asahan Pekan', 4),
	('1209102005', '120910', 'Kapias Batu VIII', 4),
	('1209102006', '120910', 'Pematang Sei Baru', 4),
	('1209102007', '120910', 'Sei Apung', 4),
	('1209102008', '120910', 'Sei Apung Jaya', 4),
	('1209112008', '120911', 'Sei Kepayang Tengah', 4),
	('1209112010', '120911', 'Sei Kepayang Kanan', 4),
	('1209112011', '120911', 'Sei Paham', 4),
	('1209112014', '120911', 'Pertahanan', 4),
	('1209112015', '120911', 'Perbangunan', 4),
	('1209112016', '120911', 'Bangun Baru', 4),
	('1209122002', '120912', 'Perkebunan Suka Raja', 4),
	('1209122004', '120912', 'Perkebunan Hessa', 4),
	('1209122006', '120912', 'Sei Dua Hulu', 4),
	('1209122007', '120912', 'Sei Lama', 4),
	('1209122008', '120912', 'Silomlom', 4),
	('1209122009', '120912', 'Simpang Empat', 4),
	('1209122012', '120912', 'Sipaku Area', 4),
	('1209122013', '120912', 'Anjung Ganjang', 4),
	('1209132001', '120913', 'Sei Alim Ulu', 4),
	('1209132003', '120913', 'Pinanggiripan', 4),
	('1209132006', '120913', 'Perkebunan Pulahan', 4),
	('1209132007', '120913', 'Hessa Perlompongan', 4),
	('1209132008', '120913', 'Perkebunan Air Batu I/II', 4),
	('1209132009', '120913', 'Perkebunan Air Batu III/IV', 4),
	('1209132010', '120913', 'Danau Sijabut', 4),
	('1209132012', '120913', 'Air Teluk Hessa', 4),
	('1209132013', '120913', 'Air Ginting', 4),
	('1209132014', '120913', 'Hessa Air Genting', 4),
	('1209132018', '120913', 'Sijabut Teratai', 4),
	('1209132019', '120913', 'Pulau Pule', 4),
	('1209142001', '120914', 'Sei Piring', 4),
	('1209142002', '120914', 'Pulau Rakyat Tua', 4),
	('1209142003', '120914', 'Pulau Rakyat Pekan', 4),
	('1209142004', '120914', 'Orika', 4),
	('1209142005', '120914', 'Manis', 4),
	('1209142006', '120914', 'Tunggul', 4),
	('1209142007', '120914', 'Bangun', 4),
	('1209142008', '120914', 'Persatuan', 4),
	('1209142009', '120914', 'Padang Mahondang', 4),
	('1209142010', '120914', 'Ofa Padang Mahondang', 4),
	('1209142011', '120914', 'Baru', 4),
	('1209142012', '120914', 'Mekar Sari', 4),
	('1209152003', '120915', 'Bandar Pulau Pekan', 4),
	('1209152005', '120915', 'Buntu Maraja', 4),
	('1209152006', '120915', 'Gonting Malaha', 4),
	('1209152010', '120915', 'Padang Pulau', 4),
	('1209152012', '120915', 'Perkebunan Aek Tarum', 4),
	('1209152016', '120915', 'Perkebunan Padang Pulau', 4),
	('1209152019', '120915', 'Huta Rao', 4),
	('1209152020', '120915', 'Aek Nagali', 4),
	('1209152021', '120915', 'Gajah Sakti', 4),
	('1209152022', '120915', 'Gunung Berkat', 4),
	('1209162001', '120916', 'Ambalutu', 4),
	('1209162002', '120916', 'Buntu Pane', 4),
	('1209162003', '120916', 'Lestari', 4),
	('1209162005', '120916', 'Prapat Janji', 4),
	('1209162007', '120916', 'Sei Silau Timur', 4),
	('1209162016', '120916', 'Sionggang', 4),
	('1209162017', '120916', 'Mekar Sari', 4),
	('1209162018', '120916', 'Perkebunan Sei Silau', 4),
	('1209162019', '120916', 'Karya Ambalutu', 4),
	('1209172001', '120917', 'Bandar Pasir Mandoge', 4),
	('1209172002', '120917', 'Huta Bagasan', 4),
	('1209172003', '120917', 'Sei Nadoras', 4),
	('1209172004', '120917', 'Silau Jawa', 4),
	('1209172005', '120917', 'Suka Makmur', 4),
	('1209172006', '120917', 'Sei Kopas', 4),
	('1209172007', '120917', 'Huta Padang', 4),
	('1209172008', '120917', 'Tomuan Holbung', 4),
	('1209172009', '120917', 'Gotting Sidodadi', 4),
	('1209181001', '120918', 'Aek Loba Pekan', 3),
	('1209182002', '120918', 'Aek Loba Afdeling I', 4),
	('1209182003', '120918', 'Alang Bonbon', 4),
	('1209182009', '120918', 'Sengon Sari', 4),
	('1209182010', '120918', 'Lobu Jiur', 4),
	('1209182011', '120918', 'Rawa Sari', 4),
	('1209182013', '120918', 'Aek Loba', 4),
	('1209191001', '120919', 'Bunut', 3),
	('1209191002', '120919', 'Bunut Darat', 3),
	('1209191003', '120919', 'Dadi Mulyo', 3),
	('1209191004', '120919', 'Kisaran Barat', 3),
	('1209191005', '120919', 'Kisaran Baru', 3),
	('1209191006', '120919', 'Kisaran Kota', 3),
	('1209191007', '120919', 'Mekar Baru', 3),
	('1209191008', '120919', 'Sei Renggas', 3),
	('1209191009', '120919', 'Sendang Sari', 3),
	('1209191010', '120919', 'Sidodadi', 3),
	('1209191011', '120919', 'Sido Mukti', 3),
	('1209191012', '120919', 'Tebing Kisaran', 3),
	('1209191013', '120919', 'Tegal Sari', 3),
	('1209201001', '120920', 'Teladan', 3),
	('1209201002', '120920', 'Siumbut Umbut', 3),
	('1209201003', '120920', 'Siumbut Baru', 3),
	('1209201004', '120920', 'Sentang', 3),
	('1209201005', '120920', 'Selawan', 3),
	('1209201006', '120920', 'Mutiara', 3),
	('1209201007', '120920', 'Lestari', 3),
	('1209201008', '120920', 'Kisaran Timur', 3),
	('1209201009', '120920', 'Kisaran Naga', 3),
	('1209201010', '120920', 'Kedai Ledang', 3),
	('1209201011', '120920', 'Karang Anyer', 3),
	('1209201012', '120920', 'Gambir Baru', 3),
	('1209212001', '120921', 'Aek Songsongan', 4),
	('1209212002', '120921', 'Perkebunan Bandar Selamat', 4),
	('1209212003', '120921', 'Perkebunan Bandar Pulau', 4),
	('1209212004', '120921', 'Aek Bamban', 4),
	('1209212005', '120921', 'Marjanji Aceh', 4),
	('1209212006', '120921', 'Lobu Rappa', 4),
	('1209212007', '120921', 'Tangga', 4),
	('1209212008', '120921', 'Situnjak', 4),
	('1209212009', '120921', 'Mekar Marjanji', 4),
	('1209222001', '120922', 'Rahuning', 4),
	('1209222002', '120922', 'Perkebunan Gunung Melayu', 4),
	('1209222003', '120922', 'Gunung Melayu', 4),
	('1209222004', '120922', 'Batu Anam', 4),
	('1209222005', '120922', 'Perkebunan Aek Nagaga', 4),
	('1209222006', '120922', 'Rahuning I', 4),
	('1209222007', '120922', 'Rahuning II', 4),
	('1209232001', '120923', 'Tanjung Alam', 4),
	('1209232002', '120923', 'Perkebunan Sei Dadap I/II', 4),
	('1209232003', '120923', 'Perkebunan Sei Dadap III/IV', 4),
	('1209232004', '120923', 'Sei Kamah I', 4),
	('1209232005', '120923', 'Sei Kamah II', 4),
	('1209232006', '120923', 'Bahung Sibatu-batu', 4),
	('1209232007', '120923', 'Sei Alim Hasak', 4),
	('1209232008', '120923', 'Tanjung Asri', 4),
	('1209232009', '120923', 'Sei Kamah Baru', 4),
	('1209232010', '120923', 'Pasiran', 4),
	('1209242001', '120924', 'Sei Nangka', 4),
	('1209242002', '120924', 'Sei Jawi-Jawi', 4),
	('1209242003', '120924', 'Sei Serindan', 4),
	('1209242004', '120924', 'Sei Tualang Pandau', 4),
	('1209242005', '120924', 'Sei Lendir', 4),
	('1209242006', '120924', 'Sei Kepayang Kiri', 4),
	('1209252001', '120925', 'Sei Lunang', 4),
	('1209252002', '120925', 'Sei Pasir', 4),
	('1209252003', '120925', 'Sei Tempurung', 4),
	('1209252004', '120925', 'Sarang Helang', 4),
	('1209252005', '120925', 'Sei Sembilang', 4),
	('1209262001', '120926', 'Tinggi Raja', 4),
	('1209262002', '120926', 'Sumber Harapan', 4),
	('1209262003', '120926', 'Terusan Tengah', 4),
	('1209262004', '120926', 'Piasa Ulu', 4),
	('1209262005', '120926', 'Sido Mulyo', 4),
	('1209262006', '120926', 'Teladan', 4),
	('1209262007', '120926', 'Padang Sari', 4),
	('1209272001', '120927', 'Urung Pane', 4),
	('1209272002', '120927', 'Sei Silau Tua', 4),
	('1209272003', '120927', 'Sei Silau Barat', 4),
	('1209272004', '120927', 'Silau Maraja', 4),
	('1209272005', '120927', 'Bangun Sari', 4),
	('1209282001', '120928', 'Silo Baru', 4),
	('1209282002', '120928', 'Silo Lama', 4),
	('1209282003', '120928', 'Silo Bonto', 4),
	('1209282004', '120928', 'Lubuk Palas', 4),
	('1209282005', '120928', 'Bangun Sari', 4),
	('1209292001', '120929', 'Rawang Lama', 4),
	('1209292002', '120929', 'Rawang Baru', 4),
	('1209292003', '120929', 'Rawang Pasar IV', 4),
	('1209292004', '120929', 'Rawang Pasar V', 4),
	('1209292005', '120929', 'Pondok Bungur', 4),
	('1209292006', '120929', 'Panca Arga', 4),
	('1209292007', '120929', 'Rawang Pasar VI', 4),
	('1209302001', '120930', 'Suka Damai', 4),
	('1209302002', '120930', 'Perhutanan Silau', 4),
	('1209302003', '120930', 'Tanah Rakyat', 4),
	('1209302004', '120930', 'Taman Sari', 4),
	('1209302005', '120930', 'Gedangan', 4),
	('1209302006', '120930', 'Suka Makmur', 4),
	('1209302007', '120930', 'Pulo Bandring', 4),
	('1209302008', '120930', 'Sidomulyo', 4),
	('1209302009', '120930', 'Suka Damai Barat', 4),
	('1209302010', '120930', 'Bunut Seberang', 4),
	('1209312001', '120931', 'Air Teluk Kiri', 4),
	('1209312002', '120931', 'Teluk Dalam', 4),
	('1209312003', '120931', 'Perkebunan Teluk Dalam', 4),
	('1209312004', '120931', 'Pulau Maria', 4),
	('1209312005', '120931', 'Pulau Tanjung', 4),
	('1209312006', '120931', 'Mekar Tanjung', 4),
	('1209322001', '120932', 'Aek Bange', 4),
	('1209322002', '120932', 'Aek Korsik', 4),
	('1209322003', '120932', 'Aek Ledong', 4),
	('1209322004', '120932', 'Ledong Barat', 4),
	('1209322005', '120932', 'Aek Nabuntu', 4),
	('1209322006', '120932', 'Ledong Timur', 4),
	('1209322007', '120932', 'Padang Sipirok', 4),
	('1210011001', '121001', 'Padang Matinggi', 3),
	('1210011002', '121001', 'Siringo-Ringo', 3),
	('1210011003', '121001', 'Sirandorung', 3),
	('1210011004', '121001', 'Rantauprapat', 3),
	('1210011005', '121001', 'Kartini', 3),
	('1210011006', '121001', 'Cendana', 3),
	('1210011007', '121001', 'Binaraga', 3),
	('1210011008', '121001', 'Pulo Padang', 3),
	('1210011009', '121001', 'Padang Bulan', 3),
	('1210011010', '121001', 'Aek Paing', 3),
	('1210021001', '121002', 'Bakaran Batu', 3),
	('1210021002', '121002', 'Sioldengan', 3),
	('1210021003', '121002', 'Urung Kompas', 3),
	('1210021004', '121002', 'Ujung Bandar', 3),
	('1210021005', '121002', 'Sigambal', 3),
	('1210021006', '121002', 'Lobusona', 3),
	('1210021007', '121002', 'Pardamean', 3),
	('1210021008', '121002', 'Danau Bale', 3),
	('1210021009', '121002', 'Sidorejo', 3),
	('1210072001', '121007', 'Sibargot', 4),
	('1210072002', '121007', 'Bandar Kumbul', 4),
	('1210072003', '121007', 'Tanjung Medan', 4),
	('1210072004', '121007', 'Janji', 4),
	('1210072005', '121007', 'Tebing Linggahara', 4),
	('1210072006', '121007', 'AFD.I Rantauprapat', 4),
	('1210072007', '121007', 'AFD.II Rantauprapat', 4),
	('1210072008', '121007', 'Aek Buru Selatan', 4),
	('1210072009', '121007', 'Kampung Baru', 4),
	('1210072010', '121007', 'Tb Linggahara Baru', 4),
	('1210081001', '121008', 'Negeri Lama', 3),
	('1210081002', '121008', 'Negeri Baru', 3),
	('1210082003', '121008', 'Perk. Sennah', 4),
	('1210082004', '121008', 'Perk. Negeri Lama', 4),
	('1210082005', '121008', 'Perk. Bilah', 4),
	('1210082006', '121008', 'Kampung Bilah', 4),
	('1210082007', '121008', 'Negeri Lama Seberang', 4),
	('1210082008', '121008', 'Sei Tampang', 4),
	('1210082009', '121008', 'Selat Besar', 4),
	('1210082010', '121008', 'Tanjung Haloban', 4),
	('1210082011', '121008', 'Sidomulyo', 4),
	('1210082012', '121008', 'Sei Tarolat', 4),
	('1210082013', '121008', 'Sei Kasih', 4),
	('1210092001', '121009', 'Lingga Tiga', 4),
	('1210092002', '121009', 'Tanjung Siram', 4),
	('1210092003', '121009', 'Pematang Seleng', 4),
	('1210092004', '121009', 'Perbaungan', 4),
	('1210092005', '121009', 'Gunung Selamat', 4),
	('1210092006', '121009', 'Emplasemen Aek Nabara', 4),
	('1210092007', '121009', 'Bandar Tinggi', 4),
	('1210092008', '121009', 'Kampung Dalam', 4),
	('1210092009', '121009', 'Pondok Batu', 4),
	('1210092010', '121009', 'Meranti', 4),
	('1210092011', '121009', 'N- Aek Nabara', 4),
	('1210092012', '121009', 'N- Aek Nabara', 4),
	('1210092013', '121009', 'N- Aek Nabara', 4),
	('1210092014', '121009', 'N- Aek Nabara', 4),
	('1210092015', '121009', 'N- Aek Nabara', 4),
	('1210092016', '121009', 'N- Aek Nabara', 4),
	('1210092017', '121009', 'N- Aek Nabara', 4),
	('1210092018', '121009', 'N- Aek Nabara', 4),
	('1210092019', '121009', 'S- Aek Nabara', 4),
	('1210092020', '121009', 'S- Aek Nabara', 4),
	('1210092021', '121009', 'S- Aek Nabara', 4),
	('1210092022', '121009', 'S- Aek Nabara', 4),
	('1210092023', '121009', 'S- Aek Nabara', 4),
	('1210092024', '121009', 'S- Aek Nabara', 4),
	('1210142001', '121014', 'Sidorukun', 4),
	('1210142002', '121014', 'Tebing Tinggi Pangkatan', 4),
	('1210142003', '121014', 'Perkebunan Pangkatan', 4),
	('1210142004', '121014', 'Kampung Padang', 4),
	('1210142005', '121014', 'Pangkatan', 4),
	('1210142006', '121014', 'Sennah', 4),
	('1210142007', '121014', 'Tanjung Harapan', 4),
	('1210181001', '121018', 'Labuhan Bilik', 3),
	('1210182002', '121018', 'Sei Pelancang', 4),
	('1210182003', '121018', 'Sei Siarti', 4),
	('1210182004', '121018', 'Sei Nahodaris', 4),
	('1210182005', '121018', 'Sei Merdeka', 4),
	('1210182006', '121018', 'Sei Rakyat', 4),
	('1210182007', '121018', 'Selat Beting', 4),
	('1210182008', '121018', 'Bagan Bilah', 4),
	('1210182009', '121018', 'Telaga Suka', 4),
	('1210182010', '121018', 'Pasar Tiga', 4),
	('1210191001', '121019', 'Sei Brombang', 3),
	('1210192002', '121019', 'Sei Penggantungan', 4),
	('1210192003', '121019', 'Sei Lumut', 4),
	('1210192004', '121019', 'Sei Tawar', 4),
	('1210192005', '121019', 'Sei Sanggul', 4),
	('1210192006', '121019', 'Sei Sakat', 4),
	('1210192007', '121019', 'Sei Baru', 4),
	('1210192008', '121019', 'Wonosari', 4),
	('1210202001', '121020', 'Tanjung Sarang Elang', 4),
	('1210202002', '121020', 'Perk. Ajamu', 4),
	('1210202003', '121020', 'Teluk Sentosa', 4),
	('1210202004', '121020', 'Cinta Makmur', 4),
	('1210202005', '121020', 'Sei Sentosa', 4),
	('1210202006', '121020', 'Meranti Paham', 4),
	('1210202007', '121020', 'Sijawi-jawi', 4),
	('1211011005', '121101', 'Kuta Gambir', 3),
	('1211011007', '121101', 'Sidiangkat', 3),
	('1211011009', '121101', 'Batang Beruh', 3),
	('1211011010', '121101', 'Sidikalang', 3),
	('1211011015', '121101', 'Bintang Hulu', 3),
	('1211012008', '121101', 'Blang Malum', 4),
	('1211012011', '121101', 'Huta Rakyat', 4),
	('1211012012', '121101', 'Kalang', 4),
	('1211012013', '121101', 'Bintang', 4),
	('1211012014', '121101', 'Kalang Simbara', 4),
	('1211021007', '121102', 'Pagagan Julu I', 3),
	('1211022001', '121102', 'Pagagan Julu X', 4),
	('1211022002', '121102', 'Pagagan Julu IX', 4),
	('1211022003', '121102', 'Pagagan Julu VIII', 4),
	('1211022004', '121102', 'Pagagan Julu VII', 4),
	('1211022005', '121102', 'Pagagan Julu VI', 4),
	('1211022006', '121102', 'Pagagan Julu V', 4),
	('1211022008', '121102', 'Pagagan Julu IV', 4),
	('1211022009', '121102', 'Pagagan Julu III', 4),
	('1211022010', '121102', 'Pagagan Julu II', 4),
	('1211022014', '121102', 'Tanjung Beringin', 4),
	('1211022015', '121102', 'Dolok Tolong', 4),
	('1211022017', '121102', 'Pargambiran', 4),
	('1211022018', '121102', 'Perjuangan', 4),
	('1211022020', '121102', 'Kuta Gugung', 4),
	('1211032001', '121103', 'Sumbul Tengah', 4),
	('1211032002', '121103', 'Ujung Teran', 4),
	('1211032003', '121103', 'Juma Gerat', 4),
	('1211032004', '121103', 'Sarintonu', 4),
	('1211032005', '121103', 'Tigalingga', 4),
	('1211032006', '121103', 'Palding', 4),
	('1211032007', '121103', 'Lau Bagot', 4),
	('1211032008', '121103', 'Bertungen Julu', 4),
	('1211032009', '121103', 'Lau Molgap', 4),
	('1211032010', '121103', 'Lau Pak-Pak', 4),
	('1211032012', '121103', 'Sukandebi', 4),
	('1211032013', '121103', 'Lau Mil', 4),
	('1211032014', '121103', 'Lau Sireme', 4),
	('1211032019', '121103', 'Polding Jaya Sumbul', 4),
	('1211042001', '121104', 'Sinampang', 4),
	('1211042002', '121104', 'Sihorbo', 4),
	('1211042003', '121104', 'Soban', 4),
	('1211042004', '121104', 'Adian Nangka', 4),
	('1211042005', '121104', 'Bunturaja', 4),
	('1211042006', '121104', 'Juma Siulok', 4),
	('1211042007', '121104', 'Juma Teguh', 4),
	('1211042008', '121104', 'Sosor Lontung', 4),
	('1211042009', '121104', 'Huta Imbaru', 4),
	('1211042010', '121104', 'Jumantuang', 4),
	('1211042011', '121104', 'Gomit', 4),
	('1211051014', '121105', 'Parongil', 3),
	('1211052008', '121105', 'Palipi', 4),
	('1211052010', '121105', 'Longkotan', 4),
	('1211052011', '121105', 'Bongkaras', 4),
	('1211052012', '121105', 'Tungtung Batu', 4),
	('1211052013', '121105', 'Polling Anak-Anak', 4),
	('1211052015', '121105', 'Siratah', 4),
	('1211052016', '121105', 'Urik Belin', 4),
	('1211052017', '121105', 'Siboras', 4),
	('1211052018', '121105', 'Bonian', 4),
	('1211052019', '121105', 'Sumbari', 4),
	('1211052020', '121105', 'Bakal Gajah', 4),
	('1211052021', '121105', 'Lae Panginuman', 4),
	('1211052022', '121105', 'Lae Ambat', 4),
	('1211052023', '121105', 'Lae Rambong', 4),
	('1211062001', '121106', 'Suka Dame', 4),
	('1211062002', '121106', 'Gunung Tua', 4),
	('1211062003', '121106', 'Harapan', 4),
	('1211062004', '121106', 'Lau Primbon', 4),
	('1211062005', '121106', 'Kuta Gambir', 4),
	('1211062006', '121106', 'Kempawa', 4),
	('1211062007', '121106', 'Tanah Pinem', 4),
	('1211062008', '121106', 'Pamah', 4),
	('1211062009', '121106', 'Kutabuluh', 4),
	('1211062010', '121106', 'Pasir Tengah', 4),
	('1211062011', '121106', 'Renun', 4),
	('1211062012', '121106', 'Lau Tawar', 4),
	('1211072001', '121107', 'Tambahan', 4),
	('1211072002', '121107', 'Kuta Tengah', 4),
	('1211072003', '121107', 'Lae Nuaha', 4),
	('1211072004', '121107', 'Sungai Raya', 4),
	('1211072005', '121107', 'Gunung Meriah', 4),
	('1211072006', '121107', 'Silumboyah', 4),
	('1211072007', '121107', 'Pandan', 4),
	('1211072008', '121107', 'Tualang', 4),
	('1211072009', '121107', 'Pangaribuan', 4),
	('1211072010', '121107', 'Sigambir-gambir', 4),
	('1211072011', '121107', 'Bakal Julu', 4),
	('1211072012', '121107', 'Sipoltong', 4),
	('1211082001', '121108', 'Lae Itam', 4),
	('1211082002', '121108', 'Lae Luhung', 4),
	('1211082003', '121108', 'Pardomuan', 4),
	('1211082004', '121108', 'Lae Markelang', 4),
	('1211082005', '121108', 'Jambur Indonesia', 4),
	('1211082006', '121108', 'Simungun', 4),
	('1211082007', '121108', 'Janji', 4),
	('1211082008', '121108', 'Sopobutar', 4),
	('1211082009', '121108', 'Lae Saring', 4),
	('1211092001', '121109', 'Simanduma', 4),
	('1211092002', '121109', 'Bandar Huta Usang', 4),
	('1211092003', '121109', 'Onan Lama', 4),
	('1211092004', '121109', 'Lingga Raja', 4),
	('1211092005', '121109', 'Laksa', 4),
	('1211092006', '121109', 'Tanjung Saluksuk', 4),
	('1211092007', '121109', 'Bukittinggi', 4),
	('1211102001', '121110', 'Bangun', 4),
	('1211102002', '121110', 'Lae Hole', 4),
	('1211102003', '121110', 'Parbuluan IV', 4),
	('1211102004', '121110', 'Parbuluan III', 4),
	('1211102005', '121110', 'Parbuluan II', 4),
	('1211102006', '121110', 'Parbuluan I', 4),
	('1211102007', '121110', 'Parbuluan V', 4),
	('1211102008', '121110', 'Parbuluan VI', 4),
	('1211112001', '121111', 'Sumbul', 4),
	('1211112002', '121111', 'Kentara', 4),
	('1211112003', '121111', 'Lae Parira', 4),
	('1211112004', '121111', 'Bulu Duri', 4),
	('1211112005', '121111', 'Sempung Polling', 4),
	('1211112006', '121111', 'Lumban Sihite', 4),
	('1211112007', '121111', 'Lumban Toruan', 4),
	('1211112008', '121111', 'Pandiangan', 4),
	('1211122001', '121112', 'Bukit Lau Kersik', 4),
	('1211122002', '121112', 'Gunung Sitember', 4),
	('1211122003', '121112', 'Batu Gun-Gun', 4),
	('1211122004', '121112', 'Rante Besi', 4),
	('1211122005', '121112', 'Gundaling', 4),
	('1211122006', '121112', 'Kendit Liang', 4),
	('1211122007', '121112', 'Lau Lebah', 4),
	('1211122008', '121112', 'Tupak Raja', 4),
	('1211132001', '121113', 'Sambaliang', 4),
	('1211132002', '121113', 'Pasi', 4),
	('1211132003', '121113', 'Banjartoba', 4),
	('1211132004', '121113', 'Brampu', 4),
	('1211132005', '121113', 'Karing', 4),
	('1211142001', '121114', 'Silalahi II', 4),
	('1211142002', '121114', 'Silalahi I', 4),
	('1211142003', '121114', 'Paropo', 4),
	('1211142004', '121114', 'Silalahi III', 4),
	('1211151004', '121115', 'Panji Dabutar', 3),
	('1211152001', '121115', 'Sitinjo', 4),
	('1211152002', '121115', 'Sitinjo I', 4),
	('1211152003', '121115', 'Sitinjo II', 4),
	('1212011034', '121201', 'Balige I', 3),
	('1212011035', '121201', 'Balige III', 3),
	('1212011036', '121201', 'Pardede Onan', 3),
	('1212011037', '121201', 'Sangkar Nihuta', 3),
	('1212011038', '121201', 'Lumban Dolok Hauma Bange', 3),
	('1212011039', '121201', 'Napitupulu Bagasan', 3),
	('1212012003', '121201', 'Hutanamora', 4),
	('1212012004', '121201', 'Hutagaol Peatalun', 4),
	('1212012005', '121201', 'Hinalang Bagasan', 4),
	('1212012006', '121201', 'Matio', 4),
	('1212012007', '121201', 'Lumban Pea', 4),
	('1212012008', '121201', 'Hutabulu Mejan', 4),
	('1212012010', '121201', 'Lumban Gaol', 4),
	('1212012011', '121201', 'Parsuratan', 4),
	('1212012012', '121201', 'Baruara', 4),
	('1212012013', '121201', 'Aek Bolon Julu', 4),
	('1212012014', '121201', 'Sibolahotang SAS', 4),
	('1212012015', '121201', 'Lumban Bulbul', 4),
	('1212012016', '121201', 'Sianipar Sihailhail', 4),
	('1212012017', '121201', 'Silalahi Pagar Batu', 4),
	('1212012018', '121201', 'Lumban Silintong', 4),
	('1212012019', '121201', 'Saribu Raja Janji Maria', 4),
	('1212012022', '121201', 'Longat', 4),
	('1212012023', '121201', 'Balige II', 4),
	('1212012024', '121201', 'Aek Bolon Jae', 4),
	('1212012025', '121201', 'Lumban Gorat', 4),
	('1212012026', '121201', 'Sibuntuon', 4),
	('1212012027', '121201', 'Siboruon', 4),
	('1212012028', '121201', 'Paindoan', 4),
	('1212012029', '121201', 'Bonan Dolok I', 4),
	('1212012030', '121201', 'Bonan Dolok II', 4),
	('1212012031', '121201', 'Bonan Dolok III', 4),
	('1212012032', '121201', 'Huta Dame', 4),
	('1212012040', '121201', 'Lumban Pea Timur', 4),
	('1212012041', '121201', 'Tambunan Sunge', 4),
	('1212021001', '121202', 'Pasar Laguboti', 3),
	('1212022002', '121202', 'Sibuea', 4),
	('1212022003', '121202', 'Sintong Marnipi', 4),
	('1212022004', '121202', 'Sibarani Nasampulu/Namungk', 4),
	('1212022005', '121202', 'Aruan', 4),
	('1212022006', '121202', 'Sidulang', 4),
	('1212022007', '121202', 'Ujung Tanduk', 4),
	('1212022008', '121202', 'Haunatas II', 4),
	('1212022009', '121202', 'Pardomuan Nauli', 4),
	('1212022010', '121202', 'Sitangkola', 4),
	('1212022011', '121202', 'Tinggir Nipasir', 4),
	('1212022012', '121202', 'Haunatas I', 4),
	('1212022013', '121202', 'Pintu Bosi', 4),
	('1212022014', '121202', 'Simatibung', 4),
	('1212022015', '121202', 'Lumban Binanga', 4),
	('1212022016', '121202', 'Ompu Raja Hutapea', 4),
	('1212022017', '121202', 'Gasaribu', 4),
	('1212022018', '121202', 'Pardinggaran', 4),
	('1212022019', '121202', 'Sitoluama', 4),
	('1212022020', '121202', 'Lumban Bagasan', 4),
	('1212022021', '121202', 'Siraja Gorat', 4),
	('1212022022', '121202', 'Ompu Raja Hutapea Timur', 4),
	('1212022023', '121202', 'Ompu Raja Hatulian', 4),
	('1212032001', '121203', 'Pintu Batu', 4),
	('1212032002', '121203', 'Sitorang', 4),
	('1212032003', '121203', 'Parsambilan', 4),
	('1212032004', '121203', 'Huta Gur- Gur II', 4),
	('1212032005', '121203', 'Silaen', 4),
	('1212032006', '121203', 'Ombur', 4),
	('1212032008', '121203', 'Natolutali', 4),
	('1212032009', '121203', 'Dalihan Natolu', 4),
	('1212032010', '121203', 'Sigodang Tua', 4),
	('1212032014', '121203', 'Sinta Dame', 4),
	('1212032015', '121203', 'Hutanamora', 4),
	('1212032017', '121203', 'Pardomuan', 4),
	('1212032018', '121203', 'Huta Gur-Gur I', 4),
	('1212032022', '121203', 'Lumban Dolok', 4),
	('1212032023', '121203', 'Napitupulu', 4),
	('1212032024', '121203', 'Hutagaol Sihujur', 4),
	('1212032025', '121203', 'Meranti Barat', 4),
	('1212032026', '121203', 'Sibide Barat', 4),
	('1212032027', '121203', 'Sibide', 4),
	('1212032028', '121203', 'Simanobak', 4),
	('1212032029', '121203', 'Panindi', 4),
	('1212032030', '121203', 'Siringkiron', 4),
	('1212032031', '121203', 'Marbulang', 4),
	('1212041009', '121204', 'Parsoburan Tengah', 3),
	('1212042002', '121204', 'Lumban Rau Selatan', 4),
	('1212042004', '121204', 'Lumban Rau Barat', 4),
	('1212042006', '121204', 'Lumban Balik', 4),
	('1212042007', '121204', 'Panamparan', 4),
	('1212042008', '121204', 'Lumban Pinasa', 4),
	('1212042010', '121204', 'Parsoburan Barat', 4),
	('1212042011', '121204', 'Lumban Ruhap', 4),
	('1212042012', '121204', 'Lumban Pea', 4),
	('1212042014', '121204', 'Hitetano', 4),
	('1212042017', '121204', 'Lobu Hole', 4),
	('1212042018', '121204', 'Batu Nabolon', 4),
	('1212042019', '121204', 'Lumban Gaol', 4),
	('1212042020', '121204', 'Tornagodang', 4),
	('1212042021', '121204', 'Taon Marisi', 4),
	('1212042022', '121204', 'Pagar Batu', 4),
	('1212042023', '121204', 'Sibuntuon', 4),
	('1212042024', '121204', 'Pararungan', 4),
	('1212042025', '121204', 'Lumban Lintong', 4),
	('1212042026', '121204', 'Pangunjungan', 4),
	('1212042027', '121204', 'Lumban Pinasa Saroba', 4),
	('1212042028', '121204', 'Aek Ulok', 4),
	('1212052001', '121205', 'Meranti Utara', 4),
	('1212052002', '121205', 'Meranti Timur', 4),
	('1212052003', '121205', 'Meranti Tengah', 4),
	('1212052007', '121205', 'Pintu Pohan', 4),
	('1212052008', '121205', 'Ambar Halim', 4),
	('1212052009', '121205', 'Pintu Pohan Dolok', 4),
	('1212052010', '121205', 'Halado', 4),
	('1212062001', '121206', 'Natumingka', 4),
	('1212062002', '121206', 'Pangururan', 4),
	('1212062003', '121206', 'Pardomuan Nauli', 4),
	('1212062004', '121206', 'Lintong', 4),
	('1212062005', '121206', 'Rianiate', 4),
	('1212062006', '121206', 'Aek Unsim', 4),
	('1212062007', '121206', 'Purba Tua', 4),
	('1212062008', '121206', 'Janji Maria', 4),
	('1212062009', '121206', 'Pangururan II', 4),
	('1212062010', '121206', 'Pangururan III', 4),
	('1212062011', '121206', 'Hutagurgur', 4),
	('1212062012', '121206', 'Simare', 4),
	('1212062013', '121206', 'Lumban Sewa', 4),
	('1212062014', '121206', 'Riganjang', 4),
	('1212062015', '121206', 'Pasar Borbor', 4),
	('1212071037', '121207', 'Pasar Porsea', 3),
	('1212071038', '121207', 'Patane III', 3),
	('1212071039', '121207', 'Parparean III', 3),
	('1212072001', '121207', 'Patane IV', 4),
	('1212072003', '121207', 'Lumban Gurning', 4),
	('1212072004', '121207', 'Amborgang', 4),
	('1212072005', '121207', 'Nalela', 4),
	('1212072007', '121207', 'Patane II', 4),
	('1212072022', '121207', 'Gala Gala Pangkailan', 4),
	('1212072023', '121207', 'Silamosik I', 4),
	('1212072030', '121207', 'Parparean IV', 4),
	('1212072031', '121207', 'Parparean I', 4),
	('1212072033', '121207', 'Parparean II', 4),
	('1212072036', '121207', 'Patane I', 4),
	('1212072040', '121207', 'Patane V', 4),
	('1212072041', '121207', 'Simpang Sigura-Gura', 4),
	('1212072042', '121207', 'Raut Bosi', 4),
	('1212081009', '121208', 'Parsaoran Ajibata', 3),
	('1212082001', '121208', 'Sigapiton', 4),
	('1212082002', '121208', 'Pardomuan Ajibata', 4),
	('1212082003', '121208', 'Pardamean Ajibata', 4),
	('1212082004', '121208', 'Motung', 4),
	('1212082005', '121208', 'Horsik', 4),
	('1212082006', '121208', 'Sirunkkungon', 4),
	('1212082007', '121208', 'Parsaoran Sibisa', 4),
	('1212082008', '121208', 'Pardamean Sibisa', 4),
	('1212082010', '121208', 'Pardomuan Motung', 4),
	('1212092002', '121209', 'Lintong Julu', 4),
	('1212092003', '121209', 'Hatinggian', 4),
	('1212092004', '121209', 'Sibaruang', 4),
	('1212092005', '121209', 'Jangga Toruan', 4),
	('1212092006', '121209', 'Sionggang Selatan', 4),
	('1212092007', '121209', 'Pasar Lumban Julu', 4),
	('1212092008', '121209', 'Sionggang Utara', 4),
	('1212092014', '121209', 'Sionggang Tengah', 4),
	('1212092015', '121209', 'Jangga Dolok', 4),
	('1212092016', '121209', 'Hutanamora', 4),
	('1212092017', '121209', 'Jonggi Nihuta', 4),
	('1212092018', '121209', 'Aek Natolu Jaya', 4),
	('1212102001', '121210', 'Dolok Saribu Janji Matogu', 4),
	('1212102002', '121210', 'Dolok Nagodang', 4),
	('1212102003', '121210', 'Lumban Binanga', 4),
	('1212102004', '121210', 'Partoruan Janji Matogu', 4),
	('1212102005', '121210', 'Parhabinsaran Janji Matogu', 4),
	('1212102006', '121210', 'Parik', 4),
	('1212102007', '121210', 'Sibuntuon', 4),
	('1212102008', '121210', 'Sigaol Barat', 4),
	('1212102009', '121210', 'Marom', 4),
	('1212102010', '121210', 'Sigaol Timur', 4),
	('1212102012', '121210', 'Siregar Aek Nalas', 4),
	('1212102014', '121210', 'Lumban Holbung', 4),
	('1212102015', '121210', 'Parbagasan Janji Matogu', 4),
	('1212102017', '121210', 'Lumban Nabolon', 4),
	('1212102018', '121210', 'Sampuara', 4),
	('1212102019', '121210', 'Dolok Saribu Lumban Nabolon', 4),
	('1212191007', '121219', 'Sigumpar Dangsina', 3),
	('1212192001', '121219', 'Marsangap', 4),
	('1212192002', '121219', 'Nauli', 4),
	('1212192003', '121219', 'Situa-tua', 4),
	('1212192004', '121219', 'Sigumpar', 4),
	('1212192005', '121219', 'Maju', 4),
	('1212192006', '121219', 'Dolok Jiur', 4),
	('1212192008', '121219', 'Sigumpar Julu', 4),
	('1212192009', '121219', 'Sigumpar Barat', 4),
	('1212192010', '121219', 'Banua Huta', 4),
	('1212202001', '121220', 'Narumonda I', 4),
	('1212202002', '121220', 'Narumonda II', 4),
	('1212202003', '121220', 'Narumonda III', 4),
	('1212202004', '121220', 'Narumonda IV', 4),
	('1212202005', '121220', 'Narumonda V', 4),
	('1212202006', '121220', 'Narumonda VI', 4),
	('1212202007', '121220', 'Narumonda VII', 4),
	('1212202008', '121220', 'Narumonda VIII', 4),
	('1212202009', '121220', 'Siantar Sitio Tio', 4),
	('1212202010', '121220', 'Siantar Dangsina', 4),
	('1212202011', '121220', 'Siantar Tonga-tonga I', 4),
	('1212202012', '121220', 'Siantar Tonga-Tonga II', 4),
	('1212202013', '121220', 'Siantar Sigordang', 4),
	('1212202014', '121220', 'Siantar Tonga-Tonga III', 4),
	('1212212001', '121221', 'Lumban Rau Tengah', 4),
	('1212212002', '121221', 'Lumban Rau Timur', 4),
	('1212212003', '121221', 'Lumban Rau Utara', 4),
	('1212212004', '121221', 'Sipagabu', 4),
	('1212212005', '121221', 'Napajoring', 4),
	('1212212006', '121221', 'Liat Tondung', 4),
	('1212212007', '121221', 'Batu Manumpak', 4),
	('1212212008', '121221', 'Lumban Rau Tenggara', 4),
	('1212212009', '121221', 'Cinta Damai', 4),
	('1212212010', '121221', 'Siantarasa', 4),
	('1212222001', '121222', 'Lintong Nihuta', 4),
	('1212222002', '121222', 'Tarabunga', 4),
	('1212222003', '121222', 'Meat', 4),
	('1212222004', '121222', 'Gurgur Aek Raja', 4),
	('1212222005', '121222', 'Tangga Batu Barat', 4),
	('1212222006', '121222', 'Tangga Batu Timur', 4),
	('1212232001', '121223', 'Sihiong', 4),
	('1212232002', '121223', 'Sinar Sabungan', 4),
	('1212232003', '121223', 'Lumban Lobu', 4),
	('1212232004', '121223', 'Harungguan', 4),
	('1212232005', '121223', 'Naga Timbul', 4),
	('1212232006', '121223', 'Sibadihon', 4),
	('1212232007', '121223', 'Silamosik II', 4),
	('1212232011', '121223', 'Partoruan Lumban Lobu', 4),
	('1212232012', '121223', 'Pardolok Lumban Lobu', 4),
	('1212232013', '121223', 'Silombu', 4),
	('1212232014', '121223', 'Lumban Sangkalan', 4),
	('1212232015', '121223', 'Nagatimbul Timur', 4),
	('1212242001', '121224', 'Siantar Utara', 4),
	('1212242002', '121224', 'Lumban Sitorus', 4),
	('1212242003', '121224', 'Banjar Ganjang', 4),
	('1212242004', '121224', 'Tangga Batu I', 4),
	('1212242005', '121224', 'Tangga Batu II', 4),
	('1212242006', '121224', 'Pangombusan', 4),
	('1212242007', '121224', 'Jonggi Manulus', 4),
	('1212242008', '121224', 'Lumban Huala', 4),
	('1212242009', '121224', 'Dolok Nauli', 4),
	('1212242010', '121224', 'Bius Gu Barat', 4),
	('1212242011', '121224', 'Lumban Manurung', 4),
	('1213011011', '121301', 'Kota Siantar', 3),
	('1213011014', '121301', 'Kayu Jati', 3),
	('1213011022', '121301', 'Pasar Hilir', 3),
	('1213011023', '121301', 'Pidoli Dolok', 3),
	('1213011031', '121301', 'Panyabungan II', 3),
	('1213011032', '121301', 'Panyabungan III', 3),
	('1213011033', '121301', 'Panyabungan I', 3),
	('1213011035', '121301', 'Sipolu-Polu', 3),
	('1213011036', '121301', 'Dalan Lidang', 3),
	('1213012001', '121301', 'Adian Jior', 4),
	('1213012002', '121301', 'Aek Banir', 4),
	('1213012003', '121301', 'Aek Mata', 4),
	('1213012004', '121301', 'Darussalam', 4),
	('1213012005', '121301', 'Gunung Barani', 4),
	('1213012006', '121301', 'Gunung Manaon', 4),
	('1213012007', '121301', 'Gunung Tua Jae', 4),
	('1213012008', '121301', 'Gunung Tua Julu', 4),
	('1213012009', '121301', 'Gunung Tua Tonga', 4),
	('1213012010', '121301', 'Huta Lombang Lubis', 4),
	('1213012012', '121301', 'Ipar Bondar', 4),
	('1213012013', '121301', 'Kampung Padang', 4),
	('1213012015', '121301', 'Lumban Pasir', 4),
	('1213012016', '121301', 'Manyabar', 4),
	('1213012017', '121301', 'Pagaran Tonga', 4),
	('1213012018', '121301', 'Panyabungan Jae', 4),
	('1213012019', '121301', 'Panyabungan Julu', 4),
	('1213012020', '121301', 'Panyabungan Tonga', 4),
	('1213012021', '121301', 'Perbangunan', 4),
	('1213012024', '121301', 'Pidoli Lombang', 4),
	('1213012025', '121301', 'Salam Bue', 4),
	('1213012026', '121301', 'Sarak Matua', 4),
	('1213012027', '121301', 'Sigalapang Julu', 4),
	('1213012028', '121301', 'Siobon Julu', 4),
	('1213012029', '121301', 'Sipapaga', 4),
	('1213012030', '121301', 'Sopobatu', 4),
	('1213012037', '121301', 'Siobon Jae', 4),
	('1213012038', '121301', 'Panggorengan', 4),
	('1213012039', '121301', 'Saba Jambu', 4),
	('1213012040', '121301', 'Manyabar Jae', 4),
	('1213021012', '121302', 'Mompang Jae', 3),
	('1213022002', '121302', 'Beringin Jaya', 4),
	('1213022007', '121302', 'Huta damai', 4),
	('1213022008', '121302', 'Jambur Padang Matinggi', 4),
	('1213022009', '121302', 'Kampung Baru', 4),
	('1213022010', '121302', 'Mompang Julu', 4),
	('1213022014', '121302', 'Rumbio', 4),
	('1213022015', '121302', 'Suka Ramai', 4),
	('1213022017', '121302', 'Sopo Sorik', 4),
	('1213022018', '121302', 'Simanondong', 4),
	('1213022019', '121302', 'Torbanua Raja', 4),
	('1213022020', '121302', 'Tanjung Mompang', 4),
	('1213022023', '121302', 'Binanga', 4),
	('1213022024', '121302', 'Hutanaingkan', 4),
	('1213031002', '121303', 'Gunung Baringin', 3),
	('1213032001', '121303', 'Aek Nabara', 4),
	('1213032003', '121303', 'Hutaimbaru', 4),
	('1213032004', '121303', 'Huta Bangun', 4),
	('1213032005', '121303', 'Huta Tinggi', 4),
	('1213032006', '121303', 'Pagur', 4),
	('1213032007', '121303', 'Pardomuan', 4),
	('1213032008', '121303', 'Parmompang', 4),
	('1213032009', '121303', 'Ranto Natas', 4),
	('1213032010', '121303', 'Sirangkap', 4),
	('1213032011', '121303', 'Tanjung', 4),
	('1213032012', '121303', 'Tebing Tinggi', 4),
	('1213032013', '121303', 'Tanjung Julu', 4),
	('1213032014', '121303', 'Banjar Lancat', 4),
	('1213032015', '121303', 'Padang Laru', 4),
	('1213041009', '121304', 'Tano Bato', 3),
	('1213042001', '121304', 'Aek Ngali', 4),
	('1213042002', '121304', 'Hutarimbaru', 4),
	('1213042003', '121304', 'Hayuraja', 4),
	('1213042004', '121304', 'Huta Julu', 4),
	('1213042005', '121304', 'Kayu Laut', 4),
	('1213042006', '121304', 'Lumban Dolok', 4),
	('1213042007', '121304', 'Roburan Dolok', 4),
	('1213042008', '121304', 'Roburan Lombang', 4),
	('1213042010', '121304', 'Huta Raja', 4),
	('1213042011', '121304', 'Pagaran Gala-Gala', 4),
	('1213051006', '121305', 'Longat', 3),
	('1213052001', '121305', 'Barbaran', 4),
	('1213052002', '121305', 'Barbaran Jae', 4),
	('1213052003', '121305', 'Batang Gadis', 4),
	('1213052004', '121305', 'Huta Baringin', 4),
	('1213052005', '121305', 'Huta Tonga BB', 4),
	('1213052007', '121305', 'Runding', 4),
	('1213052008', '121305', 'Sirambas', 4),
	('1213052009', '121305', 'Saba Jior', 4),
	('1213052010', '121305', 'Batang Gadis Jae', 4),
	('1213061014', '121306', 'Siabu', 3),
	('1213061023', '121306', 'Simangambat', 3),
	('1213062001', '121306', 'Aek Mual', 4),
	('1213062002', '121306', 'Bonan Dolok', 4),
	('1213062003', '121306', 'Huta Raja', 4),
	('1213062004', '121306', 'Huta Puli', 4),
	('1213062005', '121306', 'Huta Baringin', 4),
	('1213062006', '121306', 'Huta Godang Muda', 4),
	('1213062007', '121306', 'Huraba I', 4),
	('1213062008', '121306', 'Huraba II', 4),
	('1213062009', '121306', 'Lumban Pinasa', 4),
	('1213062010', '121306', 'Lumban Dolok', 4),
	('1213062011', '121306', 'Muara Btg. Angkola', 4),
	('1213062012', '121306', 'Pintu Padang Jae', 4),
	('1213062013', '121306', 'Pintu Padang Julu', 4),
	('1213062015', '121306', 'Sibaruang', 4),
	('1213062016', '121306', 'Sihepeng', 4),
	('1213062017', '121306', 'Simaninggir', 4),
	('1213062018', '121306', 'Sinonoan', 4),
	('1213062019', '121306', 'Tangga Bosi II', 4),
	('1213062020', '121306', 'Tanjung Sialang', 4),
	('1213062021', '121306', 'Tangga Bosi I', 4),
	('1213062022', '121306', 'Tangga Bosi III', 4),
	('1213062024', '121306', 'Sihepeng Sada', 4),
	('1213062025', '121306', 'Sihepeng Dua', 4),
	('1213062026', '121306', 'Sihepeng Tolu', 4),
	('1213062027', '121306', 'Sihepeng Opat', 4),
	('1213062028', '121306', 'Sihepeng Lima', 4),
	('1213072001', '121307', 'Bange', 4),
	('1213072003', '121307', 'Huta Bangun', 4),
	('1213072005', '121307', 'Janji Matogu', 4),
	('1213072006', '121307', 'Malintang Jae', 4),
	('1213072007', '121307', 'Malintang Julu', 4),
	('1213072008', '121307', 'Pasar Baru Malintang', 4),
	('1213072010', '121307', 'Sidojadi', 4),
	('1213072013', '121307', 'Lambou Darul Ihsan', 4),
	('1213072014', '121307', 'Huta Bangun Jae', 4),
	('1213072015', '121307', 'Bange Nauli', 4),
	('1213072016', '121307', 'Malintang', 4),
	('1213081032', '121308', 'Tamiang', 3),
	('1213081036', '121308', 'Pasar Kotanopan', 3),
	('1213082001', '121308', 'Batahan', 4),
	('1213082002', '121308', 'Botung', 4),
	('1213082003', '121308', 'Gading Bain', 4),
	('1213082004', '121308', 'Gunung Tua MS', 4),
	('1213082005', '121308', 'Gunung Tua SM', 4),
	('1213082006', '121308', 'Hutapuli', 4),
	('1213082007', '121308', 'Huta Padang MS', 4),
	('1213082008', '121308', 'Hutarimbaru SM', 4),
	('1213082009', '121308', 'Huta Baringin TB', 4),
	('1213082010', '121308', 'Huta Pungkut Jae', 4),
	('1213082011', '121308', 'Huta Pungkut Tonga', 4),
	('1213082012', '121308', 'Huta Pungkut Julu', 4),
	('1213082013', '121308', 'Huta Dangka', 4),
	('1213082014', '121308', 'Muara Potan', 4),
	('1213082015', '121308', 'Muara Siambak', 4),
	('1213082016', '121308', 'Manambin', 4),
	('1213082017', '121308', 'Muara Pungkut', 4),
	('1213082018', '121308', 'Muara Botung', 4),
	('1213082019', '121308', 'Pagar Gunung', 4),
	('1213082020', '121308', 'Padang Bulan', 4),
	('1213082021', '121308', 'Patialo', 4),
	('1213082022', '121308', 'Saba Dolok', 4),
	('1213082023', '121308', 'Singengu Jae', 4),
	('1213082024', '121308', 'Singengu Julu', 4),
	('1213082025', '121308', 'Sayur Maincat', 4),
	('1213082026', '121308', 'Simpang Tolang Jae', 4),
	('1213082027', '121308', 'Simpang Tolang Julu', 4),
	('1213082028', '121308', 'Sibio Bio', 4),
	('1213082029', '121308', 'Sopo Sorik', 4),
	('1213082030', '121308', 'Simandolam', 4),
	('1213082031', '121308', 'Tombang Bustak', 4),
	('1213082033', '121308', 'Tobang', 4),
	('1213082034', '121308', 'Ujung Marisi', 4),
	('1213082035', '121308', 'Usor Tolang', 4),
	('1213082037', '121308', 'Muara Saladi', 4),
	('1213091008', '121309', 'Pasar Maga', 3),
	('1213092001', '121309', 'Aek Marian MG', 4),
	('1213092002', '121309', 'Bangun Purba', 4),
	('1213092003', '121309', 'Maga Lombang', 4),
	('1213092004', '121309', 'Maga Dolok', 4),
	('1213092005', '121309', 'Purba Baru', 4),
	('1213092006', '121309', 'Purba Lamo', 4),
	('1213092007', '121309', 'Pangkat', 4),
	('1213092009', '121309', 'Siantona', 4),
	('1213101010', '121310', 'Laru Lombang', 3),
	('1213102001', '121310', 'Angin Barat', 4),
	('1213102006', '121310', 'Huta Tonga AB', 4),
	('1213102007', '121310', 'Laru Baringin', 4),
	('1213102008', '121310', 'Laru Bolak', 4),
	('1213102009', '121310', 'Laru Dolok', 4),
	('1213102011', '121310', 'Lumban Pasir', 4),
	('1213102012', '121310', 'Muara Mais', 4),
	('1213102013', '121310', 'Muara Mais Jambur', 4),
	('1213102014', '121310', 'Padang Sanggar', 4),
	('1213102015', '121310', 'Panjaringan', 4),
	('1213102016', '121310', 'Pasar Laru', 4),
	('1213102017', '121310', 'Pastap', 4),
	('1213102018', '121310', 'Pastap Julu', 4),
	('1213102020', '121310', 'Rao Rao Dolok', 4),
	('1213102021', '121310', 'Rao Rao Lombang', 4),
	('1213102025', '121310', 'Simangambat TB', 4),
	('1213102026', '121310', 'Tambangan Jae', 4),
	('1213102027', '121310', 'Tambangan Pasoman', 4),
	('1213102028', '121310', 'Tambangan Tonga', 4),
	('1213111003', '121311', 'Huta Godang', 3),
	('1213112001', '121311', 'Alahan Kae', 4),
	('1213112002', '121311', 'Habincaran', 4),
	('1213112004', '121311', 'Huta Padang UP', 4),
	('1213112005', '121311', 'Hutaimbaru UP', 4),
	('1213112007', '121311', 'Patahajang', 4),
	('1213112008', '121311', 'Simpang Banyak Jae', 4),
	('1213112009', '121311', 'Simpang Banyak Julu', 4),
	('1213112010', '121311', 'Simpang Duhu Dolok', 4),
	('1213112011', '121311', 'Simpang Duhu Lombang', 4),
	('1213112012', '121311', 'Simpang Pining', 4),
	('1213112013', '121311', 'Tolang', 4),
	('1213121019', '121312', 'Pasar Muara Sipongi', 3),
	('1213122001', '121312', 'Bandar Panjang', 4),
	('1213122002', '121312', 'Bandar Panjang Tuo', 4),
	('1213122007', '121312', 'Kampung Pinang', 4),
	('1213122008', '121312', 'Koto Baringin', 4),
	('1213122009', '121312', 'Limau Manis', 4),
	('1213122012', '121312', 'Ranjo Batu', 4),
	('1213122013', '121312', 'Sibinail', 4),
	('1213122015', '121312', 'Simpang Mandepo', 4),
	('1213122016', '121312', 'Tamiang Mudo', 4),
	('1213122017', '121312', 'Tanjung Alai', 4),
	('1213122020', '121312', 'Tanjung Medan', 4),
	('1213122021', '121312', 'Muara Kumpulan', 4),
	('1213122022', '121312', 'Aek Botung', 4),
	('1213122023', '121312', 'Koto Boru', 4),
	('1213122024', '121312', 'Tanjung Larangan', 4),
	('1213131017', '121313', 'Muara Soma', 3),
	('1213132001', '121313', 'Aek Guo', 4),
	('1213132002', '121313', 'Aek Holbung', 4),
	('1213132003', '121313', 'Aek Manggis', 4),
	('1213132004', '121313', 'Aek Nabara', 4),
	('1213132005', '121313', 'Aek Nangali', 4),
	('1213132006', '121313', 'Ampung Julu', 4),
	('1213132007', '121313', 'Ampung Padang', 4),
	('1213132008', '121313', 'Ampung Siala', 4),
	('1213132009', '121313', 'Bangkelang', 4),
	('1213132010', '121313', 'Banjar Malayu', 4),
	('1213132011', '121313', 'Batu Madinding', 4),
	('1213132012', '121313', 'Bulu Soma', 4),
	('1213132013', '121313', 'Guo Batu', 4),
	('1213132014', '121313', 'Hadangkahan', 4),
	('1213132015', '121313', 'Hatupangan', 4),
	('1213132016', '121313', 'Muara Parlampungan', 4),
	('1213132018', '121313', 'Rantobi', 4),
	('1213132019', '121313', 'Rao Rao', 4),
	('1213132020', '121313', 'Simanguntong', 4),
	('1213132021', '121313', 'Sipogu', 4),
	('1213132022', '121313', 'Sopo Tinjak', 4),
	('1213132023', '121313', 'Tarlola', 4),
	('1213132024', '121313', 'Tombang Taluang', 4),
	('1213132025', '121313', 'Huta Lobu', 4),
	('1213132026', '121313', 'Lubuk Samboa', 4),
	('1213132027', '121313', 'Jambur Baru', 4),
	('1213132028', '121313', 'Aek Baru Jae', 4),
	('1213132029', '121313', 'Aek Baru Julu', 4),
	('1213132030', '121313', 'Lubuk Bondar Panjang', 4),
	('1213132031', '121313', 'Tor Naincat', 4),
	('1213141024', '121314', 'Simpang Gambir', 3),
	('1213141028', '121314', 'Tapus', 3),
	('1213142001', '121314', 'Aek Garingging', 4),
	('1213142002', '121314', 'Aek Manyuruk', 4),
	('1213142003', '121314', 'Bandar Limabung', 4),
	('1213142006', '121314', 'Lancat', 4),
	('1213142010', '121314', 'Kampung Baru', 4),
	('1213142011', '121314', 'Lobung', 4),
	('1213142014', '121314', 'Pangkalan', 4),
	('1213142015', '121314', 'Perk. Simpang Gambir', 4),
	('1213142019', '121314', 'Sikumbu', 4),
	('1213142021', '121314', 'Simpang Bajole', 4),
	('1213142022', '121314', 'Simpang Duku', 4),
	('1213142023', '121314', 'Simpang Durian', 4),
	('1213142025', '121314', 'Simpang Koje', 4),
	('1213142029', '121314', 'Dalan Lidang', 4),
	('1213142031', '121314', 'Bonca Bayuon', 4),
	('1213142033', '121314', 'Padang Silojongan', 4),
	('1213142034', '121314', 'Perbatasan', 4),
	('1213142035', '121314', 'Tangsi Atas', 4),
	('1213151011', '121315', 'Pasar Baru Batahan', 3),
	('1213152001', '121315', 'Banjar Aur', 4),
	('1213152003', '121315', 'Batahan I', 4),
	('1213152004', '121315', 'Batu Sondat', 4),
	('1213152005', '121315', 'Bintungan Bejangkar', 4),
	('1213152007', '121315', 'Kampung Kapas', 4),
	('1213152008', '121315', 'Kuala Batahan', 4),
	('1213152009', '121315', 'Kubangan Tompek', 4),
	('1213152010', '121315', 'Muara Pertemuan', 4),
	('1213152012', '121315', 'Pasar Batahan', 4),
	('1213152013', '121315', 'Pulau Tamang', 4),
	('1213152014', '121315', 'Sari Kenanga Batahan', 4),
	('1213152019', '121315', 'Batahan II', 4),
	('1213152020', '121315', 'Batahan III', 4),
	('1213152021', '121315', 'Batahan IV', 4),
	('1213152022', '121315', 'Sinunukan VI', 4),
	('1213152023', '121315', 'Kampung Kapas I', 4),
	('1213152024', '121315', 'Kubangan Pandan Sari', 4),
	('1213161008', '121316', 'Pasar II Natal', 3),
	('1213161025', '121316', 'Pasar I Natal', 3),
	('1213162001', '121316', 'Balimbing', 4),
	('1213162002', '121316', 'Bintuas', 4),
	('1213162003', '121316', 'Bonda Kase', 4),
	('1213162004', '121316', 'Buburan', 4),
	('1213162005', '121316', 'Kampung Sawah', 4),
	('1213162006', '121316', 'Panggautan', 4),
	('1213162007', '121316', 'Pardamean Baru', 4),
	('1213162009', '121316', 'Pasar III Natal', 4),
	('1213162010', '121316', 'Pasar V Natal', 4),
	('1213162011', '121316', 'Patiluban Hilir', 4),
	('1213162012', '121316', 'Patiluban Mudik', 4),
	('1213162013', '121316', 'Perkebunan Patiluban', 4),
	('1213162014', '121316', 'Rukun Jaya', 4),
	('1213162015', '121316', 'Setia Karya', 4),
	('1213162016', '121316', 'Sikara Kara', 4),
	('1213162017', '121316', 'Sikara Kara I', 4),
	('1213162018', '121316', 'Sikara Kara II', 4),
	('1213162019', '121316', 'Sikara Kara III', 4),
	('1213162020', '121316', 'Sikara Kara IV', 4),
	('1213162021', '121316', 'Sundutan Tigo', 4),
	('1213162022', '121316', 'Taluk', 4),
	('1213162023', '121316', 'Tegal Sari', 4),
	('1213162024', '121316', 'Tunas Karya', 4),
	('1213162026', '121316', 'Pasar VI Natal', 4),
	('1213162027', '121316', 'Sinunukan V', 4),
	('1213162028', '121316', 'Suka Maju', 4),
	('1213162029', '121316', 'Sasaran', 4),
	('1213162030', '121316', 'Kun-Kun', 4),
	('1213172001', '121317', 'Batu Mundom', 4),
	('1213172002', '121317', 'Hutaimbaru', 4),
	('1213172003', '121317', 'Lubuk Kapundung', 4),
	('1213172004', '121317', 'Manuncang', 4),
	('1213172005', '121317', 'Panunggulan', 4),
	('1213172006', '121317', 'Pasar Singkuang I', 4),
	('1213172007', '121317', 'Pasar Singkuang II', 4),
	('1213172008', '121317', 'Rantau Panjang', 4),
	('1213172009', '121317', 'Sikapas', 4),
	('1213172010', '121317', 'Tabuyung', 4),
	('1213172011', '121317', 'Tagilang Julu', 4),
	('1213172012', '121317', 'Sali Baru', 4),
	('1213172013', '121317', 'Lubuk Kapundung II', 4),
	('1213172014', '121317', 'Suka Makmur', 4),
	('1213182001', '121318', 'Manisak', 4),
	('1213182002', '121318', 'Simpang Talap', 4),
	('1213182003', '121318', 'Sampuran', 4),
	('1213182004', '121318', 'Tandikek', 4),
	('1213182005', '121318', 'Gonting', 4),
	('1213182006', '121318', 'Bangun Saroha', 4),
	('1213182007', '121318', 'Huta Baringin', 4),
	('1213182008', '121318', 'Muara Bangko', 4),
	('1213182009', '121318', 'Ranto Nalinjang', 4),
	('1213182010', '121318', 'Banjar Maga', 4),
	('1213182011', '121318', 'Huta Raja', 4),
	('1213182012', '121318', 'Simaninggir', 4),
	('1213182013', '121318', 'Ranto Panjang', 4),
	('1213182014', '121318', 'Huta Nauli', 4),
	('1213182015', '121318', 'Lubuk Kancah', 4),
	('1213182016', '121318', 'Dua Sepakat', 4),
	('1213182017', '121318', 'Gunung Godang', 4),
	('1213192001', '121319', 'Bangun Sejati', 4),
	('1213192002', '121319', 'Hutarimbaru', 4),
	('1213192003', '121319', 'Pasar Huta Bargot', 4),
	('1213192004', '121319', 'Huta Bargot Lombang', 4),
	('1213192005', '121319', 'Huta Bargot Dolok', 4),
	('1213192006', '121319', 'Huta Bargot Setia', 4),
	('1213192007', '121319', 'Huta Bargot Nauli', 4),
	('1213192008', '121319', 'Mondan', 4),
	('1213192009', '121319', 'Sayur Maincat', 4),
	('1213192010', '121319', 'Kumpulan Setia', 4),
	('1213192011', '121319', 'Simalagi', 4),
	('1213192012', '121319', 'Saba Padang', 4),
	('1213202001', '121320', 'Huta Lombang', 4),
	('1213202002', '121320', 'Huta Baru', 4),
	('1213202003', '121320', 'Handel', 4),
	('1213202004', '121320', 'Hutatinggi', 4),
	('1213202005', '121320', 'Hutanamale', 4),
	('1213202006', '121320', 'Hutabaringin Julu', 4),
	('1213202007', '121320', 'Sibanggor Jae', 4),
	('1213202008', '121320', 'Sibanggor Tonga', 4),
	('1213202009', '121320', 'Sibanggor Julu', 4),
	('1213202010', '121320', 'Purba Julu', 4),
	('1213202011', '121320', 'Huta Baringin', 4),
	('1213212001', '121321', 'Pakantan Dolok', 4),
	('1213212002', '121321', 'Pakantan Lombang', 4),
	('1213212003', '121321', 'Huta Gambir', 4),
	('1213212004', '121321', 'Huta Lancat', 4),
	('1213212005', '121321', 'Huta Julu', 4),
	('1213212006', '121321', 'Huta Toras', 4),
	('1213212007', '121321', 'Huta Padang', 4),
	('1213212008', '121321', 'Silogun', 4),
	('1213222001', '121322', 'Sinunukan I', 4),
	('1213222002', '121322', 'Sinunukan II', 4),
	('1213222003', '121322', 'Sinunukan III', 4),
	('1213222004', '121322', 'Sinunukan IV', 4),
	('1213222005', '121322', 'Bintungan Bejangkar Baru', 4),
	('1213222006', '121322', 'Banjar Aur Utara', 4),
	('1213222007', '121322', 'Kampung Kapas II', 4),
	('1213222008', '121322', 'Airapa', 4),
	('1213222009', '121322', 'Sido Makmur', 4),
	('1213222010', '121322', 'Wido Daren', 4),
	('1213222011', '121322', 'Wono Sari', 4),
	('1213222012', '121322', 'Suka Damai', 4),
	('1213222013', '121322', 'Pasir Putih', 4),
	('1213222014', '121322', 'Sinunukan I Central', 4),
	('1213232001', '121323', 'Tambiski', 4),
	('1213232002', '121323', 'Tarutung Panjang', 4),
	('1213232003', '121323', 'Humbang I', 4),
	('1213232004', '121323', 'Banua Rakyat', 4),
	('1213232005', '121323', 'Sayur Matua', 4),
	('1213232006', '121323', 'Banua Sima Nosor', 4),
	('1213232007', '121323', 'Tambiski Nauli', 4),
	('1214012002', '121401', 'Hilisangowola', 4),
	('1214012005', '121401', 'Hiliotalua', 4),
	('1214012006', '121401', 'Koendrafo', 4),
	('1214012008', '121401', 'Lawa-Lawa Luo', 4),
	('1214012016', '121401', 'Tuhemberua', 4),
	('1214012017', '121401', 'Tesikhori', 4),
	('1214012021', '121401', 'Tumari', 4),
	('1214012023', '121401', 'Ewo', 4),
	('1214012024', '121401', 'Ko\'olotano', 4),
	('1214012026', '121401', 'Botohili Ndruria', 4),
	('1214012027', '121401', 'Caritas Sogawunasi', 4),
	('1214012028', '121401', 'Orudua Lawa-Lawa Lou', 4),
	('1214012029', '121401', 'Hilifaondrato', 4),
	('1214022005', '121402', 'Doli Doli Idano Tae', 4),
	('1214022006', '121402', 'Fanedanu', 4),
	('1214022007', '121402', 'Hiliana\'a Gomo', 4),
	('1214022008', '121402', 'Hilimbowo Idano Tae', 4),
	('1214022015', '121402', 'Lawa-Lawa Luo Gomo', 4),
	('1214022016', '121402', 'Lahusa Idano Tae', 4),
	('1214022017', '121402', 'Lolosoni', 4),
	('1214022018', '121402', 'Lawa Lawa Luoidano Tae', 4),
	('1214022023', '121402', 'Orahili Gomo', 4),
	('1214022024', '121402', 'Sifaoroasi Gomo', 4),
	('1214022026', '121402', 'Sirahia', 4),
	('1214022031', '121402', 'Umbu Idano Tae', 4),
	('1214022035', '121402', 'Tanoniko\'o', 4),
	('1214022036', '121402', 'Dao-dao Zanuwo Idano Tae', 4),
	('1214022037', '121402', 'Orahua', 4),
	('1214022038', '121402', 'Hiliserangkai', 4),
	('1214022039', '121402', 'Fanedanu Sibohou', 4),
	('1214022040', '121402', 'Suka Maju Mohili', 4),
	('1214022041', '121402', 'Orahili Sibohou', 4),
	('1214022042', '121402', 'Gununggabungan', 4),
	('1214022043', '121402', 'Umbu Orahua', 4),
	('1214022044', '121402', 'Sisiwa Ewali', 4),
	('1214022045', '121402', 'Sisarahili Ewo', 4),
	('1214022046', '121402', 'Hilialo\'oa', 4),
	('1214022047', '121402', 'Damai', 4),
	('1214022048', '121402', 'Awoni', 4),
	('1214022049', '121402', 'Hilisalo\'o', 4),
	('1214022050', '121402', 'Balombaruzo Orahua', 4),
	('1214022051', '121402', 'Harefa Orahua', 4),
	('1214022052', '121402', 'Hiligabungan', 4),
	('1214022053', '121402', 'Buhawa', 4),
	('1214032001', '121403', 'Bawolato', 4),
	('1214032002', '121403', 'Bawozihono', 4),
	('1214032003', '121403', 'Bawootalua', 4),
	('1214032004', '121403', 'Golambanua I', 4),
	('1214032007', '121403', 'Hilisimaetano', 4),
	('1214032009', '121403', 'Lahusa', 4),
	('1214032014', '121403', 'Tetezou', 4),
	('1214032016', '121403', 'Orahili Balaekha', 4),
	('1214032017', '121403', 'Harenoro', 4),
	('1214032018', '121403', 'Sarahililaza', 4),
	('1214032024', '121403', 'Hiliabolata', 4),
	('1214032025', '121403', 'Hiligambukha', 4),
	('1214032026', '121403', 'Sinar Baru Darodaro', 4),
	('1214032027', '121403', 'Hiliorudua', 4),
	('1214032032', '121403', 'Hilizomboi', 4),
	('1214032036', '121403', 'Oikhoda Balaekha', 4),
	('1214032037', '121403', 'Angorudua Balaekha', 4),
	('1214032038', '121403', 'Hilinawalo Balaekha', 4),
	('1214032039', '121403', 'Sobawagoli', 4),
	('1214032040', '121403', 'Lahusa Satu', 4),
	('1214032041', '121403', 'Hiliwatema', 4),
	('1214032042', '121403', 'Mogae', 4),
	('1214032043', '121403', 'Sinar Baho', 4),
	('1214042001', '121404', 'Duru', 4),
	('1214042002', '121404', 'Tuwaso', 4),
	('1214042003', '121404', 'Hilioromao', 4),
	('1214042004', '121404', 'Eho', 4),
	('1214042005', '121404', 'Sialema', 4),
	('1214042006', '121404', 'Bawonifaoso', 4),
	('1214042007', '121404', 'Hilianombasela', 4),
	('1214042008', '121404', 'Lumbui Melayu', 4),
	('1214042009', '121404', 'Hiliarudua Tebolo', 4),
	('1214042010', '121404', 'Tebolo Melayu', 4),
	('1214042021', '121404', 'Lumbui Nias', 4),
	('1214042022', '121404', 'Baruyu Sibohou', 4),
	('1214042023', '121404', 'Sepakat', 4),
	('1214042024', '121404', 'Tano Mokinu', 4),
	('1214042025', '121404', 'Hilikana', 4),
	('1214042026', '121404', 'Hilinifaese', 4),
	('1214042027', '121404', 'Omega', 4),
	('1214051046', '121405', 'Pasar Pulau Telo', 3),
	('1214052001', '121405', 'Hiliotalua', 4),
	('1214052002', '121405', 'Bawodobara', 4),
	('1214052003', '121405', 'Bawoamahelato', 4),
	('1214052004', '121405', 'Bawoomasio', 4),
	('1214052005', '121405', 'Loboi', 4),
	('1214052006', '121405', 'Hilimaodula', 4),
	('1214052007', '121405', 'Baruyu Lasara', 4),
	('1214052008', '121405', 'Sifitu Ewali', 4),
	('1214052009', '121405', 'Rapa-Rapa Melayu', 4),
	('1214052010', '121405', 'Sinauru', 4),
	('1214052011', '121405', 'Siofaewali', 4),
	('1214052012', '121405', 'Simaluaya', 4),
	('1214052013', '121405', 'Silimaewali', 4),
	('1214052014', '121405', 'Sidua Ewali', 4),
	('1214052027', '121405', 'Balogia', 4),
	('1214052029', '121405', 'Lasondre', 4),
	('1214052041', '121405', 'Koto', 4),
	('1214052048', '121405', 'Onaya', 4),
	('1214052049', '121405', 'Sisarahili', 4),
	('1214052051', '121405', 'Sebuasi', 4),
	('1214052054', '121405', 'Orahili', 4),
	('1214061008', '121406', 'Pasar Teluk Dalam', 3),
	('1214062006', '121406', 'Hiligeho', 4),
	('1214062007', '121406', 'Hilitobara', 4),
	('1214062009', '121406', 'Bawo Nifaoso', 4),
	('1214062010', '121406', 'Bawoza\'ua', 4),
	('1214062011', '121406', 'Hiliganowo', 4),
	('1214062021', '121406', 'Hilifalago', 4),
	('1214062022', '121406', 'Hilifarono', 4),
	('1214062023', '121406', 'Bawo Dobara', 4),
	('1214062024', '121406', 'Bawo Lowalani', 4),
	('1214062025', '121406', 'Hilisa\'otoniha', 4),
	('1214062026', '121406', 'Hililsondrekha', 4),
	('1214062027', '121406', 'Hilimondregeraya', 4),
	('1214062028', '121406', 'Hilinamozaua', 4),
	('1214062040', '121406', 'Hiliamuri', 4),
	('1214062041', '121406', 'Hilionaha', 4),
	('1214062042', '121406', 'Hiliana\'a', 4),
	('1214062043', '121406', 'Hiliganowo Salo\'o', 4),
	('1214062044', '121406', 'Ganowo Saua', 4),
	('1214062045', '121406', 'Nanowa', 4),
	('1214062046', '121406', 'Hililaza', 4),
	('1214062047', '121406', 'Hilikara', 4),
	('1214062048', '121406', 'Hilialito Saua', 4),
	('1214062049', '121406', 'Hilinamozaua Raya', 4),
	('1214062050', '121406', 'Hilifalago Raya', 4),
	('1214062051', '121406', 'Hilisanekhehosi', 4),
	('1214072004', '121407', 'Sifaoro\'asi', 4),
	('1214072005', '121407', 'Hilihoro', 4),
	('1214072006', '121407', 'Hilimbulawa', 4),
	('1214072008', '121407', 'Tu\' Indrao', 4),
	('1214072009', '121407', 'Hilimbowo', 4),
	('1214072011', '121407', 'Sisarahili', 4),
	('1214072012', '121407', 'Lolozasai', 4),
	('1214072013', '121407', 'Lolomoyo', 4),
	('1214072014', '121407', 'Hilifadolo', 4),
	('1214072015', '121407', 'Orahili Eho', 4),
	('1214072016', '121407', 'Sisobahili', 4),
	('1214072023', '121407', 'Loloabolo', 4),
	('1214072024', '121407', 'Hilisalo\'o', 4),
	('1214072026', '121407', 'Sirofi', 4),
	('1214072027', '121407', 'Hilindraso', 4),
	('1214072028', '121407', 'Hilimaera', 4),
	('1214072029', '121407', 'Boholu', 4),
	('1214072030', '121407', 'Amandraya', 4),
	('1214072031', '121407', 'Sinar Ino\'o', 4),
	('1214072032', '121407', 'Tuindrao Satu', 4),
	('1214072033', '121407', 'Tuhemberua Amandraya', 4),
	('1214082001', '121408', 'Amuri', 4),
	('1214082004', '121408', 'Bawosaloo Sowalawa', 4),
	('1214082009', '121408', 'Hilifadolo', 4),
	('1214082014', '121408', 'Lolofaoso', 4),
	('1214082015', '121408', 'Lolomoyo', 4),
	('1214082016', '121408', 'Lolowa\'u', 4),
	('1214082017', '121408', 'Lolohowa', 4),
	('1214082022', '121408', 'Sisarahili Ekholo', 4),
	('1214082030', '121408', 'Tuhegafoa', 4),
	('1214082033', '121408', 'Botohili', 4),
	('1214082035', '121408', 'Hilikara', 4),
	('1214082044', '121408', 'Samiri', 4),
	('1214082047', '121408', 'Hilimbowo Siwalawa', 4),
	('1214082048', '121408', 'Nituwu Boho', 4),
	('1214092001', '121409', 'Sifalago Susua', 4),
	('1214092002', '121409', 'Orahili Susua', 4),
	('1214092003', '121409', 'Hiliana\'a Susua', 4),
	('1214092004', '121409', 'Hiliorahua', 4),
	('1214092005', '121409', 'Hilimboe', 4),
	('1214092006', '121409', 'Hilimboho', 4),
	('1214092008', '121409', 'Hiliwaebu', 4),
	('1214092009', '121409', 'Hilidanayao', 4),
	('1214092010', '121409', 'Hilizamurugo', 4),
	('1214092011', '121409', 'Sisobahili', 4),
	('1214092012', '121409', 'Dao-dao Zanuwo', 4),
	('1214092013', '121409', 'Hiliorudua', 4),
	('1214092014', '121409', 'Bintang Baru', 4),
	('1214092015', '121409', 'Hilitobara Susua', 4),
	('1214092016', '121409', 'Orahua Uluzoi', 4),
	('1214092017', '121409', 'Hilisibohou', 4),
	('1214092018', '121409', 'Hiliadulosoi', 4),
	('1214092019', '121409', 'Orahili Bo\'e', 4),
	('1214102001', '121410', 'Hilisimaetano', 4),
	('1214102002', '121410', 'Bawogosali', 4),
	('1214102003', '121410', 'Hilifalawu', 4),
	('1214102004', '121410', 'Hilimaenamolo', 4),
	('1214102005', '121410', 'Samadaya Hilisimaetano', 4),
	('1214102006', '121410', 'Idala Jaya', 4),
	('1214102007', '121410', 'Pekan Hilisimaetano', 4),
	('1214102008', '121410', 'Bonia Hilisimaetano', 4),
	('1214102009', '121410', 'Ndraso Hilisimaetano', 4),
	('1214102010', '121410', 'Faomasi Hilisimaetano', 4),
	('1214102011', '121410', 'Eho Hilisimaetano', 4),
	('1214102012', '121410', 'Soto\'o Hilisimaetano', 4);
INSERT INTO `kelurahan` (`id_kel`, `id_kec`, `nama`, `id_jenis`) VALUES
	('1214102013', '121410', 'Hiliaurifa Hilisimaetano', 4),
	('1214102014', '121410', 'Bawomaenamolo', 4),
	('1214102015', '121410', 'Bawohosi Maniamolo', 4),
	('1214102016', '121410', 'Bawosaodano', 4),
	('1214112001', '121411', 'Togizita', 4),
	('1214112002', '121411', 'Soledua', 4),
	('1214112003', '121411', 'Bawasalo\'o Dao-dao', 4),
	('1214112004', '121411', 'Tuho Owo', 4),
	('1214112005', '121411', 'Togozita Satu', 4),
	('1214112007', '121411', 'Hilitoese', 4),
	('1214112008', '121411', 'Dao-dao Sowo', 4),
	('1214112009', '121411', 'Hiliadulo', 4),
	('1214112010', '121411', 'Soledua Satu', 4),
	('1214112011', '121411', 'Soledua Dua', 4),
	('1214122001', '121412', 'Hilisataro', 4),
	('1214122002', '121412', 'Hilinamoniha', 4),
	('1214122003', '121412', 'Hiliamaetaluo', 4),
	('1214122004', '121412', 'Bawoganowo', 4),
	('1214122005', '121412', 'Hilialawa', 4),
	('1214122006', '121412', 'Hilindrasoniha', 4),
	('1214122007', '121412', 'Hilimagari', 4),
	('1214122008', '121412', 'Hilisataro Raya', 4),
	('1214122009', '121412', 'Hilisataro Gewa', 4),
	('1214122010', '121412', 'Hilisoromi', 4),
	('1214122011', '121412', 'Hiliasi', 4),
	('1214122012', '121412', 'Hilindraso Raya', 4),
	('1214122013', '121412', 'Hilisataro Nandisa', 4),
	('1214122014', '121412', 'Hilisataro Eho Sofayo', 4),
	('1214132001', '121413', 'Hilizalo\'otano', 4),
	('1214132002', '121413', 'Hilinawalo Mazino', 4),
	('1214132003', '121413', 'Lawindra', 4),
	('1214132004', '121413', 'Bawolahusa', 4),
	('1214132005', '121413', 'Hilizoroilawa', 4),
	('1214132006', '121413', 'Hilizalo\'otano Laowo', 4),
	('1214132007', '121413', 'Hilizalo\'otano Larono', 4),
	('1214132008', '121413', 'Hililaza Hilinawalo Mazino', 4),
	('1214132009', '121413', 'Hilifondege Hilizoroilawa', 4),
	('1214132010', '121413', 'Lolomboli', 4),
	('1214132011', '121413', 'Bawolahusa Doli-doli', 4),
	('1214142001', '121414', 'Lawindra', 4),
	('1214142002', '121414', 'Lolozukhu', 4),
	('1214142003', '121414', 'Sifaoroasi Mola', 4),
	('1214142004', '121414', 'Hiliuso', 4),
	('1214142005', '121414', 'Balohili Mola', 4),
	('1214142006', '121414', 'Ambukha', 4),
	('1214142007', '121414', 'Tobualo', 4),
	('1214142008', '121414', 'Hilibadalu', 4),
	('1214142009', '121414', 'Foikhugaga', 4),
	('1214142010', '121414', 'Orlin', 4),
	('1214142011', '121414', 'Orahili Mola', 4),
	('1214142012', '121414', 'Umbunasi', 4),
	('1214142013', '121414', 'Silima Banua Umbunasi', 4),
	('1214142014', '121414', 'Sindrolo', 4),
	('1214152001', '121415', 'Hilitatao', 4),
	('1214152002', '121415', 'Hiliorudua', 4),
	('1214152003', '121415', 'Sisobambowo', 4),
	('1214152004', '121415', 'Hiliamozula', 4),
	('1214152005', '121415', 'Aramo', 4),
	('1214152006', '121415', 'Sikhorilafau', 4),
	('1214152007', '121415', 'Hilifadolo', 4),
	('1214152008', '121415', 'Hume', 4),
	('1214152009', '121415', 'Dao-dao', 4),
	('1214152010', '121415', 'Hilimagiao', 4),
	('1214152011', '121415', 'Hilisawato', 4),
	('1214152012', '121415', 'Baohao', 4),
	('1214152013', '121415', 'Hiligafoa', 4),
	('1214152014', '121415', 'Hilimbowo', 4),
	('1214152015', '121415', 'Hilimezaya', 4),
	('1214152016', '121415', 'Hiliadolowa', 4),
	('1214152017', '121415', 'Hiligumbu', 4),
	('1214152018', '121415', 'Bagoa', 4),
	('1214162001', '121416', 'Labuan Hiu', 4),
	('1214162002', '121416', 'Labuan Bajau', 4),
	('1214162003', '121416', 'Labuan Rima', 4),
	('1214162004', '121416', 'Lambak', 4),
	('1214162005', '121416', 'Bais', 4),
	('1214162006', '121416', 'Mahang Labara', 4),
	('1214162007', '121416', 'Adam', 4),
	('1214162008', '121416', 'Labara', 4),
	('1214162009', '121416', 'Bais Baru', 4),
	('1214162010', '121416', 'Labuan Rima Baru', 4),
	('1214172001', '121417', 'Tetegawa\'ai', 4),
	('1214172002', '121417', 'Hilimbaruzo', 4),
	('1214172003', '121417', 'Luahandroito', 4),
	('1214172005', '121417', 'Orahuahili', 4),
	('1214172006', '121417', 'Ulu Mazo', 4),
	('1214172007', '121417', 'Guigui', 4),
	('1214172009', '121417', 'Hilimaufa', 4),
	('1214172010', '121417', 'Siofabanua', 4),
	('1214172011', '121417', 'Tetegawa\'ai Ehomo', 4),
	('1214172013', '121417', 'Tafulu', 4),
	('1214182001', '121418', 'Bawomataluo', 4),
	('1214182002', '121418', 'Orahili Fau', 4),
	('1214182003', '121418', 'Bawonahono', 4),
	('1214182004', '121418', 'Hiliamaetaniha', 4),
	('1214182005', '121418', 'Siwalawa', 4),
	('1214182006', '121418', 'Ono Hondro', 4),
	('1214182007', '121418', 'Hinawalo Fau', 4),
	('1214182008', '121418', 'Lahusa Fau', 4),
	('1214182009', '121418', 'Lagundri', 4),
	('1214182010', '121418', 'Botohilitano', 4),
	('1214182011', '121418', 'Hilizihono', 4),
	('1214182012', '121418', 'Hiliofonaluo', 4),
	('1214182013', '121418', 'Orahili Faomasi', 4),
	('1214182014', '121418', 'Botohilisalo\'o', 4),
	('1214182015', '121418', 'Bawofanayama', 4),
	('1214182016', '121418', 'Sondregeasi', 4),
	('1214182017', '121418', 'Hilikara Maha', 4),
	('1214182018', '121418', 'Hilisalawa', 4),
	('1214182019', '121418', 'Hiligito', 4),
	('1214182020', '121418', 'Siliwulawa', 4),
	('1214182021', '121418', 'Hilifarokha Lawa', 4),
	('1214182022', '121418', 'Eho Orahili', 4),
	('1214182023', '121418', 'Ete Batu', 4),
	('1214182024', '121418', 'Botohili Silambo', 4),
	('1214182025', '121418', 'Botohili Sorake', 4),
	('1214192001', '121419', 'Sambulu', 4),
	('1214192002', '121419', 'Orahili Ulunoyo', 4),
	('1214192003', '121419', 'Hiliwaebu', 4),
	('1214192004', '121419', 'Amorosa', 4),
	('1214192005', '121419', 'Marao', 4),
	('1214192006', '121419', 'Borowosi', 4),
	('1214192007', '121419', 'Hilimaera', 4),
	('1214192008', '121419', 'Suka Maju', 4),
	('1214192009', '121419', 'Loloana\'a', 4),
	('1214192010', '121419', 'Hilifakhe', 4),
	('1214192011', '121419', 'Bawo Lolomatua', 4),
	('1214192012', '121419', 'Ambukha Satu', 4),
	('1214192013', '121419', 'Puncak Lolomatua', 4),
	('1214202001', '121420', 'Ehosakhozi', 4),
	('1214202002', '121420', 'Bawahosi Huruna', 4),
	('1214202003', '121420', 'Hilizoliga', 4),
	('1214202004', '121420', 'Olayama', 4),
	('1214202005', '121420', 'Sifaoro\'asi', 4),
	('1214202006', '121420', 'Sifalago', 4),
	('1214202007', '121420', 'Lalimanawa', 4),
	('1214202008', '121420', 'Tundrombaho', 4),
	('1214202009', '121420', 'Hiliuso', 4),
	('1214202010', '121420', 'Sisarahili Huruna', 4),
	('1214202011', '121420', 'Tarewe', 4),
	('1214202012', '121420', 'Fadoro Tuhemberua', 4),
	('1214202013', '121420', 'Hilifalawu', 4),
	('1214202014', '121420', 'Luahamofakhe', 4),
	('1214202015', '121420', 'Sifaoroasi Huruna', 4),
	('1214202016', '121420', 'Hilimanawa', 4),
	('1214202017', '121420', 'Mombawa Oladano', 4),
	('1214212001', '121421', 'Hilinamozihono', 4),
	('1214212002', '121421', 'Hilimbowo', 4),
	('1214212003', '121421', 'Simandraolo', 4),
	('1214212004', '121421', 'Bawosalo\'o Bawoluo', 4),
	('1214212005', '121421', 'Hilimbuasi', 4),
	('1214212006', '121421', 'Simandraolo O\'ou', 4),
	('1214212007', '121421', 'Lolomaya', 4),
	('1214212008', '121421', 'Suka Maju', 4),
	('1214212009', '121421', 'Hiliorudua', 4),
	('1214212010', '121421', 'Hilinamozihono Moale', 4),
	('1214212011', '121421', 'Balohili O\'o\'u', 4),
	('1214222001', '121422', 'Fadoro\'ewo', 4),
	('1214222002', '121422', 'Soroma\'asi', 4),
	('1214222003', '121422', 'La\'uso', 4),
	('1214222004', '121422', 'Sisarahili Oyo', 4),
	('1214222005', '121422', 'Sisobahili Huruna', 4),
	('1214222006', '121422', 'Onohazumba', 4),
	('1214222007', '121422', 'Hiliweto', 4),
	('1214222008', '121422', 'Orahili Huruna', 4),
	('1214222009', '121422', 'Tetehosi', 4),
	('1214222010', '121422', 'Helefanikha', 4),
	('1214232001', '121423', 'Maluo', 4),
	('1214232002', '121423', 'Hilidulo', 4),
	('1214232003', '121423', 'Umbu\'asi', 4),
	('1214232004', '121423', 'Sisobahili Siwalawa', 4),
	('1214232005', '121423', 'Manawadano', 4),
	('1214232006', '121423', 'Talio', 4),
	('1214232007', '121423', 'Anaoma', 4),
	('1214232008', '121423', 'Berua Siwalawa', 4),
	('1214232009', '121423', 'Umbuasi Barat', 4),
	('1214232010', '121423', 'Hiligodu', 4),
	('1214232011', '121423', 'Bukitburasi', 4),
	('1214242001', '121424', 'Fondrakoraya', 4),
	('1214242002', '121424', 'Orudu Sibohou', 4),
	('1214242003', '121424', 'Sisarahili Susua', 4),
	('1214242004', '121424', 'Susua', 4),
	('1214242005', '121424', 'Lahusa Susua', 4),
	('1214242006', '121424', 'Ramba-Ramba', 4),
	('1214242007', '121424', 'Hilinifaoso', 4),
	('1214242008', '121424', 'Sifaoroasi', 4),
	('1214242009', '121424', 'Amandraya Ulususua', 4),
	('1214242010', '121424', 'Foikhu Fondrako', 4),
	('1214242011', '121424', 'Hiliwosi', 4),
	('1214242012', '121424', 'Orahili Fondrako', 4),
	('1214252001', '121425', 'Mondrowe', 4),
	('1214252002', '121425', 'Hilidohona', 4),
	('1214252003', '121425', 'Hililaora', 4),
	('1214252004', '121425', 'Uluidanoduo', 4),
	('1214252005', '121425', 'Umbu Sohahua', 4),
	('1214252006', '121425', 'Hilisao\'oto', 4),
	('1214252007', '121425', 'Taluzusua', 4),
	('1214252008', '121425', 'Hilizanuwo', 4),
	('1214252009', '121425', 'Hoya', 4),
	('1214252010', '121425', 'Na\'ai', 4),
	('1214252011', '121425', 'Olanori', 4),
	('1214262001', '121426', 'Sifitubanua', 4),
	('1214262002', '121426', 'Siwalubanua', 4),
	('1214262003', '121426', 'Sitolu Banua', 4),
	('1214262004', '121426', 'Silimabanua Somambawa', 4),
	('1214262005', '121426', 'Mehaga', 4),
	('1214262006', '121426', 'Sihareo', 4),
	('1214262007', '121426', 'Golambanua II', 4),
	('1214262008', '121426', 'Oladano', 4),
	('1214262009', '121426', 'Fanedanu', 4),
	('1214262010', '121426', 'Hiliorahua Tasua', 4),
	('1214262011', '121426', 'Somambawa', 4),
	('1214262012', '121426', 'Gabungan Tasua', 4),
	('1214262013', '121426', 'Hilialawa', 4),
	('1214262014', '121426', 'Sinar Susua', 4),
	('1214272001', '121427', 'Sifalago Gomo', 4),
	('1214272002', '121427', 'Balohili Gomo', 4),
	('1214272003', '121427', 'Bohalu', 4),
	('1214272004', '121427', 'Orsedes', 4),
	('1214272005', '121427', 'Sinar Helaowo', 4),
	('1214272006', '121427', 'Siholi', 4),
	('1214272007', '121427', 'Tuhegafoa', 4),
	('1214272008', '121427', 'Perjuangan', 4),
	('1214272009', '121427', 'Lewa-Lewa', 4),
	('1214272010', '121427', 'Siraha', 4),
	('1214282001', '121428', 'Gobo', 4),
	('1214282002', '121428', 'Silina', 4),
	('1214282003', '121428', 'Maufa', 4),
	('1214282004', '121428', 'Gondia', 4),
	('1214282005', '121428', 'Gobo Baru', 4),
	('1214282006', '121428', 'Silina Baru', 4),
	('1214292001', '121429', 'Fuge', 4),
	('1214292002', '121429', 'Luaha Idanopono', 4),
	('1214292003', '121429', 'Sigese', 4),
	('1214292004', '121429', 'Bawositora', 4),
	('1214292005', '121429', 'Bintuang', 4),
	('1214292006', '121429', 'Sibaranun', 4),
	('1214292007', '121429', 'Bawolawindra', 4),
	('1214292008', '121429', 'Hayo', 4),
	('1214292009', '121429', 'Hilizamorogotano', 4),
	('1214302001', '121430', 'Siofa Banua Lorang', 4),
	('1214302002', '121430', 'Siofa Banua Marit', 4),
	('1214302003', '121430', 'Ziabiang', 4),
	('1214302004', '121430', 'Limo Biang', 4),
	('1214302005', '121430', 'Memong', 4),
	('1214302006', '121430', 'Bale-Bale', 4),
	('1214302007', '121430', 'Teluk Limo', 4),
	('1214302008', '121430', 'Wawa', 4),
	('1214302009', '121430', 'Merit Baru', 4),
	('1214302010', '121430', 'Majino Lorang', 4),
	('1214302011', '121430', 'Afore Gobo', 4),
	('1214302012', '121430', 'Bale-Bale Sibohou', 4),
	('1214312001', '121431', 'Baluta', 4),
	('1214312002', '121431', 'Eho Baluta', 4),
	('1214312003', '121431', 'Bawo Ofuloa', 4),
	('1214312004', '121431', 'Hale Baluta', 4),
	('1214312005', '121431', 'Bawo Orudua', 4),
	('1214312006', '121431', 'Jeke', 4),
	('1214312007', '121431', 'Makole', 4),
	('1214312008', '121431', 'Sifauruasi', 4),
	('1214312009', '121431', 'Bawo Analita Saeru', 4),
	('1214312010', '121431', 'Saeru Melayu', 4),
	('1214312011', '121431', 'Hiligeho Sogawu', 4),
	('1214312012', '121431', 'Hilimasio', 4),
	('1215012001', '121501', 'Tanjung Meriah', 4),
	('1215012002', '121501', 'Tanjung Mulia', 4),
	('1215012003', '121501', 'Kaban Tengah', 4),
	('1215012004', '121501', 'Bandar Baru', 4),
	('1215012005', '121501', 'Simberruna', 4),
	('1215012006', '121501', 'Perolihen', 4),
	('1215012007', '121501', 'Maholida', 4),
	('1215012008', '121501', 'Perjaga', 4),
	('1215012009', '121501', 'Malum', 4),
	('1215012010', '121501', 'Mbinalun', 4),
	('1215022001', '121502', 'Sukaramai', 4),
	('1215022002', '121502', 'Kuta Saga', 4),
	('1215022003', '121502', 'Kuta Meriah', 4),
	('1215022004', '121502', 'Kuta Dame', 4),
	('1215022005', '121502', 'Parpulungen', 4),
	('1215022006', '121502', 'Pardomuan', 4),
	('1215022014', '121502', 'Majanggut I', 4),
	('1215022015', '121502', 'Majanggut II', 4),
	('1215022016', '121502', 'Surung Mersada', 4),
	('1215022021', '121502', 'Perduhapen', 4),
	('1215032001', '121503', 'Salak I', 4),
	('1215032002', '121503', 'Salak II', 4),
	('1215032003', '121503', 'Boangmanalu', 4),
	('1215032009', '121503', 'Sibongkaras', 4),
	('1215032013', '121503', 'Kuta Tinggi', 4),
	('1215032014', '121503', 'Penanggalan Binanga Boang', 4),
	('1215042001', '121504', 'Ulu Merah', 4),
	('1215042002', '121504', 'Pardomuan', 4),
	('1215042003', '121504', 'Silima Kuta', 4),
	('1215042004', '121504', 'Lae Langge Namuseng', 4),
	('1215042005', '121504', 'Cikaok', 4),
	('1215052001', '121505', 'Kecupak I', 4),
	('1215052002', '121505', 'Kecupak II', 4),
	('1215052003', '121505', 'Aornakan I', 4),
	('1215052004', '121505', 'Simerpara', 4),
	('1215052005', '121505', 'Aornakan II', 4),
	('1215062001', '121506', 'Sibagindar', 4),
	('1215062002', '121506', 'Napatalun Perlumbaken', 4),
	('1215062003', '121506', 'Lae Mbentar', 4),
	('1215062004', '121506', 'Pagindar', 4),
	('1215072001', '121507', 'Kuta Babo', 4),
	('1215072002', '121507', 'Tinada', 4),
	('1215072003', '121507', 'Silima Kuta', 4),
	('1215072004', '121507', 'Mahala', 4),
	('1215072005', '121507', 'Prongil', 4),
	('1215072006', '121507', 'Buluh Tellang', 4),
	('1215082001', '121508', 'Siempat Rube II', 4),
	('1215082002', '121508', 'Siempat Rube I', 4),
	('1215082003', '121508', 'Mungkur', 4),
	('1215082004', '121508', 'Siempat Rube IV', 4),
	('1215082005', '121508', 'Kuta Jungak', 4),
	('1215082006', '121508', 'Traju', 4),
	('1216012002', '121601', 'Pusuk II Simaninggir', 4),
	('1216012003', '121601', 'Sionom Hudon VII', 4),
	('1216012004', '121601', 'Baringin', 4),
	('1216012005', '121601', 'Sionom Hudon Julu', 4),
	('1216012006', '121601', 'Sionom Hudon Tonga', 4),
	('1216012007', '121601', 'Sionom Hudon Utara', 4),
	('1216012008', '121601', 'Sionom Hudon Selatan', 4),
	('1216012009', '121601', 'Sionom Hudon Timur', 4),
	('1216012010', '121601', 'Sihotang Hasugian Tonga', 4),
	('1216012011', '121601', 'Pusuk I', 4),
	('1216012012', '121601', 'Sionom Hudon Toruan', 4),
	('1216012013', '121601', 'Simataniari', 4),
	('1216012014', '121601', 'Sionom Hudon Timur II', 4),
	('1216012015', '121601', 'Sihotang Hasugian Dolok II', 4),
	('1216012016', '121601', 'Sihotang Hasugian Habinsaran', 4),
	('1216012017', '121601', 'Sionom Hudon Sibulbulon', 4),
	('1216012018', '121601', 'Sionom Hudon Runggu', 4),
	('1216012019', '121601', 'Janji Hutanapa', 4),
	('1216012020', '121601', 'Baringin Natam', 4),
	('1216012021', '121601', 'Sihotang Hasugian Dolok I', 4),
	('1216022001', '121602', 'Parsingguran I', 4),
	('1216022002', '121602', 'Hutapaung', 4),
	('1216022003', '121602', 'Pollung', 4),
	('1216022004', '121602', 'Hutajulu', 4),
	('1216022005', '121602', 'Ria Ria', 4),
	('1216022006', '121602', 'Parsingguran II', 4),
	('1216022007', '121602', 'Pansurbatu', 4),
	('1216022008', '121602', 'Aek Nauli I', 4),
	('1216022009', '121602', 'Aek Nauli II', 4),
	('1216022010', '121602', 'Pandumaan', 4),
	('1216022011', '121602', 'Sipituhuta', 4),
	('1216022012', '121602', 'Pardomuan', 4),
	('1216022013', '121602', 'Hutapaung Utara', 4),
	('1216032001', '121603', 'Marbun', 4),
	('1216032002', '121603', 'Simamora', 4),
	('1216032003', '121603', 'Tipang', 4),
	('1216032004', '121603', 'Sinambela', 4),
	('1216032005', '121603', 'Simangulampe', 4),
	('1216032006', '121603', 'Siunong Unong Julu', 4),
	('1216032007', '121603', 'Marbun Tonga Marbun Dolok', 4),
	('1216042001', '121604', 'Sihonongan', 4),
	('1216042002', '121604', 'Paranginan Selatan', 4),
	('1216042003', '121604', 'Paranginan Utara', 4),
	('1216042004', '121604', 'Lumban Sialaman', 4),
	('1216042005', '121604', 'Pearung', 4),
	('1216042006', '121604', 'Lobutolong', 4),
	('1216042007', '121604', 'Lumban Barat', 4),
	('1216042008', '121604', 'Siboru Torop', 4),
	('1216042009', '121604', 'Pearung Silali', 4),
	('1216042010', '121604', 'Lumban Sianturi', 4),
	('1216042011', '121604', 'Lobutolong Habinsaran', 4),
	('1216052001', '121605', 'Sibuntuon', 4),
	('1216052002', '121605', 'Siharjulu', 4),
	('1216052003', '121605', 'Sitolu Bahal', 4),
	('1216052004', '121605', 'Tapian Nauli', 4),
	('1216052005', '121605', 'Pargaulan', 4),
	('1216052006', '121605', 'Lobutua', 4),
	('1216052007', '121605', 'Dolok Margu', 4),
	('1216052008', '121605', 'Hutasoit', 4),
	('1216052009', '121605', 'Nagasaribu I', 4),
	('1216052010', '121605', 'Nagasaribu II', 4),
	('1216052011', '121605', 'Sibuntoan Parpea', 4),
	('1216052012', '121605', 'Siponjot', 4),
	('1216052013', '121605', 'Habeahan', 4),
	('1216052014', '121605', 'Sigompul', 4),
	('1216052015', '121605', 'Bonan Dolok', 4),
	('1216052016', '121605', 'Sigumpar', 4),
	('1216052017', '121605', 'Parulohan', 4),
	('1216052018', '121605', 'Sitio II', 4),
	('1216052019', '121605', 'Hutasoit II', 4),
	('1216052020', '121605', 'Nagasaribu III', 4),
	('1216052021', '121605', 'Nagasaribu IV', 4),
	('1216052022', '121605', 'Nagasaribu V', 4),
	('1216061001', '121606', 'Dolok Sanggul', 3),
	('1216062002', '121606', 'Sileang', 4),
	('1216062003', '121606', 'Purba Manalu', 4),
	('1216062004', '121606', 'Pasaribu', 4),
	('1216062005', '121606', 'Simarigung', 4),
	('1216062006', '121606', 'Sampean', 4),
	('1216062007', '121606', 'Silaga Laga', 4),
	('1216062008', '121606', 'Sosor Gonting', 4),
	('1216062009', '121606', 'Sosor Tambok', 4),
	('1216062010', '121606', 'Purba Dolok', 4),
	('1216062011', '121606', 'Sihite I', 4),
	('1216062012', '121606', 'Lumban Tobing', 4),
	('1216062013', '121606', 'Hutabagasan', 4),
	('1216062014', '121606', 'Matiti II', 4),
	('1216062015', '121606', 'Saitnihuta', 4),
	('1216062016', '121606', 'Hutaraja', 4),
	('1216062017', '121606', 'Lumban Purba', 4),
	('1216062018', '121606', 'Bonanionan', 4),
	('1216062019', '121606', 'Parik Sinomba', 4),
	('1216062020', '121606', 'Sihite II', 4),
	('1216062021', '121606', 'Janji', 4),
	('1216062022', '121606', 'Pakkat', 4),
	('1216062023', '121606', 'Sirisirisi', 4),
	('1216062024', '121606', 'Hutagurgur', 4),
	('1216062025', '121606', 'Matiti', 4),
	('1216062026', '121606', 'Aek Lung', 4),
	('1216062027', '121606', 'Simangaronsang', 4),
	('1216062028', '121606', 'Sosortolong Sihite III', 4),
	('1216072001', '121607', 'Batunajagar', 4),
	('1216072002', '121607', 'Sanggaran I', 4),
	('1216072003', '121607', 'Sitapongan', 4),
	('1216072004', '121607', 'Sigulok', 4),
	('1216072005', '121607', 'Hutaginjang', 4),
	('1216072006', '121607', 'Siborboron', 4),
	('1216072007', '121607', 'Bonan Dolok I', 4),
	('1216072008', '121607', 'Bonan Dolok II', 4),
	('1216072009', '121607', 'Sibuntuon', 4),
	('1216072010', '121607', 'Nagurguran', 4),
	('1216082001', '121608', 'Batu Nagodang Siatas', 4),
	('1216082002', '121608', 'Onan Ganjang', 4),
	('1216082003', '121608', 'Parbotihan', 4),
	('1216082004', '121608', 'Sihikit', 4),
	('1216082005', '121608', 'Parnapa', 4),
	('1216082006', '121608', 'Janji Nagodang', 4),
	('1216082007', '121608', 'Sampe Tua', 4),
	('1216082008', '121608', 'Hutajulu', 4),
	('1216082009', '121608', 'Sibuluan', 4),
	('1216082010', '121608', 'Sigalogo', 4),
	('1216082011', '121608', 'Aek Godang Arbaan', 4),
	('1216082012', '121608', 'Sanggaran II', 4),
	('1216092001', '121609', 'Purba Bersatu', 4),
	('1216092002', '121609', 'Purba Baringin', 4),
	('1216092003', '121609', 'Karya', 4),
	('1216092004', '121609', 'Manalu', 4),
	('1216092005', '121609', 'Sijarango', 4),
	('1216092006', '121609', 'Tukka Dolok', 4),
	('1216092007', '121609', 'Siambaton', 4),
	('1216092008', '121609', 'Parmonangan', 4),
	('1216092009', '121609', 'Sipagabu', 4),
	('1216092010', '121609', 'Banuarea', 4),
	('1216092011', '121609', 'Rura Tanjung', 4),
	('1216092012', '121609', 'Rura Aek Sopang', 4),
	('1216092013', '121609', 'Lumban Tonga-Tonga', 4),
	('1216092014', '121609', 'Pulo Godang', 4),
	('1216092015', '121609', 'Pakkat Hauagong', 4),
	('1216092016', '121609', 'Peadungdung', 4),
	('1216092017', '121609', 'Sijarango I', 4),
	('1216092018', '121609', 'Ambobi Paranginan', 4),
	('1216092019', '121609', 'Purba Sianjur', 4),
	('1216092020', '121609', 'Siambaton Pahae', 4),
	('1216092021', '121609', 'Panggugunan', 4),
	('1216092022', '121609', 'Hauagong', 4),
	('1216102001', '121610', 'Tarabintang', 4),
	('1216102002', '121610', 'Sihotang Hasugian Toruan', 4),
	('1216102003', '121610', 'Sibongkare', 4),
	('1216102004', '121610', 'Sitanduk', 4),
	('1216102005', '121610', 'Sihombu', 4),
	('1216102006', '121610', 'Simbara', 4),
	('1216102007', '121610', 'Marpadan', 4),
	('1216102008', '121610', 'Mungkur', 4),
	('1216102009', '121610', 'Sibongkare Sianju', 4),
	('1217011016', '121701', 'Tuktuk Siadong', 3),
	('1217012001', '121701', 'Tomok', 4),
	('1217012002', '121701', 'Sihusapi', 4),
	('1217012003', '121701', 'Maduma', 4),
	('1217012004', '121701', 'Dosroha', 4),
	('1217012005', '121701', 'Ambarita', 4),
	('1217012006', '121701', 'Martoba', 4),
	('1217012007', '121701', 'Garoga', 4),
	('1217012008', '121701', 'Simanindo Sangkal', 4),
	('1217012009', '121701', 'Cinta Dame', 4),
	('1217012010', '121701', 'Huta Ginjang', 4),
	('1217012011', '121701', 'Pardomuan', 4),
	('1217012012', '121701', 'Parmonangan', 4),
	('1217012013', '121701', 'Parbalohan', 4),
	('1217012014', '121701', 'Tanjungan', 4),
	('1217012015', '121701', 'Simarmata', 4),
	('1217012017', '121701', 'Tomok Parsaoran', 4),
	('1217012018', '121701', 'Marlumba', 4),
	('1217012019', '121701', 'Simanindo', 4),
	('1217012020', '121701', 'Unjur', 4),
	('1217012021', '121701', 'Siallagan Pindaraya', 4),
	('1217022001', '121702', 'Pakpahan', 4),
	('1217022002', '121702', 'Huta Hotang', 4),
	('1217022003', '121702', 'Sitinjak', 4),
	('1217022004', '121702', 'Pardomuan', 4),
	('1217022005', '121702', 'Tambun Sungkean', 4),
	('1217022006', '121702', 'Rina Bolak', 4),
	('1217022007', '121702', 'Onan Runggu', 4),
	('1217022008', '121702', 'Sitamiang', 4),
	('1217022009', '121702', 'Janji Matogu', 4),
	('1217022010', '121702', 'Silima Lombu', 4),
	('1217022011', '121702', 'Sipira', 4),
	('1217022012', '121702', 'Harian', 4),
	('1217031011', '121703', 'Parhusip III', 3),
	('1217031012', '121703', 'Sirumahombar', 3),
	('1217032001', '121703', 'Pangaloan', 4),
	('1217032002', '121703', 'Hutarihit', 4),
	('1217032003', '121703', 'Sinaga Uruk Pandiangan', 4),
	('1217032004', '121703', 'Toguan Galung', 4),
	('1217032005', '121703', 'Pananggangan', 4),
	('1217032006', '121703', 'Pasaran Parsaoran', 4),
	('1217032007', '121703', 'Sipinggan Lumban Siantar', 4),
	('1217032008', '121703', 'Sibonor Ompu Ratus', 4),
	('1217032009', '121703', 'Nainggolan', 4),
	('1217032010', '121703', 'Pasaran I', 4),
	('1217032013', '121703', 'Pananggangan II', 4),
	('1217032014', '121703', 'Sipinggan', 4),
	('1217032015', '121703', 'Janji Marapot', 4),
	('1217042001', '121704', 'Suhutnihuta Pardomuan', 4),
	('1217042002', '121704', 'Gorat Pallombuan', 4),
	('1217042003', '121704', 'Urat II', 4),
	('1217042004', '121704', 'Palipi', 4),
	('1217042005', '121704', 'Pardomuan Nauli', 4),
	('1217042006', '121704', 'Hatoguan', 4),
	('1217042007', '121704', 'Simbolon Purba', 4),
	('1217042008', '121704', 'Sigaol Simbolon', 4),
	('1217042009', '121704', 'Urat Timur', 4),
	('1217042010', '121704', 'Saor Nauli Hatoguan', 4),
	('1217042011', '121704', 'Parsaoran Urat', 4),
	('1217042012', '121704', 'Hutaginjang', 4),
	('1217042014', '121704', 'Sigaol Marbun', 4),
	('1217042018', '121704', 'Hutadame', 4),
	('1217042019', '121704', 'Pallombuan', 4),
	('1217042020', '121704', 'Pamutaran', 4),
	('1217042021', '121704', 'Sideak', 4),
	('1217052001', '121705', 'Sosor Dolok', 4),
	('1217052002', '121705', 'Partungkonaginjang', 4),
	('1217052003', '121705', 'Hariara Pohan', 4),
	('1217052004', '121705', 'Dolok Raja', 4),
	('1217052006', '121705', 'Sampur Toba', 4),
	('1217052007', '121705', 'Siparmahan', 4),
	('1217052008', '121705', 'Turpuk Limbong', 4),
	('1217052009', '121705', 'Turpuk Sagala', 4),
	('1217052010', '121705', 'Turpuk Malau', 4),
	('1217052011', '121705', 'Turpuk Sihotang', 4),
	('1217052012', '121705', 'Janji Martahan', 4),
	('1217052014', '121705', 'Hutagalung', 4),
	('1217052015', '121705', 'Hariarapintu', 4),
	('1217062001', '121706', 'Huta Ginjang', 4),
	('1217062002', '121706', 'Singkam', 4),
	('1217062003', '121706', 'Hasinggaan', 4),
	('1217062004', '121706', 'Aek Sipitudai', 4),
	('1217062005', '121706', 'Huta Gurgur', 4),
	('1217062006', '121706', 'Sianjur Mula Mula', 4),
	('1217062007', '121706', 'Boho', 4),
	('1217062008', '121706', 'Siboro', 4),
	('1217062009', '121706', 'Simarihit', 4),
	('1217062010', '121706', 'Ginolat', 4),
	('1217062011', '121706', 'Bonan Dolok', 4),
	('1217062012', '121706', 'Habeahan Naburahan', 4),
	('1217072001', '121707', 'Salaon Toba', 4),
	('1217072002', '121707', 'Lintong Nihuta', 4),
	('1217072003', '121707', 'Salaon Tonga Tonga', 4),
	('1217072004', '121707', 'Salaon Dolok', 4),
	('1217072005', '121707', 'Ronggur Nihuta', 4),
	('1217072006', '121707', 'Sabungan Nihuta', 4),
	('1217072007', '121707', 'Paraduan', 4),
	('1217072008', '121707', 'Sijambur', 4),
	('1217081026', '121708', 'Pasar Pangururan', 3),
	('1217081027', '121708', 'Pintu Sona', 3),
	('1217081028', '121708', 'Siogung-Ogung', 3),
	('1217082001', '121708', 'Lumban SS Dolok', 4),
	('1217082002', '121708', 'Lumban SS Torua', 4),
	('1217082003', '121708', 'Parbaba Dolok', 4),
	('1217082004', '121708', 'Huta Tinggi', 4),
	('1217082005', '121708', 'Parhorasan', 4),
	('1217082006', '121708', 'Pardomuan Nauli', 4),
	('1217082007', '121708', 'Parsaoran I', 4),
	('1217082008', '121708', 'Rianiate', 4),
	('1217082009', '121708', 'Huta Bolon', 4),
	('1217082010', '121708', 'Panampangan', 4),
	('1217082011', '121708', 'Pardugul', 4),
	('1217082012', '121708', 'Huta Namora', 4),
	('1217082013', '121708', 'Parlondut', 4),
	('1217082014', '121708', 'Tanjung Bunga', 4),
	('1217082015', '121708', 'Parmonangan', 4),
	('1217082016', '121708', 'Sait Nihuta', 4),
	('1217082017', '121708', 'Situngkir', 4),
	('1217082018', '121708', 'Sianting-Anting', 4),
	('1217082019', '121708', 'Sialanguan', 4),
	('1217082020', '121708', 'Lumban Pinggol', 4),
	('1217082021', '121708', 'Pardomuan I', 4),
	('1217082022', '121708', 'Sitolu Huta', 4),
	('1217082023', '121708', 'Sinabulan', 4),
	('1217082024', '121708', 'Aek Nauli', 4),
	('1217082025', '121708', 'Siopat Sosor', 4),
	('1217092001', '121709', 'Holbung', 4),
	('1217092002', '121709', 'Janji Raja', 4),
	('1217092003', '121709', 'Sabulan', 4),
	('1217092004', '121709', 'Buntu Mauli', 4),
	('1217092005', '121709', 'Tamba Dolok', 4),
	('1217092006', '121709', 'Cinta Maju', 4),
	('1217092007', '121709', 'Parsaoran', 4),
	('1217092008', '121709', 'Janji Maria', 4),
	('1218012001', '121801', 'Pantai Cermin Kanan', 4),
	('1218012002', '121801', 'Pantai Cermin Kiri', 4),
	('1218012003', '121801', 'Kota Pari', 4),
	('1218012004', '121801', 'Celawan', 4),
	('1218012005', '121801', 'Ujung Rambung', 4),
	('1218012006', '121801', 'Kuala Lama', 4),
	('1218012007', '121801', 'Besar II Terjun', 4),
	('1218012008', '121801', 'Sementara', 4),
	('1218012009', '121801', 'Ara Payung', 4),
	('1218012010', '121801', 'Pematang Kasih', 4),
	('1218012011', '121801', 'Lubuk Saban', 4),
	('1218012012', '121801', 'Naga Kisar', 4),
	('1218021038', '121802', 'Melati I', 3),
	('1218021039', '121802', 'Simpang Tiga Pekan', 3),
	('1218021040', '121802', 'Batang Terap', 3),
	('1218021041', '121802', 'Tualang', 3),
	('1218022001', '121802', 'Adolina', 4),
	('1218022003', '121802', 'Bengkel', 4),
	('1218022005', '121802', 'Cinta Air', 4),
	('1218022006', '121802', 'Cintaman Jernih', 4),
	('1218022007', '121802', 'Deli Muda Hulu', 4),
	('1218022008', '121802', 'Deli Muda Hilir', 4),
	('1218022009', '121802', 'Jambur Pulau', 4),
	('1218022012', '121802', 'Kesatuan', 4),
	('1218022013', '121802', 'Kota Galuh', 4),
	('1218022015', '121802', 'Lidah Tanah', 4),
	('1218022016', '121802', 'Lubuk Bayas', 4),
	('1218022017', '121802', 'Lubuk Cemara', 4),
	('1218022018', '121802', 'Lubuk Dendang', 4),
	('1218022019', '121802', 'Lubuk Rotan', 4),
	('1218022020', '121802', 'Melati II', 4),
	('1218022024', '121802', 'Pematang Sijonam', 4),
	('1218022025', '121802', 'Pematang Tatal', 4),
	('1218022028', '121802', 'Suka Beras', 4),
	('1218022029', '121802', 'Sukajadi', 4),
	('1218022031', '121802', 'Sei Buluh', 4),
	('1218022032', '121802', 'Sei Nagalawan', 4),
	('1218022033', '121802', 'Sei Sijenggi', 4),
	('1218022034', '121802', 'Tanah Merah', 4),
	('1218022035', '121802', 'Tanjung Buluh', 4),
	('1218032001', '121803', 'Sei Buluh', 4),
	('1218032002', '121803', 'Liberia', 4),
	('1218032003', '121803', 'Mata Pao', 4),
	('1218032004', '121803', 'Pematang Setrak', 4),
	('1218032005', '121803', 'Makmur', 4),
	('1218032006', '121803', 'Pasar Baru', 4),
	('1218032007', '121803', 'Pekan Sialang Buah', 4),
	('1218032008', '121803', 'Pematang Guntung', 4),
	('1218032009', '121803', 'Sialang Buah', 4),
	('1218032010', '121803', 'Sentang', 4),
	('1218032011', '121803', 'Bogak Besar', 4),
	('1218032012', '121803', 'Pematang Kuala', 4),
	('1218042001', '121804', 'Cempedak Lobang', 4),
	('1218042002', '121804', 'Firdaus', 4),
	('1218042004', '121804', 'Pergulaan', 4),
	('1218042006', '121804', 'Sei Rampah', 4),
	('1218042008', '121804', 'Sei Rejo', 4),
	('1218042009', '121804', 'Sei Parit', 4),
	('1218042010', '121804', 'Silau Rakyat', 4),
	('1218042012', '121804', 'Firdaus Estate', 4),
	('1218042014', '121804', 'Pematang Ganjang', 4),
	('1218042015', '121804', 'Pematang Pelintahan', 4),
	('1218042016', '121804', 'Rambung Estate', 4),
	('1218042017', '121804', 'Rambung Sialang Hulu', 4),
	('1218042018', '121804', 'Rambung Sialang Tengah', 4),
	('1218042019', '121804', 'Rambung Sialang Hilir', 4),
	('1218042024', '121804', 'Simpang Empat', 4),
	('1218042026', '121804', 'Sinah Kasih', 4),
	('1218042027', '121804', 'Tanah Raja', 4),
	('1218052001', '121805', 'Pekan Tg. Beringin', 4),
	('1218052002', '121805', 'Nagur', 4),
	('1218052003', '121805', 'Mangga Dua', 4),
	('1218052004', '121805', 'Sukajadi', 4),
	('1218052005', '121805', 'Tebing Tinggi', 4),
	('1218052006', '121805', 'Pematang Cermai', 4),
	('1218052007', '121805', 'Pematang Terang', 4),
	('1218052008', '121805', 'Bagan Kuala', 4),
	('1218062001', '121806', 'Bandar Tengah', 4),
	('1218062002', '121806', 'Juhar', 4),
	('1218062003', '121806', 'Gelam Sei Serimah', 4),
	('1218062004', '121806', 'Pekan Bandar Khalipah', 4),
	('1218062005', '121806', 'Kayu Besar', 4),
	('1218072001', '121807', 'Nagaraja I', 4),
	('1218072002', '121807', 'Panglong', 4),
	('1218072003', '121807', 'Bandarawan', 4),
	('1218072004', '121807', 'Gunung Para II', 4),
	('1218072005', '121807', 'Limbong', 4),
	('1218072006', '121807', 'Dolok Merawan', 4),
	('1218072007', '121807', 'Paritokan', 4),
	('1218072008', '121807', 'Kalembak', 4),
	('1218072009', '121807', 'Afd.IV Dolok Ilir', 4),
	('1218072010', '121807', 'Pabatu I', 4),
	('1218072011', '121807', 'Afd. VII Dolok Ilir', 4),
	('1218072012', '121807', 'Pabatu II', 4),
	('1218072013', '121807', 'Mainu Tengah', 4),
	('1218072014', '121807', 'Bahdamar', 4),
	('1218072015', '121807', 'Pabatu III', 4),
	('1218072016', '121807', 'Pabatu VI', 4),
	('1218072017', '121807', 'Korojin', 4),
	('1218082001', '121808', 'Sipispis', 4),
	('1218082002', '121808', 'Serbananti', 4),
	('1218082003', '121808', 'Bartong', 4),
	('1218082004', '121808', 'Marubun', 4),
	('1218082005', '121808', 'Pispis', 4),
	('1218082006', '121808', 'Baja Dolok', 4),
	('1218082007', '121808', 'Tinokkah', 4),
	('1218082008', '121808', 'Nagur Pane', 4),
	('1218082009', '121808', 'Parlambean', 4),
	('1218082010', '121808', 'Naga Raja', 4),
	('1218082011', '121808', 'Mariah Nagur', 4),
	('1218082012', '121808', 'Rimbun', 4),
	('1218082013', '121808', 'Marjanji', 4),
	('1218082014', '121808', 'Silau Padang', 4),
	('1218082015', '121808', 'Buluh Duri', 4),
	('1218082016', '121808', 'Gunung Monako', 4),
	('1218082017', '121808', 'Damak Urat', 4),
	('1218082018', '121808', 'Simalas', 4),
	('1218082019', '121808', 'Gunung Pane', 4),
	('1218082020', '121808', 'Sibarau', 4),
	('1218091029', '121809', 'Pkn.Dolok Masihul', 3),
	('1218092001', '121809', 'Dame', 4),
	('1218092002', '121809', 'Blok', 4),
	('1218092003', '121809', 'Kota Tengah', 4),
	('1218092004', '121809', 'Silau Merawan', 4),
	('1218092005', '121809', 'Pekan Kamis', 4),
	('1218092006', '121809', 'Batu', 4),
	('1218092007', '121809', 'Batu', 4),
	('1218092008', '121809', 'Baja Ronggi', 4),
	('1218092009', '121809', 'Dolok Sagala', 4),
	('1218092010', '121809', 'Dolok Manampang', 4),
	('1218092011', '121809', 'Pardomuan', 4),
	('1218092012', '121809', 'Tegal Sari', 4),
	('1218092013', '121809', 'Pertambatan', 4),
	('1218092015', '121809', 'Huta Nauli', 4),
	('1218092016', '121809', 'Bantan', 4),
	('1218092017', '121809', 'Bukit Cermin Hilir', 4),
	('1218092018', '121809', 'Malasori', 4),
	('1218092019', '121809', 'Sarang Giting', 4),
	('1218092020', '121809', 'Durian Puloan', 4),
	('1218092021', '121809', 'Sarang Torop', 4),
	('1218092022', '121809', 'Havae', 4),
	('1218092023', '121809', 'Aras Panjang', 4),
	('1218092024', '121809', 'Martebing', 4),
	('1218092025', '121809', 'Kerapuh', 4),
	('1218092026', '121809', 'Tanjung Meria', 4),
	('1218092027', '121809', 'Bah Kerapuh', 4),
	('1218092028', '121809', 'Ujung Silau', 4),
	('1218102001', '121810', 'Kutarih Pekan', 4),
	('1218102002', '121810', 'Kutarih Baru', 4),
	('1218102003', '121810', 'Banjaran Godang', 4),
	('1218102004', '121810', 'Si Ujan-Ujan', 4),
	('1218102010', '121810', 'Sei Kari', 4),
	('1218102013', '121810', 'Bandar Bayu', 4),
	('1218102014', '121810', 'Durian Kondot', 4),
	('1218102015', '121810', 'Perbahingan', 4),
	('1218102022', '121810', 'Sialtong', 4),
	('1218102023', '121810', 'Huta Galuh', 4),
	('1218102024', '121810', 'Rubun Dunia', 4),
	('1218112004', '121811', 'Batu Masagi', 4),
	('1218112013', '121811', 'Damak Gelugur', 4),
	('1218112016', '121811', 'Kulasar', 4),
	('1218112021', '121811', 'Pagar Manik', 4),
	('1218112022', '121811', 'Pamah', 4),
	('1218112026', '121811', 'Silinda', 4),
	('1218112028', '121811', 'Sungai Buaya', 4),
	('1218112029', '121811', 'Tarean', 4),
	('1218112031', '121811', 'Tapak Meriah', 4),
	('1218122010', '121812', 'Tanjung Harap', 4),
	('1218122011', '121812', 'Kuala Bali', 4),
	('1218122014', '121812', 'Karang Tengah', 4),
	('1218122015', '121812', 'Kelapa Bajohom', 4),
	('1218122018', '121812', 'Manggis', 4),
	('1218122020', '121812', 'Pulau Gambar', 4),
	('1218122021', '121812', 'Pulau Tagor', 4),
	('1218122032', '121812', 'Serba Jadi', 4),
	('1218122033', '121812', 'Tambak Cekur', 4),
	('1218122038', '121812', 'Bah Sidua-dua', 4),
	('1218132001', '121813', 'Bah Sumbu', 4),
	('1218132002', '121813', 'Naga Kesiangan', 4),
	('1218132003', '121813', 'Jambu', 4),
	('1218132004', '121813', 'Mariah Padang', 4),
	('1218132005', '121813', 'Pentapaan', 4),
	('1218132006', '121813', 'Paya Lombang', 4),
	('1218132007', '121813', 'Sei. Sarimah', 4),
	('1218132008', '121813', 'Paya Bagas', 4),
	('1218132009', '121813', 'Paya Mabar', 4),
	('1218132010', '121813', 'Sei. Priok', 4),
	('1218132011', '121813', 'Kuta Baru', 4),
	('1218132018', '121813', 'Kedai Damar', 4),
	('1218132019', '121813', 'Penonggol', 4),
	('1218132020', '121813', 'Gunung Kataran', 4),
	('1218141012', '121814', 'Melati Kebun', 3),
	('1218142001', '121814', 'Bengabing', 4),
	('1218142002', '121814', 'Bingkat', 4),
	('1218142003', '121814', 'Jati Mulyo', 4),
	('1218142004', '121814', 'Karang Anyar', 4),
	('1218142005', '121814', 'Lestari Dadi', 4),
	('1218142006', '121814', 'Pegajahan', 4),
	('1218142007', '121814', 'Petuaran Hulu', 4),
	('1218142008', '121814', 'Petuaran Hilir', 4),
	('1218142009', '121814', 'Pondok Tengah', 4),
	('1218142010', '121814', 'Sukasari', 4),
	('1218142011', '121814', 'Tanjung Putus', 4),
	('1218142013', '121814', 'Sennah', 4),
	('1218152001', '121815', 'Pon', 4),
	('1218152002', '121815', 'Sei Bamban', 4),
	('1218152003', '121815', 'Bakaran Batu', 4),
	('1218152004', '121815', 'Gempolan', 4),
	('1218152005', '121815', 'Rampah Estate', 4),
	('1218152006', '121815', 'Suka Damai', 4),
	('1218152007', '121815', 'Bamban Estate', 4),
	('1218152008', '121815', 'Belutu', 4),
	('1218152009', '121815', 'Sei. Buluh', 4),
	('1218152010', '121815', 'Penggalean', 4),
	('1218162001', '121816', 'Penggalian', 4),
	('1218162002', '121816', 'Laut Tador', 4),
	('1218162003', '121816', 'Tanah Besih', 4),
	('1218162004', '121816', 'Binjai', 4),
	('1218162005', '121816', 'Paya Pasir', 4),
	('1218162006', '121816', 'Bahilang', 4),
	('1218162007', '121816', 'Penggalangan', 4),
	('1218162008', '121816', 'Paya Pinang', 4),
	('1218162009', '121816', 'Kuta Pinang', 4),
	('1218162010', '121816', 'Sibulan', 4),
	('1218172001', '121817', 'Gudang Garam', 4),
	('1218172002', '121817', 'Dolok Masango', 4),
	('1218172003', '121817', 'Panombean', 4),
	('1218172004', '121817', 'Bandar Negeri', 4),
	('1218172005', '121817', 'Ujung Negeri Kahan', 4),
	('1218172006', '121817', 'Bandar Magodang', 4),
	('1218172007', '121817', 'Ujung Negeri Hulu', 4),
	('1218172008', '121817', 'Pegajahan Hulu', 4),
	('1218172009', '121817', 'Marihat Dolok', 4),
	('1218172010', '121817', 'Bintang Bayu', 4),
	('1218172011', '121817', 'Bandar Pinang Kebon', 4),
	('1218172012', '121817', 'Damak Tolong Buho', 4),
	('1218172013', '121817', 'Bandar Pinang Rambe', 4),
	('1218172014', '121817', 'Pegajahan Kahan', 4),
	('1218172015', '121817', 'Huta Durian', 4),
	('1218172016', '121817', 'Kampung Kristen', 4),
	('1218172017', '121817', 'Sarang Ginting Kahan', 4),
	('1218172018', '121817', 'Sarang Ginting Hulu', 4),
	('1218172019', '121817', 'Siahap', 4),
	('1219011001', '121901', 'Pangkalan Dodek', 3),
	('1219011002', '121901', 'Pangkalan Dodek Baru', 3),
	('1219011021', '121901', 'Pagurawan', 3),
	('1219012003', '121901', 'Aek Nauli', 4),
	('1219012004', '121901', 'Durian', 4),
	('1219012005', '121901', 'Lalang', 4),
	('1219012006', '121901', 'Medang', 4),
	('1219012007', '121901', 'Pakam', 4),
	('1219012008', '121901', 'Pakam Raya', 4),
	('1219012009', '121901', 'Pematang Cengkering', 4),
	('1219012010', '121901', 'Sei Buah Keras', 4),
	('1219012011', '121901', 'Sei Rakyat', 4),
	('1219012012', '121901', 'Sidomulyo', 4),
	('1219012013', '121901', 'Tanjung Sigoni', 4),
	('1219012014', '121901', 'Nenas Siam', 4),
	('1219012015', '121901', 'Pakam Raya Selatan', 4),
	('1219012016', '121901', 'Mandarsah', 4),
	('1219012017', '121901', 'Medang Baru', 4),
	('1219012018', '121901', 'Pematang Nibung', 4),
	('1219012019', '121901', 'Cengkering Pekan', 4),
	('1219012020', '121901', 'Sei Raja', 4),
	('1219021001', '121902', 'Perkebunan Sipare Pare', 3),
	('1219022002', '121902', 'Laut Tador', 4),
	('1219022003', '121902', 'Tanjung Parapat', 4),
	('1219022004', '121902', 'Tanjung Kasau', 4),
	('1219022005', '121902', 'Tanjung Seri', 4),
	('1219022006', '121902', 'Sei Simujur', 4),
	('1219022007', '121902', 'Sei Suka Deras', 4),
	('1219022008', '121902', 'Simodong', 4),
	('1219022009', '121902', 'Pematang Jering', 4),
	('1219022010', '121902', 'Pematang Kuning', 4),
	('1219022011', '121902', 'Kuala Indah', 4),
	('1219022012', '121902', 'Kuala Tanjung', 4),
	('1219022013', '121902', 'Perkebunan Tj Kasau', 4),
	('1219022014', '121902', 'Pelanggiran Laut Tador', 4),
	('1219022015', '121902', 'Dwi Sri', 4),
	('1219022016', '121902', 'Mekar Sari', 4),
	('1219022017', '121902', 'Kandangan', 4),
	('1219022018', '121902', 'Tanjunggading', 4),
	('1219022019', '121902', 'Simpang Kopi', 4),
	('1219022020', '121902', 'Brohol', 4),
	('1219031001', '121903', 'Indrapura', 3),
	('1219031019', '121903', 'Indrasakti', 3),
	('1219032002', '121903', 'Limau Sundai', 4),
	('1219032003', '121903', 'Pematang Panjang', 4),
	('1219032004', '121903', 'Sukaraja', 4),
	('1219032005', '121903', 'Tanah Tinggi', 4),
	('1219032006', '121903', 'Tanjungmuda', 4),
	('1219032007', '121903', 'Tanah Merah', 4),
	('1219032008', '121903', 'Aras', 4),
	('1219032009', '121903', 'Pasar Lapan', 4),
	('1219032010', '121903', 'Sipare-pare', 4),
	('1219032011', '121903', 'Tanjungkubah', 4),
	('1219032012', '121903', 'Tanjungharapan', 4),
	('1219032013', '121903', 'Suka Ramai', 4),
	('1219032014', '121903', 'Tanah Rendah', 4),
	('1219032015', '121903', 'Tanjungmulya', 4),
	('1219032016', '121903', 'Titi Payung', 4),
	('1219032017', '121903', 'Perkotaan', 4),
	('1219032018', '121903', 'Kampung Kelapa', 4),
	('1219041001', '121904', 'Lima Puluh Kota', 3),
	('1219042002', '121904', 'Gambus Laut', 4),
	('1219042003', '121904', 'Air Hitam', 4),
	('1219042004', '121904', 'Bulan Bulan', 4),
	('1219042005', '121904', 'Cahaya Pardomuan', 4),
	('1219042006', '121904', 'Empat Negeri', 4),
	('1219042007', '121904', 'Guntung', 4),
	('1219042008', '121904', 'Kuala Gunung', 4),
	('1219042009', '121904', 'Lubuk Besar', 4),
	('1219042010', '121904', 'Lubuk Cuik', 4),
	('1219042011', '121904', 'Mangkai Baru', 4),
	('1219042012', '121904', 'Mangkai Lama', 4),
	('1219042013', '121904', 'Pematang Panjang', 4),
	('1219042014', '121904', 'Perkebunan Dolok', 4),
	('1219042015', '121904', 'Perk. Kw. Gunung', 4),
	('1219042016', '121904', 'Antara', 4),
	('1219042017', '121904', 'Perk. Lima Puluh', 4),
	('1219042018', '121904', 'Perk. Limau Manis', 4),
	('1219042019', '121904', 'Perk. Tanah Gambus', 4),
	('1219042020', '121904', 'Perk. Tanah Itam Ilir', 4),
	('1219042021', '121904', 'Perk. Tanah Itam Hulu', 4),
	('1219042022', '121904', 'Pulausejuk', 4),
	('1219042023', '121904', 'Perupuk', 4),
	('1219042024', '121904', 'Simpang Dolok', 4),
	('1219042025', '121904', 'Simpang Gambus', 4),
	('1219042026', '121904', 'Sumber Makmur', 4),
	('1219042027', '121904', 'Sumber Padi', 4),
	('1219042028', '121904', 'Pasir Permit', 4),
	('1219042029', '121904', 'Barung-Barung', 4),
	('1219042030', '121904', 'Titi Putih', 4),
	('1219042031', '121904', 'Sumber Rejo', 4),
	('1219042032', '121904', 'Lubuk Hulu', 4),
	('1219042033', '121904', 'Gunungbandung', 4),
	('1219042034', '121904', 'Titi Merah', 4),
	('1219042035', '121904', 'Pematang Tengah', 4),
	('1219051001', '121905', 'Labuhan Ruku', 3),
	('1219052002', '121905', 'Bangun Sari', 4),
	('1219052003', '121905', 'Binjai Baru', 4),
	('1219052004', '121905', 'Dahari Silebar', 4),
	('1219052005', '121905', 'Karang Baru', 4),
	('1219052006', '121905', 'Mesjid Lama', 4),
	('1219052007', '121905', 'Padang Genting', 4),
	('1219052008', '121905', 'Pahang', 4),
	('1219052009', '121905', 'Panjang', 4),
	('1219052010', '121905', 'Perkebunan Petatal', 4),
	('1219052011', '121905', 'Perkebunan Tnh. Datar', 4),
	('1219052012', '121905', 'Petatal', 4),
	('1219052013', '121905', 'Sei Muka', 4),
	('1219052014', '121905', 'Gunungrante', 4),
	('1219052015', '121905', 'Dahari Indah', 4),
	('1219052016', '121905', 'Indra Yaman', 4),
	('1219052017', '121905', 'Benteng', 4),
	('1219052018', '121905', 'Sumber Tani', 4),
	('1219052019', '121905', 'Glugur Makmur', 4),
	('1219052020', '121905', 'Mekar Baru', 4),
	('1219061001', '121906', 'Tanjungtiram', 3),
	('1219061022', '121906', 'Bagan Arya', 3),
	('1219062002', '121906', 'Guntung', 4),
	('1219062003', '121906', 'Bagan Baru', 4),
	('1219062004', '121906', 'Bagan Dalam', 4),
	('1219062005', '121906', 'Bogak', 4),
	('1219062006', '121906', 'Suka Maju', 4),
	('1219062007', '121906', 'Lima Laras', 4),
	('1219062008', '121906', 'Pematang Rambe', 4),
	('1219062009', '121906', 'Tanjungmulia', 4),
	('1219062010', '121906', 'Ujung Kubu', 4),
	('1219062011', '121906', 'Sei Mentaram', 4),
	('1219062012', '121906', 'Sentang', 4),
	('1219062013', '121906', 'Tali Air Permai', 4),
	('1219062014', '121906', 'Kapal Merah', 4),
	('1219062015', '121906', 'Bandar Sono', 4),
	('1219062016', '121906', 'Suka Jaya', 4),
	('1219062017', '121906', 'Pahlawan', 4),
	('1219062018', '121906', 'Bandar Rahmat', 4),
	('1219062019', '121906', 'Kampung Lalang', 4),
	('1219062020', '121906', 'Mekar Laras', 4),
	('1219062021', '121906', 'Jati Mulia', 4),
	('1219072001', '121907', 'Kwala Sikasim', 4),
	('1219072002', '121907', 'Sei Balai', 4),
	('1219072004', '121907', 'Durian', 4),
	('1219072005', '121907', 'Perkebunan Sei Balai', 4),
	('1219072007', '121907', 'Suka Ramai', 4),
	('1219072008', '121907', 'Sei Bejangkar', 4),
	('1219072009', '121907', 'Mekar Mulio', 4),
	('1219072010', '121907', 'Perkebunan Sei Bejangkar', 4),
	('1219072012', '121907', 'Benteng Jaya', 4),
	('1219072013', '121907', 'Tanah Timbul', 4),
	('1219072014', '121907', 'Perjuangan', 4),
	('1219072015', '121907', 'Sidomulio', 4),
	('1219072016', '121907', 'Mekar Baru', 4),
	('1219072017', '121907', 'Suko Rejo', 4),
	('1220012001', '122001', 'Janji Manahan GNT', 4),
	('1220012002', '122001', 'Pasir Lela', 4),
	('1220012003', '122001', 'Aek Jabut', 4),
	('1220012004', '122001', 'Nabundong', 4),
	('1220012005', '122001', 'Gunung Sormin', 4),
	('1220012006', '122001', 'Sihalo Halo', 4),
	('1220012007', '122001', 'Kuala Simpang', 4),
	('1220012008', '122001', 'Simundol', 4),
	('1220012009', '122001', 'Nahula Julu', 4),
	('1220012010', '122001', 'Simaninggir Simundol', 4),
	('1220012011', '122001', 'Simangambat', 4),
	('1220012012', '122001', 'Saba Bangun', 4),
	('1220012013', '122001', 'Malino', 4),
	('1220012014', '122001', 'Gonting Bange', 4),
	('1220012015', '122001', 'Hutaimbaru Simundol', 4),
	('1220012017', '122001', 'Sunut', 4),
	('1220012018', '122001', 'Batu Hibul', 4),
	('1220012019', '122001', 'Sigordang', 4),
	('1220012020', '122001', 'Pamarai', 4),
	('1220012021', '122001', 'Padang Matinggi GNT', 4),
	('1220012022', '122001', 'Gadung Holbung', 4),
	('1220012023', '122001', 'Salusuhan', 4),
	('1220012024', '122001', 'Panyabungan', 4),
	('1220012025', '122001', 'Sayur Matinggi', 4),
	('1220012026', '122001', 'Hasahatan', 4),
	('1220012027', '122001', 'Pinarik', 4),
	('1220012028', '122001', 'Unte Manis', 4),
	('1220012029', '122001', 'Sipogas', 4),
	('1220012030', '122001', 'Sipogas A', 4),
	('1220012031', '122001', 'Padang Malakka', 4),
	('1220012032', '122001', 'Aek Simanap', 4),
	('1220012033', '122001', 'Pulo Liman', 4),
	('1220012034', '122001', 'Aek Kundur', 4),
	('1220012035', '122001', 'Hatiran', 4),
	('1220012036', '122001', 'Karang Anyar', 4),
	('1220012037', '122001', 'Aek Kanan', 4),
	('1220012038', '122001', 'Nahula Jae', 4),
	('1220012039', '122001', 'Simadihon', 4),
	('1220012040', '122001', 'Pasar Sayur Matinggi', 4),
	('1220012041', '122001', 'Tj. Baru Silaiya', 4),
	('1220012042', '122001', 'Sitonun', 4),
	('1220012043', '122001', 'Pasar Simundol', 4),
	('1220012044', '122001', 'Pamonoran', 4),
	('1220022001', '122002', 'Sigugah', 4),
	('1220022002', '122002', 'Siganyal', 4),
	('1220022003', '122002', 'Sibanga Panahasahan', 4),
	('1220022004', '122002', 'Aek Haruaya', 4),
	('1220022005', '122002', 'Tanjung Baru B', 4),
	('1220022006', '122002', 'Pasar Sipiongot', 4),
	('1220022007', '122002', 'Bintais Julu', 4),
	('1220022008', '122002', 'Bunut', 4),
	('1220022009', '122002', 'Paya Ombik', 4),
	('1220022010', '122002', 'Aek Suhat Jae', 4),
	('1220022011', '122002', 'Hutabaru Sil', 4),
	('1220022012', '122002', 'Sijorang', 4),
	('1220022013', '122002', 'Simaninggir Sip', 4),
	('1220022014', '122002', 'Pangaran Julu I', 4),
	('1220022015', '122002', 'Mompang Lombang', 4),
	('1220022016', '122002', 'Janji Manahan Sil', 4),
	('1220022017', '122002', 'Baringin Sip', 4),
	('1220022018', '122002', 'Gunung Maria', 4),
	('1220022019', '122002', 'Mompang Dolok', 4),
	('1220022020', '122002', 'Aek Raotan', 4),
	('1220022021', '122002', 'Sijantung Julu', 4),
	('1220022022', '122002', 'Batu Runding', 4),
	('1220022023', '122002', 'Lubuk Godang', 4),
	('1220022024', '122002', 'Bahap', 4),
	('1220022025', '122002', 'Aek Ilung', 4),
	('1220022026', '122002', 'Tarutung Bolak', 4),
	('1220022027', '122002', 'Sungai Pining', 4),
	('1220022028', '122002', 'Siloung', 4),
	('1220022029', '122002', 'Hutaimbaru Gul', 4),
	('1220022030', '122002', 'Sipiongot', 4),
	('1220022031', '122002', 'Gumbot', 4),
	('1220022032', '122002', 'Gunung Selamat', 4),
	('1220022033', '122002', 'Silogo Logo', 4),
	('1220022034', '122002', 'Lubuk Kundur', 4),
	('1220022035', '122002', 'Jambur Batu', 4),
	('1220022036', '122002', 'Simatorkis', 4),
	('1220022037', '122002', 'Pancaran', 4),
	('1220022038', '122002', 'Naga Saribu', 4),
	('1220022039', '122002', 'Simataniari Jae', 4),
	('1220022040', '122002', 'Janji Manahan Gul', 4),
	('1220022041', '122002', 'Simataniari', 4),
	('1220022042', '122002', 'Parmeraan', 4),
	('1220022043', '122002', 'Panca', 4),
	('1220022044', '122002', 'Dalihan Natolu', 4),
	('1220022045', '122002', 'Sungai Batar', 4),
	('1220022046', '122002', 'Lubuk Lanjang', 4),
	('1220022047', '122002', 'Arse', 4),
	('1220022048', '122002', 'Simangambat Tua', 4),
	('1220022049', '122002', 'Sigala Gala', 4),
	('1220022050', '122002', 'Sibayo Jae', 4),
	('1220022051', '122002', 'Dolok Sanggul', 4),
	('1220022052', '122002', 'Silangge', 4),
	('1220022053', '122002', 'Pijor Koling', 4),
	('1220022054', '122002', 'Pagaran Julu', 4),
	('1220022055', '122002', 'Siala Gundi', 4),
	('1220022056', '122002', 'Siraga HP', 4),
	('1220022057', '122002', 'Aek Sundur', 4),
	('1220022058', '122002', 'Baringin Sil', 4),
	('1220022059', '122002', 'Hula Baringin', 4),
	('1220022060', '122002', 'Nabonggal', 4),
	('1220022061', '122002', 'Purba Tua', 4),
	('1220022062', '122002', 'Tanjung Longat', 4),
	('1220022063', '122002', 'Sibio Bio', 4),
	('1220022064', '122002', 'Situmbaga', 4),
	('1220022065', '122002', 'Sijara Jara', 4),
	('1220022067', '122002', 'Pagaran Siregar', 4),
	('1220022068', '122002', 'Parigi', 4),
	('1220022069', '122002', 'Napasundali', 4),
	('1220022070', '122002', 'Aek Suhat TR', 4),
	('1220022071', '122002', 'Gumarupu', 4),
	('1220022072', '122002', 'Sijantung Jae', 4),
	('1220022073', '122002', 'Janji Matogu', 4),
	('1220022074', '122002', 'Sialang Dolok', 4),
	('1220022075', '122002', 'Binanga Gumbot', 4),
	('1220022076', '122002', 'Simanosor', 4),
	('1220022077', '122002', 'Bukit Tinggi', 4),
	('1220022078', '122002', 'Sigambal', 4),
	('1220022079', '122002', 'Bandar Nauli', 4),
	('1220022080', '122002', 'Sibayo', 4),
	('1220022081', '122002', 'Sinabongan', 4),
	('1220022082', '122002', 'Siranap', 4),
	('1220022083', '122002', 'Aek Tangga', 4),
	('1220022084', '122002', 'Rongkare', 4),
	('1220022085', '122002', 'Sibubur', 4),
	('1220022086', '122002', 'Pintu Padang Merdeka', 4),
	('1220032001', '122003', 'Hutaimbaru', 4),
	('1220032002', '122003', 'Hambulo', 4),
	('1220032003', '122003', 'Paolan', 4),
	('1220032004', '122003', 'Pangirkiran', 4),
	('1220032005', '122003', 'Balimbing', 4),
	('1220032006', '122003', 'Rondaman Siburegar', 4),
	('1220032007', '122003', 'Sipaho', 4),
	('1220032008', '122003', 'Silantoyung', 4),
	('1220032009', '122003', 'Hitte Urat', 4),
	('1220032010', '122003', 'Siboru Angin', 4),
	('1220032011', '122003', 'Sandean Jae', 4),
	('1220032012', '122003', 'Sandean Tonga', 4),
	('1220032013', '122003', 'Sandean Julu', 4),
	('1220032014', '122003', 'Hasahatan', 4),
	('1220032015', '122003', 'Pagar Gunung', 4),
	('1220032016', '122003', 'Pangarambangan', 4),
	('1220032017', '122003', 'Napa Lancat', 4),
	('1220032018', '122003', 'Halongonan', 4),
	('1220032019', '122003', 'Borgot Topong Julu', 4),
	('1220032020', '122003', 'Borgot Topong Jae', 4),
	('1220032021', '122003', 'Siringki Jae', 4),
	('1220032022', '122003', 'Ujang Padang', 4),
	('1220032023', '122003', 'Sigala Gala', 4),
	('1220032024', '122003', 'Pasir Bara', 4),
	('1220032025', '122003', 'Gunung Intan', 4),
	('1220032026', '122003', 'Mompang I', 4),
	('1220032027', '122003', 'Gunung Manaon III', 4),
	('1220032028', '122003', 'Sihopuk Baru', 4),
	('1220032029', '122003', 'Sihopuk Lama', 4),
	('1220032030', '122003', 'Rondaman', 4),
	('1220032031', '122003', 'Siancimun', 4),
	('1220032032', '122003', 'Hutanopan', 4),
	('1220032033', '122003', 'Hutabaru Nangka', 4),
	('1220032034', '122003', 'Situmbaga', 4),
	('1220032035', '122003', 'Bolatan', 4),
	('1220032036', '122003', 'Sipenggeng', 4),
	('1220032037', '122003', 'Saba', 4),
	('1220032038', '122003', 'Sitabola', 4),
	('1220032039', '122003', 'Sitenun', 4),
	('1220032040', '122003', 'Tapus Jae', 4),
	('1220032041', '122003', 'Japinulik', 4),
	('1220032042', '122003', 'Paran Honas', 4),
	('1220032043', '122003', 'Siringki Julu', 4),
	('1220032044', '122003', 'Batu Tunggal', 4),
	('1220041001', '122004', 'Pasar Gunung Tua', 3),
	('1220042002', '122004', 'Gulangan', 4),
	('1220042003', '122004', 'Mompang II', 4),
	('1220042004', '122004', 'Simaninggir', 4),
	('1220042005', '122004', 'Siunggam Julu', 4),
	('1220042006', '122004', 'Siunggam Tonga', 4),
	('1220042007', '122004', 'Siunggam Jae', 4),
	('1220042008', '122004', 'Lubuk Torap', 4),
	('1220042009', '122004', 'Batang Pane I', 4),
	('1220042010', '122004', 'Batang Pane II', 4),
	('1220042011', '122004', 'Batang Pane III', 4),
	('1220042012', '122004', 'Tanjung Marulak', 4),
	('1220042013', '122004', 'Ambasang Natigor', 4),
	('1220042014', '122004', 'Napagadung Laut', 4),
	('1220042015', '122004', 'Rampa Jae', 4),
	('1220042016', '122004', 'Rampa Julu', 4),
	('1220042017', '122004', 'Mananti', 4),
	('1220042018', '122004', 'Parang Padang', 4),
	('1220042019', '122004', 'Rahuning Jae', 4),
	('1220042020', '122004', 'Botung', 4),
	('1220042021', '122004', 'Sigimbal', 4),
	('1220042022', '122004', 'Dolok Sae', 4),
	('1220042023', '122004', 'Simasi', 4),
	('1220042024', '122004', 'Sihapas Hapas', 4),
	('1220042025', '122004', 'Sunge Tolang', 4),
	('1220042026', '122004', 'Losung Batu', 4),
	('1220042027', '122004', 'Batu Mamak', 4),
	('1220042028', '122004', 'Sampuran', 4),
	('1220042029', '122004', 'Gunung Tua Baru', 4),
	('1220042030', '122004', 'Sibatang Kayu', 4),
	('1220042031', '122004', 'Aek Suhat', 4),
	('1220042032', '122004', 'Aek Tolang', 4),
	('1220042033', '122004', 'Tangga Tangga Hambeng', 4),
	('1220042034', '122004', 'Aek Bayur', 4),
	('1220042035', '122004', 'Bangun Purba', 4),
	('1220042036', '122004', 'Naga Saribu', 4),
	('1220042037', '122004', 'Sihoda-hoda', 4),
	('1220042038', '122004', 'Gunung Tua Tonga', 4),
	('1220042039', '122004', 'Gunung Tua Jae', 4),
	('1220042040', '122004', 'Gunung Tua Julu', 4),
	('1220042041', '122004', 'Hutalombang', 4),
	('1220042042', '122004', 'Batang Baruhar Julu', 4),
	('1220042043', '122004', 'Batang Baruhar Jae', 4),
	('1220042044', '122004', 'Purba Sinomba', 4),
	('1220042045', '122004', 'Hambiri', 4),
	('1220042046', '122004', 'Sosopan', 4),
	('1220042047', '122004', 'Pagaran Singkam', 4),
	('1220042048', '122004', 'Pagaran Tonga', 4),
	('1220042049', '122004', 'Sibagasi', 4),
	('1220042050', '122004', 'Batu Tambun', 4),
	('1220042051', '122004', 'Tanjung Tiram', 4),
	('1220042052', '122004', 'Garoga', 4),
	('1220042053', '122004', 'Hajoran', 4),
	('1220042054', '122004', 'Batu Sundung', 4),
	('1220042055', '122004', 'Garonggang', 4),
	('1220042056', '122004', 'Nabongal', 4),
	('1220042057', '122004', 'Liang Hasona', 4),
	('1220042058', '122004', 'Mandi Angin Dolok', 4),
	('1220042059', '122004', 'Mandi Angin Lombang', 4),
	('1220042060', '122004', 'Padang Garugur', 4),
	('1220042061', '122004', 'Simanosor', 4),
	('1220042062', '122004', 'Sigama', 4),
	('1220042063', '122004', 'Sigama Ujung Gading', 4),
	('1220042064', '122004', 'Parlimbatan', 4),
	('1220042065', '122004', 'Saba Sitahul tahul', 4),
	('1220042066', '122004', 'Saba Bangunan', 4),
	('1220042067', '122004', 'Sidikkat', 4),
	('1220042068', '122004', 'Batu Tunggal', 4),
	('1220042069', '122004', 'Gunung Manuan II', 4),
	('1220042070', '122004', 'Purba Tua', 4),
	('1220042071', '122004', 'Sunge Durian', 4),
	('1220042072', '122004', 'Sunge Orosan', 4),
	('1220042073', '122004', 'Hutaimbaru II', 4),
	('1220042074', '122004', 'Siombob', 4),
	('1220042075', '122004', 'Aek Gambir', 4),
	('1220042076', '122004', 'Bukit Raya Sordang', 4),
	('1220042077', '122004', 'Aek Jangkang', 4),
	('1220042078', '122004', 'Simbolon', 4),
	('1220052001', '122005', 'Pancur Pangko', 4),
	('1220052002', '122005', 'Hasambi', 4),
	('1220052003', '122005', 'Paran Nangka', 4),
	('1220052004', '122005', 'Batu Rancang', 4),
	('1220052005', '122005', 'Sitanggoru', 4),
	('1220052006', '122005', 'Siunggam Dolok', 4),
	('1220052007', '122005', 'Balimbing Jae', 4),
	('1220052008', '122005', 'Sipupus Lombang', 4),
	('1220052009', '122005', 'Balimbing Julu', 4),
	('1220052010', '122005', 'Sobar', 4),
	('1220052011', '122005', 'Pamuntaran', 4),
	('1220052012', '122005', 'Paran Gadung', 4),
	('1220052013', '122005', 'Padang Bujur', 4),
	('1220052014', '122005', 'Ubar', 4),
	('1220052015', '122005', 'Lantosan II', 4),
	('1220052016', '122005', 'Batu Gana', 4),
	('1220052017', '122005', 'Padang Baruas', 4),
	('1220052018', '122005', 'Aek Bargot', 4),
	('1220052019', '122005', 'Gariang', 4),
	('1220052020', '122005', 'Balakka', 4),
	('1220052021', '122005', 'Parupuk Jae', 4),
	('1220052022', '122005', 'Parupuk Julu', 4),
	('1220052023', '122005', 'Sialang', 4),
	('1220062001', '122006', 'Pijar Koling', 4),
	('1220062002', '122006', 'Sitopayan', 4),
	('1220062003', '122006', 'Lantosan I', 4),
	('1220062004', '122006', 'Aek Haruaya', 4),
	('1220062005', '122006', 'Gunung Baringin', 4),
	('1220062006', '122006', 'Hadungdung', 4),
	('1220062007', '122006', 'Rondaman Dolok', 4),
	('1220062008', '122006', 'Sipirok', 4),
	('1220062009', '122006', 'Tanjung Salamat', 4),
	('1220062010', '122006', 'Rondaman Lombang', 4),
	('1220062011', '122006', 'Parsarmaan', 4),
	('1220062012', '122006', 'Aloban', 4),
	('1220062013', '122006', 'Portibi Julu', 4),
	('1220062014', '122006', 'Portibi Jae', 4),
	('1220062015', '122006', 'Gunung Manaon', 4),
	('1220062016', '122006', 'Pasir Pinang', 4),
	('1220062017', '122006', 'Bahal', 4),
	('1220062018', '122006', 'Bara', 4),
	('1220062019', '122006', 'Simandiangin', 4),
	('1220062020', '122006', 'Hotang Sasa', 4),
	('1220062021', '122006', 'Aek Siala', 4),
	('1220062022', '122006', 'Gumarupu Baru', 4),
	('1220062023', '122006', 'Padang Manjoir', 4),
	('1220062024', '122006', 'Gumarupu Lama', 4),
	('1220062025', '122006', 'Gunung Martua', 4),
	('1220062026', '122006', 'Sihambeng', 4),
	('1220062027', '122006', 'Aek Torop', 4),
	('1220062028', '122006', 'Napa Lombang', 4),
	('1220062029', '122006', 'Mangaledang Lama', 4),
	('1220062030', '122006', 'Mangaledang', 4),
	('1220062031', '122006', 'Bangkudu', 4),
	('1220062032', '122006', 'Balaka Torop', 4),
	('1220062033', '122006', 'Janji Matogu', 4),
	('1220062034', '122006', 'Muara Sigama', 4),
	('1220062035', '122006', 'Napa Halas', 4),
	('1220062036', '122006', 'Sigama Napahalas', 4),
	('1220062038', '122006', 'Purba Tua Dolok', 4),
	('1220062039', '122006', 'Torluk Muara Dolok', 4),
	('1220072001', '122007', 'Sayur Matinggi', 4),
	('1220072002', '122007', 'Pangkal Dolok Lama', 4),
	('1220072003', '122007', 'Pangkal Dolok Julu', 4),
	('1220072004', '122007', 'Pintu Padang', 4),
	('1220072005', '122007', 'Batang Onang Lama', 4),
	('1220072006', '122007', 'Bonan Dolok', 4),
	('1220072007', '122007', 'Simardona', 4),
	('1220072008', '122007', 'Batang Onang Baru', 4),
	('1220072009', '122007', 'Parau Sorat', 4),
	('1220072010', '122007', 'Pasar Matanggor', 4),
	('1220072011', '122007', 'Batu Pulut', 4),
	('1220072012', '122007', 'Huta Lambung', 4),
	('1220072013', '122007', 'Galanggang', 4),
	('1220072014', '122007', 'Gunung Tua Jati', 4),
	('1220072015', '122007', 'Onang', 4),
	('1220072016', '122007', 'Simanapan', 4),
	('1220072017', '122007', 'Simaninggir PSM', 4),
	('1220072018', '122007', 'Batu Mamak', 4),
	('1220072019', '122007', 'Padang Garugur', 4),
	('1220072020', '122007', 'Padang Matinggi', 4),
	('1220072021', '122007', 'Purba Tua', 4),
	('1220072022', '122007', 'Janji Mauli', 4),
	('1220072023', '122007', 'Sayur Matinggi Julu', 4),
	('1220072024', '122007', 'Gunung Tua Julu', 4),
	('1220072025', '122007', 'Pasir Ampolu Hopong', 4),
	('1220072026', '122007', 'Pagaran Batu', 4),
	('1220072027', '122007', 'Tamosu', 4),
	('1220072028', '122007', 'Simangambat Dolok', 4),
	('1220072029', '122007', 'Janji Manahan', 4),
	('1220072030', '122007', 'Padang Bujur Baru', 4),
	('1220072031', '122007', 'Batu Nanggar', 4),
	('1220072032', '122007', 'Morang', 4),
	('1220082001', '122008', 'Huta Raja', 4),
	('1220082002', '122008', 'Marlaung', 4),
	('1220082003', '122008', 'Mananti', 4),
	('1220082004', '122008', 'Tobing Tinggi UB', 4),
	('1220082005', '122008', 'Ujung Batu Jae', 4),
	('1220082006', '122008', 'Labuhan Jurung', 4),
	('1220082007', '122008', 'Gunung Manaon UB', 4),
	('1220082008', '122008', 'Jambu Tonang', 4),
	('1220082009', '122008', 'Paya Bahung UB', 4),
	('1220082010', '122008', 'Manare Tua', 4),
	('1220082011', '122008', 'Ujung Batu Julu', 4),
	('1220082012', '122008', 'Pasir Lancat UB', 4),
	('1220082013', '122008', 'Martujuan', 4),
	('1220082014', '122008', 'Ulak Tano', 4),
	('1220082015', '122008', 'Aekraru', 4),
	('1220082016', '122008', 'Tanjung Maria', 4),
	('1220082017', '122008', 'Mandasip', 4),
	('1220082018', '122008', 'Huta Baru', 4),
	('1220082019', '122008', 'Janji Matogu SIM', 4),
	('1220082020', '122008', 'Paran Padang', 4),
	('1220082021', '122008', 'Tanjung Botung', 4),
	('1220082022', '122008', 'Huta Pasir', 4),
	('1220082023', '122008', 'Langkimat', 4),
	('1220082024', '122008', 'Jabi Jabi', 4),
	('1220082025', '122008', 'Simangambat Jae', 4),
	('1220082026', '122008', 'Ujung Gading Jae', 4),
	('1220082027', '122008', 'Huta Baringin', 4),
	('1220082028', '122008', 'Gunung Manaon Sim', 4),
	('1220082029', '122008', 'Sionggoton', 4),
	('1220082030', '122008', 'Paran Tonga Sim', 4),
	('1220082031', '122008', 'Ujung Gading Julu', 4),
	('1220082032', '122008', 'Simangambat Julu', 4),
	('1220082033', '122008', 'Sigagan', 4),
	('1220082034', '122008', 'Kosik Putih', 4),
	('1220092001', '122009', 'Aek Godang', 4),
	('1220092002', '122009', 'Aek Nauli', 4),
	('1220092003', '122009', 'Sampuran Simarloting', 4),
	('1220092004', '122009', 'Pangirkiran', 4),
	('1220092005', '122009', 'Simaninggir', 4),
	('1220092006', '122009', 'Suka Dame', 4),
	('1220092007', '122009', 'Pintu Bosi', 4),
	('1220092008', '122009', 'Sidong-dong', 4),
	('1220092009', '122009', 'Sitabar', 4),
	('1220092010', '122009', 'Parmeraan', 4),
	('1221012001', '122101', 'Pagaran Bira Jae', 4),
	('1221012002', '122101', 'Pagaran Bira Julu', 4),
	('1221012003', '122101', 'Huta Bargot', 4),
	('1221012004', '122101', 'Siundol Jae', 4),
	('1221012005', '122101', 'Siundol Julu', 4),
	('1221012006', '122101', 'Siundol Dolok', 4),
	('1221012007', '122101', 'Huta Baru Siundol', 4),
	('1221012008', '122101', 'Binanga Tolu', 4),
	('1221012009', '122101', 'Aek Bargot', 4),
	('1221012010', '122101', 'Ulu Aer', 4),
	('1221012011', '122101', 'Hulim', 4),
	('1221012012', '122101', 'Sianggunan', 4),
	('1221012013', '122101', 'Simaninggir Sosopan', 4),
	('1221012014', '122101', 'Sibualbuali', 4),
	('1221012015', '122101', 'Sosopan', 4),
	('1221012016', '122101', 'Sigala-Gala', 4),
	('1221012017', '122101', 'Sihaporas', 4),
	('1221012018', '122101', 'Banua Tonga', 4),
	('1221012019', '122101', 'Sosopan Julu', 4),
	('1221012020', '122101', 'Huta Bara', 4),
	('1221012021', '122101', 'Huta Baru Sosopan', 4),
	('1221012022', '122101', 'Simartolu', 4),
	('1221022001', '122102', 'Gunung Baringin', 4),
	('1221022002', '122102', 'Pasar Binanga', 4),
	('1221022003', '122102', 'Sihaborgoan Dalan', 4),
	('1221022004', '122102', 'Aek Tanduk', 4),
	('1221022005', '122102', 'PP. Makmur', 4),
	('1221022006', '122102', 'Siboris Bahal', 4),
	('1221022007', '122102', 'Bangkudu', 4),
	('1221022008', '122102', 'Siolip', 4),
	('1221022009', '122102', 'Aek Tunjang', 4),
	('1221022010', '122102', 'Binanga', 4),
	('1221022011', '122102', 'Manombo', 4),
	('1221022012', '122102', 'Janji Raja', 4),
	('1221022013', '122102', 'Pangirkiran Dolok', 4),
	('1221022014', '122102', 'Sihaborgoan Barumun', 4),
	('1221022015', '122102', 'Siboris Dolok', 4),
	('1221022016', '122102', 'Padang Matinggi', 4),
	('1221022017', '122102', 'Tandihat', 4),
	('1221022018', '122102', 'Bara Batu', 4),
	('1221022019', '122102', 'Bahal Batu', 4),
	('1221022020', '122102', 'Ginduang Batu', 4),
	('1221022021', '122102', 'Padang Garugur', 4),
	('1221022022', '122102', 'Gunung Manaon', 4),
	('1221022023', '122102', 'Siboris Lombang', 4),
	('1221022024', '122102', 'Janji Matogu', 4),
	('1221022025', '122102', 'Gunung Malintang', 4),
	('1221022026', '122102', 'Sibatu Loting', 4),
	('1221022027', '122102', 'Sisalean', 4),
	('1221022028', '122102', 'Janji Manahan', 4),
	('1221022029', '122102', 'Siparau', 4),
	('1221022030', '122102', 'Unterudang', 4),
	('1221022053', '122102', 'Huta Ruhom', 4),
	('1221022056', '122102', 'Paran Napa Dolok', 4),
	('1221022061', '122102', 'Bire', 4),
	('1221022065', '122102', 'Gading', 4),
	('1221022067', '122102', 'Paran Napa Jae', 4),
	('1221022068', '122102', 'Sibontar', 4),
	('1221022070', '122102', 'Aek Siala', 4),
	('1221022071', '122102', 'Batusundung', 4),
	('1221022072', '122102', 'Sidongdong', 4),
	('1221032001', '122103', 'Binanga Tolu', 4),
	('1221032002', '122103', 'Tanjung Baringin', 4),
	('1221032003', '122103', 'Huristak', 4),
	('1221032004', '122103', 'Paran Tonga', 4),
	('1221032005', '122103', 'Gonting Julu', 4),
	('1221032006', '122103', 'Bulu Cina', 4),
	('1221032007', '122103', 'Sigading', 4),
	('1221032008', '122103', 'Pasir Lancat Lama', 4),
	('1221032009', '122103', 'Siala Gundi', 4),
	('1221032010', '122103', 'Tobing Julu', 4),
	('1221032011', '122103', 'Tar Sihoda-Hoda', 4),
	('1221032012', '122103', 'Huta Pasir Ulak Tano', 4),
	('1221032013', '122103', 'Tobing Jae', 4),
	('1221032014', '122103', 'Pasar Huristak', 4),
	('1221032015', '122103', 'Sipirok Baru', 4),
	('1221032016', '122103', 'Pasir Lancat Baru', 4),
	('1221032017', '122103', 'Tobing Tinggi', 4),
	('1221032018', '122103', 'Ganal', 4),
	('1221032019', '122103', 'Paya Bujing', 4),
	('1221032020', '122103', 'Pulo Bariang', 4),
	('1221032021', '122103', 'Ramba', 4),
	('1221032022', '122103', 'Gonting Jae', 4),
	('1221032023', '122103', 'Gala Bonang', 4),
	('1221032024', '122103', 'Tanjung Morang', 4),
	('1221032025', '122103', 'Gunung Manaon', 4),
	('1221032026', '122103', 'Gunung Matinggi', 4),
	('1221032027', '122103', 'Pasir Pinang', 4),
	('1221042001', '122104', 'Janji Matogu', 4),
	('1221042002', '122104', 'Pagaran Silindung', 4),
	('1221042003', '122104', 'Tangga Bosi', 4),
	('1221042004', '122104', 'Hutaibus', 4),
	('1221042005', '122104', 'Pagaran Jalu-Jalu', 4),
	('1221042006', '122104', 'Hutanopan', 4),
	('1221042007', '122104', 'Pasar Latong', 4),
	('1221042008', '122104', 'Pagaran Jae Batu', 4),
	('1221042009', '122104', 'Aek Lancat', 4),
	('1221042010', '122104', 'Batang Tanggal Baru', 4),
	('1221042011', '122104', 'Bonal', 4),
	('1221042012', '122104', 'Pagaran Malaka', 4),
	('1221042013', '122104', 'Huta Dolok', 4),
	('1221042014', '122104', 'Gunung Manobot', 4),
	('1221042015', '122104', 'Batang Bulu Jae', 4),
	('1221042016', '122104', 'Suro Dingin', 4),
	('1221042017', '122104', 'Janji Lobi Lima', 4),
	('1221042018', '122104', 'Sangkilon', 4),
	('1221042019', '122104', 'Siali-Ali', 4),
	('1221042020', '122104', 'Huta Lombang', 4),
	('1221042021', '122104', 'Pagaran Mompang', 4),
	('1221042022', '122104', 'Parsombaan', 4),
	('1221042023', '122104', 'Sihiuk', 4),
	('1221042024', '122104', 'Batang Bulu Tanggal', 4),
	('1221052001', '122105', 'Simangambat', 4),
	('1221052002', '122105', 'Sigala-Gala', 4),
	('1221052003', '122105', 'Tanjung Ale', 4),
	('1221052004', '122105', 'Lubuk Bunut', 4),
	('1221052005', '122105', 'Ujung Padang', 4),
	('1221052006', '122105', 'Tanjung Baringin', 4),
	('1221052007', '122105', 'Sibodak Sosa Jae', 4),
	('1221052008', '122105', 'Parmainan', 4),
	('1221052009', '122105', 'Pagaran Dolok Sosa Jae', 4),
	('1221052010', '122105', 'Aliaga', 4),
	('1221052011', '122105', 'Mananti Sosa Jae', 4),
	('1221052012', '122105', 'Panyabungan', 4),
	('1221052013', '122105', 'Pasar Panyabungan', 4),
	('1221052014', '122105', 'Sigalapung', 4),
	('1221052015', '122105', 'Siabu', 4),
	('1221052016', '122105', 'Paya Ombur', 4),
	('1221052017', '122105', 'Hutaraja Tinggi', 4),
	('1221052018', '122105', 'Sungai Korang', 4),
	('1221052019', '122105', 'Ujung Batu I', 4),
	('1221052020', '122105', 'Ujung Batu II', 4),
	('1221052021', '122105', 'Ujung Batu III', 4),
	('1221052022', '122105', 'Ujung Batu IV', 4),
	('1221052023', '122105', 'Ujung Batu V', 4),
	('1221052024', '122105', 'Pirtrans Sosa I A', 4),
	('1221052025', '122105', 'Pirtrans Sosa I B', 4),
	('1221052026', '122105', 'Pirtrans Sosa III A', 4),
	('1221052027', '122105', 'Pirtrans Sosa III B', 4),
	('1221052028', '122105', 'Pirtrans Sosa II', 4),
	('1221052029', '122105', 'Pirtrans Sosa IV', 4),
	('1221052030', '122105', 'Pirtrans Sosa V', 4),
	('1221052031', '122105', 'Pirtrans Sosa VI', 4),
	('1221062001', '122106', 'Simanuldang Jae', 4),
	('1221062002', '122106', 'Simanuldang Julu', 4),
	('1221062003', '122106', 'Tapian Nauli', 4),
	('1221062004', '122106', 'Handang Kopo', 4),
	('1221062005', '122106', 'Sibulus Salam', 4),
	('1221062006', '122106', 'Pintu Padang', 4),
	('1221062007', '122106', 'Matondang', 4),
	('1221062008', '122106', 'Pasar Ipuh', 4),
	('1221062009', '122106', 'Paringgonan', 4),
	('1221062010', '122106', 'Paringgonan Julu', 4),
	('1221062011', '122106', 'Paran Batu', 4),
	('1221062012', '122106', 'Sibual Buali', 4),
	('1221062013', '122106', 'Tanjung', 4),
	('1221062014', '122106', 'Siraisan', 4),
	('1221062015', '122106', 'Aek Haruaya', 4),
	('1221071001', '122107', 'Pasar Sibuhuan', 3),
	('1221072002', '122107', 'Sibuhuan Julu', 4),
	('1221072003', '122107', 'Bangun Raya', 4),
	('1221072004', '122107', 'Purba Tua', 4),
	('1221072005', '122107', 'Handis Julu', 4),
	('1221072006', '122107', 'Sialambue', 4),
	('1221072007', '122107', 'Sibuhuan Jae', 4),
	('1221072008', '122107', 'Janji Lobi', 4),
	('1221072009', '122107', 'Hasahatan Jae', 4),
	('1221072010', '122107', 'Siolip', 4),
	('1221072011', '122107', 'Sabarimba', 4),
	('1221072012', '122107', 'Binabo Julu', 4),
	('1221072013', '122107', 'Binabo Jae', 4),
	('1221072014', '122107', 'Limbong', 4),
	('1221072015', '122107', 'Simaninggir', 4),
	('1221072016', '122107', 'Hasahatan Julu', 4),
	('1221072017', '122107', 'Sitarolo Julu', 4),
	('1221072018', '122107', 'Mompang', 4),
	('1221072019', '122107', 'Sigorbus Jae', 4),
	('1221072020', '122107', 'Sabahotang', 4),
	('1221072021', '122107', 'Tanjung Durian', 4),
	('1221072022', '122107', 'Tanjung Botung', 4),
	('1221072023', '122107', 'Tano Bato', 4),
	('1221072024', '122107', 'Hutarimbaru', 4),
	('1221072025', '122107', 'Sayurmatua', 4),
	('1221072037', '122107', 'Bulusonik', 4),
	('1221072038', '122107', 'Arse Simatorkis', 4),
	('1221072039', '122107', 'Pancaukan', 4),
	('1221072040', '122107', 'Pagaran Baringin', 4),
	('1221072041', '122107', 'Sigorbus Julu', 4),
	('1221082001', '122108', 'Siborna Bunut', 4),
	('1221082002', '122108', 'Hurung Jilok', 4),
	('1221082003', '122108', 'Pasir Jae', 4),
	('1221082004', '122108', 'Harang Julu', 4),
	('1221082005', '122108', 'Parapat', 4),
	('1221082006', '122108', 'Pasar Ujung Batu', 4),
	('1221082007', '122108', 'Hapung', 4),
	('1221082008', '122108', 'Plasma Mondang', 4),
	('1221082009', '122108', 'Mandian', 4),
	('1221082010', '122108', 'Bonan Dolok', 4),
	('1221082011', '122108', 'Hutaimbaru', 4),
	('1221082012', '122108', 'Mondang', 4),
	('1221082013', '122108', 'Sisoma', 4),
	('1221082014', '122108', 'Aek Tinga', 4),
	('1221082015', '122108', 'Gunung Baringin', 4),
	('1221082016', '122108', 'Simarancar', 4),
	('1221082017', '122108', 'Huta Raja Lamo', 4),
	('1221082018', '122108', 'Tanjung Botung S. Jae', 4),
	('1221082019', '122108', 'Ujung Batu', 4),
	('1221082020', '122108', 'Janji Raja', 4),
	('1221082021', '122108', 'Rao-Rao Dolok', 4),
	('1221082022', '122108', 'Parau Sorat', 4),
	('1221082023', '122108', 'Aer Bale', 4),
	('1221082024', '122108', 'Tanjung Bale', 4),
	('1221082025', '122108', 'Ampolu', 4),
	('1221082026', '122108', 'Mananti Sosa Julu', 4),
	('1221082027', '122108', 'Siginduang', 4),
	('1221082028', '122108', 'Ramba', 4),
	('1221082029', '122108', 'Roburan', 4),
	('1221082030', '122108', 'Tanjung', 4),
	('1221082031', '122108', 'Sungai Jior', 4),
	('1221082032', '122108', 'Lumban Huayan', 4),
	('1221082033', '122108', 'Pasir Julu', 4),
	('1221082034', '122108', 'Hapung Torop', 4),
	('1221082035', '122108', 'Batu Gajah', 4),
	('1221082036', '122108', 'Harang Jae', 4),
	('1221082037', '122108', 'Horuon', 4),
	('1221082038', '122108', 'Gunung Tua', 4),
	('1221082039', '122108', 'Handio', 4),
	('1221092001', '122109', 'Tanjung Baru', 4),
	('1221092002', '122109', 'Tamiang', 4),
	('1221092003', '122109', 'Tanjung Barani', 4),
	('1221092004', '122109', 'Manggis', 4),
	('1221092005', '122109', 'Pagaran Tayas', 4),
	('1221092006', '122109', 'Hatongga', 4),
	('1221092007', '122109', 'Botung', 4),
	('1221092008', '122109', 'Siadam', 4),
	('1221092009', '122109', 'Siojo', 4),
	('1221092010', '122109', 'Pagaran Manggis', 4),
	('1221092011', '122109', 'Muara Malinto Lamo', 4),
	('1221092012', '122109', 'Hutabaru', 4),
	('1221092013', '122109', 'Huta Nopan', 4),
	('1221092014', '122109', 'Tandolan', 4),
	('1221092015', '122109', 'Tangga Batu', 4),
	('1221092016', '122109', 'Pagaran Dolok Pinarik', 4),
	('1221092017', '122109', 'Muara Malinto Baru', 4),
	('1221092018', '122109', 'Aek Sorik', 4),
	('1221092019', '122109', 'Tanjung Botung Pinarik', 4),
	('1221092020', '122109', 'Pinarik', 4),
	('1221092021', '122109', 'Rombayan', 4),
	('1221092022', '122109', 'Salambue', 4),
	('1221092023', '122109', 'Papaso', 4),
	('1221092024', '122109', 'Muara Tige', 4),
	('1221092025', '122109', 'Sibodak Papaso', 4),
	('1221092026', '122109', 'Pagaran Baringin', 4),
	('1221092027', '122109', 'Gunung Intan', 4),
	('1221092028', '122109', 'Gunung Manaon', 4),
	('1221102001', '122110', 'Batang Bulu Lama', 4),
	('1221102002', '122110', 'Pagur Satio', 4),
	('1221102003', '122110', 'Batang Bulu Baru', 4),
	('1221102004', '122110', 'Gunung Intan', 4),
	('1221102005', '122110', 'Tanjung Purba Tua', 4),
	('1221102006', '122110', 'Banua Tonga', 4),
	('1221102007', '122110', 'Gunung Barani', 4),
	('1221102008', '122110', 'Tanjung Baringin S', 4),
	('1221102009', '122110', 'Sayur Mahincat', 4),
	('1221102010', '122110', 'Sidomulio', 4),
	('1221102011', '122110', 'Panarian', 4),
	('1221112001', '122111', 'Aek Nabara Tonga', 4),
	('1221112002', '122111', 'Aek Nabara Jae', 4),
	('1221112003', '122111', 'Padang Garugur Jae', 4),
	('1221112004', '122111', 'Huta Bargot', 4),
	('1221112005', '122111', 'Janji Maria', 4),
	('1221112006', '122111', 'Padang Garugur Julu', 4),
	('1221112007', '122111', 'Sidokan', 4),
	('1221112008', '122111', 'Tobing', 4),
	('1221112009', '122111', 'Hadungdung Aek Rampah', 4),
	('1221112010', '122111', 'Tobing Tinggi', 4),
	('1221112011', '122111', 'Sipagabu', 4),
	('1221112012', '122111', 'Tanjung', 4),
	('1221112013', '122111', 'Paran Tonga', 4),
	('1221112014', '122111', 'Paran Julu', 4),
	('1221112015', '122111', 'Hadungdung Pintu Padang', 4),
	('1221112016', '122111', 'Tanjung Rokan', 4),
	('1221112017', '122111', 'Aek Bonban', 4),
	('1221112018', '122111', 'Marenu', 4),
	('1221112019', '122111', 'Aek Nabara Julu', 4),
	('1221112020', '122111', 'Padang Garugur Tonga', 4),
	('1221112021', '122111', 'Bangkuang', 4),
	('1221112022', '122111', 'Paya bahung', 4),
	('1221112023', '122111', 'Aek Buaton', 4),
	('1221112024', '122111', 'Sayur Matua', 4),
	('1221112025', '122111', 'Sayur Mahincat', 4),
	('1221122001', '122112', 'Lubuk Gonting', 4),
	('1221122002', '122112', 'Padang Hasior Dolok', 4),
	('1221122003', '122112', 'Padang Hasior Lombang', 4),
	('1221122004', '122112', 'Sitada-Tada', 4),
	('1221122005', '122112', 'Paran Dolok', 4),
	('1221122006', '122112', 'Ujung Gading', 4),
	('1221122007', '122112', 'Simaninggir', 4),
	('1221122008', '122112', 'Tanjung Morang', 4),
	('1221122009', '122112', 'Silenjeng', 4),
	('1221122010', '122112', 'Aek Goti', 4),
	('1221122011', '122112', 'Gulangan', 4),
	('1221122012', '122112', 'Ujung Padang', 4),
	('1221122013', '122112', 'Balangka', 4),
	('1222011001', '122201', 'Kota Pinang', 3),
	('1222012002', '122201', 'Simatahari', 4),
	('1222012003', '122201', 'Mampang', 4),
	('1222012004', '122201', 'Pasir Tuntung', 4),
	('1222012005', '122201', 'Sisumut', 4),
	('1222012006', '122201', 'Hadundung', 4),
	('1222012007', '122201', 'Sosopan', 4),
	('1222012008', '122201', 'Perkebunan Nomark', 4),
	('1222012009', '122201', 'Perkebunan Nagodang', 4),
	('1222012010', '122201', 'Perk. Sei Rumbia', 4),
	('1222022001', '122202', 'Perk. Pelabian', 4),
	('1222022002', '122202', 'Perk. Teluk Panji', 4),
	('1222022003', '122202', 'Perk. Tolan I/II', 4),
	('1222022004', '122202', 'Perk. Batang Saponggol', 4),
	('1222022005', '122202', 'Perk. Tolan', 4),
	('1222022006', '122202', 'Air Merah', 4),
	('1222022007', '122202', 'Teluk Panji', 4),
	('1222022008', '122202', 'Tanjung Medan', 4),
	('1222022009', '122202', 'Kampung Perlabian', 4),
	('1222022010', '122202', 'Tanjung Selamat', 4),
	('1222022011', '122202', 'Tanjung Mulia', 4),
	('1222022012', '122202', 'Teluk Panji I', 4),
	('1222022013', '122202', 'Teluk Panji II', 4),
	('1222022014', '122202', 'Teluk Panji III', 4),
	('1222022015', '122202', 'Teluk Panji IV', 4),
	('1222032001', '122203', 'Bangai', 4),
	('1222032002', '122203', 'Rasau', 4),
	('1222032003', '122203', 'Teluk Rampah', 4),
	('1222032004', '122203', 'Pangarungan', 4),
	('1222032005', '122203', 'Bunut', 4),
	('1222032006', '122203', 'Aek Batu', 4),
	('1222032007', '122203', 'Pinang Damai', 4),
	('1222032008', '122203', 'Aek Raso', 4),
	('1222032009', '122203', 'Torgamba', 4),
	('1222032010', '122203', 'Asam Jawa', 4),
	('1222032011', '122203', 'Torganda', 4),
	('1222032012', '122203', 'Beringin Jaya', 4),
	('1222032013', '122203', 'Bukit Tujuh', 4),
	('1222032014', '122203', 'Sei Meranti', 4),
	('1222041001', '122204', 'Langga Payung', 3),
	('1222042002', '122204', 'Batang Nadenggan', 4),
	('1222042003', '122204', 'Sabungan', 4),
	('1222042004', '122204', 'Hajoran', 4),
	('1222042005', '122204', 'Ujung Gading', 4),
	('1222042006', '122204', 'Huta Godang', 4),
	('1222042007', '122204', 'Parimburan', 4),
	('1222042008', '122204', 'Sampean', 4),
	('1222042009', '122204', 'Marsonja', 4),
	('1222052001', '122205', 'Mandala Sena', 4),
	('1222052002', '122205', 'Binanga II', 4),
	('1222052003', '122205', 'Aek Goti', 4),
	('1222052004', '122205', 'Ulu Mahuam', 4),
	('1222052005', '122205', 'Rintis', 4),
	('1222052006', '122205', 'Sukadame', 4),
	('1223011001', '122301', 'Aek Kanopan', 3),
	('1223011002', '122301', 'Aek Kanopan Timur', 3),
	('1223012003', '122301', 'Kuala Beringin', 4),
	('1223012004', '122301', 'Perpaudangan', 4),
	('1223012005', '122301', 'Pulo Dogom', 4),
	('1223012006', '122301', 'Perkebunan Londut', 4),
	('1223012007', '122301', 'Perkebunan Kanopan Ulu', 4),
	('1223012008', '122301', 'Perkebunan Mambang Muda', 4),
	('1223012009', '122301', 'Perkebunan Labuhan Haji', 4),
	('1223012010', '122301', 'Perkebunan Hanna', 4),
	('1223012011', '122301', 'Sonomartani', 4),
	('1223012012', '122301', 'Sukarame', 4),
	('1223012013', '122301', 'Sukarame Baru', 4),
	('1223021001', '122302', 'Tanjung Leidong', 3),
	('1223022002', '122302', 'Teluk Pulai Dalam', 4),
	('1223022003', '122302', 'Teluk Pulai Luar', 4),
	('1223022004', '122302', 'Kelapa Sebatang', 4),
	('1223022005', '122302', 'Simandulang', 4),
	('1223022006', '122302', 'Air Hitam', 4),
	('1223022007', '122302', 'Pangkalan Lunang', 4),
	('1223031001', '122303', 'Kampung Mesjid', 3),
	('1223032002', '122303', 'Kuala Bangka', 4),
	('1223032003', '122303', 'Sei Sentang', 4),
	('1223032004', '122303', 'Teluk Piai', 4),
	('1223032005', '122303', 'Tanjung Mangedar', 4),
	('1223032006', '122303', 'Teluk Binjai', 4),
	('1223032007', '122303', 'Sei Apung', 4),
	('1223042001', '122304', 'Aek Korsik', 4),
	('1223042002', '122304', 'Bandar Selamat', 4),
	('1223042003', '122304', 'Perk. Padang Halaban', 4),
	('1223042004', '122304', 'Perkebunan Panigoran', 4),
	('1223042005', '122304', 'Sidomulyo', 4),
	('1223042006', '122304', 'Karang Anyer', 4),
	('1223042007', '122304', 'Padang Maninjau', 4),
	('1223042008', '122304', 'Purworejo', 4),
	('1223051001', '122305', 'Marbau', 3),
	('1223052002', '122305', 'Perkebunan Pernantian', 4),
	('1223052003', '122305', 'Perk. Marbau Selatan', 4),
	('1223052004', '122305', 'Perkebunan Milano', 4),
	('1223052005', '122305', 'Perkebuanan Brussel', 4),
	('1223052006', '122305', 'Pulo Bargot', 4),
	('1223052007', '122305', 'Siparepare Tengah', 4),
	('1223052008', '122305', 'Siparepare Hilir', 4),
	('1223052009', '122305', 'Tubiran', 4),
	('1223052010', '122305', 'Belongkut', 4),
	('1223052011', '122305', 'Simpang Empat', 4),
	('1223052012', '122305', 'Babussalam', 4),
	('1223052013', '122305', 'Marbau Selatan', 4),
	('1223052014', '122305', 'Aek Tapa', 4),
	('1223052015', '122305', 'Lobu Rampah', 4),
	('1223052016', '122305', 'Bulungihit', 4),
	('1223052017', '122305', 'Aek Hitetoras', 4),
	('1223052018', '122305', 'Sumber Mulyo', 4),
	('1223061001', '122306', 'Aek Kota Batu', 3),
	('1223062002', '122306', 'Pematang', 4),
	('1223062003', '122306', 'Batu Tunggal', 4),
	('1223062004', '122306', 'Sungai Raja', 4),
	('1223062005', '122306', 'Perkebunan Berangir', 4),
	('1223062006', '122306', 'Silumajang', 4),
	('1223062007', '122306', 'Pulo Jantan', 4),
	('1223062008', '122306', 'Kampung Pajak', 4),
	('1223062009', '122306', 'Meranti Omas', 4),
	('1223062010', '122306', 'Hatapang', 4),
	('1223062011', '122306', 'Pasang Lela', 4),
	('1223062012', '122306', 'Simpang Marbau', 4),
	('1223062013', '122306', 'Bangun Rejo', 4),
	('1223071001', '122307', 'Bandar Durian', 3),
	('1223072002', '122307', 'Poldung', 4),
	('1223072003', '122307', 'Rombisan', 4),
	('1223072004', '122307', 'Sibito', 4),
	('1223072005', '122307', 'Simonis', 4),
	('1223072006', '122307', 'Perkebunan Aek Pamingke', 4),
	('1223072007', '122307', 'Pangkalan', 4),
	('1223072008', '122307', 'Adian Torop', 4),
	('1223072009', '122307', 'Ujung Padang', 4),
	('1223072010', '122307', 'Kampung Yaman', 4),
	('1223072011', '122307', 'Terang Bulan', 4),
	('1223072012', '122307', 'Perkebunan Halimbe', 4),
	('1223081001', '122308', 'Gunting Saga', 3),
	('1223082002', '122308', 'Damuli Pekan', 4),
	('1223082003', '122308', 'Siamporik', 4),
	('1223082004', '122308', 'Lobu Huala', 4),
	('1223082005', '122308', 'Gunung Melayu', 4),
	('1223082006', '122308', 'Damuli Kebun', 4),
	('1223082007', '122308', 'Hasang', 4),
	('1223082008', '122308', 'Bandar Lama', 4),
	('1223082009', '122308', 'Sidua-dua', 4),
	('1223082010', '122308', 'Simangalam', 4),
	('1223082011', '122308', 'Tanjung Pasir', 4),
	('1223082012', '122308', 'Sialang Taji', 4),
	('1224012001', '122401', 'Hilidundra', 4),
	('1224012002', '122401', 'Lawira Satua', 4),
	('1224012003', '122401', 'Fadoro Ulolo', 4),
	('1224012004', '122401', 'Lawira I', 4),
	('1224012005', '122401', 'Hiligodu', 4),
	('1224012006', '122401', 'Lombuzaua', 4),
	('1224012007', '122401', 'Maziaya', 4),
	('1224012008', '122401', 'Baho', 4),
	('1224012009', '122401', 'Lolofaoso', 4),
	('1224012010', '122401', 'Lawira II', 4),
	('1224012011', '122401', 'Dahadando', 4),
	('1224012012', '122401', 'Lolomboli', 4),
	('1224012013', '122401', 'Hiligeo Afia', 4),
	('1224022001', '122402', 'Seriwa\'u', 4),
	('1224022002', '122402', 'Ombolata Sawo', 4),
	('1224022003', '122402', 'Sanawuyu', 4),
	('1224022004', '122402', 'Onozitoli Sawo', 4),
	('1224022005', '122402', 'Sifahandro', 4),
	('1224022006', '122402', 'Sisarahili Tlk Siabang', 4),
	('1224022007', '122402', 'Lasara Sowu', 4),
	('1224022008', '122402', 'Sawo', 4),
	('1224022009', '122402', 'Hiliduruwa', 4),
	('1224022010', '122402', 'Teluk Bengkuang', 4),
	('1224032001', '122403', 'Botolakha', 4),
	('1224032002', '122403', 'Siofa Banua', 4),
	('1224032003', '122403', 'La\'aya', 4),
	('1224032004', '122403', 'Alo\'oa', 4),
	('1224032005', '122403', 'Ladara', 4),
	('1224032006', '122403', 'Banua Gea', 4),
	('1224032007', '122403', 'Silima Banua', 4),
	('1224032008', '122403', 'Fino', 4),
	('1224042001', '122404', 'Tetehosi Maziaya', 4),
	('1224042002', '122404', 'Umbubalodano', 4),
	('1224042003', '122404', 'Hilimbosi', 4),
	('1224042004', '122404', 'Hilisalo\'o', 4),
	('1224042005', '122404', 'Fulolo Salo\'o', 4),
	('1224042006', '122404', 'Botombawo', 4),
	('1224052001', '122405', 'Berua', 4),
	('1224052002', '122405', 'Esiwa', 4),
	('1224052003', '122405', 'Dahana Hiligodu', 4),
	('1224052004', '122405', 'Hilibanua', 4),
	('1224052005', '122405', 'Sisarahili', 4),
	('1224052006', '122405', 'Sisobahili', 4),
	('1224052007', '122405', 'Lasara', 4),
	('1224052008', '122405', 'Namohalu', 4),
	('1224052009', '122405', 'Tuhenakhe I', 4),
	('1224052010', '122405', 'Orahili', 4),
	('1224052011', '122405', 'Banua Sibohou', 4),
	('1224062001', '122406', 'Banua Sibohou III', 4),
	('1224062002', '122406', 'Harefanaese', 4),
	('1224062003', '122406', 'Hilimbowo Kare', 4),
	('1224062004', '122406', 'Laehuwa', 4),
	('1224062005', '122406', 'Mazingo', 4),
	('1224062006', '122406', 'Hilina\'a', 4),
	('1224072001', '122407', 'Bitaya', 4),
	('1224072002', '122407', 'Lahemboho', 4),
	('1224072003', '122407', 'Anaoma', 4),
	('1224072004', '122407', 'Dahana Tugala Oyo', 4),
	('1224072005', '122407', 'Fulolo', 4),
	('1224072006', '122407', 'Hiligawoni', 4),
	('1224072007', '122407', 'Ononamolo Tumula', 4),
	('1224072008', '122407', 'Banua Sibohou I', 4),
	('1224072009', '122407', 'Ombolata', 4),
	('1224072010', '122407', 'Banua Sibohou II', 4),
	('1224072011', '122407', 'Dahana Alasa', 4),
	('1224072012', '122407', 'Ononamolo Alasa', 4),
	('1224072013', '122407', 'Loloana\'a', 4),
	('1224072014', '122407', 'Siwabanua', 4),
	('1224082001', '122408', 'Te\'olo', 4),
	('1224082002', '122408', 'Siwawo', 4),
	('1224082003', '122408', 'Fabaliwa Oyo', 4),
	('1224082004', '122408', 'Ononazara', 4),
	('1224082005', '122408', 'Humene Siheneasi', 4),
	('1224082006', '122408', 'Gunung Tua', 4),
	('1224082007', '122408', 'Botona\'ai', 4),
	('1224082008', '122408', 'Harefa', 4),
	('1224092001', '122409', 'Afulu', 4),
	('1224092002', '122409', 'Lauru Fadoro', 4),
	('1224092003', '122409', 'Lauru I', 4),
	('1224092004', '122409', 'Ombolata Afulu', 4),
	('1224092005', '122409', 'Harewakhe', 4),
	('1224092006', '122409', 'Sisobahili', 4),
	('1224092007', '122409', 'Lauru Lahewa', 4),
	('1224092008', '122409', 'Sifaoro\'asi', 4),
	('1224092009', '122409', 'Faekhuna\'a', 4),
	('1224101001', '122410', 'Pasar Lahewa', 3),
	('1224102002', '122410', 'Iraono Lase', 4),
	('1224102003', '122410', 'Holi', 4),
	('1224102004', '122410', 'Sifaoro\'asi', 4),
	('1224102005', '122410', 'Hilizukhu', 4),
	('1224102006', '122410', 'Onozalukhu', 4),
	('1224102007', '122410', 'Hilina\'a', 4),
	('1224102008', '122410', 'Hiligodu Hoya', 4),
	('1224102009', '122410', 'Sitolubanua', 4),
	('1224102010', '122410', 'Hilihati', 4),
	('1224102011', '122410', 'Fadoro Sitolu Hili', 4),
	('1224102012', '122410', 'Marafala', 4),
	('1224102013', '122410', 'Hiligawolo', 4),
	('1224102014', '122410', 'Balefadoro Tuho', 4),
	('1224102015', '122410', 'Ombolata', 4),
	('1224102016', '122410', 'Afia', 4),
	('1224102017', '122410', 'Moawo', 4),
	('1224102018', '122410', 'Lasara', 4),
	('1224102019', '122410', 'Sihene\'asi', 4),
	('1224102020', '122410', 'Fadoro Hilimbowo', 4),
	('1224102021', '122410', 'Fadoro Hilihambawa', 4),
	('1224112001', '122411', 'Laowowaga', 4),
	('1224112002', '122411', 'Lukhu Lase', 4),
	('1224112003', '122411', 'Tetehosi Sorowi', 4),
	('1224112004', '122411', 'Tefao', 4),
	('1224112005', '122411', 'Tugala Lauru', 4),
	('1224112006', '122411', 'Muzoi', 4),
	('1224112007', '122411', 'Maefu', 4),
	('1225012001', '122501', 'Sisobaoho', 4),
	('1225012002', '122501', 'Bawa Zamaiwo', 4),
	('1225012003', '122501', 'Sitolu Banua', 4),
	('1225012004', '122501', 'Lologundre', 4),
	('1225012005', '122501', 'Iraonogaila', 4),
	('1225012006', '122501', 'Tiga Serangkai', 4),
	('1225012007', '122501', 'Onowaembo', 4),
	('1225012008', '122501', 'Onolimbu', 4),
	('1225012009', '122501', 'Haliadulo', 4),
	('1225012010', '122501', 'Sisobambowo', 4),
	('1225012011', '122501', 'Lolowa"u', 4),
	('1225022001', '122502', 'Bawazolo\'o', 4),
	('1225022002', '122502', 'Imana', 4),
	('1225022003', '122502', 'Tuwa-Tuwa', 4),
	('1225022004', '122502', 'Kafo-Kafo', 4),
	('1225022005', '122502', 'Bawasawa', 4),
	('1225022006', '122502', 'Pulau Bongi', 4),
	('1225022007', '122502', 'Halamona', 4),
	('1225022008', '122502', 'Hanofa', 4),
	('1225022009', '122502', 'Lahawa', 4),
	('1225022010', '122502', 'Hinako', 4),
	('1225022011', '122502', 'Sinene\'eto', 4),
	('1225022012', '122502', 'Balowondrate', 4),
	('1225022013', '122502', 'Hilimburuana\'a', 4),
	('1225022014', '122502', 'Lahusa', 4),
	('1225022015', '122502', 'Ombolata', 4),
	('1225022016', '122502', 'Telehose', 4),
	('1225022017', '122502', 'Togimbogi', 4),
	('1225022018', '122502', 'Sisobandrao', 4),
	('1225022019', '122502', 'Fadoro', 4),
	('1225022020', '122502', 'Tugala Gawu', 4),
	('1225022021', '122502', 'Sirombu', 4),
	('1225022022', '122502', 'Togi\'deu', 4),
	('1225022023', '122502', 'Tuga Gawu', 4),
	('1225022024', '122502', 'Orahili', 4),
	('1225022025', '122502', 'Gunung Cahaya', 4),
	('1225032001', '122503', 'Onolalimburaya', 4),
	('1225032002', '122503', 'Ono Namolo III', 4),
	('1225032003', '122503', 'Sisobaoho', 4),
	('1225032004', '122503', 'Iriano Geba', 4),
	('1225032005', '122503', 'Lolohia', 4),
	('1225032006', '122503', 'Fadoro Situlo Banua', 4),
	('1225032007', '122503', 'Hillidaura', 4),
	('1225032008', '122503', 'Sisarahili II', 4),
	('1225032009', '122503', 'Lasara Bagawu', 4),
	('1225032010', '122503', 'Sisobandrao', 4),
	('1225032011', '122503', 'Mazingo', 4),
	('1225032012', '122503', 'Onolimbu You', 4),
	('1225032013', '122503', 'Lasara Faga', 4),
	('1225032014', '122503', 'Orahili Badalu', 4),
	('1225042001', '122504', 'Hiliwalo\'o II', 4),
	('1225042002', '122504', 'Gunung Baru', 4),
	('1225042003', '122504', 'Hilisoromi', 4),
	('1225042004', '122504', 'Sidua Hili', 4),
	('1225042005', '122504', 'Sitolu Banua Fadoro', 4),
	('1225042006', '122504', 'Halifadolo', 4),
	('1225042007', '122504', 'Lasara Bahili', 4),
	('1225042008', '122504', 'Hiliwa\'ele', 4),
	('1225042009', '122504', 'Sitolu Ewali', 4),
	('1225042010', '122504', 'Onozalukhu You', 4),
	('1225052001', '122505', 'Simae\'asi', 4),
	('1225052002', '122505', 'Lologolu', 4),
	('1225052003', '122505', 'Tuwuuna', 4),
	('1225052004', '122505', 'Tuhemberua', 4),
	('1225052005', '122505', 'Lolozirugi', 4),
	('1225052006', '122505', 'Lakhena', 4),
	('1225052007', '122505', 'Hiliwalo\'o I', 4),
	('1225052008', '122505', 'Siana\'a', 4),
	('1225052009', '122505', 'Fadoro', 4),
	('1225052010', '122505', 'Iraono Gambo', 4),
	('1225052011', '122505', 'Tuho\'owo', 4),
	('1225052012', '122505', 'Fadoro Bahili', 4),
	('1225052013', '122505', 'Tumori', 4),
	('1225052014', '122505', 'Lasara Baene', 4),
	('1225052015', '122505', 'Tetehosi', 4),
	('1225052016', '122505', 'Sisarahili I', 4),
	('1225052017', '122505', 'Doli-Doli', 4),
	('1225052018', '122505', 'Hayo', 4),
	('1225052019', '122505', 'ZuzuNdrao', 4),
	('1225052020', '122505', 'Iriani Gambo', 4),
	('1225062001', '122506', 'Balodano', 4),
	('1225062002', '122506', 'Hiambanua', 4),
	('1225062003', '122506', 'Hilimato', 4),
	('1225062004', '122506', 'Sihare\'o', 4),
	('1225062005', '122506', 'Lolomboli', 4),
	('1225062006', '122506', 'Ononamolo I', 4),
	('1225062007', '122506', 'Hilimbaruzo', 4),
	('1225062008', '122506', 'Tarahoso', 4),
	('1225062009', '122506', 'Ononamolo II', 4),
	('1225062010', '122506', 'Taraha', 4),
	('1225062011', '122506', 'Lahabu', 4),
	('1225062012', '122506', 'Hilimbowo', 4),
	('1225072001', '122507', 'Sisobawino II', 4),
	('1225072002', '122507', 'Duria', 4),
	('1225072003', '122507', 'Ambukha', 4),
	('1225072004', '122507', 'Hilimbowo Ma\'u', 4),
	('1225072005', '122507', 'Hilimbuasi', 4),
	('1225072006', '122507', 'Lolofitu', 4),
	('1225072007', '122507', 'Hili"uso', 4),
	('1225072008', '122507', 'Wango', 4),
	('1225082001', '122508', 'Bukit Tinggi', 4),
	('1225082002', '122508', 'Lawelu', 4),
	('1225082003', '122508', 'Salo\'o', 4),
	('1225082004', '122508', 'Hilisangawola', 4),
	('1225082005', '122508', 'Hilibadalu', 4),
	('1271011001', '127101', 'Pasar Baru', 3),
	('1271011002', '127101', 'Pusat Pasar', 3),
	('1271011003', '127101', 'Sei Rengas I', 3),
	('1271011004', '127101', 'Mesjid', 3),
	('1271011005', '127101', 'Pandau Hulu I', 3),
	('1271011006', '127101', 'Kotamatsum III', 3),
	('1271011007', '127101', 'Pasar Merah Barat', 3),
	('1271011008', '127101', 'Teladan Timur', 3),
	('1271011009', '127101', 'Teladan Barat', 3),
	('1271011010', '127101', 'Sudirejo', 3),
	('1271011011', '127101', 'Sudirejo II', 3),
	('1271011012', '127101', 'Sitirejo I', 3),
	('1271021001', '127102', 'Lalang', 3),
	('1271021002', '127102', 'Sei Sikambing B', 3),
	('1271021003', '127102', 'Sunggal', 3),
	('1271021004', '127102', 'Babura Sunggal', 3),
	('1271021005', '127102', 'Tanjung Rejo', 3),
	('1271021006', '127102', 'Simpang Tanjung', 3),
	('1271031001', '127103', 'Helvetia', 3),
	('1271031002', '127103', 'Helvetia Tengah', 3),
	('1271031003', '127103', 'Helvetia Timur', 3),
	('1271031004', '127103', 'Tanjung Gusta', 3),
	('1271031005', '127103', 'Cinta Damai', 3),
	('1271031006', '127103', 'Dwi Kora', 3),
	('1271031007', '127103', 'Sei Sikambing C II', 3),
	('1271041001', '127104', 'Tegal S Mandala I', 3),
	('1271041002', '127104', 'Tegal S Mandala II', 3),
	('1271041003', '127104', 'Tegal S Mandala III', 3),
	('1271041004', '127104', 'Denai', 3),
	('1271041005', '127104', 'Binjai', 3),
	('1271041006', '127104', 'Medan Tenggara', 3),
	('1271051001', '127105', 'Kesawan', 3),
	('1271051002', '127105', 'Silalas', 3),
	('1271051003', '127105', 'Glugur Kota', 3),
	('1271051004', '127105', 'Pulo Berayan Kota', 3),
	('1271051005', '127105', 'Sei Agul', 3),
	('1271051006', '127105', 'Karang Berombak', 3),
	('1271061001', '127106', 'Titipapan', 3),
	('1271061002', '127106', 'Tanjung Mulia Hilir', 3),
	('1271061003', '127106', 'Tanjung Mulya', 3),
	('1271061004', '127106', 'Kota Bangun', 3),
	('1271061005', '127106', 'Mabar', 3),
	('1271061006', '127106', 'Mabar Hilir', 3),
	('1271071001', '127107', 'Tanjung Selamat', 3),
	('1271071002', '127107', 'Simpang Selayang', 3),
	('1271071003', '127107', 'Namo Gajah', 3),
	('1271071004', '127107', 'Kemenangan Tani', 3),
	('1271071005', '127107', 'Laucih', 3),
	('1271071006', '127107', 'Sidomulyo', 3),
	('1271071007', '127107', 'Ladang Bambu', 3),
	('1271071008', '127107', 'Simalingkar B', 3),
	('1271071009', '127107', 'Mangga', 3),
	('1271081001', '127108', 'Belawan I', 3),
	('1271081002', '127108', 'Belawan II', 3),
	('1271081003', '127108', 'Belawan Bahagia', 3),
	('1271081004', '127108', 'Belawan Bahari', 3),
	('1271081005', '127108', 'Belawan Sicanang', 3),
	('1271081006', '127108', 'Bagan Deli', 3),
	('1271091001', '127109', 'Amplas', 3),
	('1271091002', '127109', 'Sitirejo II', 3),
	('1271091003', '127109', 'Sitirejo III', 3),
	('1271091004', '127109', 'Harjosari I', 3),
	('1271091005', '127109', 'Harjosari II', 3),
	('1271091006', '127109', 'Timbang Deli', 3),
	('1271091007', '127109', 'Bangun Mulia', 3),
	('1271101001', '127110', 'Sukaramai I', 3),
	('1271101002', '127110', 'Sukaramai II', 3),
	('1271101003', '127110', 'Sei Rengas II', 3),
	('1271101004', '127110', 'S. Rengas Permata', 3),
	('1271101005', '127110', 'Pandau Hulu II', 3),
	('1271101006', '127110', 'Kota Matsum I', 3),
	('1271101007', '127110', 'Kota Matsum II', 3),
	('1271101008', '127110', 'Kota Matsum IV', 3),
	('1271101009', '127110', 'Pasar Merah Timur', 3),
	('1271101010', '127110', 'Tegal Sari I', 3),
	('1271101011', '127110', 'Tegal Sari II', 3),
	('1271101012', '127110', 'Tegal Sari III', 3),
	('1271111001', '127111', 'Suka Maju', 3),
	('1271111002', '127111', 'Titi Kuning', 3),
	('1271111003', '127111', 'Kedai Durian', 3),
	('1271111004', '127111', 'Pangkalan Mansur', 3),
	('1271111005', '127111', 'Gedung Johor', 3),
	('1271111006', '127111', 'Kwala Bekala', 3),
	('1271121001', '127112', 'Labuhan Deli', 3),
	('1271121002', '127112', 'Rengas Pulau', 3),
	('1271121003', '127112', 'Terjun', 3),
	('1271121004', '127112', 'Tanah Enam Ratus', 3),
	('1271121005', '127112', 'Paya Pasir', 3),
	('1271131001', '127113', 'Pekan Labuhan', 3),
	('1271131002', '127113', 'Sei Mati', 3),
	('1271131003', '127113', 'Besar', 3),
	('1271131004', '127113', 'Martubung', 3),
	('1271131005', '127113', 'Nelayan Indah', 3),
	('1271131006', '127113', 'Tangkahan', 3),
	('1271141001', '127114', 'Indra Kasih', 3),
	('1271141002', '127114', 'Sidorejo Hilir', 3),
	('1271141003', '127114', 'Sidorejo', 3),
	('1271141004', '127114', 'Bantan', 3),
	('1271141005', '127114', 'Tembung', 3),
	('1271141006', '127114', 'Bandar Selamat', 3),
	('1271141007', '127114', 'Bantan Timur', 3),
	('1271151001', '127115', 'Aur', 3),
	('1271151002', '127115', 'Hamdan', 3),
	('1271151003', '127115', 'J a t i', 3),
	('1271151004', '127115', 'Sukaraja', 3),
	('1271151005', '127115', 'Sei Mati', 3),
	('1271151006', '127115', 'Kampung Baru', 3),
	('1271161001', '127116', 'Madras Hulu', 3),
	('1271161002', '127116', 'Polonia', 3),
	('1271161003', '127116', 'Sari Rejo', 3),
	('1271161004', '127116', 'Suka Damai', 3),
	('1271161005', '127116', 'Anggrung', 3),
	('1271171001', '127117', 'Petisah Hulu', 3),
	('1271171002', '127117', 'Babura', 3),
	('1271171003', '127117', 'Merdeka', 3),
	('1271171004', '127117', 'Darat', 3),
	('1271171005', '127117', 'Padang Bulan', 3),
	('1271171006', '127117', 'Titi Rante', 3),
	('1271181001', '127118', 'Pandau Hilir', 3),
	('1271181002', '127118', 'Pahlawan', 3),
	('1271181003', '127118', 'Sei Kera Hilir I', 3),
	('1271181004', '127118', 'Sei Kera Hilir II', 3),
	('1271181005', '127118', 'Sei Kera Hulu', 3),
	('1271181006', '127118', 'Sidorame Timur', 3),
	('1271181007', '127118', 'Sidorame Barat I', 3),
	('1271181008', '127118', 'Sidorame Barat II', 3),
	('1271181009', '127118', 'Tegalrejo', 3),
	('1271191001', '127119', 'Petisah Tengah', 3),
	('1271191002', '127119', 'Sekip', 3),
	('1271191003', '127119', 'Sei Sikambing D', 3),
	('1271191004', '127119', 'Sei Putih Barat', 3),
	('1271191005', '127119', 'Sei Putih Tengah', 3),
	('1271191006', '127119', 'Sei Putih Timur I', 3),
	('1271191007', '127119', 'Sei Putih Timur II', 3),
	('1271201001', '127120', 'Gang Buntu', 3),
	('1271201002', '127120', 'Sidodadi', 3),
	('1271201003', '127120', 'Durian', 3),
	('1271201004', '127120', 'Glugur Darat I', 3),
	('1271201005', '127120', 'Glugur Darat II', 3),
	('1271201006', '127120', 'P Berayan Darat I', 3),
	('1271201007', '127120', 'P Berayan Darat II', 3),
	('1271201008', '127120', 'P Berayan Bengkel', 3),
	('1271201009', '127120', 'PB Bengkel Baru', 3),
	('1271201010', '127120', 'Perintis', 3),
	('1271201011', '127120', 'Gaharu', 3),
	('1271211001', '127121', 'Asam Kumbang', 3),
	('1271211002', '127121', 'Tanjungsari', 3),
	('1271211003', '127121', 'P Bulan Selayang II', 3),
	('1271211004', '127121', 'Beringin', 3),
	('1271211005', '127121', 'P Bulan Selayang I', 3),
	('1271211006', '127121', 'Sempakata', 3),
	('1272011001', '127201', 'Kebun Sayur', 3),
	('1272011002', '127201', 'Tomuan', 3),
	('1272011003', '127201', 'Pahlawan', 3),
	('1272011004', '127201', 'Asahan', 3),
	('1272011005', '127201', 'Merdeka', 3),
	('1272011006', '127201', 'Pardomuan', 3),
	('1272011007', '127201', 'Siopat Suhu', 3),
	('1272021001', '127202', 'Dwikora', 3),
	('1272021002', '127202', 'Proklamasi', 3),
	('1272021003', '127202', 'Bantan', 3),
	('1272021004', '127202', 'Timbang Galung', 3),
	('1272021005', '127202', 'Simarito', 3),
	('1272021006', '127202', 'Sipinggol-Pinggol', 3),
	('1272021007', '127202', 'Banjar', 3),
	('1272031001', '127203', 'Melayu', 3),
	('1272031002', '127203', 'Martoba', 3),
	('1272031003', '127203', 'Baru', 3),
	('1272031004', '127203', 'Sukadame', 3),
	('1272031005', '127203', 'Kahean', 3),
	('1272031006', '127203', 'Sigulang-gulang', 3),
	('1272031007', '127203', 'Bane', 3),
	('1272041001', '127204', 'Toba', 3),
	('1272041002', '127204', 'Karo', 3),
	('1272041003', '127204', 'Simalungun', 3),
	('1272041004', '127204', 'Martimbang', 3),
	('1272041005', '127204', 'Kristen', 3),
	('1272041006', '127204', 'Aek Nauli', 3),
	('1272051002', '127205', 'Sukaraja', 3),
	('1272051005', '127205', 'Baringin Pancur Nauli', 3),
	('1272051006', '127205', 'Pardamean', 3),
	('1272051007', '127205', 'Sukamaju', 3),
	('1272051008', '127205', 'Parhorasan Nauli', 3),
	('1272051009', '127205', 'Sukamakmur', 3),
	('1272051010', '127205', 'Mekar Nauli', 3),
	('1272061001', '127206', 'Sumber Jaya', 3),
	('1272061003', '127206', 'Tambun Nabolon', 3),
	('1272061007', '127206', 'Naga Pita', 3),
	('1272061008', '127206', 'Pondok Sayur', 3),
	('1272061009', '127206', 'Tanjung Tongah', 3),
	('1272061010', '127206', 'Naga Pitu', 3),
	('1272061011', '127206', 'Tanjung Pinggir', 3),
	('1272071001', '127207', 'Gurilla', 3),
	('1272071002', '127207', 'Bah Kapul', 3),
	('1272071003', '127207', 'Setia Negara', 3),
	('1272071004', '127207', 'Bukit Sofa', 3),
	('1272071005', '127207', 'Bah Sorma', 3),
	('1272081001', '127208', 'Simarimbun', 3),
	('1272081002', '127208', 'Tong Marimbun', 3),
	('1272081003', '127208', 'Naga Huta', 3),
	('1272081004', '127208', 'Naga Huta Timur', 3),
	('1272081005', '127208', 'Pematang Marihat', 3),
	('1272081006', '127208', 'Marihat Jaya', 3),
	('1273011001', '127301', 'Huta Barangan', 3),
	('1273011002', '127301', 'Angin Nauli', 3),
	('1273011003', '127301', 'Huta Tonga-tonga', 3),
	('1273011004', '127301', 'Sibolga Ilir', 3),
	('1273011005', '127301', 'Simare-Mare', 3),
	('1273021001', '127302', 'Kota Baringin', 3),
	('1273021002', '127302', 'Pasar Baru', 3),
	('1273021003', '127302', 'Pasar Belakang', 3),
	('1273021004', '127302', 'Pancuran Gerobak', 3),
	('1273031001', '127303', 'Aek Habil', 3),
	('1273031002', '127303', 'Aek Manis', 3),
	('1273031003', '127303', 'Aek Muara Pinang', 3),
	('1273031004', '127303', 'Aek Parombunan', 3),
	('1273041001', '127304', 'Pancuran Kerambil', 3),
	('1273041002', '127304', 'Pancuran Dewa', 3),
	('1273041003', '127304', 'Pancuran Pinang', 3),
	('1273041004', '127304', 'Pancuran Bambu', 3),
	('1274011001', '127401', 'Tanjung Balai Kota I', 3),
	('1274011002', '127401', 'Tanjung Balai Kota II', 3),
	('1274011003', '127401', 'Perwira', 3),
	('1274011004', '127401', 'Karya', 3),
	('1274011005', '127401', 'Pantai Burung', 3),
	('1274011006', '127401', 'Indra Sakti', 3),
	('1274021001', '127402', 'Tanjung Balai Kota III', 3),
	('1274021002', '127402', 'Tanjung Balai Kota IV', 3),
	('1274021003', '127402', 'Sejahtera', 3),
	('1274021004', '127402', 'Kualo Silau Bestari', 3),
	('1274021005', '127402', 'Mata Halasan', 3),
	('1274031001', '127403', 'Keramat Kubah', 3),
	('1274031002', '127403', 'Sumber Sari', 3),
	('1274031003', '127403', 'Muara Sentosa', 3),
	('1274031004', '127403', 'Pasar Baru', 3),
	('1274031005', '127403', 'Sungai Raja', 3),
	('1274041001', '127404', 'Sei Merbau', 3),
	('1274041002', '127404', 'Pematang Pasir', 3),
	('1274041003', '127404', 'Perjuangan', 3),
	('1274041004', '127404', 'Kapias Pulau Buaya', 3),
	('1274041005', '127404', 'Beting Kuala Kapias', 3),
	('1274051003', '127405', 'Gading', 3),
	('1274051004', '127405', 'Sirantau', 3),
	('1274051005', '127405', 'Sijambi', 3),
	('1274051006', '127405', 'Pahang', 3),
	('1274051010', '127405', 'Pantai Johor', 3),
	('1274061001', '127406', 'Pulau Simardan', 3),
	('1274061002', '127406', 'Semula Jadi', 3),
	('1274061003', '127406', 'Selat Lancang', 3),
	('1274061004', '127406', 'Bunga Tanjung', 3),
	('1274061005', '127406', 'Selat Tanjung Medan', 3),
	('1275011001', '127501', 'Pahlawan', 3),
	('1275011002', '127501', 'Jatinegara', 3),
	('1275011003', '127501', 'Nangka', 3),
	('1275011004', '127501', 'Damai', 3),
	('1275011005', '127501', 'Kebun Lada', 3),
	('1275011006', '127501', 'Cengkeh Turi', 3),
	('1275011007', '127501', 'Jati Utomo', 3),
	('1275011008', '127501', 'Jati Makmur', 3),
	('1275011009', '127501', 'Jati Karya', 3),
	('1275021001', '127502', 'Berngam', 3),
	('1275021002', '127502', 'Satria', 3),
	('1275021003', '127502', 'Setia', 3),
	('1275021004', '127502', 'Kartini', 3),
	('1275021005', '127502', 'Tangsi', 3),
	('1275021006', '127502', 'Binjai', 3),
	('1275021007', '127502', 'Pekan Binjai', 3),
	('1275031001', '127503', 'Bandar Senembah', 3),
	('1275031002', '127503', 'Limau Mungkur', 3),
	('1275031003', '127503', 'Limau Sundai', 3),
	('1275031004', '127503', 'Paya Roba', 3),
	('1275031005', '127503', 'Suka Maju', 3),
	('1275031006', '127503', 'Suka Ramai', 3),
	('1275041001', '127504', 'Tanah Tinggi', 3),
	('1275041002', '127504', 'Dataran Tinggi', 3),
	('1275041003', '127504', 'Timbang Langkat', 3),
	('1275041004', '127504', 'Mencirim', 3),
	('1275041005', '127504', 'Tunggurono', 3),
	('1275041006', '127504', 'Sumber Mulyorejo', 3),
	('1275041007', '127504', 'Sumber Karya', 3),
	('1275051001', '127505', 'Tanah Merah', 3),
	('1275051002', '127505', 'Binjai Estate', 3),
	('1275051003', '127505', 'Bhakti Karya', 3),
	('1275051004', '127505', 'Rambung Dalam', 3),
	('1275051005', '127505', 'Pujidadi', 3),
	('1275051006', '127505', 'Tanah Seribu', 3),
	('1275051007', '127505', 'Rambung Barat', 3),
	('1275051008', '127505', 'Rambung Timur', 3),
	('1276011001', '127601', 'Pabatu', 3),
	('1276011002', '127601', 'Lubuk Baru', 3),
	('1276011006', '127601', 'Persiakan', 3),
	('1276011007', '127601', 'Bandar Sono', 3),
	('1276011010', '127601', 'Tualang', 3),
	('1276011011', '127601', 'Padang Merbau', 3),
	('1276011012', '127601', 'Lubuk Raya', 3),
	('1276021004', '127602', 'Rantau Laban', 3),
	('1276021007', '127602', 'Karya Jaya', 3),
	('1276021009', '127602', 'Lalang', 3),
	('1276021010', '127602', 'Tanjung Marulak', 3),
	('1276021011', '127602', 'Sri Padang', 3),
	('1276021012', '127602', 'Tanjung Marulak Hilir', 3),
	('1276021013', '127602', 'Mekar Sentosa', 3),
	('1276031001', '127603', 'Bagelen', 3),
	('1276031002', '127603', 'Tambangan', 3),
	('1276031004', '127603', 'Tebing Tinggi', 3),
	('1276031006', '127603', 'Satria', 3),
	('1276031007', '127603', 'Damar Sari', 3),
	('1276031008', '127603', 'Tambangan Hulu', 3),
	('1276031009', '127603', 'Deblod Sundoro', 3),
	('1276041001', '127604', 'Durian', 3),
	('1276041002', '127604', 'Pelita', 3),
	('1276041003', '127604', 'Bulian', 3),
	('1276041004', '127604', 'Berohol', 3),
	('1276041005', '127604', 'Bandar Sakti', 3),
	('1276041006', '127604', 'Pinang Mancung', 3),
	('1276041007', '127604', 'Teluk Karang', 3),
	('1276051001', '127605', 'Mandailing', 3),
	('1276051002', '127605', 'Pasar Baru', 3),
	('1276051003', '127605', 'Pasar Gambir', 3),
	('1276051004', '127605', 'Badak Bejuang', 3),
	('1276051005', '127605', 'Bandar Utama', 3),
	('1276051006', '127605', 'Rambung', 3),
	('1276051007', '127605', 'Tebing Tinggi Lama', 3),
	('1277011001', '127701', 'Wek I', 3),
	('1277011002', '127701', 'Wek II', 3),
	('1277011003', '127701', 'Wek III', 3),
	('1277011004', '127701', 'Wek IV', 3),
	('1277011005', '127701', 'Tanobato', 3),
	('1277011006', '127701', 'Tobat', 3),
	('1277011007', '127701', 'Batang Ayumi Jae', 3),
	('1277011008', '127701', 'Batang Ayumi Julu', 3),
	('1277011009', '127701', 'Sadabuan', 3),
	('1277011010', '127701', 'Panyanggar', 3),
	('1277011011', '127701', 'Bonan Dolok', 3),
	('1277011012', '127701', 'Losung Batu.', 3),
	('1277011013', '127701', 'Timbangan', 3),
	('1277011014', '127701', 'Bincar', 3),
	('1277011015', '127701', 'Kantin', 3),
	('1277011016', '127701', 'Kayu Ombun', 3),
	('1277021001', '127702', 'Wek V', 3),
	('1277021002', '127702', 'Wek VI', 3),
	('1277021003', '127702', 'Losung', 3),
	('1277021004', '127702', 'Sitamiang', 3),
	('1277021005', '127702', 'Ujung Pandang', 3),
	('1277021006', '127702', 'Aek Tampang', 3),
	('1277021007', '127702', 'Padang Matinggi', 3),
	('1277021008', '127702', 'Silandit', 3),
	('1277021009', '127702', 'Sidangkal', 3),
	('1277021010', '127702', 'Hanopan', 3),
	('1277021011', '127702', 'Padang Matinggi Lestari', 3),
	('1277021012', '127702', 'Sitamiang Baru', 3),
	('1277031001', '127703', 'Batunadua Jae', 3),
	('1277031002', '127703', 'Batunadua Julu', 3),
	('1277032003', '127703', 'Purwodadi', 4),
	('1277032004', '127703', 'Gunung Hasahatan', 4),
	('1277032005', '127703', 'Ujunggurap', 4),
	('1277032006', '127703', 'Aek Tuhul', 4),
	('1277032007', '127703', 'Baruas', 4),
	('1277032008', '127703', 'Siloting', 4),
	('1277032009', '127703', 'Aek Bayur', 4),
	('1277032010', '127703', 'Pudun Jae', 4),
	('1277032011', '127703', 'Pudun Julu', 4),
	('1277032012', '127703', 'Batang Bahal', 4),
	('1277032013', '127703', 'Aek Najaji', 4),
	('1277032014', '127703', 'Simirik', 4),
	('1277032015', '127703', 'Bargottopong', 4),
	('1277041001', '127704', 'Hutaimbaru', 3),
	('1277041002', '127704', 'Lubuk Raya', 3),
	('1277041003', '127704', 'Sabungan Jae', 3),
	('1277041004', '127704', 'Lembah Lubuk Manik', 3),
	('1277041005', '127704', 'Palopat Maria', 3),
	('1277042006', '127704', 'Sabungan Sipabangun', 4),
	('1277042007', '127704', 'Singali', 4),
	('1277042008', '127704', 'Huta Padang', 4),
	('1277042009', '127704', 'Partihaman Saroha', 4),
	('1277042010', '127704', 'Tinjoman Lame', 4),
	('1277051001', '127705', 'Sihitang', 3),
	('1277051002', '127705', 'Pijarkoling', 3),
	('1277052003', '127705', 'Palopat PK', 4),
	('1277052004', '127705', 'Salambue', 4),
	('1277052005', '127705', 'Purbatua PK', 4),
	('1277052006', '127705', 'Sigulang', 4),
	('1277052007', '127705', 'Manunggang Julu', 4),
	('1277052008', '127705', 'Goti', 4),
	('1277052009', '127705', 'Manegen', 4),
	('1277052010', '127705', 'Huta Koje', 4),
	('1277052011', '127705', 'Hutalimbong', 4),
	('1277052012', '127705', 'Hutapadang', 4),
	('1277052013', '127705', 'Perkebunan PK', 4),
	('1277052014', '127705', 'Labuhan Labo', 4),
	('1277052015', '127705', 'Huta Lombang', 4),
	('1277052016', '127705', 'Manunggang Jae', 4),
	('1277052017', '127705', 'Labuhan Rasoki', 4),
	('1277052018', '127705', 'Tarutung Baru', 4),
	('1277062001', '127706', 'Joring Lombang', 4),
	('1277062002', '127706', 'Batu Layan', 4),
	('1277062003', '127706', 'Simasom', 4),
	('1277062004', '127706', 'Pintu Langit Jae', 4),
	('1277062005', '127706', 'Mompang', 4),
	('1277062006', '127706', 'Rimba Soping', 4),
	('1277062007', '127706', 'Simatohir', 4),
	('1277062008', '127706', 'Joring Natobang', 4),
	('1278011030', '127801', 'Pasar Gunungsitoli', 3),
	('1278011031', '127801', 'Saombo', 3),
	('1278011032', '127801', 'Ilir', 3),
	('1278012001', '127801', 'Bawodesolo', 4),
	('1278012002', '127801', 'Boyo', 4),
	('1278012003', '127801', 'Dahadano Gawu-Gawu', 4),
	('1278012004', '127801', 'Dahana Tabaloho', 4),
	('1278012005', '127801', 'Fadoro Lasara', 4),
	('1278012006', '127801', 'Hilihao', 4),
	('1278012007', '127801', 'Hilimbaruzo', 4),
	('1278012008', '127801', 'Hilina\'a', 4),
	('1278012009', '127801', 'Iraonogeba', 4),
	('1278012010', '127801', 'Lasara Bahili', 4),
	('1278012011', '127801', 'Lolowonu Niko\'otano', 4),
	('1278012012', '127801', 'Madula', 4),
	('1278012013', '127801', 'Madolaoli', 4),
	('1278012014', '127801', 'Mudik', 4),
	('1278012015', '127801', 'Miga', 4),
	('1278012016', '127801', 'Mo\'awo', 4),
	('1278012017', '127801', 'Ombolata Ulu', 4),
	('1278012018', '127801', 'Onowaembo', 4),
	('1278012019', '127801', 'Onozitoli Olora', 4),
	('1278012020', '127801', 'Onozitoli Sifaoroasi', 4),
	('1278012021', '127801', 'Saewe', 4),
	('1278012022', '127801', 'Sifalaete Tabaloho', 4),
	('1278012023', '127801', 'Sifalaete Ulu', 4),
	('1278012024', '127801', 'Sihare\'o II Tabaloho', 4),
	('1278012025', '127801', 'Simandraolo', 4),
	('1278012026', '127801', 'Sisarahiligamo', 4),
	('1278012027', '127801', 'Sisarahili Sisambualahe', 4),
	('1278012028', '127801', 'Sisobahili Tabaloho', 4),
	('1278012029', '127801', 'Tuhemberua Ulu', 4),
	('1278022001', '127802', 'Ononamolo I Lot', 4),
	('1278022002', '127802', 'Fodo', 4),
	('1278022003', '127802', 'Faekhu', 4),
	('1278022004', '127802', 'Lolofaoso Tabaloho', 4),
	('1278022005', '127802', 'Lolomboli', 4),
	('1278022006', '127802', 'Mazingo Tabaloho', 4),
	('1278022007', '127802', 'Onozitoli Tabaloho', 4),
	('1278022008', '127802', 'Lololakha', 4),
	('1278022009', '127802', 'Sihare\'o I Tabaloho', 4),
	('1278022010', '127802', 'Ombolata Simenari', 4),
	('1278022011', '127802', 'Hiligara', 4),
	('1278022012', '127802', 'Luahalaraga', 4),
	('1278022013', '127802', 'Sisobahili II Tanose\'o', 4),
	('1278022014', '127802', 'Hiligodu Ombolata', 4),
	('1278022015', '127802', 'Tetehosi Ombolata', 4),
	('1278032001', '127803', 'Afia', 4),
	('1278032002', '127803', 'Lolo\'ana\'a Lolomoyo', 4),
	('1278032003', '127803', 'Lasara Sowu', 4),
	('1278032004', '127803', 'Telukbelukar', 4),
	('1278032005', '127803', 'Tetehosi Afia', 4),
	('1278032006', '127803', 'Hambawa', 4),
	('1278032007', '127803', 'Gawu-Gawu Bo\'uso', 4),
	('1278032008', '127803', 'Olora', 4),
	('1278032009', '127803', 'Hilimbowo Olora', 4),
	('1278032010', '127803', 'Hiligodu Ulu', 4),
	('1278042001', '127804', 'Sifalaete', 4),
	('1278042002', '127804', 'Hilimbawodesolo', 4),
	('1278042003', '127804', 'Dahana', 4),
	('1278042004', '127804', 'Bawodesolo', 4),
	('1278042005', '127804', 'Tuhegeo I', 4),
	('1278042006', '127804', 'Simanaere', 4),
	('1278042007', '127804', 'Humene', 4),
	('1278042008', '127804', 'Siwalubanua II', 4),
	('1278042009', '127804', 'Helefanikha', 4),
	('1278042010', '127804', 'Tetehosi I', 4),
	('1278042011', '127804', 'Fowa', 4),
	('1278042012', '127804', 'Binaka', 4),
	('1278042013', '127804', 'Idanotae', 4),
	('1278042014', '127804', 'Tetehosi II', 4),
	('1278042015', '127804', 'Lolo\'ana\'a Idanoi', 4),
	('1278042016', '127804', 'Siwalubanua I', 4),
	('1278042017', '127804', 'Hilihambawa', 4),
	('1278042018', '127804', 'Awa\'ai', 4),
	('1278042019', '127804', 'Lewuoguru Idanoi', 4),
	('1278042020', '127804', 'Fadoro', 4),
	('1278042021', '127804', 'Hiliweto Idanoi', 4),
	('1278042022', '127804', 'Hilimbowo Idanoi', 4),
	('1278042023', '127804', 'Onowaembo', 4),
	('1278042024', '127804', 'Ombolata', 4),
	('1278042025', '127804', 'Samasi', 4),
	('1278042026', '127804', 'Tuhegeo II', 4),
	('1278052001', '127805', 'Nazalou Alo\'oa', 4),
	('1278052002', '127805', 'Niko\'otano Dao', 4),
	('1278052003', '127805', 'Iraonolase', 4),
	('1278052004', '127805', 'Orahili Tanose\'o', 4),
	('1278052005', '127805', 'Tarakhaini', 4),
	('1278052006', '127805', 'Fadoro Hilimbowo', 4),
	('1278052007', '127805', 'Fadoro You', 4),
	('1278052008', '127805', 'Lololawa', 4),
	('1278052009', '127805', 'Nazalou Lolowua', 4),
	('1278062001', '127806', 'Tumori', 4),
	('1278062002', '127806', 'Tumori Balohili', 4),
	('1278062003', '127806', 'Orahili Tumori', 4),
	('1278062004', '127806', 'Gada', 4),
	('1278062005', '127806', 'Lolomoyo Tuhemberua', 4),
	('1278062006', '127806', 'Sihare\'o Siwahili', 4),
	('1278062007', '127806', 'Hilinakhe', 4),
	('1278062008', '127806', 'Onozikho', 4),
	('1278062009', '127806', 'Ononamolo II Lot', 4),
	('1301012001', '130101', 'Inderapura', 4),
	('1301012002', '130101', 'Muaro Sakai Inderapura', 4),
	('1301012003', '130101', 'Tiga Sepakat Inderapura', 4),
	('1301012004', '130101', 'Inderapura Barat', 4),
	('1301012005', '130101', 'Kudo-Kudo Inderapura', 4),
	('1301012006', '130101', 'Inderapura Selatan', 4),
	('1301012009', '130101', 'Simpang Lama Inderapura', 4),
	('1301012010', '130101', 'Tigo Sungai Inderapura', 4),
	('1301012011', '130101', 'Tluk Amplu Inderapura', 4),
	('1301012012', '130101', 'Inderapura Tengah', 4),
	('1301022001', '130102', 'Pelangai', 4),
	('1301022002', '130102', 'Sungai Tunu', 4),
	('1301022003', '130102', 'Sungai Tunu Utara', 4),
	('1301022004', '130102', 'Sungai Tunu Barat', 4),
	('1301022005', '130102', 'Nyiur Melambai Pelangai', 4),
	('1301022006', '130102', 'Sungai Liku Pelangai', 4),
	('1301022007', '130102', 'Koto VIII Pelangai', 4),
	('1301022008', '130102', 'Pelangai Gadang', 4),
	('1301022009', '130102', 'Pelangai Kaciak', 4),
	('1301022010', '130102', 'Pasia Pelangai', 4),
	('1301032001', '130103', 'Kambang', 4),
	('1301032002', '130103', 'Lakitan', 4),
	('1301032003', '130103', 'Kambang Utara', 4),
	('1301032004', '130103', 'Kambang Timur', 4),
	('1301032005', '130103', 'Kambang Barat', 4),
	('1301032006', '130103', 'Lakitan Utara', 4),
	('1301032007', '130103', 'Lakitan Selatan', 4),
	('1301032008', '130103', 'Lakitan Timur', 4),
	('1301032009', '130103', 'Lakitan Tengah', 4),
	('1301042001', '130104', 'IV Koto Hilie', 4),
	('1301042002', '130104', 'IV Koto Mudiek', 4),
	('1301042003', '130104', 'Taluak', 4),
	('1301042004', '130104', 'Koto Nan Duo IV Koto Hilie', 4),
	('1301042005', '130104', 'Koto Nan Tigo IV Koto Hilie', 4),
	('1301042006', '130104', 'Teratak Tempatih IV Koto Mudiek', 4),
	('1301042007', '130104', 'Tuik IV Koto Mudiek', 4),
	('1301042008', '130104', 'Sungai Nyalo IV Koto Mudiek', 4),
	('1301042009', '130104', 'Taluk Tigo Sakato', 4),
	('1301052001', '130105', 'Painan', 4),
	('1301052002', '130105', 'Tambang', 4),
	('1301052003', '130105', 'Salido', 4),
	('1301052004', '130105', 'Lumpo', 4),
	('1301052005', '130105', 'Bunga Pasang Salido', 4),
	('1301052006', '130105', 'Sago Salido', 4),
	('1301052007', '130105', 'Salido Sari Bulan', 4),
	('1301052008', '130105', 'Koto Rawang', 4),
	('1301052009', '130105', 'Limau Gadang Lumpo', 4),
	('1301052010', '130105', 'Batu Kunik Lumpo', 4),
	('1301052011', '130105', 'Taratak Tangah Lumpo', 4),
	('1301052012', '130105', 'Ampuan Lumpo', 4),
	('1301052013', '130105', 'Ampang Tareh Lumpo', 4),
	('1301052014', '130105', 'Balai Sinayan Lumpo', 4),
	('1301052015', '130105', 'Sungai Gayo Lumpo', 4),
	('1301052016', '130105', 'Sungai Sariak Lumpo', 4),
	('1301052017', '130105', 'Bukik Kaciak Lumpo', 4),
	('1301052018', '130105', 'Gunung Bungkuak Lumpo', 4),
	('1301052019', '130105', 'Painan Selatan Painan', 4),
	('1301052020', '130105', 'Painan Timur Painan', 4),
	('1301062005', '130106', 'Koto Berapak', 4),
	('1301062006', '130106', 'Talaok', 4),
	('1301062007', '130106', 'Pasar Baru', 4),
	('1301062008', '130106', 'Gurun Panjang', 4),
	('1301062009', '130106', 'Api-api Pasar Baru', 4),
	('1301062010', '130106', 'Tanjung Durian Pasar Baru', 4),
	('1301062011', '130106', 'Asam Kamba Pasar Baru', 4),
	('1301062012', '130106', 'Sawah Laweh Pasar Baru', 4),
	('1301062013', '130106', 'Kapeh Panji Jaya Talaok', 4),
	('1301062014', '130106', 'Aur Begalung Talaok', 4),
	('1301062015', '130106', 'Kapelgam Koto Berapak', 4),
	('1301062016', '130106', 'Koto Baru Koto Berapak', 4),
	('1301062017', '130106', 'Kubang Koto Berapak', 4),
	('1301062018', '130106', 'Kapujan Koto Berapak', 4),
	('1301062019', '130106', 'Gurun Panjang Utara', 4),
	('1301062020', '130106', 'Gurun Panjang Barat', 4),
	('1301062021', '130106', 'Gurun Panjang Selatan', 4),
	('1301072001', '130107', 'Siguntur', 4),
	('1301072002', '130107', 'Sungai Pinang', 4),
	('1301072003', '130107', 'Duku', 4),
	('1301072004', '130107', 'Batu Hampa', 4),
	('1301072005', '130107', 'Nanggalo', 4),
	('1301072006', '130107', 'Ampang Pulai', 4),
	('1301072007', '130107', 'Kapuh', 4),
	('1301072008', '130107', 'Barung-Barung Balantai', 4),
	('1301072009', '130107', 'Barung-Barung Balantai Selatan', 4),
	('1301072010', '130107', 'Mandeh', 4),
	('1301072011', '130107', 'Kapuah Utara', 4),
	('1301072012', '130107', 'Taratak Sungai Lundang', 4),
	('1301072013', '130107', 'Siguntur Tua', 4),
	('1301072014', '130107', 'Kampung Baru Korong Nan Ampek', 4),
	('1301072015', '130107', 'Duku Utara', 4),
	('1301072016', '130107', 'Pulau Karam Ampang Pulai', 4),
	('1301072017', '130107', 'Jinang Kampung Pansur Ampang Pulai', 4),
	('1301072018', '130107', 'Cerocok Anau Ampang Pulai', 4),
	('1301072019', '130107', 'Sungai Nyalo Mudiak Aia', 4),
	('1301072020', '130107', 'Batu Hampar Selatan', 4),
	('1301072021', '130107', 'Barung-Barung', 4),
	('1301072022', '130107', 'Barung-Barung Balantai Tengah', 4),
	('1301072023', '130107', 'Setara Nanggalo', 4),
	('1301082001', '130108', 'Taratak', 4),
	('1301082002', '130108', 'Surantih', 4),
	('1301082003', '130108', 'Amping Parak', 4),
	('1301082004', '130108', 'Amping Parak Timur', 4),
	('1301082005', '130108', 'Koto Taratak', 4),
	('1301082006', '130108', 'Lansano Taratak', 4),
	('1301082007', '130108', 'Aur Duri Surantih', 4),
	('1301082008', '130108', 'Rawang Gunung Malelo Surantih', 4),
	('1301082009', '130108', 'Koto Nan Tigo Selatan Surantih', 4),
	('1301082010', '130108', 'Koto Nan Tigo Utara Surantih', 4),
	('1301082011', '130108', 'Ganting Mudiak Selatan Surantih', 4),
	('1301082012', '130108', 'Ganting Mudiak Utara Surantih', 4),
	('1301092001', '130109', 'Punggasan', 4),
	('1301092002', '130109', 'Air Haji', 4),
	('1301092003', '130109', 'Punggasan Utara', 4),
	('1301092004', '130109', 'Punggasan Timur', 4),
	('1301092005', '130109', 'Padang XI Punggasan', 4),
	('1301092006', '130109', 'Lagan Mudik Punggasan', 4),
	('1301092007', '130109', 'Lagan Hilir Punggasan', 4),
	('1301092008', '130109', 'Air Haji Tenggara', 4),
	('1301092009', '130109', 'Pasar Lama Muara Air Haji', 4),
	('1301092010', '130109', 'Pasar Bukit Air Haji', 4),
	('1301092011', '130109', 'Air Haji Barat', 4),
	('1301092012', '130109', 'Air Haji Tengah', 4),
	('1301092013', '130109', 'Rantau Simalenang Air Haji', 4),
	('1301092014', '130109', 'Muara Gadang Air Haji', 4),
	('1301092015', '130109', 'Sungai Sirah Air Haji', 4),
	('1301092016', '130109', 'Muara Kandis Punggasan', 4),
	('1301102001', '130110', 'Lunang', 4),
	('1301102003', '130110', 'Lunang Utara', 4),
	('1301102004', '130110', 'Lunang Selatan', 4),
	('1301102005', '130110', 'Lunang Barat', 4),
	('1301102015', '130110', 'Sindang Lunang', 4),
	('1301102016', '130110', 'Pondok Parian Lunang', 4),
	('1301102017', '130110', 'Lunang Tengah', 4),
	('1301102018', '130110', 'Lunang Satu', 4),
	('1301102019', '130110', 'Lunang Dua', 4),
	('1301102020', '130110', 'Lunang Tiga', 4),
	('1301112001', '130111', 'Tapan', 4),
	('1301112002', '130111', 'Pasar Tapan', 4),
	('1301112007', '130111', 'Batang Arah Tapan', 4),
	('1301112008', '130111', 'Ampang Tulak Tapan', 4),
	('1301112009', '130111', 'Tanjung Pondok Tapan', 4),
	('1301112010', '130111', 'Batang Betung Tapan', 4),
	('1301112016', '130111', 'Bukit Buai Tapan', 4),
	('1301112017', '130111', 'Riak Danau Tapan', 4),
	('1301112018', '130111', 'Koto Anau Tapan', 4),
	('1301112019', '130111', 'Dusun Baru Tapan', 4),
	('1301122001', '130112', 'Puluik-Puluik', 4),
	('1301122002', '130112', 'Koto Ranah', 4),
	('1301122003', '130112', 'Muaro Aie', 4),
	('1301122004', '130112', 'Pancuang Taba', 4),
	('1301122005', '130112', 'Puluik-Puluik Selatan', 4),
	('1301122006', '130112', 'Limau Gadang Pancung Taba', 4),
	('1301132001', '130113', 'Inderapura Utara', 4),
	('1301132002', '130113', 'Muara Inderapura', 4),
	('1301132003', '130113', 'Damar Lapan Batang Inderapura', 4),
	('1301132004', '130113', 'Lalang Panjang Inderapura', 4),
	('1301132005', '130113', 'Palokan Inderapura', 4),
	('1301132006', '130113', 'Lubuk Betung Inderapura', 4),
	('1301132007', '130113', 'Tluk Kualo Inderapura', 4),
	('1301132008', '130113', 'Tanah Bakali Inderapura', 4),
	('1301132009', '130113', 'Inderapura Timur', 4),
	('1301132010', '130113', 'Pulau Rajo Inderapura', 4),
	('1301142001', '130114', 'Sungai Gambir Sako Tapan', 4),
	('1301142002', '130114', 'Limau Purut Tapan', 4),
	('1301142003', '130114', 'Talang Balarik Tapan', 4),
	('1301142004', '130114', 'Tebing Tinggi Tapan', 4),
	('1301142005', '130114', 'Binjai Tapan', 4),
	('1301142006', '130114', 'Sungai Pinang Tapan', 4),
	('1301142007', '130114', 'Talang Koto Pulai Tapan', 4),
	('1301142008', '130114', 'Kampung Tengah Tapan', 4),
	('1301142009', '130114', 'Kubu Tapan', 4),
	('1301142010', '130114', 'Simpang Gunung Tapan', 4),
	('1301152001', '130115', 'Silaut', 4),
	('1301152002', '130115', 'Sungai Sirah', 4),
	('1301152003', '130115', 'Sungai Sarik', 4),
	('1301152004', '130115', 'Sungai Pulai', 4),
	('1301152005', '130115', 'Pasir Binjai', 4),
	('1301152006', '130115', 'Talang Binjai', 4),
	('1301152007', '130115', 'Durian Seribu', 4),
	('1301152008', '130115', 'Lubuk Bunta', 4),
	('1301152009', '130115', 'Air Hitam', 4),
	('1301152010', '130115', 'Sambungo', 4),
	('1302032001', '130203', 'Lolo', 4),
	('1302032002', '130203', 'Surian', 4),
	('1302042001', '130204', 'Alahan Panjang', 4),
	('1302042002', '130204', 'Sungai Nanam', 4),
	('1302042003', '130204', 'Salimpat', 4),
	('1302042004', '130204', 'Aie Dingin', 4),
	('1302052001', '130205', 'Supayang', 4),
	('1302052002', '130205', 'Sirukam', 4),
	('1302052003', '130205', 'Aie Luo', 4),
	('1302062001', '130206', 'Batu Banyak', 4),
	('1302062002', '130206', 'Batu Bajanjang', 4),
	('1302062003', '130206', 'Koto Laweh', 4),
	('1302062004', '130206', 'Limau Lunggo', 4),
	('1302062005', '130206', 'Koto Gadang Koto Anau', 4),
	('1302062006', '130206', 'Selayo Tanang B. Sileh', 4),
	('1302072001', '130207', 'Cupak', 4),
	('1302072002', '130207', 'Talang', 4),
	('1302072003', '130207', 'Koto Gadang Guguak', 4),
	('1302072004', '130207', 'Jawi Jawi', 4),
	('1302072005', '130207', 'Sungai Janiah', 4),
	('1302072006', '130207', 'Batang Barus', 4),
	('1302072007', '130207', 'Aie Batumbuak', 4),
	('1302072008', '130207', 'Koto Gaek Guguk', 4),
	('1302082001', '130208', 'Muaro Paneh', 4),
	('1302082002', '130208', 'Kinari', 4),
	('1302082003', '130208', 'Bukit Tandang', 4),
	('1302082004', '130208', 'Parambahan', 4),
	('1302082005', '130208', 'Dilam', 4),
	('1302092001', '130209', 'Taruang-Taruang', 4),
	('1302092002', '130209', 'Siaro-Aro', 4),
	('1302092003', '130209', 'Pianggu', 4),
	('1302092004', '130209', 'Sungai Durian', 4),
	('1302092005', '130209', 'Bukik Bais', 4),
	('1302092006', '130209', 'Sungai Jambur', 4),
	('1302092007', '130209', 'Guguak Sarai', 4),
	('1302092008', '130209', 'Koto Laweh', 4),
	('1302092009', '130209', 'Indudur', 4),
	('1302102001', '130210', 'Koto Baru', 4),
	('1302102002', '130210', 'Selayo', 4),
	('1302102003', '130210', 'Panyakalan', 4),
	('1302102004', '130210', 'Gaung', 4),
	('1302102005', '130210', 'Gantuang Ciri', 4),
	('1302102006', '130210', 'Saok Laweh', 4),
	('1302102007', '130210', 'Koto Hilalang', 4),
	('1302102008', '130210', 'Tanjung Bingkung', 4),
	('1302112001', '130211', 'Sumani', 4),
	('1302112002', '130211', 'Tikalak', 4),
	('1302112003', '130211', 'Koto Sani', 4),
	('1302112004', '130211', 'Singkarak', 4),
	('1302112005', '130211', 'Aripan', 4),
	('1302112006', '130211', 'Kacang', 4),
	('1302112007', '130211', 'Tanjung Alai', 4),
	('1302112008', '130211', 'Saniangbaka', 4),
	('1302122001', '130212', 'Sulit Air', 4),
	('1302122002', '130212', 'Tanjung Balik', 4),
	('1302122003', '130212', 'Paninjauan', 4),
	('1302122004', '130212', 'Kuncir', 4),
	('1302122005', '130212', 'Katialo', 4),
	('1302122006', '130212', 'Pasilihan', 4),
	('1302122007', '130212', 'Bukit Kanduang', 4),
	('1302122008', '130212', 'Sibarambang', 4),
	('1302122009', '130212', 'Labuh Panjang', 4),
	('1302132001', '130213', 'Paninggahan', 4),
	('1302132002', '130213', 'Muaro Pingai', 4),
	('1302172001', '130217', 'Talang Babungo', 4),
	('1302172002', '130217', 'Sariak Alahan Tigo', 4),
	('1302172003', '130217', 'Sungai Abu', 4),
	('1302182001', '130218', 'Rangkiang Luluih', 4),
	('1302182002', '130218', 'Batu Bajanjang', 4),
	('1302182003', '130218', 'Garabak Data', 4),
	('1302182004', '130218', 'Tanjung Balik Sumiso', 4),
	('1302182005', '130218', 'Simanau', 4),
	('1302192001', '130219', 'Simpang Tj. Nan IV', 4),
	('1302192002', '130219', 'Kampung Batu Dalam', 4),
	('1303032001', '130303', 'Timbulun', 4),
	('1303032002', '130303', 'Tanjung Gadang', 4),
	('1303032003', '130303', 'Taratak Baru', 4),
	('1303032004', '130303', 'Pulasan', 4),
	('1303032005', '130303', 'Langki', 4),
	('1303032006', '130303', 'Sibakur', 4),
	('1303032007', '130303', 'Tanjung Lolo', 4),
	('1303032008', '130303', 'Taratak Baru Utara', 4),
	('1303032009', '130303', 'Sinyamu', 4),
	('1303042001', '130304', 'Muaro', 4),
	('1303042002', '130304', 'Kandang Baru', 4),
	('1303042003', '130304', 'Silokek', 4),
	('1303042004', '130304', 'Pematang Panjang', 4),
	('1303042005', '130304', 'Solok Ambah', 4),
	('1303042006', '130304', 'Paru', 4),
	('1303042007', '130304', 'Durian Gadang', 4),
	('1303042008', '130304', 'Aie Angek', 4),
	('1303042009', '130304', 'Sijunjung', 4),
	('1303052001', '130305', 'Palangki', 4),
	('1303052002', '130305', 'Koto Baru', 4),
	('1303052003', '130305', 'Muaro Bodi', 4),
	('1303052004', '130305', 'Mundam Sakti', 4),
	('1303052005', '130305', 'Koto Tuo', 4),
	('1303062001', '130306', 'Sungai Lansek', 4),
	('1303062002', '130306', 'Kamang', 4),
	('1303062003', '130306', 'Muaro Takuang', 4),
	('1303062004', '130306', 'Aia Amo', 4),
	('1303062005', '130306', 'Sungai Batuang', 4),
	('1303062006', '130306', 'Kunangan Parit Rantang', 4),
	('1303062007', '130306', 'Tanjung Kaliang', 4),
	('1303062008', '130306', 'Padang Tarok', 4),
	('1303062009', '130306', 'Siaur', 4),
	('1303062010', '130306', 'Lubuk Tarantang', 4),
	('1303062011', '130306', 'Maloro', 4),
	('1303072001', '130307', 'Lubuak Tarok', 4),
	('1303072002', '130307', 'Lalan', 4),
	('1303072003', '130307', 'Buluah Kasok', 4),
	('1303072004', '130307', 'Kampung Dalam', 4),
	('1303072005', '130307', 'Silongo', 4),
	('1303072006', '130307', 'Latang', 4),
	('1303082001', '130308', 'Limo Koto', 4),
	('1303082002', '130308', 'Palaluar', 4),
	('1303082003', '130308', 'Guguk', 4),
	('1303082004', '130308', 'Padang Laweh', 4),
	('1303082005', '130308', 'Tanjung', 4),
	('1303082006', '130308', 'Bukit Bual', 4),
	('1303092001', '130309', 'Silantai', 4),
	('1303092002', '130309', 'Sisawah', 4),
	('1303092003', '130309', 'Unggan', 4),
	('1303092004', '130309', 'Tanjung Bonai Aur', 4),
	('1303092005', '130309', 'Sumpur Kudus', 4),
	('1303092006', '130309', 'Tamparungo', 4),
	('1303092007', '130309', 'Kumanis', 4),
	('1303092008', '130309', 'Mangganti', 4),
	('1303092009', '130309', 'Sumpur Kudus Selatan', 4),
	('1303092010', '130309', 'Tanjuang Labuah', 4),
	('1303092011', '130309', 'Tanjung Bonai Aur Selatan', 4),
	('1303102001', '130310', 'Batu Manjulur', 4),
	('1303102002', '130310', 'Pamuatan', 4),
	('1303102003', '130310', 'Padang Sibusuk', 4),
	('1303102004', '130310', 'Desa Kampung Baru', 4),
	('1304012001', '130401', 'Tambangan', 4),
	('1304012002', '130401', 'Jaho', 4),
	('1304012003', '130401', 'Singgalang', 4),
	('1304012004', '130401', 'Paninjauan', 4),
	('1304012005', '130401', 'Panyalaian', 4),
	('1304012006', '130401', 'Koto Laweh', 4),
	('1304012007', '130401', 'Aia Angek', 4),
	('1304012008', '130401', 'Pandai Sikek', 4),
	('1304012009', '130401', 'Koto Baru', 4),
	('1304022001', '130402', 'Andaleh', 4),
	('1304022002', '130402', 'Sabu', 4),
	('1304022003', '130402', 'Batipuh Ateh', 4),
	('1304022004', '130402', 'Batipuh Baruh', 4),
	('1304022005', '130402', 'Gunung Rajo', 4),
	('1304022006', '130402', 'Pitalah', 4),
	('1304022007', '130402', 'Tanjung Barulak', 4),
	('1304022008', '130402', 'Bungo Tanjung', 4),
	('1304032001', '130403', 'Simawang', 4),
	('1304032002', '130403', 'Balimbing', 4),
	('1304032003', '130403', 'III Koto', 4),
	('1304032004', '130403', 'Padang Magek', 4),
	('1304032005', '130403', 'Rambatan', 4),
	('1304042001', '130404', 'Baringin', 4),
	('1304042002', '130404', 'Limo Kaum', 4),
	('1304042003', '130404', 'Parambahan', 4),
	('1304042004', '130404', 'Cubadak', 4),
	('1304042005', '130404', 'Labuah', 4),
	('1304052001', '130405', 'Tanjung Barulak', 4),
	('1304052002', '130405', 'Saruaso', 4),
	('1304052003', '130405', 'Koto Tangah', 4),
	('1304052004', '130405', 'Pagaruyung', 4),
	('1304062001', '130406', 'Taluak', 4),
	('1304062002', '130406', 'Buo', 4),
	('1304062003', '130406', 'Tigo Jangko', 4),
	('1304062004', '130406', 'Pangian', 4),
	('1304072001', '130407', 'Sungai Patai', 4),
	('1304072002', '130407', 'Andaleh Barung Bukik', 4),
	('1304072003', '130407', 'Tanjung', 4),
	('1304072004', '130407', 'Sungayang', 4),
	('1304072005', '130407', 'Minang Kabau', 4),
	('1304082001', '130408', 'Simpuruik', 4),
	('1304082002', '130408', 'Sungai Tarab', 4),
	('1304082003', '130408', 'Gurun', 4),
	('1304082004', '130408', 'Talang Tangah', 4),
	('1304082005', '130408', 'Padang Laweh', 4),
	('1304082006', '130408', 'Pasie Laweh', 4),
	('1304082007', '130408', 'Koto Tuo', 4),
	('1304082008', '130408', 'Rao Rao', 4),
	('1304082009', '130408', 'Kumango', 4),
	('1304082010', '130408', 'Koto Baru', 4),
	('1304092001', '130409', 'Batu Basa', 4),
	('1304092002', '130409', 'Tabek', 4),
	('1304092003', '130409', 'Sawah Tangah', 4),
	('1304092004', '130409', 'Simabur', 4),
	('1304092005', '130409', 'Pariangan', 4),
	('1304092006', '130409', 'Sungai Jambu', 4),
	('1304102001', '130410', 'Sumanik', 4),
	('1304102002', '130410', 'Situmbuk', 4),
	('1304102003', '130410', 'Lawang Mandahiling', 4),
	('1304102004', '130410', 'Supayang', 4),
	('1304102005', '130410', 'Salimpaung', 4),
	('1304102006', '130410', 'Tabek Patah', 4),
	('1304112001', '130411', 'Atar', 4),
	('1304112002', '130411', 'Padang Ganting', 4),
	('1304122001', '130412', 'Tanjung Alam', 4),
	('1304122002', '130412', 'Barulak', 4),
	('1304132001', '130413', 'Batu Bulek', 4),
	('1304132002', '130413', 'Balai Tangah', 4),
	('1304132003', '130413', 'Tanjuang Bonai', 4),
	('1304132004', '130413', 'Lubuak Jantan', 4),
	('1304132005', '130413', 'Tapi Selo', 4),
	('1304142001', '130414', 'Batu Taba', 4),
	('1304142002', '130414', 'Sumpur', 4),
	('1304142003', '130414', 'Padang Laweh Malalo', 4),
	('1304142004', '130414', 'Guguak Malalo', 4),
	('1305012001', '130501', 'Lubuk Alung', 4),
	('1305012002', '130501', 'Pungguang Kasiak Lubuk Alung', 4),
	('1305012003', '130501', 'Pasie Laweh Lubuk Alung', 4),
	('1305012004', '130501', 'Aie Tajun Lubuk Alung', 4),
	('1305012005', '130501', 'Sikabu Lubuk Alung', 4),
	('1305022001', '130502', 'Katapiang', 4),
	('1305022002', '130502', 'Kasang', 4),
	('1305022003', '130502', 'Sungai Buluah', 4),
	('1305022004', '130502', 'Buayan Lubuk Alung', 4),
	('1305032001', '130503', 'Kapalo Koto', 4),
	('1305032002', '130503', 'Pauh Kambar', 4),
	('1305032003', '130503', 'Padang Bintungan', 4),
	('1305032004', '130503', 'Kurai Taji', 4),
	('1305032005', '130503', 'Sunua', 4),
	('1305042002', '130504', 'Sicincin', 4),
	('1305042003', '130504', 'Lubuk Pandan', 4),
	('1305042004', '130504', 'Sungai Asam', 4),
	('1305052001', '130505', 'Balah Aia', 4),
	('1305052002', '130505', 'Sungai Sariak', 4),
	('1305052003', '130505', 'Lurah Ampalu', 4),
	('1305052004', '130505', 'Lareh Nan Panjang', 4),
	('1305062001', '130506', 'Campago', 4),
	('1305062002', '130506', 'Sikucur', 4),
	('1305072001', '130507', 'Kuranji Hulu', 4),
	('1305072002', '130507', 'Malai III Koto', 4),
	('1305072003', '130507', 'Batu Gadang Kuranji Hulu', 4),
	('1305072004', '130507', 'Sungai Sirah Kuranji Hulu', 4),
	('1305082001', '130508', 'Kuranji Hilir', 4),
	('1305082002', '130508', 'Pilubang', 4),
	('1305082003', '130508', 'Guguak Kuranji Hilir', 4),
	('1305082004', '130508', 'Koto Tinggi Kuranji Hilir', 4),
	('1305092001', '130509', 'III Koto Aur Malintang', 4),
	('1305092002', '130509', 'III Koto Aur Malintang Utara', 4),
	('1305092003', '130509', 'III Koto Aur Malintang Timur', 4),
	('1305092004', '130509', 'III Koto Aur Malintang Selatan', 4),
	('1305092005', '130509', 'Balai Baiak Malai III Koto', 4),
	('1305102001', '130510', 'Tapakih', 4),
	('1305102002', '130510', 'Ulakan', 4),
	('1305112001', '130511', 'Sintuak', 4),
	('1305112002', '130511', 'Toboh Gadang', 4),
	('1305122001', '130512', 'Koto Baru', 4),
	('1305122002', '130512', 'Koto Dalam', 4),
	('1305122003', '130512', 'Batu Kalang', 4),
	('1305132001', '130513', 'Malai V Suku', 4),
	('1305132002', '130513', 'Gasan Gadang', 4),
	('1305142001', '130514', 'Kudu Ganting', 4),
	('1305142002', '130514', 'Limau Puruik', 4),
	('1305142003', '130514', 'Gunung Padang Alai', 4),
	('1305152001', '130515', 'Kayu Tanam', 4),
	('1305152002', '130515', 'Guguak', 4),
	('1305152003', '130515', 'Anduriang', 4),
	('1305152004', '130515', 'Kapalo Hilalang', 4),
	('1305162001', '130516', 'Sungai Durian', 4),
	('1305162002', '130516', 'Tandikek', 4),
	('1305162003', '130516', 'Tandikek Utara', 4),
	('1305172001', '130517', 'Pakandangan', 4),
	('1305172002', '130517', 'Koto Tinggi', 4),
	('1305172003', '130517', 'Toboh Ketek', 4),
	('1305172004', '130517', 'Parit Malintang', 4),
	('1305172005', '130517', 'Gadur', 4),
	('1306012001', '130601', 'Tiku Selatan', 4),
	('1306012002', '130601', 'Tiku Utara', 4),
	('1306012003', '130601', 'Tiku Limo Jorong', 4),
	('1306022001', '130602', 'Lubuk Basung', 4),
	('1306022002', '130602', 'Geragahan', 4),
	('1306022003', '130602', 'Kampung Pinang', 4),
	('1306022004', '130602', 'Kampung Tangah', 4),
	('1306022005', '130602', 'Manggopoh', 4),
	('1306032001', '130603', 'Tanjung Sani', 4),
	('1306032002', '130603', 'Sungai Batang', 4),
	('1306032003', '130603', 'Maninjau', 4),
	('1306032004', '130603', 'Bayua', 4),
	('1306032006', '130603', 'Koto Kaciak', 4),
	('1306032007', '130603', 'Duo Koto', 4),
	('1306032008', '130603', 'Koto Gadang', 4),
	('1306032009', '130603', 'Koto Malintang', 4),
	('1306032010', '130603', 'Paninjauan', 4),
	('1306042001', '130604', 'Matua Hilia', 4),
	('1306042002', '130604', 'Matua Mudiak', 4),
	('1306042003', '130604', 'Tigo Balai', 4),
	('1306042004', '130604', 'Lawang', 4),
	('1306042005', '130604', 'Parik Panjang', 4),
	('1306042006', '130604', 'Panta Pauh', 4),
	('1306052002', '130605', 'Sungai Landia', 4),
	('1306052003', '130605', 'Balingka', 4),
	('1306052004', '130605', 'Koto Tuo', 4),
	('1306052005', '130605', 'Guguk Tabek Sarajo', 4),
	('1306052006', '130605', 'Koto Panjang', 4),
	('1306052007', '130605', 'Sianok Anam Suku', 4),
	('1306052008', '130605', 'Koto Gadang', 4),
	('1306062001', '130606', 'Padang Lua', 4),
	('1306062002', '130606', 'Taluak Ampek Suku', 4),
	('1306062003', '130606', 'Pakan Sinayan', 4),
	('1306062004', '130606', 'Kubang Putiah', 4),
	('1306062005', '130606', 'Ladang Laweh', 4),
	('1306062006', '130606', 'Cingkariang', 4),
	('1306062007', '130606', 'Sungai Tanang', 4),
	('1306072001', '130607', 'Batu Taba', 4),
	('1306072002', '130607', 'Biaro Gadang', 4),
	('1306072003', '130607', 'Lambah', 4),
	('1306072004', '130607', 'Panampung', 4),
	('1306072005', '130607', 'Ampang Gadang', 4),
	('1306072006', '130607', 'Pasia', 4),
	('1306072008', '130607', 'Balai Gurah', 4),
	('1306082001', '130608', 'Koto Tinggi', 4),
	('1306082002', '130608', 'Tabek Panjang', 4),
	('1306082004', '130608', 'Simarasok', 4),
	('1306082005', '130608', 'Padang Tarok', 4),
	('1306082006', '130608', 'Salo', 4),
	('1306082007', '130608', 'Koto Baru', 4),
	('1306092001', '130609', 'Koto Tangah', 4),
	('1306092003', '130609', 'Gadut', 4),
	('1306092004', '130609', 'Kapau', 4),
	('1306102001', '130610', 'Koto Rantang', 4),
	('1306102002', '130610', 'Pasia Laweh', 4),
	('1306102003', '130610', 'Pagadih', 4),
	('1306102004', '130610', 'Nan Tujuah', 4),
	('1306112001', '130611', 'Baringin', 4),
	('1306112002', '130611', 'Sipinang', 4),
	('1306112003', '130611', 'Sungai Puar', 4),
	('1306112004', '130611', 'Ampek Koto Palembayan', 4),
	('1306112005', '130611', 'Tigo Koto Silungkang', 4),
	('1306112006', '130611', 'Salareh Aia', 4),
	('1306122001', '130612', 'Padang Laweh', 4),
	('1306122002', '130612', 'Sungai Pua', 4),
	('1306122003', '130612', 'Batagak', 4),
	('1306122004', '130612', 'Batu Palano', 4),
	('1306122005', '130612', 'Sariak', 4),
	('1306132001', '130613', 'Batu Kambing', 4),
	('1306132002', '130613', 'Sitalang', 4),
	('1306132003', '130613', 'Bawan', 4),
	('1306132004', '130613', 'Sitanang', 4),
	('1306142001', '130614', 'Canduang Koto Laweh', 4),
	('1306142002', '130614', 'Lasi', 4),
	('1306142003', '130614', 'Bukik Batabuah', 4),
	('1306152001', '130615', 'Magek', 4),
	('1306152002', '130615', 'Kamang Hilia', 4),
	('1306152003', '130615', 'Kamang Mudiak', 4),
	('1306162001', '130616', 'Malalak Utara', 4),
	('1306162002', '130616', 'Malalak Timur', 4),
	('1306162003', '130616', 'Malalak Selatan', 4),
	('1306162004', '130616', 'Malalak Barat', 4),
	('1307012001', '130701', 'Kurai', 4),
	('1307012002', '130701', 'Sungai Rimbang', 4),
	('1307012003', '130701', 'Tanjuang Bungo', 4),
	('1307012004', '130701', 'Suliki', 4),
	('1307012005', '130701', 'Limbanang', 4),
	('1307012006', '130701', 'Andiang', 4),
	('1307022001', '130702', 'Guguak VIII Koto', 4),
	('1307022002', '130702', 'VII Koto Talago', 4),
	('1307022003', '130702', 'Sungai Talang', 4),
	('1307022004', '130702', 'Kubang', 4),
	('1307022005', '130702', 'Simpang Sugiran', 4),
	('1307032001', '130703', 'Koto Baru Simalanggang', 4),
	('1307032002', '130703', 'Taeh Bukik', 4),
	('1307032003', '130703', 'Simalanggang', 4),
	('1307032004', '130703', 'Sungai Beringin', 4),
	('1307032005', '130703', 'Piobang', 4),
	('1307032006', '130703', 'Taeh Baruah', 4),
	('1307032007', '130703', 'Koto Tangah Simalanggang', 4),
	('1307042001', '130704', 'Tj. Haro Sikabu-kabu Pd. Panjang', 4),
	('1307042002', '130704', 'Mungo', 4),
	('1307042003', '130704', 'Sungai Kamuyang', 4),
	('1307042004', '130704', 'Andaleh', 4),
	('1307052001', '130705', 'Taram', 4),
	('1307052002', '130705', 'Solok Bio Bio', 4),
	('1307052003', '130705', 'Tarantang', 4),
	('1307052004', '130705', 'Bukik Limbuku', 4),
	('1307052005', '130705', 'Harau', 4),
	('1307052006', '130705', 'Batu Balang', 4),
	('1307052007', '130705', 'Sarilamak', 4),
	('1307052008', '130705', 'Gurun', 4),
	('1307052009', '130705', 'Lubuak Batingkok', 4),
	('1307052010', '130705', 'Koto Tuo', 4),
	('1307052011', '130705', 'Pilubang', 4),
	('1307062001', '130706', 'Manggilang', 4),
	('1307062002', '130706', 'Tanjuang Balik', 4),
	('1307062003', '130706', 'Gunuang Malintang', 4),
	('1307062004', '130706', 'Pangkalan', 4),
	('1307062005', '130706', 'Koto Alam', 4),
	('1307062006', '130706', 'Tanjung Pauh', 4),
	('1307072001', '130707', 'Muaro Paiti', 4),
	('1307072002', '130707', 'Koto Bangun', 4),
	('1307072003', '130707', 'Lubuak Alai', 4),
	('1307072004', '130707', 'Koto Lamo', 4),
	('1307072005', '130707', 'Durian Tinggi', 4),
	('1307072006', '130707', 'Sialang', 4),
	('1307072007', '130707', 'Galugua', 4),
	('1307082001', '130708', 'Pandam Gadang', 4),
	('1307082002', '130708', 'Koto Tinggi', 4),
	('1307082003', '130708', 'Talang Anau', 4),
	('1307092001', '130709', 'Labuah Gunuang', 4),
	('1307092002', '130709', 'Batu Payuang', 4),
	('1307092003', '130709', 'Ampalu', 4),
	('1307092004', '130709', 'Bukik Sikumpa', 4),
	('1307092005', '130709', 'Balai Panjang', 4),
	('1307092006', '130709', 'Halaban', 4),
	('1307092007', '130709', 'Tanjuang Gadang', 4),
	('1307092008', '130709', 'Sitanang', 4),
	('1307102001', '130710', 'Situjuah Batua', 4),
	('1307102002', '130710', 'Situjuah Ladang Laweh', 4),
	('1307102003', '130710', 'Tungka', 4),
	('1307102004', '130710', 'Situjuah Banda Dalam', 4),
	('1307102005', '130710', 'Situjuah Gadang', 4),
	('1307112001', '130711', 'Jopang Manganti', 4),
	('1307112002', '130711', 'Simpang Kapuak', 4),
	('1307112003', '130711', 'Mungka', 4),
	('1307112004', '130711', 'Talang Maur', 4),
	('1307112005', '130711', 'Sungai Antuan', 4),
	('1307122001', '130712', 'Maek', 4),
	('1307122002', '130712', 'Banja Loweh', 4),
	('1307122003', '130712', 'Baruah Gunuang', 4),
	('1307122004', '130712', 'Sungai Naniang', 4),
	('1307122005', '130712', 'Koto Tangah', 4),
	('1307132001', '130713', 'Sariak Laweh', 4),
	('1307132002', '130713', 'Koto Tangah Batu Ampa', 4),
	('1307132003', '130713', 'Batuhampar', 4),
	('1307132004', '130713', 'Suayan', 4),
	('1307132005', '130713', 'Sungai Balantiak', 4),
	('1307132006', '130713', 'Pauh Sangik', 4),
	('1307132007', '130713', 'Durian Gadang', 4),
	('1308042001', '130804', 'Limo Koto', 4),
	('1308042002', '130804', 'Koto Kaciak', 4),
	('1308042003', '130804', 'Ganggo Mudiak', 4),
	('1308042004', '130804', 'Ganggo Hilia', 4),
	('1308052001', '130805', 'Tanjuang Baringin', 4),
	('1308052002', '130805', 'Jambak', 4),
	('1308052003', '130805', 'Durian Tinggi', 4),
	('1308052004', '130805', 'Pauah', 4),
	('1308052005', '130805', 'Aia Manggih', 4),
	('1308052006', '130805', 'Sundata', 4),
	('1308072001', '130807', 'Panti', 4),
	('1308082001', '130808', 'Muara Tais', 4),
	('1308082002', '130808', 'Lubuak Gadang', 4),
	('1308082005', '130808', 'Pintu Padang', 4),
	('1308122001', '130812', 'Simpang Tonang', 4),
	('1308122002', '130812', 'Cubadak', 4),
	('1308132001', '130813', 'Malampah', 4),
	('1308132002', '130813', 'Ladang Panjang', 4),
	('1308132003', '130813', 'Binjai', 4),
	('1308142002', '130814', 'Taruang Taruang', 4),
	('1308142005', '130814', 'Padang Mantinggi', 4),
	('1308152001', '130815', 'Silayang', 4),
	('1308152002', '130815', 'Muaro Sungai Lolo', 4),
	('1308162001', '130816', 'Alahan Mati', 4),
	('1308162002', '130816', 'Simpang', 4),
	('1308172001', '130817', 'Padang Gelugur', 4),
	('1308182001', '130818', 'Koto Nopan', 4),
	('1308182002', '130818', 'Koto Rajo', 4),
	('1308182003', '130818', 'Languang', 4),
	('1308192001', '130819', 'Lansek Kadok', 4),
	('1308192002', '130819', 'Lubuak Layang', 4),
	('1308192003', '130819', 'Tanjung Betung', 4),
	('1309012007', '130901', 'Betumonga', 4),
	('1309012008', '130901', 'Silabu', 4),
	('1309012009', '130901', 'Saumanganyak', 4),
	('1309022001', '130902', 'Bosua', 4),
	('1309022002', '130902', 'Beriulou', 4),
	('1309022003', '130902', 'Nemnem Leleu', 4),
	('1309022004', '130902', 'Mara', 4),
	('1309022006', '130902', 'Sioban', 4),
	('1309022007', '130902', 'Matobe', 4),
	('1309022008', '130902', 'Saureinu', 4),
	('1309032002', '130903', 'Muara Siberut', 4),
	('1309032003', '130903', 'Maileppet', 4),
	('1309032004', '130903', 'Muntei', 4),
	('1309032005', '130903', 'Matotonan', 4),
	('1309032007', '130903', 'Madobag', 4),
	('1309042003', '130904', 'Bojakan', 4),
	('1309042004', '130904', 'Sotboyak', 4),
	('1309042005', '130904', 'Manganpoula', 4),
	('1309042006', '130904', 'Muara Sikabaluan', 4),
	('1309042007', '130904', 'Sirilogui', 4),
	('1309042008', '130904', 'Malancan', 4),
	('1309052001', '130905', 'Simatalu', 4),
	('1309052002', '130905', 'Simalegi', 4),
	('1309052003', '130905', 'Sigapokna', 4),
	('1309062001', '130906', 'Katurei', 4),
	('1309062002', '130906', 'Sagalubbeg', 4),
	('1309062003', '130906', 'Pasakiat Taileleu', 4),
	('1309072001', '130907', 'Saibi Samukop', 4),
	('1309072002', '130907', 'Cimpungan', 4),
	('1309072003', '130907', 'Saliguma', 4),
	('1309082001', '130908', 'Betumonga', 4),
	('1309082002', '130908', 'Goisooinan', 4),
	('1309082003', '130908', 'Tuapejat', 4),
	('1309082004', '130908', 'Sido Makmur', 4),
	('1309082005', '130908', 'Bukit Pamewa', 4),
	('1309082006', '130908', 'Sipora Jaya', 4),
	('1309092001', '130909', 'Sikakap', 4),
	('1309092002', '130909', 'Taikako', 4),
	('1309092003', '130909', 'Matobe', 4),
	('1309102001', '130910', 'Sinaka', 4),
	('1309102002', '130910', 'Bulasat', 4),
	('1309102003', '130910', 'Malakopa', 4),
	('1309102004', '130910', 'Makalo', 4),
	('1310012002', '131001', 'Koto Baru', 4),
	('1310012003', '131001', 'Sialang Gaung', 4),
	('1310012005', '131001', 'Ampang Kuranji', 4),
	('1310012008', '131001', 'Koto Padang', 4),
	('1310022001', '131002', 'Sungai Dareh', 4),
	('1310022002', '131002', 'Tebing Tinggi', 4),
	('1310022006', '131002', 'Empat Koto Pulau Punjung', 4),
	('1310022007', '131002', 'Sungai Kambut', 4),
	('1310022008', '131002', 'Gunung Selasih', 4),
	('1310022009', '131002', 'Sikabau', 4),
	('1310032003', '131003', 'Sungai Rumbai', 4),
	('1310032004', '131003', 'Kurnia Koto Salak', 4),
	('1310032007', '131003', 'Sungai Rumbai Timur', 4),
	('1310032008', '131003', 'Kurnia Selatan', 4),
	('1310042001', '131004', 'Sitiung', 4),
	('1310042002', '131004', 'Siguntur', 4),
	('1310042004', '131004', 'Gunung Medan', 4),
	('1310042005', '131004', 'Sungai Duo', 4),
	('1310052001', '131005', 'Silago', 4),
	('1310052002', '131005', 'Lubuak Karak', 4),
	('1310052003', '131005', 'Koto Nan Empat Dibawuh', 4),
	('1310052004', '131005', 'Banai', 4),
	('1310062001', '131006', 'Timpeh', 4),
	('1310062002', '131006', 'Taratak Tinggi', 4),
	('1310062003', '131006', 'Tabek', 4),
	('1310062004', '131006', 'Panyubarangan', 4),
	('1310062005', '131006', 'Ranah Palabi', 4),
	('1310072001', '131007', 'Koto Salak', 4),
	('1310072002', '131007', 'Ampalu', 4),
	('1310072003', '131007', 'Padukuan', 4),
	('1310072004', '131007', 'Pulau Mainan', 4),
	('1310072005', '131007', 'Simalidu', 4),
	('1310082001', '131008', 'Tiumang', 4),
	('1310082002', '131008', 'Sungai Langkok', 4),
	('1310082003', '131008', 'Koto Beringin', 4),
	('1310082004', '131008', 'Sipangkur', 4),
	('1310092001', '131009', 'Padang Laweh', 4),
	('1310092002', '131009', 'Batu Rijal', 4),
	('1310092003', '131009', 'Muaro Sopan', 4),
	('1310092004', '131009', 'Sopan Jaya', 4),
	('1310102001', '131010', 'Sungai Limau', 4),
	('1310102002', '131010', 'Alahan Nan Tigo', 4),
	('1310102003', '131010', 'Lubuk Besar', 4),
	('1310102004', '131010', 'Tanjung Alam', 4),
	('1310102005', '131010', 'Sinamar', 4),
	('1310112001', '131011', 'Koto Besar', 4),
	('1310112002', '131011', 'Koto Tinggi', 4),
	('1310112003', '131011', 'Koto Gadang', 4),
	('1310112004', '131011', 'Bonjol', 4),
	('1310112005', '131011', 'Abai Siat', 4),
	('1310112006', '131011', 'Koto Laweh', 4),
	('1310112007', '131011', 'Koto Ranah', 4),
	('1311012001', '131101', 'Lubuk Gadang', 4),
	('1311012002', '131101', 'Lubuk Gadang Timur', 4),
	('1311012003', '131101', 'Lubuk Gadang Selatan', 4),
	('1311012004', '131101', 'Lubuk Gadang Utara', 4),
	('1311022001', '131102', 'Pasir Talang', 4),
	('1311022002', '131102', 'Koto Baru', 4),
	('1311022004', '131102', 'Sako Pasia Talang', 4),
	('1311022005', '131102', 'Pasar Muara Labuh', 4),
	('1311022006', '131102', 'Pulakek Koto Baru', 4),
	('1311022007', '131102', 'Bomas', 4),
	('1311022008', '131102', 'Sako Utara Pasia Talang', 4),
	('1311022009', '131102', 'Sako Selatan Pasia Talang', 4),
	('1311022010', '131102', 'Pasir Talang Barat', 4),
	('1311022011', '131102', 'Pasir Talang Timur', 4),
	('1311022012', '131102', 'Pasir Talang Selatan', 4),
	('1311032001', '131103', 'Pakan Rabaa', 4),
	('1311032002', '131103', 'Pakan Rabaa Timur', 4),
	('1311032003', '131103', 'Pakan Rabaa Utara', 4),
	('1311032004', '131103', 'Pakan Rabaa Tengah', 4),
	('1311042001', '131104', 'Lubuk Malako', 4),
	('1311042002', '131104', 'Bidar Alam', 4),
	('1311042004', '131104', 'Padang Air Dingin', 4),
	('1311042005', '131104', 'Padang Limau Sundai', 4),
	('1311042006', '131104', 'Padang Gantiang', 4),
	('1311052001', '131105', 'Abai', 4),
	('1311052002', '131105', 'Dusun Tangah', 4),
	('1311052003', '131105', 'Lubuk Ulang Aling', 4),
	('1311052004', '131105', 'Ranah Pantai Cermin', 4),
	('1311052005', '131105', 'Sitapus', 4),
	('1311052006', '131105', 'Lubuk Ulang Aling Selatan', 4),
	('1311052007', '131105', 'Lubuk Ulang Aling Tengah', 4),
	('1311062001', '131106', 'Alam Pauh Duo', 4),
	('1311062002', '131106', 'Kapau Alam Pauh Duo', 4),
	('1311062003', '131106', 'Luak Kapau Alam Pauh Duo', 4),
	('1311062004', '131106', 'Pauh Duo Nan Batigo', 4),
	('1311072001', '131107', 'Sungai Kunyit', 4),
	('1311072002', '131107', 'Talao Sungai Kunyit', 4),
	('1311072003', '131107', 'Sungai Kunyit Barat', 4),
	('1311072004', '131107', 'Talunan Maju', 4),
	('1312012001', '131201', 'Aia Bangih', 4),
	('1312022001', '131202', 'Ujung Gading', 4),
	('1312032003', '131203', 'Lingkuang Aua', 4),
	('1312032004', '131203', 'Aua Kuniang', 4),
	('1312032006', '131203', 'Aia Gadang', 4),
	('1312042001', '131204', 'Kajai', 4),
	('1312042002', '131204', 'Talu', 4),
	('1312042003', '131204', 'Sinuruik', 4),
	('1312052001', '131205', 'Kinali', 4),
	('1312052002', '131205', 'Katiagan', 4),
	('1312062001', '131206', 'Muaro Kiawai', 4),
	('1312062002', '131206', 'Rabi Jonggor', 4),
	('1312072001', '131207', 'Batahan', 4),
	('1312072002', '131207', 'Desa Baru', 4),
	('1312082001', '131208', 'Parit', 4),
	('1312092001', '131209', 'Sungai Aua', 4),
	('1312102001', '131210', 'Koto Baru', 4),
	('1312102002', '131210', 'Kapa', 4),
	('1312112001', '131211', 'Sasak', 4),
	('1371011001', '137101', 'Belakang Pondok', 3),
	('1371011002', '137101', 'Alang Laweh', 3),
	('1371011003', '137101', 'Ranah Parak Rumbio', 3),
	('1371011004', '137101', 'Pasa Gadang', 3),
	('1371011005', '137101', 'Batang Arau', 3),
	('1371011006', '137101', 'Seberang Palinggam', 3),
	('1371011007', '137101', 'Seberang Padang', 3),
	('1371011008', '137101', 'Mata Air', 3),
	('1371011009', '137101', 'Rawang', 3),
	('1371011010', '137101', 'Teluk Bayur', 3),
	('1371011011', '137101', 'Air Manis', 3),
	('1371011012', '137101', 'Bukit Gado-gado', 3),
	('1371021001', '137102', 'Sawahan', 3),
	('1371021002', '137102', 'Jati Baru', 3),
	('1371021003', '137102', 'Jati', 3),
	('1371021004', '137102', 'Sawahan Timur', 3),
	('1371021005', '137102', 'Simpang Haru', 3),
	('1371021006', '137102', 'Kubu Marapalam', 3),
	('1371021007', '137102', 'Andalas', 3),
	('1371021008', '137102', 'Kubu Dalam Parak Karakah', 3),
	('1371021009', '137102', 'Parak Gadang Timur', 3),
	('1371021010', '137102', 'Ganting Parak Gadang', 3),
	('1371031001', '137103', 'Flamboyan Baru', 3),
	('1371031002', '137103', 'Rimbo Kaluang', 3),
	('1371031003', '137103', 'Ujung Gurun', 3),
	('1371031004', '137103', 'Purus', 3),
	('1371031005', '137103', 'Padang Pasir', 3),
	('1371031006', '137103', 'Olo', 3),
	('1371031007', '137103', 'Kampung Jao', 3),
	('1371031008', '137103', 'Belakang Tangsi', 3),
	('1371031009', '137103', 'Kampung Pondok', 3),
	('1371031010', '137103', 'Berok Nipah', 3),
	('1371041001', '137104', 'Air Tawar Timur', 3),
	('1371041002', '137104', 'Air Tawar Barat', 3),
	('1371041003', '137104', 'Ulak Karang Utara', 3),
	('1371041004', '137104', 'Ulak Karang Selatan', 3),
	('1371041005', '137104', 'Lolong Belanti', 3),
	('1371041006', '137104', 'Alai Parak Kopi', 3),
	('1371041007', '137104', 'Gunung Pangilun', 3),
	('1371051001', '137105', 'Bungus Timur', 3),
	('1371051002', '137105', 'Bungus Barat', 3),
	('1371051003', '137105', 'Bungus Selatan', 3),
	('1371051004', '137105', 'Teluk Kabung Utara', 3),
	('1371051005', '137105', 'Teluk Kabung Tengah', 3),
	('1371051006', '137105', 'Teluk Kabung Selatan', 3),
	('1371061001', '137106', 'Cangkeh Nan XX', 3),
	('1371061002', '137106', 'Kampung Baru Nan XX', 3),
	('1371061003', '137106', 'Tanah Sirah Piai Nan XX', 3),
	('1371061004', '137106', 'Tanjung Saba Pitamen Nan XX', 3),
	('1371061005', '137106', 'Lubuk Begalung Nan XX', 3),
	('1371061006', '137106', 'Gurun Laweh Nan XX', 3),
	('1371061007', '137106', 'Tanjung Aua Nan XX', 3),
	('1371061008', '137106', 'Koto Baru Nan XX', 3),
	('1371061009', '137106', 'Banuaran Nan XX', 3),
	('1371061010', '137106', 'Parak Laweh Pulau Aia Nan XX', 3),
	('1371061011', '137106', 'Batung Taba Nan XX', 3),
	('1371061012', '137106', 'Pagambiran Ampalu Nan XX', 3),
	('1371061013', '137106', 'Pampangan Nan XX', 3),
	('1371061014', '137106', 'Gates Nan XX', 3),
	('1371061015', '137106', 'Kampung Jua Nan XX', 3),
	('1371071001', '137107', 'Indarung', 3),
	('1371071002', '137107', 'Padang Besi', 3),
	('1371071003', '137107', 'Batu Gadang', 3),
	('1371071004', '137107', 'Bandar Buat', 3),
	('1371071005', '137107', 'Koto Lalang', 3),
	('1371071006', '137107', 'Baringin', 3),
	('1371071007', '137107', 'Tarantang', 3),
	('1371081001', '137108', 'Limau Manis', 3),
	('1371081002', '137108', 'Koto Lua', 3),
	('1371081003', '137108', 'Limau Manis Selatan', 3),
	('1371081004', '137108', 'Piai Tangah', 3),
	('1371081005', '137108', 'Cupak Tangah', 3),
	('1371081006', '137108', 'Pisang', 3),
	('1371081007', '137108', 'Binuang Kampuang Dalam', 3),
	('1371081008', '137108', 'Kapalo Koto', 3),
	('1371081009', '137108', 'Lambung Bukik', 3),
	('1371091001', '137109', 'Pasar Ambacang', 3),
	('1371091002', '137109', 'Anduring', 3),
	('1371091003', '137109', 'Lubuk Lintah', 3),
	('1371091004', '137109', 'Ampang', 3),
	('1371091005', '137109', 'Kalumbuk', 3),
	('1371091006', '137109', 'Korong Gadang', 3),
	('1371091007', '137109', 'Kuranji', 3),
	('1371091008', '137109', 'Gunung Sarik', 3),
	('1371091009', '137109', 'Sungai Sapih', 3),
	('1371101001', '137110', 'Surau Gadang', 3),
	('1371101002', '137110', 'Kampung Olo', 3),
	('1371101003', '137110', 'Kurao Pagang', 3),
	('1371101004', '137110', 'Gurun Laweh', 3),
	('1371101005', '137110', 'Tabing Banda Gadang', 3),
	('1371101006', '137110', 'Kampung Lapai', 3),
	('1371111001', '137111', 'Balai Gadang', 3),
	('1371111002', '137111', 'Lubuk Minturun', 3),
	('1371111003', '137111', 'Aie Pacah', 3),
	('1371111004', '137111', 'Dadok Tunggul Hitam', 3),
	('1371111005', '137111', 'Koto Panjang Ikua Koto', 3),
	('1371111006', '137111', 'Koto Pulai', 3),
	('1371111007', '137111', 'Batipuh Panjang', 3),
	('1371111008', '137111', 'Padang Sarai', 3),
	('1371111009', '137111', 'Lubuk Buaya', 3),
	('1371111010', '137111', 'Batang Kabung Ganting', 3),
	('1371111011', '137111', 'Bungo Pasang', 3),
	('1371111012', '137111', 'Parupuk Tabing', 3),
	('1371111013', '137111', 'Pasie Nan Tigo', 3),
	('1372011001', '137201', 'Tanah Garam', 3),
	('1372011002', '137201', 'VI Suku', 3),
	('1372011003', '137201', 'Sinapa Piliang', 3),
	('1372011004', '137201', 'IX Korong', 3),
	('1372011005', '137201', 'Kampai Tabu Karambia', 3),
	('1372011006', '137201', 'Aro IV Korong', 3),
	('1372011007', '137201', 'Simpang Rumbio', 3),
	('1372021001', '137202', 'Koto Panjang', 3),
	('1372021002', '137202', 'Pasar Pandan Air Mati', 3),
	('1372021003', '137202', 'Tanjung Paku', 3),
	('1372021004', '137202', 'Nan Balimo', 3),
	('1372021005', '137202', 'Kampung Jawa', 3),
	('1372021006', '137202', 'Laing', 3),
	('1373011001', '137301', 'Aur Mulio', 3),
	('1373011002', '137301', 'Kubang Sirakuk Utara', 3),
	('1373011003', '137301', 'Kubang S. Selatan', 3),
	('1373011004', '137301', 'Pasar', 3),
	('1373011005', '137301', 'Tanah Lapang', 3),
	('1373011006', '137301', 'Aia Dingin', 3),
	('1373012007', '137301', 'Lunto Timur', 4),
	('1373012008', '137301', 'Lunto Barat', 4),
	('1373012009', '137301', 'Kubang Tangah', 4),
	('1373012010', '137301', 'Kubang Utara Sikabu', 4),
	('1373012011', '137301', 'Pasa Kubang', 4),
	('1373021001', '137302', 'Saringan', 3),
	('1373021002', '137302', 'Lubang Panjang', 3),
	('1373021003', '137302', 'Durian I', 3),
	('1373021004', '137302', 'Durian II', 3),
	('1373022005', '137302', 'Santua', 4),
	('1373022006', '137302', 'Kolok Mudiak', 4),
	('1373022007', '137302', 'Kolok Nan Tuo', 4),
	('1373022008', '137302', 'Talago Gunung', 4),
	('1373022009', '137302', 'Lumindai', 4),
	('1373022010', '137302', 'Balai Batu Sadara', 4),
	('1373032001', '137303', 'Silungkang Duo', 4),
	('1373032002', '137303', 'Silungkang Oso', 4),
	('1373032003', '137303', 'Silungkang Tigo', 4),
	('1373032004', '137303', 'Muaro Kalaban', 4),
	('1373032005', '137303', 'Taratak Boncah', 4),
	('1373042001', '137304', 'Talawi Hilie', 4),
	('1373042002', '137304', 'Talawi Mudiak', 4),
	('1373042003', '137304', 'Bukit Gadang', 4),
	('1373042004', '137304', 'Batu Tanjung', 4),
	('1373042005', '137304', 'Kumbayau', 4),
	('1373042006', '137304', 'Tumpuk Tangah', 4),
	('1373042007', '137304', 'Data Mansiang', 4),
	('1373042008', '137304', 'Sijantang Koto', 4),
	('1373042009', '137304', 'Salak', 4),
	('1373042010', '137304', 'Sikalang', 4),
	('1373042011', '137304', 'Rantih', 4),
	('1374011001', '137401', 'Ganting', 3),
	('1374011002', '137401', 'Sigando', 3),
	('1374011003', '137401', 'Ekor Lubuk', 3),
	('1374011004', '137401', 'Ngalau', 3),
	('1374011005', '137401', 'Guguk Malintang', 3),
	('1374011006', '137401', 'Koto Panjang', 3),
	('1374011007', '137401', 'Koto Katik', 3),
	('1374011008', '137401', 'Tanah Pak Lambik', 3),
	('1374021001', '137402', 'Bukit Surungan', 3),
	('1374021002', '137402', 'Pasar Usang', 3),
	('1374021003', '137402', 'Kampung Manggis', 3),
	('1374021004', '137402', 'Silaing Bawah', 3),
	('1374021005', '137402', 'Silaing Atas', 3),
	('1374021006', '137402', 'Pasar Baru', 3),
	('1374021007', '137402', 'Tanah Hitam', 3),
	('1374021008', '137402', 'Balai-balai', 3),
	('1375011001', '137501', 'Tarok Dipo', 3),
	('1375011002', '137501', 'Bukik Cangang/Kayu Rmg.', 3),
	('1375011003', '137501', 'Pakan Kurai', 3),
	('1375011004', '137501', 'Aur Tajungkang/Tgh. Sawah', 3),
	('1375011005', '137501', 'Benteng Pasar Atas', 3),
	('1375011006', '137501', 'Kayu Kubu', 3),
	('1375011007', '137501', 'Bukik Apik Puhun', 3),
	('1375021001', '137502', 'Campago Guguk Bulek', 3),
	('1375021002', '137502', 'Campago Ipuh', 3),
	('1375021003', '137502', 'Puhun Tembok', 3),
	('1375021004', '137502', 'Kubu Gulai Bancah', 3),
	('1375021005', '137502', 'Puhun Pintu Kabun', 3),
	('1375021006', '137502', 'Pulai Anak Air', 3),
	('1375021007', '137502', 'Koto Selayan', 3),
	('1375021008', '137502', 'Garegeh', 3),
	('1375021009', '137502', 'Manggis/Ganting', 3),
	('1375031001', '137503', 'Aur Kuning', 3),
	('1375031002', '137503', 'Birugo', 3),
	('1375031003', '137503', 'Belakang Balok', 3),
	('1375031004', '137503', 'Sapiran', 3),
	('1375031005', '137503', 'Kubu Tanjung', 3),
	('1375031006', '137503', 'Pakan Labuh', 3),
	('1375031007', '137503', 'Parit Rantang', 3),
	('1375031008', '137503', 'Ladang Cakiah', 3),
	('1376011001', '137601', 'Balai Nan Duo', 3),
	('1376011002', '137601', 'Pakan Sinayan', 3),
	('1376011003', '137601', 'Kubu Gadang', 3),
	('1376011004', '137601', 'Bulakan Balai Kandi', 3),
	('1376011005', '137601', 'Payolansek', 3),
	('1376011006', '137601', 'Tanjuang Gadang', 3),
	('1376011007', '137601', 'Talang', 3),
	('1376011008', '137601', 'Sungai Pinago', 3),
	('1376011009', '137601', 'Padang Tinggi', 3),
	('1376011010', '137601', 'Padang Tangah', 3),
	('1376011011', '137601', 'Koto Tangah', 3),
	('1376011012', '137601', 'Padang Datar', 3),
	('1376011013', '137601', 'Subarang Batuang', 3),
	('1376011014', '137601', 'Tanah Mati', 3),
	('1376011015', '137601', 'Piliang', 3),
	('1376011016', '137601', 'Parik Rantang', 3),
	('1376011017', '137601', 'Parak Batuang', 3),
	('1376011018', '137601', 'Daya Bangun', 3),
	('1376011019', '137601', 'Nunang', 3),
	('1376011020', '137601', 'Labuah Basilang', 3),
	('1376011021', '137601', 'Ibuah', 3),
	('1376011022', '137601', 'Tanjung Pauh', 3),
	('1376021001', '137602', 'Bunian', 3),
	('1376021002', '137602', 'Napar', 3),
	('1376021003', '137602', 'Padang Kaduduak', 3),
	('1376021004', '137602', 'Tarok', 3),
	('1376021005', '137602', 'Cubadak Aia', 3),
	('1376021006', '137602', 'Tambago', 3),
	('1376021007', '137602', 'Talawi', 3),
	('1376021008', '137602', 'Balai Batuang', 3),
	('1376021009', '137602', 'Tanjung Anau', 3),
	('1376021010', '137602', 'Payonibung', 3),
	('1376021011', '137602', 'Payolinyam', 3),
	('1376021012', '137602', 'Nan Kodok', 3),
	('1376021013', '137602', 'Kaning Bukit', 3),
	('1376021014', '137602', 'Muaro', 3),
	('1376021015', '137602', 'Pasir', 3),
	('1376021016', '137602', 'Taruko', 3),
	('1376021017', '137602', 'Balai Cacang', 3),
	('1376021018', '137602', 'Balai Gadang', 3),
	('1376021019', '137602', 'Balai jaring', 3),
	('1376021020', '137602', 'Balai Gurun', 3),
	('1376021021', '137602', 'Balai Baru', 3),
	('1376021022', '137602', 'Balai Kaliki', 3),
	('1376021023', '137602', 'Koto Baru', 3),
	('1376021024', '137602', 'Labuah Baru', 3),
	('1376021025', '137602', 'Kubu Gadang', 3),
	('1376031001', '137603', 'Balai Jaring', 3),
	('1376031002', '137603', 'Bodi', 3),
	('1376031003', '137603', 'Padang Tangah Payobadar', 3),
	('1376031004', '137603', 'Padang Alai', 3),
	('1376031005', '137603', 'Sicincin Hilir', 3),
	('1376031006', '137603', 'Sicincin Mudik', 3),
	('1376031007', '137603', 'Padang Tiakar Hilir', 3),
	('1376031008', '137603', 'Padang Tiakar Mudik', 3),
	('1376031009', '137603', 'Payobasung', 3),
	('1376031010', '137603', 'Koto Panjang', 3),
	('1376031011', '137603', 'Koto Baru', 3),
	('1376031012', '137603', 'Balai Batimah', 3),
	('1376031013', '137603', 'Balai Nan Tuo', 3),
	('1376031014', '137603', 'Ranah', 3),
	('1376041001', '137604', 'Sungai Durian', 3),
	('1376041002', '137604', 'Parit Muko Aie', 3),
	('1376041003', '137604', 'Parambahan', 3),
	('1376041004', '137604', 'Padang Sikabu', 3),
	('1376041005', '137604', 'Koto Panjang Padang', 3),
	('1376041006', '137604', 'Koto Panjang Dalam', 3),
	('1376051001', '137605', 'Padang Karambia', 3),
	('1376051002', '137605', 'Limo Kampuang', 3),
	('1376051003', '137605', 'Limbukan', 3),
	('1376051004', '137605', 'Koto Tuo', 3),
	('1376051005', '137605', 'Balai Panjang', 3),
	('1376051006', '137605', 'Ampangan', 3),
	('1376051007', '137605', 'Kapalo Koto', 3),
	('1376051008', '137605', 'Aur Kuniang', 3),
	('1376051009', '137605', 'Sawah Padang', 3),
	('1377011001', '137701', 'Karan Aur', 3),
	('1377011002', '137701', 'Kampung Perak', 3),
	('1377011003', '137701', 'Lohong', 3),
	('1377011004', '137701', 'Pasir', 3),
	('1377011005', '137701', 'Kampung Pondok', 3),
	('1377011006', '137701', 'Pondok II', 3),
	('1377011007', '137701', 'Kampung Jawa I', 3),
	('1377011008', '137701', 'Kampung Jawa II', 3),
	('1377011009', '137701', 'Alai Gelombang', 3),
	('1377011010', '137701', 'Jawi Jawi I', 3),
	('1377011011', '137701', 'Jawi Jawi II', 3),
	('1377011012', '137701', 'Jalan Baru', 3),
	('1377011013', '137701', 'Taratak', 3),
	('1377011014', '137701', 'Jalan Kereta Api', 3),
	('1377011015', '137701', 'Ujung Batung', 3),
	('1377011016', '137701', 'Jati Hilir', 3),
	('1377012017', '137701', 'Pauh Barat', 4),
	('1377012018', '137701', 'Pauh Timur', 4),
	('1377012019', '137701', 'Rawang', 4),
	('1377012020', '137701', 'Kampung Baru', 4),
	('1377012021', '137701', 'Cimparuh', 4),
	('1377012025', '137701', 'Jati Mudik', 4),
	('1377022005', '137702', 'Ampalu', 4),
	('1377022006', '137702', 'Apar', 4),
	('1377022007', '137702', 'Tanjung Sabar', 4),
	('1377022008', '137702', 'Cubadak Air Selatan', 4),
	('1377022009', '137702', 'Sikapak Barat', 4),
	('1377022010', '137702', 'Sikapak Timur', 4),
	('1377022011', '137702', 'Manggung', 4),
	('1377022012', '137702', 'Cubadak Air Utara', 4),
	('1377022013', '137702', 'Tungkal Selatan', 4),
	('1377022014', '137702', 'Naras Hilir', 4),
	('1377022015', '137702', 'Naras I', 4),
	('1377022016', '137702', 'Balai Naras', 4),
	('1377022017', '137702', 'Padang Birik Birik', 4),
	('1377022018', '137702', 'Sintuk', 4),
	('1377022019', '137702', 'Sungai Rambai', 4),
	('1377022020', '137702', 'Tungkal Utara', 4),
	('1377022021', '137702', 'Cubadak Air', 4),
	('1377032006', '137703', 'Pasir Sunur', 4),
	('1377032007', '137703', 'Balai Kurai Taji', 4),
	('1377032008', '137703', 'Pauh Kurai Taji', 4),
	('1377032009', '137703', 'Simpang', 4),
	('1377032010', '137703', 'Toboh Palabah', 4),
	('1377032011', '137703', 'Marabau', 4),
	('1377032012', '137703', 'Batang Tajongkek', 4),
	('1377032013', '137703', 'Sikabu', 4),
	('1377032014', '137703', 'Sungai Kasai', 4),
	('1377032015', '137703', 'Palak Aneh', 4),
	('1377032016', '137703', 'Kampung Apar', 4),
	('1377032017', '137703', 'Marunggi', 4),
	('1377032018', '137703', 'Taluk', 4),
	('1377032019', '137703', 'Padang Cakur', 4),
	('1377032020', '137703', 'Punggung Lading', 4),
	('1377032021', '137703', 'Rambai', 4),
	('1377042001', '137704', 'Talago Sarik', 4),
	('1377042002', '137704', 'Pakasai', 4),
	('1377042003', '137704', 'Kampung Baru Padusunan', 4),
	('1377042004', '137704', 'Kampung Gadang', 4),
	('1377042005', '137704', 'Koto Marapak', 4),
	('1377042006', '137704', 'Batang Kabung', 4),
	('1377042007', '137704', 'Bato', 4),
	('1377042008', '137704', 'Air Santok', 4),
	('1377042009', '137704', 'Cubadak Mentawai', 4),
	('1377042010', '137704', 'Sungai Sirah', 4),
	('1377042011', '137704', 'Sungai Pasak', 4),
	('1377042012', '137704', 'Bungo Tanjung', 4),
	('1377042013', '137704', 'Kampung Tangah', 4),
	('1377042014', '137704', 'Kampung Kandang', 4),
	('1377042015', '137704', 'Kaluat', 4),
	('1377042016', '137704', 'Kajai', 4),
	('1401011011', '140101', 'Bangkinang', 3),
	('1401011013', '140101', 'Langgini', 3),
	('1401012009', '140101', 'Kumantan', 4),
	('1401012010', '140101', 'Ridan Permai', 4),
	('1401021027', '140102', 'Air Tiris', 3),
	('1401022001', '140102', 'Batu Belah', 4),
	('1401022003', '140102', 'Tanjung Berulak', 4),
	('1401022006', '140102', 'Ranah', 4),
	('1401022007', '140102', 'Penyasawan', 4),
	('1401022008', '140102', 'Rumbio', 4),
	('1401022013', '140102', 'Padang Mutung', 4),
	('1401022023', '140102', 'Pulau Jambu', 4),
	('1401022024', '140102', 'Tj. Rambutan', 4),
	('1401022025', '140102', 'Simpang Kubu', 4),
	('1401022028', '140102', 'Limau Manis', 4),
	('1401022030', '140102', 'Naumbai', 4),
	('1401022031', '140102', 'Pulautinggi', 4),
	('1401022032', '140102', 'Ranah Baru', 4),
	('1401022033', '140102', 'Bukitranah', 4),
	('1401022034', '140102', 'Pulausarak', 4),
	('1401022035', '140102', 'Koto Tibun', 4),
	('1401022036', '140102', 'Ranah Singkuang', 4),
	('1401032001', '140103', 'Tambang', 4),
	('1401032002', '140103', 'Kuapan', 4),
	('1401032003', '140103', 'Gobah', 4),
	('1401032004', '140103', 'Teluk Kenidai', 4),
	('1401032005', '140103', 'Aursati', 4),
	('1401032006', '140103', 'Padang Luas', 4),
	('1401032007', '140103', 'Terantang', 4),
	('1401032008', '140103', 'Kualu', 4),
	('1401032009', '140103', 'Rimbo Panjang', 4),
	('1401032010', '140103', 'Parit Baru', 4),
	('1401032011', '140103', 'Kemang Indah', 4),
	('1401032012', '140103', 'Kualu Nenas', 4),
	('1401032013', '140103', 'Tarai bangun', 4),
	('1401032014', '140103', 'Sungai Pinang', 4),
	('1401032015', '140103', 'Balam Jaya', 4),
	('1401032016', '140103', 'Pulaupermai', 4),
	('1401032017', '140103', 'Palungraya', 4),
	('1401041018', '140104', 'Batu Bersurat', 3),
	('1401042004', '140104', 'Gunung Bungsu', 4),
	('1401042005', '140104', 'Koto Tuo', 4),
	('1401042006', '140104', 'Balung', 4),
	('1401042007', '140104', 'Muara Takus', 4),
	('1401042010', '140104', 'Pulau Gadang', 4),
	('1401042011', '140104', 'Tanjung Alai', 4),
	('1401042012', '140104', 'Ranah Sungkai', 4),
	('1401042013', '140104', 'Lubuk Agung', 4),
	('1401042014', '140104', 'Koto Mesjid', 4),
	('1401042016', '140104', 'Pongkai Istiqomah', 4),
	('1401042017', '140104', 'Binamang', 4),
	('1401042019', '140104', 'Koto Tuo Barat', 4),
	('1401052001', '140105', 'Kuok', 4),
	('1401052005', '140105', 'Merangin', 4),
	('1401052006', '140105', 'Empat Balai', 4),
	('1401052007', '140105', 'Pulau Jambu', 4),
	('1401052008', '140105', 'Silam', 4),
	('1401052010', '140105', 'Bukit Melintang', 4),
	('1401052011', '140105', 'Pulautarap', 4),
	('1401052012', '140105', 'Lereng', 4),
	('1401052013', '140105', 'Batulangka Kecil', 4),
	('1401062001', '140106', 'Pangkalan Baru', 4),
	('1401062002', '140106', 'Desa Baru', 4),
	('1401062003', '140106', 'Teratak Buluh', 4),
	('1401062005', '140106', 'Lubuk Siam', 4),
	('1401062006', '140106', 'Buluh Cina', 4),
	('1401062007', '140106', 'Buluh Nipis', 4),
	('1401062011', '140106', 'Tanah Merah', 4),
	('1401062012', '140106', 'Pandau Jaya', 4),
	('1401062013', '140106', 'Tanjung Balam', 4),
	('1401062014', '140106', 'Kapau Jaya', 4),
	('1401062015', '140106', 'Pangkalan Serik', 4),
	('1401062016', '140106', 'Kubang Jaya', 4),
	('1401071027', '140107', 'Lipat Kain', 3),
	('1401072003', '140107', 'Kuntu', 4),
	('1401072004', '140107', 'Padang Sawah', 4),
	('1401072005', '140107', 'Domo', 4),
	('1401072006', '140107', 'IV Koto Setingkai', 4),
	('1401072008', '140107', 'Teluk Paman', 4),
	('1401072013', '140107', 'Sungai Giringging', 4),
	('1401072016', '140107', 'Sungai Paku', 4),
	('1401072019', '140107', 'Muara Selayah', 4),
	('1401072020', '140107', 'Sungai Rambai', 4),
	('1401072021', '140107', 'Tanjung Harapan', 4),
	('1401072023', '140107', 'Sungai Raja', 4),
	('1401072026', '140107', 'Sungai Sarik', 4),
	('1401072028', '140107', 'Lipat Kain Utara', 4),
	('1401072029', '140107', 'Lipat Kain Selatan', 4),
	('1401072030', '140107', 'Kuntu Darussalam', 4),
	('1401072031', '140107', 'Tanjungmas', 4),
	('1401072032', '140107', 'Sungaiharapan', 4),
	('1401072033', '140107', 'Sungailiti', 4),
	('1401072034', '140107', 'Telukpaman Timur', 4),
	('1401081001', '140108', 'Sungai Pagar', 3),
	('1401082002', '140108', 'Mentulik', 4),
	('1401082003', '140108', 'Sungai Smp. Dua', 4),
	('1401082004', '140108', 'Sungai Bungo', 4),
	('1401082005', '140108', 'Rantau Kasih', 4),
	('1401082006', '140108', 'Sungai Petai', 4),
	('1401082007', '140108', 'Gading Permai', 4),
	('1401082008', '140108', 'Bangun Sari', 4),
	('1401092001', '140109', 'Gema', 4),
	('1401092002', '140109', 'Tanjung Belit', 4),
	('1401092003', '140109', 'Tanjung Belit Selatan', 4),
	('1401092004', '140109', 'Koto Lama', 4),
	('1401092005', '140109', 'Batu Sanggan', 4),
	('1401092006', '140109', 'Aur Kuning', 4),
	('1401092007', '140109', 'Ludai', 4),
	('1401092008', '140109', 'Tanjung Karang', 4),
	('1401092009', '140109', 'Batu Sasak', 4),
	('1401092010', '140109', 'Pangkalan Kapas', 4),
	('1401092011', '140109', 'Kebun Tinggi', 4),
	('1401092012', '140109', 'Tanjung Beringin', 4),
	('1401092013', '140109', 'Gajah Betalut', 4),
	('1401092014', '140109', 'Danau Sontul', 4),
	('1401092015', '140109', 'Pangkalan Serai', 4),
	('1401092016', '140109', 'Dua Sepakat', 4),
	('1401092017', '140109', 'Terusan', 4),
	('1401092018', '140109', 'Deras Tajak', 4),
	('1401092019', '140109', 'Sungai Santi', 4),
	('1401092020', '140109', 'Subayang Jaya', 4),
	('1401092021', '140109', 'Tanjung Permai', 4),
	('1401092022', '140109', 'Bukitbetung', 4),
	('1401092023', '140109', 'Muarobio', 4),
	('1401092024', '140109', 'Lubuk Bingau', 4),
	('1401102001', '140110', 'Petapahan', 4),
	('1401102002', '140110', 'Pantai Cermin', 4),
	('1401102003', '140110', 'Petahapan Jaya', 4),
	('1401102004', '140110', 'Mukti Sari', 4),
	('1401102005', '140110', 'Sungai Putih', 4),
	('1401102006', '140110', 'Indra Sakti', 4),
	('1401102007', '140110', 'Gading Sari', 4),
	('1401102008', '140110', 'Sumber Makmur', 4),
	('1401102009', '140110', 'Pancuran Gading', 4),
	('1401102010', '140110', 'Sari Galuh', 4),
	('1401102011', '140110', 'Tri Manunggal', 4),
	('1401102012', '140110', 'Air Terbit', 4),
	('1401102013', '140110', 'Tanjung Sawit', 4),
	('1401102014', '140110', 'Pagaruyung', 4),
	('1401102015', '140110', 'Sibuak', 4),
	('1401102016', '140110', 'Pelambayan', 4),
	('1401102017', '140110', 'Kenantan', 4),
	('1401102018', '140110', 'Indrapuri', 4),
	('1401102019', '140110', 'Sungai Lambu Makmur', 4),
	('1401102020', '140110', 'Muara Mahat Baru', 4),
	('1401102021', '140110', 'Karya Indah', 4),
	('1401102022', '140110', 'Kijang Rejo', 4),
	('1401102023', '140110', 'Sungai Agung', 4),
	('1401102024', '140110', 'Bencah Kelubi', 4),
	('1401102025', '140110', 'Batugajah', 4),
	('1401112001', '140111', 'Kota Garo', 4),
	('1401112002', '140111', 'Sekijang', 4),
	('1401112003', '140111', 'Beringin Lestari', 4),
	('1401112004', '140111', 'Kota Bangun', 4),
	('1401112005', '140111', 'Cinta Damai', 4),
	('1401112006', '140111', 'Suka Maju', 4),
	('1401112007', '140111', 'Kota Baru', 4),
	('1401112008', '140111', 'Tebing Lestari', 4),
	('1401112009', '140111', 'Tanah Tinggi', 4),
	('1401112010', '140111', 'Koto Aman', 4),
	('1401112011', '140111', 'Tapung Lestari', 4),
	('1401112012', '140111', 'Tapung Makmur', 4),
	('1401112013', '140111', 'Tandan Sari', 4),
	('1401112014', '140111', 'Gerbang Sari', 4),
	('1401112015', '140111', 'Kijang Jaya', 4),
	('1401112016', '140111', 'Kijang Makmur', 4),
	('1401122001', '140112', 'Sinama Nenek', 4),
	('1401122002', '140112', 'Kasikan', 4),
	('1401122003', '140112', 'Bukit Kemuning', 4),
	('1401122004', '140112', 'Danau Lancang', 4),
	('1401122005', '140112', 'Muara Intan', 4),
	('1401122006', '140112', 'Intan Jaya', 4),
	('1401122007', '140112', 'Tanah Datar', 4),
	('1401122008', '140112', 'Rimba Jaya', 4),
	('1401122009', '140112', 'Rimba Makmur', 4),
	('1401122010', '140112', 'Rimba Beringin', 4),
	('1401122011', '140112', 'Sukaramai', 4),
	('1401122012', '140112', 'Sumber Sari', 4),
	('1401122013', '140112', 'Kusau Makmur', 4),
	('1401122014', '140112', 'Talang Danto', 4),
	('1401132001', '140113', 'Salo', 4),
	('1401132002', '140113', 'Siabu', 4),
	('1401132003', '140113', 'Salo Timur', 4),
	('1401132004', '140113', 'Sepungguk', 4),
	('1401132005', '140113', 'Ganting Damai', 4),
	('1401132006', '140113', 'Ganting', 4),
	('1401142001', '140114', 'Pulau Payung', 4),
	('1401142002', '140114', 'Teratak', 4),
	('1401142003', '140114', 'Alam Panjang', 4),
	('1401142004', '140114', 'Bukit Teratai', 4),
	('1401142005', '140114', 'Batang Batindih', 4),
	('1401142006', '140114', 'Tambusai', 4),
	('1401142007', '140114', 'Simpang Petai', 4),
	('1401151007', '140115', 'Pulau', 3),
	('1401151008', '140115', 'Pasir Sialang', 3),
	('1401152001', '140115', 'Pulau Lawas', 4),
	('1401152002', '140115', 'Muara Uwai', 4),
	('1401152003', '140115', 'Laboy Jaya', 4),
	('1401152004', '140115', 'Bukit Payung', 4),
	('1401152005', '140115', 'Suka Mulya', 4),
	('1401152006', '140115', 'Bukit Sembilan', 4),
	('1401152009', '140115', 'Binuang', 4),
	('1401162001', '140116', 'Kampung Pinang', 4),
	('1401162002', '140116', 'Pantai Raja', 4),
	('1401162003', '140116', 'Hangtuah', 4),
	('1401162004', '140116', 'Sialang Kubang', 4),
	('1401162005', '140116', 'Lubuk Sakat', 4),
	('1401172001', '140117', 'Pulau Birandang', 4),
	('1401172002', '140117', 'Pulau Rambai', 4),
	('1401172003', '140117', 'Kampar', 4),
	('1401172004', '140117', 'Koto Perambahan', 4),
	('1401172005', '140117', 'Sei Putih', 4),
	('1401172006', '140117', 'Deli Makmur', 4),
	('1401172007', '140117', 'Sungaitarap', 4),
	('1401172008', '140117', 'Tanjungbungo', 4),
	('1401172009', '140117', 'Sawahbaru', 4),
	('1401182001', '140118', 'Muara Jalai', 4),
	('1401182002', '140118', 'Sawah', 4),
	('1401182003', '140118', 'Kampung Panjang', 4),
	('1401182004', '140118', 'Kayu Aro', 4),
	('1401182005', '140118', 'Sei Tonang', 4),
	('1401182006', '140118', 'Sei Jalau', 4),
	('1401182007', '140118', 'Sendayan', 4),
	('1401182008', '140118', 'Naga Beralih', 4),
	('1401192001', '140119', 'Simalinyang', 4),
	('1401192002', '140119', 'Bina Baru', 4),
	('1401192003', '140119', 'Hidup Baru', 4),
	('1401192004', '140119', 'Karya Bakti', 4),
	('1401192005', '140119', 'Lubuk Sakai', 4),
	('1401192006', '140119', 'Penghidupan', 4),
	('1401192007', '140119', 'Mayang Pongkai', 4),
	('1401192008', '140119', 'Koto Damai', 4),
	('1401192009', '140119', 'Utama Karya', 4),
	('1401192010', '140119', 'Bukit Sakai', 4),
	('1401192011', '140119', 'Mekar Jaya', 4),
	('1401202001', '140120', 'Kebun Durian', 4),
	('1401202002', '140120', 'Gunung Sahilan', 4),
	('1401202003', '140120', 'Gunung Sari', 4),
	('1401202004', '140120', 'Suka Makmur', 4),
	('1401202005', '140120', 'Subarak', 4),
	('1401202006', '140120', 'Sungailipai', 4),
	('1401202007', '140120', 'Sahilan Darussalam', 4),
	('1401202008', '140120', 'Gunungmulya', 4),
	('1401202009', '140120', 'Makmur Sejahtera', 4),
	('1401212001', '140121', 'Siberuang', 4),
	('1401212002', '140121', 'Bandur Picak', 4),
	('1401212003', '140121', 'Gunung Malelo', 4),
	('1401212004', '140121', 'Tabing', 4),
	('1401212005', '140121', 'Pongkai', 4),
	('1401212006', '140121', 'Tanjung', 4),
	('1402011004', '140201', 'Kampung Dagang', 3),
	('1402011006', '140201', 'Pasar Kota', 3),
	('1402011007', '140201', 'Kampung Besar Kota', 3),
	('1402011008', '140201', 'Sekip Hulu', 3),
	('1402011011', '140201', 'Kmp Besar Seberang', 3),
	('1402011018', '140201', 'Sekip Hilir', 3),
	('1402012001', '140201', 'Sungai Guntung Tengah', 4),
	('1402012002', '140201', 'Sungai Guntung Hilir', 4),
	('1402012003', '140201', 'Kuantan Baru', 4),
	('1402012005', '140201', 'Kampung Pulau', 4),
	('1402012009', '140201', 'Sungai Beringin', 4),
	('1402012010', '140201', 'Pasir Kemilu', 4),
	('1402012012', '140201', 'Rantau Mapesai', 4),
	('1402012013', '140201', 'Pulau Gajah', 4),
	('1402012014', '140201', 'Sungai Raya', 4),
	('1402012023', '140201', 'Rawa Bangun', 4),
	('1402021009', '140202', 'Pematang Reba', 3),
	('1402022001', '140202', 'Barangan', 4),
	('1402022002', '140202', 'Alang Kepayang', 4),
	('1402022003', '140202', 'Kota Lama', 4),
	('1402022004', '140202', 'Redang', 4),
	('1402022005', '140202', 'Pekan Heran', 4),
	('1402022006', '140202', 'Rantau Bakung', 4),
	('1402022007', '140202', 'Talang Jerinjing', 4),
	('1402022008', '140202', 'Sialang Dua Dahan', 4),
	('1402022010', '140202', 'Sungai Dawu', 4),
	('1402022011', '140202', 'Bukit Petaling', 4),
	('1402022012', '140202', 'Pematang Jaya', 4),
	('1402022013', '140202', 'Danau Baru', 4),
	('1402022014', '140202', 'Tanah Datar', 4),
	('1402022015', '140202', 'Tani Makmur', 4),
	('1402022016', '140202', 'Sungai Baung', 4),
	('1402022017', '140202', 'Danau Tiga', 4),
	('1402022018', '140202', 'Air Jernih', 4),
	('1402031019', '140203', 'Simpang Kelayang', 3),
	('1402032007', '140203', 'Pulau Sengkilo', 4),
	('1402032008', '140203', 'Kota Medan', 4),
	('1402032009', '140203', 'Simpang Kota Medan', 4),
	('1402032010', '140203', 'Polak Pisang', 4),
	('1402032018', '140203', 'Pelangko', 4),
	('1402032020', '140203', 'Teluk Sejua', 4),
	('1402032021', '140203', 'Bongkal Malang', 4),
	('1402032022', '140203', 'Dusun Tua', 4),
	('1402032024', '140203', 'Sungai Banyak Ikan', 4),
	('1402032025', '140203', 'Tanjung Beludu', 4),
	('1402032026', '140203', 'Sungai Pasir Putih', 4),
	('1402032027', '140203', 'Sungai Golang', 4),
	('1402032028', '140203', 'Pasir Beringin', 4),
	('1402032029', '140203', 'Sungai Kuning Benio', 4),
	('1402032030', '140203', 'Bukit Selanjut', 4),
	('1402032031', '140203', 'Dusun Tua Pelang', 4),
	('1402041007', '140204', 'Air Molek', 3),
	('1402041020', '140204', 'Kembang Harum', 3),
	('1402041031', '140204', 'Tanjung Gading', 3),
	('1402041032', '140204', 'Sekar Mawar', 3),
	('1402041033', '140204', 'Tanah Merah', 3),
	('1402042006', '140204', 'Petalongan', 4),
	('1402042008', '140204', 'Air Molek II', 4),
	('1402042009', '140204', 'Pasir Keranji', 4),
	('1402042016', '140204', 'Jati Rejo', 4),
	('1402042017', '140204', 'Batu Gajah', 4),
	('1402042018', '140204', 'Candi Rejo', 4),
	('1402042019', '140204', 'Lembah Dusun Gading', 4),
	('1402042030', '140204', 'Serumpun Jaya', 4),
	('1402051005', '140205', 'Peranap', 3),
	('1402051008', '140205', 'Batu Rijal Hilir', 3),
	('1402052003', '140205', 'Semelinang Tebing', 4),
	('1402052004', '140205', 'Gumanti', 4),
	('1402052007', '140205', 'Batu Rijal Hulu', 4),
	('1402052009', '140205', 'Semelinang Darat', 4),
	('1402052010', '140205', 'Pauh Peranap', 4),
	('1402052012', '140205', 'Serai Wangi', 4),
	('1402052013', '140205', 'Pandan Wangi', 4),
	('1402052017', '140205', 'Ketipopura', 4),
	('1402052019', '140205', 'Batu Rijal Barat', 4),
	('1402052020', '140205', 'Setako Raya', 4),
	('1402061001', '140206', 'Pangkalan Kasai', 3),
	('1402062002', '140206', 'Kelesa', 4),
	('1402062003', '140206', 'Beligan', 4),
	('1402062004', '140206', 'Seresam', 4),
	('1402062005', '140206', 'Paya Rumbai', 4),
	('1402062006', '140206', 'Bukit Meranti', 4),
	('1402062007', '140206', 'Buluh Rampai', 4),
	('1402062008', '140206', 'Titian Resak', 4),
	('1402062009', '140206', 'Petala Bumi', 4),
	('1402062010', '140206', 'Sibabat', 4),
	('1402062011', '140206', 'Bandar Padang', 4),
	('1402072002', '140207', 'Anak Talang', 4),
	('1402072004', '140207', 'Bukit Lingkar', 4),
	('1402072005', '140207', 'Bukit Lipai', 4),
	('1402072006', '140207', 'Kuala Gading', 4),
	('1402072007', '140207', 'Kuala Kilan', 4),
	('1402072008', '140207', 'Kerubung Jaya', 4),
	('1402072009', '140207', 'Pejangki', 4),
	('1402072010', '140207', 'Pematang Manggis', 4),
	('1402072011', '140207', 'Sipang', 4),
	('1402072012', '140207', 'Talang Bersemi', 4),
	('1402072013', '140207', 'Talang Mulya', 4),
	('1402072014', '140207', 'Punti Anai', 4),
	('1402072015', '140207', 'Petaling Jaya', 4),
	('1402072017', '140207', 'Cenaku Kecil', 4),
	('1402072018', '140207', 'Alim', 4),
	('1402072019', '140207', 'Aur Cina', 4),
	('1402072020', '140207', 'Lahai Kemuning', 4),
	('1402072021', '140207', 'Kepayang Sari', 4),
	('1402072022', '140207', 'Batu Papan', 4),
	('1402072023', '140207', 'Sanglap', 4),
	('1402082001', '140208', 'Siambul', 4),
	('1402082002', '140208', 'Rantai Langsat', 4),
	('1402082003', '140208', 'Sungai Akar', 4),
	('1402082004', '140208', 'Usul', 4),
	('1402082005', '140208', 'Seberida', 4),
	('1402082006', '140208', 'Talang Lakat', 4),
	('1402082007', '140208', 'Belimbing', 4),
	('1402082008', '140208', 'Ringin', 4),
	('1402082010', '140208', 'Penyaguan', 4),
	('1402082011', '140208', 'Danau Rambai', 4),
	('1402092001', '140209', 'Japura', 4),
	('1402092002', '140209', 'Sidomulyo', 4),
	('1402092003', '140209', 'Pasir Ringgit', 4),
	('1402092004', '140209', 'Gudang Batu', 4),
	('1402092005', '140209', 'Sungai Sagu', 4),
	('1402092006', '140209', 'Lirik Area', 4),
	('1402092007', '140209', 'Rejosari', 4),
	('1402092008', '140209', 'Lambang Sari V', 4),
	('1402092009', '140209', 'Lambang Sari IV', 4),
	('1402092010', '140209', 'Lambang Sari I, II, III', 4),
	('1402092011', '140209', 'Wonosari', 4),
	('1402092012', '140209', 'Sekolubuk Tigo', 4),
	('1402092013', '140209', 'Banjar Balam', 4),
	('1402092014', '140209', 'Redang Seko', 4),
	('1402092015', '140209', 'Sukajadi', 4),
	('1402092016', '140209', 'Mekar Sari', 4),
	('1402092017', '140209', 'Pasir Sialang Jaya', 4),
	('1402102001', '140210', 'Tambak', 4),
	('1402102002', '140210', 'Kuala Cenaku', 4),
	('1402102003', '140210', 'Pulau Gelang', 4),
	('1402102004', '140210', 'Kuala Mulya', 4),
	('1402102005', '140210', 'Tanjung Sari', 4),
	('1402102006', '140210', 'Rawa Sekip', 4),
	('1402102007', '140210', 'Rawa Asri', 4),
	('1402102008', '140210', 'Suka Jadi', 4),
	('1402102009', '140210', 'Teluk Sungkai', 4),
	('1402102010', '140210', 'Pulau Jum\'at', 4),
	('1402112001', '140211', 'Morong', 4),
	('1402112002', '140211', 'Pasir Bongkal', 4),
	('1402112003', '140211', 'Pasir Selabau', 4),
	('1402112004', '140211', 'Pasir Batu Mandi', 4),
	('1402112005', '140211', 'Pasir Kelampaian', 4),
	('1402112006', '140211', 'Kuala Lala', 4),
	('1402112007', '140211', 'Sungai Lala', 4),
	('1402112008', '140211', 'Kelawat', 4),
	('1402112009', '140211', 'Perkebunan Sei Parit', 4),
	('1402112010', '140211', 'Perkebunan Sei Lala', 4),
	('1402112011', '140211', 'Tanjung Danau', 4),
	('1402112012', '140211', 'Sungai Air Putih', 4),
	('1402122001', '140212', 'Rimpian', 4),
	('1402122002', '140212', 'Pondok Gelugur', 4),
	('1402122003', '140212', 'Lubuk Batu Tinggal', 4),
	('1402122004', '140212', 'Sei Beras Hilir', 4),
	('1402122005', '140212', 'Kulim Jaya', 4),
	('1402122006', '140212', 'Sei Beras-Beras', 4),
	('1402122007', '140212', 'Tasik Juang', 4),
	('1402122008', '140212', 'Pontian Mekar', 4),
	('1402122009', '140212', 'Air Putih', 4),
	('1402132001', '140213', 'Talang Buah Tangga', 4),
	('1402132002', '140213', 'Talang Durian Cacar', 4),
	('1402132003', '140213', 'Talang Selantai', 4),
	('1402132004', '140213', 'Talang Perigi', 4),
	('1402132005', '140213', 'Kuantan Tenang', 4),
	('1402132006', '140213', 'Kota Baru', 4),
	('1402132007', '140213', 'Rimba Seminai', 4),
	('1402132008', '140213', 'Kelayang', 4),
	('1402132009', '140213', 'Talang Gedabu', 4),
	('1402132010', '140213', 'Talang Sei Limau', 4),
	('1402132011', '140213', 'Talang Sei Parit', 4),
	('1402132012', '140213', 'Batu Sawar', 4),
	('1402132013', '140213', 'Petongan', 4),
	('1402132014', '140213', 'Lubuk Setarak', 4),
	('1402132015', '140213', 'Bukit Indah', 4),
	('1402132016', '140213', 'Talang Sungai Elok', 4),
	('1402132017', '140213', 'Talang Sungai Maju', 4),
	('1402132018', '140213', 'Kampung Bungo', 4),
	('1402132019', '140213', 'Talang Pring Jaya', 4),
	('1402142001', '140214', 'Pesajian', 4),
	('1402142002', '140214', 'Panti Kayu', 4),
	('1402142003', '140214', 'Pematang', 4),
	('1402142004', '140214', 'Selunak', 4),
	('1402142005', '140214', 'Suka Maju', 4),
	('1402142006', '140214', 'Pematang Benteng', 4),
	('1402142007', '140214', 'Secano Jaya', 4),
	('1402142008', '140214', 'Sungai Aur', 4),
	('1402142009', '140214', 'Peladangan', 4),
	('1402142010', '140214', 'Koto Tuo', 4),
	('1403011001', '140301', 'Kota Bengkalis', 3),
	('1403011002', '140301', 'Damon', 3),
	('1403011003', '140301', 'Rimba Sekampung', 3),
	('1403012004', '140301', 'Kelapapati', 4),
	('1403012005', '140301', 'Pedekik', 4),
	('1403012006', '140301', 'Pangkalan Batang', 4),
	('1403012007', '140301', 'Sebauk', 4),
	('1403012008', '140301', 'Teluklatak', 4),
	('1403012009', '140301', 'Meskom', 4),
	('1403012010', '140301', 'Senggoro', 4),
	('1403012011', '140301', 'Air Putih', 4),
	('1403012012', '140301', 'Sei Alam', 4),
	('1403012013', '140301', 'Penampi', 4),
	('1403012014', '140301', 'Temeran', 4),
	('1403012015', '140301', 'Penebal', 4),
	('1403012016', '140301', 'Pematang Duku', 4),
	('1403012017', '140301', 'Ketam Putih', 4),
	('1403012018', '140301', 'Kelemantan', 4),
	('1403012019', '140301', 'Sekodi', 4),
	('1403012020', '140301', 'Wonosari', 4),
	('1403012021', '140301', 'Kuala Alam', 4),
	('1403012022', '140301', 'Kelebuk', 4),
	('1403012023', '140301', 'Palkun', 4),
	('1403012024', '140301', 'Sungaibatang', 4),
	('1403012025', '140301', 'Prapat Tunggal', 4),
	('1403012026', '140301', 'Simpang Ayam', 4),
	('1403012027', '140301', 'Senderek', 4),
	('1403012028', '140301', 'Kelemantan Barat', 4),
	('1403012029', '140301', 'Damai', 4),
	('1403012030', '140301', 'Pangkalan Batang Barat', 4),
	('1403012031', '140301', 'Pematang Duku Timur', 4),
	('1403022001', '140302', 'Bantan Tengah', 4),
	('1403022002', '140302', 'Bantan Air', 4),
	('1403022003', '140302', 'Bantan Tua', 4),
	('1403022004', '140302', 'Telukpambang', 4),
	('1403022005', '140302', 'Selat Baru', 4),
	('1403022006', '140302', 'Teluklancar', 4),
	('1403022007', '140302', 'Kembung Luar', 4),
	('1403022008', '140302', 'Jangkang', 4),
	('1403022009', '140302', 'Muntai', 4),
	('1403022010', '140302', 'Resam Lapis', 4),
	('1403022011', '140302', 'Berancah', 4),
	('1403022012', '140302', 'Ulu Pulau', 4),
	('1403022013', '140302', 'Mentayan', 4),
	('1403022014', '140302', 'Pampang Pesisir', 4),
	('1403022015', '140302', 'Sukamaju', 4),
	('1403022016', '140302', 'Pampang Baru', 4),
	('1403022017', '140302', 'Kembung Baru', 4),
	('1403022018', '140302', 'Pasiran', 4),
	('1403022019', '140302', 'Bantan Sari', 4),
	('1403022020', '140302', 'Bantan Timur', 4),
	('1403022021', '140302', 'Telukpapal', 4),
	('1403022022', '140302', 'Muntai Barat', 4),
	('1403022023', '140302', 'Deluk', 4),
	('1403031010', '140303', 'Sungaipakning', 3),
	('1403032001', '140303', 'Sejangat', 4),
	('1403032002', '140303', 'Dompas', 4),
	('1403032003', '140303', 'Pangkalan Jambi', 4),
	('1403032004', '140303', 'Sungaiselari', 4),
	('1403032005', '140303', 'Buruk Bakul', 4),
	('1403032006', '140303', 'Bukit Batu', 4),
	('1403032007', '140303', 'Sukajadi', 4),
	('1403032008', '140303', 'Parit I Api-Api', 4),
	('1403032009', '140303', 'Temiang', 4),
	('1403032011', '140303', 'Api - Api', 4),
	('1403032012', '140303', 'Tenggayun', 4),
	('1403032013', '140303', 'Sepahat', 4),
	('1403032014', '140303', 'Bukitkerikil', 4),
	('1403032015', '140303', 'Tanjungleban', 4),
	('1403032016', '140303', 'Batang Duku', 4),
	('1403032017', '140303', 'Pakning Asal', 4),
	('1403091001', '140309', 'Air Jamban', 3),
	('1403091002', '140309', 'Babussalam', 3),
	('1403091003', '140309', 'Batang Serosa', 3),
	('1403091004', '140309', 'Balik Alam', 3),
	('1403091006', '140309', 'Duri Barat', 3),
	('1403091007', '140309', 'Duri Timur', 3),
	('1403091008', '140309', 'Gajah Sakti', 3),
	('1403091009', '140309', 'Talang Mandi', 3),
	('1403091010', '140309', 'Pematang Pudu', 3),
	('1403092005', '140309', 'Balai Makam', 4),
	('1403092011', '140309', 'Harapan Baru', 4),
	('1403092012', '140309', 'Petani', 4),
	('1403092013', '140309', 'Sebangar', 4),
	('1403092014', '140309', 'Bumbung', 4),
	('1403092015', '140309', 'Kesumo Ampai', 4),
	('1403092016', '140309', 'Tambusai Batang Dui', 4),
	('1403092017', '140309', 'Simpang Padang', 4),
	('1403092018', '140309', 'Pematang Obo', 4),
	('1403092019', '140309', 'Air Kulim', 4),
	('1403092020', '140309', 'Buluh Manis', 4),
	('1403092021', '140309', 'Bathin Betuah', 4),
	('1403092022', '140309', 'Boncah Mahang', 4),
	('1403092023', '140309', 'Pamesi', 4),
	('1403092024', '140309', 'Bathin Sobanga', 4),
	('1403101001', '140310', 'Batu Panjang', 3),
	('1403101002', '140310', 'Pergam', 3),
	('1403101003', '140310', 'Terkul', 3),
	('1403101004', '140310', 'Tanjungkapal', 3),
	('1403102005', '140310', 'Sungaicingam', 4),
	('1403102006', '140310', 'Teluklecah', 4),
	('1403102007', '140310', 'Makeruh', 4),
	('1403102008', '140310', 'Hutan Panjang', 4),
	('1403102009', '140310', 'Pangkalan Nyirih', 4),
	('1403102010', '140310', 'Sukarjo Mesin', 4),
	('1403102011', '140310', 'Darul Aman', 4),
	('1403102012', '140310', 'Parit Kebumen', 4),
	('1403102013', '140310', 'Sri Tanjung', 4),
	('1403102014', '140310', 'Pancur Jaya', 4),
	('1403102015', '140310', 'Pangkalan Pinang', 4),
	('1403102016', '140310', 'Dungun Baru', 4),
	('1403112001', '140311', 'Tanjungmedang', 4),
	('1403112002', '140311', 'Telukrhu', 4),
	('1403112003', '140311', 'Tanjungpunak', 4),
	('1403112004', '140311', 'Kadur', 4),
	('1403112005', '140311', 'Titi Akar', 4),
	('1403112006', '140311', 'Hutan Ayu', 4),
	('1403112007', '140311', 'Suka Damai', 4),
	('1403112008', '140311', 'Puteri Sembilan', 4),
	('1403122001', '140312', 'Lubuk Muda', 4),
	('1403122002', '140312', 'Tanjungbelit', 4),
	('1403122003', '140312', 'Sungaisiput', 4),
	('1403122004', '140312', 'Sepotong', 4),
	('1403122005', '140312', 'Lubuk Gaung', 4),
	('1403122006', '140312', 'Langkat', 4),
	('1403122007', '140312', 'Sadar Jaya', 4),
	('1403122008', '140312', 'Sungailinau', 4),
	('1403122009', '140312', 'Bandar Jaya', 4),
	('1403122010', '140312', 'Muara Dua', 4),
	('1403122011', '140312', 'Tanjungdamai', 4),
	('1403122012', '140312', 'Sumber Jaya', 4),
	('1403122013', '140312', 'Lubuk Garam', 4),
	('1403122014', '140312', 'Liang Banir', 4),
	('1403122015', '140312', 'Tanjungdatuk', 4),
	('1403122016', '140312', 'Koto Raja', 4),
	('1403122017', '140312', 'Sungainibung', 4),
	('1403131001', '140313', 'Titian Antui', 3),
	('1403131012', '140313', 'Balai Raja', 3),
	('1403132002', '140313', 'Beringin', 4),
	('1403132003', '140313', 'Balai Pungut', 4),
	('1403132004', '140313', 'Melibur', 4),
	('1403132005', '140313', 'Muara Basung', 4),
	('1403132006', '140313', 'Kuala Penaso', 4),
	('1403132007', '140313', 'Pinggir', 4),
	('1403132008', '140313', 'Semunai', 4),
	('1403132009', '140313', 'Tasik Serai Timur', 4),
	('1403132010', '140313', 'Tasik Serai', 4),
	('1403132011', '140313', 'Tengganau', 4),
	('1403132013', '140313', 'Serai Wangi', 4),
	('1403132014', '140313', 'Sungaimeranti', 4),
	('1403132015', '140313', 'Pangkalan Libut', 4),
	('1403132016', '140313', 'Buluh Apo', 4),
	('1403132017', '140313', 'Tasik Serai Barat', 4),
	('1403132018', '140313', 'Tasik Tebing Serai', 4),
	('1403132019', '140313', 'Koto Pait Beringin', 4),
	('1404011001', '140401', 'Pulaukijang', 3),
	('1404011017', '140401', 'Metro', 3),
	('1404011018', '140401', 'Madani', 3),
	('1404012002', '140401', 'Sanglar', 4),
	('1404012003', '140401', 'Pulaukecil', 4),
	('1404012004', '140401', 'Sungaiterap', 4),
	('1404012009', '140401', 'Sungaiundan', 4),
	('1404012010', '140401', 'Seberang Sanglar', 4),
	('1404012011', '140401', 'Mekar Sari', 4),
	('1404012012', '140401', 'Seberang Pulau Kijang', 4),
	('1404012013', '140401', 'Sungaiasam', 4),
	('1404012014', '140401', 'Pulauruku', 4),
	('1404012019', '140401', 'Tanjunglabuh', 4),
	('1404012020', '140401', 'Sungaimahang', 4),
	('1404021001', '140402', 'Enok', 3),
	('1404021002', '140402', 'Pusaran', 3),
	('1404021003', '140402', 'Telukmedan', 3),
	('1404021013', '140402', 'Pantaiseberang Makmur', 3),
	('1404022004', '140402', 'Pengalehan', 4),
	('1404022005', '140402', 'Sungaiambat', 4),
	('1404022006', '140402', 'Simpang Tiga', 4),
	('1404022007', '140402', 'Rantau Panjang', 4),
	('1404022008', '140402', 'Sungairukam', 4),
	('1404022009', '140402', 'Bagan Jaya', 4),
	('1404022010', '140402', 'Suhada', 4),
	('1404022011', '140402', 'Jaya Bakti', 4),
	('1404022012', '140402', 'Sungailokan', 4),
	('1404022014', '140402', 'Simpang Tiga Daratan', 4),
	('1404031007', '140403', 'Sapat', 3),
	('1404032001', '140403', 'Sungaibuluh', 4),
	('1404032002', '140403', 'Tanjunglajau', 4),
	('1404032003', '140403', 'Sungaibela', 4),
	('1404032006', '140403', 'Telukdalam', 4),
	('1404032008', '140403', 'Sungaipiyai', 4),
	('1404032009', '140403', 'Perigi Raja', 4),
	('1404032010', '140403', 'Tanjungmelayu', 4),
	('1404041001', '140404', 'Tembilahan Kota', 3),
	('1404041002', '140404', 'Tembilahan Hilir', 3),
	('1404041003', '140404', 'Seberang Tembilahan', 3),
	('1404041004', '140404', 'Sungaiperak', 3),
	('1404041005', '140404', 'Sungaiberingin', 3),
	('1404041006', '140404', 'Pekan Arba', 3),
	('1404041007', '140404', 'Seberang Tembilahan Barat', 3),
	('1404041008', '140404', 'Seberang Tembilahan Selatan', 3),
	('1404051004', '140405', 'Sungaisalak', 3),
	('1404051005', '140405', 'Tempuling', 3),
	('1404051016', '140405', 'Tanjungpidada', 3),
	('1404051017', '140405', 'Pangkalan Tujuh', 3),
	('1404052002', '140405', 'Telukkiambang', 4),
	('1404052003', '140405', 'Mumpa', 4),
	('1404052007', '140405', 'Telukjira', 4),
	('1404052009', '140405', 'Karya Tunas Jaya', 4),
	('1404052011', '140405', 'Harapan Jaya', 4),
	('1404061004', '140406', 'Sungaiempat', 3),
	('1404061005', '140406', 'Telukpinang', 3),
	('1404061009', '140406', 'Tanjungharapan', 3),
	('1404062001', '140406', 'Kuala Gaung', 4),
	('1404062002', '140406', 'Telukpantaian', 4),
	('1404062003', '140406', 'Teluksungka', 4),
	('1404062006', '140406', 'Sungaiiliran', 4),
	('1404062007', '140406', 'Teluktuasan', 4),
	('1404062008', '140406', 'Rambaian', 4),
	('1404062010', '140406', 'Harapan Makmur', 4),
	('1404062011', '140406', 'Kelumpang', 4),
	('1404062012', '140406', 'Idaman', 4),
	('1404071004', '140407', 'Khairiah Mandah', 3),
	('1404072001', '140407', 'Pulaucawan', 4),
	('1404072002', '140407', 'Belaras', 4),
	('1404072003', '140407', 'Bente', 4),
	('1404072005', '140407', 'Igal', 4),
	('1404072006', '140407', 'Pelanduk', 4),
	('1404072007', '140407', 'Bakau Aceh', 4),
	('1404072008', '140407', 'Batang Tumu', 4),
	('1404072009', '140407', 'Bekawan', 4),
	('1404072010', '140407', 'Bantayan', 4),
	('1404072011', '140407', 'Batang Sari', 4),
	('1404072012', '140407', 'Bolak Raya', 4),
	('1404072013', '140407', 'Cahaya Baru', 4),
	('1404072014', '140407', 'Belaras Barat', 4),
	('1404072015', '140407', 'Sepakat Jaya', 4),
	('1404072016', '140407', 'Suraya Mandiri', 4),
	('1404072017', '140407', 'Bidari Tanjung Datuk', 4),
	('1404081001', '140408', 'Tegaraja', 3),
	('1404081009', '140408', 'Amal Bakti', 3),
	('1404081010', '140408', 'Bandar Sri Gemilang', 3),
	('1404082002', '140408', 'Kuala Selat', 4),
	('1404082003', '140408', 'Sungaisimbar', 4),
	('1404082004', '140408', 'Penjuru', 4),
	('1404082005', '140408', 'Sari Mulia', 4),
	('1404082006', '140408', 'Air Tawar', 4),
	('1404082007', '140408', 'Tanjungraja', 4),
	('1404082008', '140408', 'Sungaiteritip', 4),
	('1404082011', '140408', 'Makmur Jaya', 4),
	('1404091003', '140409', 'Kota Baru Reteh', 3),
	('1404092001', '140409', 'Pebenaan', 4),
	('1404092002', '140409', 'Seberang Pebenaan', 4),
	('1404092004', '140409', 'Nusantara Jaya', 4),
	('1404092005', '140409', 'Kota Baru Seberida', 4),
	('1404092006', '140409', 'Kembang Mekarsari', 4),
	('1404092007', '140409', 'Pasar Kembang', 4),
	('1404092008', '140409', 'Kuala Keritang', 4),
	('1404092009', '140409', 'Kuala Lemang', 4),
	('1404092010', '140409', 'Telukkelasa', 4),
	('1404092011', '140409', 'Pengalehan', 4),
	('1404092012', '140409', 'Pancur', 4),
	('1404092013', '140409', 'Sencalang', 4),
	('1404092014', '140409', 'Petalongan', 4),
	('1404092015', '140409', 'Nyiur Permai', 4),
	('1404092016', '140409', 'Lintas Utara', 4),
	('1404092017', '140409', 'Kayu Raja', 4),
	('1404101001', '140410', 'Kuala Enok', 3),
	('1404102002', '140410', 'Selatnama', 4),
	('1404102003', '140410', 'Sungainyiur', 4),
	('1404102004', '140410', 'Tanjungbaru', 4),
	('1404102005', '140410', 'Tekulai Hilir', 4),
	('1404102006', '140410', 'Tekulai Hulu', 4),
	('1404102007', '140410', 'Tekulai Bugis', 4),
	('1404102008', '140410', 'Tanjungpasir', 4),
	('1404102009', '140410', 'Tanah Merah', 4),
	('1404102010', '140410', 'Sungailaut', 4),
	('1404111001', '140411', 'Sungaipiring', 3),
	('1404112002', '140411', 'Sungailuar', 4),
	('1404112003', '140411', 'Sungaidusun', 4),
	('1404112004', '140411', 'Sungaijunjangan', 4),
	('1404112005', '140411', 'Sungairaya', 4),
	('1404112006', '140411', 'Kuala Sebatu', 4),
	('1404112007', '140411', 'Tanjungsiantar', 4),
	('1404112008', '140411', 'Sungairawa', 4),
	('1404112009', '140411', 'Sialang Jaya', 4),
	('1404112010', '140411', 'Gemilang Jaya', 4),
	('1404112011', '140411', 'Tasik Raya', 4),
	('1404112012', '140411', 'Pasir Emas', 4),
	('1404112013', '140411', 'Simpang Jaya', 4),
	('1404121006', '140412', 'Kuala Lahang', 3),
	('1404122001', '140412', 'Terusan Kempas', 4),
	('1404122002', '140412', 'Lahang Baru', 4),
	('1404122003', '140412', 'Simpang Gaung', 4),
	('1404122004', '140412', 'Belantaraya', 4),
	('1404122005', '140412', 'Sungaibaru', 4),
	('1404122007', '140412', 'Lahang Tengah', 4),
	('1404122008', '140412', 'Lahang Hulu', 4),
	('1404122009', '140412', 'Pungkat', 4),
	('1404122010', '140412', 'Jerambang', 4),
	('1404122011', '140412', 'Telukkabung', 4),
	('1404122012', '140412', 'Gembira', 4),
	('1404122013', '140412', 'Semambu Kuning', 4),
	('1404122014', '140412', 'Telukmerbau', 4),
	('1404122015', '140412', 'Soren', 4),
	('1404122016', '140412', 'Pintasan', 4),
	('1404131001', '140413', 'Tembilahan Hulu', 3),
	('1404131005', '140413', 'Tembilahan Barat', 3),
	('1404132002', '140413', 'Pekan Kamis', 4),
	('1404132003', '140413', 'Pulaupalas', 4),
	('1404132004', '140413', 'Sialang Panjang', 4),
	('1404132006', '140413', 'Sungaiintan', 4),
	('1404141001', '140414', 'Selensen', 3),
	('1404142002', '140414', 'Batu Ampar', 4),
	('1404142003', '140414', 'Keritang', 4),
	('1404142004', '140414', 'Air Balui', 4),
	('1404142005', '140414', 'Tuk Jimun', 4),
	('1404142006', '140414', 'Kemuning Tua', 4),
	('1404142007', '140414', 'Kemuning Muda', 4),
	('1404142008', '140414', 'Limau Manis', 4),
	('1404142009', '140414', 'Lubuk Besar', 4),
	('1404142010', '140414', 'Sekara', 4),
	('1404142011', '140414', 'Talang Jangkang', 4),
	('1404142012', '140414', 'Sekayan', 4),
	('1404151002', '140415', 'Pelangiran', 3),
	('1404152001', '140415', 'Rotan Semelur', 4),
	('1404152003', '140415', 'Simpang Kateman', 4),
	('1404152004', '140415', 'Tanjungsimpang', 4),
	('1404152005', '140415', 'Gaung Rejo Jaya', 4),
	('1404152006', '140415', 'Tagagiri Tama Jaya', 4),
	('1404152007', '140415', 'Pinang Jaya', 4),
	('1404152008', '140415', 'Wonosari', 4),
	('1404152009', '140415', 'Tegal Rejo', 4),
	('1404152010', '140415', 'Intan Mulia Jaya', 4),
	('1404152011', '140415', 'Saka Palas Jaya', 4),
	('1404152012', '140415', 'Catur Karya', 4),
	('1404152013', '140415', 'Bagan Jaya', 4),
	('1404152014', '140415', 'Telukbunian', 4),
	('1404152015', '140415', 'Terusan Beringin Jaya', 4),
	('1404152016', '140415', 'Hidayah', 4),
	('1404162001', '140416', 'Hibrida Mulia', 4),
	('1404162002', '140416', 'Indra Sari Jaya', 4),
	('1404162003', '140416', 'Tunggal Rahayu Jaya', 4),
	('1404162004', '140416', 'Griya Mukti Jaya', 4),
	('1404162005', '140416', 'Beringin Mulia', 4),
	('1404162006', '140416', 'Hibrida Jaya', 4),
	('1404162007', '140416', 'Sumber Jaya', 4),
	('1404162008', '140416', 'Sumber Makmur Jaya', 4),
	('1404162009', '140416', 'Sumber Sari Jaya', 4),
	('1404162010', '140416', 'Kelapa Patih Jaya', 4),
	('1404162011', '140416', 'Sapta Mulia Jaya', 4),
	('1404162012', '140416', 'Saka Rotan', 4),
	('1404162013', '140416', 'Gembaran', 4),
	('1404172001', '140417', 'Pulauburung', 4),
	('1404172002', '140417', 'Teluknibung', 4),
	('1404172003', '140417', 'Sungaidanai', 4),
	('1404172004', '140417', 'Mayang Sari Jaya', 4),
	('1404172005', '140417', 'Bukit Sari Intan Jaya', 4),
	('1404172006', '140417', 'Manunggal Jaya', 4),
	('1404172007', '140417', 'Bangun Harjo Jaya', 4),
	('1404172008', '140417', 'Beringin Jaya', 4),
	('1404172009', '140417', 'Sri Danai', 4),
	('1404172010', '140417', 'Sapta Jaya', 4),
	('1404172011', '140417', 'Kramat Jaya', 4),
	('1404172012', '140417', 'Binagun Jaya', 4),
	('1404172013', '140417', 'Suka Jaya', 4),
	('1404172014', '140417', 'Sukaharjo Jaya', 4),
	('1404172015', '140417', 'Sempadan Jaya', 4),
	('1404181001', '140418', 'Concong Luar', 3),
	('1404182002', '140418', 'Concong Dalam', 4),
	('1404182003', '140418', 'Concong Tengah', 4),
	('1404182004', '140418', 'Kampung Baru', 4),
	('1404182005', '140418', 'Panglima Raja', 4),
	('1404182006', '140418', 'Sungaiberapit', 4),
	('1404191002', '140419', 'Kempas Jaya', 3),
	('1404191007', '140419', 'Harapan Tani', 3),
	('1404192001', '140419', 'Pekan Tua', 4),
	('1404192003', '140419', 'Rumbai Jaya', 4),
	('1404192004', '140419', 'Bayas Jaya', 4),
	('1404192005', '140419', 'Sungaiara', 4),
	('1404192006', '140419', 'Sungaigantang', 4),
	('1404192008', '140419', 'Karya Tani', 4),
	('1404192009', '140419', 'Kerta jaya', 4),
	('1404192010', '140419', 'Kulim Jaya', 4),
	('1404192011', '140419', 'Danaupulai Indah', 4),
	('1404192012', '140419', 'Sungairabit', 4),
	('1404201001', '140420', 'Benteng', 3),
	('1404202002', '140420', 'Benteng Utara', 4),
	('1404202003', '140420', 'Pasenggerahan', 4),
	('1404202004', '140420', 'Kuala Sungai Batang', 4),
	('1404202005', '140420', 'Kuala Patah Arang', 4),
	('1404202006', '140420', 'Benteng Barat', 4),
	('1404202007', '140420', 'Pandan Sari', 4),
	('1404202008', '140420', 'Mugo Mulyo', 4),
	('1405011010', '140501', 'Ukui I', 3),
	('1405012001', '140501', 'Air Hitam', 4),
	('1405012002', '140501', 'Air Emas', 4),
	('1405012003', '140501', 'Bukit Gajah', 4),
	('1405012004', '140501', 'Bukit Jaya', 4),
	('1405012005', '140501', 'Kampung Baru', 4),
	('1405012006', '140501', 'Lubuk Kembang Bunga', 4),
	('1405012007', '140501', 'Lubuk Kembang Sari', 4),
	('1405012008', '140501', 'Silikuan Hulu', 4),
	('1405012009', '140501', 'Tri Mulya Jaya', 4),
	('1405012011', '140501', 'Ukui Dua', 4),
	('1405012012', '140501', 'Bagan Limau', 4),
	('1405021007', '140502', 'Pangkalan Kerinci Barat', 3),
	('1405021008', '140502', 'Pangkalan Kerinci Kota', 3),
	('1405021009', '140502', 'Pangkalan Kerinci Timur', 3),
	('1405022001', '140502', 'Mekar Jaya', 4),
	('1405022002', '140502', 'Kuala Terusan', 4),
	('1405022003', '140502', 'Makmur', 4),
	('1405022005', '140502', 'Rantau Baru', 4),
	('1405031001', '140503', 'Sorek I', 3),
	('1405032002', '140503', 'Sorek II', 4),
	('1405032003', '140503', 'Dundangan', 4),
	('1405032004', '140503', 'Palas', 4),
	('1405032005', '140503', 'Terantang Manuk', 4),
	('1405032006', '140503', 'Kemang', 4),
	('1405032007', '140503', 'Talau', 4),
	('1405032008', '140503', 'Tanjung Beringin', 4),
	('1405032009', '140503', 'Betung', 4),
	('1405032010', '140503', 'Kesuma', 4),
	('1405032011', '140503', 'Surya Indah', 4),
	('1405032012', '140503', 'Sialang Indah', 4),
	('1405032013', '140503', 'Beringin Indah', 4),
	('1405032014', '140503', 'Meranti', 4),
	('1405032015', '140503', 'Harapan Jaya', 4),
	('1405032016', '140503', 'Batang Kulim', 4),
	('1405032017', '140503', 'Sidomukti', 4),
	('1405041001', '140504', 'Pangkalan Lesung', 3),
	('1405042002', '140504', 'Dusun Tua', 4),
	('1405042003', '140504', 'Genduang', 4),
	('1405042004', '140504', 'Mayang Sari', 4),
	('1405042005', '140504', 'Rawang Sari', 4),
	('1405042006', '140504', 'Mulya Subur', 4),
	('1405042007', '140504', 'Sari Mulya', 4),
	('1405042008', '140504', 'Sari Makmur', 4),
	('1405042009', '140504', 'Tanjung Kuyo', 4),
	('1405042010', '140504', 'Pesaguan', 4),
	('1405051001', '140505', 'Langgam', 3),
	('1405052002', '140505', 'Tambak', 4),
	('1405052003', '140505', 'Penarikan', 4),
	('1405052004', '140505', 'Segati', 4),
	('1405052005', '140505', 'Sotol', 4),
	('1405052006', '140505', 'Pangkalan Gondai', 4),
	('1405052007', '140505', 'Langkan', 4),
	('1405052008', '140505', 'Padang Luas', 4),
	('1405061001', '140506', 'Pelalawan', 3),
	('1405062002', '140506', 'Sungai Ara', 4),
	('1405062003', '140506', 'Ransang', 4),
	('1405062004', '140506', 'Kuala Tolam', 4),
	('1405062005', '140506', 'Sering', 4),
	('1405062006', '140506', 'Telayap', 4),
	('1405062007', '140506', 'Batang Nilo Kecil', 4),
	('1405062008', '140506', 'Delik', 4),
	('1405062010', '140506', 'Lalang Kabung', 4),
	('1405071001', '140507', 'Kerumutan', 3),
	('1405072002', '140507', 'Pangkalan Panduk', 4),
	('1405072003', '140507', 'Pangkalan Tampui', 4),
	('1405072004', '140507', 'Bukit Lembah Subur', 4),
	('1405072005', '140507', 'Banjar Panjang', 4),
	('1405072006', '140507', 'Beringin Makmur', 4),
	('1405072007', '140507', 'Pematang Tinggi', 4),
	('1405072008', '140507', 'Tanjung Air Hitam', 4),
	('1405072009', '140507', 'Mak Teduh', 4),
	('1405072010', '140507', 'Lipai Bulan', 4),
	('1405081011', '140508', 'Pangkalan Bunut', 3),
	('1405082001', '140508', 'Petani', 4),
	('1405082002', '140508', 'Merbau', 4),
	('1405082003', '140508', 'Sungai Buluh', 4),
	('1405082008', '140508', 'Lubuk Mas', 4),
	('1405082009', '140508', 'Balam Merah', 4),
	('1405082010', '140508', 'Bagan Labah', 4),
	('1405082013', '140508', 'Lubuk Mandian Gajah', 4),
	('1405082017', '140508', 'Keriung', 4),
	('1405082018', '140508', 'Sialang Kayu Batu', 4),
	('1405091001', '140509', 'Teluk Meranti', 3),
	('1405092002', '140509', 'Kuala Panduk', 4),
	('1405092003', '140509', 'Petodaan', 4),
	('1405092004', '140509', 'Teluk Binjai', 4),
	('1405092005', '140509', 'Pulau Muda', 4),
	('1405092006', '140509', 'Gambut Mutiara', 4),
	('1405092007', '140509', 'Labuhan Bilik', 4),
	('1405092008', '140509', 'Pangkalan Terap', 4),
	('1405092009', '140509', 'Segamai', 4),
	('1405101001', '140510', 'Teluk Dalam', 3),
	('1405102002', '140510', 'Tanjung Sum', 4),
	('1405102003', '140510', 'Sungai Solok', 4),
	('1405102004', '140510', 'Sungai Upih', 4),
	('1405102005', '140510', 'Teluk', 4),
	('1405102006', '140510', 'Serapung', 4),
	('1405102007', '140510', 'Teluk Beringin', 4),
	('1405102008', '140510', 'Sokoi', 4),
	('1405102009', '140510', 'Sungai Mas', 4),
	('1405102010', '140510', 'Teluk Bakau', 4),
	('1405111001', '140511', 'Sei Kijang', 3),
	('1405112002', '140511', 'Lubuk Ogung', 4),
	('1405112003', '140511', 'Simpang Beringin', 4),
	('1405112004', '140511', 'Muda Setia', 4),
	('1405112005', '140511', 'Kiab Jaya', 4),
	('1405121002', '140512', 'Rawang Empat', 3),
	('1405122001', '140512', 'Kuala Semundam', 4),
	('1405122003', '140512', 'Tambun', 4),
	('1405122004', '140512', 'Terbangiang', 4),
	('1405122005', '140512', 'Lubuk Terap', 4),
	('1405122006', '140512', 'Angkasa', 4),
	('1405122007', '140512', 'Sialang Godang', 4),
	('1405122008', '140512', 'Lubuk Raja', 4),
	('1405122009', '140512', 'Lubuk Keranji Timur', 4),
	('1405122010', '140512', 'Airterjun', 4),
	('1405122011', '140512', 'Sialang Bungkuk', 4),
	('1406011001', '140601', 'Ujung Batu', 3),
	('1406012002', '140601', 'Suka Damai', 4),
	('1406012003', '140601', 'Ngaso', 4),
	('1406012004', '140601', 'Ujung Batu Timur', 4),
	('1406012005', '140601', 'Pematang Tebih', 4),
	('1406021001', '140602', 'Rokan', 3),
	('1406022002', '140602', 'Cipang Kanan', 4),
	('1406022003', '140602', 'Cipang Kiri Hulu', 4),
	('1406022004', '140602', 'Cipang Kiri Hilir', 4),
	('1406022006', '140602', 'Tanjung Medan', 4),
	('1406022007', '140602', 'Lubuk Bendahara Timur', 4),
	('1406022008', '140602', 'Lubuk Bendahara', 4),
	('1406022010', '140602', 'Sikebau Jaya', 4),
	('1406022013', '140602', 'Rokan Koto Ruang', 4),
	('1406022014', '140602', 'Rokan Timur', 4),
	('1406022016', '140602', 'Lubuk Betung', 4),
	('1406022017', '140602', 'Pemandang', 4),
	('1406022018', '140602', 'Alahan', 4),
	('1406022019', '140602', 'Tibawan', 4),
	('1406031001', '140603', 'Pasir Pengarayan', 3),
	('1406032002', '140603', 'Rambah Tengah Utara', 4),
	('1406032003', '140603', 'Rambah Tengah Hilir', 4),
	('1406032004', '140603', 'Rambah Tengah Hulu', 4),
	('1406032005', '140603', 'Rambah Tengah Barat', 4),
	('1406032006', '140603', 'Menaming', 4),
	('1406032007', '140603', 'Pasir Baru', 4),
	('1406032008', '140603', 'Sialang Jaya', 4),
	('1406032009', '140603', 'Tanjung Belit', 4),
	('1406032010', '140603', 'Koto Tinggi', 4),
	('1406032011', '140603', 'Suka Maju', 4),
	('1406032012', '140603', 'Pemalang Berangan', 4),
	('1406032013', '140603', 'Babussalam', 4),
	('1406032014', '140603', 'Pasir Maju', 4),
	('1406041001', '140604', 'Tambusai Tengah', 3),
	('1406042002', '140604', 'Tambusai Barat', 4),
	('1406042003', '140604', 'Tambusai Timur', 4),
	('1406042004', '140604', 'Batas', 4),
	('1406042005', '140604', 'Talikumain', 4),
	('1406042006', '140604', 'Rantau Panjang', 4),
	('1406042007', '140604', 'Sungai Kumango', 4),
	('1406042008', '140604', 'Batang Kumu', 4),
	('1406042009', '140604', 'Sialang Rindang', 4),
	('1406042010', '140604', 'Suka Maju', 4),
	('1406042011', '140604', 'Lubuk Soting', 4),
	('1406042012', '140604', 'Tingkok', 4),
	('1406051001', '140605', 'KepenuhanTengah', 3),
	('1406052003', '140605', 'Kepenuhan Barat', 4),
	('1406052004', '140605', 'Kepenuhan Hilir', 4),
	('1406052005', '140605', 'Kepenuhan Timur', 4),
	('1406052006', '140605', 'Kepenuhan Barat Sei Rokan Jaya', 4),
	('1406052007', '140605', 'Kepenuhan Raya', 4),
	('1406052008', '140605', 'Kepenuhan Baru', 4),
	('1406052009', '140605', 'Kepenuhan Barat Mulya', 4),
	('1406052010', '140605', 'Ulak Patian', 4),
	('1406052012', '140605', 'Rantau Binuang Sakti', 4),
	('1406061001', '140606', 'Kota Lama', 3),
	('1406062003', '140606', 'Kota Intan', 4),
	('1406062004', '140606', 'Muara Dilam', 4),
	('1406062008', '140606', 'Kota Raya', 4),
	('1406062009', '140606', 'Kota Baru', 4),
	('1406062010', '140606', 'Sungai Kuti', 4),
	('1406062011', '140606', 'Pasir Indah', 4),
	('1406062012', '140606', 'Pasir Luhur', 4),
	('1406062017', '140606', 'Bukit Intan Makmur', 4),
	('1406062018', '140606', 'Bagan Tujuh', 4),
	('1406072001', '140607', 'Rambah Samo', 4),
	('1406072002', '140607', 'Rambah Samo Barat', 4),
	('1406072003', '140607', 'Rambah Baru', 4),
	('1406072004', '140607', 'Rambah Utama', 4),
	('1406072005', '140607', 'Pasir Makmur', 4),
	('1406072006', '140607', 'Karya Mulya', 4),
	('1406072007', '140607', 'Marga Mulya', 4),
	('1406072008', '140607', 'Langkitan', 4),
	('1406072009', '140607', 'Masda Makmur', 4),
	('1406072010', '140607', 'Lubuk Napai', 4),
	('1406072011', '140607', 'Teluk Aur', 4),
	('1406072012', '140607', 'Sei Salak', 4),
	('1406072013', '140607', 'Sei Kuning', 4),
	('1406072014', '140607', 'Lubuk Bilang', 4),
	('1406082001', '140608', 'Rambah Hilir', 4),
	('1406082002', '140608', 'Rambah Hilir Tengah', 4),
	('1406082003', '140608', 'Rambah Hilir Timur', 4),
	('1406082004', '140608', 'Pasir Utama', 4),
	('1406082005', '140608', 'Pasir Jaya', 4),
	('1406082006', '140608', 'Rambah Muda', 4),
	('1406082007', '140608', 'Sungai Sitolang', 4),
	('1406082008', '140608', 'Lubuk Kerapat', 4),
	('1406082009', '140608', 'Rambah', 4),
	('1406082010', '140608', 'Serambau Indah', 4),
	('1406082011', '140608', 'Sungai Dua Indah', 4),
	('1406082012', '140608', 'Muara Musu', 4),
	('1406082013', '140608', 'Sejati', 4),
	('1406092001', '140609', 'Tambusai Utara', 4),
	('1406092002', '140609', 'Mahato', 4),
	('1406092003', '140609', 'Bangun Jaya', 4),
	('1406092004', '140609', 'Simpang Harapan', 4),
	('1406092005', '140609', 'Pagar Mayang', 4),
	('1406092006', '140609', 'Payung Sekaki', 4),
	('1406092007', '140609', 'Mekar Jaya', 4),
	('1406092008', '140609', 'Tanjung Medan', 4),
	('1406092009', '140609', 'Suka Damai', 4),
	('1406092010', '140609', 'Rantau Sakti', 4),
	('1406092011', '140609', 'Mahato Sakti', 4),
	('1406102001', '140610', 'Pasir Agung', 4),
	('1406102002', '140610', 'Pasir Intan', 4),
	('1406102003', '140610', 'Rambah Jaya', 4),
	('1406102004', '140610', 'Bangun Purba', 4),
	('1406102005', '140610', 'Bangun Purba Timur Jaya', 4),
	('1406102006', '140610', 'Bangun Purba Barat', 4),
	('1406102007', '140610', 'Tangun', 4),
	('1406112001', '140611', 'Tandun', 4),
	('1406112002', '140611', 'Kumain', 4),
	('1406112003', '140611', 'Bona Tapung', 4),
	('1406112004', '140611', 'Dayo', 4),
	('1406112005', '140611', 'Tapung Jaya', 4),
	('1406112006', '140611', 'Puo Raya', 4),
	('1406112007', '140611', 'Sei Kuning', 4),
	('1406112008', '140611', 'Koto Tandun', 4),
	('1406112009', '140611', 'Tandun Barat', 4),
	('1406122001', '140612', 'Kabun', 4),
	('1406122002', '140612', 'Aliantan', 4),
	('1406122003', '140612', 'Kota Ranah', 4),
	('1406122004', '140612', 'Boncah Kesuma', 4),
	('1406122005', '140612', 'Batu Langkah Besar', 4),
	('1406122006', '140612', 'Giti', 4),
	('1406132001', '140613', 'Teluk Sono', 4),
	('1406132002', '140613', 'Sontang', 4),
	('1406132003', '140613', 'Bonai', 4),
	('1406132004', '140613', 'Rawa Makmur', 4),
	('1406132005', '140613', 'Pauh', 4),
	('1406132006', '140613', 'Kasang Padang', 4),
	('1406132007', '140613', 'Kasang Mungai', 4),
	('1406142001', '140614', 'Pagaran Tapah', 4),
	('1406142002', '140614', 'Kembang Damai', 4),
	('1406142005', '140614', 'Sangkir Indah', 4),
	('1406152001', '140615', 'Kepenuhan Hulu', 4),
	('1406152002', '140615', 'Pekan Tebih', 4),
	('1406152003', '140615', 'Kepayang', 4),
	('1406152004', '140615', 'Muara Jaya', 4),
	('1406152005', '140615', 'Kepenuhan Jaya', 4),
	('1406162001', '140616', 'Pendalian', 4),
	('1406162002', '140616', 'Bengkolan Salak', 4),
	('1406162003', '140616', 'Suligi', 4),
	('1406162004', '140616', 'Air Panas', 4),
	('1406162005', '140616', 'Sei Kandis', 4),
	('1407011010', '140701', 'Telukmerbau', 3),
	('1407012002', '140701', 'Tanjungleban', 4),
	('1407012003', '140701', 'Sungaikubu', 4),
	('1407012004', '140701', 'Rantau Panjang Kanan', 4),
	('1407012012', '140701', 'Telukpiyai', 4),
	('1407012013', '140701', 'Sungaisegajah', 4),
	('1407012015', '140701', 'Sei Segajah Makmur', 4),
	('1407012020', '140701', 'Telukpiyai Pesisir', 4),
	('1407012021', '140701', 'Sungaikubu Hulu', 4),
	('1407012022', '140701', 'Sungaisegajah Jaya', 4),
	('1407021011', '140702', 'Bagan Punak', 3),
	('1407021012', '140702', 'Bagan Kota', 3),
	('1407021015', '140702', 'Bagan Hulu', 3),
	('1407021016', '140702', 'Bagan Barat', 3),
	('1407021017', '140702', 'Bagan Timur', 3),
	('1407022009', '140702', 'Labuhan Tangga Kecil', 4),
	('1407022010', '140702', 'Labuhan Tangga Besar', 4),
	('1407022013', '140702', 'Bagan Jawa', 4),
	('1407022014', '140702', 'Parit Aman', 4),
	('1407022019', '140702', 'Labuhan Tangga Baru', 4),
	('1407022021', '140702', 'Bagan Jawa Pesisir', 4),
	('1407022022', '140702', 'Serusa', 4),
	('1407022023', '140702', 'Labuhan Tangga Hilir', 4),
	('1407022024', '140702', 'Bagan Punak Meranti', 4),
	('1407022025', '140702', 'Bagan Punak Pesisir', 4),
	('1407031007', '140703', 'Sedinginan', 3),
	('1407031010', '140703', 'Banjar XII', 3),
	('1407031019', '140703', 'Cempedak Rahuk', 3),
	('1407032001', '140703', 'Ujung Tanjung', 4),
	('1407032002', '140703', 'Rantau Bais', 4),
	('1407032005', '140703', 'Sekeladi', 4),
	('1407032006', '140703', 'Teluk Mega', 4),
	('1407032008', '140703', 'Putat', 4),
	('1407032009', '140703', 'Sintong', 4),
	('1407032011', '140703', 'Mumugo', 4),
	('1407032012', '140703', 'Teluk Berembun', 4),
	('1407032013', '140703', 'Menggala Sakti', 4),
	('1407032014', '140703', 'Sekeladi Hilir', 4),
	('1407032015', '140703', 'Menggala Sempurna', 4),
	('1407032016', '140703', 'Sintong Pusaka', 4),
	('1407032017', '140703', 'Sintong Bakti', 4),
	('1407032018', '140703', 'Sintong Makmur', 4),
	('1407041001', '140704', 'Rimba Melintang', 3),
	('1407042002', '140704', 'Jumrah', 4),
	('1407042003', '140704', 'Telukpulau Hilir', 4),
	('1407042004', '140704', 'Telukpulau Hulu', 4),
	('1407042005', '140704', 'Langgadai Hulu', 4),
	('1407042006', '140704', 'Lenggadai Hilir', 4),
	('1407042007', '140704', 'Mukti Jaya', 4),
	('1407042008', '140704', 'Karya Mukti', 4),
	('1407042009', '140704', 'Harapan Jaya', 4),
	('1407042010', '140704', 'Seremban Jaya', 4),
	('1407042011', '140704', 'Pematang Botam', 4),
	('1407042012', '140704', 'Pematang Sikek', 4),
	('1407051018', '140705', 'Bagan Batu Kota', 3),
	('1407051019', '140705', 'Bahtera Makmur Kota', 3),
	('1407051020', '140705', 'Balai Jaya Kota', 3),
	('1407051021', '140705', 'Balam Sempurna Kota', 3),
	('1407051022', '140705', 'Bagan Sinembah Kota', 3),
	('1407052001', '140705', 'Bagan Sinembah', 4),
	('1407052002', '140705', 'Bagan Batu', 4),
	('1407052003', '140705', 'Bahtera Makmur', 4),
	('1407052004', '140705', 'Pasir Putih', 4),
	('1407052005', '140705', 'Balai Jaya', 4),
	('1407052006', '140705', 'Balam Sempurna', 4),
	('1407052007', '140705', 'Pelita', 4),
	('1407052008', '140705', 'Gelora', 4),
	('1407052009', '140705', 'Kencana', 4),
	('1407052010', '140705', 'Bagan Bakti', 4),
	('1407052011', '140705', 'Lubuk Jawi', 4),
	('1407052012', '140705', 'Panca Mukti', 4),
	('1407052013', '140705', 'Harapan Makmur', 4),
	('1407052014', '140705', 'Salak', 4),
	('1407052015', '140705', 'Suka Maju', 4),
	('1407052016', '140705', 'Bagan Manunggal', 4),
	('1407052017', '140705', 'Bagan Sapta Permai', 4),
	('1407052023', '140705', 'Bagan Sinembah Utara', 4),
	('1407052024', '140705', 'Bagan Sinembah Barat', 4),
	('1407052025', '140705', 'Bakti Makmur', 4),
	('1407052026', '140705', 'Makmur Jaya', 4),
	('1407052027', '140705', 'Pasir Putih Utara', 4),
	('1407052028', '140705', 'Jaya Agung', 4),
	('1407052029', '140705', 'Harapan Makmur Selatan', 4),
	('1407052030', '140705', 'Meranti Makmur', 4),
	('1407052031', '140705', 'Bhayangkara Jaya', 4),
	('1407052032', '140705', 'Pasir Putih Barat', 4),
	('1407052033', '140705', 'Bagan Sinembah Timur', 4),
	('1407052034', '140705', 'Balam Jaya', 4),
	('1407061007', '140706', 'Panipahan', 3),
	('1407062001', '140706', 'Panipahan', 4),
	('1407062002', '140706', 'Telukpulai', 4),
	('1407062003', '140706', 'Pasir Limau Kapas', 4),
	('1407062004', '140706', 'Sungaidaun', 4),
	('1407062005', '140706', 'Panipahan Darat', 4),
	('1407062006', '140706', 'Panipahan Laut', 4),
	('1407062008', '140706', 'Pulaujemur', 4),
	('1407071005', '140707', 'Sinaboi Kota', 3),
	('1407072001', '140707', 'Sinaboi', 4),
	('1407072002', '140707', 'Sei Bakau', 4),
	('1407072003', '140707', 'Raja Bejamu', 4),
	('1407072004', '140707', 'Sungai Nyamuk', 4),
	('1407072006', '140707', 'Darussalam', 4),
	('1407081010', '140708', 'Pujud Selatan', 3),
	('1407082001', '140708', 'Teluknayang', 4),
	('1407082002', '140708', 'Pujud', 4),
	('1407082003', '140708', 'Air Hitam', 4),
	('1407082004', '140708', 'Kasang Bangsawan', 4),
	('1407082005', '140708', 'Sungaipinang', 4),
	('1407082006', '140708', 'Sri Kayangan', 4),
	('1407082007', '140708', 'Tanjungmedan', 4),
	('1407082008', '140708', 'Siarang-arang', 4),
	('1407082009', '140708', 'Tanjungsari', 4),
	('1407082011', '140708', 'Suka Jadi', 4),
	('1407082012', '140708', 'Sungaitapah', 4),
	('1407082013', '140708', 'Pondok Kresek', 4),
	('1407082014', '140708', 'Perkebunan Tanjung Medan', 4),
	('1407082015', '140708', 'Pujud Utara', 4),
	('1407082016', '140708', 'Babussalam Rokan', 4),
	('1407082017', '140708', 'Perkebunan Siarang-arang', 4),
	('1407082018', '140708', 'Tanjungmedan Utara', 4),
	('1407082019', '140708', 'Tanjungmedan Barat', 4),
	('1407082020', '140708', 'Tangga Batu', 4),
	('1407082021', '140708', 'Sei Meranti', 4),
	('1407082022', '140708', 'Sei Meranti Darussalam', 4),
	('1407082023', '140708', 'Akar Belingkar', 4),
	('1407091005', '140709', 'Melayu Besar Kota', 3),
	('1407092001', '140709', 'Melayu Besar', 4),
	('1407092002', '140709', 'Melayu Tengah', 4),
	('1407092003', '140709', 'Batu Hampar', 4),
	('1407092004', '140709', 'Mesah', 4),
	('1407092006', '140709', 'Labuhan papan', 4),
	('1407101001', '140710', 'Bangko Kanan', 3),
	('1407101006', '140710', 'Bangko Kiri', 3),
	('1407102002', '140710', 'Bangko Jaya', 4),
	('1407102003', '140710', 'Bangko Sempurna', 4),
	('1407102004', '140710', 'Bangko Bakti', 4),
	('1407102005', '140710', 'Bangko Pusako', 4),
	('1407102007', '140710', 'Sei Manasib', 4),
	('1407102008', '140710', 'Teluk Bano I', 4),
	('1407102009', '140710', 'Bangko Makmur', 4),
	('1407102010', '140710', 'Pematang Damar', 4),
	('1407102011', '140710', 'Pematang Ibul', 4),
	('1407102012', '140710', 'Bangko Permata', 4),
	('1407102013', '140710', 'Bangko Mukti', 4),
	('1407102014', '140710', 'Bangko Lestari', 4),
	('1407102015', '140710', 'Bangko Balam', 4),
	('1407102016', '140710', 'Bangko Mas Raya', 4),
	('1407111001', '140711', 'Simpang Kanan', 3),
	('1407112002', '140711', 'Kota Parit', 4),
	('1407112003', '140711', 'Bagan Nibung', 4),
	('1407112004', '140711', 'Bukit Damar', 4),
	('1407112005', '140711', 'Bukit Mas', 4),
	('1407112006', '140711', 'Bukit Selamat', 4),
	('1407121004', '140712', 'Bantayan Hilir', 3),
	('1407122001', '140712', 'Bantaian', 4),
	('1407122002', '140712', 'Sungaisialang', 4),
	('1407122003', '140712', 'Bantayan Baru', 4),
	('1407122005', '140712', 'Sungaisialang Hulu', 4),
	('1407131002', '140713', 'Rantau Kopar', 3),
	('1407131003', '140713', 'Sungai Rangau', 3),
	('1407132001', '140713', 'Sekapas', 4),
	('1407132004', '140713', 'Bagan Cempedak', 4),
	('1407142001', '140714', 'Pedamaran', 4),
	('1407142002', '140714', 'Rokan Baru', 4),
	('1407142003', '140714', 'Sei Besar', 4),
	('1407142004', '140714', 'Suak Temenggung', 4),
	('1407142005', '140714', 'Telukbano II', 4),
	('1407142006', '140714', 'Pekaitan', 4),
	('1407142007', '140714', 'Suak Air Hitam', 4),
	('1407142008', '140714', 'Kubu I', 4),
	('1407142009', '140714', 'Karyo Mulyo Sari', 4),
	('1407142010', '140714', 'Rokan Baru Pesisir', 4),
	('1407152001', '140715', 'Rantau Panjang Kiri', 4),
	('1407152002', '140715', 'Teluknilap', 4),
	('1407152003', '140715', 'Sungaimajo', 4),
	('1407152004', '140715', 'Sungaipinang', 4),
	('1407152005', '140715', 'Sungaipanji-panji', 4),
	('1407152006', '140715', 'Jojol', 4),
	('1407152007', '140715', 'Pulauhalang Muka', 4),
	('1407152008', '140715', 'Pulauhalang Belakang', 4),
	('1407152009', '140715', 'Rantau Panjang Kiri Hilir', 4),
	('1407152010', '140715', 'Teluknilap Jaya', 4),
	('1407152011', '140715', 'Sungaimajo Pusako', 4),
	('1407152012', '140715', 'Pulauhalang Hulu', 4),
	('1408011001', '140801', 'Kampung Dalam', 3),
	('1408011002', '140801', 'Kampung Rempak', 3),
	('1408012003', '140801', 'Langkai', 4),
	('1408012011', '140801', 'Tumang', 4),
	('1408012012', '140801', 'Merempan Hulu', 4),
	('1408012013', '140801', 'Rawang Air Putih', 4),
	('1408012014', '140801', 'Suak Lanjut', 4),
	('1408012015', '140801', 'Buantan Besar', 4),
	('1408021001', '140802', 'Sungai Apit', 3),
	('1408022002', '140802', 'Teluk Lanus', 4),
	('1408022003', '140802', 'Tanjung Kuras', 4),
	('1408022004', '140802', 'Parit I/II', 4),
	('1408022005', '140802', 'Teluk Mesjid', 4),
	('1408022008', '140802', 'Sungai Kayu Ara', 4),
	('1408022009', '140802', 'Lalang', 4),
	('1408022010', '140802', 'Mengkapan', 4),
	('1408022011', '140802', 'Sungai Rawa', 4),
	('1408022012', '140802', 'Penyengat', 4),
	('1408022014', '140802', 'Teluk Batil', 4),
	('1408022016', '140802', 'Bungsur', 4),
	('1408022017', '140802', 'Harapan', 4),
	('1408022019', '140802', 'Kayu Ara Permai', 4),
	('1408022020', '140802', 'Rawa Mekar Jaya', 4),
	('1408031001', '140803', 'Minas Jaya', 3),
	('1408032002', '140803', 'Minas Timur', 4),
	('1408032003', '140803', 'Minas Barat', 4),
	('1408032004', '140803', 'Mandi Angin', 4),
	('1408032005', '140803', 'Rantau Bertuah', 4),
	('1408041001', '140804', 'Perawang', 3),
	('1408042002', '140804', 'Tualang', 4),
	('1408042003', '140804', 'Pinang Sebatang', 4),
	('1408042004', '140804', 'Meredan', 4),
	('1408042005', '140804', 'Pinang Sebatang Timur', 4),
	('1408042006', '140804', 'Pinang Sebatang Barat', 4),
	('1408042007', '140804', 'Meredan Barat', 4),
	('1408042008', '140804', 'Perawang Barat', 4),
	('1408042009', '140804', 'Tualang Timur', 4),
	('1408052001', '140805', 'Muara Kelantan', 4),
	('1408052002', '140805', 'Teluk Lancang', 4),
	('1408052003', '140805', 'Sungai Selodang', 4),
	('1408052004', '140805', 'Olak', 4),
	('1408052005', '140805', 'Lubuk Jering', 4),
	('1408052006', '140805', 'Muara Bungkal', 4),
	('1408052007', '140805', 'Lubuk Umbut', 4),
	('1408052008', '140805', 'Bencah Umbai', 4),
	('1408052009', '140805', 'Tasik Betung', 4),
	('1408062001', '140806', 'Dayun', 4),
	('1408062002', '140806', 'Banjar Seminai', 4),
	('1408062003', '140806', 'Teluk Merbau', 4),
	('1408062004', '140806', 'Merangkai', 4),
	('1408062005', '140806', 'Lubuk Tilam', 4),
	('1408062006', '140806', 'Berumbung Baru', 4),
	('1408062007', '140806', 'Pangkalan Makmur', 4),
	('1408062008', '140806', 'Buana Makmur', 4),
	('1408062009', '140806', 'Suka Mulya', 4),
	('1408062010', '140806', 'Sawit Permai', 4),
	('1408062011', '140806', 'Sialang Sakti', 4),
	('1408072001', '140807', 'Kerinci Kanan', 4),
	('1408072002', '140807', 'Kerinci Kiri', 4),
	('1408072003', '140807', 'Buana Bakti', 4),
	('1408072004', '140807', 'Bukit Harapan', 4),
	('1408072005', '140807', 'Kumbara Utama', 4),
	('1408072006', '140807', 'Bukit Agung', 4),
	('1408072008', '140807', 'Simpang Perak Jaya', 4),
	('1408072009', '140807', 'Buatan Baru', 4),
	('1408072010', '140807', 'Gabung Makmur', 4),
	('1408072011', '140807', 'Jati Mulya', 4),
	('1408072012', '140807', 'Seminai', 4),
	('1408072013', '140807', 'Delima Jaya', 4),
	('1408082001', '140808', 'Bunga Raya', 4),
	('1408082002', '140808', 'Jati Baru', 4),
	('1408082003', '140808', 'Jaya Pura', 4),
	('1408082011', '140808', 'Kemuning Muda', 4),
	('1408082012', '140808', 'Buantan Lestari', 4),
	('1408082013', '140808', 'Tuah Indrapura', 4),
	('1408082014', '140808', 'Langsat Permai', 4),
	('1408082015', '140808', 'Temusai', 4),
	('1408082016', '140808', 'Dayangsuri', 4),
	('1408082017', '140808', 'Suak Merambai', 4),
	('1408092001', '140809', 'Pangkalan Pisang', 4),
	('1408092002', '140809', 'Kuala Gasib', 4),
	('1408092003', '140809', 'Teluk Rimba', 4),
	('1408092004', '140809', 'Buatan I', 4),
	('1408092005', '140809', 'Buatan II', 4),
	('1408092006', '140809', 'Sengkemang', 4),
	('1408092007', '140809', 'Rantau Panjang', 4),
	('1408092008', '140809', 'Empang Pandan', 4),
	('1408092009', '140809', 'Keranji Guguh', 4),
	('1408092010', '140809', 'Sri Gemilang', 4),
	('1408092011', '140809', 'Tasik Seminai', 4),
	('1408101001', '140810', 'Simpang Belutu', 3),
	('1408101002', '140810', 'Telaga Sam-sam', 3),
	('1408101003', '140810', 'Kandis Kota', 3),
	('1408102004', '140810', 'Belutu', 4),
	('1408102005', '140810', 'Kandis', 4),
	('1408102006', '140810', 'Sam-Sam', 4),
	('1408102007', '140810', 'Bekalar', 4),
	('1408102008', '140810', 'Jambai Makmur', 4),
	('1408102009', '140810', 'Sungai Gondang', 4),
	('1408102010', '140810', 'Pencing Bekuto', 4),
	('1408102011', '140810', 'Libo Jaya', 4),
	('1408112001', '140811', 'Lubuk Dalam', 4),
	('1408112002', '140811', 'Rawang Kao', 4),
	('1408112003', '140811', 'Sri Gading', 4),
	('1408112004', '140811', 'Sialang Baru', 4),
	('1408112005', '140811', 'Sialang Palas', 4),
	('1408112006', '140811', 'Empang Baru', 4),
	('1408112007', '140811', 'Rawang Kao Barat', 4),
	('1408122001', '140812', 'Bandar Sungai', 4),
	('1408122002', '140812', 'Rempak', 4),
	('1408122003', '140812', 'Belading', 4),
	('1408122004', '140812', 'Sungai Tengah', 4),
	('1408122005', '140812', 'Laksamana', 4),
	('1408122006', '140812', 'Sabak Permai', 4),
	('1408122007', '140812', 'Bandar Pedada', 4),
	('1408122008', '140812', 'Selat Guntung', 4),
	('1408131006', '140813', 'Sungaimempura', 3),
	('1408132001', '140813', 'Kota Ringin', 4),
	('1408132002', '140813', 'Paluh', 4),
	('1408132003', '140813', 'Benteng Hilir', 4),
	('1408132004', '140813', 'Benteng Hulu', 4),
	('1408132005', '140813', 'Kampung Tengah', 4),
	('1408132007', '140813', 'Merempan Hilir', 4),
	('1408132008', '140813', 'Telukmerempan', 4),
	('1408142001', '140814', 'Sungai Berbari', 4),
	('1408142002', '140814', 'Sungai Limau', 4),
	('1408142003', '140814', 'Dosan', 4),
	('1408142004', '140814', 'Benayah', 4),
	('1408142005', '140814', 'Pebadaran', 4),
	('1408142006', '140814', 'Dusun Pusaka', 4),
	('1408142007', '140814', 'Perincit', 4),
	('1409011012', '140901', 'Pasar Lubuk Jambi', 3),
	('1409012004', '140901', 'Air Buluh', 4),
	('1409012005', '140901', 'Pantai', 4),
	('1409012007', '140901', 'Lubuk Ramo', 4),
	('1409012008', '140901', 'Seberang Cengar', 4),
	('1409012009', '140901', 'Koto Cengar', 4),
	('1409012010', '140901', 'Sangau', 4),
	('1409012011', '140901', 'Banjar Padang', 4),
	('1409012013', '140901', 'Kasang', 4),
	('1409012014', '140901', 'Koto Lubuk Jambi', 4),
	('1409012015', '140901', 'Pulaubinjai', 4),
	('1409012016', '140901', 'Seberang Pantai', 4),
	('1409012017', '140901', 'Rantau Sialang', 4),
	('1409012018', '140901', 'Luai', 4),
	('1409012019', '140901', 'Banjar Guntung', 4),
	('1409012020', '140901', 'Bukitpedusunan', 4),
	('1409012021', '140901', 'Saik', 4),
	('1409012022', '140901', 'Pebaun Hulu', 4),
	('1409012023', '140901', 'Pebaun Hilir', 4),
	('1409012024', '140901', 'Kinali', 4),
	('1409012025', '140901', 'Bukit Kauman', 4),
	('1409012026', '140901', 'Aur Duri', 4),
	('1409012027', '140901', 'Sungaimanau', 4),
	('1409012030', '140901', 'Muaro Tombang', 4),
	('1409021016', '140902', 'Pasar Teluk', 3),
	('1409021018', '140902', 'Simpang Tiga', 3),
	('1409021025', '140902', 'Sungaijering', 3),
	('1409022001', '140902', 'Bandar Alai', 4),
	('1409022002', '140902', 'Pulaukedundung', 4),
	('1409022003', '140902', 'Pulauaro', 4),
	('1409022004', '140902', 'Seberang Taluk', 4),
	('1409022005', '140902', 'Pulaubaru', 4),
	('1409022006', '140902', 'Koto Tuo', 4),
	('1409022007', '140902', 'Kopah', 4),
	('1409022008', '140902', 'Munsalo', 4),
	('1409022014', '140902', 'Sawah', 4),
	('1409022015', '140902', 'Koto Taluk', 4),
	('1409022017', '140902', 'Koto Kari', 4),
	('1409022019', '140902', 'Pintu Gobang', 4),
	('1409022020', '140902', 'Jake', 4),
	('1409022021', '140902', 'Pulaugodang Kari', 4),
	('1409022022', '140902', 'Jaya', 4),
	('1409022023', '140902', 'Beringin Taluk', 4),
	('1409022024', '140902', 'Sitorajo', 4),
	('1409022026', '140902', 'Seberang Taluk Hilir', 4),
	('1409022027', '140902', 'Titian Modang Kopah', 4),
	('1409022028', '140902', 'Pulaubanjar Kari', 4),
	('1409031003', '140903', 'Muara Lembu', 3),
	('1409032001', '140903', 'Pangkalan Indarung', 4),
	('1409032002', '140903', 'Pulaupadang', 4),
	('1409032004', '140903', 'Logas', 4),
	('1409032005', '140903', 'Kebun Lado', 4),
	('1409032006', '140903', 'Sungaikuning', 4),
	('1409032007', '140903', 'Sungaisirih', 4),
	('1409032008', '140903', 'Sungaibawang', 4),
	('1409032009', '140903', 'Air Emas', 4),
	('1409032010', '140903', 'Pasir Emas', 4),
	('1409032011', '140903', 'Petai baru', 4),
	('1409032012', '140903', 'Sungaikeranji', 4),
	('1409032013', '140903', 'Sumber Datar', 4),
	('1409032014', '140903', 'Logas Hilir', 4),
	('1409041001', '140904', 'Pasar Usang', 3),
	('1409041002', '140904', 'Pasar Baru', 3),
	('1409042003', '140904', 'Simpang Tanah Lapang', 4),
	('1409042004', '140904', 'Rawang Bonto', 4),
	('1409042005', '140904', 'Koto Tuo', 4),
	('1409042006', '140904', 'Banuaran', 4),
	('1409042007', '140904', 'Kampung Madura', 4),
	('1409042009', '140904', 'Pulaukijang', 4),
	('1409042015', '140904', 'Pulaumadinah', 4),
	('1409042016', '140904', 'Kampung Tengah', 4),
	('1409042017', '140904', 'Kampung Medan', 4),
	('1409042018', '140904', 'Kepala Pulau', 4),
	('1409042019', '140904', 'Teratak Baru', 4),
	('1409042020', '140904', 'Dusun Tuo', 4),
	('1409042028', '140904', 'Gunungmelintang', 4),
	('1409042030', '140904', 'Simpang Pulauberalo', 4),
	('1409051001', '140905', 'Pasar Cerenti', 3),
	('1409051002', '140905', 'Koto Peraku', 3),
	('1409052003', '140905', 'Kompe Berangin', 4),
	('1409052004', '140905', 'Sikakak', 4),
	('1409052005', '140905', 'Kampung Baru', 4),
	('1409052006', '140905', 'Pulaujambu', 4),
	('1409052007', '140905', 'Koto Cerenti', 4),
	('1409052008', '140905', 'Pulaubayur', 4),
	('1409052009', '140905', 'Pulaupajang Cerenti', 4),
	('1409052010', '140905', 'Pesikaian', 4),
	('1409052011', '140905', 'Telukpauh', 4),
	('1409052012', '140905', 'Tanjungmedan', 4),
	('1409052013', '140905', 'Kampung Baru Timur', 4),
	('1409061001', '140906', 'Benai', 3),
	('1409062003', '140906', 'Banjar Benai', 4),
	('1409062004', '140906', 'Talontom', 4),
	('1409062005', '140906', 'Gunungkesiangan', 4),
	('1409062006', '140906', 'Pulaukalimanting', 4),
	('1409062007', '140906', 'Banjar Lopak', 4),
	('1409062008', '140906', 'Tanjungsimandolak', 4),
	('1409062009', '140906', 'Siberakun', 4),
	('1409062010', '140906', 'Pulautongah', 4),
	('1409062011', '140906', 'Ujung Tanjung', 4),
	('1409062012', '140906', 'Pulauingu', 4),
	('1409062013', '140906', 'Simandolak', 4),
	('1409062014', '140906', 'Tebing Tinggi', 4),
	('1409062015', '140906', 'Pulaulancang', 4),
	('1409062016', '140906', 'Benai Kecil', 4),
	('1409062021', '140906', 'Koto Benai', 4),
	('1409072001', '140907', 'Pulaumungkur', 4),
	('1409072002', '140907', 'Telukberingin', 4),
	('1409072003', '140907', 'Pulaurumput', 4),
	('1409072004', '140907', 'Seberang Gunung', 4),
	('1409072005', '140907', 'Teberau Panjang', 4),
	('1409072006', '140907', 'Koto Gunung', 4),
	('1409072007', '140907', 'Gunung', 4),
	('1409072008', '140907', 'Toar', 4),
	('1409072009', '140907', 'Petapahan', 4),
	('1409072010', '140907', 'Kampung Baru', 4),
	('1409072011', '140907', 'Pisang Berebus', 4),
	('1409072012', '140907', 'Lubuk Terentang', 4),
	('1409072013', '140907', 'Siberobah', 4),
	('1409072014', '140907', 'Seberang Sungai', 4),
	('1409082001', '140908', 'Koto Baru', 4),
	('1409082002', '140908', 'Petai', 4),
	('1409082003', '140908', 'Sungaipaku', 4),
	('1409082004', '140908', 'Tanjungpauh', 4),
	('1409082005', '140908', 'Simpang Raya', 4),
	('1409082006', '140908', 'Sungaibuluh', 4),
	('1409082007', '140908', 'Suka Damai', 4),
	('1409082008', '140908', 'Sumber Jaya', 4),
	('1409082009', '140908', 'Muara Bahan', 4),
	('1409082010', '140908', 'Bukitraya', 4),
	('1409082011', '140908', 'Beringin Jaya', 4),
	('1409082012', '140908', 'Suka Maju', 4),
	('1409092001', '140909', 'Pasar Baru Pangean', 4),
	('1409092002', '140909', 'Koto Pangean', 4),
	('1409092003', '140909', 'Pulaukumpai', 4),
	('1409092004', '140909', 'Pulautongah', 4),
	('1409092005', '140909', 'Pulauderas', 4),
	('1409092006', '140909', 'Telukpauh', 4),
	('1409092007', '140909', 'Tanah Bekali', 4),
	('1409092008', '140909', 'Padang Tanggung', 4),
	('1409092009', '140909', 'Padang Kunik', 4),
	('1409092010', '140909', 'Pembatang', 4),
	('1409092011', '140909', 'Pauh Angit', 4),
	('1409092012', '140909', 'Sukaping', 4),
	('1409092013', '140909', 'Pulaurengas', 4),
	('1409092014', '140909', 'Rawang Binjai', 4),
	('1409092015', '140909', 'Sako', 4),
	('1409092016', '140909', 'Sungailangsat', 4),
	('1409092017', '140909', 'Pauh Angit Hulu', 4),
	('1409102001', '140910', 'Perhentian Luas', 4),
	('1409102002', '140910', 'Logas', 4),
	('1409102003', '140910', 'Lubuk Kebun', 4),
	('1409102004', '140910', 'Sungai Rambai', 4),
	('1409102005', '140910', 'Situgal', 4),
	('1409102006', '140910', 'Rambahan', 4),
	('1409102007', '140910', 'Teratak Rendah', 4),
	('1409102008', '140910', 'Sikijang', 4),
	('1409102009', '140910', 'Sukaraja', 4),
	('1409102010', '140910', 'Sako Margasari', 4),
	('1409102011', '140910', 'Kuantan Sako', 4),
	('1409102012', '140910', 'Hulu Teso', 4),
	('1409102013', '140910', 'Giri Sako', 4),
	('1409102014', '140910', 'Bumi Mulya', 4),
	('1409102015', '140910', 'Sidodadi', 4),
	('1409112001', '140911', 'Pasar Inuman', 4),
	('1409112002', '140911', 'Koto Inuman', 4),
	('1409112003', '140911', 'Pulaupanjang Hulu', 4),
	('1409112004', '140911', 'Pulaupanjang Hilir', 4),
	('1409112005', '140911', 'Sigaruntang', 4),
	('1409112006', '140911', 'Pulaubusuk', 4),
	('1409112007', '140911', 'Bedeng Sikuran', 4),
	('1409112008', '140911', 'Banjar Nan Tigo', 4),
	('1409112009', '140911', 'Pulausipan', 4),
	('1409112010', '140911', 'Pulaubusuk Jaya', 4),
	('1409112011', '140911', 'Seberang Pulau Busuk', 4),
	('1409112012', '140911', 'Lebuh Lurus', 4),
	('1409112013', '140911', 'Kampung Baru Koto', 4),
	('1409112014', '140911', 'Ketaping Jaya', 4),
	('1409122001', '140912', 'Lubuk Ambacang', 4),
	('1409122002', '140912', 'Sungaikelelawar', 4),
	('1409122003', '140912', 'Tanjung', 4),
	('1409122004', '140912', 'Sungaipinang', 4),
	('1409122005', '140912', 'Sungaialah', 4),
	('1409122006', '140912', 'Koto Kombu', 4),
	('1409122007', '140912', 'Sumpu', 4),
	('1409122008', '140912', 'Mudik Ulo', 4),
	('1409122009', '140912', 'Inuman', 4),
	('1409122010', '140912', 'Tanjungmedang', 4),
	('1409122011', '140912', 'Serosa', 4),
	('1409122012', '140912', 'Sampurago', 4),
	('1409132001', '140913', 'Pulaubaru', 4),
	('1409132002', '140913', 'Pulauberalo', 4),
	('1409132003', '140913', 'Pulaukulur', 4),
	('1409132004', '140913', 'Pelukahan', 4),
	('1409132005', '140913', 'Pengalihan', 4),
	('1409132006', '140913', 'Lumbok', 4),
	('1409132007', '140913', 'Teratak Jering', 4),
	('1409132008', '140913', 'Tanjungpisang', 4),
	('1409132009', '140913', 'Danau', 4),
	('1409132010', '140913', 'Kasang Limau Sundai', 4),
	('1409132011', '140913', 'Koto Rajo', 4),
	('1409132012', '140913', 'Tanjung', 4),
	('1409132013', '140913', 'Sungaisorik', 4),
	('1409132014', '140913', 'Rawang Oguang', 4),
	('1409141015', '140914', 'Beringin Jaya', 3),
	('1409142001', '140914', 'Pulaukomang Sentajo', 4),
	('1409142002', '140914', 'Muaro Sentajo', 4),
	('1409142003', '140914', 'Koto Sentajo', 4),
	('1409142004', '140914', 'Kampung Baru Sentajo', 4),
	('1409142005', '140914', 'Pulaukopung Sentajo', 4),
	('1409142006', '140914', 'Teratak Air Hitam', 4),
	('1409142007', '140914', 'Seberang Teratak Air Hitam', 4),
	('1409142008', '140914', 'Parit Teratak Air Hitam', 4),
	('1409142009', '140914', 'Jalur Patah', 4),
	('1409142010', '140914', 'Geringing Baru', 4),
	('1409142011', '140914', 'Marsawa', 4),
	('1409142012', '140914', 'Langsat Hulu', 4),
	('1409142013', '140914', 'Muara Langsat', 4),
	('1409142014', '140914', 'Geringging Jaya', 4),
	('1409152001', '140915', 'Perhentian Sungkai', 4),
	('1409152002', '140915', 'Ibul', 4),
	('1409152003', '140915', 'Muarapetai', 4),
	('1409152004', '140915', 'Pangkalan', 4),
	('1409152005', '140915', 'Sungaibesar', 4),
	('1409152006', '140915', 'Setiang', 4),
	('1409152007', '140915', 'Muaro Tiu Makmur', 4),
	('1409152008', '140915', 'Muaratobek', 4),
	('1409152009', '140915', 'Sungaibesar Hilir', 4),
	('1409152010', '140915', 'Kampung Baru Ibul', 4),
	('1410011001', '141001', 'Selatpanjang Kota', 3),
	('1410011002', '141001', 'Selatpanjang Barat', 3),
	('1410011003', '141001', 'Selatpanjang Selatan', 3),
	('1410011004', '141001', 'Selatpanjang Timur', 3),
	('1410012005', '141001', 'Banglas', 4),
	('1410012006', '141001', 'Alah Air', 4),
	('1410012007', '141001', 'Alah Air Timur', 4),
	('1410012008', '141001', 'Sesap', 4),
	('1410012016', '141001', 'Banglas Barat', 4),
	('1410022001', '141002', 'Segomeng', 4),
	('1410022002', '141002', 'Bantar', 4),
	('1410022003', '141002', 'Anak Setatah', 4),
	('1410022004', '141002', 'Lemang', 4),
	('1410022005', '141002', 'Bokor', 4),
	('1410022006', '141002', 'Sungai Cina', 4),
	('1410022007', '141002', 'Melai', 4),
	('1410022011', '141002', 'Telaga Baru', 4),
	('1410022012', '141002', 'Bina Maju', 4),
	('1410022015', '141002', 'Sialang Pasung', 4),
	('1410022016', '141002', 'Permai', 4),
	('1410022017', '141002', 'Mekar Baru', 4),
	('1410032001', '141003', 'Tanjung Samak', 4),
	('1410032002', '141003', 'Tanjung Medang', 4),
	('1410032004', '141003', 'Gemala Sari', 4),
	('1410032007', '141003', 'Topang', 4),
	('1410032008', '141003', 'Penyagun', 4),
	('1410032010', '141003', 'Repan', 4),
	('1410032011', '141003', 'Tanjung Bakau', 4),
	('1410032012', '141003', 'Teluk Samak', 4),
	('1410032013', '141003', 'Sungai Gayung Kiri', 4),
	('1410032014', '141003', 'Citra Damai', 4),
	('1410032016', '141003', 'Dwi Tunggal', 4),
	('1410032017', '141003', 'Wonosari', 4),
	('1410032018', '141003', 'Tebun', 4),
	('1410032020', '141003', 'Tanjung Gemuk', 4),
	('1410042001', '141004', 'Alai', 4),
	('1410042002', '141004', 'Tenan', 4),
	('1410042003', '141004', 'Insit', 4),
	('1410042004', '141004', 'Tanjung', 4),
	('1410042005', '141004', 'Tanjung Peranap', 4),
	('1410042006', '141004', 'Kundur', 4),
	('1410042007', '141004', 'Mekong', 4),
	('1410042008', '141004', 'Batang Malas', 4),
	('1410042009', '141004', 'Mantiasa', 4),
	('1410042010', '141004', 'Gogok Darussalam', 4),
	('1410042011', '141004', 'Maini Darul Aman', 4),
	('1410042012', '141004', 'Mengkikip', 4),
	('1410042013', '141004', 'Alai Selatan', 4),
	('1410042014', '141004', 'Tanjung Darul Takzim', 4),
	('1410051001', '141005', 'Teluk Belitung', 3),
	('1410052002', '141005', 'Meranti Bunting', 4),
	('1410052003', '141005', 'Lukit', 4),
	('1410052004', '141005', 'Bagan Melibur', 4),
	('1410052018', '141005', 'Pelantai', 4),
	('1410052019', '141005', 'Tanjung Kulim', 4),
	('1410052021', '141005', 'Mekar Sari', 4),
	('1410052023', '141005', 'Mayang Sari', 4),
	('1410052026', '141005', 'Sungai Anak Kamal', 4),
	('1410052027', '141005', 'Sungai Tengah', 4),
	('1410062001', '141006', 'Kuala Merbau', 4),
	('1410062002', '141006', 'Renak Dungun', 4),
	('1410062003', '141006', 'Baran Melintang', 4),
	('1410062004', '141006', 'Teluk Ketapang', 4),
	('1410062005', '141006', 'Semukut', 4),
	('1410062006', '141006', 'Centai', 4),
	('1410062007', '141006', 'Tanjungbunga', 4),
	('1410062008', '141006', 'Batang Meranti', 4),
	('1410062009', '141006', 'Pangkalan Balai', 4),
	('1410062010', '141006', 'Padang Kamal', 4),
	('1410062011', '141006', 'Ketapang Permai', 4),
	('1410072001', '141007', 'Lukun', 4),
	('1410072002', '141007', 'Sungai Tohor', 4),
	('1410072003', '141007', 'Nipah Sendanu', 4),
	('1410072004', '141007', 'Tanjung Sari', 4),
	('1410072005', '141007', 'Tanjung Gadai', 4),
	('1410072006', '141007', 'Teluk Buntal', 4),
	('1410072007', '141007', 'Kepau Baru', 4),
	('1410072008', '141007', 'Sungai Tohor Barat', 4),
	('1410072009', '141007', 'Sendanu Darul Ihsan', 4),
	('1410072010', '141007', 'Batin Suir', 4),
	('1410082001', '141008', 'Tanjung Padang', 4),
	('1410082002', '141008', 'Putri Puyu', 4),
	('1410082003', '141008', 'Mekar Delima', 4),
	('1410082004', '141008', 'Dedap', 4),
	('1410082005', '141008', 'Kudap', 4),
	('1410082006', '141008', 'Bandul', 4),
	('1410082007', '141008', 'Selat Akar', 4),
	('1410082008', '141008', 'Tanjung Pisang', 4),
	('1410082009', '141008', 'Mengkopot', 4),
	('1410082010', '141008', 'Mengkirau', 4),
	('1410092001', '141009', 'Tanjung Kedabu', 4),
	('1410092002', '141009', 'Beting', 4),
	('1410092003', '141009', 'Sokop', 4),
	('1410092004', '141009', 'Telesung', 4),
	('1410092005', '141009', 'Bungur', 4),
	('1410092006', '141009', 'Tenggayun Raya', 4),
	('1410092007', '141009', 'Sendaur', 4),
	('1410092008', '141009', 'Kayu Ara', 4),
	('1410092009', '141009', 'Sonde', 4),
	('1410092010', '141009', 'Kedabu Rapat', 4),
	('1410092011', '141009', 'Tanah Merah', 4),
	('1471011002', '147101', 'Jadirejo', 3),
	('1471011003', '147101', 'Kampung Tengah', 3),
	('1471011004', '147101', 'Kampung Melayu', 3),
	('1471011005', '147101', 'Kedung Sari', 3),
	('1471011006', '147101', 'Harjosari', 3),
	('1471011007', '147101', 'Sukajadi', 3),
	('1471011008', '147101', 'Pulau Karam', 3),
	('1471021001', '147102', 'Simpang Empat', 3),
	('1471021002', '147102', 'Sumahilang', 3),
	('1471021003', '147102', 'Tanah Datar', 3),
	('1471021004', '147102', 'Kota Baru', 3),
	('1471021005', '147102', 'Sukaramai', 3),
	('1471021006', '147102', 'Kota Tinggi', 3),
	('1471031001', '147103', 'Cinta Raja', 3),
	('1471031002', '147103', 'Sukamulya', 3),
	('1471031003', '147103', 'Sukamaju', 3),
	('1471041001', '147104', 'Rintis', 3),
	('1471041002', '147104', 'Tanjung RHU', 3),
	('1471041003', '147104', 'Pesisir', 3),
	('1471041004', '147104', 'Sekip', 3),
	('1471051001', '147105', 'Padang Bulan', 3),
	('1471051002', '147105', 'Sago', 3),
	('1471051003', '147105', 'Kampung Baru', 3),
	('1471051004', '147105', 'Kampung Dalam', 3),
	('1471051005', '147105', 'Kampung Bandar', 3),
	('1471051006', '147105', 'Padang Terubuk', 3),
	('1471061003', '147106', 'Rumbai Bukit', 3),
	('1471061005', '147106', 'Muara Fajar', 3),
	('1471061006', '147106', 'Umban Sari', 3),
	('1471061008', '147106', 'Sri Meranti', 3),
	('1471061009', '147106', 'Palas', 3),
	('1471071005', '147107', 'Simpang Tiga', 3),
	('1471071006', '147107', 'Tangkerang Selatan', 3),
	('1471071008', '147107', 'Tangkerang Utara', 3),
	('1471071011', '147107', 'Tangkerang Labuai', 3),
	('1471081001', '147108', 'Simpang Baru', 3),
	('1471081006', '147108', 'Sidomulya Barat', 3),
	('1471081007', '147108', 'Tuah Karya', 3),
	('1471081008', '147108', 'Delima', 3),
	('1471091001', '147109', 'Tangkerang Barat', 3),
	('1471091002', '147109', 'Tangkerang Tengah', 3),
	('1471091003', '147109', 'Sidomulyo Timur', 3),
	('1471091004', '147109', 'Wonorejo', 3),
	('1471091005', '147109', 'Maharatu', 3),
	('1471101001', '147110', 'Kulim', 3),
	('1471101002', '147110', 'Sail', 3),
	('1471101003', '147110', 'Tangkerang Timur', 3),
	('1471101004', '147110', 'Rejo Sari', 3),
	('1471111001', '147111', 'Tampan', 3),
	('1471111002', '147111', 'Labuh Baru Timur', 3),
	('1471111003', '147111', 'Labuh Baru Barat', 3),
	('1471111004', '147111', 'Air Hitam', 3),
	('1471121001', '147112', 'Meranti Pandak', 3),
	('1471121002', '147112', 'Limbungan', 3),
	('1471121003', '147112', 'Lembah Sari', 3),
	('1471121004', '147112', 'Lembah Damai', 3),
	('1471121005', '147112', 'Tebing Tinggi Okura', 3),
	('1471121006', '147112', 'Limbungan Baru', 3),
	('1472011003', '147201', 'Pangkalan Sesai', 3),
	('1472011006', '147201', 'Purnama', 3),
	('1472011008', '147201', 'Bagan Keladi', 3),
	('1472011009', '147201', 'Simapang Tetap Darul Ichsan', 3),
	('1472021002', '147202', 'Teluk Binjai', 3),
	('1472021003', '147202', 'Tanjung Palas', 3),
	('1472021004', '147202', 'Jaya Mukti', 3),
	('1472021006', '147202', 'Buluh Kasap', 3),
	('1472021009', '147202', 'Bukit Batrem', 3),
	('1472031001', '147203', 'Bukit Nanas', 3),
	('1472031002', '147203', 'Kayu Kapur', 3),
	('1472031003', '147203', 'Gurun Panjang', 3),
	('1472031004', '147203', 'Bagan Besar', 3),
	('1472031005', '147203', 'Kampung Baru', 3),
	('1472041001', '147204', 'Lubuk Gaung', 3),
	('1472041002', '147204', 'Tanjung Penyebal', 3),
	('1472041003', '147204', 'Bangsal Aceh', 3),
	('1472041004', '147204', 'Basilam Baru', 3),
	('1472041005', '147204', 'Batu Teritip', 3),
	('1472051001', '147205', 'Teluk Makmur', 3),
	('1472051002', '147205', 'Mundam', 3),
	('1472051003', '147205', 'Guntung', 3),
	('1472051004', '147205', 'Pelintung', 3),
	('1472061001', '147206', 'Laksamana', 3),
	('1472061002', '147206', 'Rimba Sekampung', 3),
	('1472061003', '147206', 'Dumai Kota', 3),
	('1472061004', '147206', 'Bintan', 3),
	('1472061005', '147206', 'Sukajadi', 3),
	('1472071001', '147207', 'Ratu Sima', 3),
	('1472071002', '147207', 'Bukit Timah', 3),
	('1472071003', '147207', 'Mekar Sari', 3),
	('1472071004', '147207', 'Bukit Datuk', 3),
	('1472071005', '147207', 'Bumi Ayu', 3),
	('1501011004', '150101', 'Lempur Tengah', 3),
	('1501012001', '150101', 'Selam Paung', 4),
	('1501012002', '150101', 'Air Mumu', 4),
	('1501012003', '150101', 'Lempur Mudik', 4),
	('1501012005', '150101', 'Masgo', 4),
	('1501012006', '150101', 'Lempur Hilir', 4),
	('1501012011', '150101', 'Kebun Baru', 4),
	('1501012012', '150101', 'Perikan Tengah', 4),
	('1501012013', '150101', 'Dusun Baru Lempur', 4),
	('1501012016', '150101', 'Sungaihangat', 4),
	('1501012018', '150101', 'Manjunto Lempur', 4),
	('1501012019', '150101', 'Kebun Lima', 4),
	('1501022001', '150102', 'Sanggaran Agung', 4),
	('1501022002', '150102', 'Kota Baru Sanggaran Agung', 4),
	('1501022003', '150102', 'Pendung Talang Genting', 4),
	('1501022004', '150102', 'Seleman', 4),
	('1501022005', '150102', 'Tebing Tinggi', 4),
	('1501022006', '150102', 'Cupak', 4),
	('1501022007', '150102', 'Tanjungtanah', 4),
	('1501022008', '150102', 'Koto Tengah', 4),
	('1501022009', '150102', 'Koto Iman', 4),
	('1501022010', '150102', 'Ujung Pasir', 4),
	('1501022011', '150102', 'Koto Petai', 4),
	('1501022012', '150102', 'Koto Salak', 4),
	('1501022013', '150102', 'Simpang Empat', 4),
	('1501022014', '150102', 'Talang Kemulun', 4),
	('1501022015', '150102', 'Dusun Baru Tanjung Tanah', 4),
	('1501022016', '150102', 'Pasar Sore Seleman', 4),
	('1501022017', '150102', 'Koto Tuo Ujung Pasir', 4),
	('1501022018', '150102', 'Tanjungharapan', 4),
	('1501022019', '150102', 'Agung Koto Iman', 4),
	('1501042001', '150104', 'Kayu Aro Ambai', 4),
	('1501042002', '150104', 'Bunga Tanjung', 4),
	('1501042004', '150104', 'Semerah', 4),
	('1501042005', '150104', 'Sebukar', 4),
	('1501042008', '150104', 'Hiang Tinggi', 4),
	('1501042009', '150104', 'Ambai Atas', 4),
	('1501042010', '150104', 'Tanjungmudo', 4),
	('1501042011', '150104', 'Pendung Tengah', 4),
	('1501042012', '150104', 'Pendung Hilir', 4),
	('1501042013', '150104', 'Koto Baru Hiang', 4),
	('1501042014', '150104', 'Betung Kuning', 4),
	('1501042025', '150104', 'Pondok Beringin', 4),
	('1501042026', '150104', 'Ambai Bawah', 4),
	('1501042028', '150104', 'Hiang Karya', 4),
	('1501042029', '150104', 'Hiang Lestari', 4),
	('1501042030', '150104', 'Angkasa Pura', 4),
	('1501042031', '150104', 'Hiang Sakti', 4),
	('1501042032', '150104', 'Baru Semerah', 4),
	('1501042033', '150104', 'Koto Sekilan Ambai', 4),
	('1501042034', '150104', 'Penawar Tinggi', 4),
	('1501052002', '150105', 'Baru Semurup', 4),
	('1501052004', '150105', 'Koto Dua Lama', 4),
	('1501052012', '150105', 'Koto Di Air', 4),
	('1501052013', '150105', 'Pasar Semurup', 4),
	('1501052014', '150105', 'Balai', 4),
	('1501052015', '150105', 'Koto Majidin Hilir', 4),
	('1501052016', '150105', 'Pendung Hilir', 4),
	('1501052018', '150105', 'Pendung Mudik', 4),
	('1501052022', '150105', 'Air Tenang', 4),
	('1501052024', '150105', 'Muara Semerah', 4),
	('1501052029', '150105', 'Koto Majidin Mudik', 4),
	('1501052035', '150105', 'Muara Semerah Mudik', 4),
	('1501052036', '150105', 'Sawahan Koto Majidin', 4),
	('1501052037', '150105', 'Sawahan Jaya', 4),
	('1501052038', '150105', 'Koto Majidin Di Air', 4),
	('1501052039', '150105', 'Pendung Tengah', 4),
	('1501061009', '150106', 'Siulak Deras', 3),
	('1501062010', '150106', 'Sungaibetung Hilir', 4),
	('1501062011', '150106', 'Sungaibatu Gantih', 4),
	('1501062012', '150106', 'Tanjunggenting', 4),
	('1501062013', '150106', 'Simpang Tutup', 4),
	('1501062014', '150106', 'Suko Pangkat', 4),
	('1501062015', '150106', 'Sungaibetung Mudik', 4),
	('1501062016', '150106', 'Danautinggi', 4),
	('1501062017', '150106', 'Sungaigelampeh', 4),
	('1501062018', '150106', 'Siulak Deras Mudik', 4),
	('1501062019', '150106', 'Siulak Tenang', 4),
	('1501062039', '150106', 'Sungai Batu Gantih Hilir', 4),
	('1501062040', '150106', 'Baru Sungai Betung Mudik', 4),
	('1501062041', '150106', 'Tanjunggenting Mudik', 4),
	('1501062042', '150106', 'Air Betung', 4),
	('1501062043', '150106', 'Ujung Ladang', 4),
	('1501072004', '150107', 'Tarutung', 4),
	('1501072006', '150107', 'Lubuk Paku', 4),
	('1501072007', '150107', 'Tamiai', 4),
	('1501072008', '150107', 'Pematang Lingkung', 4),
	('1501072009', '150107', 'Pasar Tamiai', 4),
	('1501072010', '150107', 'Seberang Merangin', 4),
	('1501072011', '150107', 'Baru Pulau Sangkar', 4),
	('1501072013', '150107', 'Batang Merangin', 4),
	('1501072014', '150107', 'Muara Hemat', 4),
	('1501082001', '150108', 'Jujun', 4),
	('1501082002', '150108', 'Talang Lindung', 4),
	('1501082003', '150108', 'Keluru', 4),
	('1501082004', '150108', 'Pidung', 4),
	('1501082005', '150108', 'Tanjungbatu', 4),
	('1501082006', '150108', 'Benik', 4),
	('1501082007', '150108', 'Kt Tuo P. Tengah', 4),
	('1501082008', '150108', 'Kt. Dian P. Tengah', 4),
	('1501082009', '150108', 'Tanjungpauh Mudik', 4),
	('1501082010', '150108', 'Tanjungpauh Hilir', 4),
	('1501082011', '150108', 'Semerap', 4),
	('1501082012', '150108', 'Lempur Danau', 4),
	('1501082013', '150108', 'Dsn. Baru P. Tengah', 4),
	('1501082014', '150108', 'Koto Baru Semerap', 4),
	('1501082015', '150108', 'Koto Patah', 4),
	('1501082016', '150108', 'Punai Merindu', 4),
	('1501082017', '150108', 'Pondok Saguang', 4),
	('1501082018', '150108', 'Telago', 4),
	('1501082019', '150108', 'Koto Agung', 4),
	('1501082020', '150108', 'Pancuran Tiga', 4),
	('1501082021', '150108', 'Permai Baru', 4),
	('1501082022', '150108', 'Pulautengah', 4),
	('1501082023', '150108', 'Koto Baru', 4),
	('1501082024', '150108', 'Pasar Semerap', 4),
	('1501082025', '150108', 'Jembatan Merah Pulau Tengah', 4),
	('1501082026', '150108', 'Limok Manaih Pulau Tengah', 4),
	('1501082027', '150108', 'Pasar Jujun', 4),
	('1501082028', '150108', 'Pancuran Bangko', 4),
	('1501082029', '150108', 'Sumur Jauh', 4),
	('1501082030', '150108', 'Koto Tengah', 4),
	('1501082031', '150108', 'Bukitpulai', 4),
	('1501082032', '150108', 'Serumpun Pauh', 4),
	('1501092010', '150109', 'Koto Tuo', 4),
	('1501092011', '150109', 'Sungaitanduk', 4),
	('1501092012', '150109', 'Kersik Tuo', 4),
	('1501092013', '150109', 'Sangir', 4),
	('1501092014', '150109', 'Koto Baru', 4),
	('1501092015', '150109', 'Koto Panjang', 4),
	('1501092016', '150109', 'Koto Tengah', 4),
	('1501092017', '150109', 'Sungaibendung Air', 4),
	('1501092022', '150109', 'Sungaisampun', 4),
	('1501092024', '150109', 'Bedeng Baru', 4),
	('1501092025', '150109', 'Batang Sangir', 4),
	('1501092030', '150109', 'Sungaidalam', 4),
	('1501092038', '150109', 'Koto Periang', 4),
	('1501092039', '150109', 'Lindung Jaya', 4),
	('1501092041', '150109', 'Renah Kasah', 4),
	('1501092042', '150109', 'Pasar Sungai Tanduk', 4),
	('1501092043', '150109', 'Mekar Sari', 4),
	('1501092045', '150109', 'Mekar Jaya', 4),
	('1501092047', '150109', 'Sangir Tengah', 4),
	('1501092048', '150109', 'Tanjungbungo', 4),
	('1501092049', '150109', 'Bendung Air Timur', 4),
	('1501112001', '150111', 'Kemantan Tinggi', 4),
	('1501112002', '150111', 'Kemantan Kebalai', 4),
	('1501112003', '150111', 'Kemantan Darat', 4),
	('1501112004', '150111', 'Sungaiabu', 4),
	('1501112005', '150111', 'Pondok Sungaiabu', 4),
	('1501112006', '150111', 'Koto Tebat', 4),
	('1501112007', '150111', 'Sungaimedang', 4),
	('1501112008', '150111', 'Air Hangat', 4),
	('1501112009', '150111', 'Baru Sungai Tutung', 4),
	('1501112010', '150111', 'Pungut Tengah', 4),
	('1501112011', '150111', 'Pungut Hilir', 4),
	('1501112012', '150111', 'Pungut Mudik', 4),
	('1501112014', '150111', 'Kemantan Hilir', 4),
	('1501112015', '150111', 'Sungaitutung', 4),
	('1501112018', '150111', 'Kemantan Agung', 4),
	('1501112019', '150111', 'Sungaideras', 4),
	('1501112020', '150111', 'Kemantan Mudik', 4),
	('1501112021', '150111', 'Simpang Empat Sungai Tutung', 4),
	('1501112022', '150111', 'Baru Sungaideras', 4),
	('1501112023', '150111', 'Taman Jernih Sungaitutung', 4),
	('1501112024', '150111', 'Baru Sungaimedang', 4),
	('1501112025', '150111', 'Kemantan Raya', 4),
	('1501112026', '150111', 'Baru Air Hangat', 4),
	('1501112027', '150111', 'Air Panas Sungaiabu', 4),
	('1501112028', '150111', 'Baru Sungaiabu', 4),
	('1501152001', '150115', 'Sungairumpun', 4),
	('1501152002', '150115', 'Sungaisikai', 4),
	('1501152003', '150115', 'Tangkil', 4),
	('1501152004', '150115', 'Pelompek', 4),
	('1501152005', '150115', 'Jernih Jaya', 4),
	('1501152006', '150115', 'Bengkolan Duo', 4),
	('1501152007', '150115', 'Lubuk Pauh', 4),
	('1501152008', '150115', 'Telun Berasap', 4),
	('1501152009', '150115', 'Bumbun Duri', 4),
	('1501152010', '150115', 'Pesisir Bukit', 4),
	('1501152011', '150115', 'Pauh Tinggi', 4),
	('1501152012', '150115', 'Sungaijernih', 4),
	('1501152013', '150115', 'Pelompek Pasar Baru', 4),
	('1501162001', '150116', 'Siulak Gedang', 4),
	('1501162004', '150116', 'Pasar Siulak Gedang', 4),
	('1501162005', '150116', 'Siulak Panjang', 4),
	('1501162006', '150116', 'Siulak Kecil Mudik', 4),
	('1501162007', '150116', 'Koto Rendah', 4),
	('1501162009', '150116', 'Lubuk Nagodang', 4),
	('1501162010', '150116', 'Sungaipegeh', 4),
	('1501162011', '150116', 'Sungailebuh', 4),
	('1501162012', '150116', 'Koto Kapeh', 4),
	('1501162013', '150116', 'Koto Beringin', 4),
	('1501162014', '150116', 'Dusun Baru', 4),
	('1501162015', '150116', 'Dusun Dalam', 4),
	('1501162016', '150116', 'Air Terjun', 4),
	('1501162019', '150116', 'Koto Aro', 4),
	('1501162021', '150116', 'Koto Lebuh Tinggi', 4),
	('1501162024', '150116', 'Siulak Kecil Hilir', 4),
	('1501162025', '150116', 'Koto Tengah', 4),
	('1501162028', '150116', 'Telago Biru', 4),
	('1501162030', '150116', 'Tutung Bungkuk', 4),
	('1501162033', '150116', 'Baru Sungaipegeh', 4),
	('1501162034', '150116', 'Bendar Sedap', 4),
	('1501162035', '150116', 'Plak Naneh', 4),
	('1501162036', '150116', 'Padang Jantung', 4),
	('1501162038', '150116', 'Pelak Gedang', 4),
	('1501162039', '150116', 'Demong Sakti', 4),
	('1501162040', '150116', 'Pasar Senen', 4),
	('1501172001', '150117', 'Belui', 4),
	('1501172002', '150117', 'Baru Kubang', 4),
	('1501172003', '150117', 'Koto Panjang', 4),
	('1501172004', '150117', 'Kubang Gedang', 4),
	('1501172005', '150117', 'Semumu', 4),
	('1501172006', '150117', 'Belui Tinggi', 4),
	('1501172007', '150117', 'Koto Tuo', 4),
	('1501172008', '150117', 'Koto Payang', 4),
	('1501172009', '150117', 'Tebat Ijuk', 4),
	('1501172010', '150117', 'Sekungkung', 4),
	('1501172011', '150117', 'Simpang Belui', 4),
	('1501172012', '150117', 'Koto Lanang', 4),
	('1501172013', '150117', 'Ladeh', 4),
	('1501172014', '150117', 'Lubuk Suli', 4),
	('1501172015', '150117', 'Kayu Aho Mangkak Koto Lanang', 4),
	('1501172016', '150117', 'Tambak Tinggi', 4),
	('1501172017', '150117', 'Kubang Agung', 4),
	('1501172018', '150117', 'Tebat Ijuk Dili', 4),
	('1501172019', '150117', 'Koto Simpai Kubang', 4),
	('1501172020', '150117', 'Pahlawan Belui', 4),
	('1501182001', '150118', 'Mukai Hilir', 4),
	('1501182002', '150118', 'Mukai Tengah', 4),
	('1501182003', '150118', 'Mukai Mudik', 4),
	('1501182004', '150118', 'Senimpik', 4),
	('1501182005', '150118', 'Tebing Tinggi', 4),
	('1501182006', '150118', 'Mukai Tinggi', 4),
	('1501182007', '150118', 'Mukai Pintu', 4),
	('1501182008', '150118', 'Sungailangkap', 4),
	('1501182009', '150118', 'Pasir Jaya', 4),
	('1501182010', '150118', 'Sungaikuning', 4),
	('1501182011', '150118', 'Mukai Seberang', 4),
	('1501182012', '150118', 'Talang Tinggi', 4),
	('1501182013', '150118', 'Lubuk Tabun', 4),
	('1501182014', '150118', 'Koto Lua', 4),
	('1501192001', '150119', 'Batu Hampar', 4),
	('1501192002', '150119', 'Sungairenah', 4),
	('1501192003', '150119', 'Bedeng Delapan', 4),
	('1501192004', '150119', 'Bedeng Dua', 4),
	('1501192005', '150119', 'Sako Duo', 4),
	('1501192006', '150119', 'Sungailintang', 4),
	('1501192007', '150119', 'Kebun Baru', 4),
	('1501192008', '150119', 'Patok Empat', 4),
	('1501192009', '150119', 'Sungaijambu', 4),
	('1501192010', '150119', 'Sungaikering', 4),
	('1501192011', '150119', 'Giri Mulyo', 4),
	('1501192012', '150119', 'Gununglabu', 4),
	('1501192013', '150119', 'Bento', 4),
	('1501192014', '150119', 'Kampung Baru', 4),
	('1501192015', '150119', 'Sungaiasam', 4),
	('1501192016', '150119', 'Pasar Minggu', 4),
	('1501192017', '150119', 'Ensatu', 4),
	('1501202001', '150120', 'Pasar Kerman', 4),
	('1501202002', '150120', 'Lolo Gedang', 4),
	('1501202003', '150120', 'Lolo Kecil', 4),
	('1501202004', '150120', 'Lolo Hilir', 4),
	('1501202005', '150120', 'Tanjung Syam', 4),
	('1501202006', '150120', 'Talang Kemuning', 4),
	('1501202007', '150120', 'Pondok', 4),
	('1501202008', '150120', 'Muak', 4),
	('1501202009', '150120', 'Pengasi Lama', 4),
	('1501202010', '150120', 'Pulaupandan', 4),
	('1501202011', '150120', 'Pulausangkar', 4),
	('1501202012', '150120', 'Bintang Marak', 4),
	('1501202013', '150120', 'Karang Pandan', 4),
	('1501202014', '150120', 'Pengasi Baru', 4),
	('1501202015', '150120', 'Muaro Lulo', 4),
	('1501212001', '150121', 'Koto Mebai', 4),
	('1501212002', '150121', 'Baru', 4),
	('1501212003', '150121', 'Air Panas', 4),
	('1501212004', '150121', 'Hamparan Pugu', 4),
	('1501212005', '150121', 'Pugu', 4),
	('1501212006', '150121', 'Koto Mudik', 4),
	('1501212007', '150121', 'Koto Tengah', 4),
	('1501212008', '150121', 'Koto Datuk', 4),
	('1501212009', '150121', 'Koto Dua Baru', 4),
	('1501212010', '150121', 'Koto Cayo', 4),
	('1501212011', '150121', 'Kecil', 4),
	('1501212012', '150121', 'Air Bersih', 4),
	('1502012001', '150201', 'Renah Kemumu', 4),
	('1502012002', '150201', 'Tanjung Kasri', 4),
	('1502012003', '150201', 'Lubuk Mentilin', 4),
	('1502012004', '150201', 'Rantau Kermas', 4),
	('1502012005', '150201', 'Renah Alai', 4),
	('1502012008', '150201', 'Pulau Tengah', 4),
	('1502012009', '150201', 'Lubuk Pungguk', 4),
	('1502012010', '150201', 'Koto Renah', 4),
	('1502012011', '150201', 'Muara Manderas', 4),
	('1502012023', '150201', 'Renah Pelaan', 4),
	('1502012024', '150201', 'Koto Rawang', 4),
	('1502021009', '150202', 'Pasar Atas', 3),
	('1502021010', '150202', 'Pasar Bangko', 3),
	('1502021011', '150202', 'Dusun Bangko', 3),
	('1502021013', '150202', 'Pematang Kandis', 3),
	('1502022004', '150202', 'Kungkai', 4),
	('1502022008', '150202', 'Mudo', 4),
	('1502022012', '150202', 'Langling', 4),
	('1502022024', '150202', 'Sungai Kapas', 4),
	('1502032004', '150203', 'Durian Rambun', 4),
	('1502032007', '150203', 'Lubuk Birah', 4),
	('1502032008', '150203', 'Lubuk Beringin', 4),
	('1502032009', '150203', 'Rantau Macang', 4),
	('1502032010', '150203', 'Peradun Temeras', 4),
	('1502032011', '150203', 'Teluk Sikumbang', 4),
	('1502032012', '150203', 'Muara Siau', 4),
	('1502032013', '150203', 'Tiaro', 4),
	('1502032015', '150203', 'Air Lago', 4),
	('1502032016', '150203', 'Badak Takurung', 4),
	('1502032017', '150203', 'Rantai Bidaro', 4),
	('1502032018', '150203', 'Rantau Panjang', 4),
	('1502032021', '150203', 'Pulau Raman', 4),
	('1502032024', '150203', 'Pasar Muara Siau', 4),
	('1502032027', '150203', 'Sepantai Renah', 4),
	('1502032028', '150203', 'Sungai Ulas', 4),
	('1502032029', '150203', 'Rantau Bayur', 4),
	('1502042007', '150204', 'Sungai Pinang', 4),
	('1502042008', '150204', 'Tiangko', 4),
	('1502042009', '150204', 'Palipan', 4),
	('1502042010', '150204', 'Seringat', 4),
	('1502042011', '150204', 'Durian Lencah', 4),
	('1502042015', '150204', 'Bukit Batu', 4),
	('1502042016', '150204', 'Sungai Nilau', 4),
	('1502042017', '150204', 'Sungai Manau', 4),
	('1502042025', '150204', 'Benteng', 4),
	('1502042026', '150204', 'Gelanggang', 4),
	('1502051002', '150205', 'Dusun Baru', 3),
	('1502051003', '150205', 'Pasar R. Panjang', 3),
	('1502051005', '150205', 'Kampung Baruh', 3),
	('1502051020', '150205', 'Mampun', 3),
	('1502051036', '150205', 'Ps.Baru Rantau', 3),
	('1502052007', '150205', 'Kandang', 4),
	('1502052008', '150205', 'Koto Rayo', 4),
	('1502052011', '150205', 'Tanjung Ilir', 4),
	('1502052014', '150205', 'Buluran Panjang', 4),
	('1502052015', '150205', 'Seling', 4),
	('1502052035', '150205', 'Lubuk Napal', 4),
	('1502061008', '150206', 'Pamenang', 3),
	('1502062004', '150206', 'Jelatang', 4),
	('1502062005', '150206', 'Tanjung Gedang', 4),
	('1502062006', '150206', 'Empang Benao', 4),
	('1502062007', '150206', 'Rejo Sari', 4),
	('1502062009', '150206', 'Keroya', 4),
	('1502062010', '150206', 'Muara Belengo', 4),
	('1502062011', '150206', 'Karang Berahi', 4),
	('1502062012', '150206', 'Pauh Menang', 4),
	('1502062013', '150206', 'Pematang Kancil', 4),
	('1502062014', '150206', 'Tanah Abang', 4),
	('1502062015', '150206', 'Sialang', 4),
	('1502062026', '150206', 'Sungai Udang', 4),
	('1502062027', '150206', 'Pelakar Jaya', 4),
	('1502072009', '150207', 'Muara Jernih', 4),
	('1502072010', '150207', 'Kapuk', 4),
	('1502072011', '150207', 'Pulau Aro', 4),
	('1502072012', '150207', 'Rantau Ngaro', 4),
	('1502072013', '150207', 'Medan Baru', 4),
	('1502072014', '150207', 'Muara Seketuk', 4),
	('1502082001', '150208', 'Sungai Sahut', 4),
	('1502082002', '150208', 'Bungo Antoi', 4),
	('1502082003', '150208', 'Muara Delang', 4),
	('1502082004', '150208', 'Sinar Gading', 4),
	('1502082005', '150208', 'Bungo Tanjung', 4),
	('1502082006', '150208', 'Rawa Jaya', 4),
	('1502082007', '150208', 'Gading Jaya', 4),
	('1502082008', '150208', 'Mekar Jaya', 4),
	('1502092001', '150209', 'Nilo Dingin', 4),
	('1502092002', '150209', 'Tanjung Beruga', 4),
	('1502092003', '150209', 'Tuo', 4),
	('1502092004', '150209', 'Koto Rami', 4),
	('1502092005', '150209', 'Rancan', 4),
	('1502092006', '150209', 'Pasar Masurai', 4),
	('1502092007', '150209', 'Rantau Jering', 4),
	('1502092008', '150209', 'Tanjung Dalam', 4),
	('1502092009', '150209', 'Muara Pangi', 4),
	('1502092010', '150209', 'Sungai Lalang', 4),
	('1502092011', '150209', 'Talang Asal', 4),
	('1502092012', '150209', 'Muara Kelukup', 4),
	('1502092013', '150209', 'Muara Lengayo', 4),
	('1502092014', '150209', 'Talang Paruh', 4),
	('1502092015', '150209', 'Durian Mukut', 4),
	('1502102001', '150210', 'Pulau Rengas', 4),
	('1502102002', '150210', 'Biuku Tanjung', 4),
	('1502102003', '150210', 'Bedeng Rejo', 4),
	('1502102004', '150210', 'Sungai Putih', 4),
	('1502102005', '150210', 'Bukit Beringin', 4),
	('1502102006', '150210', 'Pulau Rengas Ulu', 4),
	('1502112001', '150211', 'Sungai Ulak', 4),
	('1502112002', '150211', 'Aur Berduri', 4),
	('1502112003', '150211', 'Telun', 4),
	('1502112004', '150211', 'Nalo Gedang', 4),
	('1502112005', '150211', 'Baru Nalo', 4),
	('1502112006', '150211', 'Mentawak', 4),
	('1502112007', '150211', 'Danau', 4),
	('1502122001', '150212', 'Lubuk Gaung', 4),
	('1502122002', '150212', 'Salam Buku', 4),
	('1502122003', '150212', 'Pulau Baru', 4),
	('1502122004', '150212', 'Nibung', 4),
	('1502122005', '150212', 'Titian Teras', 4),
	('1502122006', '150212', 'Kedarasan Panjang', 4),
	('1502122007', '150212', 'Rantau Alai', 4),
	('1502122008', '150212', 'Tambang Besi', 4),
	('1502122009', '150212', 'Pelangki', 4),
	('1502122010', '150212', 'Pulau Layang', 4),
	('1502132001', '150213', 'Tanjung Lamin', 4),
	('1502132002', '150213', 'Limbur Merangin', 4),
	('1502132003', '150213', 'Karang Anyar', 4),
	('1502132004', '150213', 'Pinang Merah', 4),
	('1502132005', '150213', 'Simpang L. Merangin', 4),
	('1502132006', '150213', 'Mampun Baru', 4),
	('1502132007', '150213', 'Papit', 4),
	('1502132008', '150213', 'PulauTujuh', 4),
	('1502142001', '150214', 'Rantau Limau Manis', 4),
	('1502142002', '150214', 'Ulak Makam', 4),
	('1502142003', '150214', 'Air Batu', 4),
	('1502142004', '150214', 'Rejo Sari', 4),
	('1502142005', '150214', 'Kota Raja', 4),
	('1502142006', '150214', 'Tunggul Bulian', 4),
	('1502142007', '150214', 'Mekar Limau Manis', 4),
	('1502152001', '150215', 'Sungai Limau', 4),
	('1502152002', '150215', 'Sungai Bulian', 4),
	('1502152003', '150215', 'Seri Sembilan', 4),
	('1502152004', '150215', 'Bukit Subur', 4),
	('1502162001', '150216', 'Simpangmuara Panco Barat', 4),
	('1502162002', '150216', 'Talang Segegah', 4),
	('1502162003', '150216', 'Durian Batakuk', 4),
	('1502162004', '150216', 'Muara Bantan', 4),
	('1502162005', '150216', 'Parit Ujung Tanjung', 4),
	('1502162006', '150216', 'Guguk', 4),
	('1502162007', '150216', 'Markeh', 4),
	('1502162008', '150216', 'Air Batu', 4),
	('1502162009', '150216', 'Marus Jaya', 4),
	('1502162010', '150216', 'Renah Medan', 4),
	('1502162011', '150216', 'Simpang Parit', 4),
	('1502162012', '150216', 'Simpangmuaro Panco Timur', 4),
	('1502172001', '150217', 'Baru Pangkalan Jambu', 4),
	('1502172002', '150217', 'Bukit Perentak', 4),
	('1502172003', '150217', 'Birun', 4),
	('1502172004', '150217', 'Tiga Alur', 4),
	('1502172005', '150217', 'Bungo Tanjung', 4),
	('1502172006', '150217', 'Sungai Jering', 4),
	('1502172007', '150217', 'Kampung Limo', 4),
	('1502172008', '150217', 'Tanjung Mudo', 4),
	('1502182001', '150218', 'Tanjung Mudo', 4),
	('1502182002', '150218', 'Koto Teguh', 4),
	('1502182003', '150218', 'Baru', 4),
	('1502182004', '150218', 'Talang Tembago', 4),
	('1502182005', '150218', 'Beringin Tinggi', 4),
	('1502182006', '150218', 'Pematang Pauh', 4),
	('1502182007', '150218', 'Rantau Suli', 4),
	('1502182008', '150218', 'Gedang', 4),
	('1502182010', '150218', 'Koto Baru', 4),
	('1502182011', '150218', 'Tanjung Benuang', 4),
	('1502182012', '150218', 'Jangkat', 4),
	('1502182013', '150218', 'Tanjung Alam', 4),
	('1502182014', '150218', 'Kabu', 4),
	('1502182015', '150218', 'Simpang Talang Tembago', 4),
	('1502192001', '150219', 'Meranti', 4),
	('1502192002', '150219', 'Bukit Bungkul', 4),
	('1502192003', '150219', 'Rasau', 4),
	('1502192004', '150219', 'Lantak Seribu', 4),
	('1502202001', '150220', 'Tambang Emas', 4),
	('1502202002', '150220', 'Tanjung Benuang', 4),
	('1502202003', '150220', 'Pulau Bayur', 4),
	('1502202004', '150220', 'Selango', 4),
	('1502212001', '150221', 'Tanjung Rejo', 4),
	('1502212002', '150221', 'Sumber Agung', 4),
	('1502212003', '150221', 'Suko Rejo', 4),
	('1502212004', '150221', 'Sido Rukun', 4),
	('1502212005', '150221', 'Lubuk Bumbun', 4),
	('1502212006', '150221', 'Tegal Rejo', 4),
	('1502222001', '150222', 'Tambang Baru', 4),
	('1502222002', '150222', 'Sido Lego', 4),
	('1502222003', '150222', 'Mensango', 4),
	('1502222004', '150222', 'Koto Baru', 4),
	('1502222005', '150222', 'Sido Harjo', 4),
	('1502232001', '150223', 'Muara Kibul', 4),
	('1502232002', '150223', 'Tanjung Putus', 4),
	('1502232003', '150223', 'Pulau Tebakar', 4),
	('1502232004', '150223', 'Batang Kibul', 4),
	('1502232005', '150223', 'Sungai Tabir', 4),
	('1502232006', '150223', 'Telentam', 4),
	('1502232007', '150223', 'Ngaol', 4),
	('1502232008', '150223', 'Air Liki', 4),
	('1502232009', '150223', 'Pulau Lebar', 4),
	('1502232010', '150223', 'Muaro Langeh', 4),
	('1502232011', '150223', 'Tanjung Beringin', 4),
	('1502232012', '150223', 'Baru Kibul', 4),
	('1502232013', '150223', 'Ngaol Ilir', 4),
	('1502232014', '150223', 'Air Liki Baru', 4),
	('1502242001', '150224', 'Sekancing', 4),
	('1502242002', '150224', 'Sekancing Ilir', 4),
	('1502242003', '150224', 'Beringin Sanggul', 4),
	('1502242004', '150224', 'Baru Bukit Punjung', 4),
	('1502242005', '150224', 'Rantau Limau Kapas', 4),
	('1502242006', '150224', 'Baru Sungai Sakai', 4),
	('1503012001', '150301', 'Tambak Ratu', 4),
	('1503012002', '150301', 'Sungaikeradak', 4),
	('1503012003', '150301', 'Muaro Air Dua', 4),
	('1503012004', '150301', 'Simpang Narso', 4),
	('1503012005', '150301', 'Batin Pengambang', 4),
	('1503012006', '150301', 'Batu Empang', 4),
	('1503012007', '150301', 'Rantau Panjang', 4),
	('1503012008', '150301', 'P. Salak Baru', 4),
	('1503012009', '150301', 'Muaro Pemuat', 4),
	('1503012010', '150301', 'Lubuk Bangkar', 4),
	('1503012011', '150301', 'Pekan Gedang', 4),
	('1503012012', '150301', 'Raden Anom', 4),
	('1503012013', '150301', 'Datuk Nan Duo', 4),
	('1503012014', '150301', 'Bukitkalimau Ulu', 4),
	('1503012015', '150301', 'Sungaibemban', 4),
	('1503012016', '150301', 'Muaracuban', 4),
	('1503012017', '150301', 'Sungaibaung', 4),
	('1503012018', '150301', 'Padang Jering', 4),
	('1503012019', '150301', 'Kasiro', 4),
	('1503012020', '150301', 'Kasiro Hilir', 4),
	('1503012021', '150301', 'Bukitberantai', 4),
	('1503012022', '150301', 'Bukit Sulah', 4),
	('1503012023', '150301', 'Paniban Baru', 4),
	('1503022005', '150302', 'Pulaupandan', 4),
	('1503022006', '150302', 'Temenggung', 4),
	('1503022007', '150302', 'Ranggo', 4),
	('1503022008', '150302', 'Panca Karya', 4),
	('1503022009', '150302', 'Lubuk Bedorong', 4),
	('1503022010', '150302', 'Maribung', 4),
	('1503022011', '150302', 'Napal Melintang', 4),
	('1503022012', '150302', 'Berkun', 4),
	('1503022013', '150302', 'Mersip', 4),
	('1503022014', '150302', 'Tanjungraden', 4),
	('1503022016', '150302', 'Moenti', 4),
	('1503022017', '150302', 'Muaramansao', 4),
	('1503022018', '150302', 'Demang', 4),
	('1503022021', '150302', 'Temalang', 4),
	('1503022022', '150302', 'Muara Limun', 4),
	('1503022023', '150302', 'Suka Damai', 4),
	('1503031001', '150303', 'Dusun Sarolangun', 3),
	('1503031015', '150303', 'Sukasari', 3),
	('1503031016', '150303', 'Pasar Sarolangun', 3),
	('1503031019', '150303', 'Sarolangun Kembang', 3),
	('1503031025', '150303', 'Gunungkembang', 3),
	('1503031026', '150303', 'Aur', 3),
	('1503032002', '150303', 'Bernai', 4),
	('